/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import junit.framework.Assert;
import kafka.common.KafkaException;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet;
import kafka.server.OffsetCheckpoint;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"BA\u0006K+:LGoM*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002A1A\u0005\u0002e\tA\u0001^5nKV\t!\u0004\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\t\u0005)Q\u000f^5mg&\u0011q\u0004\b\u0002\t\u001b>\u001c7\u000eV5nK\"1\u0011\u0005\u0001Q\u0001\ni\tQ\u0001^5nK\u0002Bqa\t\u0001C\u0002\u0013\u0005A%A\bnCb\u0014v\u000e\u001c7J]R,'O^1m+\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#aA%oi\"1A\u0006\u0001Q\u0001\n\u0015\n\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\t\u000f9\u0002!\u0019!C\u0001I\u0005YQ.\u0019=M_\u001e\fu-Z't\u0011\u0019\u0001\u0004\u0001)A\u0005K\u0005aQ.\u0019=M_\u001e\fu-Z'tA!9!\u0007\u0001b\u0001\n\u0003\u0019\u0014!\u00037pO\u000e{gNZ5h+\u0005!\u0004C\u0001\f6\u0013\t1$AA\u0005M_\u001e\u001cuN\u001c4jO\"1\u0001\b\u0001Q\u0001\nQ\n!\u0002\\8h\u0007>tg-[4!\u0011\u001dQ\u0004\u00011A\u0005\u0002m\na\u0001\\8h\t&\u0014X#\u0001\u001f\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015AA5p\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\t\u0019KG.\u001a\u0005\b\u000b\u0002\u0001\r\u0011\"\u0001G\u0003)awn\u001a#je~#S-\u001d\u000b\u0003\u000f*\u0003\"A\n%\n\u0005%;#\u0001B+oSRDqa\u0013#\u0002\u0002\u0003\u0007A(A\u0002yIEBa!\u0014\u0001!B\u0013a\u0014a\u00027pO\u0012K'\u000f\t\u0005\b\u001f\u0002\u0001\r\u0011\"\u0001Q\u0003)awnZ'b]\u0006<WM]\u000b\u0002#B\u0011aCU\u0005\u0003'\n\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0011\u001d)\u0006\u00011A\u0005\u0002Y\u000ba\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002H/\"91\nVA\u0001\u0002\u0004\t\u0006BB-\u0001A\u0003&\u0011+A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001X\u0001\u0005]\u0006lW-F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001\u0007)\u0001\u0003mC:<\u0017B\u00012`\u0005\u0019\u0019FO]5oO\"1A\r\u0001Q\u0001\nu\u000bQA\\1nK\u0002BqA\u001a\u0001C\u0002\u0013\u0005q-A\rwKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006dW#\u00015\u0011\u0005\u0019J\u0017B\u00016(\u0005\u0011auN\\4\t\r1\u0004\u0001\u0015!\u0003i\u0003i1XM]=MCJ<W\rT8h\r2,8\u000f[%oi\u0016\u0014h/\u00197!\u0011\u001dq\u0007A1A\u0005\u0002=\fQb\u00197fC:,'oQ8oM&<W#\u00019\u0011\u0005Y\t\u0018B\u0001:\u0003\u00055\u0019E.Z1oKJ\u001cuN\u001c4jO\"1A\u000f\u0001Q\u0001\nA\fab\u00197fC:,'oQ8oM&<\u0007\u0005C\u0003w\u0001\u0011\u0005s/A\u0003tKR,\u0006\u000fF\u0001H\u0011\u0015I\b\u0001\"\u0011x\u0003!!X-\u0019:E_^t\u0007\"B>\u0001\t\u00039\u0018!\u0004;fgR\u001c%/Z1uK2{w\r\u000b\u0002{{B\u0019a0!\u0001\u000e\u0003}T!a\u0003\b\n\u0007\u0005\rqP\u0001\u0003UKN$\bBBA\u0004\u0001\u0011\u0005q/A\u000buKN$x)\u001a;O_:,\u00050[:uK:$Hj\\4)\u0007\u0005\u0015Q\u0010\u0003\u0004\u0002\u000e\u0001!\ta^\u0001\u001bi\u0016\u001cHo\u00117fC:,\b/\u0012=qSJ,GmU3h[\u0016tGo\u001d\u0015\u0004\u0003\u0017i\bBBA\n\u0001\u0011\u0005q/A\u0011uKN$8\t\\3b]V\u00048+Z4nK:$8\u000fV8NC&tG/Y5o'&TX\rK\u0002\u0002\u0012uDa!!\u0007\u0001\t\u00039\u0018A\u0005;fgR$\u0016.\\3CCN,GM\u00127vg\"D3!a\u0006~\u0011\u0019\ty\u0002\u0001C\u0001o\u0006IB/Z:u\u0019\u0016\f7\u000f\u001e'pC\u0012,G-Q:tS\u001etW.\u001a8uQ\r\ti\" \u0005\u0007\u0003K\u0001A\u0011A<\u0002GQ,7\u000f\u001e+x_2{w-T1oC\u001e,'o]+tS:<7+Y7f\t&\u0014h)Y5mg\"\u001a\u00111E?\t\r\u0005-\u0002\u0001\"\u0001x\u0003q!Xm\u001d;DQ\u0016\u001c7\u000e]8j]R\u0014VmY8wKJL\bk\\5oiND3!!\u000b~\u0011\u0019\t\t\u0004\u0001C\u0001o\u0006iC/Z:u%\u0016\u001cwN^3ss\u0012K'/Z2u_JLX*\u00199qS:<w+\u001b;i)J\f\u0017\u000e\\5oONc\u0017m\u001d5)\u0007\u0005=R\u0010\u0003\u0004\u00028\u0001!\ta^\u00012i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\bNU3mCRLg/\u001a#je\u0016\u001cGo\u001c:zQ\r\t)$ \u0005\b\u0003{\u0001A\u0011BA \u0003a1XM]5gs\u000eCWmY6q_&tGOU3d_Z,'/\u001f\u000b\u0006\u000f\u0006\u0005\u0013\u0011\u000e\u0005\t\u0003\u0007\nY\u00041\u0001\u0002F\u0005\u0011Bo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8t!\u0019\t9%a\u0016\u0002^9!\u0011\u0011JA*\u001d\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(\r\u00051AH]8pizJ\u0011\u0001K\u0005\u0004\u0003+:\u0013a\u00029bG.\fw-Z\u0005\u0005\u00033\nYFA\u0002TKFT1!!\u0016(!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2\t\u000511m\\7n_:LA!a\u001a\u0002b\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\r=\u000bY\u00041\u0001R\u0001")
public class LogManagerTest
extends JUnit3Suite {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;
    private final CleanerConfig cleanerConfig;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    public CleanerConfig cleanerConfig() {
        return this.cleanerConfig;
    }

    public void setUp() {
        super.setUp();
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(new LogManager((File[])((Object[])new File[]{this.logDir()}), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), this.logConfig(), this.cleanerConfig(), 1000L, 100000L, 1000L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        this.logManager().startup();
        this.logDir_$eq(this.logManager().logDirs()[0]);
    }

    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils$.MODULE$.rm(this.logDir());
        Predef$.MODULE$.refArrayOps((Object[])this.logManager().logDirs()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils$.MODULE$.rm(x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        super.tearDown();
    }

    @Test
    public void testCreateLog() {
        Log log = this.logManager().createLog(new TopicAndPartition(this.name(), 0), this.logConfig());
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
    }

    @Test
    public void testGetNonExistentLog() {
        Option log = this.logManager().getLog(new TopicAndPartition(this.name(), 0));
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        Log log = this.logManager().createLog(new TopicAndPartition(this.name(), 0), this.logConfig());
        LongRef offset = new LongRef(0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final LongRef offset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                Log.LogAppendInfo info = this.log$1.append(set, this.log$1.append$default$2());
                this.offset$1.elem = info.lastOffset();
            }
            {
                this.log$1 = log$1;
                this.offset$1 = offset$1;
            }
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$2) {
                return x$2.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (int)1, (int)log.numberOfSegments());
        this.time().sleep(log.config().fileDeleteDelayMs() + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (int)(log.numberOfSegments() * 2), (int)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (int)0, (int)log.read(offset.elem + 1L, 1024, log.read$default$3()).sizeInBytes());
        try {
            log.read(0L, 1024, log.read$default$3());
            throw this.fail("Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
            return;
        }
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()).sizeInBytes();
        this.logManager().shutdown();
        int x$28 = 10 * (setSize - 1);
        long x$29 = 50L * (long)setSize + 10L;
        long x$30 = this.logConfig().copy$default$2();
        long x$31 = this.logConfig().copy$default$3();
        long x$32 = this.logConfig().copy$default$4();
        long x$33 = this.logConfig().copy$default$6();
        int x$34 = this.logConfig().copy$default$7();
        int x$35 = this.logConfig().copy$default$8();
        int x$36 = this.logConfig().copy$default$9();
        long x$37 = this.logConfig().copy$default$10();
        long x$38 = this.logConfig().copy$default$11();
        double x$39 = this.logConfig().copy$default$12();
        boolean x$40 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$28, x$30, x$31, x$32, x$29, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
        this.logManager_$eq(new LogManager((File[])((Object[])new File[]{this.logDir()}), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), config, this.cleanerConfig(), 1000L, 100000L, 1000L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        this.logManager().startup();
        Log log = this.logManager().createLog(new TopicAndPartition(this.name(), 0), config);
        LongRef offset = new LongRef(0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final LongRef offset$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                Log.LogAppendInfo info = this.log$2.append(set, this.log$2.append$default$2());
                this.offset$2.elem = info.firstOffset();
            }
            {
                this.log$2 = log$2;
                this.offset$2 = offset$2;
            }
        });
        Assert.assertEquals((String)"Check we have the expected number of segments.", (int)(numMessages * setSize / config.segmentSize()), (int)log.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (int)6, (int)log.numberOfSegments());
        this.time().sleep(log.config().fileDeleteDelayMs() + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (int)(log.numberOfSegments() * 2), (int)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (int)0, (int)log.read(offset.elem + 1L, 1024, log.read$default$3()).sizeInBytes());
        try {
            log.read(0L, 1024, log.read$default$3());
            throw this.fail("Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
            return;
        }
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        long x$41 = 1000L;
        int x$42 = this.logConfig().copy$default$1();
        long x$43 = this.logConfig().copy$default$2();
        long x$44 = this.logConfig().copy$default$3();
        long x$45 = this.logConfig().copy$default$5();
        long x$46 = this.logConfig().copy$default$6();
        int x$47 = this.logConfig().copy$default$7();
        int x$48 = this.logConfig().copy$default$8();
        int x$49 = this.logConfig().copy$default$9();
        long x$50 = this.logConfig().copy$default$10();
        long x$51 = this.logConfig().copy$default$11();
        double x$52 = this.logConfig().copy$default$12();
        boolean x$53 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$42, x$43, x$44, x$41, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53);
        this.logManager_$eq(new LogManager((File[])((Object[])new File[]{this.logDir()}), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), config, this.cleanerConfig(), 1000L, 10000L, 1000L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        this.logManager().startup();
        Log log = this.logManager().createLog(new TopicAndPartition(this.name(), 0), config);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$3;

            public final Log.LogAppendInfo apply(int i) {
                ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                return this.log$3.append(set, this.log$3.append$default$2());
            }
            {
                this.log$3 = log$3;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered triggered", (lastFlush != log.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        File[] dirs = (File[])((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()});
        this.logManager().shutdown();
        this.logManager_$eq(new LogManager(dirs, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), this.logConfig(), this.cleanerConfig(), 1000L, 10000L, 1000L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                this.$outer.logManager().createLog(new TopicAndPartition("test", partition), this.$outer.logConfig());
                Assert.assertEquals((String)"We should have created the right number of logs", (int)(partition + 1), (int)this.$outer.logManager().allLogs().size());
                Iterable counts = (Iterable)this.$outer.logManager().allLogs().groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Log x$3) {
                        return x$3.dir().getParent();
                    }
                }).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Iterable<Log> x$4) {
                        return x$4.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            new LogManager((File[])((Object[])new File[]{this.logDir()}), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), this.logConfig(), this.cleanerConfig(), 1000L, 10000L, 1000L, (Scheduler)this.time().scheduler(), (Time)this.time());
            throw this.fail("Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicAndPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test-a", 1), new TopicAndPartition("test-b", 1)}))), this.logManager());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(new LogManager((File[])((Object[])new File[]{new File(new StringBuilder().append((Object)this.logDir().getAbsolutePath()).append((Object)File.separator).toString())}), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), this.logConfig(), this.cleanerConfig(), 1000L, 100000L, 1000L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicAndPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test-a", 1)}))), this.logManager());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logDir_$eq(new File(new StringBuilder().append((Object)"data").append((Object)File.separator).append((Object)this.logDir().getName()).toString()));
        this.logDir().mkdirs();
        this.logDir().deleteOnExit();
        this.logManager_$eq(new LogManager((File[])((Object[])new File[]{this.logDir()}), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), this.logConfig(), this.cleanerConfig(), 1000L, 100000L, 1000L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicAndPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test-a", 1)}))), this.logManager());
    }

    private void verifyCheckpointRecovery(Seq<TopicAndPartition> topicAndPartitions, LogManager logManager) {
        Seq logs = (Seq)topicAndPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final Log apply(TopicAndPartition x$5) {
                return this.$outer.logManager().createLog(x$5, this.$outer.logConfig());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Log log) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final Log log$4;

                    public final Log.LogAppendInfo apply(int i) {
                        return this.log$4.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), this.log$4.append$default$2());
                    }
                    {
                        this.log$4 = log$4;
                    }
                });
                log.flush();
            }
        });
        logManager.checkpointRecoveryPointOffsets();
        Map checkpoints = new OffsetCheckpoint(new File(this.logDir(), logManager.RecoveryPointCheckpointFile())).read();
        ((IterableLike)topicAndPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$1;

            public final void apply(Tuple2<TopicAndPartition, Log> x0$1) {
                Tuple2<TopicAndPartition, Log> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Log log = (Log)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$1 = checkpoints$1;
            }
        });
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 36000000;
        int x$6 = 1024;
        int x$7 = 4096;
        long x$8 = this.maxLogAgeMs();
        long x$9 = LogConfig$.MODULE$.apply$default$2();
        long x$10 = LogConfig$.MODULE$.apply$default$3();
        long x$11 = LogConfig$.MODULE$.apply$default$4();
        long x$12 = LogConfig$.MODULE$.apply$default$5();
        int x$13 = LogConfig$.MODULE$.apply$default$7();
        int x$14 = LogConfig$.MODULE$.apply$default$9();
        long x$15 = LogConfig$.MODULE$.apply$default$10();
        long x$16 = LogConfig$.MODULE$.apply$default$11();
        double x$17 = LogConfig$.MODULE$.apply$default$12();
        boolean x$18 = LogConfig$.MODULE$.apply$default$13();
        this.logConfig = new LogConfig(x$6, x$9, x$10, x$11, x$12, x$8, x$13, x$7, x$14, x$15, x$16, x$17, x$18);
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
        boolean x$19 = false;
        int x$20 = CleanerConfig$.MODULE$.apply$default$1();
        long x$21 = CleanerConfig$.MODULE$.apply$default$2();
        double x$22 = CleanerConfig$.MODULE$.apply$default$3();
        int x$23 = CleanerConfig$.MODULE$.apply$default$4();
        int x$24 = CleanerConfig$.MODULE$.apply$default$5();
        double x$25 = CleanerConfig$.MODULE$.apply$default$6();
        long x$26 = CleanerConfig$.MODULE$.apply$default$7();
        String x$27 = CleanerConfig$.MODULE$.apply$default$9();
        this.cleanerConfig = new CleanerConfig(x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$19, x$27);
    }
}

