/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import kafka.common.MessageSizeTooLargeException;
import kafka.common.OffsetOutOfRangeException;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.NoCompressionCodec$;
import kafka.server.KafkaConfig;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001\u001d\u0011q\u0001T8h)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011A\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tQA[;oSRT!!\u0006\f\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\f\u0002\u0007=\u0014x-\u0003\u0002\u001a%\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0001\u0004%\t!I\u0001\u0007Y><G)\u001b:\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0007\u0002\u0005%|\u0017BA\u0014%\u0005\u00111\u0015\u000e\\3\t\u000f%\u0002\u0001\u0019!C\u0001U\u0005QAn\\4ESJ|F%Z9\u0015\u0005-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#\u0001B+oSRDqA\r\u0015\u0002\u0002\u0003\u0007!%A\u0002yIEBa\u0001\u000e\u0001!B\u0013\u0011\u0013a\u00027pO\u0012K'\u000f\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003\u0011!\u0018.\\3\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005uR$\u0001C'pG.$\u0016.\\3\t\r}\u0002\u0001\u0015!\u00039\u0003\u0015!\u0018.\\3!\u0011\u001d\t\u0005\u00011A\u0005\u0002\t\u000baaY8oM&<W#A\"\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019#\u0011AB:feZ,'/\u0003\u0002I\u000b\nY1*\u00194lC\u000e{gNZ5h\u0011\u001dQ\u0005\u00011A\u0005\u0002-\u000b!bY8oM&<w\fJ3r)\tYC\nC\u00043\u0013\u0006\u0005\t\u0019A\"\t\r9\u0003\u0001\u0015)\u0003D\u0003\u001d\u0019wN\u001c4jO\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011+A\u0005m_\u001e\u001cuN\u001c4jOV\t!\u000b\u0005\u0002\u001f'&\u0011AK\u0001\u0002\n\u0019><7i\u001c8gS\u001eDaA\u0016\u0001!\u0002\u0013\u0011\u0016A\u00037pO\u000e{gNZ5hA!)\u0001\f\u0001C\u00013\u0006)1/\u001a;VaR\t1\u0006\u000b\u0002X7B\u0011ALX\u0007\u0002;*\u00111CF\u0005\u0003?v\u0013aAQ3g_J,\u0007\"B1\u0001\t\u0003I\u0016\u0001\u0003;fCJ$un\u001e8)\u0005\u0001\u001c\u0007C\u0001/e\u0013\t)WLA\u0003BMR,'\u000fC\u0003h\u0001\u0011\u0005\u0001.A\bde\u0016\fG/Z#naRLHj\\4t)\rY\u0013n\u001b\u0005\u0006U\u001a\u0004\rAI\u0001\u0004I&\u0014\b\"\u00027g\u0001\u0004i\u0017aB8gMN,Go\u001d\t\u0004Y9\u0004\u0018BA8.\u0005)a$/\u001a9fCR,GM\u0010\t\u0003YEL!A]\u0017\u0003\u0007%sG\u000fC\u0003u\u0001\u0011\u0005\u0011,\u0001\u000buKN$H+[7f\u0005\u0006\u001cX\r\u001a'pOJ{G\u000e\u001c\u0015\u0003gZ\u0004\"\u0001X<\n\u0005al&\u0001\u0002+fgRDQA\u001f\u0001\u0005\u0002e\u000bA\u0003^3tiNK'0\u001a\"bg\u0016$Gj\\4S_2d\u0007FA=w\u0011\u0015i\b\u0001\"\u0001Z\u0003A!Xm\u001d;M_\u0006$W)\u001c9us2{w\r\u000b\u0002}m\"1\u0011\u0011\u0001\u0001\u0005\u0002e\u000ba\u0005^3ti\u0006\u0003\b/\u001a8e\u0003:$'+Z1e/&$\bnU3rk\u0016tG/[1m\u001f\u001a47/\u001a;tQ\tyh\u000f\u0003\u0004\u0002\b\u0001!\t!W\u0001*i\u0016\u001cH/\u00119qK:$\u0017I\u001c3SK\u0006$w+\u001b;i\u001d>t7+Z9vK:$\u0018.\u00197PM\u001a\u001cX\r^:)\u0007\u0005\u0015a\u000f\u0003\u0004\u0002\u000e\u0001!\t!W\u0001\u0011i\u0016\u001cHOU3bI\u0006#Hj\\4HCBD3!a\u0003w\u0011\u0019\t\u0019\u0002\u0001C\u00013\u0006\u0011B/Z:u%\u0016\fGmT;u\u001f\u001a\u0014\u0016M\\4fQ\r\t\tB\u001e\u0005\u0007\u00033\u0001A\u0011A-\u0002\u0019Q,7\u000f\u001e'pOJ{G\u000e\\:)\u0007\u0005]a\u000f\u0003\u0004\u0002 \u0001!\t!W\u0001\u0017i\u0016\u001cHoQ8naJ,7o]3e\u001b\u0016\u001c8/Y4fg\"\u001a\u0011Q\u0004<\t\r\u0005\u0015\u0002\u0001\"\u0001Z\u0003M\"Xm\u001d;UQ\u0006$x)\u0019:cC\u001e,7i\u001c7mK\u000e$\u0018N\\4TK\u001elWM\u001c;t\t>,7O\u001c;DQ\u0006tw-Z(gMN,G\u000fK\u0002\u0002$YDa!a\u000b\u0001\t\u0003I\u0016\u0001\u0006;fgRlUm]:bO\u0016\u001c\u0016N_3DQ\u0016\u001c7\u000eK\u0002\u0002*YDa!!\r\u0001\t\u0003I\u0016A\b;fgRdun\u001a*fG>4XM]:U_\u000e{'O]3di>3gm]3uQ\r\tyC\u001e\u0005\u0007\u0003o\u0001A\u0011A-\u0002!Q,7\u000f^%oI\u0016D(+\u001a2vS2$\u0007fAA\u001bm\"1\u0011Q\b\u0001\u0005\u0002e\u000ba\u0002^3tiR\u0013XO\\2bi\u0016$v\u000eK\u0002\u0002<YDa!a\u0011\u0001\t\u0003I\u0016!\b;fgRLe\u000eZ3y%\u0016\u001c\u0018N_5oO\u0006#HK];oG\u0006$\u0018n\u001c8)\u0007\u0005\u0005c\u000f\u0003\u0004\u0002J\u0001!\t!W\u0001!i\u0016\u001cHOQ8hkNLe\u000eZ3y'\u0016<W.\u001a8ug\u0006\u0013XMU3n_Z,G\rK\u0002\u0002HYDa!a\u0014\u0001\t\u0003I\u0016A\u0006;fgR\u0014Vm\u001c9f]RCWM\u001c+sk:\u001c\u0017\r^3)\u0007\u00055c\u000f\u0003\u0004\u0002V\u0001!\t!W\u0001\u0010i\u0016\u001cH/Q:z]\u000e$U\r\\3uK\"\u001a\u00111\u000b<\t\r\u0005m\u0003\u0001\"\u0001Z\u0003q!Xm\u001d;Pa\u0016tG)\u001a7fi\u0016\u001cxJY:pY\u0016$XMR5mKND3!!\u0017w\u0011\u0019\t\t\u0007\u0001C\u00013\u0006\u0001C/Z:u\u0003B\u0004XM\u001c3NKN\u001c\u0018mZ3XSRDg*\u001e7m!\u0006LHn\\1eQ\r\tyF\u001e\u0005\u0007\u0003O\u0002A\u0011A-\u0002\u001dQ,7\u000f^\"peJ,\b\u000f\u001e'pO\"\u001a\u0011Q\r<\t\r\u00055\u0004\u0001\"\u0001Z\u0003U!Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\u001c$jY\u0016D3!a\u001bw\u0001")
public class LogTest
implements JUnitSuite {
    private File logDir;
    private final MockTime time;
    private KafkaConfig config;
    private final LogConfig logConfig;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, -1);
        this.config_$eq(new KafkaConfig(props));
    }

    @After
    public void tearDown() {
        Utils$.MODULE$.rm(this.logDir());
    }

    public void createEmptyLogs(File dir, Seq<Object> offsets) {
        offsets.foreach((Function1)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final boolean apply(int offset) {
                return this.apply$mcZI$sp(offset);
            }

            public boolean apply$mcZI$sp(int offset) {
                Log$.MODULE$.logFilename(this.dir$1, (long)offset).createNewFile();
                return Log$.MODULE$.indexFilename(this.dir$1, (long)offset).createNewFile();
            }
            {
                this.dir$1 = dir$1;
            }
        });
    }

    @Test
    public void testTimeBasedLogRoll() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        long x$19 = 3600L;
        int x$20 = this.logConfig().copy$default$1();
        long x$21 = this.logConfig().copy$default$3();
        long x$22 = this.logConfig().copy$default$4();
        long x$23 = this.logConfig().copy$default$5();
        long x$24 = this.logConfig().copy$default$6();
        int x$25 = this.logConfig().copy$default$7();
        int x$26 = this.logConfig().copy$default$8();
        int x$27 = this.logConfig().copy$default$9();
        long x$28 = this.logConfig().copy$default$10();
        long x$29 = this.logConfig().copy$default$11();
        double x$30 = this.logConfig().copy$default$12();
        boolean x$31 = this.logConfig().copy$default$13();
        Log log = new Log(this.logDir(), this.logConfig().copy(x$20, x$19, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Log begins with a single empty segment.", (int)1, (int)log.numberOfSegments());
        this.time().sleep(log.config().segmentMs() + 1L);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log doesn't roll if doing so creates an empty segment.", (int)1, (int)log.numberOfSegments());
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log rolls on this append since time has expired.", (int)2, (int)log.numberOfSegments());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ByteBufferMessageSet set$1;
            private final Log log$1;

            public final void apply(int numSegments) {
                this.apply$mcVI$sp(numSegments);
            }

            public void apply$mcVI$sp(int numSegments) {
                this.$outer.time().sleep(this.log$1.config().segmentMs() + 1L);
                this.log$1.append(this.set$1, this.log$1.append$default$2());
                Assert.assertEquals((String)"Changing time beyond rollMs and appending should create a new segment.", (int)numSegments, (int)this.log$1.numberOfSegments());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.set$1 = set$1;
                this.log$1 = log$1;
            }
        });
        int numSegments = log.numberOfSegments();
        this.time().sleep(log.config().segmentMs() + 1L);
        log.append(new ByteBufferMessageSet((Seq)Nil$.MODULE$), log.append$default$2());
        Assert.assertEquals((String)"Appending an empty message set should not roll log even if succient time has passed.", (int)numSegments, (int)log.numberOfSegments());
    }

    @Test
    public void testSizeBasedLogRoll() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * (setSize - 1);
        Log log = new Log(this.logDir(), this.logConfig().copy(segmentSize, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg + 1).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$2;
            private final Log log$2;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$2.append(this.set$2, this.log$2.append$default$2());
            }
            {
                this.set$2 = set$2;
                this.log$2 = log$2;
            }
        });
        Assert.assertEquals((String)"There should be exactly 2 segments.", (int)2, (int)log.numberOfSegments());
    }

    @Test
    public void testLoadEmptyLog() {
        this.createEmptyLogs(this.logDir(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        Log log = new Log(this.logDir(), this.logConfig(), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
    }

    @Test
    public void testAppendAndReadWithSequentialOffsets() {
        Log log = new Log(this.logDir(), this.logConfig().copy(71, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Message[] messages2 = (Message[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).by(2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Message.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message[] messages$1;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$3.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$1[i]})), this.log$3.append$default$2());
            }
            {
                this.log$3 = log$3;
                this.messages$1 = messages$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach$mVc$sp((Function1)new Serializable(this, log, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message[] messages$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MessageAndOffset read = (MessageAndOffset)this.log$3.read((long)i, 100, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1)))).head();
                Assert.assertEquals((String)"Offset read should match order appended.", (long)i, (long)read.offset());
                Assert.assertEquals((String)"Message should match appended.", (Object)this.messages$1[i], (Object)read.message());
            }
            {
                this.log$3 = log$3;
                this.messages$1 = messages$1;
            }
        });
        Assert.assertEquals((String)"Reading beyond the last message returns nothing.", (int)0, (int)log.read((long)messages2.length, 100, (Option)None$.MODULE$).size());
    }

    @Test
    public void testAppendAndReadWithNonSequentialOffsets() {
        Log log = new Log(this.logDir(), this.logConfig().copy(71, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int[] messageIds = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 200).by(7), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        Message[] messages2 = (Message[])Predef$.MODULE$.intArrayOps(messageIds).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Message.class)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final int[] messageIds$1;
            private final Message[] messages$2;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$4.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new AtomicLong(this.messageIds$1[i]), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$2[i]})), false);
            }
            {
                this.log$4 = log$4;
                this.messageIds$1 = messageIds$1;
                this.messages$2 = messages$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(messageIds).max((Ordering)Ordering.Int$.MODULE$))).foreach$mVc$sp((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final int[] messageIds$1;
            private final Message[] messages$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int idx = Predef$.MODULE$.intArrayOps(this.messageIds$1).indexWhere((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final boolean apply(int x$1) {
                        return this.apply$mcZI$sp(x$1);
                    }

                    public boolean apply$mcZI$sp(int x$1) {
                        return x$1 >= this.i$1;
                    }
                    {
                        this.i$1 = i$1;
                    }
                });
                MessageAndOffset read = (MessageAndOffset)this.log$4.read((long)i, 100, (Option)None$.MODULE$).head();
                Assert.assertEquals((String)"Offset read should match message id.", (long)this.messageIds$1[idx], (long)read.offset());
                Assert.assertEquals((String)"Message should match appended.", (Object)this.messages$2[idx], (Object)read.message());
            }
            {
                this.log$4 = log$4;
                this.messageIds$1 = messageIds$1;
                this.messages$2 = messages$2;
            }
        });
    }

    @Test
    public void testReadAtLogGap() {
        Log log = new Log(this.logDir(), this.logConfig().copy(300, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        while (log.numberOfSegments() == 1) {
            log.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("42".getBytes())})), log.append$default$2());
        }
        ((LogSegment)log.logSegments().head()).truncateTo(1L);
        Assert.assertEquals((String)"A read should now return the last message in the log", (long)(log.logEndOffset() - 1L), (long)((MessageAndOffset)log.read(1L, 200, (Option)None$.MODULE$).head()).offset());
    }

    @Test
    public void testReadOutOfRange() {
        this.createEmptyLogs(this.logDir(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{1024}));
        Log log = new Log(this.logDir(), this.logConfig().copy(1024, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Reading just beyond end of log should produce 0 byte read.", (int)0, (int)log.read(1024L, 1000, log.read$default$3()).sizeInBytes());
        try {
            log.read(0L, 1024, log.read$default$3());
            throw this.fail("Expected exception on invalid read.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            try {
                log.read(1025L, 1000, log.read$default$3());
                throw this.fail("Expected exception on invalid read.");
            }
            catch (OffsetOutOfRangeException offsetOutOfRangeException2) {
                return;
            }
        }
    }

    @Test
    public void testLogRolls() {
        Log log = new Log(this.logDir(), this.logConfig().copy(100, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int numMessages = 100;
        IndexedSeq messageSets = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ByteBufferMessageSet apply(int i) {
                return TestUtils$.MODULE$.singleMessageSet(((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        messageSets.foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$5;

            public final Log.LogAppendInfo apply(ByteBufferMessageSet x$2) {
                return this.log$5.append(x$2, this.log$5.append$default$2());
            }
            {
                this.log$5 = log$5;
            }
        });
        log.flush();
        LongRef offset = new LongRef(0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log, messageSets, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$5;
            private final IndexedSeq messageSets$1;
            private final LongRef offset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MessageSet messages2 = this.log$5.read(this.offset$1.elem, 0x100000, this.log$5.read$default$3());
                Assert.assertEquals((String)"Offsets not equal", (long)this.offset$1.elem, (long)((MessageAndOffset)messages2.head()).offset());
                Assert.assertEquals((String)new StringBuilder().append((Object)"Messages not equal at offset ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1.elem)).toString(), (Object)((MessageAndOffset)((IterableLike)this.messageSets$1.apply(i)).head()).message(), (Object)((MessageAndOffset)messages2.head()).message());
                this.offset$1.elem = ((MessageAndOffset)messages2.head()).offset() + 1L;
            }
            {
                this.log$5 = log$5;
                this.messageSets$1 = messageSets$1;
                this.offset$1 = offset$1;
            }
        });
        MessageSet lastRead = log.read((long)numMessages, 0x100000, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(numMessages + 1))));
        Assert.assertEquals((String)"Should be no more messages", (int)0, (int)lastRead.size());
        TestUtils$.MODULE$.retry(1000L, (Function0<BoxedUnit>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertTrue((String)"Log role should have forced flush", (this.log$5.recoveryPoint() >= this.log$5.activeSegment().baseOffset() ? 1 : 0) != 0);
            }
            {
                this.log$5 = log$5;
            }
        });
    }

    @Test
    public void testCompressedMessages() {
        Log log = new Log(this.logDir(), this.logConfig().copy(10, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())})), log.append$default$2());
        log.append(new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("alpha".getBytes()), new Message("beta".getBytes())})), log.append$default$2());
        Assert.assertEquals((String)"Read at offset 0 should produce 0", (long)0L, (long)((MessageAndOffset)this.read$1(0, log).head()).offset());
        Assert.assertEquals((String)"Read at offset 1 should produce 0", (long)0L, (long)((MessageAndOffset)this.read$1(1, log).head()).offset());
        Assert.assertEquals((String)"Read at offset 2 should produce 2", (long)2L, (long)((MessageAndOffset)this.read$1(2, log).head()).offset());
        Assert.assertEquals((String)"Read at offset 3 should produce 2", (long)2L, (long)((MessageAndOffset)this.read$1(3, log).head()).offset());
    }

    @Test
    public void testThatGarbageCollectingSegmentsDoesntChangeOffset() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 25})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;

            public final void apply(int messagesToAppend) {
                this.apply$mcVI$sp(messagesToAppend);
            }

            public void apply$mcVI$sp(int messagesToAppend) {
                this.$outer.logDir().mkdirs();
                Log log = new Log(this.$outer.logDir(), this.$outer.logConfig().copy(100, this.$outer.logConfig().copy$default$2(), this.$outer.logConfig().copy$default$3(), this.$outer.logConfig().copy$default$4(), this.$outer.logConfig().copy$default$5(), this.$outer.logConfig().copy$default$6(), this.$outer.logConfig().copy$default$7(), this.$outer.logConfig().copy$default$8(), this.$outer.logConfig().copy$default$9(), this.$outer.logConfig().copy$default$10(), this.$outer.logConfig().copy$default$11(), this.$outer.logConfig().copy$default$12(), this.$outer.logConfig().copy$default$13()), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesToAppend).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final Log log$7;

                    public final Log.LogAppendInfo apply(int i) {
                        return this.log$7.append(TestUtils$.MODULE$.singleMessageSet(((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), this.log$7.append$default$2());
                    }
                    {
                        this.log$7 = log$7;
                    }
                });
                long currOffset = log.logEndOffset();
                Assert.assertEquals((long)currOffset, (long)messagesToAppend);
                log.deleteOldSegments((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogSegment x$3) {
                        return true;
                    }
                });
                Assert.assertEquals((String)"Deleting segments shouldn't have changed the logEndOffset", (long)currOffset, (long)log.logEndOffset());
                Assert.assertEquals((String)"We should still have one segment left", (int)1, (int)log.numberOfSegments());
                Assert.assertEquals((String)"Further collection shouldn't delete anything", (int)0, (int)log.deleteOldSegments((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogSegment x$4) {
                        return true;
                    }
                }));
                Assert.assertEquals((String)"Still no change in the logEndOffset", (long)currOffset, (long)log.logEndOffset());
                Assert.assertEquals((String)"Should still be able to append and should get the logEndOffset assigned to the new append", (long)currOffset, (long)log.append(TestUtils$.MODULE$.singleMessageSet("hello".toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2()).firstOffset());
                log.delete();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testMessageSizeCheck() {
        int maxMessageSize;
        ByteBufferMessageSet first = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("You".getBytes()), new Message("bethe".getBytes())}));
        ByteBufferMessageSet second = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("change".getBytes())}));
        int x$32 = maxMessageSize = second.sizeInBytes() - 1;
        int x$33 = this.logConfig().copy$default$1();
        long x$34 = this.logConfig().copy$default$2();
        long x$35 = this.logConfig().copy$default$3();
        long x$36 = this.logConfig().copy$default$4();
        long x$37 = this.logConfig().copy$default$5();
        long x$38 = this.logConfig().copy$default$6();
        int x$39 = this.logConfig().copy$default$8();
        int x$40 = this.logConfig().copy$default$9();
        long x$41 = this.logConfig().copy$default$10();
        long x$42 = this.logConfig().copy$default$11();
        double x$43 = this.logConfig().copy$default$12();
        boolean x$44 = this.logConfig().copy$default$13();
        Log log = new Log(this.logDir(), this.logConfig().copy(x$33, x$34, x$35, x$36, x$37, x$38, x$32, x$39, x$40, x$41, x$42, x$43, x$44), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(first, log.append$default$2());
        try {
            log.append(second, log.append$default$2());
            throw this.fail("Second message set should throw MessageSizeTooLargeException.");
        }
        catch (MessageSizeTooLargeException messageSizeTooLargeException) {
            return;
        }
    }

    @Test
    public void testLogRecoversToCorrectOffset() {
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        int x$45 = segmentSize;
        int x$46 = indexInterval;
        int x$47 = 4096;
        long x$48 = this.logConfig().copy$default$2();
        long x$49 = this.logConfig().copy$default$3();
        long x$50 = this.logConfig().copy$default$4();
        long x$51 = this.logConfig().copy$default$5();
        long x$52 = this.logConfig().copy$default$6();
        int x$53 = this.logConfig().copy$default$7();
        long x$54 = this.logConfig().copy$default$10();
        long x$55 = this.logConfig().copy$default$11();
        double x$56 = this.logConfig().copy$default$12();
        boolean x$57 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$45, x$48, x$49, x$50, x$51, x$52, x$53, x$47, x$46, x$54, x$55, x$56, x$57);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, messageSize, log){
            public static final long serialVersionUID = 0L;
            private final int messageSize$1;
            private final ObjectRef log$8;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$1 = (Log)this.log$8.elem;
                ByteBufferMessageSet x$58 = TestUtils$.MODULE$.singleMessageSet(TestUtils$.MODULE$.randomBytes(this.messageSize$1), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                boolean x$59 = qual$1.append$default$2();
                return qual$1.append(x$58, x$59);
            }
            {
                this.messageSize$1 = messageSize$1;
                this.log$8 = log$8;
            }
        });
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        long lastIndexOffset = ((Log)log.elem).activeSegment().index().lastOffset();
        int numIndexEntries = ((Log)log.elem).activeSegment().index().entries();
        long lastOffset = ((Log)log.elem).logEndOffset();
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, lastOffset, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened w/o recovery")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        Assert.assertEquals((String)"Should have same last index offset as before.", (long)lastIndexOffset, (long)((Log)log.elem).activeSegment().index().lastOffset());
        Assert.assertEquals((String)"Should have same number of index entries as before.", (int)numIndexEntries, (int)((Log)log.elem).activeSegment().index().entries());
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened with recovery")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        Assert.assertEquals((String)"Should have same last index offset as before.", (long)lastIndexOffset, (long)((Log)log.elem).activeSegment().index().lastOffset());
        Assert.assertEquals((String)"Should have same number of index entries as before.", (int)numIndexEntries, (int)((Log)log.elem).activeSegment().index().entries());
        ((Log)log.elem).close();
    }

    @Test
    public void testIndexRebuild() {
        int numMessages = 200;
        int x$60 = 200;
        int x$61 = 1;
        long x$62 = this.logConfig().copy$default$2();
        long x$63 = this.logConfig().copy$default$3();
        long x$64 = this.logConfig().copy$default$4();
        long x$65 = this.logConfig().copy$default$5();
        long x$66 = this.logConfig().copy$default$6();
        int x$67 = this.logConfig().copy$default$7();
        int x$68 = this.logConfig().copy$default$8();
        long x$69 = this.logConfig().copy$default$10();
        long x$70 = this.logConfig().copy$default$11();
        double x$71 = this.logConfig().copy$default$12();
        boolean x$72 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$60, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$61, x$69, x$70, x$71, x$72);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final ObjectRef log$9;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$2 = (Log)this.log$9.elem;
                ByteBufferMessageSet x$73 = TestUtils$.MODULE$.singleMessageSet(TestUtils$.MODULE$.randomBytes(10), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                boolean x$74 = qual$2.append$default$2();
                return qual$2.append(x$73, x$74);
            }
            {
                this.log$9 = log$9;
            }
        });
        Iterable indexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$5) {
                return x$5.index().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ((Log)log.elem).close();
        indexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$6) {
                return x$6.delete();
            }
        });
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final ObjectRef log$9;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((MessageAndOffset)((Log)this.log$9.elem).read((long)i, 100, (Option)None$.MODULE$).head()).offset());
            }
            {
                this.log$9 = log$9;
            }
        });
        ((Log)log.elem).close();
    }

    @Test
    public void testTruncateTo() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * (setSize - 1);
        Log log = new Log(this.logDir(), this.logConfig().copy(segmentSize, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$10;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$10.append(this.set$3, this.log$10.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$10 = log$10;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segments.", (int)1, (int)log.numberOfSegments());
        Assert.assertEquals((String)"Log end offset should be equal to number of messages", (long)msgPerSeg, (long)log.logEndOffset());
        long lastOffset = log.logEndOffset();
        long size = log.size();
        log.truncateTo(log.logEndOffset());
        Assert.assertEquals((String)"Should not change offset", (long)lastOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should not change log size", (long)size, (long)log.size());
        log.truncateTo(log.logEndOffset() + 1L);
        Assert.assertEquals((String)"Should not change offset but should log error", (long)lastOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should not change log size", (long)size, (long)log.size());
        log.truncateTo((long)(msgPerSeg / 2));
        Assert.assertEquals((String)"Should change offset", (long)log.logEndOffset(), (long)(msgPerSeg / 2));
        Assert.assertTrue((String)"Should change log size", (log.size() < size ? 1 : 0) != 0);
        log.truncateTo(0L);
        Assert.assertEquals((String)"Should change offset", (long)0L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should change log size", (long)0L, (long)log.size());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$10;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$10.append(this.set$3, this.log$10.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$10 = log$10;
            }
        });
        Assert.assertEquals((String)"Should be back to original offset", (long)log.logEndOffset(), (long)lastOffset);
        Assert.assertEquals((String)"Should be back to original size", (long)log.size(), (long)size);
        log.truncateFullyAndStartAt(log.logEndOffset() - (long)(msgPerSeg - 1));
        Assert.assertEquals((String)"Should change offset", (long)log.logEndOffset(), (long)(lastOffset - (long)(msgPerSeg - 1)));
        Assert.assertEquals((String)"Should change log size", (long)log.size(), (long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$10;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$10.append(this.set$3, this.log$10.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$10 = log$10;
            }
        });
        Assert.assertTrue((String)"Should be ahead of to original offset", (log.logEndOffset() > (long)msgPerSeg ? 1 : 0) != 0);
        Assert.assertEquals((String)"log size should be same as before", (long)size, (long)log.size());
        log.truncateTo(0L);
        Assert.assertEquals((String)"Should change offset", (long)0L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should change log size", (long)log.size(), (long)0L);
    }

    @Test
    public void testIndexResizingAtTruncation() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * (setSize - 1);
        LogConfig config = this.logConfig().copy(segmentSize, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13());
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$11;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$4, this.log$11.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$11 = log$11;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$11;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$4, this.log$11.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$11 = log$11;
            }
        });
        Assert.assertEquals((String)"There should be exactly 2 segment.", (int)2, (int)log.numberOfSegments());
        Assert.assertEquals((String)"The index of the first segment should be trimmed to empty", (int)0, (int)((LogSegment)log.logSegments().toList().apply(0)).index().maxEntries());
        log.truncateTo(0L);
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        Assert.assertEquals((String)"The index of segment 1 should be resized to maxIndexSize", (int)(log.config().maxIndexSize() / 8), (int)((LogSegment)log.logSegments().toList().apply(0)).index().maxEntries());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$11;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$4, this.log$11.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$11 = log$11;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
    }

    @Test
    public void testBogusIndexSegmentsAreRemoved() {
        File bogusIndex1 = Log$.MODULE$.indexFilename(this.logDir(), 0L);
        File bogusIndex2 = Log$.MODULE$.indexFilename(this.logDir(), 5L);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int x$75 = set.sizeInBytes() * 5;
        int x$76 = 1000;
        int x$77 = 1;
        long x$78 = this.logConfig().copy$default$2();
        long x$79 = this.logConfig().copy$default$3();
        long x$80 = this.logConfig().copy$default$4();
        long x$81 = this.logConfig().copy$default$5();
        long x$82 = this.logConfig().copy$default$6();
        int x$83 = this.logConfig().copy$default$7();
        long x$84 = this.logConfig().copy$default$10();
        long x$85 = this.logConfig().copy$default$11();
        double x$86 = this.logConfig().copy$default$12();
        boolean x$87 = this.logConfig().copy$default$13();
        Log log = new Log(this.logDir(), this.logConfig().copy(x$75, x$78, x$79, x$80, x$81, x$82, x$83, x$76, x$77, x$84, x$85, x$86, x$87), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertTrue((String)"The first index file should have been replaced with a larger file", (bogusIndex1.length() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((String)"The second index file should have been deleted.", (boolean)bogusIndex2.exists());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$5;
            private final Log log$12;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$12.append(this.set$5, this.log$12.append$default$2());
            }
            {
                this.set$5 = set$5;
                this.log$12 = log$12;
            }
        });
        log.delete();
    }

    @Test
    public void testReopenThenTruncate() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int x$88 = set.sizeInBytes() * 5;
        int x$89 = 1000;
        int x$90 = 10000;
        long x$91 = this.logConfig().copy$default$2();
        long x$92 = this.logConfig().copy$default$3();
        long x$93 = this.logConfig().copy$default$4();
        long x$94 = this.logConfig().copy$default$5();
        long x$95 = this.logConfig().copy$default$6();
        int x$96 = this.logConfig().copy$default$7();
        long x$97 = this.logConfig().copy$default$10();
        long x$98 = this.logConfig().copy$default$11();
        double x$99 = this.logConfig().copy$default$12();
        boolean x$100 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$88, x$91, x$92, x$93, x$94, x$95, x$96, x$89, x$90, x$97, x$98, x$99, x$100);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$6;
            private final ObjectRef log$13;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$3 = (Log)this.log$13.elem;
                ByteBufferMessageSet x$101 = this.set$6;
                boolean x$102 = qual$3.append$default$2();
                return qual$3.append(x$101, x$102);
            }
            {
                this.set$6 = set$6;
                this.log$13 = log$13;
            }
        });
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        ((Log)log.elem).truncateTo(3L);
        Assert.assertEquals((String)"All but one segment should be deleted.", (int)1, (int)((Log)log.elem).numberOfSegments());
        Assert.assertEquals((String)"Log end offset should be 3.", (long)3L, (long)((Log)log.elem).logEndOffset());
    }

    @Test
    public void testAsyncDelete() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int asyncDeleteMs = 1000;
        int x$103 = set.sizeInBytes() * 5;
        long x$104 = asyncDeleteMs;
        int x$105 = 1000;
        int x$106 = 10000;
        long x$107 = this.logConfig().copy$default$2();
        long x$108 = this.logConfig().copy$default$3();
        long x$109 = this.logConfig().copy$default$4();
        long x$110 = this.logConfig().copy$default$5();
        long x$111 = this.logConfig().copy$default$6();
        int x$112 = this.logConfig().copy$default$7();
        long x$113 = this.logConfig().copy$default$11();
        double x$114 = this.logConfig().copy$default$12();
        boolean x$115 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$103, x$107, x$108, x$109, x$110, x$111, x$112, x$105, x$106, x$104, x$113, x$114, x$115);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$7;
            private final Log log$14;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$14.append(this.set$7, this.log$14.append$default$2());
            }
            {
                this.set$7 = set$7;
                this.log$14 = log$14;
            }
        });
        LogSegment[] segments = (LogSegment[])log.logSegments().toArray(ClassTag$.MODULE$.apply(LogSegment.class));
        File[] oldFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$7) {
                return x$7.log().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$8) {
                return x$8.index().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        log.deleteOldSegments((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment s) {
                return true;
            }
        });
        Assert.assertEquals((String)"Only one segment should remain.", (int)1, (int)log.numberOfSegments());
        Assert.assertTrue((String)"All log and index files should end in .deleted", (Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$9) {
                return x$9.log().file().getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }) && Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$10) {
                return x$10.index().file().getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The .deleted files should still be there.", (Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$11) {
                return x$11.log().file().exists();
            }
        }) && Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$12) {
                return x$12.index().file().exists();
            }
        }) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The original file should be gone.", (boolean)Predef$.MODULE$.refArrayOps((Object[])oldFiles).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$13) {
                return !x$13.exists();
            }
        }));
        File[] deletedFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$14) {
                return x$14.log().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$15) {
                return x$15.index().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        this.time().sleep(asyncDeleteMs + 1);
        Assert.assertTrue((String)"Files should all be gone.", (boolean)Predef$.MODULE$.refArrayOps((Object[])deletedFiles).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$16) {
                return !x$16.exists();
            }
        }));
    }

    @Test
    public void testOpenDeletesObsoleteFiles() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int x$116 = set.sizeInBytes() * 5;
        int x$117 = 1000;
        long x$118 = this.logConfig().copy$default$2();
        long x$119 = this.logConfig().copy$default$3();
        long x$120 = this.logConfig().copy$default$4();
        long x$121 = this.logConfig().copy$default$5();
        long x$122 = this.logConfig().copy$default$6();
        int x$123 = this.logConfig().copy$default$7();
        int x$124 = this.logConfig().copy$default$9();
        long x$125 = this.logConfig().copy$default$10();
        long x$126 = this.logConfig().copy$default$11();
        double x$127 = this.logConfig().copy$default$12();
        boolean x$128 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$116, x$118, x$119, x$120, x$121, x$122, x$123, x$117, x$124, x$125, x$126, x$127, x$128);
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$8;
            private final ObjectRef log$15;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$4 = (Log)this.log$15.elem;
                ByteBufferMessageSet x$129 = this.set$8;
                boolean x$130 = qual$4.append$default$2();
                return qual$4.append(x$129, x$130);
            }
            {
                this.set$8 = set$8;
                this.log$15 = log$15;
            }
        });
        ((Log)log.elem).deleteOldSegments((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment s) {
                return true;
            }
        });
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"The deleted segments should be gone.", (int)1, (int)((Log)log.elem).numberOfSegments());
    }

    @Test
    public void testAppendMessageWithNullPayload() {
        Log log;
        Log qual$5 = log = new Log(this.logDir(), new LogConfig(LogConfig$.MODULE$.apply$default$1(), LogConfig$.MODULE$.apply$default$2(), LogConfig$.MODULE$.apply$default$3(), LogConfig$.MODULE$.apply$default$4(), LogConfig$.MODULE$.apply$default$5(), LogConfig$.MODULE$.apply$default$6(), LogConfig$.MODULE$.apply$default$7(), LogConfig$.MODULE$.apply$default$8(), LogConfig$.MODULE$.apply$default$9(), LogConfig$.MODULE$.apply$default$10(), LogConfig$.MODULE$.apply$default$11(), LogConfig$.MODULE$.apply$default$12(), LogConfig$.MODULE$.apply$default$13()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Message[] messageArray = new Message[1];
        messageArray[0] = new Message(null);
        ByteBufferMessageSet x$131 = new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
        boolean x$132 = qual$5.append$default$2();
        qual$5.append(x$131, x$132);
        MessageSet ms = log.read(0L, 4096, (Option)None$.MODULE$);
        Assert.assertEquals((long)0L, (long)((MessageAndOffset)ms.head()).offset());
        Assert.assertTrue((String)"Message payload should be null.", (boolean)((MessageAndOffset)ms.head()).message().isNull());
    }

    @Test
    public void testCorruptLog() {
        int x$133 = 1;
        int x$134 = 65536;
        int x$135 = 1000;
        long x$136 = this.logConfig().copy$default$2();
        long x$137 = this.logConfig().copy$default$3();
        long x$138 = this.logConfig().copy$default$4();
        long x$139 = this.logConfig().copy$default$5();
        long x$140 = this.logConfig().copy$default$6();
        int x$141 = this.logConfig().copy$default$8();
        long x$142 = this.logConfig().copy$default$10();
        long x$143 = this.logConfig().copy$default$11();
        double x$144 = this.logConfig().copy$default$12();
        boolean x$145 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$135, x$136, x$137, x$138, x$139, x$140, x$134, x$141, x$133, x$142, x$143, x$144, x$145);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        long recoveryPoint = 50L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, config, set, recoveryPoint){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final LogConfig config$1;
            public final ByteBufferMessageSet set$9;
            private final long recoveryPoint$1;

            public final void apply(int iteration) {
                this.apply$mcVI$sp(iteration);
            }

            public void apply$mcVI$sp(int iteration) {
                this.$outer.logDir().mkdirs();
                ObjectRef log = new ObjectRef((Object)new Log(this.$outer.logDir(), this.config$1, 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time()));
                int numMessages = 50 + TestUtils$.MODULE$.random().nextInt(50);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCorruptLog$1 $outer;
                    private final ObjectRef log$16;

                    public final Log.LogAppendInfo apply(int i) {
                        Log qual$6 = (Log)this.log$16.elem;
                        ByteBufferMessageSet x$146 = this.$outer.set$9;
                        boolean x$147 = qual$6.append$default$2();
                        return qual$6.append(x$146, x$147);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.log$16 = log$16;
                    }
                });
                Iterable messages2 = (Iterable)((Log)log.elem).logSegments().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MessageAndOffset> apply(LogSegment x$17) {
                        return x$17.log().iterator().toList();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                ((Log)log.elem).close();
                TestUtils$.MODULE$.appendNonsenseToFile(((Log)log.elem).activeSegment().index().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
                TestUtils$.MODULE$.appendNonsenseToFile(((Log)log.elem).activeSegment().log().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
                log.elem = new Log(this.$outer.logDir(), this.config$1, this.recoveryPoint$1, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                Assert.assertEquals((long)numMessages, (long)((Log)log.elem).logEndOffset());
                Assert.assertEquals((String)"Messages in the log after recovery should be the same.", (Object)messages2, (Object)((Log)log.elem).logSegments().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MessageAndOffset> apply(LogSegment x$18) {
                        return x$18.log().iterator().toList();
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
                Utils$.MODULE$.rm(this.$outer.logDir());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.set$9 = set$9;
                this.recoveryPoint$1 = recoveryPoint$1;
            }
        });
    }

    @Test
    public void testCleanShutdownFile() {
        int x$148 = 1;
        int x$149 = 65536;
        int x$150 = 1000;
        long x$151 = this.logConfig().copy$default$2();
        long x$152 = this.logConfig().copy$default$3();
        long x$153 = this.logConfig().copy$default$4();
        long x$154 = this.logConfig().copy$default$5();
        long x$155 = this.logConfig().copy$default$6();
        int x$156 = this.logConfig().copy$default$8();
        long x$157 = this.logConfig().copy$default$10();
        long x$158 = this.logConfig().copy$default$11();
        double x$159 = this.logConfig().copy$default$12();
        boolean x$160 = this.logConfig().copy$default$13();
        LogConfig config = this.logConfig().copy(x$150, x$151, x$152, x$153, x$154, x$155, x$149, x$156, x$148, x$157, x$158, x$159, x$160);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        File parentLogDir = this.logDir().getParentFile();
        Assert.assertTrue((String)"Data directory %s must exist", (boolean)parentLogDir.isDirectory());
        File cleanShutdownFile = new File(parentLogDir, Log$.MODULE$.CleanShutdownFile());
        cleanShutdownFile.createNewFile();
        Assert.assertTrue((String)".kafka_cleanshutdown must exist", (boolean)cleanShutdownFile.exists());
        long recoveryPoint = 0L;
        ObjectRef log = new ObjectRef((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$10;
            private final ObjectRef log$17;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$7 = (Log)this.log$17.elem;
                ByteBufferMessageSet x$161 = this.set$10;
                boolean x$162 = qual$7.append$default$2();
                return qual$7.append(x$161, x$162);
            }
            {
                this.set$10 = set$10;
                this.log$17 = log$17;
            }
        });
        ((Log)log.elem).close();
        recoveryPoint = ((Log)log.elem).logEndOffset();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((long)recoveryPoint, (long)((Log)log.elem).logEndOffset());
        cleanShutdownFile.delete();
    }

    private final ByteBufferMessageSet read$1(int offset, Log log$6) {
        return ByteBufferMessageSet$.MODULE$.decompress(((MessageAndOffset)log$6.read((long)offset, 4096, log$6.read$default$3()).head()).message());
    }

    public LogTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        this.logDir = null;
        this.time = new MockTime(0L);
        this.config = null;
        this.logConfig = new LogConfig(LogConfig$.MODULE$.apply$default$1(), LogConfig$.MODULE$.apply$default$2(), LogConfig$.MODULE$.apply$default$3(), LogConfig$.MODULE$.apply$default$4(), LogConfig$.MODULE$.apply$default$5(), LogConfig$.MODULE$.apply$default$6(), LogConfig$.MODULE$.apply$default$7(), LogConfig$.MODULE$.apply$default$8(), LogConfig$.MODULE$.apply$default$9(), LogConfig$.MODULE$.apply$default$10(), LogConfig$.MODULE$.apply$default$11(), LogConfig$.MODULE$.apply$default$12(), LogConfig$.MODULE$.apply$default$13());
    }
}

