/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u000f\ty1*\u00194lC\u000e{gNZ5h)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005-QUK\\5ugM+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012!\t;fgRdun\u001a*fi\u0016tG/[8o)&lW\rS8veN\u0004&o\u001c<jI\u0016$G#\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003/\u0005\u0002\"A\t\u0013\u000e\u0003\rR!a\u0003\b\n\u0005\u0015\u001a#\u0001\u0002+fgRDQa\n\u0001\u0005\u0002e\t1\u0005^3ti2{wMU3uK:$\u0018n\u001c8US6,W*\u001b8vi\u0016\u001c\bK]8wS\u0012,G\r\u000b\u0002'C!)!\u0006\u0001C\u00013\u0005!C/Z:u\u0019><'+\u001a;f]RLwN\u001c+j[\u0016tunQ8oM&<\u0007K]8wS\u0012,G\r\u000b\u0002*C!)Q\u0006\u0001C\u00013\u0005yC/Z:u\u0019><'+\u001a;f]RLwN\u001c+j[\u0016\u0014u\u000e\u001e5NS:,H/Z:B]\u0012Du.\u001e:t!J|g/\u001b3fI\"\u0012A&\t\u0005\u0006a\u0001!\t!G\u0001\u0016i\u0016\u001cH/\u00113wKJ$\u0018n]3EK\u001a\fW\u000f\u001c;tQ\ty\u0013\u0005C\u00034\u0001\u0011\u0005\u0011$A\fuKN$\u0018\t\u001a<feRL7/Z\"p]\u001aLw-\u001e:fI\"\u0012!'\t")
public class KafkaConfigTest
extends JUnit3Suite {
    @Test
    public void testLogRetentionTimeHoursProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181);
        ((Hashtable)props).put("log.retention.hours", "1");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)3600000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeMinutesProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181);
        ((Hashtable)props).put("log.retention.minutes", "30");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeNoConfigProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181);
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)604800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testLogRetentionTimeBothMinutesAndHoursProvided() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, 8181);
        ((Hashtable)props).put("log.retention.minutes", "30");
        ((Hashtable)props).put("log.retention.hours", "1");
        KafkaConfig cfg = new KafkaConfig(props);
        Assert.assertEquals((long)1800000L, (long)cfg.logRetentionTimeMillis());
    }

    @Test
    public void testAdvertiseDefaults() {
        int port = 9999;
        String hostName = "fake-host";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, port);
        ((Hashtable)props).put("host.name", hostName);
        KafkaConfig serverConfig = new KafkaConfig(props);
        Assert.assertEquals((String)serverConfig.advertisedHostName(), (String)hostName);
        Assert.assertEquals((int)serverConfig.advertisedPort(), (int)port);
    }

    @Test
    public void testAdvertiseConfigured() {
        int port = 9999;
        String advertisedHostName = "routable-host";
        int advertisedPort = 1234;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, port);
        ((Hashtable)props).put("advertised.host.name", advertisedHostName);
        ((Hashtable)props).put("advertised.port", ((Object)BoxesRunTime.boxToInteger((int)advertisedPort)).toString());
        KafkaConfig serverConfig = new KafkaConfig(props);
        Assert.assertEquals((String)serverConfig.advertisedHostName(), (String)advertisedHostName);
        Assert.assertEquals((int)serverConfig.advertisedPort(), (int)advertisedPort);
    }
}

