/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.serializer.StringEncoder$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.ReplicaFetchTest$;
import kafka.utils.TestUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u000f\t\u0001\"+\u001a9mS\u000e\fg)\u001a;dQR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\u000bA\u0014x\u000e]:\u0016\u0003\u0001\u00022!I\u0016/\u001d\t\u0011\u0003F\u0004\u0002$M5\tAE\u0003\u0002&\r\u00051AH]8pizJ\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S)\nq\u0001]1dW\u0006<WMC\u0001(\u0013\taSF\u0001\u0003MSN$(BA\u0015+!\tyC'D\u00011\u0015\t\t$'\u0001\u0003vi&d'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u00199\u0004\u0001)A\u0005A\u00051\u0001O]8qg\u0002Bq!\u000f\u0001C\u0002\u0013\u0005!(A\u0004d_:4\u0017nZ:\u0016\u0003m\u00022\u0001P!C\u001b\u0005i$B\u0001 @\u0003%IW.\\;uC\ndWM\u0003\u0002AU\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051j\u0004C\u0001\u000fD\u0013\t!%AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u0002$\u0001A\u0003%1(\u0001\u0005d_:4\u0017nZ:!\u0011\u001dA\u0005\u00011A\u0005\u0002%\u000bqA\u0019:pW\u0016\u00148/F\u0001K!\r\t3*T\u0005\u0003\u00196\u00121aU3r!\tab*\u0003\u0002P\u0005\tY1*\u00194lCN+'O^3s\u0011\u001d\t\u0006\u00011A\u0005\u0002I\u000b1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u00111k\u0016\t\u0003)Vk\u0011AK\u0005\u0003-*\u0012A!\u00168ji\"9\u0001\fUA\u0001\u0002\u0004Q\u0015a\u0001=%c!1!\f\u0001Q!\n)\u000b\u0001B\u0019:pW\u0016\u00148\u000f\t\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0003\u0019!x\u000e]5dcU\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002be\u0005!A.\u00198h\u0013\t\u0019\u0007M\u0001\u0004TiJLgn\u001a\u0005\u0007K\u0002\u0001\u000b\u0011\u00020\u0002\u000fQ|\u0007/[22A!9q\r\u0001b\u0001\n\u0003i\u0016A\u0002;pa&\u001c'\u0007\u0003\u0004j\u0001\u0001\u0006IAX\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u0015Y\u0007\u0001\"\u0011m\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0006\"\u00028\u0001\t\u0003b\u0017\u0001\u0003;fCJ$un\u001e8\t\u000bA\u0004A\u0011\u00017\u00021Q,7\u000f\u001e*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r")
public class ReplicaFetchTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final List<Properties> props;
    private final List<KafkaConfig> configs;
    private Seq<KafkaServer> brokers;
    private final String topic1;
    private final String topic2;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public List<Properties> props() {
        return this.props;
    }

    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.brokers_$eq((Seq<KafkaServer>)((Seq)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig config) {
                return TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    @Override
    public void tearDown() {
        this.brokers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testReplicaFetcherThread() {
        int partition = 0;
        List testMessageList1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"}));
        List testMessageList2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test5", "test6", "test7", "test8"}));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;

            public final Option<Object> apply(String topic) {
                AdminUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, 1, 2, AdminUtils$.MODULE$.createTopic$default$5());
                return TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.$outer.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Producer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()), new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()));
        List messages2 = (List)((List)testMessageList1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage(this.$outer.topic1(), (Object)m, (Object)m);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)testMessageList2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage(this.$outer.topic2(), (Object)m, (Object)m);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        producer.send((Seq)messages2);
        producer.close();
        Assert.assertTrue((String)"Broker logs should be identical", (boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;
            private final int partition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$server$ReplicaFetchTest$$logsMatch$1(this.partition$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        }, 6000L));
    }

    public final boolean kafka$server$ReplicaFetchTest$$logsMatch$1(int partition$1) {
        BooleanRef result = new BooleanRef(true);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1)new Serializable(this, partition$1, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetchTest $outer;
            private final int partition$1;
            private final BooleanRef result$1;

            public final void apply(String topic) {
                TopicAndPartition topicAndPart = new TopicAndPartition(topic, this.partition$1);
                long expectedOffset = ((Log)((KafkaServer)this.$outer.brokers().head()).getLogManager().getLog(topicAndPart).get()).logEndOffset();
                this.result$1.elem = this.result$1.elem && expectedOffset > 0L && BoxesRunTime.unboxToBoolean((Object)this.$outer.brokers().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this, topicAndPart, expectedOffset){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPart$1;
                    private final long expectedOffset$1;

                    public final boolean apply(boolean total, KafkaServer item) {
                        return total && this.expectedOffset$1 == ((Log)item.getLogManager().getLog(this.topicAndPart$1).get()).logEndOffset();
                    }
                    {
                        this.topicAndPart$1 = topicAndPart$1;
                        this.expectedOffset$1 = expectedOffset$1;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
                this.result$1 = result$1;
            }
        });
        return result.elem;
    }

    public ReplicaFetchTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.props = TestUtils$.MODULE$.createBrokerConfigs(2);
        this.configs = (List)this.props().map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom());
        this.brokers = null;
        this.topic1 = "foo";
        this.topic2 = "bar";
    }
}

