/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.KafkaStorageException;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u000f\r&dW-T3tg\u0006<WmU3u\u0011!Y\u0002A!A!\u0002\u00131\u0012\u0001\u00027pO\u0002B\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0006S:$W\r_\u000b\u0002?A\u0011q\u0003I\u0005\u0003C\t\u00111b\u00144gg\u0016$\u0018J\u001c3fq\"A1\u0005\u0001B\u0001B\u0003%q$\u0001\u0004j]\u0012,\u0007\u0010\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0003\u001d\u0002\"!\u0003\u0015\n\u0005%R!\u0001\u0002'p]\u001eD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IaJ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003IIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:\u0016\u0003=\u0002\"!\u0003\u0019\n\u0005ER!aA%oi\"A1\u0007\u0001B\u0001B\u0003%q&A\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\b\u0005\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003\u0011!\u0018.\\3\u0011\u0005=9\u0014B\u0001\u001d\u0011\u0005\u0011!\u0016.\\3\t\u000bi\u0002A\u0011A\u001e\u0002\rqJg.\u001b;?)\u0019aTHP A\u0003B\u0011q\u0003\u0001\u0005\u0006\u0007e\u0002\rA\u0006\u0005\u0006;e\u0002\ra\b\u0005\u0006Ke\u0002\ra\n\u0005\u0006[e\u0002\ra\f\u0005\u0006ke\u0002\rA\u000e\u0005\b\u0007\u0002\u0001\r\u0011\"\u0001'\u0003\u001d\u0019'/Z1uK\u0012Dq!\u0012\u0001A\u0002\u0013\u0005a)A\u0006de\u0016\fG/\u001a3`I\u0015\fHCA$K!\tI\u0001*\u0003\u0002J\u0015\t!QK\\5u\u0011\u001dYE)!AA\u0002\u001d\n1\u0001\u001f\u00132\u0011\u0019i\u0005\u0001)Q\u0005O\u0005A1M]3bi\u0016$\u0007\u0005C\u0004P\u0001\u0001\u0007I\u0011\u0002\u0018\u00021\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018\u0010C\u0004R\u0001\u0001\u0007I\u0011\u0002*\u00029\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018p\u0018\u0013fcR\u0011qi\u0015\u0005\b\u0017B\u000b\t\u00111\u00010\u0011\u0019)\u0006\u0001)Q\u0005_\u0005I\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=!\u0011\u0015Q\u0004\u0001\"\u0001X)\u0019a\u0004L\u00193fO\")\u0011L\u0016a\u00015\u0006\u0019A-\u001b:\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016AA5p\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\t\u0019KG.\u001a\u0005\u0006GZ\u0003\raJ\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0003.-\u0002\u0007q\u0006C\u0003g-\u0002\u0007q&\u0001\u0007nCbLe\u000eZ3y'&TX\rC\u00036-\u0002\u0007a\u0007C\u0003j\u0001\u0011\u0005a%\u0001\u0003tSj,\u0007\"B6\u0001\t\u0003a\u0017AB1qa\u0016tG\rF\u0002H[>DQA\u001c6A\u0002\u001d\naa\u001c4gg\u0016$\b\"\u00029k\u0001\u0004\t\u0018\u0001C7fgN\fw-Z:\u0011\u0005I,X\"A:\u000b\u0005Q$\u0011aB7fgN\fw-Z\u0005\u0003mN\u0014ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bF\u00016y!\ty\u00110\u0003\u0002{!\tian\u001c8uQJ,\u0017\rZ:bM\u0016Da\u0001 \u0001\u0005\u0002\ti\u0018a\u0004;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;\u0015\u000by\f\u0019!!\u0002\u0011\u0005]y\u0018bAA\u0001\u0005\tqqJ\u001a4tKR\u0004vn]5uS>t\u0007\"\u00028|\u0001\u00049\u0003\u0002CA\u0004wB\u0005\t\u0019A\u0018\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\rY\u00181\u0002\t\u0004\u001f\u00055\u0011bAA\b!\tQA\u000f\u001b:fC\u0012\u001c\u0018MZ3\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005!!/Z1e)!\t9\"!\b\u0002 \u0005%\u0002c\u0001:\u0002\u001a%\u0019\u00111D:\u0003\u00155+7o]1hKN+G\u000f\u0003\u0004d\u0003#\u0001\ra\n\u0005\t\u0003C\t\t\u00021\u0001\u0002$\u0005IQ.\u0019=PM\u001a\u001cX\r\u001e\t\u0005\u0013\u0005\u0015r%C\u0002\u0002()\u0011aa\u00149uS>t\u0007bBA\u0016\u0003#\u0001\raL\u0001\b[\u0006D8+\u001b>fQ\u0011\t\t\"a\u0003\t\u000f\u0005E\u0002\u0001\"\u0001\u00024\u00059!/Z2pm\u0016\u0014HcA\u0018\u00026!9\u0011qGA\u0018\u0001\u0004y\u0013AD7bq6+7o]1hKNK'0\u001a\u0015\u0004\u0003_A\bbBA\u001f\u0001\u0011\u0005\u0013qH\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t0\u0002\t1\fgnZ\u0005\u0005\u0003\u0017\n)E\u0001\u0004TiJLgn\u001a\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004_\u0005M\u0003B\u00028\u0002N\u0001\u0007q\u0005K\u0002\u0002NaDq!!\u0017\u0001\t\u0003\tY&\u0001\u0006oKb$xJ\u001a4tKR$\u0012a\n\u0015\u0005\u0003/\nY\u0001C\u0004\u0002b\u0001!\t!a\u0019\u0002\u000b\u0019dWo\u001d5\u0015\u0003\u001dCC!a\u0018\u0002\f!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0014AE2iC:<WMR5mKN+hMZ5yKN$RaRA7\u0003{B\u0001\"a\u001c\u0002h\u0001\u0007\u0011\u0011O\u0001\n_2$7+\u001e4gSb\u0004B!a\u001d\u0002z9\u0019\u0011\"!\u001e\n\u0007\u0005]$\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\nYHC\u0002\u0002x)A\u0001\"a \u0002h\u0001\u0007\u0011\u0011O\u0001\n]\u0016<8+\u001e4gSbDq!a!\u0001\t\u0003\t\u0019'A\u0003dY>\u001cX\rC\u0004\u0002\b\u0002!\t!a\u0019\u0002\r\u0011,G.\u001a;f\u0011\u0019\tY\t\u0001C\u0001M\u0005aA.Y:u\u001b>$\u0017NZ5fI\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0015\u0001\u00057bgRlu\u000eZ5gS\u0016$w\fJ3r)\u0011\t\u0019*!'\u0011\u0007%\t)*C\u0002\u0002\u0018*\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u001c\u00065\u0005\u0019A\u0014\u0002\u00055\u001c\b\"CAP\u0001E\u0005I\u0011AAQ\u0003e!(/\u00198tY\u0006$Xm\u00144gg\u0016$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r&fA\u0018\u0002&.\u0012\u0011q\u0015\t\u0005\u0003S\u000b\u0019,\u0004\u0002\u0002,*!\u0011QVAX\u0003%)hn\u00195fG.,GMC\u0002\u00022*\t!\"\u00198o_R\fG/[8o\u0013\u0011\t),a+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u000b\u0002\u0001q\u0002")
public class LogSegment
implements Logging {
    private final FileMessageSet log;
    private final OffsetIndex index;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileMessageSet log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long created() {
        return this.created;
    }

    public void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public void append(long offset, ByteBufferMessageSet messages) {
        if (messages.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, offset, messages){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long offset$1;
                private final ByteBufferMessageSet messages$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.offset$1 = offset$1;
                    this.messages$1 = messages$1;
                }
            });
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(offset, this.log().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.log().append(messages);
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + messages.sizeInBytes());
        }
    }

    public OffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchFor(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public MessageSet read(long startOffset, Option<Object> maxOffset, int maxSize) {
        Option<Object> option;
        block9: {
            int n;
            OffsetPosition startPosition;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
                    }
                    if (maxSize == 0) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    logSize = this.log().sizeInBytes();
                    startPosition = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startPosition == null) {
                        return null;
                    }
                    option = maxOffset;
                    None$ none$ = None$.MODULE$;
                    Option<Object> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    n = maxSize;
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long offset = BoxesRunTime.unboxToLong((Object)some.x());
                if (offset < startOffset) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToLong((long)startOffset)})));
                }
                OffsetPosition mapping = this.translateOffset(offset, startPosition.position());
                int endPosition = mapping == null ? logSize : mapping.position();
                n = package$.MODULE$.min(endPosition - startPosition.position(), maxSize);
            }
            int length = n;
            return this.log().read(startPosition.position(), length);
        }
        throw new MatchError(option);
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        int validBytes = 0;
        int lastIndexEntry = 0;
        Iterator<MessageAndOffset> iter = this.log().iterator(maxMessageSize);
        try {
            while (iter.hasNext()) {
                MessageAndOffset entry2 = (MessageAndOffset)iter.next();
                entry2.message().ensureValid();
                if (validBytes - lastIndexEntry > this.indexIntervalBytes()) {
                    CompressionCodec compressionCodec = entry2.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    long l = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? entry2.offset() : ((MessageAndOffset)ByteBufferMessageSet$.MODULE$.decompress(entry2.message()).head()).offset();
                    long startOffset = l;
                    this.index().append(startOffset, validBytes);
                    lastIndexEntry = validBytes;
                }
                validBytes += MessageSet$.MODULE$.entrySize(entry2.message());
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.logger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes), invalidMessageException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes;
        this.log().truncateTo(validBytes);
        this.index().trimToValidSize();
        return truncated;
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset) {
        OffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset);
        this.index().resize(this.index().maxIndexSize());
        int bytesTruncated = this.log().truncateTo(mapping.position());
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time.milliseconds());
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        return bytesTruncated;
    }

    public long nextOffset() {
        Option option;
        block6: {
            long l;
            block3: {
                long l2;
                block5: {
                    block4: {
                        MessageSet ms;
                        block2: {
                            ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes());
                            if (ms != null) break block2;
                            l = this.baseOffset();
                            break block3;
                        }
                        option = ms.lastOption();
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        l2 = this.baseOffset();
                        break block5;
                    }
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    MessageAndOffset last = (MessageAndOffset)some.x();
                    l2 = last.nextOffset();
                }
                l = l2;
            }
            return l;
        }
        throw new MatchError((Object)option);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.index().flush();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        boolean logRenamed = this.log().renameTo(new File(Utils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        if (logRenamed) {
            boolean indexRenamed = this.index().renameTo(new File(Utils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
            if (indexRenamed) {
                return;
            }
            throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("Failed to change the index file suffix from %s to %s for log segment %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
        }
        throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("Failed to change the log file suffix from %s to %s for log segment %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
    }

    public void close() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        return this.index().file().setLastModified(ms);
    }

    public LogSegment(FileMessageSet log, OffsetIndex index, long baseOffset, int indexIntervalBytes, Time time) {
        this.log = log;
        this.index = index;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, Time time) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(dir, startOffset)), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, time);
    }
}

