/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import kafka.log.FileMessageSet;
import kafka.log.OffsetPosition;
import kafka.message.BaseMessageSetTestCases;
import kafka.message.BaseMessageSetTestCases$class;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.TestUtils$;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u000f\t\u0011b)\u001b7f\u001b\u0016\u001c8/Y4f'\u0016$H+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001\u0002\u0005\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\b[\u0016\u001c8/Y4f\u0013\t)\"CA\fCCN,W*Z:tC\u001e,7+\u001a;UKN$8)Y:fg\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0005\b9\u0001\u0011\r\u0011\"\u0001\u001e\u0003)iWm]:bO\u0016\u001cV\r^\u000b\u0002=A\u0011!dH\u0005\u0003A\t\u0011aBR5mK6+7o]1hKN+G\u000f\u0003\u0004#\u0001\u0001\u0006IAH\u0001\f[\u0016\u001c8/Y4f'\u0016$\b\u0005C\u0003%\u0001\u0011\u0005Q%\u0001\tde\u0016\fG/Z'fgN\fw-Z*fiR\u0011aD\n\u0005\u0006O\r\u0002\r\u0001K\u0001\t[\u0016\u001c8/Y4fgB\u0019\u0011f\r\u001c\u000f\u0005)\u0002dBA\u0016/\u001b\u0005a#BA\u0017\u0007\u0003\u0019a$o\\8u}%\tq&A\u0003tG\u0006d\u0017-\u0003\u00022e\u00059\u0001/Y2lC\u001e,'\"A\u0018\n\u0005Q*$aA*fc*\u0011\u0011G\r\t\u0003#]J!\u0001\u000f\n\u0003\u000f5+7o]1hK\")!\b\u0001C\u0001w\u0005aA/Z:u\r&dWmU5{KR\tA\b\u0005\u0002>}5\t!'\u0003\u0002@e\t!QK\\5uQ\tI\u0014\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006)!.\u001e8ji*\ta)A\u0002pe\u001eL!\u0001S\"\u0003\tQ+7\u000f\u001e\u0005\u0006\u0015\u0002!\taO\u0001&i\u0016\u001cH/\u0013;fe\u0006$\u0018n\u001c8Pm\u0016\u0014\b+\u0019:uS\u0006d\u0017I\u001c3UeVt7-\u0019;j_:D#!S!\t\u000b5\u0003A\u0011\u0001(\u0002!Q,7\u000f\u001e)beRL\u0017\r\\,sSR,Gc\u0001\u001fP)\")\u0001\u000b\u0014a\u0001#\u0006!1/\u001b>f!\ti$+\u0003\u0002Te\t\u0019\u0011J\u001c;\t\u000bqa\u0005\u0019\u0001\u0010\t\u000bY\u0003A\u0011A\u001e\u0002CQ,7\u000f^%uKJ\fG/[8o\t>,7O\u001c;DQ\u0006tw-\u001a)pg&$\u0018n\u001c8)\u0005U\u000b\u0005\"B-\u0001\t\u0003Y\u0014\u0001\u0003;fgR\u0014V-\u00193)\u0005a\u000b\u0005\"\u0002/\u0001\t\u0003Y\u0014A\u0003;fgR\u001cV-\u0019:dQ\"\u00121,\u0011\u0005\u0006?\u0002!\taO\u0001\u0017i\u0016\u001cH/\u0013;fe\u0006$xN],ji\"d\u0015.\\5ug\"\u0012a,\u0011\u0005\u0006E\u0002!\taO\u0001\ri\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a\u0015\u0003C\u0006\u0003")
public class FileMessageSetTest
implements BaseMessageSetTestCases {
    private final FileMessageSet messageSet;
    private final Message[] messages;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    @Override
    public Message[] messages() {
        return this.messages;
    }

    @Override
    public void kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq(Message[] x$1) {
        this.messages = x$1;
    }

    @Override
    @Test
    public void testWrittenEqualsRead() {
        BaseMessageSetTestCases$class.testWrittenEqualsRead(this);
    }

    @Override
    @Test
    public void testIteratorIsConsistent() {
        BaseMessageSetTestCases$class.testIteratorIsConsistent(this);
    }

    @Override
    @Test
    public void testSizeInBytes() {
        BaseMessageSetTestCases$class.testSizeInBytes(this);
    }

    @Override
    @Test
    public void testWriteTo() {
        BaseMessageSetTestCases$class.testWriteTo(this);
    }

    @Override
    public void testWriteToWithMessageSet(MessageSet set) {
        BaseMessageSetTestCases$class.testWriteToWithMessageSet(this, set);
    }

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public FileMessageSet messageSet() {
        return this.messageSet;
    }

    /*
     * WARNING - void declaration
     */
    public FileMessageSet createMessageSet(Seq<Message> messages2) {
        void var2_2;
        FileMessageSet set = new FileMessageSet(TestUtils$.MODULE$.tempFile());
        set.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, messages2));
        set.flush();
        return var2_2;
    }

    @Test
    public void testFileSize() {
        Assert.assertEquals((long)this.messageSet().channel().size(), (long)this.messageSet().sizeInBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSetTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.messageSet().append(TestUtils$.MODULE$.singleMessageSet("abcd".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()));
                Assert.assertEquals((long)this.$outer.messageSet().channel().size(), (long)this.$outer.messageSet().sizeInBytes());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testIterationOverPartialAndTruncation() {
        this.testPartialWrite(0, this.messageSet());
        this.testPartialWrite(2, this.messageSet());
        this.testPartialWrite(4, this.messageSet());
        this.testPartialWrite(5, this.messageSet());
        this.testPartialWrite(6, this.messageSet());
    }

    public void testPartialWrite(int size, FileMessageSet messageSet) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        long originalPosition = messageSet.channel().position();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;

            public final ByteBuffer apply(int i) {
                return this.buffer$1.put((byte)0);
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        buffer.rewind();
        messageSet.channel().write(buffer);
        TestUtils$.MODULE$.checkEquals(Predef$.MODULE$.refArrayOps((Object[])this.messages()).iterator(), ((IterableLike)messageSet.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset m) {
                return m.message();
            }
        }, Iterable$.MODULE$.canBuildFrom())).iterator());
    }

    @Test
    public void testIterationDoesntChangePosition() {
        long position = this.messageSet().channel().position();
        TestUtils$.MODULE$.checkEquals(Predef$.MODULE$.refArrayOps((Object[])this.messages()).iterator(), ((IterableLike)this.messageSet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset m) {
                return m.message();
            }
        }, Iterable$.MODULE$.canBuildFrom())).iterator());
        Assert.assertEquals((long)position, (long)this.messageSet().channel().position());
    }

    @Test
    public void testRead() {
        FileMessageSet read = this.messageSet().read(0, this.messageSet().sizeInBytes());
        TestUtils$.MODULE$.checkEquals(this.messageSet().iterator(), read.iterator());
        List items = read.iterator().toList();
        MessageAndOffset sec = (MessageAndOffset)((IterableLike)items.tail()).head();
        read = this.messageSet().read(MessageSet$.MODULE$.entrySize(sec.message()), this.messageSet().sizeInBytes());
        Assert.assertEquals((String)"Try a read starting from the second message", (Object)items.tail(), (Object)read.toList());
        read = this.messageSet().read(MessageSet$.MODULE$.entrySize(sec.message()), MessageSet$.MODULE$.entrySize(sec.message()));
        Assert.assertEquals((String)"Try a read of a single message starting from the second message", (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{(MessageAndOffset)((IterableLike)items.tail()).head()})), (Object)read.toList());
    }

    @Test
    public void testSearch() {
        Message lastMessage = new Message("test".getBytes());
        this.messageSet().append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new AtomicLong(50L), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{lastMessage})));
        int position = 0;
        Assert.assertEquals((String)"Should be able to find the first message by its offset", (Object)new OffsetPosition(0L, position), (Object)this.messageSet().searchFor(0L, 0));
        Assert.assertEquals((String)"Should be able to find second message when starting from 0", (Object)new OffsetPosition(1L, position += MessageSet$.MODULE$.entrySize(((MessageAndOffset)this.messageSet().head()).message())), (Object)this.messageSet().searchFor(1L, 0));
        Assert.assertEquals((String)"Should be able to find second message starting from its offset", (Object)new OffsetPosition(1L, position), (Object)this.messageSet().searchFor(1L, position));
        Assert.assertEquals((String)"Should be able to find fourth message from a non-existant offset", (Object)new OffsetPosition(50L, position += MessageSet$.MODULE$.entrySize(((MessageAndOffset)((IterableLike)this.messageSet().tail()).head()).message()) + MessageSet$.MODULE$.entrySize(((MessageAndOffset)((IterableLike)((TraversableLike)this.messageSet().tail()).tail()).head()).message())), (Object)this.messageSet().searchFor(3L, position));
        Assert.assertEquals((String)"Should be able to find fourth message by correct offset", (Object)new OffsetPosition(50L, position), (Object)this.messageSet().searchFor(50L, position));
    }

    @Test
    public void testIteratorWithLimits() {
        MessageAndOffset message = (MessageAndOffset)this.messageSet().toList().apply(1);
        int start = this.messageSet().searchFor(1L, 0).position();
        int size = message.message().size();
        FileMessageSet slice = this.messageSet().read(start, size);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{message})), (Object)slice.toList());
    }

    @Test
    public void testTruncate() {
        MessageAndOffset message = (MessageAndOffset)this.messageSet().toList().apply(0);
        int end = this.messageSet().searchFor(1L, 0).position();
        this.messageSet().truncateTo(end);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{message})), (Object)this.messageSet().toList());
        Assert.assertEquals((int)MessageSet$.MODULE$.entrySize(message.message()), (int)this.messageSet().sizeInBytes());
    }

    public FileMessageSetTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        BaseMessageSetTestCases$class.$init$(this);
        this.messageSet = this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])this.messages()));
    }
}

