/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.easymock.EasyMock;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u000f\t\u0011\"+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u0005)Ao\u001c9jGV\t!\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\rM#(/\u001b8h\u0011\u0019\u0019\u0003\u0001)A\u00055\u00051Ao\u001c9jG\u0002BQ!\n\u0001\u0005\u0002\u0019\n\u0011\u0005^3ti\"Kw\r[,bi\u0016\u0014X*\u0019:l\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001e$\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0005+:LG\u000f\u000b\u0002%]A\u0011q&M\u0007\u0002a)\u00111BD\u0005\u0003eA\u0012A\u0001V3ti\")A\u0007\u0001C\u0001M\u0005IC/Z:u\u0011&<\u0007n^1uKJl\u0015M]6SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001eD#a\r\u0018")
public class ReplicaManagerTest
extends JUnit3Suite {
    private final String topic;

    public String topic() {
        return this.topic;
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.createBrokerConfig$default$2(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        KafkaConfig config = new KafkaConfig(props);
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        MockTime time = new MockTime();
        ReplicaManager rm = new ReplicaManager(config, (Time)time, zkClient, (Scheduler)new MockScheduler(time), mockLogMgr, new AtomicBoolean(false));
        Partition partition = rm.getOrCreatePartition(this.topic(), 1);
        partition.getOrCreateReplica(1);
        rm.checkpointHighWatermarks();
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.createBrokerConfig$default$2(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = new KafkaConfig(props);
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        MockTime time = new MockTime();
        ReplicaManager rm = new ReplicaManager(config, (Time)time, zkClient, (Scheduler)new MockScheduler(time), mockLogMgr, new AtomicBoolean(false));
        Partition partition = rm.getOrCreatePartition(this.topic(), 1);
        partition.getOrCreateReplica(1);
        rm.checkpointHighWatermarks();
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }
}

