/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import junit.framework.Assert;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001!2A!\u0001\u0002\u0001\u000f\t\t2+\u001a:wKJ\u001cF/\u0019:ukB$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!\taH\u0001\u001ai\u0016\u001cHO\u0011:pW\u0016\u00148I]3bi\u0016\u001c(lS\"ie>|G/F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011)f.\u001b;\t\u000b\u001d\u0002A\u0011A\u0010\u0002=Q,7\u000f^\"p]\u001ad\u0017n\u0019;Ce>\\WM\u001d*fO&\u001cHO]1uS>t\u0007")
public class ServerStartupTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testBrokerCreatesZKChroot() {
        int brokerId = 0;
        String zookeeperChroot = "/kafka-chroot-for-unittest";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, TestUtils$.MODULE$.choosePort(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        Object zooKeeperConnect = props.get("zookeeper.connect");
        props.put("zookeeper.connect", StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(zooKeeperConnect), zookeeperChroot));
        KafkaServer server = TestUtils$.MODULE$.createServer(new KafkaConfig(props), TestUtils$.MODULE$.createServer$default$2());
        boolean pathExists = ZkUtils$.MODULE$.pathExists(this.zkClient(), zookeeperChroot);
        Assert.assertTrue((boolean)pathExists);
        server.shutdown();
        Utils$.MODULE$.rm(server.config().logDirs());
    }

    public void testConflictBrokerRegistration() {
        int brokerId = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId, TestUtils$.MODULE$.createBrokerConfig$default$2(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        KafkaServer server1 = TestUtils$.MODULE$.createServer(new KafkaConfig(props1), TestUtils$.MODULE$.createServer$default$2());
        String brokerRegistration = (String)ZkUtils$.MODULE$.readData(this.zkClient(), new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString())._1();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId, TestUtils$.MODULE$.createBrokerConfig$default$2(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        try {
            TestUtils$.MODULE$.createServer(new KafkaConfig(props2), TestUtils$.MODULE$.createServer$default$2());
            throw this.fail("Registering a broker with a conflicting id should fail");
        }
        catch (RuntimeException runtimeException) {
            Assert.assertEquals((String)brokerRegistration, (String)((String)ZkUtils$.MODULE$.readData(this.zkClient(), new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString())._1()));
            server1.shutdown();
            Utils$.MODULE$.rm(server1.config().logDirs());
            return;
        }
    }

    public ServerStartupTest() {
        ZooKeeperTestHarness$class.$init$(this);
    }
}

