/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.utils.Json$;
import kafka.utils.ReplicationUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u000f\t!\"+\u001a9mS\u000e\fG/[8o+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\f\u0015Vs\u0017\u000e^\u001aTk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005\u0011!p[\u0005\u0003/Q\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\tQ\u0001^8qS\u000e,\u0012\u0001\t\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019\u0019FO]5oO\"1\u0011\u0006\u0001Q\u0001\n\u0001\na\u0001^8qS\u000e\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\fa\u0006\u0014H/\u001b;j_:LE-F\u0001.!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\rIe\u000e\u001e\u0005\u0007i\u0001\u0001\u000b\u0011B\u0017\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u000fY\u0002!\u0019!C\u0001Y\u0005A!M]8lKJLE\r\u0003\u00049\u0001\u0001\u0006I!L\u0001\nEJ|7.\u001a:JI\u0002BqA\u000f\u0001C\u0002\u0013\u0005A&A\u0006mK\u0006$WM]#q_\u000eD\u0007B\u0002\u001f\u0001A\u0003%Q&\u0001\u0007mK\u0006$WM]#q_\u000eD\u0007\u0005C\u0004?\u0001\t\u0007I\u0011\u0001\u0017\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"Da\u0001\u0011\u0001!\u0002\u0013i\u0013\u0001E2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0011\u001d\u0011\u0005A1A\u0005\u00021\n\u0011B_6WKJ\u001c\u0018n\u001c8\t\r\u0011\u0003\u0001\u0015!\u0003.\u0003)Q8NV3sg&|g\u000e\t\u0005\b\r\u0002\u0011\r\u0011\"\u0001 \u0003%!x\u000e]5d!\u0006$\b\u000e\u0003\u0004I\u0001\u0001\u0006I\u0001I\u0001\u000bi>\u0004\u0018n\u0019)bi\"\u0004\u0003b\u0002&\u0001\u0005\u0004%\taS\u0001\ni>\u0004\u0018n\u0019#bi\u0006,\u0012\u0001\u0014\t\u0003\u001bBs!A\f(\n\u0005={\u0013A\u0002)sK\u0012,g-\u0003\u0002(#*\u0011qj\f\u0005\u0007'\u0002\u0001\u000b\u0011\u0002'\u0002\u0015Q|\u0007/[2ECR\f\u0007\u0005C\u0004V\u0001\t\u0007I\u0011A&\u00021Q|\u0007/[2ECR\fg+\u001a:tS>tW*[:nCR\u001c\u0007\u000e\u0003\u0004X\u0001\u0001\u0006I\u0001T\u0001\u001ai>\u0004\u0018n\u0019#bi\u00064VM]:j_:l\u0015n]7bi\u000eD\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011A&\u0002#Q|\u0007/[2ECR\fW*[:nCR\u001c\u0007\u000e\u0003\u0004\\\u0001\u0001\u0006I\u0001T\u0001\u0013i>\u0004\u0018n\u0019#bi\u0006l\u0015n]7bi\u000eD\u0007\u0005C\u0003^\u0001\u0011\u0005c,A\u0003tKR,\u0006\u000fF\u0001`!\tq\u0003-\u0003\u0002b_\t!QK\\5u\u0011\u0015\u0019\u0007\u0001\"\u0001_\u0003Y!Xm\u001d;Va\u0012\fG/\u001a'fC\u0012,'/\u00118e\u0013N\u0014\bF\u00012f!\t1\u0007.D\u0001h\u0015\tYa\"\u0003\u0002jO\n!A+Z:u\u0001")
public class ReplicationUtilsTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final String topic;
    private final int partitionId;
    private final int brokerId;
    private final int leaderEpoch;
    private final int controllerEpoch;
    private final int zkVersion;
    private final String topicPath;
    private final String topicData;
    private final String topicDataVersionMismatch;
    private final String topicDataMismatch;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public String topicPath() {
        return this.topicPath;
    }

    public String topicData() {
        return this.topicData;
    }

    public String topicDataVersionMismatch() {
        return this.topicDataVersionMismatch;
    }

    public String topicDataMismatch() {
        return this.topicDataMismatch;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        ZkUtils$.MODULE$.createPersistentPath(this.zkClient(), this.topicPath(), this.topicData());
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        List configs = (List)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.createBrokerConfigs$default$2()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties x$1) {
                return new KafkaConfig(x$1);
            }
        }, List$.MODULE$.canBuildFrom());
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log);
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(new TopicAndPartition(this.topic(), this.partitionId()))).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.config()).andReturn(configs.head());
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager);
        EasyMock.expect((Object)replicaManager.replicaFetcherManager()).andReturn(EasyMock.createMock(ReplicaFetcherManager.class));
        EasyMock.expect((Object)replicaManager.zkClient()).andReturn((Object)this.zkClient());
        EasyMock.replay((Object[])new Object[]{replicaManager});
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        LeaderAndIsr newLeaderAndIsr1 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch(), replicas, 0);
        Tuple2 tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), "my-topic-test", this.partitionId(), newLeaderAndIsr1, this.controllerEpoch(), 0);
        if (tuple2 != null) {
            Tuple2.mcZI.sp sp2;
            boolean updateSucceeded1 = tuple2._1$mcZ$sp();
            int newZkVersion1 = tuple2._2$mcI$sp();
            Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(updateSucceeded1, newZkVersion1);
            boolean updateSucceeded12 = sp3._1$mcZ$sp();
            int newZkVersion12 = sp3._2$mcI$sp();
            Assert.assertTrue((boolean)updateSucceeded12);
            Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)newZkVersion12), (Object)BoxesRunTime.boxToInteger((int)1));
            LeaderAndIsr newLeaderAndIsr2 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch(), replicas, this.zkVersion() + 1);
            Tuple2 tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), "my-topic-test", this.partitionId(), newLeaderAndIsr2, this.controllerEpoch(), this.zkVersion() + 1);
            if (tuple22 != null) {
                Tuple2.mcZI.sp sp4;
                boolean updateSucceeded2 = tuple22._1$mcZ$sp();
                int newZkVersion2 = tuple22._2$mcI$sp();
                Tuple2.mcZI.sp sp5 = sp4 = new Tuple2.mcZI.sp(updateSucceeded2, newZkVersion2);
                boolean updateSucceeded22 = sp5._1$mcZ$sp();
                int newZkVersion22 = sp5._2$mcI$sp();
                Assert.assertTrue((boolean)updateSucceeded22);
                Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)newZkVersion22), (Object)BoxesRunTime.boxToInteger((int)1));
                LeaderAndIsr newLeaderAndIsr3 = new LeaderAndIsr(this.brokerId(), this.leaderEpoch() + 1, replicas, this.zkVersion() + 1);
                Tuple2 tuple23 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), "my-topic-test", this.partitionId(), newLeaderAndIsr3, this.controllerEpoch(), this.zkVersion() + 1);
                if (tuple23 != null) {
                    Tuple2.mcZI.sp sp6;
                    boolean updateSucceeded3 = tuple23._1$mcZ$sp();
                    int newZkVersion3 = tuple23._2$mcI$sp();
                    Tuple2.mcZI.sp sp7 = sp6 = new Tuple2.mcZI.sp(updateSucceeded3, newZkVersion3);
                    boolean updateSucceeded32 = sp7._1$mcZ$sp();
                    int newZkVersion32 = sp7._2$mcI$sp();
                    Assert.assertFalse((boolean)updateSucceeded32);
                    Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)newZkVersion32), (Object)BoxesRunTime.boxToInteger((int)-1));
                    return;
                }
                throw new MatchError((Object)tuple23);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    public ReplicationUtilsTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.topic = "my-topic-test";
        this.partitionId = 0;
        this.brokerId = 1;
        this.leaderEpoch = 1;
        this.controllerEpoch = 1;
        this.zkVersion = 1;
        this.topicPath = "/brokers/topics/my-topic-test/partitions/0/state";
        this.topicData = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
        this.topicDataVersionMismatch = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
        this.topicDataMismatch = Json$.MODULE$.encode((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"isr"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})));
    }
}

