/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001 !\t\u0001\u0013%D\u0001\u0003\u0013\t\u0011#AA\u0005QCJ$\u0018\u000e^5p]\"AA\u0005\u0001B\u0001B\u0003%q$\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0005i&lW\r\u0005\u0002\u0010Q%\u0011\u0011\u0006\u0005\u0002\u0005)&lW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003eIg.\u001b;jC2D\u0015n\u001a5XCR,'/\\1sWZ\u000bG.^3\u0011\u0005%i\u0013B\u0001\u0018\u000b\u0005\u0011auN\\4\t\u0011A\u0002!Q1A\u0005\u0002E\n1\u0001\\8h+\u0005\u0011\u0004cA\u00054k%\u0011AG\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YBT\"A\u001c\u000b\u0005A\"\u0011BA\u001d8\u0005\raun\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005e\u0005!An\\4!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q1q\bQ!C\u0007\u0012\u0003\"\u0001\t\u0001\t\u000bUa\u0004\u0019A\f\t\u000bua\u0004\u0019A\u0010\t\u000f\u0019b\u0004\u0013!a\u0001O!91\u0006\u0010I\u0001\u0002\u0004a\u0003b\u0002\u0019=!\u0003\u0005\rA\r\u0005\u0007\r\u0002\u0001\u000b\u0015B$\u0002+!Lw\r[,bi\u0016\u0014X.\u0019:l\u001b\u0016$\u0018\rZ1uCB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nB\u0001\u0007g\u0016\u0014h/\u001a:\n\u00051K%!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"\u0012QI\u0014\t\u0003\u0013=K!\u0001\u0015\u0006\u0003\u0011Y|G.\u0019;jY\u0016DaA\u0015\u0001!B\u00139\u0015\u0001\u00067pO\u0016sGm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\r\u000b\u0002R\u001d\"1Q\u000b\u0001Q\u0001\nY\u000bQ\u0004\\8h\u000b:$wJ\u001a4tKR,\u0006\u000fZ1uKRKW.Z't-\u0006dW/\u001a\t\u0003/\u0002l\u0011\u0001\u0017\u0006\u00033j\u000ba!\u0019;p[&\u001c'BA.]\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003;z\u000bA!\u001e;jY*\tq,\u0001\u0003kCZ\f\u0017BA1Y\u0005)\tEo\\7jG2{gn\u001a\u0005\bG\u0002\u0011\r\u0011\"\u0001e\u0003\u0015!x\u000e]5d+\u0005)\u0007C\u00014j\u001d\tIq-\u0003\u0002i\u0015\u00051\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tA'\u0002\u0003\u0004n\u0001\u0001\u0006I!Z\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f=\u0004!\u0019!C\u0001-\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u0019\t\b\u0001)A\u0005/\u0005a\u0001/\u0019:uSRLwN\\%eA!)1\u000f\u0001C\u0001i\u00069\u0011n\u001d'pG\u0006dW#A;\u0011\u0005%1\u0018BA<\u000b\u0005\u001d\u0011un\u001c7fC:DQ!\u001f\u0001\u0005\u0002i\f\u0001\u0003\\8h\u000b:$wJ\u001a4tKR|F%Z9\u0015\u0005mt\bCA\u0005}\u0013\ti(B\u0001\u0003V]&$\b\"B@y\u0001\u00049\u0015a\u00048fo2{w-\u00128e\u001f\u001a47/\u001a;\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005aAn\\4F]\u0012|eMZ:fiV\tq\tC\u0004\u0002\n\u0001!\t!a\u0003\u000211|w-\u00128e\u001f\u001a47/\u001a;Va\u0012\fG/\u001a+j[\u0016l5/F\u0001-\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\t\u0011\u0003[5hQ^\u000bG/\u001a:nCJ\\w\fJ3r)\rY\u00181\u0003\u0005\b\u0003+\ti\u00011\u0001H\u0003AqWm\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eC\u0004\u0002\u001a\u0001!\t!!\u0002\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\tadY8om\u0016\u0014H\u000fS,U_2{7-\u00197PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0015\u0003mDq!a\t\u0001\t\u0003\n)#\u0001\u0004fcV\fGn\u001d\u000b\u0004k\u0006\u001d\u0002\u0002CA\u0015\u0003C\u0001\r!a\u000b\u0002\tQD\u0017\r\u001e\t\u0004\u0013\u00055\u0012bAA\u0018\u0015\t\u0019\u0011I\\=\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005A\u0001.Y:i\u0007>$W\rF\u0001\u0018\u0011\u001d\tI\u0004\u0001C!\u0003w\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002K\u001eI\u0011q\b\u0002\u0002\u0002#\u0005\u0011\u0011I\u0001\b%\u0016\u0004H.[2b!\r\u0001\u00131\t\u0004\t\u0003\t\t\t\u0011#\u0001\u0002FM\u0019\u00111\t\u0005\t\u000fu\n\u0019\u0005\"\u0001\u0002JQ\u0011\u0011\u0011\t\u0005\u000b\u0003\u001b\n\u0019%%A\u0005\u0002\u0005=\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002R)\u001aq%a\u0015,\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0018\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\nIFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a\u001a\u0002DE\u0005I\u0011AA5\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u000e\u0016\u0004Y\u0005M\u0003BCA8\u0003\u0007\n\n\u0011\"\u0001\u0002r\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!a\u001d+\u0007I\n\u0019\u0006")
public class Replica
implements Logging {
    private final int brokerId;
    private final Partition partition;
    private final Time time;
    private final Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    public volatile LogOffsetMetadata kafka$cluster$Replica$$logEndOffsetMetadata;
    private final AtomicLong logEndOffsetUpdateTimeMsValue;
    private final String topic;
    private final int partitionId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean isLocal() {
        Option<Log> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.log();
                    if (!(option instanceof Some)) break block2;
                    bl = true;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not set log end offset on partition [%s,%d]'s local replica %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.kafka$cluster$Replica$$logEndOffsetMetadata = newLogEndOffset;
        this.logEndOffsetUpdateTimeMsValue.set(this.time.milliseconds());
        this.trace((Function0<String>)new Serializable(this){
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Setting log end offset for replica %d for partition [%s,%d] to [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), this.$outer.kafka$cluster$Replica$$logEndOffsetMetadata}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.kafka$cluster$Replica$$logEndOffsetMetadata;
    }

    public long logEndOffsetUpdateTimeMs() {
        return this.logEndOffsetUpdateTimeMsValue.get();
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (this.isLocal()) {
            this.highWatermarkMetadata = newHighWatermark;
            this.trace((Function0<String>)new Serializable(this, newHighWatermark){
                private final /* synthetic */ Replica $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Setting high watermark for replica %d partition [%s,%d] on broker %d to [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = newHighWatermark$1;
                }
            });
            return;
        }
        throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not set high watermark on partition [%s,%d]'s non-local replica %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public void convertHWToLocalOffsetMetadata() {
        if (this.isLocal()) {
            this.highWatermarkMetadata = ((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset());
            return;
        }
        throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not construct complete high watermark on partition [%s,%d]'s non-local replica %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.brokerId())})));
    }

    public boolean equals(Object that) {
        if (that instanceof Replica) {
            Replica other = (Replica)that;
            return this.topic().equals(other.topic()) && this.brokerId() == other.brokerId() && this.partition().equals(other.partition());
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.brokerId() + this.partition().hashCode();
    }

    public String toString() {
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"ReplicaId: ").append((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; Topic: ").append((Object)this.topic()).toString());
        replicaString.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partition().partitionId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; isLocal: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isLocal())).toString());
        Object object = this.isLocal() ? replicaString.append(new StringBuilder().append((Object)"; Highwatermark: ").append((Object)this.highWatermark()).toString()) : BoxedUnit.UNIT;
        return replicaString.toString();
    }

    public Replica(int brokerId, Partition partition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.partition = partition;
        this.time = time;
        this.log = log;
        Logging$class.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.kafka$cluster$Replica$$logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this.logEndOffsetUpdateTimeMsValue = new AtomicLong(time.milliseconds());
        this.topic = partition.topic();
        this.partitionId = partition.partitionId();
    }
}

