/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.KafkaException;
import kafka.common.MessageSizeTooLargeException;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.ConsumerTopicStats;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.message.MessageAndMetadata;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cQ8ogVlWM]%uKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t/\u0011\u001a2\u0001A\u0005'!\rQQbD\u0007\u0002\u0017)\u0011A\u0002B\u0001\u0006kRLGn]\u0005\u0003\u001d-\u0011\u0001#\u0013;fe\u0006$xN\u001d+f[Bd\u0017\r^3\u0011\tA\u0019RcI\u0007\u0002#)\u0011!\u0003B\u0001\b[\u0016\u001c8/Y4f\u0013\t!\u0012C\u0001\nNKN\u001c\u0018mZ3B]\u0012lU\r^1eCR\f\u0007C\u0001\f\u0018\u0019\u0001!Q\u0001\u0007\u0001C\u0002e\u0011\u0011aS\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\u0004\u0003:L\bC\u0001\f%\t\u0015)\u0003A1\u0001\u001a\u0005\u00051\u0006C\u0001\u0006(\u0013\tA3BA\u0004M_\u001e<\u0017N\\4\t\u0011)\u0002!Q1A\u0005\n-\nqa\u00195b]:,G.F\u0001-!\riCGN\u0007\u0002])\u0011q\u0006M\u0001\u000bG>t7-\u001e:sK:$(BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011QG\f\u0002\u000e\u00052|7m[5oOF+X-^3\u0011\u0005]BT\"\u0001\u0002\n\u0005e\u0012!\u0001\u0005$fi\u000eDW\r\u001a#bi\u0006\u001c\u0005.\u001e8l\u0011!Y\u0004A!A!\u0002\u0013a\u0013\u0001C2iC:tW\r\u001c\u0011\t\u0011u\u0002!\u0011!Q\u0001\ny\n\u0011cY8ogVlWM\u001d+j[\u0016|W\u000f^'t!\tYr(\u0003\u0002A9\t\u0019\u0011J\u001c;\t\u0011\t\u0003!Q1A\u0005\n\r\u000b!b[3z\t\u0016\u001cw\u000eZ3s+\u0005!\u0005cA#I+5\taI\u0003\u0002H\t\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005%3%a\u0002#fG>$WM\u001d\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\t\u0006Y1.Z=EK\u000e|G-\u001a:!\u0011!i\u0005A!b\u0001\n\u0013q\u0015\u0001\u0004<bYV,G)Z2pI\u0016\u0014X#A(\u0011\u0007\u0015C5\u0005\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003P\u000351\u0018\r\\;f\t\u0016\u001cw\u000eZ3sA!A1\u000b\u0001BC\u0002\u0013\u0005A+\u0001\u0005dY&,g\u000e^%e+\u0005)\u0006C\u0001,Z\u001d\tYr+\u0003\u0002Y9\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAF\u0004\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003V\u0003%\u0019G.[3oi&#\u0007\u0005C\u0003`\u0001\u0011\u0005\u0001-\u0001\u0004=S:LGO\u0010\u000b\u0007C\n\u001cG-\u001a4\u0011\t]\u0002Qc\t\u0005\u0006Uy\u0003\r\u0001\f\u0005\u0006{y\u0003\rA\u0010\u0005\u0006\u0005z\u0003\r\u0001\u0012\u0005\u0006\u001bz\u0003\ra\u0014\u0005\u0006'z\u0003\r!\u0016\u0005\bQ\u0002\u0001\r\u0011\"\u0003j\u0003\u001d\u0019WO\u001d:f]R,\u0012A\u001b\t\u0004W:\u0004X\"\u00017\u000b\u00055t\u0013AB1u_6L7-\u0003\u0002pY\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0002rsrt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005U4\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tAH$A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(\u0001C%uKJ\fGo\u001c:\u000b\u0005ad\u0002C\u0001\t~\u0013\tq\u0018C\u0001\tNKN\u001c\u0018mZ3B]\u0012|eMZ:fi\"I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111A\u0001\fGV\u0014(/\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005-\u0001cA\u000e\u0002\b%\u0019\u0011\u0011\u0002\u000f\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001by\u0018\u0011!a\u0001U\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005E\u0001\u0001)Q\u0005U\u0006A1-\u001e:sK:$\b\u0005C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018\u0005\u00012-\u001e:sK:$Hk\u001c9jG&sgm\\\u000b\u0003\u00033\u00012aNA\u000e\u0013\r\tiB\u0001\u0002\u0013!\u0006\u0014H/\u001b;j_:$v\u000e]5d\u0013:4w\u000eC\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$\u0005!2-\u001e:sK:$Hk\u001c9jG&sgm\\0%KF$B!!\u0002\u0002&!Q\u0011QBA\u0010\u0003\u0003\u0005\r!!\u0007\t\u0011\u0005%\u0002\u0001)Q\u0005\u00033\t\u0011cY;se\u0016tG\u000fV8qS\u000eLeNZ8!\u0011%\ti\u0003\u0001a\u0001\n\u0013\ty#\u0001\bd_:\u001cX/\\3e\u001f\u001a47/\u001a;\u0016\u0005\u0005E\u0002cA\u000e\u00024%\u0019\u0011Q\u0007\u000f\u0003\t1{gn\u001a\u0005\n\u0003s\u0001\u0001\u0019!C\u0005\u0003w\t!cY8ogVlW\rZ(gMN,Go\u0018\u0013fcR!\u0011QAA\u001f\u0011)\ti!a\u000e\u0002\u0002\u0003\u0007\u0011\u0011\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015)\u0003\u00022\u0005y1m\u001c8tk6,Gm\u00144gg\u0016$\b\u0005C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002H\u0005\u00112m\u001c8tk6,'\u000fV8qS\u000e\u001cF/\u0019;t+\t\tI\u0005E\u00028\u0003\u0017J1!!\u0014\u0003\u0005I\u0019uN\\:v[\u0016\u0014Hk\u001c9jGN#\u0018\r^:\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0013\n1cY8ogVlWM\u001d+pa&\u001c7\u000b^1ug\u0002Bq!!\u0016\u0001\t\u0003\n9&\u0001\u0003oKb$H#A\b\t\u000f\u0005m\u0003\u0001\"\u0005\u0002X\u0005AQ.Y6f\u001d\u0016DH\u000fC\u0004\u0002`\u0001!\t!!\u0019\u0002#\rdW-\u0019:DkJ\u0014XM\u001c;DQVt7\u000e\u0006\u0002\u0002\u0006\u0001")
public class ConsumerIterator<K, V>
extends IteratorTemplate<MessageAndMetadata<K, V>>
implements Logging {
    private final BlockingQueue<FetchedDataChunk> channel;
    private final int consumerTimeoutMs;
    private final Decoder<K> keyDecoder;
    private final Decoder<V> valueDecoder;
    private final String clientId;
    private AtomicReference<Iterator<MessageAndOffset>> current;
    private PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo;
    private long kafka$consumer$ConsumerIterator$$consumedOffset;
    private final ConsumerTopicStats consumerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsumerIterator consumerIterator = this;
        synchronized (consumerIterator) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private BlockingQueue<FetchedDataChunk> channel() {
        return this.channel;
    }

    private Decoder<K> keyDecoder() {
        return this.keyDecoder;
    }

    private Decoder<V> valueDecoder() {
        return this.valueDecoder;
    }

    public String clientId() {
        return this.clientId;
    }

    private AtomicReference<Iterator<MessageAndOffset>> current() {
        return this.current;
    }

    private void current_$eq(AtomicReference<Iterator<MessageAndOffset>> x$1) {
        this.current = x$1;
    }

    public PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo() {
        return this.kafka$consumer$ConsumerIterator$$currentTopicInfo;
    }

    private void kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(PartitionTopicInfo x$1) {
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = x$1;
    }

    public long kafka$consumer$ConsumerIterator$$consumedOffset() {
        return this.kafka$consumer$ConsumerIterator$$consumedOffset;
    }

    private void kafka$consumer$ConsumerIterator$$consumedOffset_$eq(long x$1) {
        this.kafka$consumer$ConsumerIterator$$consumedOffset = x$1;
    }

    private ConsumerTopicStats consumerTopicStats() {
        return this.consumerTopicStats;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MessageAndMetadata<K, V> next() {
        void var1_1;
        MessageAndMetadata item = (MessageAndMetadata)super.next();
        if (this.kafka$consumer$ConsumerIterator$$consumedOffset() < 0L) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Offset returned by the message set is invalid %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.kafka$consumer$ConsumerIterator$$consumedOffset())})));
        }
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(this.kafka$consumer$ConsumerIterator$$consumedOffset());
        String topic = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic();
        this.trace((Function0<String>)new Serializable(this, topic){
            private final /* synthetic */ ConsumerIterator $outer;
            private final String topic$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Setting %s consumed offset to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToLong((long)this.$outer.kafka$consumer$ConsumerIterator$$consumedOffset())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
        this.consumerTopicStats().getConsumerTopicStats(topic).messageRate().mark();
        this.consumerTopicStats().getConsumerAllTopicStats().messageRate().mark();
        return var1_1;
    }

    @Override
    public MessageAndMetadata<K, V> makeNext() {
        FetchedDataChunk currentDataChunk = null;
        Iterator<MessageAndOffset> localCurrent = this.current().get();
        if (localCurrent == null || !localCurrent.hasNext()) {
            if (this.consumerTimeoutMs < 0) {
                currentDataChunk = this.channel().take();
            } else {
                currentDataChunk = this.channel().poll(this.consumerTimeoutMs, TimeUnit.MILLISECONDS);
                if (currentDataChunk == null) {
                    this.resetState();
                    throw new ConsumerTimeoutException();
                }
            }
            if (currentDataChunk == ZookeeperConsumerConnector$.MODULE$.shutdownCommand()) {
                this.debug((Function0<String>)new Serializable(this){

                    public final String apply() {
                        return "Received the shutdown command";
                    }
                });
                this.channel().offer(currentDataChunk);
                return (MessageAndMetadata)this.allDone();
            }
            this.kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(currentDataChunk.topicInfo());
            long cdcFetchOffset = currentDataChunk.fetchOffset();
            long ctiConsumeOffset = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset();
            if (ctiConsumeOffset < cdcFetchOffset) {
                this.error((Function0<String>)new Serializable(this, cdcFetchOffset, ctiConsumeOffset){
                    private final /* synthetic */ ConsumerIterator $outer;
                    private final long cdcFetchOffset$1;
                    private final long ctiConsumeOffset$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("consumed offset: %d doesn't match fetch offset: %d for %s;\n Consumer may lose data")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.ctiConsumeOffset$1), BoxesRunTime.boxToLong((long)this.cdcFetchOffset$1), this.$outer.kafka$consumer$ConsumerIterator$$currentTopicInfo()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.cdcFetchOffset$1 = cdcFetchOffset$1;
                        this.ctiConsumeOffset$1 = ctiConsumeOffset$1;
                    }
                });
                this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(cdcFetchOffset);
            }
            localCurrent = currentDataChunk.messages().iterator();
            this.current().set(localCurrent);
            if (currentDataChunk.messages().validBytes() == 0) {
                throw new MessageSizeTooLargeException(new StringBuilder().append((Object)"Found a message larger than the maximum fetch size of this consumer on topic ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%s partition %d at fetch offset %d. Increase the fetch size, or decrease the maximum message size the broker will allow.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentDataChunk.topicInfo().topic(), BoxesRunTime.boxToInteger((int)currentDataChunk.topicInfo().partitionId()), BoxesRunTime.boxToLong((long)currentDataChunk.fetchOffset())}))).toString());
            }
        }
        MessageAndOffset item = (MessageAndOffset)localCurrent.next();
        while (item.offset() < this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset() && localCurrent.hasNext()) {
            item = (MessageAndOffset)localCurrent.next();
        }
        this.kafka$consumer$ConsumerIterator$$consumedOffset_$eq(item.nextOffset());
        item.message().ensureValid();
        return new MessageAndMetadata<K, V>(this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic(), this.kafka$consumer$ConsumerIterator$$currentTopicInfo().partitionId(), item.message(), item.offset(), this.keyDecoder(), this.valueDecoder());
    }

    public void clearCurrentChunk() {
        this.debug((Function0<String>)new Serializable(this){

            public final String apply() {
                return "Clearing the current data chunk for this consumer iterator";
            }
        });
        this.current().set(null);
    }

    public ConsumerIterator(BlockingQueue<FetchedDataChunk> channel, int consumerTimeoutMs, Decoder<K> keyDecoder, Decoder<V> valueDecoder, String clientId) {
        this.channel = channel;
        this.consumerTimeoutMs = consumerTimeoutMs;
        this.keyDecoder = keyDecoder;
        this.valueDecoder = valueDecoder;
        this.clientId = clientId;
        Logging$class.$init$(this);
        this.current = new AtomicReference<Object>(null);
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = null;
        this.kafka$consumer$ConsumerIterator$$consumedOffset = -1L;
        this.consumerTopicStats = ConsumerTopicStatsRegistry$.MODULE$.getConsumerTopicStat(clientId);
    }
}

