/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019\u0019wN\u001c4jOV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!!\u0003A!b\u0001\n\u0003)\u0013a\u00027pO\u0012K'o]\u000b\u0002MA\u0019\u0011bJ\u0015\n\u0005!R!!B!se\u0006L\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\tIwNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#\u0001\u0002$jY\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\tY><G)\u001b:tA!AA\u0007\u0001BC\u0002\u0013\u0005Q'\u0001\u0003m_\u001e\u001cX#\u0001\u001c\u0011\t=9\u0014hP\u0005\u0003qA\u0011A\u0001U8pYB\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007G>lWn\u001c8\n\u0005yZ$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011a\u0004Q\u0005\u0003\u0003\n\u00111\u0001T8h\u0011!\u0019\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\tQLW.\u001a\t\u0003\u001f\u001dK!\u0001\u0013\t\u0003\tQKW.\u001a\u0005\u0006\u0015\u0002!\taS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1kej\u0014)\u0011\u0005y\u0001\u0001\"B\u000eJ\u0001\u0004i\u0002\"\u0002\u0013J\u0001\u00041\u0003\"\u0002\u001bJ\u0001\u00041\u0004bB#J!\u0003\u0005\rA\u0012\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u00039\u0019G.Z1oKJl\u0015M\\1hKJ,\u0012\u0001\u0016\t\u0003=UK!A\u0016\u0002\u0003#1{wm\u00117fC:,'/T1oC\u001e,'\u000f\u0003\u0004Y\u0001\u0001\u0006I\u0001V\u0001\u0010G2,\u0017M\\3s\u001b\u0006t\u0017mZ3sA!9!\f\u0001b\u0001\n\u0013Y\u0016!\u0003;ie>$H\u000f\\3s+\u0005a\u0006CA\b^\u0013\tq\u0006CA\u0005UQJ|G\u000f\u001e7fe\"1\u0001\r\u0001Q\u0001\nq\u000b!\u0002\u001e5s_R$H.\u001a:!\u0011\u001d\u0011\u0007A1A\u0005\n\r\f\u0001b\u00197fC:,'o]\u000b\u0002IB\u0019QM\u001b7\u000e\u0003\u0019T!a\u001a5\u0002\u0013%lW.\u001e;bE2,'BA5\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\u001a\u0014!\"\u00138eKb,GmU3r!\tig.D\u0001\u0001\r\u0011y\u0007\u0001\u00029\u0003\u001b\rcW-\u00198feRC'/Z1e'\tq\u0017\u000f\u0005\u0002\u0010e&\u00111\u000f\u0005\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0003\u0005v]\n\u0005\t\u0015!\u0003w\u0003!!\bN]3bI&#\u0007CA\u0005x\u0013\tA(BA\u0002J]RDQA\u00138\u0005\u0002i$\"\u0001\\>\t\u000bUL\b\u0019\u0001<\t\u000fut'\u0019!C!}\u0006QAn\\4hKJt\u0015-\\3\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bi\u0013\u0001\u00027b]\u001eLA!!\u0003\u0002\u0004\t11\u000b\u001e:j]\u001eDq!!\u0004oA\u0003%q0A\u0006m_\u001e<WM\u001d(b[\u0016\u0004\u0003\"CA\t]\n\u0007I\u0011AA\n\u0003\u001d\u0019G.Z1oKJ,\"!!\u0006\u0011\u0007y\t9\"C\u0002\u0002\u001a\t\u0011qa\u00117fC:,'\u000f\u0003\u0005\u0002\u001e9\u0004\u000b\u0011BA\u000b\u0003!\u0019G.Z1oKJ\u0004\u0003\"CA\u0011]\u0002\u0007I\u0011AA\u0012\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u0002&A\u0019a$a\n\n\u0007\u0005%\"A\u0001\u0007DY\u0016\fg.\u001a:Ti\u0006$8\u000fC\u0005\u0002.9\u0004\r\u0011\"\u0001\u00020\u0005iA.Y:u'R\fGo]0%KF$B!!\r\u00028A\u0019\u0011\"a\r\n\u0007\u0005U\"B\u0001\u0003V]&$\bBCA\u001d\u0003W\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005ub\u000e)Q\u0005\u0003K\t!\u0002\\1tiN#\u0018\r^:!Q\u0011\tY$!\u0011\u0011\u0007%\t\u0019%C\u0002\u0002F)\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003\u0013r'\u0019!C\u0005\u0003\u0017\n\u0001CY1dW>3gmV1ji2\u000bGo\u00195\u0016\u0005\u00055\u0003\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u000bG>t7-\u001e:sK:$(bAA,[\u0005!Q\u000f^5m\u0013\u0011\tY&!\u0015\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\"A\u0011q\f8!\u0002\u0013\ti%A\tcC\u000e\\wJ\u001a4XC&$H*\u0019;dQ\u0002Bq!a\u0019o\t\u0013\t)'A\u0005dQ\u0016\u001c7\u000eR8oKR!\u0011\u0011GA4\u0011\u001d\tI'!\u0019A\u0002e\n\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\tiG\u001cC!\u0003_\na\u0001Z8X_J\\GCAA\u0019\u0011\u001d\t\u0019H\u001cC!\u0003_\n\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0003orG\u0011BA8\u00031\u0019G.Z1o\u001fJ\u001cF.Z3q\u0011\u001d\tYH\u001cC\u0001\u0003{\n1B]3d_J$7\u000b^1ugRa\u0011\u0011GA@\u0003\u0007\u000b\u0019*!(\u0002\"\"9\u0011\u0011QA=\u0001\u00041\u0018AA5e\u0011!\t))!\u001fA\u0002\u0005\u001d\u0015\u0001\u00028b[\u0016\u0004B!!#\u0002\u0010:\u0019\u0011\"a#\n\u0007\u00055%\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\t\tJC\u0002\u0002\u000e*A\u0001\"!&\u0002z\u0001\u0007\u0011qS\u0001\u0005MJ|W\u000eE\u0002\n\u00033K1!a'\u000b\u0005\u0011auN\\4\t\u0011\u0005}\u0015\u0011\u0010a\u0001\u0003/\u000b!\u0001^8\t\u0011\u0005\r\u0016\u0011\u0010a\u0001\u0003K\tQa\u001d;biNDq!a*\u0001A\u0003%A-A\u0005dY\u0016\fg.\u001a:tA!9\u00111\u0016\u0001\u0005\u0002\u0005=\u0014aB:uCJ$X\u000f\u001d\u0005\b\u0003g\u0002A\u0011AA8\u0011\u001d\t\t\f\u0001C\u0001\u0003g\u000bQ\"\u00192peR\u001cE.Z1oS:<G\u0003BA\u0019\u0003kCq!!\u001b\u00020\u0002\u0007\u0011\bC\u0004\u0002:\u0002!\t!a/\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u0011\u0011GA_\u0011\u001d\tI'a.A\u0002eBq!!1\u0001\t\u0003\t\u0019-\u0001\bsKN,X.Z\"mK\u0006t\u0017N\\4\u0015\t\u0005E\u0012Q\u0019\u0005\b\u0003S\ny\f1\u0001:\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017\fA\"Y<bSR\u001cE.Z1oK\u0012$\"\"!\r\u0002N\u0006E\u0017Q[Am\u0011!\ty-a2A\u0002\u0005\u001d\u0015!\u0002;pa&\u001c\u0007bBAj\u0003\u000f\u0004\rA^\u0001\u0005a\u0006\u0014H\u000f\u0003\u0005\u0002X\u0006\u001d\u0007\u0019AAL\u0003\u0019ygMZ:fi\"Q\u00111\\Ad!\u0003\u0005\r!a&\u0002\u000fQLW.Z8vi\"I\u0011q\u001c\u0001\u0012\u0002\u0013\u0005\u0011\u0011]\u0001\u0017C^\f\u0017\u000e^\"mK\u0006tW\r\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u001d\u0016\u0005\u0003/\u000b)o\u000b\u0002\u0002hB!\u0011\u0011^Az\u001b\t\tYO\u0003\u0003\u0002n\u0006=\u0018!C;oG\",7m[3e\u0015\r\t\tPC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA{\u0003W\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f%\tIPAA\u0001\u0012\u0003\tY0\u0001\u0006M_\u001e\u001cE.Z1oKJ\u00042AHA\u007f\r!\t!!!A\t\u0002\u0005}8cAA\u007f\u0011!9!*!@\u0005\u0002\t\rACAA~\u0011)\u00119!!@\u0012\u0002\u0013\u0005!\u0011B\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t-!f\u0001$\u0002f\u0002")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager kafka$log$LogCleaner$$cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public void removeMetric(String name) {
        KafkaMetricsGroup$class.removeMetric(this, name);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public LogCleanerManager kafka$log$LogCleaner$$cleanerManager() {
        return this.kafka$log$LogCleaner$$cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){

            public final void apply(CleanerThread x$9) {
                x$9.start();
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){

            public final void apply(CleanerThread x$10) {
                x$10.shutdown();
            }
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortCleaning(topicAndPartition);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().resumeCleaning(topicAndPartition);
    }

    public void awaitCleaned(String topic, int part, long offset, long timeout) {
        while (!this.kafka$log$LogCleaner$$cleanerManager().allCleanerCheckpoints().contains((Object)new TopicAndPartition(topic, part))) {
            Thread.sleep(10L);
        }
        return;
    }

    public long awaitCleaned$default$4() {
        return 30000L;
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$log$LogCleaner$$cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){

                    public final CleanerStats apply(CleanerThread x$2) {
                        return x$2.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                    public final double apply(CleanerStats x$3) {
                        return (double)100 * x$3.bufferUtilization();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                IndexedSeq stats = (IndexedSeq)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){

                    public final CleanerStats apply(CleanerThread x$4) {
                        return x$4.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){

                    public final long apply(CleanerStats x$5) {
                        return x$5.bytesWritten();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){

                    public final long apply(CleanerStats x$6) {
                        return x$6.bytesRead();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){

                    public final CleanerStats apply(CleanerThread x$7) {
                        return x$7.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                    public final double apply(CleanerStats x$8) {
                        return x$8.elapsedSecs();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private final CountDownLatch backOffWaitLatch;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private CountDownLatch backOffWaitLatch() {
            return this.backOffWaitLatch;
        }

        public void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicAndPartition topicAndPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().checkCleaningAborted(topicAndPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        @Override
        public void doWork() {
            this.cleanOrSleep();
        }

        @Override
        public void shutdown() {
            this.initiateShutdown();
            this.backOffWaitLatch().countDown();
            this.awaitShutdown();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            BoxedUnit boxedUnit;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().grabFilthiestLog();
            if (None$.MODULE$.equals(option)) {
                this.backOffWaitLatch().await(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs(), TimeUnit.MILLISECONDS);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            LogToClean cleanable = (LogToClean)some.x();
            long endOffset = cleanable.firstDirtyOffset();
            try {
                endOffset = this.cleaner().clean(cleanable);
                this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (LogCleaningAbortedException logCleaningAbortedException) {
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            this.cleaner().statsUnderlying().swap();
            String message = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message){
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicAndPartition, BoxedUnit>)new CleanerThread$$anonfun$6(this));
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.backOffWaitLatch = new CountDownLatch(1);
        }
    }
}

