/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.KafkaStorageException;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u000f\r&dW-T3tg\u0006<WmU3u\u0011!Y\u0002A!A!\u0002\u00131\u0012\u0001\u00027pO\u0002B\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0006S:$W\r_\u000b\u0002?A\u0011q\u0003I\u0005\u0003C\t\u00111b\u00144gg\u0016$\u0018J\u001c3fq\"A1\u0005\u0001B\u0001B\u0003%q$\u0001\u0004j]\u0012,\u0007\u0010\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0003\u001d\u0002\"!\u0003\u0015\n\u0005%R!\u0001\u0002'p]\u001eD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IaJ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003IIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:\u0016\u0003=\u0002\"!\u0003\u0019\n\u0005ER!aA%oi\"A1\u0007\u0001B\u0001B\u0003%q&A\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\b\u0005\u0003\u00056\u0001\t\u0015\r\u0011\"\u0001'\u00031\u0011x\u000e\u001c7KSR$XM]'t\u0011!9\u0004A!A!\u0002\u00139\u0013!\u0004:pY2T\u0015\u000e\u001e;fe6\u001b\b\u0005\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0003\u0011!\u0018.\\3\u0011\u0005=Y\u0014B\u0001\u001f\u0011\u0005\u0011!\u0016.\\3\t\u000by\u0002A\u0011A \u0002\rqJg.\u001b;?)\u001d\u0001\u0015IQ\"E\u000b\u001a\u0003\"a\u0006\u0001\t\u000b\ri\u0004\u0019\u0001\f\t\u000bui\u0004\u0019A\u0010\t\u000b\u0015j\u0004\u0019A\u0014\t\u000b5j\u0004\u0019A\u0018\t\u000bUj\u0004\u0019A\u0014\t\u000bej\u0004\u0019\u0001\u001e\t\u000f!\u0003\u0001\u0019!C\u0001M\u000591M]3bi\u0016$\u0007b\u0002&\u0001\u0001\u0004%\taS\u0001\fGJ,\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0002M\u001fB\u0011\u0011\"T\u0005\u0003\u001d*\u0011A!\u00168ji\"9\u0001+SA\u0001\u0002\u00049\u0013a\u0001=%c!1!\u000b\u0001Q!\n\u001d\n\u0001b\u0019:fCR,G\r\t\u0005\b)\u0002\u0001\r\u0011\"\u0003/\u0003a\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/\u001f\u0005\b-\u0002\u0001\r\u0011\"\u0003X\u0003q\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/_0%KF$\"\u0001\u0014-\t\u000fA+\u0016\u0011!a\u0001_!1!\f\u0001Q!\n=\n\u0011DY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:zA!)a\b\u0001C\u00019R9\u0001)X4jU2l\u0007\"\u00020\\\u0001\u0004y\u0016a\u00013jeB\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\u0003S>T\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\n!a)\u001b7f\u0011\u0015A7\f1\u0001(\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000b5Z\u0006\u0019A\u0018\t\u000b-\\\u0006\u0019A\u0018\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\t\u000bUZ\u0006\u0019A\u0014\t\u000beZ\u0006\u0019\u0001\u001e\t\u000b=\u0004A\u0011\u0001\u0014\u0002\tML'0\u001a\u0005\u0006c\u0002!\tA]\u0001\u0007CB\u0004XM\u001c3\u0015\u00071\u001bX\u000fC\u0003ua\u0002\u0007q%\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0006mB\u0004\ra^\u0001\t[\u0016\u001c8/Y4fgB\u0011\u0001p_\u0007\u0002s*\u0011!\u0010B\u0001\b[\u0016\u001c8/Y4f\u0013\ta\u0018P\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0015\u0003az\u0004\"aD@\n\u0007\u0005\u0005\u0001CA\u0007o_:$\bN]3bIN\fg-\u001a\u0005\t\u0003\u000b\u0001A\u0011\u0001\u0002\u0002\b\u0005yAO]1og2\fG/Z(gMN,G\u000f\u0006\u0004\u0002\n\u0005=\u0011\u0011\u0003\t\u0004/\u0005-\u0011bAA\u0007\u0005\tqqJ\u001a4tKR\u0004vn]5uS>t\u0007B\u0002;\u0002\u0004\u0001\u0007q\u0005C\u0005\u0002\u0014\u0005\r\u0001\u0013!a\u0001_\u0005!2\u000f^1si&twMR5mKB{7/\u001b;j_:DC!a\u0001\u0002\u0018A\u0019q\"!\u0007\n\u0007\u0005m\u0001C\u0001\u0006uQJ,\u0017\rZ:bM\u0016Dq!a\b\u0001\t\u0003\t\t#\u0001\u0003sK\u0006$G\u0003CA\u0012\u0003_\t\t$a\u000f\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u0005\u0003\u0019\u0019XM\u001d<fe&!\u0011QFA\u0014\u000551U\r^2i\t\u0006$\u0018-\u00138g_\"1\u0001.!\bA\u0002\u001dB\u0001\"a\r\u0002\u001e\u0001\u0007\u0011QG\u0001\n[\u0006DxJ\u001a4tKR\u0004B!CA\u001cO%\u0019\u0011\u0011\b\u0006\u0003\r=\u0003H/[8o\u0011\u001d\ti$!\bA\u0002=\nq!\\1y'&TX\r\u000b\u0003\u0002\u001e\u0005]\u0001bBA\"\u0001\u0011\u0005\u0011QI\u0001\be\u0016\u001cwN^3s)\ry\u0013q\t\u0005\b\u0003\u0013\n\t\u00051\u00010\u00039i\u0017\r_'fgN\fw-Z*ju\u0016D3!!\u0011\u007f\u0011\u001d\ty\u0005\u0001C!\u0003#\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033\u001a\u0017\u0001\u00027b]\u001eLA!!\u0018\u0002X\t11\u000b\u001e:j]\u001eDq!!\u0019\u0001\t\u0003\t\u0019'\u0001\u0006ueVt7-\u0019;f)>$2aLA3\u0011\u0019!\u0018q\fa\u0001O!\u001a\u0011q\f@\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\u0005Qa.\u001a=u\u001f\u001a47/\u001a;\u0015\u0003\u001dBC!!\u001b\u0002\u0018!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0014!\u00024mkNDG#\u0001')\t\u0005E\u0014q\u0003\u0005\b\u0003w\u0002A\u0011AA?\u0003I\u0019\u0007.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:\u0015\u000b1\u000by(a$\t\u0011\u0005\u0005\u0015\u0011\u0010a\u0001\u0003\u0007\u000b\u0011b\u001c7e'V4g-\u001b=\u0011\t\u0005\u0015\u00151\u0012\b\u0004\u0013\u0005\u001d\u0015bAAE\u0015\u00051\u0001K]3eK\u001aLA!!\u0018\u0002\u000e*\u0019\u0011\u0011\u0012\u0006\t\u0011\u0005E\u0015\u0011\u0010a\u0001\u0003\u0007\u000b\u0011B\\3x'V4g-\u001b=\t\u000f\u0005U\u0005\u0001\"\u0001\u0002v\u0005)1\r\\8tK\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005U\u0014A\u00023fY\u0016$X\r\u0003\u0004\u0002\u001e\u0002!\tAJ\u0001\rY\u0006\u001cH/T8eS\u001aLW\r\u001a\u0005\b\u0003C\u0003A\u0011AAR\u0003Aa\u0017m\u001d;N_\u0012Lg-[3e?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0006-\u0006cA\u0005\u0002(&\u0019\u0011\u0011\u0016\u0006\u0003\u000f\t{w\u000e\\3b]\"9\u0011QVAP\u0001\u00049\u0013AA7t\u0011%\t\t\fAI\u0001\n\u0003\t\u0019,A\rue\u0006t7\u000f\\1uK>3gm]3uI\u0011,g-Y;mi\u0012\u0012TCAA[U\ry\u0013qW\u0016\u0003\u0003s\u0003B!a/\u0002F6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0019\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002H\u0006u&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"\u0012\u0001A ")
public class LogSegment
implements Logging {
    private final FileMessageSet log;
    private final OffsetIndex index;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileMessageSet log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public long created() {
        return this.created;
    }

    public void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public void append(long offset, ByteBufferMessageSet messages) {
        if (messages.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, offset, messages){
                private final /* synthetic */ LogSegment $outer;
                private final long offset$1;
                private final ByteBufferMessageSet messages$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.offset$1 = offset$1;
                    this.messages$1 = messages$1;
                }
            });
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(offset, this.log().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.log().append(messages);
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + messages.sizeInBytes());
        }
    }

    public OffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchFor(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize) {
        Option<Object> option;
        block9: {
            int n;
            LogOffsetMetadata offsetMetadata;
            OffsetPosition startPosition;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
                    }
                    logSize = this.log().sizeInBytes();
                    startPosition = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startPosition == null) {
                        return null;
                    }
                    offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition.position());
                    if (maxSize == 0) {
                        return new FetchDataInfo(offsetMetadata, MessageSet$.MODULE$.Empty());
                    }
                    option = maxOffset;
                    if (!None$.MODULE$.equals(option)) break block7;
                    n = maxSize;
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long offset = BoxesRunTime.unboxToLong((Object)some.x());
                if (offset < startOffset) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToLong((long)startOffset)})));
                }
                OffsetPosition mapping = this.translateOffset(offset, startPosition.position());
                int endPosition = mapping == null ? logSize : mapping.position();
                n = package$.MODULE$.min(endPosition - startPosition.position(), maxSize);
            }
            int length = n;
            return new FetchDataInfo(offsetMetadata, this.log().read(startPosition.position(), length));
        }
        throw new MatchError(option);
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        int validBytes = 0;
        int lastIndexEntry = 0;
        Iterator<MessageAndOffset> iter = this.log().iterator(maxMessageSize);
        try {
            while (iter.hasNext()) {
                MessageAndOffset entry2 = (MessageAndOffset)iter.next();
                entry2.message().ensureValid();
                if (validBytes - lastIndexEntry > this.indexIntervalBytes()) {
                    CompressionCodec compressionCodec = entry2.message().compressionCodec();
                    long l = NoCompressionCodec$.MODULE$.equals(compressionCodec) ? entry2.offset() : ((MessageAndOffset)ByteBufferMessageSet$.MODULE$.decompress(entry2.message()).head()).offset();
                    long startOffset = l;
                    this.index().append(startOffset, validBytes);
                    lastIndexEntry = validBytes;
                }
                validBytes += MessageSet$.MODULE$.entrySize(entry2.message());
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.logger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes), invalidMessageException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes;
        this.log().truncateTo(validBytes);
        this.index().trimToValidSize();
        return truncated;
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset) {
        OffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset);
        this.index().resize(this.index().maxIndexSize());
        int bytesTruncated = this.log().truncateTo(mapping.position());
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time.milliseconds());
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        return bytesTruncated;
    }

    public long nextOffset() {
        Option<MessageAndOffset> option;
        block6: {
            long l;
            block3: {
                long l2;
                block5: {
                    block4: {
                        FetchDataInfo ms;
                        block2: {
                            ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes());
                            if (ms != null) break block2;
                            l = this.baseOffset();
                            break block3;
                        }
                        option = ms.messageSet().lastOption();
                        if (!None$.MODULE$.equals(option)) break block4;
                        l2 = this.baseOffset();
                        break block5;
                    }
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    MessageAndOffset last = (MessageAndOffset)some.x();
                    l2 = last.nextOffset();
                }
                l = l2;
            }
            return l;
        }
        throw new MatchError(option);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.index().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        boolean logRenamed = this.log().renameTo(new File(Utils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        if (logRenamed) {
            boolean indexRenamed = this.index().renameTo(new File(Utils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
            if (indexRenamed) {
                return;
            }
            throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("Failed to change the index file suffix from %s to %s for log segment %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
        }
        throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("Failed to change the log file suffix from %s to %s for log segment %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
    }

    public void close() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        return this.index().file().setLastModified(ms);
    }

    public LogSegment(FileMessageSet log, OffsetIndex index, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.index = index;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, long rollJitterMs, Time time) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(dir, startOffset)), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, rollJitterMs, time);
    }
}

