/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import junit.framework.Assert;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.junit.After;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001\u001d\u00111b\u00117fC:,'\u000fV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\u0004I&\u0014X#\u0001\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012AA5p\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\t\u0019KG.\u001a\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000e\u0002\t\u0011L'\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003%awnZ\"p]\u001aLw-F\u0001(!\t1\u0002&\u0003\u0002*\u0005\tIAj\\4D_:4\u0017n\u001a\u0005\u0007W\u0001\u0001\u000b\u0011B\u0014\u0002\u00151|wmQ8oM&<\u0007\u0005C\u0004.\u0001\t\u0007I\u0011\u0001\u0018\u0002\tQLW.Z\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\u0011!\u0007B\u0001\u0006kRLGn]\u0005\u0003iE\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007m\u0001\u0001\u000b\u0011B\u0018\u0002\u000bQLW.\u001a\u0011\t\u000fa\u0002!\u0019!C\u0001s\u0005IA\u000f\u001b:piRdWM]\u000b\u0002uA\u0011\u0001gO\u0005\u0003yE\u0012\u0011\u0002\u00165s_R$H.\u001a:\t\ry\u0002\u0001\u0015!\u0003;\u0003)!\bN]8ui2,'\u000f\t\u0005\u0006\u0001\u0002!\t!Q\u0001\ti\u0016\f'\u000fZ8x]R\t!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0003V]&$\bFA J!\tQE*D\u0001L\u0015\tYa\"\u0003\u0002N\u0017\n)\u0011I\u001a;fe\")q\n\u0001C\u0001\u0003\u0006\tB/Z:u\u00072,\u0017M\\*fO6,g\u000e^:)\u00059\u000b\u0006C\u0001&S\u0013\t\u00196J\u0001\u0003UKN$\b\"B+\u0001\t\u0003\t\u0015a\u0006;fgR\u001cE.Z1oS:<w+\u001b;i\t\u0016dW\r^3tQ\t!\u0016\u000bC\u0003Y\u0001\u0011\u0005\u0011,A\u0005lKf\u001c\u0018J\u001c'pOR\u0011!l\u0019\t\u00047z\u0003W\"\u0001/\u000b\u0005u#\u0015AC2pY2,7\r^5p]&\u0011q\f\u0018\u0002\t\u0013R,'/\u00192mKB\u00111)Y\u0005\u0003E\u0012\u00131!\u00138u\u0011\u0015\u0019q\u000b1\u0001e!\t1R-\u0003\u0002g\u0005\t\u0019Aj\\4\t\u000b!\u0004A\u0011A5\u0002\u001d\u0005\u0014wN\u001d;DQ\u0016\u001c7\u000eR8oKR\u0011!I\u001b\u0005\u0006W\u001e\u0004\r\u0001\\\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007CA7q\u001b\u0005q'BA8\u0005\u0003\u0019\u0019w.\\7p]&\u0011\u0011O\u001c\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\"B:\u0001\t\u0003\t\u0015A\u0007;fgR\u001cE.Z1o'\u0016<W.\u001a8ug^KG\u000f[!c_J$\bF\u0001:R\u0011\u00151\b\u0001\"\u0001B\u0003M!Xm\u001d;TK\u001elWM\u001c;He>,\b/\u001b8hQ\t)\u0018\u000bC\u0003z\u0001\u0011%!0A\tdQ\u0016\u001c7nU3h[\u0016tGo\u0014:eKJ$\"AQ>\t\u000bqD\b\u0019A?\u0002\r\u001d\u0014x.\u001e9t!\u0011Yf0!\u0001\n\u0005}d&aA*fcB!1L`A\u0002!\r1\u0012QA\u0005\u0004\u0003\u000f\u0011!A\u0003'pON+w-\\3oi\"1\u00111\u0002\u0001\u0005\u0002\u0005\u000b!\u0003^3ti\n+\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\"\u001a\u0011\u0011B)\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u00059Q.Y6f\u0019><G#\u00023\u0002\u0016\u0005]\u0001\u0002\u0003\r\u0002\u0010A\u0005\t\u0019\u0001\u000e\t\u0013\u0005e\u0011q\u0002I\u0001\u0002\u00049\u0013AB2p]\u001aLw\rC\u0004\u0002\u001e\u0001!\t!a\b\u0002\u001b9|w\n]\"iK\u000e\\Gi\u001c8f)\r\u0011\u0015\u0011\u0005\u0005\u0007W\u0006m\u0001\u0019\u00017\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\u0005YQ.Y6f\u00072,\u0017M\\3s)\u0019\tI#a\f\u00024A\u0019a#a\u000b\n\u0007\u00055\"AA\u0004DY\u0016\fg.\u001a:\t\u000f\u0005E\u00121\u0005a\u0001A\u0006A1-\u00199bG&$\u0018\u0010\u0003\u0006\u00026\u0005\r\u0002\u0013!a\u0001\u0003o\t\u0011b\u00195fG.$uN\\3\u0011\u000b\r\u000bI\u0004\u001c\"\n\u0007\u0005mBIA\u0005Gk:\u001cG/[8oc!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0013AC<sSR,Gk\u001c'pOR1\u00111IA&\u0003\u001b\u0002Ba\u00170\u0002FA\u00191)a\u0012\n\u0007\u0005%CI\u0001\u0003M_:<\u0007BB\u0002\u0002>\u0001\u0007A\r\u0003\u0005\u0002P\u0005u\u0002\u0019AA)\u0003\r\u0019X-\u001d\t\u00057z\u000b\u0019\u0006E\u0003D\u0003+\u0002\u0007-C\u0002\u0002X\u0011\u0013a\u0001V;qY\u0016\u0014\u0004bBA.\u0001\u0011\u0005\u0011QL\u0001\u0004W\u0016LH\u0003BA0\u0003W\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003Kr\u0012a\u00018j_&!\u0011\u0011NA2\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003[\nI\u00061\u0001a\u0003\tIG\rC\u0004\u0002r\u0001!\t!a\u001d\u0002\u000f5,7o]1hKR1\u0011QOA@\u0003\u0003\u0003B!a\u001e\u0002|5\u0011\u0011\u0011\u0010\u0006\u0004\u0003c\"\u0011\u0002BA?\u0003s\u0012ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bbBA.\u0003_\u0002\r\u0001\u0019\u0005\b\u0003\u0007\u000by\u00071\u0001a\u0003\u00151\u0018\r\\;f\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013\u000bQ\u0002Z3mKR,W*Z:tC\u001e,G\u0003BA;\u0003\u0017Cq!a\u0017\u0002\u0006\u0002\u0007\u0001\rC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002\u0012\u0006)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\u0012TCAAJU\u0011\t9$!&,\u0005\u0005]\u0005\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!)E\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\u000bYJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!+\u0001#\u0003%\t!a+\u0002#5\f7.\u001a'pO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002.*\u001a!$!&\t\u0013\u0005E\u0006!%A\u0005\u0002\u0005M\u0016!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0017\u0016\u0004O\u0005U\u0005")
public class CleanerTest
extends JUnitSuite {
    private final File dir = TestUtils$.MODULE$.tempDir();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File dir() {
        return this.dir;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils$.MODULE$.rm(this.dir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        LogConfig x$35 = this.logConfig().copy(1024, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16());
        File x$36 = this.makeLog$default$1();
        Log log = this.makeLog(x$36, x$35);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToInteger((int)x$1));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        LogConfig x$39 = this.logConfig().copy(1024, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16());
        File x$40 = this.makeLog$default$1();
        Log log = this.makeLog(x$40, x$39);
        while (log.numberOfSegments() < 2) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$1;

            public final Log.LogAppendInfo apply(int key) {
                return this.log$1.append(this.$outer.deleteMessage(key), this.log$1.append$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
            }
        });
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L));
        Set keys = this.keysInLog(log).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$2;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToInteger((int)x$2));
            }
            {
                this.keys$2 = keys$2;
            }
        }));
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$3) {
                        return !x$3.message().isNull();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MessageAndOffset m) {
                        return new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.readString(m.message().key(), Utils$.MODULE$.readString$default$2()))).toInt();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public void abortCheckDone(TopicAndPartition topicAndPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicAndPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.abortCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        LogConfig x$43 = this.logConfig().copy(1024, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16());
        File x$44 = this.makeLog$default$1();
        Log log = this.makeLog(x$44, x$43);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keys = this.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$2.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$1;
            private final Log log$2;
            private final FakeOffsetMap map$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$1.cleanSegments(this.log$2, ((TraversableOnce)this.log$2.logSegments().take(3)).toSeq(), (OffsetMap)this.map$2, 0L);
            }
            {
                this.cleaner$1 = cleaner$1;
                this.log$2 = log$2;
                this.map$2 = map$2;
            }
        }, ManifestFactory$.MODULE$.classType(LogCleaningAbortedException.class));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        int x$45 = 300;
        int x$46 = 1;
        long x$47 = this.logConfig().copy$default$2();
        long x$48 = this.logConfig().copy$default$3();
        long x$49 = this.logConfig().copy$default$4();
        long x$50 = this.logConfig().copy$default$5();
        long x$51 = this.logConfig().copy$default$6();
        long x$52 = this.logConfig().copy$default$7();
        int x$53 = this.logConfig().copy$default$8();
        int x$54 = this.logConfig().copy$default$9();
        long x$55 = this.logConfig().copy$default$11();
        long x$56 = this.logConfig().copy$default$12();
        double x$57 = this.logConfig().copy$default$13();
        boolean x$58 = this.logConfig().copy$default$14();
        boolean x$59 = this.logConfig().copy$default$15();
        int x$60 = this.logConfig().copy$default$16();
        LogConfig x$61 = this.logConfig().copy(x$45, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$46, x$55, x$56, x$57, x$58, x$59, x$60);
        File x$62 = this.makeLog$default$1();
        Log log = this.makeLog(x$62, x$61);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.append(TestUtils$.MODULE$.singleMessageSet("hello".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((int)1, (int)groups.size());
        Assert.assertEquals((int)log.numberOfSegments(), (int)((SeqLike)groups.apply(0)).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE);
        Assert.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$4) {
                return x$4.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1);
        Assert.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$5) {
                return x$5.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = (int)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$6) {
                return x$6.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$7) {
                return x$7.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$8) {
                return x$8.index().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$9) {
                return x$9.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$10) {
                return (Seq)x$10.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$11) {
                        return x$11.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        int start = 0;
        int end = 500;
        Iterable<Object> offsets = this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), log, cleaner);
    }

    public Log makeLog(File dir, LogConfig config) {
        return new Log(dir, config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
    }

    public File makeLog$default$1() {
        return this.dir();
    }

    public LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    public void noOpCheckDone(TopicAndPartition topicAndPartition) {
    }

    public Cleaner makeCleaner(int capacity, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), 65536, 65536, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    public Function1<TopicAndPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.noOpCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$4;

            public final long apply(Tuple2<Object, Object> x$12) {
                Tuple2<Object, Object> tuple2 = x$12;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = this.log$4.append(this.$outer.message(key, value), this.log$4.append$default$2()).firstOffset();
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$4 = log$4;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public ByteBufferMessageSet message(int key, int value) {
        Message[] messageArray = new Message[1];
        byte[] x$37 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$38 = ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes();
        messageArray[0] = new Message(x$38, x$37);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    public ByteBufferMessageSet deleteMessage(int key) {
        Message[] messageArray = new Message[1];
        byte[] x$41 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$42 = null;
        messageArray[0] = new Message(x$42, x$41);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Log log$3, Cleaner cleaner$2) {
        long endOffset = cleaner$2.buildOffsetMap(log$3, (long)start, (long)end, (OffsetMap)map) + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (int)(end - start), (int)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$3.get(this.$outer.key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
    }

    public CleanerTest() {
        int x$13 = 1024;
        int x$14 = 1024;
        boolean x$15 = true;
        long x$16 = LogConfig$.MODULE$.apply$default$2();
        long x$17 = LogConfig$.MODULE$.apply$default$3();
        long x$18 = LogConfig$.MODULE$.apply$default$4();
        long x$19 = LogConfig$.MODULE$.apply$default$5();
        long x$20 = LogConfig$.MODULE$.apply$default$6();
        long x$21 = LogConfig$.MODULE$.apply$default$7();
        int x$22 = LogConfig$.MODULE$.apply$default$8();
        int x$23 = LogConfig$.MODULE$.apply$default$10();
        long x$24 = LogConfig$.MODULE$.apply$default$11();
        long x$25 = LogConfig$.MODULE$.apply$default$12();
        double x$26 = LogConfig$.MODULE$.apply$default$13();
        boolean x$27 = LogConfig$.MODULE$.apply$default$15();
        int x$28 = LogConfig$.MODULE$.apply$default$16();
        this.logConfig = new LogConfig(x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$14, x$23, x$24, x$25, x$26, x$15, x$27, x$28);
        this.time = new MockTime();
        double x$29 = Double.MAX_VALUE;
        long x$30 = Long.MAX_VALUE;
        MockTime x$31 = this.time();
        boolean x$32 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$33 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$34 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$29, x$30, x$32, x$33, x$34, (Time)x$31);
    }
}

