/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import junit.framework.Assert;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.message.CompressionCodec;
import kafka.message.MessageAndOffset;
import kafka.server.OffsetCheckpoint;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.junit.After;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\u0005i&lW-F\u0001\u001b!\tYb$D\u0001\u001d\u0015\tiB!A\u0003vi&d7/\u0003\u0002 9\tAQj\\2l)&lW\r\u0003\u0004\"\u0001\u0001\u0006IAG\u0001\u0006i&lW\r\t\u0005\bG\u0001\u0011\r\u0011\"\u0001%\u0003-\u0019XmZ7f]R\u001c\u0016N_3\u0016\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u00121!\u00138u\u0011\u0019a\u0003\u0001)A\u0005K\u0005a1/Z4nK:$8+\u001b>fA!9a\u0006\u0001b\u0001\n\u0003!\u0013a\u00033fY\u0016$X\rR3mCfDa\u0001\r\u0001!\u0002\u0013)\u0013\u0001\u00043fY\u0016$X\rR3mCf\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%\taM\u0001\bY><g*Y7f+\u0005!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0011a\u0017M\\4\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0007'R\u0014\u0018N\\4\t\ru\u0002\u0001\u0015!\u00035\u0003!awn\u001a(b[\u0016\u0004\u0003bB \u0001\u0005\u0004%\t\u0001Q\u0001\u0007Y><G)\u001b:\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\u001d\u0002\u0005%|\u0017B\u0001$D\u0005\u00111\u0015\u000e\\3\t\r!\u0003\u0001\u0015!\u0003B\u0003\u001dawn\u001a#je\u0002BqA\u0013\u0001A\u0002\u0013\u0005A%A\u0004d_VtG/\u001a:\t\u000f1\u0003\u0001\u0019!C\u0001\u001b\u0006Y1m\\;oi\u0016\u0014x\fJ3r)\tq\u0015\u000b\u0005\u0002'\u001f&\u0011\u0001k\n\u0002\u0005+:LG\u000fC\u0004S\u0017\u0006\u0005\t\u0019A\u0013\u0002\u0007a$\u0013\u0007\u0003\u0004U\u0001\u0001\u0006K!J\u0001\tG>,h\u000e^3sA!9a\u000b\u0001b\u0001\n\u00039\u0016A\u0002;pa&\u001c7/F\u0001Y!\r1\u0013lW\u0005\u00035\u001e\u0012Q!\u0011:sCf\u0004\"\u0001X0\u000e\u0003uS!A\u0018\u0003\u0002\r\r|W.\\8o\u0013\t\u0001WLA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DaA\u0019\u0001!\u0002\u0013A\u0016a\u0002;pa&\u001c7\u000f\t\u0005\u0006I\u0002!\t!Z\u0001\fG2,\u0017M\\3s)\u0016\u001cH\u000fF\u0001OQ\t\u0019w\r\u0005\u0002iU6\t\u0011N\u0003\u0002\f\u001d%\u00111.\u001b\u0002\u0005)\u0016\u001cH\u000fC\u0003n\u0001\u0011\u0005a.A\u0006sK\u0006$gI]8n\u0019><GCA8y!\r\u00018/^\u0007\u0002c*\u0011!oJ\u0001\u000bG>dG.Z2uS>t\u0017B\u0001;r\u0005!IE/\u001a:bE2,\u0007\u0003\u0002\u0014wK\u0015J!a^\u0014\u0003\rQ+\b\u000f\\33\u0011\u0015\u0019A\u000e1\u0001z!\t1\"0\u0003\u0002|\u0005\t\u0019Aj\\4\t\u000bu\u0004A\u0011\u0001@\u0002\u0013]\u0014\u0018\u000e^3EkB\u001cHcB@\u0002\u0006\u0005%\u0011Q\u0002\t\u0005a\u0006\u0005Q/C\u0002\u0002\u0004E\u00141aU3r\u0011\u0019\t9\u0001 a\u0001K\u00059a.^7LKf\u001c\bBBA\u0006y\u0002\u0007Q%A\u0004ok6$U\u000f]:\t\u000b\ra\b\u0019A=\t\r\u0005E\u0001\u0001\"\u0001f\u0003!!X-\u0019:e_^t\u0007\u0006BA\b\u0003+\u00012\u0001[A\f\u0013\r\tI\"\u001b\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003;\u0001A\u0011AA\u0010\u0003-i\u0017m[3DY\u0016\fg.\u001a:\u0015\u0019\u0005\u0005\u0012qEA\u0016\u0003_\t\u0019$a\u0011\u0011\u0007Y\t\u0019#C\u0002\u0002&\t\u0011!\u0002T8h\u00072,\u0017M\\3s\u0011\u001d\tI#a\u0007A\u0002\u0015\nQ\u0001]1siND\u0011\"!\f\u0002\u001cA\u0005\t\u0019A\u0013\u0002!5Lg\u000eR5siflUm]:bO\u0016\u001c\b\"CA\u0019\u00037\u0001\n\u00111\u0001&\u0003)qW/\u001c+ie\u0016\fGm\u001d\u0005\u000b\u0003k\tY\u0002%AA\u0002\u0005]\u0012!\u00043fM\u0006,H\u000e\u001e)pY&\u001c\u0017\u0010\u0005\u0003\u0002:\u0005}bb\u0001\u0014\u0002<%\u0019\u0011QH\u0014\u0002\rA\u0013X\rZ3g\u0013\rY\u0014\u0011\t\u0006\u0004\u0003{9\u0003BCA#\u00037\u0001\n\u00111\u0001\u0002H\u0005y\u0001o\u001c7jGf|e/\u001a:sS\u0012,7\u000fE\u0004q\u0003\u0013\n9$a\u000e\n\u0007\u0005-\u0013OA\u0002NCBD\u0011\"a\u0014\u0001#\u0003%\t!!\u0015\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u000b\u0016\u0004K\u0005U3FAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005t%\u0001\u0006b]:|G/\u0019;j_:LA!!\u001a\u0002\\\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005%\u0004!%A\u0005\u0002\u0005E\u0013!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$He\r\u0005\n\u0003[\u0002\u0011\u0013!C\u0001\u0003_\nQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002r)\"\u0011qGA+\u0011%\t)\bAI\u0001\n\u0003\t9(A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005e$\u0006BA$\u0003+\u0002")
public class LogCleanerIntegrationTest
extends JUnitSuite {
    private final MockTime time = new MockTime();
    private final int segmentSize;
    private final int deleteDelay;
    private final String logName;
    private final File logDir = TestUtils$.MODULE$.tempDir();
    private int counter = 0;
    private final TopicAndPartition[] topics = (TopicAndPartition[])((Object[])new TopicAndPartition[]{new TopicAndPartition("log", 0), new TopicAndPartition("log", 1), new TopicAndPartition("log", 2)});

    public MockTime time() {
        return this.time;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int deleteDelay() {
        return this.deleteDelay;
    }

    public String logName() {
        return this.logName;
    }

    public File logDir() {
        return this.logDir;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicAndPartition[] topics() {
        return this.topics;
    }

    @Test
    public void cleanerTest() {
        Map checkpoints;
        LogCleaner cleaner = this.makeCleaner(3, this.makeCleaner$default$2(), this.makeCleaner$default$3(), this.makeCleaner$default$4(), this.makeCleaner$default$5());
        Log log = (Log)cleaner.logs().get((Object)this.topics()[0]);
        Seq<Tuple2<Object, Object>> appends = this.writeDups(100, 3, log);
        long startSize = log.size();
        cleaner.startup();
        long lastCleaned = log.activeSegment().baseOffset();
        cleaner.awaitCleaned("log", 0, lastCleaned, cleaner.awaitCleaned$default$4());
        Iterable<Tuple2<Object, Object>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends.toMap(Predef$.MODULE$.$conforms()), (Object)read.toMap(Predef$.MODULE$.$conforms()));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
        Seq appends2 = (Seq)appends.$plus$plus(this.writeDups(100, 3, log), Seq$.MODULE$.canBuildFrom());
        long lastCleaned2 = log.activeSegment().baseOffset();
        cleaner.awaitCleaned("log", 0, lastCleaned2, cleaner.awaitCleaned$default$4());
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends2.toMap(Predef$.MODULE$.$conforms()), (Object)read2.toMap(Predef$.MODULE$.$conforms()));
        cleaner.logs().remove((Object)this.topics()[0]);
        cleaner.updateCheckpoints(this.logDir());
        Map $org_scalatest_assert_macro_left = checkpoints = new OffsetCheckpoint(new File(this.logDir(), cleaner.cleanerManager().offsetCheckpointFile())).read();
        TopicAndPartition $org_scalatest_assert_macro_right = this.topics()[0];
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right)));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        cleaner.shutdown();
    }

    public Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)segment.log().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(MessageAndOffset message) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.readString(message.message().key(), Utils$.MODULE$.readString$default$2()))).toInt();
                        int value = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.readString(message.message().payload(), Utils$.MODULE$.readString$default$2()))).toInt();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int dup) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter();
                        byte[] x$1 = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString().getBytes();
                        byte[] x$2 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        CompressionCodec x$3 = TestUtils$.MODULE$.singleMessageSet$default$2();
                        this.$outer.log$1.append(TestUtils$.MODULE$.singleMessageSet(x$1, x$3, x$2), true);
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @After
    public void teardown() {
        Utils$.MODULE$.rm(this.logDir());
    }

    public LogCleaner makeCleaner(int parts, int minDirtyMessages, int numThreads, String defaultPolicy, Map<String, String> policyOverrides) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).foreach((Function1)new Serializable(this, logs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final Pool logs$1;

            public final Log apply(int i) {
                File dir = new File(this.$outer.logDir(), new StringBuilder().append((Object)"log-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                dir.mkdirs();
                int x$4 = this.$outer.segmentSize();
                int x$5 = 102400;
                long x$6 = this.$outer.deleteDelay();
                boolean x$7 = true;
                long x$8 = LogConfig$.MODULE$.apply$default$2();
                long x$9 = LogConfig$.MODULE$.apply$default$3();
                long x$10 = LogConfig$.MODULE$.apply$default$4();
                long x$11 = LogConfig$.MODULE$.apply$default$5();
                long x$12 = LogConfig$.MODULE$.apply$default$6();
                long x$13 = LogConfig$.MODULE$.apply$default$7();
                int x$14 = LogConfig$.MODULE$.apply$default$8();
                int x$15 = LogConfig$.MODULE$.apply$default$10();
                long x$16 = LogConfig$.MODULE$.apply$default$12();
                double x$17 = LogConfig$.MODULE$.apply$default$13();
                boolean x$18 = LogConfig$.MODULE$.apply$default$15();
                int x$19 = LogConfig$.MODULE$.apply$default$16();
                Log log = new Log(dir, new LogConfig(x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$5, x$15, x$6, x$16, x$17, x$7, x$18, x$19), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                return (Log)this.logs$1.put((Object)new TopicAndPartition("log", i), (Object)log);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logs$1 = logs$1;
            }
        });
        return new LogCleaner(new CleanerConfig(numThreads, CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()), (File[])((Object[])new File[]{this.logDir()}), logs, (Time)this.time());
    }

    public int makeCleaner$default$2() {
        return 0;
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public String makeCleaner$default$4() {
        return "compact";
    }

    public Map<String, String> makeCleaner$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public LogCleanerIntegrationTest() {
        this.segmentSize = 100;
        this.deleteDelay = 1000;
        this.logName = "log";
    }
}

