/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponse$;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.RequestOrResponseSend;
import kafka.producer.ProducerRequestStats;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.SyncProducer$;
import kafka.producer.SyncProducerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005et!B\u0001\u0003\u0011\u00039\u0011\u0001D*z]\u000e\u0004&o\u001c3vG\u0016\u0014(BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\ta1+\u001f8d!J|G-^2feN\u0011\u0011\u0002\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bMIA\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\f\n\u0005\u0004%\taF\u0001\u000b%\u0016\fX/Z:u\u0017\u0016LX#\u0001\r\u0011\u00055I\u0012B\u0001\u000e\u000f\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019a\u0012\u0002)A\u00051\u0005Y!+Z9vKN$8*Z=!\u0011\u001dq\u0012B1A\u0005\u0002}\tqB]1oI>lw)\u001a8fe\u0006$xN]\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005kRLGNC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#A\u0002*b]\u0012|W\u000e\u0003\u0004*\u0013\u0001\u0006I\u0001I\u0001\u0011e\u0006tGm\\7HK:,'/\u0019;pe\u00022AA\u0003\u0002\u0001WM\u0019!\u0006\u0004\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\"\u0011!B;uS2\u001c\u0018BA\u0019/\u0005\u001daunZ4j]\u001eD\u0001b\r\u0016\u0003\u0006\u0004%\t\u0001N\u0001\u0007G>tg-[4\u0016\u0003U\u0002\"\u0001\u0003\u001c\n\u0005]\u0012!AE*z]\u000e\u0004&o\u001c3vG\u0016\u00148i\u001c8gS\u001eD\u0001\"\u000f\u0016\u0003\u0002\u0003\u0006I!N\u0001\bG>tg-[4!\u0011\u0015\u0019\"\u0006\"\u0001<)\taT\b\u0005\u0002\tU!)1G\u000fa\u0001k!9qH\u000bb\u0001\n\u0013\u0001\u0015\u0001\u00027pG.,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\nA\u0001\\1oO&\u0011ai\u0011\u0002\u0007\u001f\nTWm\u0019;\t\r!S\u0003\u0015!\u0003B\u0003\u0015awnY6!\u0011\u001dQ%\u00061A\u0005\n-\u000b\u0001b\u001d5vi\u0012|wO\\\u000b\u0002\u0019B\u0011Q\"T\u0005\u0003\u001d:\u0011qAQ8pY\u0016\fg\u000eC\u0004QU\u0001\u0007I\u0011B)\u0002\u0019MDW\u000f\u001e3po:|F%Z9\u0015\u0005I+\u0006CA\u0007T\u0013\t!fB\u0001\u0003V]&$\bb\u0002,P\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0004B\u0002-+A\u0003&A*A\u0005tQV$Hm\\<oA!\u0012qK\u0017\t\u0003\u001bmK!\u0001\u0018\b\u0003\u0011Y|G.\u0019;jY\u0016DqA\u0018\u0016C\u0002\u0013%q,A\bcY>\u001c7.\u001b8h\u0007\"\fgN\\3m+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2\u0005\u0003\u001dqW\r^<pe.L!!\u001a2\u0003\u001f\tcwnY6j]\u001e\u001c\u0005.\u00198oK2Daa\u001a\u0016!\u0002\u0013\u0001\u0017\u0001\u00052m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7!\u0011\u001dI'F1A\u0005\u0002)\fA\u0003\u001d:pIV\u001cWM\u001d*fcV,7\u000f^*uCR\u001cX#A6\u0011\u0005!a\u0017BA7\u0003\u0005Q\u0001&o\u001c3vG\u0016\u0014(+Z9vKN$8\u000b^1ug\"1qN\u000bQ\u0001\n-\fQ\u0003\u001d:pIV\u001cWM\u001d*fcV,7\u000f^*uCR\u001c\b\u0005C\u0003rU\u0011%!/A\u0007wKJLg-\u001f*fcV,7\u000f\u001e\u000b\u0003%NDQ\u0001\u001e9A\u0002U\fqA]3rk\u0016\u001cH\u000f\u0005\u0002ws6\tqO\u0003\u0002y\t\u0005\u0019\u0011\r]5\n\u0005i<(!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tK\")AP\u000bC\u0005{\u00061Am\\*f]\u0012$RA`A\u000b\u0003/\u00012a`A\t\u001b\t\t\tAC\u0002d\u0003\u0007QA!!\u0002\u0002\b\u000511m\\7n_:T1!BA\u0005\u0015\u0011\tY!!\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty!A\u0002pe\u001eLA!a\u0005\u0002\u0002\tqa*\u001a;x_J\\'+Z2fSZ,\u0007\"\u0002;|\u0001\u0004)\b\u0002CA\rwB\u0005\t\u0019\u0001'\u0002\u0019I,\u0017\r\u001a*fgB|gn]3\t\u000f\u0005u!\u0006\"\u0001\u0002 \u0005!1/\u001a8e)\u0011\t\t#a\n\u0011\u0007Y\f\u0019#C\u0002\u0002&]\u0014\u0001\u0003\u0015:pIV\u001cWM\u001d*fgB|gn]3\t\u0011\u0005%\u00121\u0004a\u0001\u0003W\tq\u0002\u001d:pIV\u001cWM\u001d*fcV,7\u000f\u001e\t\u0004m\u00065\u0012bAA\u0018o\ny\u0001K]8ek\u000e,'OU3rk\u0016\u001cH\u000fC\u0004\u0002\u001e)\"\t!a\r\u0015\t\u0005U\u00121\b\t\u0004m\u0006]\u0012bAA\u001do\n)Bk\u001c9jG6+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007b\u0002;\u00022\u0001\u0007\u0011Q\b\t\u0004m\u0006}\u0012bAA!o\n!Bk\u001c9jG6+G/\u00193bi\u0006\u0014V-];fgRDq!!\u0012+\t\u0003\t9%A\u0003dY>\u001cX\rF\u0001S\u0011\u001d\tYE\u000bC\u0005\u0003\u000f\n!\u0002Z5tG>tg.Z2u\u0011\u001d\tyE\u000bC\u0005\u0003#\nqaY8o]\u0016\u001cG\u000fF\u0001a\u0011\u001d\t)F\u000bC\u0005\u0003\u000f\n1cZ3u\u001fJl\u0015m[3D_:tWm\u0019;j_:D\u0011\"!\u0017+#\u0003%I!a\u0017\u0002!\u0011|7+\u001a8eI\u0011,g-Y;mi\u0012\u0012TCAA/U\ra\u0015qL\u0016\u0003\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0005v]\u000eDWmY6fI*\u0019\u00111\u000e\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002p\u0005\u0015$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"\u001a!&a\u001d\u0011\u00075\n)(C\u0002\u0002x9\u0012!\u0002\u001e5sK\u0006$7/\u00194f\u0001")
public class SyncProducer
implements Logging {
    private final SyncProducerConfig config;
    private final Object lock;
    private volatile boolean shutdown;
    private final BlockingChannel blockingChannel;
    private final ProducerRequestStats producerRequestStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Random randomGenerator() {
        return SyncProducer$.MODULE$.randomGenerator();
    }

    public static short RequestKey() {
        return SyncProducer$.MODULE$.RequestKey();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SyncProducer syncProducer = this;
        synchronized (syncProducer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public SyncProducerConfig config() {
        return this.config;
    }

    private Object lock() {
        return this.lock;
    }

    private boolean shutdown() {
        return this.shutdown;
    }

    private void shutdown_$eq(boolean x$1) {
        this.shutdown = x$1;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    public ProducerRequestStats producerRequestStats() {
        return this.producerRequestStats;
    }

    private void verifyRequest(RequestOrResponse request) {
        if (this.logger().isDebugEnabled()) {
            ByteBuffer buffer = new RequestOrResponseSend("", request).buffer();
            this.trace((Function0<String>)new Serializable(this, buffer){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buffer$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"verifying sendbuffer of size ").append((Object)BoxesRunTime.boxToInteger((int)this.buffer$1.limit())).toString();
                }
                {
                    this.buffer$1 = buffer$1;
                }
            });
            short requestTypeId = buffer.getShort();
            if (requestTypeId == RequestKeys$.MODULE$.ProduceKey()) {
                ProducerRequest request2 = ProducerRequest$.MODULE$.readFrom(buffer);
                this.trace((Function0<String>)new Serializable(this, request2){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRequest request$1;

                    public final String apply() {
                        return this.request$1.toString();
                    }
                    {
                        this.request$1 = request$1;
                    }
                });
            }
        }
    }

    public NetworkReceive kafka$producer$SyncProducer$$doSend(RequestOrResponse request, boolean readResponse) {
        Object object = this.lock();
        synchronized (object) {
            this.verifyRequest(request);
            this.getOrMakeConnection();
            ObjectRef response = ObjectRef.create(null);
            this.liftedTree1$1(request, readResponse, response);
            NetworkReceive networkReceive = (NetworkReceive)response.elem;
            return networkReceive;
        }
    }

    private boolean doSend$default$2() {
        return true;
    }

    public ProducerResponse send(ProducerRequest producerRequest) {
        ProducerResponse producerResponse;
        int requestSize = producerRequest.sizeInBytes();
        this.producerRequestStats().getProducerRequestStats(this.config().host(), this.config().port()).requestSizeHist().update(requestSize);
        this.producerRequestStats().getProducerRequestAllBrokersStats().requestSizeHist().update(requestSize);
        ObjectRef response = ObjectRef.create(null);
        KafkaTimer specificTimer = this.producerRequestStats().getProducerRequestStats(this.config().host(), this.config().port()).requestTimer();
        KafkaTimer aggregateTimer = this.producerRequestStats().getProducerRequestAllBrokersStats().requestTimer();
        aggregateTimer.time(new Serializable(this, producerRequest, response, specificTimer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyncProducer $outer;
            public final ProducerRequest producerRequest$1;
            public final ObjectRef response$2;
            private final KafkaTimer specificTimer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.specificTimer$1.time(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$send$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.response$2.elem = this.$outer.kafka$producer$SyncProducer$$anonfun$$$outer().kafka$producer$SyncProducer$$doSend(this.$outer.producerRequest$1, this.$outer.producerRequest$1.requiredAcks() != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SyncProducer kafka$producer$SyncProducer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerRequest$1 = producerRequest$1;
                this.response$2 = response$2;
                this.specificTimer$1 = specificTimer$1;
            }
        });
        if (producerRequest.requiredAcks() != 0) {
            ProducerResponse producerResponse2 = ProducerResponse$.MODULE$.readFrom(((NetworkReceive)response.elem).payload());
            this.producerRequestStats().getProducerRequestStats(this.config().host(), this.config().port()).throttleTimeStats().update((long)producerResponse2.throttleTime(), TimeUnit.MILLISECONDS);
            this.producerRequestStats().getProducerRequestAllBrokersStats().throttleTimeStats().update((long)producerResponse2.throttleTime(), TimeUnit.MILLISECONDS);
            producerResponse = producerResponse2;
        } else {
            producerResponse = null;
        }
        return producerResponse;
    }

    public TopicMetadataResponse send(TopicMetadataRequest request) {
        NetworkReceive response = this.kafka$producer$SyncProducer$$doSend(request, this.doSend$default$2());
        return TopicMetadataResponse$.MODULE$.readFrom(response.payload());
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.shutdown_$eq(true);
            return;
        }
    }

    private void disconnect() {
        try {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Disconnecting from ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.blockingChannel().disconnect();
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error on disconnect: ";
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BlockingChannel connect() {
        if (this.blockingChannel().isConnected() || this.shutdown()) return this.blockingChannel();
        try {
            this.blockingChannel().connect();
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Connected to ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).append((Object)" for producing").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Exception exception) {
            this.disconnect();
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Producer connection to ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).append((Object)" unsuccessful").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$2;

                public final Exception apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            throw exception;
        }
        return this.blockingChannel();
    }

    private void getOrMakeConnection() {
        if (!this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    private final void liftedTree1$1(RequestOrResponse request$2, boolean readResponse$1, ObjectRef response$1) {
        try {
            this.blockingChannel().send(request$2);
            if (readResponse$1) {
                response$1.elem = this.blockingChannel().receive();
            } else {
                this.trace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Skipping reading response";
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public SyncProducer(SyncProducerConfig config) {
        this.config = config;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.shutdown = false;
        this.blockingChannel = new BlockingChannel(config.host(), config.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), config.sendBufferBytes(), config.requestTimeoutMs());
        this.producerRequestStats = ProducerRequestStatsRegistry$.MODULE$.getProducerRequestStats(config.clientId());
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyncProducer $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Instantiating Scala Sync Producer with properties: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.config().props()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

