/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.consumer.ConsumerTopicStats;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003U1si&$\u0018n\u001c8U_BL7-\u00138g_*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001BC\u0002\u0013\u0005a#A\u0003u_BL7-F\u0001\u0018!\tArD\u0004\u0002\u001a;A\u0011!DC\u0007\u00027)\u0011ADB\u0001\u0007yI|w\u000e\u001e \n\u0005yQ\u0011A\u0002)sK\u0012,g-\u0003\u0002!C\t11\u000b\u001e:j]\u001eT!A\b\u0006\t\u0011\r\u0002!\u0011!Q\u0001\n]\ta\u0001^8qS\u000e\u0004\u0003\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u0002OA\u0011\u0011\u0002K\u0005\u0003S)\u00111!\u00138u\u0011!Y\u0003A!A!\u0002\u00139\u0013\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011\u0002\u0018\u0002\u0015\rDWO\\6Rk\u0016,X-F\u00010!\r\u0001t'O\u0007\u0002c)\u0011!gM\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001b6\u0003\u0011)H/\u001b7\u000b\u0003Y\nAA[1wC&\u0011\u0001(\r\u0002\u000e\u00052|7m[5oOF+X-^3\u0011\u0005iZT\"\u0001\u0002\n\u0005q\u0012!\u0001\u0005$fi\u000eDW\r\u001a#bi\u0006\u001c\u0005.\u001e8l\u0011!q\u0004A!A!\u0002\u0013y\u0013aC2ik:\\\u0017+^3vK\u0002B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%I!Q\u0001\u000fG>t7/^7fI>3gm]3u+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#2\u0003\u0019\tGo\\7jG&\u0011q\t\u0012\u0002\u000b\u0003R|W.[2M_:<\u0007\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u001f\r|gn];nK\u0012|eMZ:fi\u0002B\u0001b\u0013\u0001\u0003\u0006\u0004%I!Q\u0001\u000eM\u0016$8\r[3e\u001f\u001a47/\u001a;\t\u00115\u0003!\u0011!Q\u0001\n\t\u000baBZ3uG\",Gm\u00144gg\u0016$\b\u0005\u0003\u0005P\u0001\t\u0015\r\u0011\"\u0003Q\u0003%1W\r^2i'&TX-F\u0001R!\t\u0019%+\u0003\u0002T\t\ni\u0011\t^8nS\u000eLe\u000e^3hKJD\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006I!U\u0001\u000bM\u0016$8\r[*ju\u0016\u0004\u0003\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0002\f\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012D\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IaF\u0001\nG2LWM\u001c;JI\u0002BQa\u0017\u0001\u0005\u0002q\u000ba\u0001P5oSRtD\u0003C/_?\u0002\f'm\u00193\u0011\u0005i\u0002\u0001\"B\u000b[\u0001\u00049\u0002\"B\u0013[\u0001\u00049\u0003\"B\u0017[\u0001\u0004y\u0003\"\u0002![\u0001\u0004\u0011\u0005\"B&[\u0001\u0004\u0011\u0005\"B([\u0001\u0004\t\u0006\"B,[\u0001\u00049\u0002b\u00024\u0001\u0005\u0004%IaZ\u0001\u0013G>t7/^7feR{\u0007/[2Ti\u0006$8/F\u0001i!\tQ\u0014.\u0003\u0002k\u0005\t\u00112i\u001c8tk6,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019a\u0007\u0001)A\u0005Q\u0006\u00192m\u001c8tk6,'\u000fV8qS\u000e\u001cF/\u0019;tA!)a\u000e\u0001C\u0001_\u0006\u0001r-\u001a;D_:\u001cX/\\3PM\u001a\u001cX\r\u001e\u000b\u0002aB\u0011\u0011\"]\u0005\u0003e*\u0011A\u0001T8oO\")A\u000f\u0001C\u0001_\u0006qq-\u001a;GKR\u001c\u0007n\u00144gg\u0016$\b\"\u0002<\u0001\t\u00039\u0018A\u0005:fg\u0016$8i\u001c8tk6,wJ\u001a4tKR$\"\u0001_>\u0011\u0005%I\u0018B\u0001>\u000b\u0005\u0011)f.\u001b;\t\u000bq,\b\u0019\u00019\u0002!9,woQ8ogVlWm\u00144gg\u0016$\b\"\u0002@\u0001\t\u0003y\u0018\u0001\u0005:fg\u0016$h)\u001a;dQ>3gm]3u)\rA\u0018\u0011\u0001\u0005\u0007\u0003\u0007i\b\u0019\u00019\u0002\u001d9,wOR3uG\"|eMZ:fi\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0011aB3ocV,W/\u001a\u000b\u0004q\u0006-\u0001\u0002CA\u0007\u0003\u000b\u0001\r!a\u0004\u0002\u00115,7o]1hKN\u0004B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+!\u0011aB7fgN\fw-Z\u0005\u0005\u00033\t\u0019B\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0005\b\u0003;\u0001A\u0011IA\u0010\u0003!!xn\u0015;sS:<G#A\f\b\u000f\u0005\r\"\u0001#\u0001\u0002&\u0005\u0011\u0002+\u0019:uSRLwN\u001c+pa&\u001c\u0017J\u001c4p!\rQ\u0014q\u0005\u0004\u0007\u0003\tA\t!!\u000b\u0014\u0007\u0005\u001d\u0002\u0002C\u0004\\\u0003O!\t!!\f\u0015\u0005\u0005\u0015\u0002BCA\u0019\u0003O\u0011\r\u0011\"\u0001\u00024\u0005i\u0011J\u001c<bY&$wJ\u001a4tKR,\u0012\u0001\u001d\u0005\t\u0003o\t9\u0003)A\u0005a\u0006q\u0011J\u001c<bY&$wJ\u001a4tKR\u0004\u0003\u0002CA\u001e\u0003O!\t!!\u0010\u0002\u001f%\u001cxJ\u001a4tKRLeN^1mS\u0012$B!a\u0010\u0002FA\u0019\u0011\"!\u0011\n\u0007\u0005\r#BA\u0004C_>dW-\u00198\t\u000f\u0005\u001d\u0013\u0011\ba\u0001a\u00061qN\u001a4tKR\u0004")
public class PartitionTopicInfo
implements Logging {
    private final String topic;
    private final int partitionId;
    private final BlockingQueue<FetchedDataChunk> chunkQueue;
    private final AtomicLong consumedOffset;
    private final AtomicLong fetchedOffset;
    private final AtomicInteger fetchSize;
    private final String clientId;
    private final ConsumerTopicStats consumerTopicStats;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean isOffsetInvalid(long l) {
        return PartitionTopicInfo$.MODULE$.isOffsetInvalid(l);
    }

    public static long InvalidOffset() {
        return PartitionTopicInfo$.MODULE$.InvalidOffset();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionTopicInfo partitionTopicInfo = this;
        synchronized (partitionTopicInfo) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    private BlockingQueue<FetchedDataChunk> chunkQueue() {
        return this.chunkQueue;
    }

    private AtomicLong consumedOffset() {
        return this.consumedOffset;
    }

    private AtomicLong fetchedOffset() {
        return this.fetchedOffset;
    }

    private AtomicInteger fetchSize() {
        return this.fetchSize;
    }

    private String clientId() {
        return this.clientId;
    }

    private ConsumerTopicStats consumerTopicStats() {
        return this.consumerTopicStats;
    }

    public long getConsumeOffset() {
        return this.consumedOffset().get();
    }

    public long getFetchOffset() {
        return this.fetchedOffset().get();
    }

    public void resetConsumeOffset(long newConsumeOffset) {
        this.consumedOffset().set(newConsumeOffset);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "reset consume offset of " + this + " to " + newConsumeOffset);
    }

    public void resetFetchOffset(long newFetchOffset) {
        this.fetchedOffset().set(newFetchOffset);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("reset fetch offset of ( %s ) to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, BoxesRunTime.boxToLong((long)newFetchOffset)})));
    }

    public void enqueue(ByteBufferMessageSet messages) {
        block1: {
            block0: {
                int size = messages.validBytes();
                if (size <= 0) break block0;
                long next = ((MessageAndOffset)messages.shallowIterator().toSeq().last()).nextOffset();
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Updating fetch offset = " + this.fetchedOffset().get() + " to " + next);
                this.chunkQueue().put(new FetchedDataChunk(messages, this, this.fetchedOffset().get()));
                this.fetchedOffset().set(next);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("updated fetch offset of (%s) to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, BoxesRunTime.boxToLong((long)next)})));
                this.consumerTopicStats().getConsumerTopicStats(this.topic()).byteRate().mark((long)size);
                this.consumerTopicStats().getConsumerAllTopicStats().byteRate().mark((long)size);
                break block1;
            }
            if (messages.sizeInBytes() <= 0) break block1;
            this.chunkQueue().put(new FetchedDataChunk(messages, this, this.fetchedOffset().get()));
        }
    }

    public String toString() {
        return this.topic() + ":" + ((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString() + ": fetched offset = " + this.fetchedOffset().get() + ": consumed offset = " + this.consumedOffset().get();
    }

    public PartitionTopicInfo(String topic, int partitionId, BlockingQueue<FetchedDataChunk> chunkQueue, AtomicLong consumedOffset, AtomicLong fetchedOffset, AtomicInteger fetchSize, String clientId) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.chunkQueue = chunkQueue;
        this.consumedOffset = consumedOffset;
        this.fetchedOffset = fetchedOffset;
        this.fetchSize = fetchSize;
        this.clientId = clientId;
        Logging.$init$(this);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "initial consumer offset of " + this + " is " + this.consumedOffset().get());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "initial fetch offset of " + this + " is " + this.fetchedOffset().get());
        this.consumerTopicStats = ConsumerTopicStatsRegistry$.MODULE$.getConsumerTopicStat(clientId);
    }
}

