/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerZkChildListener;
import kafka.controller.ControllerZkDataListener;
import kafka.controller.ControllerZkListener;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\u0015a\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t1\u0002\u0001C\u0003\u00043\u0001\u0007Q\u0003C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001\"!\t1\"%\u0003\u0002$\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r\u0015\u0002\u0001\u0015!\u0003\"\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0011&A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003\u001dQ8.\u0016;jYN,\u0012!\r\t\u0003\u001fIJ!a\r\t\u0003\u000fi[W\u000b^5mg\"1Q\u0007\u0001Q\u0001\nE\n\u0001B_6Vi&d7\u000f\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016,\u0012!\u000f\t\u0005u}\nu)D\u0001<\u0015\taT(A\u0004nkR\f'\r\\3\u000b\u0005yR\u0011AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\u0004\u001b\u0006\u0004\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u0005\u0003\u0019\u0019w.\\7p]&\u0011ai\u0011\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\fI\u0013\tI%A\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\r-\u0003\u0001\u0015!\u0003:\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0003bB'\u0001\u0005\u0004%IAT\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001P!\t1\u0002+\u0003\u0002R\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007BB*\u0001A\u0003%q*A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u0002\u0015!\f7o\u0015;beR,G-F\u0001X!\tA\u0016-D\u0001Z\u0015\tQ6,\u0001\u0004bi>l\u0017n\u0019\u0006\u00039v\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ef\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007B\u00023\u0001A\u0003%q+A\u0006iCN\u001cF/\u0019:uK\u0012\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\u001c]>|\u0005\u000fU1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\u0016\u0003!\u0004\"AF5\n\u0005)\u0014!A\u0005(p\u001fBdU-\u00193feN+G.Z2u_JDa\u0001\u001c\u0001!\u0002\u0013A\u0017\u0001\b8p\u001fB\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'\u000f\t\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0003M!x\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s+\u0005\u0001\bCA9s\u001b\u0005\u0001a\u0001B:\u0001\u0001Q\u00141\u0003V8qS\u000e\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001c2A];|!\t1\u00180D\u0001x\u0015\tAx,\u0001\u0003mC:<\u0017B\u0001>x\u0005\u0019y%M[3diB\u0011a\u0003`\u0005\u0003{\n\u0011\u0011dQ8oiJ|G\u000e\\3s5.\u001c\u0005.\u001b7e\u0019&\u001cH/\u001a8fe\"A1A\u001dBC\u0002\u0013Eq0F\u0001\u0016\u0011%\t\u0019A\u001dB\u0001B\u0003%Q#A\u0006d_:$(o\u001c7mKJ\u0004\u0003B\u0002\u000es\t\u0003\t9\u0001F\u0002q\u0003\u0013AaaAA\u0003\u0001\u0004)\u0002bBA\u0007e\u0012E\u0011qB\u0001\bY><g*Y7f+\t\t\t\u0002E\u0002w\u0003'I1!!\u0006x\u0005\u0019\u0019FO]5oO\"9\u0011\u0011\u0004:\u0005\u0002\u0005m\u0011a\u00053p\u0011\u0006tG\r\\3DQ&dGm\u00115b]\u001e,GCBA\u000f\u0003G\tY\u0004E\u0002\n\u0003?I1!!\t\u000b\u0005\u0011)f.\u001b;\t\u0011\u0005\u0015\u0012q\u0003a\u0001\u0003O\t!\u0002]1sK:$\b+\u0019;i!\u0011\tI#a\u000e\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[QQBAA\u0018\u0015\r\t\tDB\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U\"\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\tIDC\u0002\u00026)A\u0001\"!\u0010\u0002\u0018\u0001\u0007\u0011qH\u0001\tG\"LG\u000e\u001a:f]B1\u0011\u0011IA\"\u0003Oi\u0011!P\u0005\u0004\u0003\u000bj$aA*fc\"9\u0011\u0011\n\u0001!\u0002\u0013\u0001\u0018\u0001\u0006;pa&\u001c7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\b\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002P\u0005!B-\u001a7fi\u0016$v\u000e]5dg2K7\u000f^3oKJ,\"!!\u0015\u0011\u0007E\f\u0019F\u0002\u0004\u0002V\u0001\u0001\u0011q\u000b\u0002\u0015\t\u0016dW\r^3U_BL7m\u001d'jgR,g.\u001a:\u0014\t\u0005MSo\u001f\u0005\n\u0007\u0005M#Q1A\u0005\u0012}D!\"a\u0001\u0002T\t\u0005\t\u0015!\u0003\u0016\u0011\u001dQ\u00121\u000bC\u0001\u0003?\"B!!\u0015\u0002b!11!!\u0018A\u0002UA\u0001bLA*\u0005\u0004%I\u0001\r\u0005\bk\u0005M\u0003\u0015!\u00032\u0011!\ti!a\u0015\u0005\u0012\u0005=\u0001\u0002CA\r\u0003'\"\t!a\u001b\u0015\r\u0005u\u0011QNA8\u0011!\t)#!\u001bA\u0002\u0005\u001d\u0002\u0002CA\u001f\u0003S\u0002\r!a\u0010)\r\u0005%\u00141OAF!\u0015I\u0011QOA=\u0013\r\t9H\u0003\u0002\u0007i\"\u0014xn^:\u0011\t\u0005m\u0014Q\u0011\b\u0005\u0003{\n\tI\u0004\u0003\u0002.\u0005}\u0014\"A\u0006\n\u0007\u0005\r%\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0015\u0011\u0012\u0002\n\u000bb\u001cW\r\u001d;j_:T1!a!\u000bc\u001dq\u0012qEAG\u0003s\u000b\u0014bIAH\u0003/\u000by+!'\u0016\t\u0005E\u00151S\u000b\u0003\u0003O!q!!&\u0007\u0005\u0004\tyJA\u0001U\u0013\u0011\tI*a'\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tiJC\u0001\u0007i\"\u0014xn^:\u0012\t\u0005\u0005\u0016q\u0015\t\u0004\u0013\u0005\r\u0016bAAS\u0015\t9aj\u001c;iS:<\u0007\u0003BAU\u0003Ws1!CAA\u0013\u0011\ti+!#\u0003\u0013QC'o\\<bE2,\u0017'C\u0012\u00022\u0006M\u0016QWAO\u001d\rI\u00111W\u0005\u0004\u0003;S\u0011'\u0002\u0012\n\u0015\u0005]&!B:dC2\f\u0017g\u0001\u0014\u0002z!A\u0011QXA*\t\u0003\ty,A\ne_\"\u000bg\u000e\u001a7f\t\u0006$\u0018\rR3mKR,G\r\u0006\u0003\u0002\u001e\u0005\u0005\u0007\u0002CAb\u0003w\u0003\r!a\n\u0002\u0011\u0011\fG/\u0019)bi\"D\u0001\"a2\u0001A\u0003%\u0011\u0011K\u0001\u0016I\u0016dW\r^3U_BL7m\u001d'jgR,g.\u001a:!\u0011%\tY\r\u0001b\u0001\n\u0013\ti-A\u0010qCJ$\u0018\u000e^5p]6{G-\u001b4jG\u0006$\u0018n\u001c8t\u0019&\u001cH/\u001a8feN,\"!a4\u0011\riz\u0014qEAi!\r\t\u00181\u001b\u0004\u0007\u0003+\u0004\u0001!a6\u0003=A\u000b'\u000f^5uS>tWj\u001c3jM&\u001c\u0017\r^5p]Nd\u0015n\u001d;f]\u0016\u00148#BAjk\u0006e\u0007c\u0001\f\u0002\\&\u0019\u0011Q\u001c\u0002\u00031\r{g\u000e\u001e:pY2,'OW6ECR\fG*[:uK:,'\u000fC\u0005\u0004\u0003'\u0014)\u0019!C\t\u007f\"Q\u00111AAj\u0005\u0003\u0005\u000b\u0011B\u000b\t\u0017\u0005\u0015\u00181\u001bB\u0001B\u0003%\u0011qE\u0001\u0006i>\u0004\u0018n\u0019\u0005\b5\u0005MG\u0011AAu)\u0019\t\t.a;\u0002n\"11!a:A\u0002UA\u0001\"!:\u0002h\u0002\u0007\u0011q\u0005\u0005\t\u0003\u001b\t\u0019\u000e\"\u0005\u0002\u0010!A\u00111_Aj\t\u0003\t)0\u0001\ne_\"\u000bg\u000e\u001a7f\t\u0006$\u0018m\u00115b]\u001e,GCBA\u000f\u0003o\fI\u0010\u0003\u0005\u0002D\u0006E\b\u0019AA\u0014\u0011\u001d\tY0!=A\u0002!\tA\u0001Z1uC\"A\u0011QXAj\t\u0003\ty\u0010\u0006\u0003\u0002\u001e\t\u0005\u0001\u0002CA\u0013\u0003{\u0004\r!a\n\t\u0011\t\u0015\u0001\u0001)A\u0005\u0003\u001f\f\u0001\u0005]1si&$\u0018n\u001c8N_\u0012Lg-[2bi&|gn\u001d'jgR,g.\u001a:tA!I!\u0011\u0002\u0001C\u0002\u0013%!1B\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014XC\u0001B\u0007!\u0011\u0011yA!\u0006\u000f\u0007Y\u0011\t\"C\u0002\u0003\u0014\t\tqbS1gW\u0006\u001cuN\u001c;s_2dWM]\u0005\u0005\u0005/\u0011IBA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJT1Aa\u0005\u0003\u0011!\u0011i\u0002\u0001Q\u0001\n\t5\u0011AE:uCR,7\t[1oO\u0016dunZ4fe\u0002BqA!\t\u0001\t\u0003\u0011\u0019#A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005u\u0001b\u0002B\u0014\u0001\u0011\u0005!1E\u0001\u0012e\u0016<\u0017n\u001d;fe2K7\u000f^3oKJ\u001c\bb\u0002B\u0016\u0001\u0011\u0005!1E\u0001\u0014I\u0016\u0014XmZ5ti\u0016\u0014H*[:uK:,'o\u001d\u0005\b\u0005_\u0001A\u0011\u0001B\u0012\u0003!\u0019\b.\u001e;e_^t\u0007b\u0002B\u001a\u0001\u0011\u0005!1E\u0001\"iJLwmZ3s\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]N#\u0018\r^3DQ\u0006tw-\u001a\u0005\b\u0005o\u0001A\u0011\u0001B\u001d\u0003E\u0001\u0018M\u001d;ji&|gn]%o'R\fG/\u001a\u000b\u0005\u0005w\u0011\t\u0005E\u0003\u0002B\tu\u0012)C\u0002\u0003@u\u00121aU3u\u0011\u001d\u0011\u0019E!\u000eA\u0002\u001d\u000bQa\u001d;bi\u0016DqAa\u0012\u0001\t\u0003\u0011I%\u0001\niC:$G.Z*uCR,7\t[1oO\u0016\u001cHCCA\u000f\u0005\u0017\u0012yEa\u0015\u0003^!A!Q\nB#\u0001\u0004\u0011Y$\u0001\u0006qCJ$\u0018\u000e^5p]NDqA!\u0015\u0003F\u0001\u0007q)A\u0006uCJ<W\r^*uCR,\u0007B\u0003B+\u0005\u000b\u0002\n\u00111\u0001\u0003X\u0005qA.Z1eKJ\u001cV\r\\3di>\u0014\bc\u0001\f\u0003Z%\u0019!1\f\u0002\u0003/A\u000b'\u000f^5uS>tG*Z1eKJ\u001cV\r\\3di>\u0014\bB\u0003B0\u0005\u000b\u0002\n\u00111\u0001\u0003b\u0005I1-\u00197mE\u0006\u001c7n\u001d\t\u0004-\t\r\u0014b\u0001B3\u0005\tI1)\u00197mE\u0006\u001c7n\u001d\u0005\b\u0005S\u0002A\u0011\u0002B6\u0003EA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-\u001a\u000b\r\u0003;\u0011iGa\u001c\u0003t\tU$q\u000f\u0005\t\u0003K\u00149\u00071\u0001\u0002(!9!\u0011\u000fB4\u0001\u0004I\u0013!\u00039beRLG/[8o\u0011\u001d\u0011\tFa\u001aA\u0002\u001dC\u0001B!\u0016\u0003h\u0001\u0007!q\u000b\u0005\t\u0005?\u00129\u00071\u0001\u0003b!9!1\u0010\u0001\u0005\n\t\r\u0012\u0001G5oSRL\u0017\r\\5{KB\u000b'\u000f^5uS>t7\u000b^1uK\"9!q\u0010\u0001\u0005\n\t\u0005\u0015!G1tg\u0016\u0014HOV1mS\u0012\u0004&/\u001a<j_V\u001c8\u000b^1uKN$\u0002\"!\b\u0003\u0004\n\u001d%Q\u0012\u0005\b\u0005\u000b\u0013i\b1\u0001B\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\t\u0005\u0013\u0013i\b1\u0001\u0003\f\u0006QaM]8n'R\fG/Z:\u0011\u000b\u0005\u0005\u00131I$\t\u000f\tE#Q\u0010a\u0001\u000f\"9!\u0011\u0013\u0001\u0005\n\tM\u0015AI5oSRL\u0017\r\\5{K2+\u0017\rZ3s\u0003:$\u0017j\u001d:G_J\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002\u001e\tU\u0005b\u0002BC\u0005\u001f\u0003\r!\u0011\u0005\b\u00053\u0003A\u0011\u0001BN\u0003])G.Z2u\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0005\u0002\u001e\tu%q\u0014BQ\u0011!\t)Oa&A\u0002\u0005\u001d\u0002b\u0002B9\u0005/\u0003\r!\u000b\u0005\t\u0005+\u00129\n1\u0001\u0003X!9!Q\u0015\u0001\u0005\n\t\u001d\u0016a\u0007:fO&\u001cH/\u001a:U_BL7m\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0002\u0003*B1!1\u0016BW\u0003#i\u0011!X\u0005\u0004\u0005_k&\u0001\u0002'jgRDqAa-\u0001\t\u0013\u0011\u0019#A\u000feKJ,w-[:uKJ$v\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s\u0011\u001d\u00119\f\u0001C\u0001\u0005s\u000bqD]3hSN$XM\u001d)beRLG/[8o\u0007\"\fgnZ3MSN$XM\\3s)\u0011\tiBa/\t\u0011\u0005\u0015(Q\u0017a\u0001\u0003OAqAa0\u0001\t\u0003\u0011\t-A\u0011eKJ,w-[:uKJ\u0004\u0016M\u001d;ji&|gn\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0003\u0003D\n%\u0007#B\u0005\u0003F\u0006E\u0017b\u0001Bd\u0015\t1q\n\u001d;j_:D\u0001\"!:\u0003>\u0002\u0007\u0011q\u0005\u0005\b\u0005\u001b\u0004A\u0011\u0002BT\u0003m\u0011XmZ5ti\u0016\u0014H)\u001a7fi\u0016$v\u000e]5d\u0019&\u001cH/\u001a8fe\"9!\u0011\u001b\u0001\u0005\n\t\r\u0012!\b3fe\u0016<\u0017n\u001d;fe\u0012+G.\u001a;f)>\u0004\u0018n\u0019'jgR,g.\u001a:\t\u000f\tU\u0007\u0001\"\u0003\u0003X\u0006!s-\u001a;MK\u0006$WM]%te\u0006sG-\u00129pG\"|%\u000f\u00165s_^,\u0005pY3qi&|g\u000e\u0006\u0004\u0003Z\n}'\u0011\u001d\t\u0004-\tm\u0017b\u0001Bo\u0005\tYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"D\u0001\"!:\u0003T\u0002\u0007\u0011q\u0005\u0005\b\u0005c\u0012\u0019\u000e1\u0001*\u0011%\u0011)\u000fAI\u0001\n\u0003\u00119/\u0001\u000fiC:$G.Z*uCR,7\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t%(\u0006\u0002B,\u0005W\\#A!<\u0011\t\t=(\u0011`\u0007\u0003\u0005cTAAa=\u0003v\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005oT\u0011AC1o]>$\u0018\r^5p]&!!1 By\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005\u007f\u0004\u0011\u0013!C\u0001\u0007\u0003\tA\u0004[1oI2,7\u000b^1uK\u000eC\u0017M\\4fg\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0004)\"!\u0011\rBv\u0001")
public class PartitionStateMachine
implements Logging {
    private final KafkaController controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkUtils kafka$controller$PartitionStateMachine$$zkUtils;
    private final Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final TopicChangeListener topicChangeListener;
    private final DeleteTopicsListener deleteTopicsListener;
    private final Map<String, PartitionModificationsListener> partitionModificationsListeners;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public ZkUtils kafka$controller$PartitionStateMachine$$zkUtils() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils;
    }

    private Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private TopicChangeListener topicChangeListener() {
        return this.topicChangeListener;
    }

    private DeleteTopicsListener deleteTopicsListener() {
        return this.deleteTopicsListener;
    }

    private Map<String, PartitionModificationsListener> partitionModificationsListeners() {
        return this.partitionModificationsListeners;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started partition state machine with initial state -> " + this.partitionState().toString());
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
        this.registerDeleteTopicListener();
    }

    public void deregisterListeners() {
        this.deregisterTopicChangeListener();
        this.partitionModificationsListeners().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionStateMachine.$anonfun$deregisterListeners$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.partitionModificationsListeners().clear();
        this.deregisterDeleteTopicListener();
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.partitionState().clear();
        this.deregisterListeners();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped partition state machine");
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$2(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$3(this, x$2);
                return BoxedUnit.UNIT;
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while moving some partitions to the online state", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.partitionState().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$partitionsInState$1(state, p)))).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, partitions.mkString(",")})));
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach((Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                this.handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), targetState, leaderSelector, callbacks);
                return BoxedUnit.UNIT;
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private void handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        block13: {
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.controller.epoch()), topicAndPartition, targetState})));
            }
            PartitionState currState = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> NonExistentPartition$.MODULE$);
            try {
                PartitionState partitionState = targetState;
                if (NewPartition$.MODULE$.equals(partitionState)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                    this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                    String assignedReplicas = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState, assignedReplicas})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                if (OnlinePartition$.MODULE$.equals(partitionState)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState2 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    if (NewPartition$.MODULE$.equals(partitionState2)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OfflinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OnlinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState, BoxesRunTime.boxToInteger((int)leader)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                if (OfflinePartition$.MODULE$.equals(partitionState)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState})));
                    this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                if (NonExistentPartition$.MODULE$.equals(partitionState)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState})));
                    this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                throw new MatchError((Object)partitionState);
            }
            catch (Throwable t) {
                this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().keys().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            Option option;
            Option option2 = this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get(topicPartition);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
                option = this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderIsrAndEpoch.leaderAndIsr().leader())) ? this.partitionState().put(topicPartition, (Object)OnlinePartition$.MODULE$) : this.partitionState().put(topicPartition, (Object)OfflinePartition$.MODULE$);
            } else if (None$.MODULE$.equals(option2)) {
                option = this.partitionState().put(topicPartition, (Object)NewPartition$.MODULE$);
            } else {
                throw new MatchError((Object)option2);
            }
            return option;
        });
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> fromStates, PartitionState targetState) {
        if (!fromStates.contains(this.partitionState().apply((Object)topicAndPartition))) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, fromStates.mkString(","), targetState})) + new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)})));
        }
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Seq replicaAssignment = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
        Seq liveAssignedReplicas = (Seq)replicaAssignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)r -> this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)r)));
        int n = liveAssignedReplicas.size();
        switch (n) {
            case 0: {
                String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
                this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch())})) + failMsg);
                throw new StateChangeFailedException(failMsg);
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Live assigned replicas for partition %s are: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, liveAssignedReplicas})));
        int leader = BoxesRunTime.unboxToInt((Object)liveAssignedReplicas.head());
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, (List<Object>)liveAssignedReplicas.toList()), this.controller.epoch());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Initializing leader and isr for partition %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndControllerEpoch})));
        try {
            this.kafka$controller$PartitionStateMachine$$zkUtils().createPersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), this.kafka$controller$PartitionStateMachine$$zkUtils().leaderAndIsrZkData(leaderIsrAndControllerEpoch.leaderAndIsr(), this.controller.epoch()), this.kafka$controller$PartitionStateMachine$$zkUtils().createPersistentPath$default$3());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkUtils(), topicAndPartition.topic(), topicAndPartition.partition()).get();
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
            this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch())})) + failMsg);
            throw new StateChangeFailedException(failMsg);
        }
    }

    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition})));
        try {
            boolean zookeeperPathUpdateSucceeded = false;
            ObjectRef newLeaderAndIsr = ObjectRef.create(null);
            Seq replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
            while (!zookeeperPathUpdateSucceeded) {
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                if (controllerEpoch > this.controller.epoch()) {
                    String failMsg = new StringOps(Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                    this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch())})) + failMsg);
                    throw new StateChangeFailedException(failMsg);
                }
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._1();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)leaderAndIsr, (Object)replicas);
                Tuple2 tuple23 = tuple22;
                LeaderAndIsr leaderAndIsr2 = (LeaderAndIsr)tuple23._1();
                Seq replicas2 = (Seq)tuple23._2();
                Tuple2<Object, Object> tuple24 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.kafka$controller$PartitionStateMachine$$zkUtils(), topic, partition, leaderAndIsr2, this.controller.epoch(), currentLeaderAndIsr.zkVersion());
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                boolean updateSucceeded = tuple24._1$mcZ$sp();
                int newVersion = tuple24._2$mcI$sp();
                Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
                Tuple2.mcZI.sp sp3 = sp2;
                boolean updateSucceeded2 = sp3._1$mcZ$sp();
                int newVersion2 = sp3._2$mcI$sp();
                newLeaderAndIsr.elem = leaderAndIsr2;
                ((LeaderAndIsr)newLeaderAndIsr.elem).zkVersion_$eq(newVersion2);
                zookeeperPathUpdateSucceeded = updateSucceeded2;
                replicasForThisPartition = replicas2;
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr.elem, this.controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)((LeaderAndIsr)newLeaderAndIsr$1.elem).leader()), topicAndPartition})));
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
        }
        catch (NoReplicaOnlineException nroe) {
            throw nroe;
        }
        catch (Throwable sce) {
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, sce.getMessage()}));
            this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch())})) + failMsg);
            throw new StateChangeFailedException(failMsg, sce);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().map((Function1 & Serializable & scala.Serializable)l -> new Tuple2(l._1(), l._2()), Map$.MODULE$.canBuildFrom())})));
    }

    private java.util.List<String> registerTopicChangeListener() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    private void deregisterTopicChangeListener() {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    public void registerPartitionChangeListener(String topic) {
        this.partitionModificationsListeners().put((Object)topic, (Object)new PartitionModificationsListener(this, this.controller, topic));
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.partitionModificationsListeners().apply((Object)topic));
    }

    public Option<PartitionModificationsListener> deregisterPartitionChangeListener(String topic) {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.partitionModificationsListeners().apply((Object)topic));
        return this.partitionModificationsListeners().remove((Object)topic);
    }

    private java.util.List<String> registerDeleteTopicListener() {
        return this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().subscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    private void deregisterDeleteTopicListener() {
        this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkUtils(), topic, partition);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                String failMsg = new StringOps(Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.partitionState().apply((Object)topicAndPartition)}));
                throw new StateChangeFailedException(failMsg);
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
        return leaderIsrAndControllerEpoch;
    }

    public static final /* synthetic */ void $anonfun$deregisterListeners$1(PartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String topic = (String)tuple2._1();
        PartitionModificationsListener listener = (PartitionModificationsListener)tuple2._2();
        $this.kafka$controller$PartitionStateMachine$$zkUtils().zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)listener);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$2(PartitionStateMachine $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        boolean bl = !$this.controller.deleteTopicManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$triggerOnlinePartitionStateChange$3(PartitionStateMachine $this, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
            PartitionState partitionState = (PartitionState)tuple2._2();
            if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                $this.handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, $this.controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsInState$1(PartitionState state$1, Tuple2 p) {
        Object object = p._2();
        PartitionState partitionState = state$1;
        return !(object != null ? !object.equals(partitionState) : partitionState != null);
    }

    public PartitionStateMachine(KafkaController controller) {
        this.controller = controller;
        Logging.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkUtils = this.kafka$controller$PartitionStateMachine$$controllerContext().zkUtils();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.topicChangeListener = new TopicChangeListener(this, controller);
        this.deleteTopicsListener = new DeleteTopicsListener(this, controller);
        this.partitionModificationsListeners = Map$.MODULE$.empty();
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq("[Partition state machine on Controller " + this.controllerId() + "]: ");
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DeleteTopicsListener
    implements ControllerZkChildListener {
        private final KafkaController controller;
        private final ZkUtils zkUtils;
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;
        public final /* synthetic */ PartitionStateMachine $outer;

        @Override
        public final void handleChildChange(String parentPath, java.util.List<String> currentChildren) throws Exception {
            ControllerZkChildListener.handleChildChange$(this, parentPath, currentChildren);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            DeleteTopicsListener deleteTopicsListener = this;
            synchronized (deleteTopicsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public KafkaController controller() {
            return this.controller;
        }

        private ZkUtils zkUtils() {
            return this.zkUtils;
        }

        @Override
        public String logName() {
            return "DeleteTopicsListener";
        }

        @Override
        public void doHandleChildChange(String parentPath, Seq<String> children) throws Exception {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ObjectRef topicsToBeDeleted = ObjectRef.create((Object)children.toSet());
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Delete topics listener fired for topics %s to be deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((scala.collection.immutable.Set)topicsToBeDeleted$1.elem).mkString(",")})));
                scala.collection.immutable.Set nonExistentTopics = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).$minus$minus(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                if (nonExistentTopics.nonEmpty()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring request to delete non-existing topics " + nonExistentTopics.mkString(","));
                    nonExistentTopics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                        DeleteTopicsListener.$anonfun$doHandleChildChange$10(this, topic);
                        return BoxedUnit.UNIT;
                    });
                }
                topicsToBeDeleted.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).$minus$minus((GenTraversableOnce)nonExistentTopics);
                if (Predef$.MODULE$.Boolean2boolean(this.controller().config().deleteTopicEnable())) {
                    if (((scala.collection.immutable.Set)topicsToBeDeleted.elem).nonEmpty()) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting topic deletion for topics " + ((scala.collection.immutable.Set)topicsToBeDeleted$1.elem).mkString(","));
                        ((scala.collection.immutable.Set)topicsToBeDeleted.elem).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                            DeleteTopicsListener.$anonfun$doHandleChildChange$12(this, topic);
                            return BoxedUnit.UNIT;
                        });
                        this.controller().deleteTopicManager().enqueueTopicsForDeletion((Set<String>)((scala.collection.immutable.Set)topicsToBeDeleted.elem));
                    }
                } else {
                    ((scala.collection.immutable.Set)topicsToBeDeleted.elem).foreach((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsListener.$anonfun$doHandleChildChange$15(this, topic)));
                }
            });
        }

        public void doHandleDataDeleted(String dataPath) {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$doHandleChildChange$10(DeleteTopicsListener $this, String topic) {
            $this.zkUtils().deletePathRecursive(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        }

        public static final /* synthetic */ void $anonfun$doHandleChildChange$12(DeleteTopicsListener $this, String topic) {
            block0: {
                boolean preferredReplicaElectionInProgress = ((SetLike)$this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsUndergoingPreferredReplicaElection().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.topic(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                boolean partitionReassignmentInProgress = ((SetLike)$this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsBeingReassigned().keySet().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.topic(), Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                if (!preferredReplicaElectionInProgress && !partitionReassignmentInProgress) break block0;
                $this.controller().deleteTopicManager().markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
            }
        }

        public static final /* synthetic */ boolean $anonfun$doHandleChildChange$15(DeleteTopicsListener $this, String topic) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Removing " + ZkUtils$.MODULE$.getDeleteTopicPath(topic) + " since delete topic is disabled");
            return $this.zkUtils().zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        }

        public DeleteTopicsListener(PartitionStateMachine $outer, KafkaController controller) {
            this.controller = controller;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.$init$(this);
            ControllerZkListener.$init$(this);
            ControllerZkChildListener.$init$(this);
            this.zkUtils = $outer.kafka$controller$PartitionStateMachine$$controllerContext().zkUtils();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class PartitionModificationsListener
    implements ControllerZkDataListener {
        private final KafkaController controller;
        private final String topic;
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;
        public final /* synthetic */ PartitionStateMachine $outer;

        @Override
        public final void handleDataChange(String dataPath, Object data) throws Exception {
            ControllerZkDataListener.handleDataChange$(this, dataPath, data);
        }

        @Override
        public final void handleDataDeleted(String dataPath) throws Exception {
            ControllerZkDataListener.handleDataDeleted$(this, dataPath);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            PartitionModificationsListener partitionModificationsListener = this;
            synchronized (partitionModificationsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public KafkaController controller() {
            return this.controller;
        }

        @Override
        public String logName() {
            return "AddPartitionsListener";
        }

        @Override
        public void doHandleDataChange(String dataPath, Object data) {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition modification triggered ", " for path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{data, dataPath})));
                    Map<TopicAndPartition, Seq<Object>> partitionReplicaAssignment = this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$zkUtils().getReplicaAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.topic})));
                    Map partitionsToBeAdded = (Map)partitionReplicaAssignment.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PartitionModificationsListener.$anonfun$doHandleDataChange$3(this, p)));
                    if (this.controller().deleteTopicManager().isTopicQueuedUpForDeletion($this.topic)) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Skipping adding partitions %s for topic %s since it is currently being deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitionsToBeAdded.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)PartitionModificationsListener.$anonfun$doHandleDataChange$5(x$7)), Iterable$.MODULE$.canBuildFrom())).mkString(","), $this.topic})));
                    } else if (partitionsToBeAdded.nonEmpty()) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("New partitions to be added %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeAdded})));
                        this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq((TraversableOnce)partitionsToBeAdded);
                        this.controller().onNewPartitionCreation((Set<TopicAndPartition>)partitionsToBeAdded.keySet());
                    }
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while handling add partitions for data path " + dataPath, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            });
        }

        @Override
        public void doHandleDataDeleted(String parentPath) {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$doHandleDataChange$3(PartitionModificationsListener $this, Tuple2 p) {
            return !$this.kafka$controller$PartitionStateMachine$PartitionModificationsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().contains(p._1());
        }

        public static final /* synthetic */ int $anonfun$doHandleDataChange$5(Tuple2 x$7) {
            return ((TopicAndPartition)x$7._1()).partition();
        }

        public PartitionModificationsListener(PartitionStateMachine $outer, KafkaController controller, String topic) {
            this.controller = controller;
            this.topic = topic;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.$init$(this);
            ControllerZkListener.$init$(this);
            ControllerZkDataListener.$init$(this);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements ControllerZkChildListener {
        private final KafkaController controller;
        private final String loggerName;
        private Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;
        public final /* synthetic */ PartitionStateMachine $outer;

        @Override
        public final void handleChildChange(String parentPath, java.util.List<String> currentChildren) throws Exception {
            ControllerZkChildListener.handleChildChange$(this, parentPath, currentChildren);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging.trace$(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging.swallowTrace$(this, action);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging.debug$(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging.swallowDebug$(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging.info$(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging.swallowInfo$(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging.warn$(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging.swallowWarn$(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging.swallow$(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging.error$(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging.swallowError$(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging.fatal$(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public KafkaController controller() {
            return this.controller;
        }

        @Override
        public String logName() {
            return "TopicChangeListener";
        }

        @Override
        public void doHandleChildChange(String parentPath, Seq<String> children) {
            CoreUtils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                block3: {
                    if (!this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) break block3;
                    try {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Topic change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentPath, children.mkString(",")})));
                        scala.collection.immutable.Set currentChildren = children.toSet();
                        scala.collection.immutable.Set newTopics = (scala.collection.immutable.Set)currentChildren.$minus$minus(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                        Set deletedTopics = (Set)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((GenTraversableOnce)currentChildren);
                        this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((Set<String>)currentChildren);
                        Map<TopicAndPartition, Seq<Object>> addedPartitionReplicaAssignment = this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkUtils().getReplicaAssignmentForTopics((Seq<String>)newTopics.toSeq());
                        this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Object>>)((Map)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicChangeListener.$anonfun$doHandleChildChange$3(deletedTopics, p)))));
                        this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(addedPartitionReplicaAssignment);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("New topics: [%s], deleted topics: [%s], new partition replica assignment [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newTopics, deletedTopics, addedPartitionReplicaAssignment})));
                        if (newTopics.nonEmpty()) {
                            this.controller().onNewTopicCreation((Set<String>)newTopics, (Set<TopicAndPartition>)addedPartitionReplicaAssignment.keySet());
                        }
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while handling new topic", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                }
            });
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$doHandleChildChange$3(Set deletedTopics$1, Tuple2 p) {
            return !deletedTopics$1.contains((Object)((TopicAndPartition)p._1()).topic());
        }

        public TopicChangeListener(PartitionStateMachine $outer, KafkaController controller) {
            this.controller = controller;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.$init$(this);
            ControllerZkListener.$init$(this);
            ControllerZkChildListener.$init$(this);
        }
    }
}

