/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kafka.common.UnknownCodecException;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message$;
import kafka.message.SnappyCompressionCodec$;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.KafkaLZ4BlockInputStream;
import org.apache.kafka.common.record.KafkaLZ4BlockOutputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public final class CompressionFactory$ {
    public static CompressionFactory$ MODULE$;

    static {
        new CompressionFactory$();
    }

    public OutputStream apply(CompressionCodec compressionCodec, byte messageVersion, OutputStream stream) {
        GZIPOutputStream gZIPOutputStream;
        CompressionCodec compressionCodec2 = compressionCodec;
        if (DefaultCompressionCodec$.MODULE$.equals(compressionCodec2)) {
            gZIPOutputStream = new GZIPOutputStream(stream);
        } else if (GZIPCompressionCodec$.MODULE$.equals(compressionCodec2)) {
            gZIPOutputStream = new GZIPOutputStream(stream);
        } else if (SnappyCompressionCodec$.MODULE$.equals(compressionCodec2)) {
            gZIPOutputStream = new SnappyOutputStream(stream);
        } else if (LZ4CompressionCodec$.MODULE$.equals(compressionCodec2)) {
            gZIPOutputStream = new KafkaLZ4BlockOutputStream(stream, messageVersion == Message$.MODULE$.MagicValue_V0());
        } else {
            throw new UnknownCodecException("Unknown Codec: " + compressionCodec);
        }
        return gZIPOutputStream;
    }

    public InputStream apply(CompressionCodec compressionCodec, byte messageVersion, ByteBuffer buffer) {
        GZIPInputStream gZIPInputStream;
        CompressionCodec compressionCodec2 = compressionCodec;
        if (DefaultCompressionCodec$.MODULE$.equals(compressionCodec2)) {
            gZIPInputStream = new GZIPInputStream(new ByteBufferBackedInputStream(buffer));
        } else if (GZIPCompressionCodec$.MODULE$.equals(compressionCodec2)) {
            gZIPInputStream = new GZIPInputStream(new ByteBufferBackedInputStream(buffer));
        } else if (SnappyCompressionCodec$.MODULE$.equals(compressionCodec2)) {
            gZIPInputStream = new SnappyInputStream((InputStream)new ByteBufferBackedInputStream(buffer));
        } else if (LZ4CompressionCodec$.MODULE$.equals(compressionCodec2)) {
            gZIPInputStream = new KafkaLZ4BlockInputStream(buffer, BufferSupplier.NO_CACHING, messageVersion == Message$.MODULE$.MagicValue_V0());
        } else {
            throw new UnknownCodecException("Unknown Codec: " + compressionCodec);
        }
        return gZIPInputStream;
    }

    private CompressionFactory$() {
        MODULE$ = this;
    }
}

