/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.api.ControlledShutdownRequest;
import kafka.api.ControlledShutdownResponse;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetMetadata;
import kafka.common.OffsetMetadata$;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.coordinator.GroupCoordinator;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.JoinGroupResult;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.TimestampOffset;
import kafka.network.RequestChannel;
import kafka.network.RequestOrResponseSend;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.Write$;
import kafka.server.AdminManager;
import kafka.server.BecomeLeaderOrFollowerResult;
import kafka.server.BrokerTopicStats$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Protocol;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r]g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011bS1gW\u0006\f\u0005/[:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012a\u0006\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tqA\\3uo>\u00148.\u0003\u0002\u001d3\tq!+Z9vKN$8\t[1o]\u0016d\u0007\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002B\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!I\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0003CA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0001b\n\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&\u0001\u0007bI6Lg.T1oC\u001e,'/F\u0001,!\t\u0019C&\u0003\u0002.\u0005\ta\u0011\tZ7j]6\u000bg.Y4fe\"Aq\u0006\u0001B\u0001B\u0003%1&A\u0007bI6Lg.T1oC\u001e,'\u000f\t\u0005\tc\u0001\u0011)\u0019!C\u0001e\u0005Y1m\\8sI&t\u0017\r^8s+\u0005\u0019\u0004C\u0001\u001b7\u001b\u0005)$BA\u0019\u0005\u0013\t9TG\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\"A\u0011\b\u0001B\u0001B\u0003%1'\u0001\u0007d_>\u0014H-\u001b8bi>\u0014\b\u0005\u0003\u0005<\u0001\t\u0015\r\u0011\"\u0001=\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0002{A\u0011a\bQ\u0007\u0002\u007f)\u00111\bB\u0005\u0003\u0003~\u0012qbS1gW\u0006\u001cuN\u001c;s_2dWM\u001d\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005{\u0005Y1m\u001c8ue>dG.\u001a:!\u0011!)\u0005A!b\u0001\n\u00031\u0015a\u0002>l+RLGn]\u000b\u0002\u000fB\u0011q\u0002S\u0005\u0003\u0013B\u0011qAW6Vi&d7\u000f\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003H\u0003!Q8.\u0016;jYN\u0004\u0003\u0002C'\u0001\u0005\u000b\u0007I\u0011\u0001(\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0014\t\u0003\u0013AK!!\u0015\u0006\u0003\u0007%sG\u000f\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003P\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005V\u0001\t\u0015\r\u0011\"\u0001W\u0003\u0019\u0019wN\u001c4jOV\tq\u000b\u0005\u0002$1&\u0011\u0011L\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003X\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\"\u0018\u0001\u0003\u0006\u0004%\tAX\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003}\u0003\"a\t1\n\u0005\u0005\u0014!!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003`\u00039iW\r^1eCR\f7)Y2iK\u0002B\u0001\"\u001a\u0001\u0003\u0006\u0004%\tAZ\u0001\b[\u0016$(/[2t+\u00059\u0007C\u00015r\u001b\u0005I'BA3k\u0015\tYG.\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b5T!A\\8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0018aA8sO&\u0011!/\u001b\u0002\b\u001b\u0016$(/[2t\u0011!!\bA!A!\u0002\u00139\u0017\u0001C7fiJL7m\u001d\u0011\t\u0011Y\u0004!Q1A\u0005\u0002]\f!\"Y;uQ>\u0014\u0018N_3s+\u0005A\bcA\u0005zw&\u0011!P\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0003bkRD'bAA\u0001\t\u0005A1/Z2ve&$\u00180C\u0002\u0002\u0006u\u0014!\"Q;uQ>\u0014\u0018N_3s\u0011%\tI\u0001\u0001B\u0001B\u0003%\u00010A\u0006bkRDwN]5{KJ\u0004\u0003BCA\u0007\u0001\t\u0015\r\u0011\"\u0001\u0002\u0010\u00051\u0011/^8uCN,\"!!\u0005\u0011\t\u0005M\u0011q\u0005\b\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005\u0005b\u0002BA\r\u0003?i!!a\u0007\u000b\u0007\u0005ua!\u0001\u0004=e>|GOP\u0005\u0002\u000b%\u00111\u0001B\u0005\u0004\u0003K\u0011\u0011\u0001D)v_R\fg)Y2u_JL\u0018\u0002BA\u0015\u0003W\u0011Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAA\u0013\u0005!Q\u0011q\u0006\u0001\u0003\u0002\u0003\u0006I!!\u0005\u0002\u000fE,x\u000e^1tA!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\u0002\u0013\rdWo\u001d;fe&#WCAA\u001c!\u0011\tI$!\u0011\u000f\t\u0005m\u0012Q\b\t\u0004\u00033Q\u0011bAA \u0015\u00051\u0001K]3eK\u001aLA!a\u0011\u0002F\t11\u000b\u001e:j]\u001eT1!a\u0010\u000b\u0011)\tI\u0005\u0001B\u0001B\u0003%\u0011qG\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0003BCA'\u0001\t\u0005\t\u0015!\u0003\u0002P\u0005!A/[7f!\u0011\t\t&!\u0016\u000e\u0005\u0005M#BA\tk\u0013\u0011\t9&a\u0015\u0003\tQKW.\u001a\u0005\b\u00037\u0002A\u0011AA/\u0003\u0019a\u0014N\\5u}Qq\u0012qLA1\u0003G\n)'a\u001a\u0002j\u0005-\u0014QNA8\u0003c\n\u0019(!\u001e\u0002x\u0005e\u00141\u0010\t\u0003G\u0001Aa!FA-\u0001\u00049\u0002B\u0002\u0011\u0002Z\u0001\u0007!\u0005\u0003\u0004*\u00033\u0002\ra\u000b\u0005\u0007c\u0005e\u0003\u0019A\u001a\t\rm\nI\u00061\u0001>\u0011\u0019)\u0015\u0011\fa\u0001\u000f\"1Q*!\u0017A\u0002=Ca!VA-\u0001\u00049\u0006BB/\u0002Z\u0001\u0007q\f\u0003\u0004f\u00033\u0002\ra\u001a\u0005\u0007m\u0006e\u0003\u0019\u0001=\t\u0011\u00055\u0011\u0011\fa\u0001\u0003#A\u0001\"a\r\u0002Z\u0001\u0007\u0011q\u0007\u0005\t\u0003\u001b\nI\u00061\u0001\u0002P!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015A\u00025b]\u0012dW\r\u0006\u0003\u0002\u0004\u0006%\u0005cA\u0005\u0002\u0006&\u0019\u0011q\u0011\u0006\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0017\u000bi\b1\u0001\u0002\u000e\u00069!/Z9vKN$\b\u0003BAH\u0003+s1\u0001GAI\u0013\r\t\u0019*G\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t9*!'\u0003\u000fI+\u0017/^3ti*\u0019\u00111S\r\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \u0006I\u0002.\u00198eY\u0016dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u)\u0011\t\u0019)!)\t\u0011\u0005-\u00151\u0014a\u0001\u0003\u001bCq!!*\u0001\t\u0003\t9+\u0001\riC:$G.Z*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgR$B!a!\u0002*\"A\u00111RAR\u0001\u0004\ti\tC\u0004\u0002.\u0002!\t!a,\u00027!\fg\u000e\u001a7f+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u)\u0011\t\u0019)!-\t\u0011\u0005-\u00151\u0016a\u0001\u0003\u001bCq!!.\u0001\t\u0003\t9,A\u0010iC:$G.Z\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0014V-];fgR$B!a!\u0002:\"A\u00111RAZ\u0001\u0004\ti\tC\u0004\u0002>\u0002!\t!a0\u00023!\fg\u000e\u001a7f\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e\u000b\u0005\u0003\u0007\u000b\t\r\u0003\u0005\u0002\f\u0006m\u0006\u0019AAG\u0011\u001d\t)\r\u0001C\u0005\u0003\u000f\f\u0011\"Y;uQ>\u0014\u0018N_3\u0015\u0011\u0005%\u0017qZAp\u0003S\u00042!CAf\u0013\r\tiM\u0003\u0002\b\u0005>|G.Z1o\u0011!\t\t.a1A\u0002\u0005M\u0017aB:fgNLwN\u001c\t\u0005\u0003+\fYN\u0004\u0003\u0002X\u0006Ee\u0002BA\f\u00033L!A\u0007\u0003\n\t\u0005u\u0017\u0011\u0014\u0002\b'\u0016\u001c8/[8o\u0011!\t\t/a1A\u0002\u0005\r\u0018!C8qKJ\fG/[8o!\ra\u0018Q]\u0005\u0004\u0003Ol(!C(qKJ\fG/[8o\u0011!\tY/a1A\u0002\u00055\u0018\u0001\u0003:fg>,(oY3\u0011\u0007q\fy/C\u0002\u0002rv\u0014\u0001BU3t_V\u00148-\u001a\u0005\b\u0003k\u0004A\u0011AA|\u0003UA\u0017M\u001c3mKB\u0013x\u000eZ;dKJ\u0014V-];fgR$B!a!\u0002z\"A\u00111RAz\u0001\u0004\ti\tC\u0004\u0002~\u0002!\t!a@\u0002%!\fg\u000e\u001a7f\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0003\u0007\u0013\t\u0001\u0003\u0005\u0002\f\u0006m\b\u0019AAG\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000f\t\u0011d]5{K>3G\u000b\u001b:piRdW\r\u001a)beRLG/[8ogRIqJ!\u0003\u0003\u0014\t\r\"q\n\u0005\t\u0005\u0017\u0011\u0019\u00011\u0001\u0003\u000e\u0005Ia/\u001a:tS>t\u0017\n\u001a\t\u0004\u0013\t=\u0011b\u0001B\t\u0015\t)1\u000b[8si\"A!Q\u0003B\u0002\u0001\u0004\u00119\"\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0003\u001a\t}QB\u0001B\u000e\u0015\r\u0011iB[\u0001\te\u0016\fX/Z:ug&!!\u0011\u0005B\u000e\u000511U\r^2i%\u0016\fX/Z:u\u0011!\u0011)Ca\u0001A\u0002\t\u001d\u0012aE7fe\u001e,G\rU1si&$\u0018n\u001c8ECR\f\u0007C\u0002B\u0015\u0005_\u0011\u0019$\u0004\u0002\u0003,)\u0019!Q\u0006\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00032\t-\"aA*fcB9\u0011B!\u000e\u0003:\t\u0005\u0013b\u0001B\u001c\u0015\t1A+\u001e9mKJ\u0002BAa\u000f\u0003>5\t!.C\u0002\u0003@)\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003D\t%c\u0002\u0002B\r\u0005\u000bJAAa\u0012\u0003\u001c\u0005ia)\u001a;dQJ+7\u000f]8og\u0016LAAa\u0013\u0003N\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006TAAa\u0012\u0003\u001c!A!\u0011\u000bB\u0002\u0001\u0004\u0011\u0019&A\u0003rk>$\u0018\rE\u0002$\u0005+J1Aa\u0016\u0003\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'\u000fC\u0004\u0003\\\u0001!\tA!\u0018\u0002!I,\u0007\u000f\\5dCRLwN\\)v_R\fG\u0003\u0002B0\u0005K\u00022a\tB1\u0013\r\u0011\u0019G\u0001\u0002\r%\u0016\u0004H.[2b#V|G/\u0019\u0005\t\u0005+\u0011I\u00061\u0001\u0003\u0018!9!\u0011\u000e\u0001\u0005\u0002\t-\u0014a\u00055b]\u0012dWm\u00144gg\u0016$(+Z9vKN$H\u0003BAB\u0005[B\u0001\"a#\u0003h\u0001\u0007\u0011Q\u0012\u0005\b\u0005c\u0002A\u0011\u0002B:\u0003UA\u0017M\u001c3mK>3gm]3u%\u0016\fX/Z:u-B\"BA!\u001e\u0003\bBA!\u0011\u0006B<\u0005s\u0011Y(\u0003\u0003\u0003z\t-\"aA'baB!!Q\u0010BB\u001d\u0011\u0011IBa \n\t\t\u0005%1D\u0001\u0013\u0019&\u001cHo\u00144gg\u0016$(+Z:q_:\u001cX-\u0003\u0003\u0003L\t\u0015%\u0002\u0002BA\u00057A\u0001\"a#\u0003p\u0001\u0007\u0011Q\u0012\u0005\b\u0005\u0017\u0003A\u0011\u0002BG\u0003UA\u0017M\u001c3mK>3gm]3u%\u0016\fX/Z:u-F\"BA!\u001e\u0003\u0010\"A\u00111\u0012BE\u0001\u0004\ti\tC\u0004\u0003\u0014\u0002!\tA!&\u0002\u0019\u0019,Go\u00195PM\u001a\u001cX\r^:\u0015\u0015\t]%q\u0014BX\u0005g\u00139\f\u0005\u0004\u0003*\t=\"\u0011\u0014\t\u0004\u0013\tm\u0015b\u0001BO\u0015\t!Aj\u001c8h\u0011!\u0011\tK!%A\u0002\t\r\u0016A\u00037pO6\u000bg.Y4feB!!Q\u0015BV\u001b\t\u00119KC\u0002\u0003*\u0012\t1\u0001\\8h\u0013\u0011\u0011iKa*\u0003\u00151{w-T1oC\u001e,'\u000f\u0003\u0005\u00032\nE\u0005\u0019\u0001B\u001d\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001B!.\u0003\u0012\u0002\u0007!\u0011T\u0001\ni&lWm\u001d;b[BDqA!/\u0003\u0012\u0002\u0007q*A\u0007nCbtU/\\(gMN,Go\u001d\u0005\b\u0005{\u0003A\u0011\u0002B`\u0003]1W\r^2i\u001f\u001a47/\u001a;G_J$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0005\u0003B\n%'1\u001aBg!\u0011I\u0011Pa1\u0011\t\t\u0015&QY\u0005\u0005\u0005\u000f\u00149KA\bUS6,7\u000f^1na>3gm]3u\u0011!\u0011\tKa/A\u0002\t\r\u0006\u0002\u0003BY\u0005w\u0003\rA!\u000f\t\u0011\tU&1\u0018a\u0001\u00053C\u0001B!5\u0001\t\u0003\u0011!1[\u0001\u0013M\u0016$8\r[(gMN,Go\u001d\"fM>\u0014X\r\u0006\u0005\u0003\u0018\nU'Q\u001cBp\u0011!\u0011IKa4A\u0002\t]\u0007\u0003\u0002BS\u00053LAAa7\u0003(\n\u0019Aj\\4\t\u0011\tU&q\u001aa\u0001\u00053CqA!/\u0003P\u0002\u0007q\nC\u0004\u0003d\u0002!IA!:\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\u000b\u0005O\u0014)P!?\u0003~\u000e\u0005\u0001\u0003\u0002Bu\u0005_tAA!\u0007\u0003l&!!Q\u001eB\u000e\u0003AiU\r^1eCR\f'+Z:q_:\u001cX-\u0003\u0003\u0003r\nM(!\u0004+pa&\u001cW*\u001a;bI\u0006$\u0018M\u0003\u0003\u0003n\nm\u0001\u0002\u0003B|\u0005C\u0004\r!a\u000e\u0002\u000bQ|\u0007/[2\t\u000f\tm(\u0011\u001da\u0001\u001f\u0006ia.^7QCJ$\u0018\u000e^5p]NDqAa@\u0003b\u0002\u0007q*A\tsKBd\u0017nY1uS>tg)Y2u_JD!ba\u0001\u0003bB\u0005\t\u0019AB\u0003\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005\u0007\u000f\u0019\t\"\u0004\u0002\u0004\n)!11BB\u0007\u0003\u0011)H/\u001b7\u000b\u0005\r=\u0011\u0001\u00026bm\u0006LAaa\u0005\u0004\n\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\r]\u0001\u0001\"\u0003\u0004\u001a\u0005A2M]3bi\u0016<%o\\;q\u001b\u0016$\u0018\rZ1uCR{\u0007/[2\u0015\u0005\t\u001d\bbBB\u000f\u0001\u0011%1qD\u0001\u001eO\u0016$xJ]\"sK\u0006$Xm\u0012:pkBlU\r^1eCR\fGk\u001c9jGR!!q]B\u0011\u0011!\u0019\u0019ca\u0007A\u0002\r\u0015\u0012\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BB\u0014\u0007Wi!a!\u000b\u000b\u0005iQ\u0017\u0002BB\u0017\u0007S\u0011A\u0002T5ti\u0016tWM\u001d(b[\u0016Dqa!\r\u0001\t\u0013\u0019\u0019$\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRA1QGB\u001c\u0007\u0003\u001a\u0019\u0005\u0005\u0004\u0003*\t=\"q\u001d\u0005\t\u0007s\u0019y\u00031\u0001\u0004<\u00051Ao\u001c9jGN\u0004bA!\u000b\u0004>\u0005]\u0012\u0002BB \u0005W\u00111aU3u\u0011!\u0019\u0019ca\fA\u0002\r\u0015\u0002\u0002CB#\u0007_\u0001\r!!3\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\u0005\b\u0007\u0013\u0002A\u0011AB&\u0003iA\u0017M\u001c3mKR{\u0007/[2NKR\fG-\u0019;b%\u0016\fX/Z:u)\u0011\t\u0019i!\u0014\t\u0011\u0005-5q\ta\u0001\u0003\u001bCqa!\u0015\u0001\t\u0003\u0019\u0019&\u0001\riC:$G.Z(gMN,GOR3uG\"\u0014V-];fgR$B!a!\u0004V!A\u00111RB(\u0001\u0004\ti\tC\u0004\u0004Z\u0001!\taa\u0017\u0002;!\fg\u000e\u001a7f\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\u0014V-];fgR$B!a!\u0004^!A\u00111RB,\u0001\u0004\ti\tC\u0004\u0004b\u0001!\taa\u0019\u00025!\fg\u000e\u001a7f\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9SKF,Xm\u001d;\u0015\t\u0005\r5Q\r\u0005\t\u0003\u0017\u001by\u00061\u0001\u0002\u000e\"91\u0011\u000e\u0001\u0005\u0002\r-\u0014a\u00065b]\u0012dW\rT5ti\u001e\u0013x.\u001e9t%\u0016\fX/Z:u)\u0011\t\u0019i!\u001c\t\u0011\u0005-5q\ra\u0001\u0003\u001bCqa!\u001d\u0001\t\u0003\u0019\u0019(\u0001\fiC:$G.\u001a&pS:<%o\\;q%\u0016\fX/Z:u)\u0011\t\u0019i!\u001e\t\u0011\u0005-5q\u000ea\u0001\u0003\u001bCqa!\u001f\u0001\t\u0003\u0019Y(\u0001\fiC:$G.Z*z]\u000e<%o\\;q%\u0016\fX/Z:u)\u0011\t\u0019i! \t\u0011\u0005-5q\u000fa\u0001\u0003\u001bCqa!!\u0001\t\u0003\u0019\u0019)\u0001\fiC:$G.\u001a%fCJ$(-Z1u%\u0016\fX/Z:u)\u0011\t\u0019i!\"\t\u0011\u0005-5q\u0010a\u0001\u0003\u001bCqa!#\u0001\t\u0003\u0019Y)A\fiC:$G.\u001a'fCZ,wI]8vaJ+\u0017/^3tiR!\u00111QBG\u0011!\tYia\"A\u0002\u00055\u0005bBBI\u0001\u0011\u000511S\u0001\u001bQ\u0006tG\r\\3TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003\u0007\u001b)\n\u0003\u0005\u0002\f\u000e=\u0005\u0019AAG\u0011\u001d\u0019I\n\u0001C\u0001\u00077\u000b\u0001\u0004[1oI2,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0011\t\u0019i!(\t\u0011\u0005-5q\u0013a\u0001\u0003\u001bCqa!)\u0001\t\u0003\u0019\u0019+A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0004\"91q\u0015\u0001\u0005\u0002\r%\u0016!\u00075b]\u0012dWm\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR$B!a!\u0004,\"A\u00111RBS\u0001\u0004\ti\tC\u0004\u00040\u0002!\ta!-\u00023!\fg\u000e\u001a7f\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e\u000b\u0005\u0003\u0007\u001b\u0019\f\u0003\u0005\u0002\f\u000e5\u0006\u0019AAG\u0011\u001d\u00199\f\u0001C\u0001\u0007s\u000ba#Y;uQ>\u0014\u0018N_3DYV\u001cH/\u001a:BGRLwN\u001c\u000b\u0005\u0003\u0007\u001bY\f\u0003\u0005\u0002\f\u000eU\u0006\u0019AAG\u0011%\u0019y\fAI\u0001\n\u0013\u0019\t-A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\r'\u0006BB\u0003\u0007\u000b\\#aa2\u0011\t\r%71[\u0007\u0003\u0007\u0017TAa!4\u0004P\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007#T\u0011AC1o]>$\u0018\r^5p]&!1Q[Bf\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class KafkaApis
implements Logging {
    private final RequestChannel requestChannel;
    private final ReplicaManager replicaManager;
    private final AdminManager adminManager;
    private final GroupCoordinator coordinator;
    private final KafkaController controller;
    private final ZkUtils zkUtils;
    private final int brokerId;
    private final KafkaConfig config;
    private final MetadataCache metadataCache;
    private final Metrics metrics;
    private final Option<Authorizer> authorizer;
    private final QuotaFactory.QuotaManagers quotas;
    private final String clusterId;
    private final Time time;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaApis kafkaApis = this;
        synchronized (kafkaApis) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public AdminManager adminManager() {
        return this.adminManager;
    }

    public GroupCoordinator coordinator() {
        return this.coordinator;
    }

    public KafkaController controller() {
        return this.controller;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public void handle(RequestChannel.Request request) {
        block29: {
            try {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Handling request:%s from connection %s;securityProtocol:%s,principal:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.requestDesc(true), request.connectionId(), request.securityProtocol(), request.session().principal()})));
                    ApiKeys apiKeys = ApiKeys.forId((int)request.requestId());
                    if (ApiKeys.PRODUCE.equals(apiKeys)) {
                        this.handleProducerRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.FETCH.equals(apiKeys)) {
                        this.handleFetchRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.LIST_OFFSETS.equals(apiKeys)) {
                        this.handleOffsetRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.METADATA.equals(apiKeys)) {
                        this.handleTopicMetadataRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.LEADER_AND_ISR.equals(apiKeys)) {
                        this.handleLeaderAndIsrRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.STOP_REPLICA.equals(apiKeys)) {
                        this.handleStopReplicaRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.UPDATE_METADATA_KEY.equals(apiKeys)) {
                        this.handleUpdateMetadataRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.CONTROLLED_SHUTDOWN_KEY.equals(apiKeys)) {
                        this.handleControlledShutdownRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.OFFSET_COMMIT.equals(apiKeys)) {
                        this.handleOffsetCommitRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.OFFSET_FETCH.equals(apiKeys)) {
                        this.handleOffsetFetchRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.GROUP_COORDINATOR.equals(apiKeys)) {
                        this.handleGroupCoordinatorRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.JOIN_GROUP.equals(apiKeys)) {
                        this.handleJoinGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.HEARTBEAT.equals(apiKeys)) {
                        this.handleHeartbeatRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.LEAVE_GROUP.equals(apiKeys)) {
                        this.handleLeaveGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.SYNC_GROUP.equals(apiKeys)) {
                        this.handleSyncGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.DESCRIBE_GROUPS.equals(apiKeys)) {
                        this.handleDescribeGroupRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.LIST_GROUPS.equals(apiKeys)) {
                        this.handleListGroupsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                        this.handleSaslHandshakeRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.handleApiVersionsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
                        this.handleCreateTopicsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
                        this.handleDeleteTopicsRequest(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block29;
                    }
                    throw new KafkaException("Unknown api code " + apiKeys);
                }
                catch (Throwable e) {
                    if (request.requestObj() != null) {
                        request.requestObj().handleError(e, this.requestChannel(), request);
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.requestObj()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        break block29;
                    }
                    AbstractResponse response = request.body().getErrorResponse(e);
                    if (response == null) {
                        this.requestChannel().closeConnection(request.processor(), request);
                    } else {
                        this.requestChannel().sendResponse(new RequestChannel.Response(request, response));
                    }
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.body()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            finally {
                request.apiLocalCompleteTimeMs_$eq(this.time.milliseconds());
            }
        }
    }

    public void handleLeaderAndIsrRequest(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)request.body();
        try {
            LeaderAndIsrResponse leaderAndIsrResponse;
            if (this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
                BecomeLeaderOrFollowerResult result = this.replicaManager().becomeLeaderOrFollower(correlationId, leaderAndIsrRequest, this.metadataCache(), (Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(updatedLeaders, updatedFollowers) -> {
                    this.onLeadershipChange$1(updatedLeaders, updatedFollowers);
                    return BoxedUnit.UNIT;
                });
                leaderAndIsrResponse = new LeaderAndIsrResponse(result.errorCode(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(result.responseMap().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> KafkaApis.$anonfun$handleLeaderAndIsrRequest$4(BoxesRunTime.unboxToShort((Object)x$1)))).asJava());
            } else {
                scala.collection.immutable.Map result = ((TraversableOnce)((scala.collection.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(leaderAndIsrRequest.partitionStates()).asScala()).keys().map((Function1 & Serializable & scala.Serializable)x$2 -> new Tuple2(x$2, (Object)new Short(Errors.CLUSTER_AUTHORIZATION_FAILED.code())), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                leaderAndIsrResponse = new LeaderAndIsrResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result).asJava());
            }
            LeaderAndIsrResponse leaderAndIsrResponse2 = leaderAndIsrResponse;
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)leaderAndIsrResponse2));
        }
        catch (KafkaStorageException e) {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disk error during leadership change.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            Runtime.getRuntime().halt(1);
        }
    }

    public void handleStopReplicaRequest(RequestChannel.Request request) {
        StopReplicaResponse stopReplicaResponse;
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)request.body();
        if (this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            Tuple2<scala.collection.mutable.Map<TopicPartition, Object>, Object> tuple2 = this.replicaManager().stopReplicas(stopReplicaRequest);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.mutable.Map result = (scala.collection.mutable.Map)tuple2._1();
            short error = BoxesRunTime.unboxToShort((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToShort((short)error));
            Tuple2 tuple23 = tuple22;
            scala.collection.mutable.Map result2 = (scala.collection.mutable.Map)tuple23._1();
            short error2 = BoxesRunTime.unboxToShort((Object)tuple23._2());
            result2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KafkaApis.$anonfun$handleStopReplicaRequest$1(this, stopReplicaRequest, x0$1);
                return BoxedUnit.UNIT;
            });
            stopReplicaResponse = new StopReplicaResponse(error2, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result2).asJava());
        } else {
            scala.collection.immutable.Map result = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(stopReplicaRequest.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> new Tuple2(x$4, (Object)new Short(Errors.CLUSTER_AUTHORIZATION_FAILED.code())), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            stopReplicaResponse = new StopReplicaResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result).asJava());
        }
        StopReplicaResponse response = stopReplicaResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)response));
        this.replicaManager().replicaFetcherManager().shutdownIdleFetcherThreads();
    }

    public void handleUpdateMetadataRequest(RequestChannel.Request request) {
        UpdateMetadataResponse updateMetadataResponse;
        int correlationId = request.header().correlationId();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)request.body();
        if (this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            Seq<TopicPartition> deletedPartitions = this.replicaManager().maybeUpdateMetadataCache(correlationId, updateMetadataRequest, this.metadataCache());
            if (deletedPartitions.nonEmpty()) {
                this.coordinator().handleDeletedPartitions(deletedPartitions);
            }
            if (this.adminManager().hasDelayedTopicOperations()) {
                ((IterableLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.partitionStates().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.topic(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                    KafkaApis.$anonfun$handleUpdateMetadataRequest$2(this, topic);
                    return BoxedUnit.UNIT;
                });
            }
            updateMetadataResponse = new UpdateMetadataResponse(Errors.NONE.code());
        } else {
            updateMetadataResponse = new UpdateMetadataResponse(Errors.CLUSTER_AUTHORIZATION_FAILED.code());
        }
        UpdateMetadataResponse updateMetadataResponse2 = updateMetadataResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)updateMetadataResponse2));
    }

    public void handleControlledShutdownRequest(RequestChannel.Request request) {
        ControlledShutdownRequest controlledShutdownRequest = (ControlledShutdownRequest)request.requestObj();
        this.authorizeClusterAction(request);
        scala.collection.Set<TopicAndPartition> partitionsRemaining = this.controller().shutdownBroker(controlledShutdownRequest.brokerId());
        ControlledShutdownResponse controlledShutdownResponse = new ControlledShutdownResponse(controlledShutdownRequest.correlationId(), Errors.NONE.code(), partitionsRemaining);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (Send)new RequestOrResponseSend(request.connectionId(), controlledShutdownResponse)));
    }

    public void handleOffsetCommitRequest(RequestChannel.Request request) {
        RequestHeader header = request.header();
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)request.body();
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, offsetCommitRequest.groupId()))) {
            Short errorCode = new Short(Errors.GROUP_AUTHORIZATION_FAILED.code());
            scala.collection.immutable.Map results = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(offsetCommitRequest.offsetData().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)topicPartition -> new Tuple2(topicPartition, (Object)errorCode), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            OffsetCommitResponse response = new OffsetCommitResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)results).asJava());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)response));
        } else {
            Tuple2 tuple2 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetCommitRequest.offsetData()).asScala()).toMap(Predef$.MODULE$.$conforms()).partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetCommitRequest$2(this, request, header, x0$2)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map existingAndAuthorizedForDescribeTopics = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map nonExistingOrUnauthorizedForDescribeTopics = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)existingAndAuthorizedForDescribeTopics, (Object)nonExistingOrUnauthorizedForDescribeTopics);
            Tuple2 tuple23 = tuple22;
            scala.collection.immutable.Map existingAndAuthorizedForDescribeTopics2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map nonExistingOrUnauthorizedForDescribeTopics2 = (scala.collection.immutable.Map)tuple23._2();
            Tuple2 tuple24 = existingAndAuthorizedForDescribeTopics2.partition((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetCommitRequest$4(this, request, x0$3)));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            scala.collection.immutable.Map authorizedTopics = (scala.collection.immutable.Map)tuple24._1();
            scala.collection.immutable.Map unauthorizedForReadTopics = (scala.collection.immutable.Map)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)authorizedTopics, (Object)unauthorizedForReadTopics);
            Tuple2 tuple26 = tuple25;
            scala.collection.immutable.Map authorizedTopics2 = (scala.collection.immutable.Map)tuple26._1();
            scala.collection.immutable.Map unauthorizedForReadTopics2 = (scala.collection.immutable.Map)tuple26._2();
            if (authorizedTopics2.isEmpty()) {
                this.sendResponseCallback$1(scala.collection.Map$.MODULE$.empty(), request, header, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForReadTopics2);
            } else if (header.apiVersion() == 0) {
                scala.collection.immutable.Map responseInfo = (scala.collection.immutable.Map)authorizedTopics2.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x0$5;
                    if (tuple22 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple22._1();
                        OffsetCommitRequest.PartitionData partitionData = (OffsetCommitRequest.PartitionData)tuple22._2();
                        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(offsetCommitRequest.groupId(), topicPartition.topic());
                        try {
                            if (partitionData.metadata != null && partitionData.metadata.length() > Predef$.MODULE$.Integer2int(this.config().offsetMetadataMaxSize())) {
                                tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.OFFSET_METADATA_TOO_LARGE.code()));
                            } else {
                                this.zkUtils().updatePersistentPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicDirs.consumerOffsetDir(), BoxesRunTime.boxToInteger((int)topicPartition.partition())})), ((Object)BoxesRunTime.boxToLong((long)partitionData.offset)).toString(), this.zkUtils().updatePersistentPath$default$3());
                                tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()));
                            }
                        }
                        catch (Throwable e) {
                            tuple2 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToShort((short)Errors.forException((Throwable)e).code()));
                        }
                    } else {
                        throw new MatchError((Object)tuple22);
                    }
                    Tuple2 tuple23 = tuple2;
                    return tuple23;
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                this.sendResponseCallback$1(responseInfo, request, header, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForReadTopics2);
            } else {
                long offsetRetention = header.apiVersion() <= 1 || offsetCommitRequest.retentionTime() == -1L ? this.coordinator().offsetConfig().offsetsRetentionMs() : offsetCommitRequest.retentionTime();
                long currentTimestamp = this.time.milliseconds();
                long defaultExpireTimestamp = offsetRetention + currentTimestamp;
                scala.collection.immutable.Map partitionData2 = authorizedTopics2.mapValues((Function1 & Serializable & scala.Serializable)partitionData -> {
                    String metadata = partitionData.metadata == null ? OffsetMetadata$.MODULE$.NoMetadata() : partitionData.metadata;
                    return new OffsetAndMetadata(new OffsetMetadata(partitionData.offset, metadata), currentTimestamp, partitionData.timestamp == -1L ? defaultExpireTimestamp : offsetRetention + partitionData.timestamp);
                });
                this.coordinator().handleCommitOffsets(offsetCommitRequest.groupId(), offsetCommitRequest.memberId(), offsetCommitRequest.generationId(), (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)partitionData2, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)commitStatus -> {
                    this.sendResponseCallback$1(commitStatus, request, header, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForReadTopics2);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        return this.authorizer().forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.authorize(session, operation, resource)));
    }

    public void handleProducerRequest(RequestChannel.Request request) {
        ProduceRequest produceRequest = (ProduceRequest)request.body();
        int numBytesAppended = request.header().sizeOf() + produceRequest.sizeOf();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceRequest.partitionRecordsOrFail()).asScala()).partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleProducerRequest$1(this, request, x0$6)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map existingAndAuthorizedForDescribeTopics = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map nonExistingOrUnauthorizedForDescribeTopics = (scala.collection.mutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingAndAuthorizedForDescribeTopics, (Object)nonExistingOrUnauthorizedForDescribeTopics);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map existingAndAuthorizedForDescribeTopics2 = (scala.collection.mutable.Map)tuple23._1();
        scala.collection.mutable.Map nonExistingOrUnauthorizedForDescribeTopics2 = (scala.collection.mutable.Map)tuple23._2();
        Tuple2 tuple24 = existingAndAuthorizedForDescribeTopics2.partition((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleProducerRequest$2(this, request, x0$7)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple24._1();
        scala.collection.mutable.Map unauthorizedForWriteRequestInfo = (scala.collection.mutable.Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedForWriteRequestInfo);
        Tuple2 tuple26 = tuple25;
        scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple26._1();
        scala.collection.mutable.Map unauthorizedForWriteRequestInfo2 = (scala.collection.mutable.Map)tuple26._2();
        if (authorizedRequestInfo2.isEmpty()) {
            this.sendResponseCallback$2((Map)scala.collection.Map$.MODULE$.empty(), request, produceRequest, numBytesAppended, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForWriteRequestInfo2);
        } else {
            String string = request.header().clientId();
            String string2 = AdminUtils$.MODULE$.AdminClientId();
            boolean internalTopicsAllowed = !(string != null ? !string.equals(string2) : string2 != null);
            this.replicaManager().appendRecords(produceRequest.timeout(), produceRequest.acks(), internalTopicsAllowed, (Map<TopicPartition, MemoryRecords>)authorizedRequestInfo2, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
                this.sendResponseCallback$2(responseStatus, request, produceRequest, numBytesAppended, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForWriteRequestInfo2);
                return BoxedUnit.UNIT;
            });
            produceRequest.clearPartitionRecords();
        }
    }

    public void handleFetchRequest(RequestChannel.Request request) {
        Tuple2 tuple2;
        FetchRequest fetchRequest = (FetchRequest)request.body();
        short versionId = request.header().apiVersion();
        String clientId = request.header().clientId();
        Tuple2 tuple22 = tuple2 = fetchRequest.isFromFollower() && !this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource()) ? new Tuple2((Object)Seq$.MODULE$.empty(), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchRequest.fetchData()).asScala()).toSeq()) : new Tuple2((Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchRequest.fetchData()).asScala()).toSeq(), (Object)Seq$.MODULE$.empty());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq clusterAuthorizedTopics = (Seq)tuple2._1();
        Seq clusterUnauthorizedTopics = (Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)clusterAuthorizedTopics, (Object)clusterUnauthorizedTopics);
        Tuple2 tuple24 = tuple23;
        Seq clusterAuthorizedTopics2 = (Seq)tuple24._1();
        Seq clusterUnauthorizedTopics2 = (Seq)tuple24._2();
        Tuple2 tuple25 = clusterAuthorizedTopics2.partition((Function1 & Serializable & scala.Serializable)x0$10 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleFetchRequest$1(this, request, x0$10)));
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        Seq existingAndAuthorizedForDescribeTopics = (Seq)tuple25._1();
        Seq nonExistingOrUnauthorizedForDescribeTopics = (Seq)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)existingAndAuthorizedForDescribeTopics, (Object)nonExistingOrUnauthorizedForDescribeTopics);
        Tuple2 tuple27 = tuple26;
        Seq existingAndAuthorizedForDescribeTopics2 = (Seq)tuple27._1();
        Seq nonExistingOrUnauthorizedForDescribeTopics2 = (Seq)tuple27._2();
        Tuple2 tuple28 = existingAndAuthorizedForDescribeTopics2.partition((Function1 & Serializable & scala.Serializable)x0$11 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleFetchRequest$2(this, request, x0$11)));
        if (tuple28 == null) {
            throw new MatchError((Object)tuple28);
        }
        Seq authorizedRequestInfo = (Seq)tuple28._1();
        Seq unauthorizedForReadRequestInfo = (Seq)tuple28._2();
        Tuple2 tuple29 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedForReadRequestInfo);
        Tuple2 tuple210 = tuple29;
        Seq authorizedRequestInfo2 = (Seq)tuple210._1();
        Seq unauthorizedForReadRequestInfo2 = (Seq)tuple210._2();
        Seq clusterUnauthorizedPartitionData = (Seq)clusterUnauthorizedTopics2.map((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Tuple2 tuple2 = x0$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)tp, (Object)new FetchResponse.PartitionData(Errors.CLUSTER_AUTHORIZATION_FAILED.code(), -1L, (Records)MemoryRecords.EMPTY));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Seq nonExistingOrUnauthorizedForDescribePartitionData = (Seq)nonExistingOrUnauthorizedForDescribeTopics2.map((Function1 & Serializable & scala.Serializable)x0$13 -> {
            Tuple2 tuple2 = x0$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)tp, (Object)new FetchResponse.PartitionData(Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), -1L, (Records)MemoryRecords.EMPTY));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Seq unauthorizedForReadPartitionData = (Seq)unauthorizedForReadRequestInfo2.map((Function1 & Serializable & scala.Serializable)x0$14 -> {
            Tuple2 tuple2 = x0$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)tp, (Object)new FetchResponse.PartitionData(Errors.TOPIC_AUTHORIZATION_FAILED.code(), -1L, (Records)MemoryRecords.EMPTY));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        if (authorizedRequestInfo2.isEmpty()) {
            this.sendResponseCallback$3((Seq)Seq$.MODULE$.empty(), request, fetchRequest, versionId, clientId, clusterUnauthorizedPartitionData, nonExistingOrUnauthorizedForDescribePartitionData, unauthorizedForReadPartitionData);
        } else {
            this.replicaManager().fetchMessages(fetchRequest.maxWait(), fetchRequest.replicaId(), fetchRequest.minBytes(), fetchRequest.maxBytes(), versionId <= 2, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)authorizedRequestInfo2, this.replicationQuota(fetchRequest), (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
                this.sendResponseCallback$3(responsePartitionData, request, fetchRequest, versionId, clientId, clusterUnauthorizedPartitionData, nonExistingOrUnauthorizedForDescribePartitionData, unauthorizedForReadPartitionData);
                return BoxedUnit.UNIT;
            });
        }
    }

    private int sizeOfThrottledPartitions(short versionId, FetchRequest fetchRequest, Seq<Tuple2<TopicPartition, FetchResponse.PartitionData>> mergedPartitionData, ReplicationQuotaManager quota) {
        LinkedHashMap partitionData = new LinkedHashMap();
        mergedPartitionData.foreach((Function1 & Serializable & scala.Serializable)x0$18 -> {
            Tuple2 tuple2 = x0$18;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchResponse.PartitionData data = (FetchResponse.PartitionData)tuple2._2();
            BoxedUnit boxedUnit = quota.isThrottled(tp) ? partitionData.put(tp, data) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        return FetchResponse.sizeOf((int)versionId, partitionData);
    }

    public ReplicaQuota replicationQuota(FetchRequest fetchRequest) {
        return fetchRequest.isFromFollower() ? this.quotas().leader() : QuotaFactory$UnboundedQuota$.MODULE$;
    }

    public void handleOffsetRequest(RequestChannel.Request request) {
        short version = request.header().apiVersion();
        Map<TopicPartition, ListOffsetResponse.PartitionData> mergedResponseMap = version == 0 ? this.handleOffsetRequestV0(request) : this.handleOffsetRequestV1(request);
        ListOffsetResponse response = new ListOffsetResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseMap).asJava(), (int)version);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)response));
    }

    private Map<TopicPartition, ListOffsetResponse.PartitionData> handleOffsetRequestV0(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        String clientId = request.header().clientId();
        ListOffsetRequest offsetRequest = (ListOffsetRequest)request.body();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetRequest.offsetData()).asScala()).partition((Function1 & Serializable & scala.Serializable)x0$19 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetRequestV0$1(this, request, x0$19)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map unauthorizedRequestInfo = (scala.collection.mutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._1();
        scala.collection.mutable.Map unauthorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._2();
        Map unauthorizedResponseStatus = unauthorizedRequestInfo2.mapValues((Function1 & Serializable & scala.Serializable)x$21 -> new ListOffsetResponse.PartitionData(Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
        scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1 & Serializable & scala.Serializable)x0$20 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$20;
            if (tuple22 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple22._1();
                ListOffsetRequest.PartitionData partitionData = (ListOffsetRequest.PartitionData)tuple22._2();
                try {
                    Seq seq;
                    Replica localReplica = offsetRequest.replicaId() != -2 ? this.replicaManager().getLeaderReplicaIfLocal(topicPartition) : this.replicaManager().getReplicaOrException(topicPartition);
                    Seq allOffsets = this.fetchOffsets(this.replicaManager().logManager(), topicPartition, partitionData.timestamp, partitionData.maxNumOffsets);
                    if (offsetRequest.replicaId() != -1) {
                        seq = allOffsets;
                    } else {
                        long hw = localReplica.highWatermark().messageOffset();
                        if (allOffsets.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$22 -> x$22 > hw)) {
                            long l = hw;
                            seq = (Seq)((SeqLike)allOffsets.dropWhile((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$23 -> x$23 > hw)).$plus$colon((Object)BoxesRunTime.boxToLong((long)l), Seq$.MODULE$.canBuildFrom());
                        } else {
                            seq = allOffsets;
                        }
                    }
                    Seq offsets = seq;
                    tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.NONE.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)offsets.map((Function1 & Serializable & scala.Serializable)x$25 -> KafkaApis.$anonfun$handleOffsetRequestV0$6(BoxesRunTime.unboxToLong((Object)x$25)), Seq$.MODULE$.canBuildFrom())).asJava()));
                }
                catch (Throwable throwable) {
                    Tuple2 tuple23;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof UnknownTopicOrPartitionException ? true : throwable2 instanceof NotLeaderForPartitionException;
                    if (bl) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)correlationId), clientId, topicPartition, throwable2.getMessage()})));
                        tuple23 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable2).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while responding to offset request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        tuple23 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable3).code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                    } else {
                        throw throwable;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            return tuple24;
        }, Map$.MODULE$.canBuildFrom());
        return responseMap.$plus$plus((GenTraversableOnce)unauthorizedResponseStatus);
    }

    private Map<TopicPartition, ListOffsetResponse.PartitionData> handleOffsetRequestV1(RequestChannel.Request request) {
        int correlationId = request.header().correlationId();
        String clientId = request.header().clientId();
        ListOffsetRequest offsetRequest = (ListOffsetRequest)request.body();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetRequest.partitionTimestamps()).asScala()).partition((Function1 & Serializable & scala.Serializable)x0$21 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetRequestV1$1(this, request, x0$21)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map authorizedRequestInfo = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map unauthorizedRequestInfo = (scala.collection.mutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)authorizedRequestInfo, (Object)unauthorizedRequestInfo);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map authorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._1();
        scala.collection.mutable.Map unauthorizedRequestInfo2 = (scala.collection.mutable.Map)tuple23._2();
        Map unauthorizedResponseStatus = unauthorizedRequestInfo2.mapValues((Function1 & Serializable & scala.Serializable)x$27 -> new ListOffsetResponse.PartitionData(Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), -1L, -1L));
        scala.collection.mutable.Map responseMap = (scala.collection.mutable.Map)authorizedRequestInfo2.map((Function1 & Serializable & scala.Serializable)x0$22 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$22;
            if (tuple22 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple22._1();
                Long timestamp = (Long)tuple22._2();
                if (offsetRequest.duplicatePartitions().contains(topicPartition)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OffsetRequest with correlation id ", " from client ", " on partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)correlationId), clientId, topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed because the partition is duplicated in the request."})).s((Seq)Nil$.MODULE$));
                    tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.INVALID_REQUEST.code(), -1L, -1L));
                } else {
                    try {
                        TimestampOffset timestampOffset;
                        Replica localReplica;
                        boolean fromConsumer = offsetRequest.replicaId() == -1;
                        Replica replica = localReplica = offsetRequest.replicaId() != -2 ? this.replicaManager().getLeaderReplicaIfLocal(topicPartition) : this.replicaManager().getReplicaOrException(topicPartition);
                        if (fromConsumer && BoxesRunTime.equalsNumObject((Number)timestamp, (Object)BoxesRunTime.boxToLong((long)-1L))) {
                            timestampOffset = new TimestampOffset(-1L, localReplica.highWatermark().messageOffset());
                        } else {
                            Some some;
                            TimestampOffset timestampOffset2;
                            Option<TimestampOffset> option = this.fetchOffsetForTimestamp(this.replicaManager().logManager(), topicPartition, Predef$.MODULE$.Long2long(timestamp));
                            TimestampOffset timestampOffset3 = option instanceof Some && KafkaApis.allowed$1(timestampOffset2 = (TimestampOffset)(some = (Some)option).value(), fromConsumer, localReplica) ? timestampOffset2 : new TimestampOffset(-1L, -1L);
                            timestampOffset = timestampOffset3;
                        }
                        TimestampOffset found = timestampOffset;
                        tuple2 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.NONE.code(), found.timestamp(), found.offset()));
                    }
                    catch (Throwable throwable) {
                        Tuple2 tuple23;
                        Throwable throwable2 = throwable;
                        boolean bl = throwable2 instanceof UnknownTopicOrPartitionException ? true : (throwable2 instanceof NotLeaderForPartitionException ? true : throwable2 instanceof UnsupportedForMessageFormatException);
                        if (bl) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset request with correlation id ", " from client ", " on "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)correlationId), clientId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, throwable2.getMessage()})));
                            tuple23 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable2).code(), -1L, -1L));
                        } else if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while responding to offset request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                            tuple23 = new Tuple2((Object)topicPartition, (Object)new ListOffsetResponse.PartitionData(Errors.forException((Throwable)throwable3).code(), -1L, -1L));
                        } else {
                            throw throwable;
                        }
                        tuple2 = tuple23;
                    }
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            return tuple24;
        }, Map$.MODULE$.canBuildFrom());
        return responseMap.$plus$plus((GenTraversableOnce)unauthorizedResponseStatus);
    }

    public Seq<Object> fetchOffsets(LogManager logManager, TopicPartition topicPartition, long timestamp, int maxNumOffsets) {
        Nil$ nil$;
        Option<Log> option = logManager.getLog(topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            Log log = (Log)some.value();
            nil$ = this.fetchOffsetsBefore(log, timestamp, maxNumOffsets);
        } else if (None$.MODULE$.equals(option)) {
            nil$ = timestamp == -1L || timestamp == -2L ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})) : Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return nil$;
    }

    private Option<TimestampOffset> fetchOffsetForTimestamp(LogManager logManager, TopicPartition topicPartition, long timestamp) {
        Option<Log> option = logManager.getLog(topicPartition);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist on the broker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Log log = (Log)some.value();
        Option<TimestampOffset> option2 = log.fetchOffsetsByTimestamp(timestamp);
        return option2;
    }

    public Seq<Object> fetchOffsetsBefore(Log log, long timestamp, int maxNumOffsets) {
        Buffer segments = log.logSegments().toBuffer();
        boolean lastSegmentHasSize = ((LogSegment)segments.last()).size() > 0L;
        Tuple2[] offsetTimeArray = lastSegmentHasSize ? new Tuple2[segments.length() + 1] : new Tuple2[segments.length()];
        segments.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            offsetTimeArray$1[i] = new Tuple2.mcJJ.sp(((LogSegment)segments.apply(i)).baseOffset(), ((LogSegment)segments.apply(i)).lastModified());
        });
        if (lastSegmentHasSize) {
            offsetTimeArray[segments.length()] = new Tuple2.mcJJ.sp(log.logEndOffset(), this.time.milliseconds());
        }
        IntRef startIndex = IntRef.create((int)-1);
        long l = timestamp;
        if (-1L == l) {
            startIndex.elem = offsetTimeArray.length - 1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (-2L == l) {
            startIndex.elem = 0;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean isFound = false;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                StringBuilder stringBuilder = new StringBuilder().append("Offset time array = ");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsetTimeArray)).foreach((Function1 & Serializable & scala.Serializable)o -> new StringOps(Predef$.MODULE$.augmentString("%d, %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)o._1$mcJ$sp()), BoxesRunTime.boxToLong((long)o._2$mcJ$sp())})));
                return stringBuilder.append(BoxedUnit.UNIT).toString();
            });
            startIndex.elem = offsetTimeArray.length - 1;
            while (startIndex.elem >= 0 && !isFound) {
                if (offsetTimeArray[startIndex.elem]._2$mcJ$sp() <= timestamp) {
                    isFound = true;
                    continue;
                }
                --startIndex.elem;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        int retSize = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(maxNumOffsets), startIndex.elem + 1);
        long[] ret = new long[retSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), retSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            ret$1[j] = offsetTimeArray[startIndex$1.elem]._1$mcJ$sp();
            --startIndex$1.elem;
        });
        return (Seq)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ret)).toSeq().sortBy((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$28 -> -x$28, (Ordering)Ordering.Long$.MODULE$);
    }

    private MetadataResponse.TopicMetadata createTopic(String topic, int numPartitions, int replicationFactor, Properties properties) {
        MetadataResponse.TopicMetadata topicMetadata;
        try {
            AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, numPartitions, replicationFactor, properties, RackAwareMode$Safe$.MODULE$);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Auto creation of topic %s with %d partitions and replication factor %d is successful")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)numPartitions), BoxesRunTime.boxToInteger((int)replicationFactor)})));
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        catch (TopicExistsException topicExistsException) {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        catch (Throwable ex) {
            topicMetadata = new MetadataResponse.TopicMetadata(Errors.forException((Throwable)ex), topic, Topic$.MODULE$.isInternal(topic), Collections.emptyList());
        }
        return topicMetadata;
    }

    private Properties createTopic$default$4() {
        return new Properties();
    }

    private MetadataResponse.TopicMetadata createGroupMetadataTopic() {
        Seq<Broker> aliveBrokers = this.metadataCache().getAliveBrokers();
        int offsetsTopicReplicationFactor = aliveBrokers.nonEmpty() ? Math.min(Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()), aliveBrokers.length()) : Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor());
        return this.createTopic(Topic$.MODULE$.GroupMetadataTopicName(), Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), offsetsTopicReplicationFactor, this.coordinator().offsetsTopicConfigs());
    }

    private MetadataResponse.TopicMetadata getOrCreateGroupMetadataTopic(ListenerName listenerName) {
        Seq<MetadataResponse.TopicMetadata> topicMetadata = this.metadataCache().getTopicMetadata((scala.collection.Set<String>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Topic$.MODULE$.GroupMetadataTopicName()}))), listenerName, this.metadataCache().getTopicMetadata$default$3());
        return (MetadataResponse.TopicMetadata)topicMetadata.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.createGroupMetadataTopic());
    }

    private Seq<MetadataResponse.TopicMetadata> getTopicMetadata(scala.collection.Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        Seq seq;
        Seq topicResponses = this.metadataCache().getTopicMetadata(topics, listenerName, errorUnavailableEndpoints);
        if (topics.isEmpty() || topicResponses.size() == topics.size()) {
            seq = topicResponses;
        } else {
            scala.collection.Set nonExistentTopics = (scala.collection.Set)topics.$minus$minus((GenTraversableOnce)((TraversableOnce)topicResponses.map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.topic(), Seq$.MODULE$.canBuildFrom())).toSet());
            scala.collection.Set responsesForNonExistentTopics = (scala.collection.Set)nonExistentTopics.map((Function1 & Serializable & scala.Serializable)topic -> {
                String string = topic;
                String string2 = Topic$.MODULE$.GroupMetadataTopicName();
                return !(string != null ? !string.equals(string2) : string2 != null) ? this.createGroupMetadataTopic() : (Predef$.MODULE$.Boolean2boolean(this.config().autoCreateTopicsEnable()) ? this.createTopic((String)topic, Predef$.MODULE$.Integer2int(this.config().numPartitions()), this.config().defaultReplicationFactor(), this.createTopic$default$4()) : new MetadataResponse.TopicMetadata(Errors.UNKNOWN_TOPIC_OR_PARTITION, topic, false, Collections.emptyList()));
            }, Set$.MODULE$.canBuildFrom());
            seq = (Seq)topicResponses.$plus$plus((GenTraversableOnce)responsesForNonExistentTopics, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public void handleTopicMetadataRequest(RequestChannel.Request request) {
        MetadataRequest metadataRequest = (MetadataRequest)request.body();
        short requestVersion = request.header().apiVersion();
        scala.collection.immutable.Set topics = requestVersion == 0 ? (metadataRequest.topics() == null || metadataRequest.topics().isEmpty() ? this.metadataCache().getAllTopics() : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadataRequest.topics()).asScala()).toSet()) : (metadataRequest.isAllTopics() ? this.metadataCache().getAllTopics() : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadataRequest.topics()).asScala()).toSet());
        Tuple2 tuple2 = topics.partition((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)this.authorize(request.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topic))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.Set authorizedTopics = (scala.collection.Set)tuple2._1();
        scala.collection.Set unauthorizedForDescribeTopics = (scala.collection.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)authorizedTopics, (Object)unauthorizedForDescribeTopics);
        Tuple2 tuple23 = tuple22;
        scala.collection.Set authorizedTopics2 = (scala.collection.Set)tuple23._1();
        scala.collection.Set unauthorizedForDescribeTopics2 = (scala.collection.Set)tuple23._2();
        scala.collection.Set unauthorizedForCreateTopics = (scala.collection.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (authorizedTopics2.nonEmpty()) {
            scala.collection.Set<String> nonExistingTopics = this.metadataCache().getNonExistingTopics((scala.collection.Set<String>)authorizedTopics2);
            if (Predef$.MODULE$.Boolean2boolean(this.config().autoCreateTopicsEnable()) && nonExistingTopics.nonEmpty() && !this.authorize(request.session(), Create$.MODULE$, Resource$.MODULE$.ClusterResource())) {
                authorizedTopics2 = (scala.collection.Set)authorizedTopics2.$minus$minus(nonExistingTopics);
                unauthorizedForCreateTopics = unauthorizedForCreateTopics.$plus$plus(nonExistingTopics);
            }
        }
        scala.collection.Set unauthorizedForCreateTopicMetadata = (scala.collection.Set)unauthorizedForCreateTopics.map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponse.TopicMetadata(Errors.TOPIC_AUTHORIZATION_FAILED, topic, Topic$.MODULE$.isInternal((String)topic), Collections.emptyList()), Set$.MODULE$.canBuildFrom());
        scala.collection.Set unauthorizedForDescribeTopicMetadata = requestVersion == 0 && (metadataRequest.topics() == null || metadataRequest.topics().isEmpty()) || metadataRequest.isAllTopics() ? Set$.MODULE$.empty() : (scala.collection.Set)unauthorizedForDescribeTopics2.map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponse.TopicMetadata(Errors.UNKNOWN_TOPIC_OR_PARTITION, topic, false, Collections.emptyList()), Set$.MODULE$.canBuildFrom());
        boolean errorUnavailableEndpoints = requestVersion == 0;
        Seq<MetadataResponse.TopicMetadata> topicMetadata = authorizedTopics2.isEmpty() ? (Seq<MetadataResponse.TopicMetadata>)Seq$.MODULE$.empty() : this.getTopicMetadata((scala.collection.Set<String>)authorizedTopics2, request.listenerName(), errorUnavailableEndpoints);
        Seq completeTopicMetadata = (Seq)((TraversableLike)topicMetadata.$plus$plus((GenTraversableOnce)unauthorizedForCreateTopicMetadata, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)unauthorizedForDescribeTopicMetadata, Seq$.MODULE$.canBuildFrom());
        Seq<Broker> brokers = this.metadataCache().getAliveBrokers();
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending topic metadata %s and brokers %s for correlation id %d to client %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completeTopicMetadata.mkString(","), brokers.mkString(","), BoxesRunTime.boxToInteger((int)request.header().correlationId()), request.header().clientId()})));
        MetadataResponse responseBody = new MetadataResponse((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.getNode(request.listenerName()), Seq$.MODULE$.canBuildFrom())).asJava(), this.clusterId(), BoxesRunTime.unboxToInt((Object)this.metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(completeTopicMetadata).asJava(), (int)requestVersion);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)responseBody));
    }

    public void handleOffsetFetchRequest(RequestChannel.Request request) {
        OffsetFetchResponse offsetFetchResponse;
        RequestHeader header = request.header();
        OffsetFetchRequest offsetFetchRequest = (OffsetFetchRequest)request.body();
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, offsetFetchRequest.groupId()))) {
            offsetFetchResponse = offsetFetchRequest.getErrorResponse(Errors.GROUP_AUTHORIZATION_FAILED);
        } else if (header.apiVersion() == 0) {
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetFetchRequest.partitions()).asScala()).partition((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)this.authorizeTopicDescribe$1(partition, request)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer authorizedPartitions = (Buffer)tuple2._1();
            Buffer unauthorizedPartitions = (Buffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)authorizedPartitions, (Object)unauthorizedPartitions);
            Tuple2 tuple23 = tuple22;
            Buffer authorizedPartitions2 = (Buffer)tuple23._1();
            Buffer unauthorizedPartitions2 = (Buffer)tuple23._2();
            scala.collection.immutable.Map authorizedPartitionData = ((TraversableOnce)authorizedPartitions2.map((Function1 & Serializable & scala.Serializable)topicPartition -> {
                Tuple2 tuple2;
                block7: {
                    ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(offsetFetchRequest.groupId(), topicPartition.topic());
                    try {
                        Tuple2 tuple22;
                        if (!this.metadataCache().contains(topicPartition.topic())) {
                            tuple2 = new Tuple2(topicPartition, (Object)OffsetFetchResponse.UNKNOWN_PARTITION);
                            break block7;
                        }
                        Option payloadOpt = (Option)this.zkUtils().readDataMaybeNull(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicDirs.consumerOffsetDir(), BoxesRunTime.boxToInteger((int)topicPartition.partition())})))._1();
                        Option option = payloadOpt;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String payload = (String)some.value();
                            tuple22 = new Tuple2(topicPartition, (Object)new OffsetFetchResponse.PartitionData(new StringOps(Predef$.MODULE$.augmentString(payload)).toLong(), "", Errors.NONE));
                        } else if (None$.MODULE$.equals(option)) {
                            tuple22 = new Tuple2(topicPartition, (Object)OffsetFetchResponse.UNKNOWN_PARTITION);
                        } else {
                            throw new MatchError((Object)option);
                        }
                        tuple2 = tuple22;
                    }
                    catch (Throwable e) {
                        tuple2 = new Tuple2(topicPartition, (Object)new OffsetFetchResponse.PartitionData(-1L, "", Errors.forException((Throwable)e)));
                    }
                }
                return tuple2;
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            scala.collection.immutable.Map unauthorizedPartitionData = ((TraversableOnce)unauthorizedPartitions2.map((Function1 & Serializable & scala.Serializable)x$33 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$33), (Object)OffsetFetchResponse.UNKNOWN_PARTITION), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            offsetFetchResponse = new OffsetFetchResponse(Errors.NONE, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)authorizedPartitionData.$plus$plus((GenTraversableOnce)unauthorizedPartitionData)).asJava(), (int)header.apiVersion());
        } else if (offsetFetchRequest.isAllPartitions()) {
            Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>> tuple2 = this.coordinator().handleFetchOffsets(offsetFetchRequest.groupId(), this.coordinator().handleFetchOffsets$default$2());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Errors error = (Errors)tuple2._1();
            Map allPartitionData = (Map)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)error, (Object)allPartitionData);
            Tuple2 tuple25 = tuple24;
            Errors error2 = (Errors)tuple25._1();
            Map allPartitionData2 = (Map)tuple25._2();
            Errors errors = error2;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                offsetFetchResponse = offsetFetchRequest.getErrorResponse(error2);
            } else {
                Map authorizedPartitionData = (Map)allPartitionData2.filter((Function1 & Serializable & scala.Serializable)x0$23 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleOffsetFetchRequest$4(this, request, x0$23)));
                offsetFetchResponse = new OffsetFetchResponse(Errors.NONE, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(authorizedPartitionData).asJava(), (int)header.apiVersion());
            }
        } else {
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetFetchRequest.partitions()).asScala()).partition((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)this.authorizeTopicDescribe$1(partition, request)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer authorizedPartitions = (Buffer)tuple2._1();
            Buffer unauthorizedPartitions = (Buffer)tuple2._2();
            Tuple2 tuple26 = new Tuple2((Object)authorizedPartitions, (Object)unauthorizedPartitions);
            Tuple2 tuple27 = tuple26;
            Buffer authorizedPartitions3 = (Buffer)tuple27._1();
            Buffer unauthorizedPartitions3 = (Buffer)tuple27._2();
            Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>> tuple28 = this.coordinator().handleFetchOffsets(offsetFetchRequest.groupId(), (Option<Seq<TopicPartition>>)new Some((Object)authorizedPartitions3));
            if (tuple28 == null) {
                throw new MatchError(tuple28);
            }
            Errors error = (Errors)tuple28._1();
            Map authorizedPartitionData = (Map)tuple28._2();
            Tuple2 tuple29 = new Tuple2((Object)error, (Object)authorizedPartitionData);
            Tuple2 tuple210 = tuple29;
            Errors error3 = (Errors)tuple210._1();
            Map authorizedPartitionData2 = (Map)tuple210._2();
            Errors errors = error3;
            Errors errors3 = Errors.NONE;
            if (errors == null ? errors3 != null : !errors.equals(errors3)) {
                offsetFetchResponse = offsetFetchRequest.getErrorResponse(error3);
            } else {
                scala.collection.immutable.Map unauthorizedPartitionData = ((TraversableOnce)unauthorizedPartitions3.map((Function1 & Serializable & scala.Serializable)x$37 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$37), (Object)OffsetFetchResponse.UNKNOWN_PARTITION), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                offsetFetchResponse = new OffsetFetchResponse(Errors.NONE, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(authorizedPartitionData2.$plus$plus((GenTraversableOnce)unauthorizedPartitionData)).asJava(), (int)header.apiVersion());
            }
        }
        OffsetFetchResponse offsetFetchResponse2 = offsetFetchResponse;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending offset fetch response ", " for correlation id ", " to client ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offsetFetchResponse2, BoxesRunTime.boxToInteger((int)header.correlationId()), header.clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)offsetFetchResponse2));
    }

    public void handleGroupCoordinatorRequest(RequestChannel.Request request) {
        GroupCoordinatorRequest groupCoordinatorRequest = (GroupCoordinatorRequest)request.body();
        if (!this.authorize(request.session(), Describe$.MODULE$, new Resource(Group$.MODULE$, groupCoordinatorRequest.groupId()))) {
            GroupCoordinatorResponse responseBody = new GroupCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED.code(), Node.noNode());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)responseBody));
        } else {
            GroupCoordinatorResponse groupCoordinatorResponse;
            int partition = this.coordinator().partitionFor(groupCoordinatorRequest.groupId());
            MetadataResponse.TopicMetadata offsetsTopicMetadata = this.getOrCreateGroupMetadataTopic(request.listenerName());
            Errors errors = offsetsTopicMetadata.error();
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                groupCoordinatorResponse = new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
            } else {
                Some some;
                Node endpoint;
                Option coordinatorEndpoint = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offsetsTopicMetadata.partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleGroupCoordinatorRequest$1(partition, x$38))).map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.leader());
                Option option = coordinatorEndpoint;
                GroupCoordinatorResponse groupCoordinatorResponse2 = option instanceof Some && !(endpoint = (Node)(some = (Some)option).value()).isEmpty() ? new GroupCoordinatorResponse(Errors.NONE.code(), endpoint) : new GroupCoordinatorResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code(), Node.noNode());
                groupCoordinatorResponse = groupCoordinatorResponse2;
            }
            GroupCoordinatorResponse responseBody = groupCoordinatorResponse;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending consumer metadata %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseBody, BoxesRunTime.boxToInteger((int)request.header().correlationId()), request.header().clientId()})));
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)responseBody));
        }
    }

    public void handleDescribeGroupRequest(RequestChannel.Request request) {
        DescribeGroupsRequest describeRequest = (DescribeGroupsRequest)request.body();
        scala.collection.immutable.Map groups = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeRequest.groupIds()).asScala()).map((Function1 & Serializable & scala.Serializable)groupId -> {
            Tuple2 tuple2;
            if (!this.authorize(request.session(), Describe$.MODULE$, new Resource(Group$.MODULE$, (String)groupId))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupId), (Object)DescribeGroupsResponse.GroupMetadata.forError((Errors)Errors.GROUP_AUTHORIZATION_FAILED));
            } else {
                Tuple2<Errors, GroupSummary> tuple22 = this.coordinator().handleDescribeGroup((String)groupId);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Errors error = (Errors)tuple22._1();
                GroupSummary summary = (GroupSummary)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)error, (Object)summary);
                Tuple2 tuple24 = tuple23;
                Errors error2 = (Errors)tuple24._1();
                GroupSummary summary2 = (GroupSummary)tuple24._2();
                List members = (List)summary2.members().map((Function1 & Serializable & scala.Serializable)member -> {
                    ByteBuffer metadata = ByteBuffer.wrap(member.metadata());
                    ByteBuffer assignment = ByteBuffer.wrap(member.assignment());
                    return new DescribeGroupsResponse.GroupMember(member.memberId(), member.clientId(), member.clientHost(), metadata, assignment);
                }, List$.MODULE$.canBuildFrom());
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupId), (Object)new DescribeGroupsResponse.GroupMetadata(error2.code(), summary2.state(), summary2.protocolType(), summary2.protocol(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)members).asJava()));
            }
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        DescribeGroupsResponse responseBody = new DescribeGroupsResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)groups).asJava());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)responseBody));
    }

    public void handleListGroupsRequest(RequestChannel.Request request) {
        ListGroupsResponse listGroupsResponse;
        if (!this.authorize(request.session(), Describe$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            listGroupsResponse = ListGroupsResponse.fromError((Errors)Errors.CLUSTER_AUTHORIZATION_FAILED);
        } else {
            Tuple2<Errors, List<GroupOverview>> tuple2 = this.coordinator().handleListGroups();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Errors error = (Errors)tuple2._1();
            List groups = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)error, (Object)groups);
            Tuple2 tuple23 = tuple22;
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            List allGroups = (List)groups2.map((Function1 & Serializable & scala.Serializable)group -> new ListGroupsResponse.Group(group.groupId(), group.protocolType()), List$.MODULE$.canBuildFrom());
            listGroupsResponse = new ListGroupsResponse(error2.code(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allGroups).asJava());
        }
        ListGroupsResponse responseBody = listGroupsResponse;
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)responseBody));
    }

    public void handleJoinGroupRequest(RequestChannel.Request request) {
        JoinGroupRequest joinGroupRequest = (JoinGroupRequest)request.body();
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, joinGroupRequest.groupId()))) {
            JoinGroupResponse responseBody = new JoinGroupResponse((int)request.header().apiVersion(), Errors.GROUP_AUTHORIZATION_FAILED.code(), -1, "", "", "", Collections.emptyMap());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)responseBody));
        } else {
            List protocols = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(joinGroupRequest.groupProtocols()).asScala()).map((Function1 & Serializable & scala.Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)Utils.toArray((ByteBuffer)protocol.metadata())), Buffer$.MODULE$.canBuildFrom())).toList();
            this.coordinator().handleJoinGroup(joinGroupRequest.groupId(), joinGroupRequest.memberId(), request.header().clientId(), request.session().clientAddress().toString(), joinGroupRequest.rebalanceTimeout(), joinGroupRequest.sessionTimeout(), joinGroupRequest.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)joinResult -> {
                this.sendResponseCallback$4(joinResult, request);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleSyncGroupRequest(RequestChannel.Request request) {
        SyncGroupRequest syncGroupRequest = (SyncGroupRequest)request.body();
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, syncGroupRequest.groupId()))) {
            this.sendResponseCallback$5((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.GROUP_AUTHORIZATION_FAILED.code(), request);
        } else {
            this.coordinator().handleSyncGroup(syncGroupRequest.groupId(), syncGroupRequest.generationId(), syncGroupRequest.memberId(), (Map<String, byte[]>)((scala.collection.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(syncGroupRequest.groupAssignment()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> Utils.toArray((ByteBuffer)x$1)), (Function2<byte[], Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(memberState, errorCode) -> {
                this.sendResponseCallback$5(memberState, BoxesRunTime.unboxToShort((Object)errorCode), request);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleHeartbeatRequest(RequestChannel.Request request) {
        HeartbeatRequest heartbeatRequest = (HeartbeatRequest)request.body();
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, heartbeatRequest.groupId()))) {
            HeartbeatResponse heartbeatResponse = new HeartbeatResponse(Errors.GROUP_AUTHORIZATION_FAILED.code());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)heartbeatResponse));
        } else {
            this.coordinator().handleHeartbeat(heartbeatRequest.groupId(), heartbeatRequest.memberId(), heartbeatRequest.groupGenerationId(), (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)errorCode -> {
                this.sendResponseCallback$6(BoxesRunTime.unboxToShort((Object)errorCode), request);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleLeaveGroupRequest(RequestChannel.Request request) {
        LeaveGroupRequest leaveGroupRequest = (LeaveGroupRequest)request.body();
        if (!this.authorize(request.session(), Read$.MODULE$, new Resource(Group$.MODULE$, leaveGroupRequest.groupId()))) {
            LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(Errors.GROUP_AUTHORIZATION_FAILED.code());
            this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)leaveGroupResponse));
        } else {
            this.coordinator().handleLeaveGroup(leaveGroupRequest.groupId(), leaveGroupRequest.memberId(), (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)errorCode -> {
                this.sendResponseCallback$7(BoxesRunTime.unboxToShort((Object)errorCode), request);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleSaslHandshakeRequest(RequestChannel.Request request) {
        SaslHandshakeResponse response = new SaslHandshakeResponse(Errors.ILLEGAL_SASL_STATE.code(), this.config().saslEnabledMechanisms());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)response));
    }

    public void handleApiVersionsRequest(RequestChannel.Request request) {
        ApiVersionsResponse responseBody = Protocol.apiVersionSupported((short)ApiKeys.API_VERSIONS.id, (short)request.header().apiVersion()) ? ApiVersionsResponse.API_VERSIONS_RESPONSE : ApiVersionsResponse.fromError((Errors)Errors.UNSUPPORTED_VERSION);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, (AbstractResponse)responseBody));
    }

    public void close() {
        this.quotas().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    public void handleCreateTopicsRequest(RequestChannel.Request request) {
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body();
        if (!this.controller().isActive()) {
            scala.collection.mutable.Map results2 = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(createTopicsRequest.topics()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$25 -> {
                Tuple2 tuple2 = x0$25;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                Tuple2 tuple22 = new Tuple2((Object)topic, (Object)new CreateTopicsResponse.Error(Errors.NOT_CONTROLLER, null));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            this.sendResponseCallback$8((Map)results2, request);
        } else if (!this.authorize(request.session(), Create$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            scala.collection.mutable.Map results3 = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(createTopicsRequest.topics()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$26 -> {
                Tuple2 tuple2 = x0$26;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                Tuple2 tuple22 = new Tuple2((Object)topic, (Object)new CreateTopicsResponse.Error(Errors.CLUSTER_AUTHORIZATION_FAILED, null));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            this.sendResponseCallback$8((Map)results3, request);
        } else {
            Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(createTopicsRequest.topics()).asScala()).partition((Function1 & Serializable & scala.Serializable)x0$27 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleCreateTopicsRequest$4(createTopicsRequest, x0$27)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.mutable.Map validTopics = (scala.collection.mutable.Map)tuple2._1();
            scala.collection.mutable.Map duplicateTopics = (scala.collection.mutable.Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)validTopics, (Object)duplicateTopics);
            Tuple2 tuple23 = tuple22;
            scala.collection.mutable.Map validTopics2 = (scala.collection.mutable.Map)tuple23._1();
            scala.collection.mutable.Map duplicateTopics2 = (scala.collection.mutable.Map)tuple23._2();
            this.adminManager().createTopics(createTopicsRequest.timeout(), createTopicsRequest.validateOnly(), (Map<String, CreateTopicsRequest.TopicDetails>)validTopics2, (Function1<Map<String, CreateTopicsResponse.Error>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)results -> {
                this.sendResponseWithDuplicatesCallback$1(results, request, duplicateTopics2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void handleDeleteTopicsRequest(RequestChannel.Request request) {
        DeleteTopicsRequest deleteTopicRequest = (DeleteTopicsRequest)request.body();
        Tuple2 tuple2 = ((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(deleteTopicRequest.topics()).asScala()).partition((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleDeleteTopicsRequest$1(this, request, topic)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set existingAndAuthorizedForDescribeTopics = (Set)tuple2._1();
        Set nonExistingOrUnauthorizedForDescribeTopics = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingAndAuthorizedForDescribeTopics, (Object)nonExistingOrUnauthorizedForDescribeTopics);
        Tuple2 tuple23 = tuple22;
        Set existingAndAuthorizedForDescribeTopics2 = (Set)tuple23._1();
        Set nonExistingOrUnauthorizedForDescribeTopics2 = (Set)tuple23._2();
        Tuple2 tuple24 = existingAndAuthorizedForDescribeTopics2.partition((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)this.authorize(request.session(), Delete$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topic))));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Set authorizedTopics = (Set)tuple24._1();
        Set unauthorizedForDeleteTopics = (Set)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)authorizedTopics, (Object)unauthorizedForDeleteTopics);
        Tuple2 tuple26 = tuple25;
        Set authorizedTopics2 = (Set)tuple26._1();
        Set unauthorizedForDeleteTopics2 = (Set)tuple26._2();
        if (!this.controller().isActive()) {
            scala.collection.immutable.Map results2 = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(deleteTopicRequest.topics()).asScala()).map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)Errors.NOT_CONTROLLER), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.sendResponseCallback$9((Map)results2, request, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForDeleteTopics2);
        } else if (authorizedTopics2.isEmpty()) {
            this.sendResponseCallback$9((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$), request, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForDeleteTopics2);
        } else {
            this.adminManager().deleteTopics(Predef$.MODULE$.Integer2int(deleteTopicRequest.timeout()), (scala.collection.Set<String>)authorizedTopics2, (Function1<Map<String, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)results -> {
                this.sendResponseCallback$9(results, request, nonExistingOrUnauthorizedForDescribeTopics2, unauthorizedForDeleteTopics2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void authorizeClusterAction(RequestChannel.Request request) {
        if (!this.authorize(request.session(), ClusterAction$.MODULE$, Resource$.MODULE$.ClusterResource())) {
            throw new ClusterAuthorizationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " is not authorized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request})));
        }
    }

    public static final /* synthetic */ void $anonfun$handleLeaderAndIsrRequest$1(KafkaApis $this, Partition partition) {
        block0: {
            String string = partition.topic();
            String string2 = Topic$.MODULE$.GroupMetadataTopicName();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            $this.coordinator().handleGroupImmigration(partition.partitionId());
        }
    }

    public static final /* synthetic */ void $anonfun$handleLeaderAndIsrRequest$2(KafkaApis $this, Partition partition) {
        block0: {
            String string = partition.topic();
            String string2 = Topic$.MODULE$.GroupMetadataTopicName();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            $this.coordinator().handleGroupEmigration(partition.partitionId());
        }
    }

    private final void onLeadershipChange$1(Iterable updatedLeaders, Iterable updatedFollowers) {
        updatedLeaders.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            KafkaApis.$anonfun$handleLeaderAndIsrRequest$1(this, partition);
            return BoxedUnit.UNIT;
        });
        updatedFollowers.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            KafkaApis.$anonfun$handleLeaderAndIsrRequest$2(this, partition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Short $anonfun$handleLeaderAndIsrRequest$4(short x$1) {
        return new Short(x$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$handleStopReplicaRequest$1(KafkaApis $this, StopReplicaRequest stopReplicaRequest$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var4_3 = x0$1;
                if (var4_3 == null) break block2;
                topicPartition = (TopicPartition)var4_3._1();
                errorCode = BoxesRunTime.unboxToShort((Object)var4_3._2());
                if (errorCode != Errors.NONE.code() || !stopReplicaRequest$1.deletePartitions()) ** GOTO lbl-1000
                v0 = topicPartition.topic();
                var7_6 = Topic$.MODULE$.GroupMetadataTopicName();
                if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                    $this.coordinator().handleGroupEmigration(topicPartition.partition());
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                break block3;
            }
            throw new MatchError((Object)var4_3);
        }
        var3_7 = v1;
    }

    public static final /* synthetic */ void $anonfun$handleUpdateMetadataRequest$2(KafkaApis $this, String topic) {
        $this.adminManager().tryCompleteDelayedTopicOperations(topic);
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetCommitRequest$2(KafkaApis $this, RequestChannel.Request request$5, RequestHeader header$1, Tuple2 x0$2) {
        boolean exists;
        boolean authorizedForDescribe;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            authorizedForDescribe = $this.authorize(request$5.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
            exists = $this.metadataCache().contains(topicPartition.topic());
            if (!authorizedForDescribe && exists) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset commit request with correlation id ", " from client ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)header$1.correlationId()), header$1.clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition ", " failing due to user not having DESCRIBE authorization, but returning UNKNOWN_TOPIC_OR_PARTITION"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = authorizedForDescribe && exists;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetCommitRequest$4(KafkaApis $this, RequestChannel.Request request$5, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$5.session(), Read$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
        return bl;
    }

    public static final /* synthetic */ Short $anonfun$handleOffsetCommitRequest$5(short x$8) {
        return new Short(x$8);
    }

    public static final /* synthetic */ void $anonfun$handleOffsetCommitRequest$8(KafkaApis $this, RequestHeader header$1, Tuple2 x0$4) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            Short errorCode = (Short)tuple2._2();
            if (!BoxesRunTime.equalsNumObject((Number)errorCode, (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code()))) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset commit request with correlation id ", " from client ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)header$1.correlationId()), header$1.clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, Errors.forCode((short)Predef$.MODULE$.Short2short(errorCode)).exceptionName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final void sendResponseCallback$1(scala.collection.immutable.Map commitStatus, RequestChannel.Request request$5, RequestHeader header$1, scala.collection.immutable.Map nonExistingOrUnauthorizedForDescribeTopics$1, scala.collection.immutable.Map unauthorizedForReadTopics$1) {
        scala.collection.immutable.Map combinedCommitStatus = commitStatus.mapValues((Function1 & Serializable & scala.Serializable)x$8 -> KafkaApis.$anonfun$handleOffsetCommitRequest$5(BoxesRunTime.unboxToShort((Object)x$8))).$plus$plus((GenTraversableOnce)unauthorizedForReadTopics$1.mapValues((Function1 & Serializable & scala.Serializable)x$9 -> new Short(Errors.TOPIC_AUTHORIZATION_FAILED.code()))).$plus$plus((GenTraversableOnce)nonExistingOrUnauthorizedForDescribeTopics$1.mapValues((Function1 & Serializable & scala.Serializable)x$10 -> new Short(Errors.UNKNOWN_TOPIC_OR_PARTITION.code())));
        if (this.isDebugEnabled()) {
            combinedCommitStatus.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                KafkaApis.$anonfun$handleOffsetCommitRequest$8(this, header$1, x0$4);
                return BoxedUnit.UNIT;
            });
        }
        OffsetCommitResponse response = new OffsetCommitResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)combinedCommitStatus).asJava());
        this.requestChannel().sendResponse(new RequestChannel.Response(request$5, (AbstractResponse)response));
    }

    public static final /* synthetic */ boolean $anonfun$handleProducerRequest$1(KafkaApis $this, RequestChannel.Request request$2, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$2.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, tp.topic())) && $this.metadataCache().contains(tp.topic());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleProducerRequest$2(KafkaApis $this, RequestChannel.Request request$2, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$2.session(), Write$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, tp.topic()));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$handleProducerRequest$5(KafkaApis $this, RequestChannel.Request request$2, BooleanRef errorInResponse$1, Tuple2 x0$8) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)tuple2._2();
            Errors errors = status.error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                errorInResponse$1.elem = true;
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)request$2.header().correlationId()), request$2.header().clientId(), topicPartition, status$1.error.exceptionName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final void produceResponseCallback$1(int delayTimeMs, RequestChannel.Request request$2, ProduceRequest produceRequest$1, Map mergedResponseStatus$1, BooleanRef errorInResponse$1) {
        if (produceRequest$1.acks() == 0) {
            if (errorInResponse$1.elem) {
                String exceptionsSummary = ((TraversableOnce)mergedResponseStatus$1.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                    Tuple2 tuple2 = x0$9;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)status.error.exceptionName());
                    return tuple22;
                }, scala.collection.Map$.MODULE$.canBuildFrom())).mkString(", ");
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing connection due to error during produce request with correlation id ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)request$2.header().correlationId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from client id ", " with ack=0\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request$2.header().clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic and partition to exceptions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exceptionsSummary})));
                this.requestChannel().closeConnection(request$2.processor(), request$2);
            } else {
                this.requestChannel().noOperation(request$2.processor(), request$2);
            }
        } else {
            ProduceResponse produceResponse;
            short s = request$2.header().apiVersion();
            switch (s) {
                case 0: {
                    produceResponse = new ProduceResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseStatus$1).asJava());
                    break;
                }
                case 1: 
                case 2: {
                    produceResponse = new ProduceResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(mergedResponseStatus$1).asJava(), delayTimeMs, (int)s);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Version `", "` of ProduceRequest is not handled. Code must be updated."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)s)})));
                }
            }
            ProduceResponse respBody = produceResponse;
            this.requestChannel().sendResponse(new RequestChannel.Response(request$2, (AbstractResponse)respBody));
        }
    }

    private final void sendResponseCallback$2(Map responseStatus, RequestChannel.Request request$2, ProduceRequest produceRequest$1, int numBytesAppended$1, scala.collection.mutable.Map nonExistingOrUnauthorizedForDescribeTopics$2, scala.collection.mutable.Map unauthorizedForWriteRequestInfo$1) {
        Map mergedResponseStatus = responseStatus.$plus$plus((GenTraversableOnce)unauthorizedForWriteRequestInfo$1.mapValues((Function1 & Serializable & scala.Serializable)x$14 -> new ProduceResponse.PartitionResponse(Errors.TOPIC_AUTHORIZATION_FAILED))).$plus$plus((GenTraversableOnce)nonExistingOrUnauthorizedForDescribeTopics$2.mapValues((Function1 & Serializable & scala.Serializable)x$15 -> new ProduceResponse.PartitionResponse(Errors.UNKNOWN_TOPIC_OR_PARTITION)));
        BooleanRef errorInResponse = BooleanRef.create((boolean)false);
        mergedResponseStatus.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            KafkaApis.$anonfun$handleProducerRequest$5(this, request$2, errorInResponse, x0$8);
            return BoxedUnit.UNIT;
        });
        request$2.apiRemoteCompleteTimeMs_$eq(this.time.milliseconds());
        this.quotas().produce().recordAndMaybeThrottle(request$2.session().sanitizedUser(), request$2.header().clientId(), numBytesAppended$1, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.produceResponseCallback$1(delayTimeMs, request$2, produceRequest$1, mergedResponseStatus, errorInResponse));
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchRequest$1(KafkaApis $this, RequestChannel.Request request$3, Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$3.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, tp.topic())) && $this.metadataCache().contains(tp.topic());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchRequest$2(KafkaApis $this, RequestChannel.Request request$3, Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$3.session(), Read$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, tp.topic()));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchRequest$7(byte x$19) {
        return x$19 > 0;
    }

    public static final /* synthetic */ void $anonfun$handleFetchRequest$9(KafkaApis $this, RequestChannel.Request request$3, String clientId$1, LinkedHashMap fetchedPartitionData$1, Tuple2 x0$16) {
        FetchResponse.PartitionData data;
        TopicPartition topicPartition;
        Tuple2 tuple2 = x0$16;
        if (tuple2 != null) {
            topicPartition = (TopicPartition)tuple2._1();
            data = (FetchResponse.PartitionData)tuple2._2();
            if (data.errorCode != Errors.NONE.code()) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch request with correlation id ", " from client ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)request$3.header().correlationId()), clientId$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, Errors.forCode((short)data$1.errorCode).exceptionName()})));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        fetchedPartitionData$1.put(topicPartition, data);
        BrokerTopicStats$.MODULE$.getBrokerTopicStats(topicPartition.topic()).bytesOutRate().mark((long)data.records.sizeInBytes());
        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesOutRate().mark((long)data.records.sizeInBytes());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$handleFetchRequest$12(Tuple2 x0$17) {
        Tuple2 tuple2 = x0$17;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FetchResponse.PartitionData v = (FetchResponse.PartitionData)tuple2._2();
        int n = v.records.sizeInBytes();
        return n;
    }

    private final void fetchResponseCallback$1(int delayTimeMs, RequestChannel.Request request$3, short versionId$1, String clientId$1, Seq convertedPartitionData$1, LinkedHashMap fetchedPartitionData$1, FetchResponse response$1) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending fetch response to client ", " of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientId$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)convertedPartitionData$1.map((Function1 & Serializable & scala.Serializable)x0$17 -> BoxesRunTime.boxToInteger((int)KafkaApis.$anonfun$handleFetchRequest$12(x0$17)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)})));
        FetchResponse fetchResponse = delayTimeMs > 0 ? new FetchResponse((int)versionId$1, fetchedPartitionData$1, delayTimeMs) : response$1;
        this.requestChannel().sendResponse(new RequestChannel.Response(request$3, (AbstractResponse)fetchResponse));
    }

    private final void sendResponseCallback$3(Seq responsePartitionData, RequestChannel.Request request$3, FetchRequest fetchRequest$1, short versionId$1, String clientId$1, Seq clusterUnauthorizedPartitionData$1, Seq nonExistingOrUnauthorizedForDescribePartitionData$1, Seq unauthorizedForReadPartitionData$1) {
        Seq convertedPartitionData = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$15 -> {
            FetchPartitionData fetchPartitionData;
            TopicPartition tp;
            Tuple2 tuple2 = x0$15;
            if (tuple2 != null) {
                tp = (TopicPartition)tuple2._1();
                FetchPartitionData data = (FetchPartitionData)tuple2._2();
                if (versionId$1 <= 1 && this.replicaManager().getMagic(tp).exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)KafkaApis.$anonfun$handleFetchRequest$7(BoxesRunTime.unboxToByte((Object)x$19)))) && !data.records().hasMatchingShallowMagic((byte)0)) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Down converting message to V0 for fetch request from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientId$1})));
                    fetchPartitionData = new FetchPartitionData(data.error(), data.hw(), data.records().toMessageFormat((byte)0));
                } else {
                    fetchPartitionData = data;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            FetchPartitionData convertedData = fetchPartitionData;
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(convertedData.error().code(), convertedData.hw(), convertedData.records()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Seq mergedPartitionData = (Seq)((TraversableLike)((TraversableLike)convertedPartitionData.$plus$plus((GenTraversableOnce)unauthorizedForReadPartitionData$1, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)nonExistingOrUnauthorizedForDescribePartitionData$1, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)clusterUnauthorizedPartitionData$1, Seq$.MODULE$.canBuildFrom());
        LinkedHashMap fetchedPartitionData = new LinkedHashMap();
        mergedPartitionData.foreach((Function1 & Serializable & scala.Serializable)x0$16 -> {
            KafkaApis.$anonfun$handleFetchRequest$9(this, request$3, clientId$1, fetchedPartitionData, x0$16);
            return BoxedUnit.UNIT;
        });
        FetchResponse response = new FetchResponse((int)versionId$1, fetchedPartitionData, 0);
        request$3.apiRemoteCompleteTimeMs_$eq(this.time.milliseconds());
        if (fetchRequest$1.isFromFollower()) {
            int responseSize = this.sizeOfThrottledPartitions(versionId$1, fetchRequest$1, (Seq<Tuple2<TopicPartition, FetchResponse.PartitionData>>)mergedPartitionData, this.quotas().leader());
            this.quotas().leader().record(responseSize);
            this.fetchResponseCallback$1(0, request$3, versionId$1, clientId$1, convertedPartitionData, fetchedPartitionData, response);
        } else {
            this.quotas().fetch().recordAndMaybeThrottle(request$3.session().sanitizedUser(), clientId$1, response.sizeOf(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)delayTimeMs -> this.fetchResponseCallback$1(delayTimeMs, request$3, versionId$1, clientId$1, convertedPartitionData, fetchedPartitionData, response));
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetRequestV0$1(KafkaApis $this, RequestChannel.Request request$15, Tuple2 x0$19) {
        Tuple2 tuple2 = x0$19;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$15.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
        return bl;
    }

    public static final /* synthetic */ Long $anonfun$handleOffsetRequestV0$6(long x$25) {
        return new Long(x$25);
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetRequestV1$1(KafkaApis $this, RequestChannel.Request request$16, Tuple2 x0$21) {
        Tuple2 tuple2 = x0$21;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorize(request$16.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topicPartition.topic()));
        return bl;
    }

    private static final boolean allowed$1(TimestampOffset timestampOffset, boolean fromConsumer$1, Replica localReplica$1) {
        return !fromConsumer$1 || timestampOffset.offset() <= localReplica$1.highWatermark().messageOffset();
    }

    private final boolean authorizeTopicDescribe$1(TopicPartition partition, RequestChannel.Request request$6) {
        return this.authorize(request$6.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, partition.topic()));
    }

    public static final /* synthetic */ boolean $anonfun$handleOffsetFetchRequest$4(KafkaApis $this, RequestChannel.Request request$6, Tuple2 x0$23) {
        Tuple2 tuple2 = x0$23;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.authorizeTopicDescribe$1(topicPartition, request$6);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleGroupCoordinatorRequest$1(int partition$1, MetadataResponse.PartitionMetadata x$38) {
        return x$38.partition() == partition$1;
    }

    private final void sendResponseCallback$4(JoinGroupResult joinResult, RequestChannel.Request request$8) {
        Map members = (Map)joinResult.members().map((Function1 & Serializable & scala.Serializable)x0$24 -> {
            Tuple2 tuple2 = x0$24;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String memberId = (String)tuple2._1();
            byte[] metadataArray = (byte[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)memberId, (Object)ByteBuffer.wrap(metadataArray));
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        JoinGroupResponse responseBody = new JoinGroupResponse((int)request$8.header().apiVersion(), joinResult.errorCode(), joinResult.generationId(), joinResult.subProtocol(), joinResult.memberId(), joinResult.leaderId(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(members).asJava());
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending join group response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseBody, BoxesRunTime.boxToInteger((int)request$8.header().correlationId()), request$8.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$8, (AbstractResponse)responseBody));
    }

    private final void sendResponseCallback$5(byte[] memberState, short errorCode, RequestChannel.Request request$11) {
        SyncGroupResponse responseBody = new SyncGroupResponse(errorCode, ByteBuffer.wrap(memberState));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$11, (AbstractResponse)responseBody));
    }

    private final void sendResponseCallback$6(short errorCode, RequestChannel.Request request$9) {
        HeartbeatResponse response = new HeartbeatResponse(errorCode);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending heartbeat response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response, BoxesRunTime.boxToInteger((int)request$9.header().correlationId()), request$9.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$9, (AbstractResponse)response));
    }

    private final void sendResponseCallback$7(short errorCode, RequestChannel.Request request$10) {
        LeaveGroupResponse response = new LeaveGroupResponse(errorCode);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending leave group response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response, BoxesRunTime.boxToInteger((int)request$10.header().correlationId()), request$10.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$10, (AbstractResponse)response));
    }

    private final void sendResponseCallback$8(Map results, RequestChannel.Request request$13) {
        CreateTopicsResponse responseBody = new CreateTopicsResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(results).asJava(), request$13.header().apiVersion());
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending create topics response ", " for correlation id ", " to client ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseBody, BoxesRunTime.boxToInteger((int)request$13.header().correlationId()), request$13.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$13, (AbstractResponse)responseBody));
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$4(CreateTopicsRequest createTopicsRequest$1, Tuple2 x0$27) {
        Tuple2 tuple2 = x0$27;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String topic = (String)tuple2._1();
        boolean bl = !createTopicsRequest$1.duplicateTopics().contains(topic);
        return bl;
    }

    private final void sendResponseWithDuplicatesCallback$1(Map results, RequestChannel.Request request$13, scala.collection.mutable.Map duplicateTopics$1) {
        scala.collection.immutable.Map map;
        if (duplicateTopics$1.nonEmpty()) {
            String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create topics request from client `", "` contains multiple entries "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request$13.header().clientId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for the following topics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopics$1.keySet().mkString(",")}));
            if (request$13.header().apiVersion() == 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            }
            map = ((TraversableOnce)duplicateTopics$1.keySet().map((Function1 & Serializable & scala.Serializable)x$43 -> new Tuple2(x$43, (Object)new CreateTopicsResponse.Error(Errors.INVALID_REQUEST, errorMessage)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = scala.collection.Map$.MODULE$.empty();
        }
        scala.collection.immutable.Map duplicatedTopicsResults = map;
        Map completeResults = results.$plus$plus((GenTraversableOnce)duplicatedTopicsResults);
        this.sendResponseCallback$8(completeResults, request$13);
    }

    public static final /* synthetic */ boolean $anonfun$handleDeleteTopicsRequest$1(KafkaApis $this, RequestChannel.Request request$14, String topic) {
        return $this.authorize(request$14.session(), Describe$.MODULE$, new Resource(kafka.security.auth.Topic$.MODULE$, topic)) && $this.metadataCache().contains(topic);
    }

    private final void sendResponseCallback$9(Map results, RequestChannel.Request request$14, Set nonExistingOrUnauthorizedForDescribeTopics$3, Set unauthorizedForDeleteTopics$1) {
        scala.collection.immutable.Map completeResults = ((TraversableOnce)nonExistingOrUnauthorizedForDescribeTopics$3.map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)unauthorizedForDeleteTopics$1.map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)Errors.TOPIC_AUTHORIZATION_FAILED), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)results);
        DeleteTopicsResponse responseBody = new DeleteTopicsResponse((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)completeResults).asJava());
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending delete topics response ", " for correlation id ", " to client ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseBody, BoxesRunTime.boxToInteger((int)request$14.header().correlationId()), request$14.header().clientId()})));
        this.requestChannel().sendResponse(new RequestChannel.Response(request$14, (AbstractResponse)responseBody));
    }

    public KafkaApis(RequestChannel requestChannel, ReplicaManager replicaManager, AdminManager adminManager, GroupCoordinator coordinator, KafkaController controller, ZkUtils zkUtils, int brokerId, KafkaConfig config, MetadataCache metadataCache, Metrics metrics, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, String clusterId, Time time) {
        this.requestChannel = requestChannel;
        this.replicaManager = replicaManager;
        this.adminManager = adminManager;
        this.coordinator = coordinator;
        this.controller = controller;
        this.zkUtils = zkUtils;
        this.brokerId = brokerId;
        this.config = config;
        this.metadataCache = metadataCache;
        this.metrics = metrics;
        this.authorizer = authorizer;
        this.quotas = quotas;
        this.clusterId = clusterId;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("[KafkaApi-%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
    }
}

