/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\b\t\u0003A!j\u0011!\t\u0006\u0003E\r\naaY8n[>t'BA\u0003%\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%\n#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tW\u0001\u0011\t\u0011)A\u0005?\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0011!\u0018.\\3\u0011\u0005=\nT\"\u0001\u0019\u000b\u0005E\t\u0013B\u0001\u001a1\u0005\u0011!\u0016.\\3\t\u0011Q\u0002!\u0011!Q\u0001\nU\n\u0011$\u001b8ji&\fG\u000eS5hQ^\u000bG/\u001a:nCJ\\g+\u00197vKB\u0011\u0011BN\u0005\u0003o)\u0011A\u0001T8oO\"A\u0011\b\u0001BC\u0002\u0013\u0005!(A\u0002m_\u001e,\u0012a\u000f\t\u0004\u0013qr\u0014BA\u001f\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011q(Q\u0007\u0002\u0001*\u0011\u0011\bB\u0005\u0003\u0005\u0002\u00131\u0001T8h\u0011!!\u0005A!A!\u0002\u0013Y\u0014\u0001\u00027pO\u0002BQA\u0012\u0001\u0005\u0002\u001d\u000ba\u0001P5oSRtDC\u0002%K\u00172ke\n\u0005\u0002J\u00015\t!\u0001C\u0003\u0016\u000b\u0002\u0007q\u0003C\u0003\u001e\u000b\u0002\u0007q\u0004C\u0004.\u000bB\u0005\t\u0019\u0001\u0018\t\u000fQ*\u0005\u0013!a\u0001k!9\u0011(\u0012I\u0001\u0002\u0004Y\u0004B\u0002)\u0001A\u0003&\u0011+A\u000biS\u001eDw+\u0019;fe6\f'o['fi\u0006$\u0017\r^1\u0011\u0005I+V\"A*\u000b\u0005Q#\u0011AB:feZ,'/\u0003\u0002W'\n\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1)\u0005=C\u0006CA\u0005Z\u0013\tQ&B\u0001\u0005w_2\fG/\u001b7f\u0011\u0019a\u0006\u0001)Q\u0005#\u0006!Bn\\4F]\u0012|eMZ:fi6+G/\u00193bi\u0006D#a\u0017-\t\r}\u0003\u0001\u0015)\u00036\u0003=yFn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bF\u00010Y\u0011\u0019\u0011\u0007\u0001)Q\u0005k\u0005YB.Y:u\r\u0016$8\r\u001b'fC\u0012,'\u000fT8h\u000b:$wJ\u001a4tKRD#!\u0019-\t\r\u0015\u0004\u0001\u0015)\u00036\u0003=a\u0017m\u001d;GKR\u001c\u0007\u000eV5nK6\u001b\bF\u00013Y\u0011\u0019A\u0007\u0001)Q\u0005k\u0005\u0019r\f\\1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3Ng\"\u0012q\r\u0017\u0005\u0006W\u0002!\t\u0001\\\u0001\bSNdunY1m+\u0005i\u0007CA\u0005o\u0013\ty'BA\u0004C_>dW-\u00198\t\u000bE\u0004A\u0011\u0001:\u0002%1\f7\u000f^\"bk\u001eDG/\u00169US6,Wj]\u000b\u0002k!9A\u000f\u0001b\u0001\n\u0003)\u0018AB3q_\u000eD7/F\u0001w!\rIAh\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003uN\u000bQ!\u001a9pG\"L!\u0001`=\u0003!1+\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007B\u0002@\u0001A\u0003%a/A\u0004fa>\u001c\u0007n\u001d\u0011\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u0005\u0019R\u000f\u001d3bi\u0016dun\u001a*fC\u0012\u0014Vm];miR!\u0011QAA\u0006!\rI\u0011qA\u0005\u0004\u0003\u0013Q!\u0001B+oSRDq!!\u0004\u0000\u0001\u0004\ty!A\u0007m_\u001e\u0014V-\u00193SKN,H\u000e\u001e\t\u0004%\u0006E\u0011bAA\n'\niAj\\4SK\u0006$'+Z:vYRDq!a\u0006\u0001\t\u0003\tI\"A\u000bsKN,G\u000fT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3\u0015\u0011\u0005\u0015\u00111DA\u0010\u0003GAq!!\b\u0002\u0016\u0001\u0007Q'A\u000bdkJdU-\u00193fe2{w-\u00128e\u001f\u001a47/\u001a;\t\u000f\u0005\u0005\u0012Q\u0003a\u0001k\u0005I1-\u001e:US6,Wj\u001d\u0005\u0007c\u0006U\u0001\u0019A\u001b\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*\u0005\u0001Bn\\4F]\u0012|eMZ:fi~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0003C\u0004\u0002.\u0005\u0015\u0002\u0019A)\u0002\u001f9,w\u000fT8h\u000b:$wJ\u001a4tKRDq!!\r\u0001\t\u0003\t\u0019$\u0001\u0007m_\u001e,e\u000eZ(gMN,G/F\u0001R\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\tA$\\1zE\u0016Len\u0019:f[\u0016tG\u000fT8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0002\u0006\u0005m\u0002bBA\u001f\u0003k\u0001\r!N\u0001\u0012]\u0016<Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bbBA!\u0001\u0011%\u00111I\u0001\u0013Y><7\u000b^1si>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005\u0015\u0003bBA\u001f\u0003\u007f\u0001\r!\u000e\u0005\u0007\u0003\u0013\u0002A\u0011\u0001:\u0002\u001d1|wm\u0015;beR|eMZ:fi\"9\u0011Q\n\u0001\u0005\u0002\u0005=\u0013!\u00055jO\"<\u0016\r^3s[\u0006\u00148n\u0018\u0013fcR!\u0011QAA)\u0011\u001d\t\u0019&a\u0013A\u0002E\u000b\u0001C\\3x\u0011&<\u0007nV1uKJl\u0017M]6\t\u000f\u0005]\u0003\u0001\"\u0001\u00024\u0005i\u0001.[4i/\u0006$XM]7be.Dq!a\u0017\u0001\t\u0003\t\u0019$\u0001\tmCN$8\u000b^1cY\u0016|eMZ:fi\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014AH2p]Z,'\u000f\u001e%X)>dunY1m\u001f\u001a47/\u001a;NKR\fG-\u0019;b)\t\t)\u0001C\u0004\u0002f\u0001!\t%a\u001a\u0002\r\u0015\fX/\u00197t)\ri\u0017\u0011\u000e\u0005\t\u0003W\n\u0019\u00071\u0001\u0002n\u0005!A\u000f[1u!\rI\u0011qN\u0005\u0004\u0003cR!aA!os\"9\u0011Q\u000f\u0001\u0005B\u0005]\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003]Aq!a\u001f\u0001\t\u0003\ni(\u0001\u0005u_N#(/\u001b8h)\t\ty\b\u0005\u0003\u0002\u0002\u0006=e\u0002BAB\u0003\u0017\u00032!!\"\u000b\u001b\t\t9IC\u0002\u0002\n\u001a\ta\u0001\u0010:p_Rt\u0014bAAG\u0015\u00051\u0001K]3eK\u001aLA!!%\u0002\u0014\n11\u000b\u001e:j]\u001eT1!!$\u000b\u000f%\t9JAA\u0001\u0012\u0003\tI*A\u0004SKBd\u0017nY1\u0011\u0007%\u000bYJ\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAO'\r\tY\n\u0003\u0005\b\r\u0006mE\u0011AAQ)\t\tI\n\u0003\u0006\u0002&\u0006m\u0015\u0013!C\u0001\u0003O\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAAUU\rq\u00131V\u0016\u0003\u0003[\u0003B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0017\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002<\u0006E&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011qXAN#\u0003%\t!!1\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019MK\u00026\u0003WC!\"a2\u0002\u001cF\u0005I\u0011AAe\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\u001a\u0016\u0004w\u0005-\u0006")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private final long initialHighWatermarkValue;
    private final Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    private volatile LogOffsetMetadata logEndOffsetMetadata;
    private volatile long _logStartOffset;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private final Option<LeaderEpochCache> epochs;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public boolean isLocal() {
        return this.log().isDefined();
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public Option<LeaderEpochCache> epochs() {
        return this.epochs;
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= logReadResult.leaderLogEndOffset()) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, logReadResult.fetchTimeMs());
        } else if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this.lastFetchTimeMs);
        }
        this.logStartOffset_$eq(logReadResult.followerLogStartOffset());
        this.logEndOffset_$eq(logReadResult.info().fetchOffsetMetadata());
        this.lastFetchLeaderLogEndOffset = logReadResult.leaderLogEndOffset();
        this.lastFetchTimeMs = logReadResult.fetchTimeMs();
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this.lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
    }

    private void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log end offset on partition ", "'s local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log end offset for replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topicPartition(), $this.logEndOffsetMetadata})));
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.logEndOffsetMetadata;
    }

    public void maybeIncrementLogStartOffset(long newLogStartOffset) {
        if (this.isLocal()) {
            if (newLogStartOffset > this.highWatermark().messageOffset()) {
                throw new OffsetOutOfRangeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot increment the log start offset to ", " of partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset), this.topicPartition()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since it is larger than the high watermark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.highWatermark().messageOffset())})));
            }
        } else {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not try to delete records on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        ((Log)this.log().get()).maybeIncrementLogStartOffset(newLogStartOffset);
    }

    private void logStartOffset_$eq(long newLogStartOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set log start offset on partition ", "'s local replica ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"without attempting to delete records of the log"})).s((Seq)Nil$.MODULE$));
        }
        this._logStartOffset = newLogStartOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting log start offset for remote replica ", " for partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topicPartition(), BoxesRunTime.boxToLong((long)newLogStartOffset)})));
    }

    public long logStartOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logStartOffset() : this._logStartOffset;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (!this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not set high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.highWatermarkMetadata = newHighWatermark;
        this.log().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.onHighWatermarkIncremented(newHighWatermark.messageOffset());
            return BoxedUnit.UNIT;
        });
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting high watermark for replica ", " partition ", " to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topicPartition(), newHighWatermark})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public LogOffsetMetadata lastStableOffset() {
        return (LogOffsetMetadata)this.log().map((Function1 & Serializable & scala.Serializable)log -> {
            Some some;
            LogOffsetMetadata offsetMetadata;
            Option<LogOffsetMetadata> option = log.firstUnstableOffset();
            LogOffsetMetadata logOffsetMetadata = option instanceof Some && (offsetMetadata = (LogOffsetMetadata)(some = (Some)option).value()).messageOffset() < this.highWatermark().messageOffset() ? offsetMetadata : this.highWatermark();
            return logOffsetMetadata;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot fetch last stable offset on partition ", "'s "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId())})));
        });
    }

    public void convertHWToLocalOffsetMetadata() {
        if (!this.isLocal()) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should not construct complete high watermark on partition ", "'s non-local replica ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.brokerId())})));
        }
        this.highWatermarkMetadata = ((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder replicaString = new StringBuilder();
        replicaString.append("ReplicaId: " + this.brokerId());
        replicaString.append("; Topic: " + this.topicPartition().topic());
        replicaString.append("; Partition: " + this.topicPartition().partition());
        replicaString.append("; isLocal: " + this.isLocal());
        replicaString.append("; lastCaughtUpTimeMs: " + this.lastCaughtUpTimeMs());
        if (this.isLocal()) {
            replicaString.append("; Highwatermark: " + this.highWatermark());
            boxedUnit = replicaString.append("; LastStableOffset: " + this.lastStableOffset());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return replicaString.toString();
    }

    public Replica(int brokerId, TopicPartition topicPartition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.initialHighWatermarkValue = initialHighWatermarkValue;
        this.log = log;
        Logging.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this._logStartOffset = Log$.MODULE$.UnknownLogStartOffset();
        this.lastFetchLeaderLogEndOffset = 0L;
        this.lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this.epochs = log.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.leaderEpochCache());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica loaded for partition ", " with initial high watermark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToLong((long)$this.initialHighWatermarkValue)})));
        log.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onHighWatermarkIncremented(this.initialHighWatermarkValue);
            return BoxedUnit.UNIT;
        });
    }
}

