/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.common.NoReplicaOnlineException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerContext;
import kafka.controller.PartitionLeaderSelector;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u000f\tqrJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!q!\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011q\u0003U1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011!B;uS2\u001c\u0018BA\f\u0015\u0005\u001daunZ4j]\u001eD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$\bCA\b\u001c\u0013\ta\"AA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqRD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0007G>tg-[4\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\"\u0011AB:feZ,'/\u0003\u0002%C\tY1*\u00194lC\u000e{gNZ5h\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q\u0019\u0001&\u000b\u0016\u0011\u0005=\u0001\u0001\"B\r&\u0001\u0004Q\u0002\"\u0002\u0010&\u0001\u0004y\u0002\"\u0002\u0017\u0001\t\u0003i\u0013\u0001D:fY\u0016\u001cG\u000fT3bI\u0016\u0014Hc\u0001\u0018G\u001dB!\u0011bL\u00198\u0013\t\u0001$B\u0001\u0004UkBdWM\r\t\u0003eUj\u0011a\r\u0006\u0003i\u0011\t1!\u00199j\u0013\t14G\u0001\u0007MK\u0006$WM]!oI&\u001b(\u000fE\u00029\u0001\u000es!!\u000f \u000f\u0005ijT\"A\u001e\u000b\u0005q2\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\ty$\"A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0013%aA*fc*\u0011qH\u0003\t\u0003\u0013\u0011K!!\u0012\u0006\u0003\u0007%sG\u000fC\u0003HW\u0001\u0007\u0001*A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u0003\u0002\r\r|W.\\8o\u0013\ti%JA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DQaT\u0016A\u0002E\n1cY;se\u0016tG\u000fT3bI\u0016\u0014\u0018I\u001c3JgJ\u0004")
public class OfflinePartitionLeaderSelector
implements PartitionLeaderSelector,
Logging {
    private final ControllerContext controllerContext;
    private final KafkaConfig config;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        OfflinePartitionLeaderSelector offlinePartitionLeaderSelector = this;
        synchronized (offlinePartitionLeaderSelector) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public Tuple2<LeaderAndIsr, Seq<Object>> selectLeader(TopicAndPartition topicAndPartition, LeaderAndIsr currentLeaderAndIsr) {
        LeaderAndIsr leaderAndIsr;
        Seq liveAssignedReplicas;
        Option option = this.controllerContext.partitionReplicaAssignment().get((Object)topicAndPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq assignedReplicas = (Seq)some.value();
            liveAssignedReplicas = (Seq)assignedReplicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)r -> $this.controllerContext.liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)r)));
            List liveBrokersInIsr = (List)currentLeaderAndIsr.isr().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)r -> $this.controllerContext.liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)r)));
            if (liveBrokersInIsr.isEmpty()) {
                if (!Predef$.MODULE$.Boolean2boolean(LogConfig$.MODULE$.fromProps(this.config.originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.controllerContext.zkUtils(), ConfigType$.MODULE$.Topic(), topicAndPartition.topic())).uncleanLeaderElectionEnable())) {
                    throw new NoReplicaOnlineException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No broker in ISR for partition ", " is alive. Live brokers are: [", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.controllerContext.liveBrokerIds()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ISR brokers are: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentLeaderAndIsr.isr().mkString(",")})));
                }
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No broker in ISR is alive for ", ". Pick the leader from the alive assigned "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replicas: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{liveAssignedReplicas.mkString(",")})));
                if (liveAssignedReplicas.isEmpty()) {
                    throw new NoReplicaOnlineException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No replica for partition ", " is alive. Live "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"brokers are: [", "]. Assigned replicas are: [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.controllerContext.liveBrokerIds(), assignedReplicas})));
                }
                this.controllerContext.stats().uncleanLeaderElectionRate().mark();
                int newLeader = BoxesRunTime.unboxToInt((Object)liveAssignedReplicas.head());
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No broker in ISR is alive for ", ". Elect leader ", " from live "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, BoxesRunTime.boxToInteger((int)newLeader)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"brokers ", ". There's potential data loss."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{liveAssignedReplicas.mkString(",")})));
                leaderAndIsr = currentLeaderAndIsr.newLeaderAndIsr(newLeader, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{newLeader})));
            } else {
                Seq liveReplicasInIsr = (Seq)liveAssignedReplicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)r -> liveBrokersInIsr.contains((Object)BoxesRunTime.boxToInteger((int)r)));
                int newLeader = BoxesRunTime.unboxToInt((Object)liveReplicasInIsr.head());
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some broker in ISR is alive for ", ". Select ", " from ISR "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, BoxesRunTime.boxToInteger((int)newLeader)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to be the leader."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{liveBrokersInIsr.mkString(",")})));
                leaderAndIsr = currentLeaderAndIsr.newLeaderAndIsr(newLeader, (List<Object>)liveBrokersInIsr);
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoReplicaOnlineException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " doesn't have replicas assigned to it"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})));
            }
            throw new MatchError((Object)option);
        }
        LeaderAndIsr newLeaderAndIsr = leaderAndIsr;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Selected new leader and ISR ", " for offline partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newLeaderAndIsr, topicAndPartition})));
        Tuple2 tuple2 = new Tuple2((Object)newLeaderAndIsr, (Object)liveAssignedReplicas);
        return tuple2;
    }

    public OfflinePartitionLeaderSelector(ControllerContext controllerContext, KafkaConfig config) {
        this.controllerContext = controllerContext;
        this.config = config;
        Logging.$init$(this);
        this.logIdent_$eq("[OfflinePartitionLeaderSelector]: ");
    }
}

