/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%v!B\u0001\u0003\u0011\u0003I\u0011A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005\r!\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u0002\u0004\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u0014\u0005-q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0003\u0016\u0017\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013!)\u0001d\u0003C\u00013\u0005)\u0011\r\u001d9msRy!Da\u0016\u0003h\tE$1\u000fB?\u0005\u0017\u0013)\n\u0005\u0002\u000b7\u0019!AB\u0001\u0001\u001d'\rYb\"\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\tQ!\u001e;jYNL!AI\u0010\u0003\u000f1{wmZ5oO\"AAe\u0007B\u0001B\u0003%Q%\u0001\u0005ce>\\WM]%e!\tya%\u0003\u0002(!\t\u0019\u0011J\u001c;\t\u0011%Z\"\u0011!Q\u0001\n)\n\u0011\u0002\u001e=o\u0007>tg-[4\u0011\u0005)Y\u0013B\u0001\u0017\u0003\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017n\u001a\u0005\t]m\u0011\t\u0011)A\u0005_\u0005I1o\u00195fIVdWM\u001d\t\u0003=AJ!!M\u0010\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002C\u001a\u001c\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002#A\u0014x\u000eZ;dKJLE-T1oC\u001e,'\u000f\u0005\u0002\u000bk%\u0011aG\u0001\u0002\u0012!J|G-^2fe&#W*\u00198bO\u0016\u0014\b\u0002\u0003\u001d\u001c\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0015QDh.T1oC\u001e,'\u000f\u0005\u0002\u000bu%\u00111H\u0001\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJD\u0001\"P\u000e\u0003\u0002\u0003\u0006IAP\u0001\u0018ibtW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\"AC \n\u0005\u0001\u0013!a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\"A!i\u0007B\u0001B\u0003%1)\u0001\u0003uS6,\u0007C\u0001#N\u001b\u0005)%B\u0001\u0011G\u0015\t9\u0005*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f%S!AS&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0015aA8sO&\u0011a*\u0012\u0002\u0005)&lW\rC\u0003\u00167\u0011\u0005\u0001\u000b\u0006\u0005\u001b#J\u001bF+\u0016,X\u0011\u0015!s\n1\u0001&\u0011\u0015Is\n1\u0001+\u0011\u0015qs\n1\u00010\u0011\u0015\u0019t\n1\u00015\u0011\u0015At\n1\u0001:\u0011\u0015it\n1\u0001?\u0011\u0015\u0011u\n1\u0001D\u000b\u0011I6\u0004\u0001.\u0003-%s\u0017\u000e\u001e)s_\u0012,8-\u001a:JI\u000e\u000bG\u000e\u001c2bG.\u0004BaD.^A&\u0011A\f\u0005\u0002\n\rVt7\r^5p]F\u0002\"A\u00030\n\u0005}\u0013!\u0001F%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*fgVdG\u000f\u0005\u0002\u0010C&\u0011!\r\u0005\u0002\u0005+:LG/\u0002\u0003e7\u0001)'!F!eIB\u000b'\u000f^5uS>t7oQ1mY\n\f7m\u001b\t\u0005\u001fm3\u0007\r\u0005\u0002hU6\t\u0001N\u0003\u0002j\r\u0006A\u0001O]8u_\u000e|G.\u0003\u0002lQ\n1QI\u001d:peN,A!\\\u000e\u0001K\nqQI\u001c3Uq:\u001c\u0015\r\u001c7cC\u000e\\W\u0001B8\u001c\u0001A\u0014\u0011\"\u00119j%\u0016\u001cX\u000f\u001c;\u0016\u0005E|\b\u0003\u0002:{Mvt!a\u001d=\u000f\u0005Q<X\"A;\u000b\u0005YD\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\tI\b#A\u0004qC\u000e\\\u0017mZ3\n\u0005md(AB#ji\",'O\u0003\u0002z!A\u0011ap \u0007\u0001\t\u001d\t\tA\u001cb\u0001\u0003\u0007\u0011\u0011\u0001V\t\u0005\u0003\u000b\tY\u0001E\u0002\u0010\u0003\u000fI1!!\u0003\u0011\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aDA\u0007\u0013\r\ty\u0001\u0005\u0002\u0004\u0003:L\b\"CA\n7\t\u0007I\u0011BA\u000b\u0003!I7/Q2uSZ,WCAA\f!\u0011\tI\"a\u000b\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\ta!\u0019;p[&\u001c'\u0002BA\u0011\u0003G\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)#a\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u000e\u00055\tEo\\7jG\n{w\u000e\\3b]\"A\u0011\u0011G\u000e!\u0002\u0013\t9\"A\u0005jg\u0006\u001bG/\u001b<fA!9\u0011QG\u000e\u0005\u0002\u0005]\u0012\u0001\u00065b]\u0012dW-\u00138jiB\u0013x\u000eZ;dKJLE\rF\u0004a\u0003s\ti%!\u0015\t\u0011\u0005m\u00121\u0007a\u0001\u0003{\tq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\t\u0005\u0003\u007f\t9E\u0004\u0003\u0002B\u0005\r\u0003C\u0001;\u0011\u0013\r\t)\u0005E\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0003\u0003C\u0004\u0002P\u0005M\u0002\u0019A\u0013\u0002)Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t\u0011!\t\u0019&a\rA\u0002\u0005U\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l!\r\t9\u0006W\u0007\u00027!9\u00111L\u000e\u0005\n\u0005u\u0013a\u00079sKB\f'/Z%oSR\u0004&o\u001c3vG\u0016LE\r\u0016:b]NLG\u000f\u0006\u0006\u0002`\u00055\u0014qNA9\u0003k\u0002R!a\u0016o\u0003C\u0002baDA2K\u0005\u001d\u0014bAA3!\t1A+\u001e9mKJ\u00022ACA5\u0013\r\tYG\u0001\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018\r\u0003\u0005\u0002<\u0005e\u0003\u0019AA\u001f\u0011\u001d\ty%!\u0017A\u0002\u0015Bq!a\u001d\u0002Z\u0001\u0007Q%\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"A\u0011qOA-\u0001\u0004\tI(A\u0006uq:lU\r^1eCR\f\u0007c\u0001\u0006\u0002|%\u0019\u0011Q\u0010\u0002\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\t\u000f\u0005\u00055\u0004\"\u0001\u0002\u0004\u0006\u0001\u0003.\u00198eY\u0016\fE\r\u001a)beRLG/[8ogR{GK]1og\u0006\u001cG/[8o)-\u0001\u0017QQAD\u0003#\u000bY*a-\t\u0011\u0005m\u0012q\u0010a\u0001\u0003{A\u0001\"!#\u0002\u0000\u0001\u0007\u00111R\u0001\u000baJ|G-^2fe&#\u0007cA\b\u0002\u000e&\u0019\u0011q\u0012\t\u0003\t1{gn\u001a\u0005\t\u0003'\u000by\b1\u0001\u0002\u0016\u0006i\u0001O]8ek\u000e,'/\u00129pG\"\u00042aDAL\u0013\r\tI\n\u0005\u0002\u0006'\"|'\u000f\u001e\u0005\t\u0003;\u000by\b1\u0001\u0002 \u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\u0005\u0005\u0016qUAV\u001b\t\t\u0019KC\u0002\u0002&B\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI+a)\u0003\u0007M+G\u000f\u0005\u0003\u0002.\u0006=V\"\u0001$\n\u0007\u0005EfI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005M\u0013q\u0010a\u0001\u0003k\u00032!a\u0016d\u0011\u001d\tIl\u0007C\u0001\u0003w\u000bA\u0003[1oI2,G\u000b\u001f8J[6LwM]1uS>tG#\u00021\u0002>\u0006\u0005\u0007bBA`\u0003o\u0003\r!J\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0003g\n9\f1\u0001&\u0011\u001d\t)m\u0007C\u0001\u0003\u000f\f1\u0003[1oI2,G\u000b\u001f8F[&<'/\u0019;j_:$R\u0001YAe\u0003\u0017Dq!a0\u0002D\u0002\u0007Q\u0005C\u0004\u0002t\u0005\r\u0007\u0019A\u0013\t\u000f\u0005=7\u0004\"\u0003\u0002R\u00069Cn\\4J]Z\fG.\u001b3Ti\u0006$X\r\u0016:b]NLG/[8o\u0003:$'+\u001a;ve:,%O]8s)!\t\u0019.!8\u0002`\u0006%\bcBAk\u000334\u0017QA\u0007\u0003\u0003/T1!!\n\u0011\u0013\u0011\tY.a6\u0003\t1+g\r\u001e\u0005\t\u0003w\ti\r1\u0001\u0002>!A\u0011\u0011]Ag\u0001\u0004\t\u0019/\u0001\tue\u0006t7/Y2uS>t7\u000b^1uKB\u0019!\"!:\n\u0007\u0005\u001d(A\u0001\tUe\u0006t7/Y2uS>t7\u000b^1uK\"A\u00111^Ag\u0001\u0004\ti/A\tue\u0006t7/Y2uS>t'+Z:vYR\u0004B!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0004\u0003g4\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005]\u0018\u0011\u001f\u0002\u0012)J\fgn]1di&|gNU3tk2$\bbBA~7\u0011\u0005\u0011Q`\u0001\u0015Q\u0006tG\r\\3F]\u0012$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0017\u0001\fyP!\u0001\u0003\u0004\t\u0015!\u0011\u0002\u0005\t\u0003w\tI\u00101\u0001\u0002>!A\u0011\u0011RA}\u0001\u0004\tY\t\u0003\u0005\u0002\u0014\u0006e\b\u0019AAK\u0011!\u00119!!?A\u0002\u00055\u0018a\u0004;y]6\u000b'o[3s%\u0016\u001cX\u000f\u001c;\t\u0011\u0005M\u0013\u0011 a\u0001\u0005\u0017\u00012!a\u0016m\u0011\u001d\u0011ya\u0007C\u0001\u0005#\tq\u0003\u001e:b]N\f7\r^5p]R{\u0007/[2D_:4\u0017nZ:\u0016\u0005\tM\u0001\u0003\u0002B\u000b\u0005/i!!a\t\n\t\te\u00111\u0005\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B\u000f7\u0011\u0005!qD\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004K\t\u0005\u0002\u0002CA\u001e\u00057\u0001\r!!\u0010\t\u000f\t\u00152\u0004\"\u0003\u0003(\u0005I\u0012MY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\u0005\u0001\u0007b\u0002B\u00167\u0011\u0005!QF\u0001\bgR\f'\u000f^;q)\r\u0001'q\u0006\u0005\u000b\u0005c\u0011I\u0003%AA\u0002\tM\u0012aH3oC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]B\u0019qB!\u000e\n\u0007\t]\u0002CA\u0004C_>dW-\u00198\t\u000f\tm2\u0004\"\u0001\u0003(\u0005A1\u000f[;uI><h\u000eC\u0005\u0003@m\t\n\u0011\"\u0001\u0003B\u0005\t2\u000f^1siV\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\r#\u0006\u0002B\u001a\u0005\u000bZ#Aa\u0012\u0011\t\t%#1K\u0007\u0003\u0005\u0017RAA!\u0014\u0003P\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005#\u0002\u0012AC1o]>$\u0018\r^5p]&!!Q\u000bB&\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b\u00053:\u0002\u0019\u0001B.\u0003\u0019\u0019wN\u001c4jOB!!Q\fB2\u001b\t\u0011yFC\u0002\u0003b\u0019\taa]3sm\u0016\u0014\u0018\u0002\u0002B3\u0005?\u00121bS1gW\u0006\u001cuN\u001c4jO\"9!\u0011N\fA\u0002\t-\u0014A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0005;\u0012i'\u0003\u0003\u0003p\t}#A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0006]]\u0001\ra\f\u0005\b\u0005k:\u0002\u0019\u0001B<\u0003\u001dQ8.\u0016;jYN\u00042A\bB=\u0013\r\u0011Yh\b\u0002\b5.,F/\u001b7t\u0011\u001d\u0011yh\u0006a\u0001\u0005\u0003\u000bq!\\3ue&\u001c7\u000f\u0005\u0003\u0003\u0004\n\u001dUB\u0001BC\u0015\r\u0011yHR\u0005\u0005\u0005\u0013\u0013)IA\u0004NKR\u0014\u0018nY:\t\u000f\t5u\u00031\u0001\u0003\u0010\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004BA!\u0018\u0003\u0012&!!1\u0013B0\u00055iU\r^1eCR\f7)Y2iK\")!i\u0006a\u0001\u0007\"9!\u0011T\u0006\u0005\n\tm\u0015\u0001F5oSR$&/\u00198tC\u000e$\u0018n\u001c8FeJ|'\u000fF\u0002^\u0005;CqAa(\u0003\u0018\u0002\u0007a-A\u0003feJ|'\u000fC\u0004\u0003$.!IA!*\u0002/%t\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fGcA/\u0003(\"A\u0011q\u000fBQ\u0001\u0004\t9\u0007")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final ProducerIdManager producerIdManager;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, ZkUtils zkUtils, Metrics metrics, MetadataCache metadataCache, Time time) {
        return TransactionCoordinator$.MODULE$.apply(kafkaConfig, replicaManager, scheduler, zkUtils, metrics, metadataCache, time);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TransactionCoordinator transactionCoordinator = this;
        synchronized (transactionCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Function1<InitProducerIdResult, BoxedUnit> responseCallback) {
        if (transactionalId == null) {
            long producerId = this.producerIdManager.generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
        } else if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
        } else if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
        } else {
            Right right;
            Tuple2 tuple2;
            Either coordinatorEpochAndMetadata = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Either<Errors, CoordinatorEpochAndTxnMetadata> either;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    long producerId = $this.producerIdManager.generateProducerId();
                    String x$6 = transactionalId;
                    long x$7 = producerId;
                    short x$8 = -1;
                    int x$9 = transactionTimeoutMs;
                    Empty$ x$10 = Empty$.MODULE$;
                    scala.collection.mutable.Set x$11 = Set$.MODULE$.empty();
                    long x$12 = $this.time.milliseconds();
                    long x$13 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
                    TransactionMetadata createdMetadata = new TransactionMetadata(x$6, x$7, x$8, x$9, x$10, (scala.collection.mutable.Set<TopicPartition>)x$11, x$13, x$12);
                    either = $this.txnManager.putTransactionStateIfNotExists(transactionalId, createdMetadata);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
                } else {
                    throw new MatchError((Object)option);
                }
                return either;
            });
            Either result = coordinatorEpochAndMetadata.right().flatMap((Function1 & Serializable & scala.Serializable)existingEpochAndMetadata -> {
                int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
                return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> this.prepareInitProduceIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata));
            });
            Either either = result;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors error2 = (Errors)left.value();
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                BoxedUnit boxedUnit;
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                TransactionState transactionState = newMetadata.txnState();
                PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                    this.handleEndTransaction(transactionalId, newMetadata.producerId(), newMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                        TransactionCoordinator.sendRetriableErrorCallback$1(error, responseCallback);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                        this.sendPidResponseCallback$1(error, transactionalId, responseCallback, newMetadata);
                        return BoxedUnit.UNIT;
                    }, this.txnManager.appendTransactionToLog$default$5());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProduceIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            Left left2;
            TransactionState transactionState = txnMetadata.state();
            boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
            if (bl) {
                left2 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
                if (bl2) {
                    TxnTransitMetadata txnTransitMetadata;
                    if (txnMetadata.isProducerEpochExhausted()) {
                        long newProducerId = this.producerIdManager.generateProducerId();
                        txnTransitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds());
                    } else {
                        txnTransitMetadata = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, this.time.milliseconds());
                    }
                    TxnTransitMetadata transitMetadata = txnTransitMetadata;
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (Ongoing$.MODULE$.equals(transactionState)) {
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
                } else {
                    boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                    if (bl3) {
                        String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                }
            }
            left = left2;
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s AddPartitions request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.INVALID_REQUEST, transactionalId})));
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
        } else {
            Right right;
            Tuple2 tuple2;
            Either result = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Left left;
                Option option = x0$2;
                if (None$.MODULE$.equals(option)) {
                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                    TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                    left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        Left left;
                        block8: {
                            block7: {
                                if (txnMetadata.producerId() != producerId) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    return left;
                                }
                                if (txnMetadata.producerEpoch() != producerEpoch) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                                    return left;
                                }
                                if (txnMetadata.pendingTransitionInProgress()) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    return left;
                                }
                                TransactionState transactionState = txnMetadata.state();
                                PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                                if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                                TransactionState transactionState2 = txnMetadata.state();
                                PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                                if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                            }
                            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            return left;
                        }
                        TransactionState transactionState = txnMetadata.state();
                        Ongoing$ ongoing$ = Ongoing$.MODULE$;
                        if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                            left = package$.MODULE$.Left().apply((Object)Errors.NONE);
                            return left;
                        }
                        left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                        return left;
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            });
            Either either = result;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s AddPartitions request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err, transactionalId})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, this.txnManager.appendTransactionToLog$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    public void handleTxnImmigration(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTxnEmigration(int txnTopicPartitionId, int coordinatorEpoch) {
        this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch);
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId: ", "'s state is ", ", but received transaction "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, transactionState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"marker result to send: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionResult})));
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
        } else {
            Right right;
            Tuple2 tuple2;
            Either preAppendResult = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Left left;
                Option option = x0$3;
                if (None$.MODULE$.equals(option)) {
                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                    int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                    left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        Right right;
                        TransactionState transactionState;
                        Right right2;
                        if (txnMetadata.producerId() != producerId) {
                            right2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            return right2;
                        }
                        if (producerEpoch < txnMetadata.producerEpoch()) {
                            right2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                            return right2;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            Object object = txnMetadata.pendingState().get();
                            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                            if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                                right2 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                return right2;
                            }
                        }
                        if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                            Product nextState;
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult2 = TransactionResult.COMMIT;
                            Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().isDefined()) {
                                Object object = txnMetadata.pendingState().get();
                                PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                                if (!(object != null ? !object.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                                    txnMetadata.producerEpoch_$eq(producerEpoch);
                                }
                            }
                            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                        } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult3 = TransactionResult.COMMIT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult4 = TransactionResult.ABORT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult5 = TransactionResult.COMMIT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult6 = TransactionResult.ABORT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (Empty$.MODULE$.equals(transactionState)) {
                            right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else {
                            boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                            if (!bl) throw new MatchError((Object)transactionState);
                            String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        right2 = right;
                        return right2;
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            });
            Either either = preAppendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting append of ", " to transaction log with coordinator and returning ", " error to client for ", "'s EndTransaction request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarkerResult, err, transactionalId})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                    this.sendTxnMarkersCallback$1(error, transactionalId, producerId, producerEpoch, txnMarkerResult, responseCallback, coordinatorEpoch, newMetadata);
                    return BoxedUnit.UNIT;
                }, this.txnManager.appendTransactionToLog$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void abortTimedOutTransactions() {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).right().flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Left left;
            Option option = x0$5;
            if (None$.MODULE$.equals(option)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find transaction metadata when trying to timeout transaction with transactionalId "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". ProducerId: ", ". ProducerEpoch: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch.transactionalId(), BoxesRunTime.boxToLong((long)txnIdAndPidEpoch.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)txnIdAndPidEpoch.producerEpoch())})));
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
            } else if (option instanceof Some) {
                Left left2;
                Some some = (Some)option;
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                boolean producerIdHasChanged = BoxesRunTime.unboxToBoolean(txnMetadata.inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> txnMetadata.producerId() != txnIdAndPidEpoch.producerId()));
                if (producerIdHasChanged) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found incorrect producerId when expiring transactionalId: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch.transactionalId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected producerId: ", ". Found producerId: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnIdAndPidEpoch.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)epochAndTxnMetadata.transactionMetadata().producerId())})));
                    left2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                } else {
                    Left left3;
                    Either transitMetadata = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> txnMetadata.pendingTransitionInProgress() ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : package$.MODULE$.Right().apply((Object)txnMetadata.prepareFenceProducerEpoch()));
                    Either either = transitMetadata;
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        TxnTransitMetadata txnTransitMetadata = (TxnTransitMetadata)right.value();
                        this.handleEndTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$6 -> {
                            TransactionCoordinator.$anonfun$abortTimedOutTransactions$7(this, txnIdAndPidEpoch, x0$6);
                            return BoxedUnit.UNIT;
                        });
                        left3 = package$.MODULE$.Right().apply((Object)txnTransitMetadata);
                    } else {
                        left3 = package$.MODULE$.Left().apply((Object)either);
                    }
                    left2 = left3;
                }
                left = left2;
            } else {
                throw new MatchError((Object)option);
            }
            return left;
        }));
    }

    public void startup(boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        if (enableTransactionalIdExpiration) {
            this.txnManager.enableTransactionalIdExpiration();
        }
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$1() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager.shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
        } else {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
        }
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, Function1 responseCallback$1, TxnTransitMetadata newMetadata$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized transactionalId ", " with producerId ", " and producer "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, BoxesRunTime.boxToLong((long)newMetadata$1.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", " on partition "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)newMetadata$1.producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__transaction_state", BoxesRunTime.boxToInteger((int)$this.txnManager.partitionFor(transactionalId$1))})));
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s InitProducerId request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, transactionalId$1})));
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$2, long producerId$1, short producerEpoch$1, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$2) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$2).right().flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Left left;
                Option option = x0$4;
                if (None$.MODULE$.equals(option)) {
                    String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The coordinator still owns the transaction partition for ", ", but there is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no metadata in the cache; this is not expected"})).s((Seq)Nil$.MODULE$);
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$4) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId$1) {
                                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            } else if (txnMetadata.producerEpoch() != producerEpoch$1) {
                                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                            } else if (txnMetadata.pendingTransitionInProgress()) {
                                left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            } else {
                                Left<Errors, Nothing$> left2;
                                TransactionState transactionState = txnMetadata.state();
                                boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                if (bl) {
                                    left2 = this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1);
                                } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                    TransactionResult transactionResult = txnMarkerResult$1;
                                    TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                    left2 = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                    TransactionResult transactionResult = txnMarkerResult$1;
                                    TransactionResult transactionResult3 = TransactionResult.ABORT;
                                    left2 = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                } else {
                                    boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                    if (bl2) {
                                        String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                        throw new IllegalStateException(errorMsg);
                                    }
                                    throw new MatchError((Object)transactionState);
                                }
                                left = left2;
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The transaction coordinator epoch has changed to ", " after ", " was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochAndMetadata.coordinatorEpoch()), txnMarkerResult$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"successfully appended to the log for ", " with old epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2, BoxesRunTime.boxToInteger((int)coordinatorEpoch$4)})));
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError((Object)option);
                }
                Left left2 = left;
                return left2;
            });
            Either either = preSendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting sending of transaction markers after appended ", " to transaction log and returning ", " error to client for ", "'s EndTransaction request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarkerResult$1, err, transactionalId$2})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            } else {
                Right right;
                Tuple2 tuple2;
                if (!(either instanceof Right) || (tuple2 = (Tuple2)(right = (Right)either).value()) == null) throw new MatchError((Object)either);
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId$2, coordinatorEpoch$4, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting sending of transaction markers and returning ", " error to client for ", "'s EndTransaction request of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, transactionalId$2, txnMarkerResult$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since appending ", " to transaction log with coordinator epoch ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newMetadata$2, BoxesRunTime.boxToInteger((int)coordinatorEpoch$4)})));
            responseCallback$2.apply((Object)error);
        }
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$7(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$1, Errors x0$6) {
        Errors errors = x0$6;
        if (Errors.NONE.equals(errors)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed rollback ongoing transaction of transactionalId: ", " due to timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(errors) ? true : (Errors.INVALID_PRODUCER_EPOCH.equals(errors) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(errors));
            if (bl) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling back ongoing transaction of transactionalId: ", " has aborted due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId(), errors.exceptionName()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling back ongoing transaction of transactionalId: ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId(), errors.exceptionName()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, ProducerIdManager producerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.producerIdManager = producerIdManager;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[Transaction Coordinator " + brokerId + "]: ");
        this.isActive = new AtomicBoolean(false);
    }
}

