/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001%\u0011A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",'BA\u0002\u0005\u0003\u0015)\u0007o\\2i\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u000b!Q\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005AaU-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013a\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003;\u0015j\u0011A\b\u0006\u0003?\u0001\naaY8n[>t'BA\u0004\"\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\n\u0005\u0019r\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005\u0019A.Z8\u0011\u0007-QC&\u0003\u0002,\u0019\tIa)\u001e8di&|g\u000e\r\t\u0003[9j\u0011\u0001B\u0005\u0003_\u0011\u0011\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014AC2iK\u000e\\\u0007o\\5oiB\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\fG\",7m\u001b9pS:$8/\u0003\u00028i\t)B*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$\b\"B\u001d\u0001\t\u0003Q\u0014A\u0002\u001fj]&$h\b\u0006\u0003<yur\u0004CA\t\u0001\u0011\u0015Y\u0002\b1\u0001\u001d\u0011\u0015A\u0003\b1\u0001*\u0011\u0015\t\u0004\b1\u00013\u0011\u001d\u0001\u0005A1A\u0005\n\u0005\u000bA\u0001\\8dWV\t!\t\u0005\u0002D\u00196\tAI\u0003\u0002F\r\u0006)An\\2lg*\u0011q\tS\u0001\u000bG>t7-\u001e:sK:$(BA%K\u0003\u0011)H/\u001b7\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0012\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"1q\n\u0001Q\u0001\n\t\u000bQ\u0001\\8dW\u0002Bq!\u0015\u0001A\u0002\u0013%!+\u0001\u0004fa>\u001c\u0007n]\u000b\u0002'B\u0019A+W.\u000e\u0003US!AV,\u0002\u000f5,H/\u00192mK*\u0011\u0001\fD\u0001\u000bG>dG.Z2uS>t\u0017B\u0001.V\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0003#qK!!\u0018\u0002\u0003\u0015\u0015\u0003xn\u00195F]R\u0014\u0018\u0010C\u0004`\u0001\u0001\u0007I\u0011\u00021\u0002\u0015\u0015\u0004xn\u00195t?\u0012*\u0017\u000f\u0006\u0002bIB\u00111BY\u0005\u0003G2\u0011A!\u00168ji\"9QMXA\u0001\u0002\u0004\u0019\u0016a\u0001=%c!1q\r\u0001Q!\nM\u000bq!\u001a9pG\"\u001c\b\u0005C\u0003j\u0001\u0011\u0005#.\u0001\u0004bgNLwM\u001c\u000b\u0004C.|\u0007\"B\u0002i\u0001\u0004a\u0007CA\u0006n\u0013\tqGBA\u0002J]RDQ\u0001\u001d5A\u0002E\faa\u001c4gg\u0016$\bCA\u0006s\u0013\t\u0019HB\u0001\u0003M_:<\u0007\"B;\u0001\t\u00032\u0018a\u00037bi\u0016\u001cH/\u00129pG\"$\u0012\u0001\u001c\u0005\u0006q\u0002!\t%_\u0001\rK:$wJ\u001a4tKR4uN\u001d\u000b\u0003cjDQa_<A\u00021\faB]3rk\u0016\u001cH/\u001a3Fa>\u001c\u0007\u000eC\u0003~\u0001\u0011\u0005c0A\ndY\u0016\f'/\u00118e\r2,8\u000f\u001b'bi\u0016\u001cH\u000f\u0006\u0002b\u007f\")\u0001\u000f a\u0001c\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011!F2mK\u0006\u0014\u0018I\u001c3GYV\u001c\b.R1sY&,7\u000f\u001e\u000b\u0004C\u0006\u001d\u0001B\u00029\u0002\u0002\u0001\u0007\u0011\u000fC\u0004\u0002\f\u0001!\t%!\u0004\u0002\u001b\rdW-\u0019:B]\u00124E.^:i)\u0005\t\u0007bBA\t\u0001\u0011\u0005\u0013QB\u0001\u0006G2,\u0017M\u001d\u0005\b\u0003+\u0001A\u0011AA\f\u00031)\u0007o\\2i\u000b:$(/[3t)\u0005\u0019\u0006bBA\u000e\u0001\u0011%\u0011QD\u0001\u000fK\u0006\u0014H.[3ti>3gm]3u)\u0005\t\bbBA\u0011\u0001\u0011%\u0011QD\u0001\rY\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0003K\u0001A\u0011BA\u0007\u0003\u00151G.^:i\u0011\u001d\tI\u0003\u0001C\u0001\u0003W\ta\"\u001a9pG\"\u001c\u0005.\u00198hK6\u001bx\r\u0006\u0004\u0002.\u0005\r\u0013Q\t\t\u0005\u0003_\tiD\u0004\u0003\u00022\u0005e\u0002cAA\u001a\u00195\u0011\u0011Q\u0007\u0006\u0004\u0003oA\u0011A\u0002\u001fs_>$h(C\u0002\u0002<1\ta\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001e\u0019!11!a\nA\u00021Da\u0001]A\u0014\u0001\u0004\t\bbBA%\u0001\u0011\u0005\u00111J\u0001\u0015m\u0006d\u0017\u000eZ1uK\u0006sG-T1zE\u0016<\u0016M\u001d8\u0015\u000b\u0005\fi%a\u0014\t\r\r\t9\u00051\u0001m\u0011\u0019\u0001\u0018q\ta\u0001c\u0002")
public class LeaderEpochFileCache
implements LeaderEpochCache,
Logging {
    private final TopicPartition topicPartition;
    private final Function0<LogOffsetMetadata> leo;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private ListBuffer<EpochEntry> epochs;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LeaderEpochFileCache leaderEpochFileCache = this;
        synchronized (leaderEpochFileCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ListBuffer<EpochEntry> epochs() {
        return this.epochs;
    }

    private void epochs_$eq(ListBuffer<EpochEntry> x$1) {
        this.epochs = x$1;
    }

    @Override
    public void assign(int epoch, long offset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (epoch >= 0 && epoch > this.latestEpoch() && offset >= this.latestOffset()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated PartitionLeaderEpoch. ", ". Cache now contains ", " entries."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.epochChangeMsg(epoch, offset), BoxesRunTime.boxToInteger((int)this.epochs().size())})));
                this.epochs().$plus$eq((Object)new EpochEntry(epoch, offset));
                this.flush();
            } else {
                this.validateAndMaybeWarn(epoch, offset);
            }
        });
    }

    @Override
    public int latestEpoch() {
        return BoxesRunTime.unboxToInt(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.epochs().isEmpty() ? -1 : ((EpochEntry)this.epochs().last()).epoch()));
    }

    @Override
    public long endOffsetFor(int requestedEpoch) {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            void var2_3;
            ListBuffer subsequentEpochs;
            long offset = requestedEpoch == -1 ? -1L : (requestedEpoch == this.latestEpoch() ? ((LogOffsetMetadata)$this.leo.apply()).messageOffset() : ((subsequentEpochs = (ListBuffer)this.epochs().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$endOffsetFor$2(requestedEpoch, e)))).isEmpty() || requestedEpoch < ((EpochEntry)this.epochs().head()).epoch() ? -1L : ((EpochEntry)subsequentEpochs.head()).startOffset()));
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed offset for epoch request for partition ", " epoch:", " and returning offset ", " from epoch list of size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.topicPartition, BoxesRunTime.boxToInteger((int)requestedEpoch), BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this.epochs().size())})));
            return (long)var2_3;
        }));
    }

    @Override
    public void clearAndFlushLatest(long offset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                ListBuffer<EpochEntry> before = this.epochs();
                if (offset < 0L || offset > this.latestOffset()) break block0;
                this.epochs_$eq((ListBuffer<EpochEntry>)((ListBuffer)this.epochs().filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$clearAndFlushLatest$2(offset, entry)))));
                this.flush();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleared latest ", " entries from epoch cache based on passed offset ", " leaving ", " in EpochFile for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{before.toSet().filterNot((Function1)this.epochs().toSet()), BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this.epochs().size()), $this.topicPartition})));
            }
        });
    }

    @Override
    public void clearAndFlushEarliest(long offset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                BoxedUnit boxedUnit;
                ListBuffer earliest;
                ListBuffer<EpochEntry> before = this.epochs();
                if (offset < 0L || this.earliestOffset() >= offset || (earliest = (ListBuffer)this.epochs().filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$clearAndFlushEarliest$2(offset, entry)))).size() <= 0) break block2;
                this.epochs_$eq((ListBuffer<EpochEntry>)((ListBuffer)this.epochs().$minus$minus$eq((TraversableOnce)earliest)));
                if (offset < this.earliestOffset() || this.epochs().isEmpty()) {
                    EpochEntry epochEntry = new EpochEntry(((EpochEntry)earliest.last()).epoch(), offset);
                    boxedUnit = this.epochs().$plus$eq$colon((Object)epochEntry);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.flush();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleared earliest ", " entries from epoch cache based on passed offset ", " leaving ", " in EpochFile for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((TraversableOnce)before.toSet().filterNot((Function1)this.epochs().toSet())).size()), BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this.epochs().size()), $this.topicPartition})));
            }
        });
    }

    @Override
    public void clearAndFlush() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.epochs().clear();
            this.flush();
        });
    }

    @Override
    public void clear() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.epochs().clear());
    }

    public ListBuffer<EpochEntry> epochEntries() {
        return this.epochs();
    }

    private long earliestOffset() {
        return this.epochs().isEmpty() ? -1L : ((EpochEntry)this.epochs().head()).startOffset();
    }

    private long latestOffset() {
        return this.epochs().isEmpty() ? -1L : ((EpochEntry)this.epochs().last()).startOffset();
    }

    private void flush() {
        this.checkpoint.write((Seq<EpochEntry>)this.epochs());
    }

    public String epochChangeMsg(int epoch, long offset) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New: {epoch:", ", offset:", "}, Current: {epoch:", ", offset", "} for Partition: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epoch), BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this.latestEpoch()), BoxesRunTime.boxToLong((long)this.latestOffset()), this.topicPartition}));
    }

    public void validateAndMaybeWarn(int epoch, long offset) {
        block1: {
            block0: {
                Predef$.MODULE$.assert(epoch >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received a PartitionLeaderEpoch assignment for an epoch < 0. This should not happen. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.epochChangeMsg(epoch, offset)})));
                if (epoch >= this.latestEpoch()) break block0;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received a PartitionLeaderEpoch assignment for an epoch < latestEpoch. "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This implies messages have arrived out of order. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.epochChangeMsg(epoch, offset)})));
                break block1;
            }
            if (offset >= this.latestOffset()) break block1;
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received a PartitionLeaderEpoch assignment for an offset < latest offset for the most recent, stored PartitionLeaderEpoch. "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This implies messages have arrived out of order. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.epochChangeMsg(epoch, offset)})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$endOffsetFor$2(int requestedEpoch$1, EpochEntry e) {
        return e.epoch() > requestedEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$clearAndFlushLatest$2(long offset$4, EpochEntry entry) {
        return entry.startOffset() < offset$4;
    }

    public static final /* synthetic */ boolean $anonfun$clearAndFlushEarliest$2(long offset$5, EpochEntry entry) {
        return entry.startOffset() < offset$5;
    }

    public LeaderEpochFileCache(TopicPartition topicPartition, Function0<LogOffsetMetadata> leo, LeaderEpochCheckpoint checkpoint) {
        this.topicPartition = topicPartition;
        this.leo = leo;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.epochs = (ListBuffer)CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply($this.checkpoint.read()));
    }
}

