/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import joptsimple.OptionSpec;
import kafka.common.MessageFormatter;
import kafka.common.StreamEndException;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.NewShinyConsumer;
import kafka.consumer.OldConsumer;
import kafka.tools.ConsoleConsumer;
import kafka.utils.Exit$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsoleConsumer$
implements Logging {
    public static ConsoleConsumer$ MODULE$;
    private int messageCount;
    private final CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int messageCount() {
        return this.messageCount;
    }

    public void messageCount_$eq(int x$1) {
        this.messageCount = x$1;
    }

    public CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch() {
        return this.kafka$tools$ConsoleConsumer$$shutdownLatch;
    }

    public void main(String[] args) {
        ConsoleConsumer.ConsumerConfig conf = new ConsoleConsumer.ConsumerConfig(args);
        try {
            this.run(conf);
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unknown error when running consumer: ", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void run(ConsoleConsumer.ConsumerConfig conf) {
        BaseConsumer baseConsumer;
        if (conf.useOldConsumer()) {
            this.checkZk(conf);
            baseConsumer = new OldConsumer(conf.filterSpec(), this.getOldConsumerProps(conf));
        } else {
            long timeoutMs = conf.timeoutMs() >= 0 ? (long)conf.timeoutMs() : Long.MAX_VALUE;
            baseConsumer = conf.partitionArg().isDefined() ? new NewShinyConsumer((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), conf.partitionArg(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)conf.offsetArg())), (Option<String>)None$.MODULE$, this.getNewConsumerProps(conf), timeoutMs) : new NewShinyConsumer((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)conf.whitelistArg()), this.getNewConsumerProps(conf), timeoutMs);
        }
        BaseConsumer consumer = baseConsumer;
        this.addShutdownHook(consumer, conf);
        try {
            this.process(Predef$.MODULE$.int2Integer(conf.maxMessages()), conf.formatter(), consumer, System.out, conf.skipMessageOnError());
        }
        finally {
            consumer.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            if (!conf.groupIdPassed()) {
                ZkUtils$.MODULE$.maybeDeletePath((String)conf.options().valueOf(conf.zkConnectOpt()), "/consumers/" + conf.consumerProps().get("group.id"));
            }
            this.kafka$tools$ConsoleConsumer$$shutdownLatch().countDown();
        }
    }

    public void checkZk(ConsoleConsumer.ConsumerConfig config) {
        if (!this.checkZkPathExists((String)config.options().valueOf(config.zkConnectOpt()), "/brokers/ids")) {
            System.err.println("No brokers found in ZK.");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (!config.options().has((OptionSpec)config.deleteConsumerOffsetsOpt()) && config.options().has((OptionSpec)config.resetBeginningOpt()) && this.checkZkPathExists((String)config.options().valueOf(config.zkConnectOpt()), "/consumers/" + config.consumerProps().getProperty("group.id") + "/offsets")) {
            System.err.println("Found previous offset information for this group " + config.consumerProps().getProperty("group.id") + ". Please use --delete-consumer-offsets to delete previous offsets metadata");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void addShutdownHook(BaseConsumer consumer, ConsoleConsumer.ConsumerConfig conf) {
        Runtime.getRuntime().addShutdownHook(new Thread(consumer, conf){
            private final BaseConsumer consumer$1;
            private final ConsoleConsumer.ConsumerConfig conf$1;

            public void run() {
                block0: {
                    this.consumer$1.stop();
                    ConsoleConsumer$.MODULE$.kafka$tools$ConsoleConsumer$$shutdownLatch().await();
                    if (!this.conf$1.enableSystestEventsLogging()) break block0;
                    System.out.println("shutdown_complete");
                }
            }
            {
                this.consumer$1 = consumer$1;
                this.conf$1 = conf$1;
            }
        });
    }

    public void process(Integer maxMessages, MessageFormatter formatter, BaseConsumer consumer, PrintStream output, boolean skipMessageOnError) {
        while (this.messageCount() < Predef$.MODULE$.Integer2int(maxMessages) || BoxesRunTime.equalsNumObject((Number)maxMessages, (Object)BoxesRunTime.boxToInteger((int)-1))) {
            BaseConsumerRecord baseConsumerRecord;
            try {
                baseConsumerRecord = consumer.receive();
            }
            catch (StreamEndException streamEndException) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught StreamEndException because consumer is shutdown, ignore and terminate.");
                return;
            }
            catch (WakeupException wakeupException) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught WakeupException because consumer is shutdown, ignore and terminate.");
                return;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error processing message, terminating consumer process: ", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
            BaseConsumerRecord msg = baseConsumerRecord;
            this.messageCount_$eq(this.messageCount() + 1);
            try {
                formatter.writeTo((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(msg.topic(), msg.partition(), msg.offset(), msg.timestamp(), msg.timestampType(), Predef$.MODULE$.long2Long(0L), 0, 0, (Object)msg.key(), (Object)msg.value(), msg.headers()), output);
            }
            catch (Throwable e) {
                if (skipMessageOnError) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error processing message, skipping this message: ", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw e;
            }
            if (!this.checkErr(output, formatter)) continue;
            return;
        }
    }

    public void reportRecordCount() {
        System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed a total of ", " messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messageCount())})));
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkErr(PrintStream output, MessageFormatter formatter) {
        void var3_3;
        block0: {
            boolean gotError = output.checkError();
            if (!gotError) break block0;
            System.err.println("Unable to write to standard out, closing consumer.");
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getOldConsumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)config.consumerProps());
        props.putAll((Map<?, ?>)config.extraConsumerProps());
        props.put("auto.offset.reset", config.fromBeginning() ? "smallest" : "largest");
        props.put("zookeeper.connect", config.zkConnectionStr());
        if (!config.options().has((OptionSpec)config.deleteConsumerOffsetsOpt()) && config.options().has((OptionSpec)config.resetBeginningOpt()) && this.checkZkPathExists((String)config.options().valueOf(config.zkConnectOpt()), "/consumers/" + props.getProperty("group.id") + "/offsets")) {
            System.err.println("Found previous offset information for this group " + props.getProperty("group.id") + ". Please use --delete-consumer-offsets to delete previous offsets metadata");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (config.options().has((OptionSpec)config.deleteConsumerOffsetsOpt())) {
            ZkUtils$.MODULE$.maybeDeletePath((String)config.options().valueOf(config.zkConnectOpt()), "/consumers/" + config.consumerProps().getProperty("group.id"));
        }
        Object object = config.timeoutMs() >= 0 ? props.put("consumer.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)config.timeoutMs())).toString()) : BoxedUnit.UNIT;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getNewConsumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)config.consumerProps());
        props.putAll((Map<?, ?>)config.extraConsumerProps());
        props.put("auto.offset.reset", config.options().has((OptionSpec)config.resetBeginningOpt()) ? "earliest" : "latest");
        props.put("bootstrap.servers", config.bootstrapServer());
        props.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.put("isolation.level", config.isolationLevel());
        return var2_2;
    }

    public boolean checkZkPathExists(String zkUrl, String path) {
        boolean bl;
        try {
            ZkClient zk = ZkUtils$.MODULE$.createZkClient(zkUrl, 30000, 30000);
            bl = zk.exists(path);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.messageCount = 0;
        this.kafka$tools$ConsoleConsumer$$shutdownLatch = new CountDownLatch(1);
    }
}

