/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.controller.IsrChangeNotificationListener$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplicationUtils$
implements Logging {
    public static ReplicationUtils$ MODULE$;
    private final String IsrChangeNotificationPrefix;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReplicationUtils$();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicationUtils$ replicationUtils$ = this;
        synchronized (replicationUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private String IsrChangeNotificationPrefix() {
        return this.IsrChangeNotificationPrefix;
    }

    public Tuple2<Object, Object> updateLeaderAndIsr(ZkUtils zkUtils2, String topic, int partitionId, LeaderAndIsr newLeaderAndIsr, int controllerEpoch, int zkVersion) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated ISR for ", "-", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), newLeaderAndIsr.isr().mkString(",")})));
        String path2 = ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partitionId);
        String newLeaderData = zkUtils2.leaderAndIsrZkData(newLeaderAndIsr, controllerEpoch);
        Tuple2<Object, Object> updatePersistentPath = zkUtils2.conditionalUpdatePersistentPath(path2, newLeaderData, zkVersion, (Option<Function3<ZkUtils, String, String, Tuple2<Object, Object>>>)new Some((Function3 & Serializable & scala.Serializable)(zkUtils, path, expectedLeaderAndIsrInfo) -> this.checkLeaderAndIsrZkData((ZkUtils)zkUtils, (String)path, (String)expectedLeaderAndIsrInfo)));
        return updatePersistentPath;
    }

    public void propagateIsrChanges(ZkUtils zkUtils, Set<TopicPartition> isrChangeSet) {
        String isrChangeNotificationPath = zkUtils.createSequentialPersistentPath(ZkUtils$.MODULE$.IsrChangeNotificationPath() + "/" + this.IsrChangeNotificationPrefix(), this.generateIsrChangeJson(isrChangeSet), zkUtils.createSequentialPersistentPath$default$3());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Added ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{isrChangeNotificationPath, isrChangeSet})));
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Object, Object> checkLeaderAndIsrZkData(ZkUtils zkUtils, String path, String expectedLeaderAndIsrInfo) {
        block6: {
            try {
                block7: {
                    writtenLeaderAndIsrInfo = zkUtils.readDataMaybeNull(path);
                    writtenLeaderOpt = (Option)writtenLeaderAndIsrInfo._1();
                    writtenStat = (Stat)writtenLeaderAndIsrInfo._2();
                    expectedLeader = this.parseLeaderAndIsr(expectedLeaderAndIsrInfo, path, writtenStat);
                    var10_8 = writtenLeaderOpt;
                    if (!(var10_8 instanceof Some)) break block7;
                    var11_9 = (Some)var10_8;
                    writtenData = (String)var11_9.value();
                    writtenLeader = this.parseLeaderAndIsr(writtenData, path, writtenStat);
                    var14_12 = new Tuple2(expectedLeader, writtenLeader);
                    if (var14_12 == null) ** GOTO lbl-1000
                    var15_13 = (Option)var14_12._1();
                    var16_14 = (Option)var14_12._2();
                    if (!(var15_13 instanceof Some)) ** GOTO lbl-1000
                    var17_15 = (Some)var15_13;
                    expectedLeader = (LeaderIsrAndControllerEpoch)var17_15.value();
                    if (var16_14 instanceof Some) {
                        var19_17 = (Some)var16_14;
                        writtenLeader = (LeaderIsrAndControllerEpoch)var19_17.value();
                        v0 = expectedLeader;
                        var21_19 = writtenLeader;
                        if (!(v0 != null ? v0.equals(var21_19) == false : var21_19 != null)) {
                            return new Tuple2.mcZI.sp(true, writtenStat.getVersion());
                        }
                        var5_20 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 3 sources

                    {
                        var5_21 = BoxedUnit.UNIT;
                    }
                    var4_22 = BoxedUnit.UNIT;
                    break block6;
                }
                if (None$.MODULE$.equals(var10_8)) {
                    var4_23 = BoxedUnit.UNIT;
                    break block6;
                }
                throw new MatchError((Object)var10_8);
            }
            catch (Exception v1) {}
        }
        return new Tuple2.mcZI.sp(false, -1);
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkUtils zkUtils, String topic, int partition) {
        String leaderAndIsrPath = ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition);
        Tuple2<Option<String>, Stat> tuple2 = zkUtils.readDataMaybeNull(leaderAndIsrPath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option leaderAndIsrOpt = (Option)tuple2._1();
        Stat stat = (Stat)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leaderAndIsrOpt, (Object)stat);
        Tuple2 tuple23 = tuple22;
        Option leaderAndIsrOpt2 = (Option)tuple23._1();
        Stat stat2 = (Stat)tuple23._2();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read leaderISR ", " for ", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leaderAndIsrOpt2, topic, BoxesRunTime.boxToInteger((int)partition)})));
        return leaderAndIsrOpt2.flatMap((Function1 & Serializable & scala.Serializable)leaderAndIsrStr -> this.parseLeaderAndIsr((String)leaderAndIsrStr, leaderAndIsrPath, stat2));
    }

    private Option<LeaderIsrAndControllerEpoch> parseLeaderAndIsr(String leaderAndIsrStr, String path, Stat stat) {
        return Json$.MODULE$.parseFull(leaderAndIsrStr).flatMap((Function1 & Serializable & scala.Serializable)m -> {
            Map leaderIsrAndEpochInfo = (Map)m;
            int leader = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader").get());
            int epoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader_epoch").get());
            List isr = (List)leaderIsrAndEpochInfo.get((Object)"isr").get();
            int controllerEpoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"controller_epoch").get());
            int zkPathVersion = stat.getVersion();
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader ", ", Epoch ", ", Isr ", ", Zk path version ", " for leaderAndIsrPath ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leader), BoxesRunTime.boxToInteger((int)epoch), isr, BoxesRunTime.boxToInteger((int)zkPathVersion), path})));
            return new Some((Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, epoch, (List<Object>)isr, zkPathVersion), controllerEpoch));
        });
    }

    private String generateIsrChangeJson(Set<TopicPartition> isrChanges) {
        Map[] partitions = (Map[])((TraversableOnce)isrChanges.map((Function1 & Serializable & scala.Serializable)tp -> (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition()))})), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Map.class));
        return Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToLong((long)IsrChangeNotificationListener$.MODULE$.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)partitions)})));
    }

    private ReplicationUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.IsrChangeNotificationPrefix = "isr_change_";
    }
}

