/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.metrics.KafkaMetricsReporter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaMetricReporterClusterIdTest$;
import kafka.server.KafkaMetricReporterClusterIdTest$MockBrokerMetricsReporter$;
import kafka.server.KafkaMetricReporterClusterIdTest$MockKafkaMetricsReporter$;
import kafka.server.KafkaServerStartable;
import kafka.server.KafkaServerStartable$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.VerifiableProperties;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015v!\u0002\u0012$\u0011\u0003Ac!\u0002\u0016$\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004b\u0002\u001b\u0002\u0005\u0004%\t!\u000e\u0005\u0007\u001b\u0006\u0001\u000b\u0011\u0002\u001c\u0007\t9\u000b\u0001a\u0014\u0005\u0006e\u0015!\t!\u0019\u0005\u0006I\u0016!\t%\u001a\u0005\u0006]\u0016!\te\\\u0004\u0006q\u0006A\t!\u001f\u0004\u0006\u001d\u0006A\tA\u001f\u0005\u0006e)!\ta\u001f\u0005\by*\u0011\r\u0011\"\u0001~\u0011\u0019y(\u0002)A\u0005}\u001e9\u0011\u0011A\u0001\t\u0002\u0005\raaBA\u0003\u0003!\u0005\u0011q\u0001\u0005\u0007e=!\t!!\u0003\t\u000fq|!\u0019!C\u0001{\"1qp\u0004Q\u0001\ny4a!!\u0002\u0002\u0001\u0005-\u0001B\u0002\u001a\u0014\t\u0003\tI\u0002\u0003\u0004e'\u0011\u0005\u0013Q\u0004\u0005\b\u0003C\u0019B\u0011IA\u0012\r\u0015Q3\u0005AA%\u0011\u0019\u0011t\u0003\"\u0001\u0002X!AAe\u0006a\u0001\n\u0003\tY\u0006C\u0005\u0002d]\u0001\r\u0011\"\u0001\u0002f!A\u00111N\f!B\u0013\ti\u0006C\u0005\u0002n]\u0001\r\u0011\"\u0001\u0002p!I\u0011qO\fA\u0002\u0013\u0005\u0011\u0011\u0010\u0005\t\u0003{:\u0002\u0015)\u0003\u0002r!9\u0011qP\f\u0005B\u0005\u0005\u0005bBAI/\u0011\u0005\u0011\u0011\u0011\u0005\b\u00037;B\u0011IAA\u0003\u0001Z\u0015MZ6b\u001b\u0016$(/[2SKB|'\u000f^3s\u00072,8\u000f^3s\u0013\u0012$Vm\u001d;\u000b\u0005\u0011*\u0013AB:feZ,'OC\u0001'\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!K\u0001\u000e\u0003\r\u0012\u0001eS1gW\u0006lU\r\u001e:jGJ+\u0007o\u001c:uKJ\u001cE.^:uKJLE\rV3tiN\u0011\u0011\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0013AC:fiV\u0004XI\u001d:peV\ta\u0007E\u00028\u0001\nk\u0011\u0001\u000f\u0006\u0003si\na!\u0019;p[&\u001c'BA\u001e=\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!9\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA\"K\u001d\t!\u0005\n\u0005\u0002F]5\taI\u0003\u0002HO\u00051AH]8pizJ!!\u0013\u0018\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013:\n1b]3ukB,%O]8sA\tARj\\2l\u0017\u000647.Y'fiJL7m\u001d*fa>\u0014H/\u001a:\u0014\t\u0015a\u0003K\u0016\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0016\nq!\\3ue&\u001c7/\u0003\u0002V%\n!2*\u00194lC6+GO]5dgJ+\u0007o\u001c:uKJ\u0004\"aV0\u000e\u0003aS!!\u0017.\u0002\r\r|W.\\8o\u0015\t13L\u0003\u0002];\u00061\u0011\r]1dQ\u0016T\u0011AX\u0001\u0004_J<\u0017B\u00011Y\u0005]\u0019E.^:uKJ\u0014Vm]8ve\u000e,G*[:uK:,'\u000fF\u0001c!\t\u0019W!D\u0001\u0002\u0003!yg.\u00169eCR,GC\u00014j!\tis-\u0003\u0002i]\t!QK\\5u\u0011\u0015Qw\u00011\u0001l\u0003=\u0019G.^:uKJlU\r^1eCR\f\u0007CA,m\u0013\ti\u0007LA\bDYV\u001cH/\u001a:SKN|WO]2f\u0003\u0011Ig.\u001b;\u0015\u0005\u0019\u0004\b\"B9\t\u0001\u0004\u0011\u0018!\u00029s_B\u001c\bCA:w\u001b\u0005!(BA;&\u0003\u0015)H/\u001b7t\u0013\t9HO\u0001\u000bWKJLg-[1cY\u0016\u0004&o\u001c9feRLWm]\u0001\u0019\u001b>\u001c7nS1gW\u0006lU\r\u001e:jGN\u0014V\r]8si\u0016\u0014\bCA2\u000b'\tQA\u0006F\u0001z\u00031\u0019E*V*U\u000bJ{V*\u0012+B+\u0005q\bcA\u001cAW\u0006i1\tT+T)\u0016\u0013v,T#U\u0003\u0002\n\u0011$T8dW\n\u0013xn[3s\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;feB\u00111m\u0004\u0002\u001a\u001b>\u001c7N\u0011:pW\u0016\u0014X*\u001a;sS\u000e\u001c(+\u001a9peR,'o\u0005\u0002\u0010YQ\u0011\u00111A\n\u0005'\u00055a\u000b\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019BW\u0001\u0005i\u0016\u001cH/\u0003\u0003\u0002\u0018\u0005E!aE'pG.lU\r\u001e:jGN\u0014V\r]8si\u0016\u0014HCAA\u000e!\t\u00197\u0003F\u0002g\u0003?AQA[\u000bA\u0002-\f\u0011bY8oM&<WO]3\u0015\u0007\u0019\f)\u0003C\u0004\u0002(Y\u0001\r!!\u000b\u0002\u000f\r|gNZ5hgB\"\u00111FA\u001c!\u001d\ti#a\fC\u0003gi\u0011\u0001P\u0005\u0004\u0003ca$aA'baB!\u0011QGA\u001c\u0019\u0001!A\"!\u000f\u0002&\u0005\u0005\t\u0011!B\u0001\u0003w\u00111a\u0018\u00132#\u0011\ti$a\u0011\u0011\u00075\ny$C\u0002\u0002B9\u0012qAT8uQ&tw\rE\u0002.\u0003\u000bJ1!a\u0012/\u0005\r\te._\n\u0004/\u0005-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005ES%\u0001\u0002{W&!\u0011QKA(\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgR\u0011\u0011\u0011\f\t\u0003S])\"!!\u0018\u0011\u0007%\ny&C\u0002\u0002b\r\u0012AcS1gW\u0006\u001cVM\u001d<feN#\u0018M\u001d;bE2,\u0017AC:feZ,'o\u0018\u0013fcR\u0019a-a\u001a\t\u0013\u0005%$$!AA\u0002\u0005u\u0013a\u0001=%c\u000591/\u001a:wKJ\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002rA\u0019\u0011&a\u001d\n\u0007\u0005U4EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR\u0019a-a\u001f\t\u0013\u0005%T$!AA\u0002\u0005E\u0014aB2p]\u001aLw\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002M\"\u001aq$!\"\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#^\u0003\u0015QWO\\5u\u0013\u0011\ty)!#\u0003\r\t+gm\u001c:f\u0003Q!Xm\u001d;DYV\u001cH/\u001a:JIB\u0013Xm]3oi\"\u001a\u0001%!&\u0011\t\u0005\u001d\u0015qS\u0005\u0005\u00033\u000bII\u0001\u0003UKN$\u0018\u0001\u0003;fCJ$un\u001e8)\u0007\u0005\ny\n\u0005\u0003\u0002\b\u0006\u0005\u0016\u0002BAR\u0003\u0013\u0013Q!\u00114uKJ\u0004")
public class KafkaMetricReporterClusterIdTest
extends ZooKeeperTestHarness {
    private KafkaServerStartable server = null;
    private KafkaConfig config = null;

    public static AtomicReference<String> setupError() {
        return KafkaMetricReporterClusterIdTest$.MODULE$.setupError();
    }

    public KafkaServerStartable server() {
        return this.server;
    }

    public void server_$eq(KafkaServerStartable x$1) {
        this.server = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.setProperty(KafkaConfig$.MODULE$.KafkaMetricsReporterClassesProp(), "kafka.server.KafkaMetricReporterClusterIdTest$MockKafkaMetricsReporter");
        props.setProperty(KafkaConfig$.MODULE$.MetricReporterClassesProp(), "kafka.server.KafkaMetricReporterClusterIdTest$MockBrokerMetricsReporter");
        props.setProperty(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "true");
        props.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "-1");
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.server_$eq(KafkaServerStartable$.MODULE$.fromProps(props, Option$.MODULE$.apply((Object)this.getClass().getName())));
        this.server().startup();
    }

    @Test
    public void testClusterIdPresent() {
        Assert.assertEquals((Object)"", (Object)KafkaMetricReporterClusterIdTest$.MODULE$.setupError().get());
        Assert.assertNotNull(KafkaMetricReporterClusterIdTest$MockKafkaMetricsReporter$.MODULE$.CLUSTER_META());
        TestUtils.isValidClusterId((String)KafkaMetricReporterClusterIdTest$MockKafkaMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        Assert.assertNotNull(KafkaMetricReporterClusterIdTest$MockBrokerMetricsReporter$.MODULE$.CLUSTER_META());
        TestUtils.isValidClusterId((String)KafkaMetricReporterClusterIdTest$MockBrokerMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        Assert.assertEquals((Object)KafkaMetricReporterClusterIdTest$MockKafkaMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId(), (Object)KafkaMetricReporterClusterIdTest$MockBrokerMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        this.server().shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Override
    @After
    public void tearDown() {
        this.server().shutdown();
        CoreUtils$.MODULE$.delete(this.config().logDirs());
        super.tearDown();
    }

    public static class MockBrokerMetricsReporter
    extends MockMetricsReporter
    implements ClusterResourceListener {
        public void onUpdate(ClusterResource clusterMetadata) {
            KafkaMetricReporterClusterIdTest$MockBrokerMetricsReporter$.MODULE$.CLUSTER_META().set(clusterMetadata);
        }

        public void configure(Map<String, ?> configs) {
            Object brokerId = configs.get(KafkaConfig$.MODULE$.BrokerIdProp());
            if (brokerId == null) {
                KafkaMetricReporterClusterIdTest$.MODULE$.setupError().compareAndSet("", "No value was set for the broker id.");
            } else if (!(brokerId instanceof String)) {
                KafkaMetricReporterClusterIdTest$.MODULE$.setupError().compareAndSet("", "The value set for the broker id was not a string.");
            }
            try {
                Integer.parseInt((String)brokerId);
                return;
            }
            catch (Exception e) {
                KafkaMetricReporterClusterIdTest$.MODULE$.setupError().compareAndSet("", new StringBuilder(24).append("Error parsing broker id ").append(e.toString()).toString());
                return;
            }
        }
    }

    public static class MockKafkaMetricsReporter
    implements KafkaMetricsReporter,
    ClusterResourceListener {
        public void onUpdate(ClusterResource clusterMetadata) {
            KafkaMetricReporterClusterIdTest$MockKafkaMetricsReporter$.MODULE$.CLUSTER_META().set(clusterMetadata);
        }

        public void init(VerifiableProperties props) {
        }
    }
}

