/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.cluster;

import kafka.cluster.AssignmentState;
import kafka.cluster.SimpleAssignmentState;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import unit.kafka.cluster.AbstractPartitionTest;
import unit.kafka.cluster.AssignmentStateTest$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0005\u0005\rq!B\u0007\u000f\u0011\u0003)b!B\f\u000f\u0011\u0003A\u0002\"\u0002\u000f\u0002\t\u0003i\u0002\"\u0002\u0010\u0002\t\u0003yb\u0001B\f\u000f\u0001\u0005C\u0001B\u0011\u0003\u0003\u0002\u0003\u0006Ia\u0011\u0005\t)\u0012\u0011\t\u0011)A\u0005\u0007\"AQ\u000b\u0002B\u0001B\u0003%1\t\u0003\u0005W\t\t\u0005\t\u0015!\u0003D\u0011!9FA!A!\u0002\u0013A\u0006\u0002\u00030\u0005\u0005\u0003\u0005\u000b\u0011B0\t\u000bq!A\u0011\u00012\t\u000b)$A\u0011A6\u0002'\u0005\u001b8/[4o[\u0016tGo\u0015;bi\u0016$Vm\u001d;\u000b\u0005=\u0001\u0012aB2mkN$XM\u001d\u0006\u0003#I\tQa[1gW\u0006T\u0011aE\u0001\u0005k:LGo\u0001\u0001\u0011\u0005Y\tQ\"\u0001\b\u0003'\u0005\u001b8/[4o[\u0016tGo\u0015;bi\u0016$Vm\u001d;\u0014\u0005\u0005I\u0002C\u0001\f\u001b\u0013\tYbBA\u000bBEN$(/Y2u!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005)\u0012\u0001\u00023bi\u0006,\u0012\u0001\t\t\u0004C\u00112S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0005\"s\u0005\u0005\u0002\"Q%\u0011\u0011F\t\u0002\u0004\u0003:L\bFA\u0002,!\tacH\u0004\u0002.w9\u0011a\u0006\u000f\b\u0003_Ur!\u0001M\u001a\u000e\u0003ER!A\r\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014aA8sO&\u0011agN\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002i%\u0011\u0011HO\u0001\beVtg.\u001a:t\u0015\t1t'\u0003\u0002={\u0005i\u0001+\u0019:b[\u0016$XM]5{K\u0012T!!\u000f\u001e\n\u0005}\u0002%A\u0003)be\u0006lW\r^3sg*\u0011A(P\n\u0003\te\t1![:s!\r!\u0015\n\u0014\b\u0003\u000b\u001es!\u0001\r$\n\u0003\rJ!\u0001\u0013\u0012\u0002\u000fA\f7m[1hK&\u0011!j\u0013\u0002\u0005\u0019&\u001cHO\u0003\u0002IEA\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0005Y\u0006twMC\u0001R\u0003\u0011Q\u0017M^1\n\u0005Ms%aB%oi\u0016<WM]\u0001\te\u0016\u0004H.[2bg\u00061\u0011\r\u001a3j]\u001e\f\u0001B]3n_ZLgnZ\u0001\t_JLw-\u001b8bYB\u0019A)W.\n\u0005i[%aA*fcB\u0011\u0011\u0005X\u0005\u0003;\n\u00121!\u00138u\u0003EI7/\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a\t\u0003C\u0001L!!\u0019\u0012\u0003\u000f\t{w\u000e\\3b]R91\rZ3gO\"L\u0007C\u0001\f\u0005\u0011\u0015\u00115\u00021\u0001D\u0011\u0015!6\u00021\u0001D\u0011\u0015)6\u00021\u0001D\u0011\u001516\u00021\u0001D\u0011\u001596\u00021\u0001Y\u0011\u0015q6\u00021\u0001`\u0003u!Xm\u001d;QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tGo\u0015;biV\u001cH#\u00017\u0011\u0005\u0005j\u0017B\u00018#\u0005\u0011)f.\u001b;)\u00051\u0001\bCA9s\u001b\u0005Q\u0014BA:;\u0005\u0011!Vm\u001d;)\t\u0011)8\u0010 \t\u0003mfl\u0011a\u001e\u0006\u0003qj\naA];o]\u0016\u0014\u0018B\u0001>x\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013! \t\u0003}~l\u0011!P\u0005\u0004\u0003\u0003i$!\u0004)be\u0006lW\r^3sSj,G\r")
public class AssignmentStateTest
extends AbstractPartitionTest {
    private final List<Integer> isr;
    private final List<Integer> replicas;
    private final List<Integer> adding;
    private final List<Integer> removing;
    private final Seq<Object> original;
    private final boolean isUnderReplicated;

    @Parameterized.Parameters
    public static Object[][] data() {
        return AssignmentStateTest$.MODULE$.data();
    }

    @Test
    public void testPartitionAssignmentStatus() {
        boolean isReassigning;
        int controllerEpoch = 3;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.isr).asJava()).setZkVersion(1).setReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.replicas).asJava()).setIsNew(false);
        if (this.adding.nonEmpty()) {
            leaderState.setAddingReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.adding).asJava());
        }
        if (this.removing.nonEmpty()) {
            leaderState.setRemovingReplicas(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.removing).asJava());
        }
        boolean bl = isReassigning = this.adding.nonEmpty() || this.removing.nonEmpty();
        if (this.original.nonEmpty()) {
            this.partition().assignmentState_$eq((AssignmentState)new SimpleAssignmentState(this.original));
        }
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assert.assertEquals((Object)isReassigning, (Object)this.partition().isReassigning());
        if (this.adding.nonEmpty()) {
            List list = this.adding;
            if (list == null) {
                throw null;
            }
            List foreach_these = list;
            while (!foreach_these.isEmpty()) {
                Integer n = (Integer)foreach_these.head();
                AssignmentStateTest.$anonfun$testPartitionAssignmentStatus$1$adapted(this, n);
                foreach_these = (List)foreach_these.tail();
            }
            Object var4_4 = null;
        }
        if (this.adding.contains((Object)this.brokerId())) {
            Assert.assertTrue((boolean)this.partition().isAddingLocalReplica());
        } else {
            Assert.assertFalse((boolean)this.partition().isAddingLocalReplica());
        }
        Assert.assertEquals((Object)this.isUnderReplicated, (Object)this.partition().isUnderReplicated());
    }

    public static final /* synthetic */ void $anonfun$testPartitionAssignmentStatus$1(AssignmentStateTest $this, Integer r) {
        Assert.assertTrue((boolean)$this.partition().isAddingReplica(BoxesRunTime.unboxToInt((Object)r)));
    }

    public AssignmentStateTest(List<Integer> isr, List<Integer> replicas, List<Integer> adding, List<Integer> removing, Seq<Object> original, boolean isUnderReplicated) {
        this.isr = isr;
        this.replicas = replicas;
        this.adding = adding;
        this.removing = removing;
        this.original = original;
        this.isUnderReplicated = isUnderReplicated;
    }

    public static final /* synthetic */ Object $anonfun$testPartitionAssignmentStatus$1$adapted(AssignmentStateTest $this, Integer r) {
        AssignmentStateTest.$anonfun$testPartitionAssignmentStatus$1($this, r);
        return BoxedUnit.UNIT;
    }
}

