/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import kafka.admin.LeaderElectionCommand$;
import kafka.admin.LeaderElectionCommandTest$;
import kafka.common.AdminCommandFailedException;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.DurationConversions;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\u000f\u001f\u0005\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001A\u0002\u0013\u0005q\u0006C\u0004?\u0001\u0001\u0007I\u0011A \t\r\u0019\u0003\u0001\u0015)\u00031\u0011\u001d9\u0005A1A\u0005\u0002!Ca\u0001\u0014\u0001!\u0002\u0013I\u0005bB'\u0001\u0005\u0004%\t\u0001\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B%\t\u000f=\u0003!\u0019!C\u0001\u0011\"1\u0001\u000b\u0001Q\u0001\n%CQ!\u0015\u0001\u0005BICQ\u0001\u0018\u0001\u0005BICQ!\u0019\u0001\u0005\u0002ICQA\u001a\u0001\u0005\u0002ICQ\u0001\u001b\u0001\u0005\u0002ICQA\u001b\u0001\u0005\u0002ICQ\u0001\u001c\u0001\u0005\u0002ICQA\u001c\u0001\u0005\u0002ICQ\u0001\u001d\u0001\u0005\u0002ICQA\u001d\u0001\u0005\u0002ICQ\u0001\u001e\u0001\u0005\u0002ICQA\u001e\u0001\u0005\u0002I;Q\u0001\u001f\u0010\t\u0002e4Q!\b\u0010\t\u0002iDQA\u000b\r\u0005\u0002yDaa \r\u0005\u0002\u0005\u0005\u0001bBA\u00191\u0011\u0005\u00111\u0007\u0005\b\u0003oAB\u0011AA\u001d\u0005eaU-\u00193fe\u0016cWm\u0019;j_:\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005}\u0001\u0013!B1e[&t'\"A\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0003O\u0001\n!A_6\n\u0005%2#\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002YA\u0011Q\u0006A\u0007\u0002=\u000591/\u001a:wKJ\u001cX#\u0001\u0019\u0011\u0007E2\u0004(D\u00013\u0015\t\u0019D'\u0001\u0006d_2dWm\u0019;j_:T\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oI\u00121aU3r!\tID(D\u0001;\u0015\tY\u0004%\u0001\u0004tKJ4XM]\u0005\u0003{i\u00121bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t\u0001E\t\u0005\u0002B\u00056\tA'\u0003\u0002Di\t!QK\\5u\u0011\u001d)5!!AA\u0002A\n1\u0001\u001f\u00132\u0003!\u0019XM\u001d<feN\u0004\u0013a\u00022s_.,'/M\u000b\u0002\u0013B\u0011\u0011IS\u0005\u0003\u0017R\u00121!\u00138u\u0003!\u0011'o\\6feF\u0002\u0013a\u00022s_.,'OM\u0001\tEJ|7.\u001a:3A\u00059!M]8lKJ\u001c\u0014\u0001\u00032s_.,'o\r\u0011\u0002\u000bM,G/\u00169\u0015\u0003\u0001C#a\u0003+\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016!\u00026v]&$(\"A-\u0002\u0007=\u0014x-\u0003\u0002\\-\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u0019y\u0003\"!V0\n\u0005\u00014&!B!gi\u0016\u0014\u0018!\u0006;fgR\fE\u000e\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0015\u0003\u001b\r\u0004\"!\u00163\n\u0005\u00154&\u0001\u0002+fgR\f!\u0003^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]\"\u0012abY\u0001\u0013i\u0016\u001cH\u000fU1uQR{'j]8o\r&dW\r\u000b\u0002\u0010G\u0006aB/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006,E.Z2uS>t\u0007F\u0001\td\u0003e!Xm\u001d;U_BL7mV5uQ>,H\u000fU1si&$\u0018n\u001c8)\u0005E\u0019\u0017!\u0007;fgR\u0004\u0016M\u001d;ji&|gnV5uQ>,H\u000fV8qS\u000eD#AE2\u0002+Q,7\u000f\u001e+pa&\u001cGi\\3t\u001d>$X\t_5ti\"\u00121cY\u0001\u0018i\u0016\u001cH/T5tg&tw-\u00127fGRLwN\u001c+za\u0016D#\u0001F2\u0002EQ,7\u000f^'jgNLgn\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\*fY\u0016\u001cG/[8oQ\t)2-A\tuKN$\u0018J\u001c<bY&$'I]8lKJD#AF2\u000231+\u0017\rZ3s\u000b2,7\r^5p]\u000e{W.\\1oIR+7\u000f\u001e\t\u0003[a\u0019\"\u0001G>\u0011\u0005\u0005c\u0018BA?5\u0005\u0019\te.\u001f*fMR\t\u00110\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\r\u0006\u0003\u0002\u0004\u0005=\u0002\u0003CA\u0003\u0003'\tI\"a\b\u000f\t\u0005\u001d\u0011q\u0002\t\u0004\u0003\u0013!TBAA\u0006\u0015\r\tiAI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005EA'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\t9BA\u0002NCBT1!!\u00055!\u0011\t)!a\u0007\n\t\u0005u\u0011q\u0003\u0002\u0007'R\u0014\u0018N\\4\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005!A.\u00198h\u0015\t\tI#\u0001\u0003kCZ\f\u0017\u0002BA\u0017\u0003G\u0011aa\u00142kK\u000e$\b\"\u0002\u0018\u001b\u0001\u0004\u0001\u0014\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t)\u0011\tI\"!\u000e\t\u000b9Z\u0002\u0019\u0001\u0019\u0002-Q,W\u000e\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c$jY\u0016$B!a\u000f\u0002LA!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00024jY\u0016TA!!\u0012\u0002(\u0005\u0019a.[8\n\t\u0005%\u0013q\b\u0002\u0005!\u0006$\b\u000eC\u0004\u0002Nq\u0001\r!a\u0014\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0002\u0006\u0005E\u0013QK\u0005\u0005\u0003'\n9BA\u0002TKR\u0004B!a\u0016\u0002d5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0004d_6lwN\u001c\u0006\u0004C\u0005}#bAA11\u00061\u0011\r]1dQ\u0016LA!!\u001a\u0002Z\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007")
public final class LeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int broker1;
    private final int broker2;
    private final int broker3;

    public static Path tempTopicPartitionFile(Set<TopicPartition> set) {
        return LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile(set);
    }

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.bootstrapServers(seq);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.createConfig(seq);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable)config -> {
            config.setProperty("auto.leader.rebalance.enable", "false");
            config.setProperty("controlled.shutdown.enable", "true");
            config.setProperty("controlled.shutdown.max.retries", "1");
            config.setProperty("controlled.shutdown.retry.backoff.ms", "1000");
            return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), Time.SYSTEM, (Option<String>)None$.MODULE$);
        })));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAllTopicPartition() {
        try (Admin resource_resource = Admin.create((java.util.Map)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testAllTopicPartition$1(this, resource_resource);
        }
    }

    @Test
    public void testTopicPartition() {
        try (Admin resource_resource = Admin.create((java.util.Map)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testTopicPartition$1(this, resource_resource);
        }
    }

    @Test
    public void testPathToJsonFile() {
        try (Admin resource_resource = Admin.create((java.util.Map)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testPathToJsonFile$1(this, resource_resource);
        }
    }

    @Test
    public void testPreferredReplicaElection() {
        try (Admin resource_resource = Admin.create((java.util.Map)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testPreferredReplicaElection$1(this, resource_resource);
        }
    }

    @Test
    public void testTopicWithoutPartition() {
        try {
            LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "unclean", "--topic", "some-topic"});
            Assert.fail();
            return;
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing required option(s)"));
            Assert.assertTrue((boolean)e.getMessage().contains(" partition"));
            return;
        }
    }

    @Test
    public void testPartitionWithoutTopic() {
        try {
            LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "unclean", "--all-topic-partitions", "--partition", "0"});
            Assert.fail();
            return;
        }
        catch (Throwable e) {
            Assert.assertEquals((Object)"Option partition is only allowed if topic is used", (Object)e.getMessage());
            return;
        }
    }

    @Test
    public void testTopicDoesNotExist() {
        try {
            LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "preferred", "--topic", "unknown-topic-name", "--partition", "0"});
            Assert.fail();
            return;
        }
        catch (AdminCommandFailedException adminCommandFailedException) {
            Assert.assertTrue((boolean)(adminCommandFailedException.getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
            return;
        }
    }

    @Test
    public void testMissingElectionType() {
        try {
            LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--topic", "some-topic", "--partition", "0"});
            Assert.fail();
            return;
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing required option(s)"));
            Assert.assertTrue((boolean)e.getMessage().contains(" election-type"));
            return;
        }
    }

    @Test
    public void testMissingTopicPartitionSelection() {
        try {
            LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "preferred"});
            Assert.fail();
            return;
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("One and only one of the following options is required: "));
            Assert.assertTrue((boolean)e.getMessage().contains(" all-topic-partitions"));
            Assert.assertTrue((boolean)e.getMessage().contains(" topic"));
            Assert.assertTrue((boolean)e.getMessage().contains(" path-to-json-file"));
            return;
        }
    }

    @Test
    public void testInvalidBroker() {
        try {
            LeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", "example.com:1234", "--election-type", "unclean", "--all-topic-partitions"}, (Duration)DurationConversions.seconds$((DurationConversions)new package.DurationInt(1)));
            Assert.fail();
            return;
        }
        catch (AdminCommandFailedException adminCommandFailedException) {
            Assert.assertTrue((boolean)(adminCommandFailedException.getCause() instanceof TimeoutException));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAllTopicPartition$1(LeaderElectionCommandTest $this, Admin client) {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Integer n;
        Integer n2;
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(partition);
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        Object var6_7 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3)), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--all-topic-partitions"});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTopicPartition$1(LeaderElectionCommandTest $this, Admin client) {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Integer n;
        Integer n2;
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(partition);
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        Object var6_7 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3)), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--topic", topic, "--partition", ((Object)partition).toString()});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testPathToJsonFile$1(LeaderElectionCommandTest $this, Admin client) {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        Integer n;
        Integer n2;
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(partition);
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        Object var7_7 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems4)), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition});
        if (set$3 == null) {
            throw null;
        }
        arraySeq4 = null;
        Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems)));
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--path-to-json-file", ((Object)topicPartitionPath).toString()});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testPreferredReplicaElection$1(LeaderElectionCommandTest $this, Admin client) {
        void apply_elems;
        void apply_elems2;
        Integer n;
        Integer n2;
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(partition);
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        Object var6_7 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2)), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
        ((KafkaServer)$this.servers().apply($this.broker2())).startup();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2()});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)));
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "preferred", "--all-topic-partitions"});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
    }

    public LeaderElectionCommandTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
    }

    public static final /* synthetic */ Object $anonfun$testAllTopicPartition$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testAllTopicPartition$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTopicPartition$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testTopicPartition$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPathToJsonFile$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testPathToJsonFile$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPreferredReplicaElection$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testPreferredReplicaElection$1($this, client);
        return BoxedUnit.UNIT;
    }
}

