/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rMg\u0001\u0002.\\\u0001\u0001DQa\u001a\u0001\u0005\u0002!Dqa\u001b\u0001C\u0002\u0013\u0005A\u000e\u0003\u0004{\u0001\u0001\u0006I!\u001c\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nuD\u0011\"!\u0002\u0001\u0005\u0004%\t!a\u0002\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u0013A\u0011\"a\u0006\u0001\u0005\u0004%\t!!\u0007\t\u0011\u0005\r\u0003\u0001)A\u0005\u00037Aq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002^\u0001!\t!a\u0012\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002H!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0003bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!!*\u0001\t\u0013\t9\u000bC\u0004\u0002V\u0002!\t!a\u0012\t\u000f\u0005e\u0007\u0001\"\u0001\u0002H!9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007bBAr\u0001\u0011\u0005\u0011q\t\u0005\b\u0003O\u0004A\u0011BAu\u0011\u001d\ty\u000f\u0001C\u0001\u0003\u000fBq!a=\u0001\t\u0003\t9\u0005C\u0004\u0002x\u0002!I!!?\t\u000f\u0005u\b\u0001\"\u0001\u0002H!9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u00057\u0001A\u0011AA$\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003\u000fBqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u0003*\u0001!\t!a\u0012\t\u000f\t5\u0002\u0001\"\u0001\u0002H!9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B\u001c\u0001\u0011\u0005\u0011q\t\u0005\b\u0005w\u0001A\u0011AA$\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003BqAa\u0012\u0001\t\u0003\t9\u0005C\u0004\u0003L\u0001!\t!a\u0012\t\u000f\t=\u0003\u0001\"\u0001\u0002H!9!1\u000b\u0001\u0005\n\tU\u0003b\u0002B-\u0001\u0011\u0005\u0011q\t\u0005\b\u0005;\u0002A\u0011AA$\u0011\u001d\u0011y\u0007\u0001C\u0001\u0003\u000fBqAa\u001d\u0001\t\u0003\t9\u0005C\u0004\u0003x\u0001!\t!a\u0012\t\u000f\tm\u0004\u0001\"\u0001\u0002H!9!q\u0010\u0001\u0005\u0002\u0005\u001d\u0003b\u0002BB\u0001\u0011\u0005\u0011q\t\u0005\b\u0005\u000f\u0003A\u0011AA$\u0011\u001d\u0011Y\t\u0001C\u0001\u0003\u000fBqAa$\u0001\t\u0003\t9\u0005C\u0004\u0003\u0014\u0002!\t!a\u0012\t\u000f\t]\u0005\u0001\"\u0001\u0002H!9!1\u0014\u0001\u0005\u0002\u0005\u001d\u0003b\u0002BP\u0001\u0011\u0005\u0011q\t\u0005\b\u0005G\u0003A\u0011AA$\u0011\u001d\u0011y\u000b\u0001C\u0001\u0003\u000fBqAa-\u0001\t\u0003\t9\u0005C\u0004\u00038\u0002!\t!a\u0012\t\u000f\tm\u0006\u0001\"\u0001\u0002H!9!q\u0018\u0001\u0005\u0002\u0005\u001d\u0003b\u0002Bb\u0001\u0011\u0005\u0011q\t\u0005\b\u0005\u000f\u0004A\u0011AA$\u0011\u001d\u0011Y\r\u0001C\u0001\u0003\u000fBqA!8\u0001\t\u0003\t9\u0005C\u0004\u0003b\u0002!\t!a\u0012\t\u000f\t\u0015\b\u0001\"\u0001\u0002H!9!\u0011\u001e\u0001\u0005\u0002\u0005\u001d\u0003b\u0002Bw\u0001\u0011\u0005\u0011q\t\u0005\b\u0005c\u0004A\u0011AA$\u0011\u001d\u0011i\u0010\u0001C\u0001\u0003\u000fBqa!\u0001\u0001\t\u0003\t9\u0005C\u0004\u0004\u0006\u0001!\t!a\u0012\t\u000f\r%\u0001\u0001\"\u0001\u0002H!91Q\u0002\u0001\u0005\u0002\u0005\u001d\u0003bBB\t\u0001\u0011%11\u0003\u0005\b\u0007S\u0001A\u0011BB\u0016\u0011%\u0019y\u0004AI\u0001\n\u0013\u0019\t\u0005C\u0004\u0004X\u0001!Ia!\u0017\t\u0013\r\u0005\u0004!%A\u0005\n\r\u0005\u0003\"CB2\u0001E\u0005I\u0011BB3\u0011\u001d\u0019I\u0007\u0001C\u0005\u0007WBqaa\u001d\u0001\t\u0003\u0019)\bC\u0004\u0004~\u0001!Iaa \t\u000f\r%\u0005\u0001\"\u0003\u0004\f\"91q\u0013\u0001\u0005\u0002\re\u0005bBBT\u0001\u0011\u00051\u0011\u0016\u0005\b\u0007k\u0003A\u0011AB\\\u0005Aaun\u001a,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002];\u0006\u0019An\\4\u000b\u0003y\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A5\u0011\u0005)\u0004Q\"A.\u0002\tQLW.Z\u000b\u0002[B\u0011a\u000e_\u0007\u0002_*\u0011\u0001/]\u0001\u0006kRLGn\u001d\u0006\u0003eN\faaY8n[>t'B\u00010u\u0015\t)h/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0006\u0019qN]4\n\u0005e|'\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001~!\tqx0D\u0001r\u0013\r\t\t!\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\t\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!X\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005M\u0011Q\u0002\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\f\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:!\u00035iW\r\u001e:jGN\\U-_*fiV\u0011\u00111\u0004\t\u0007\u0003;\t9#a\u000b\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tq!\\;uC\ndWMC\u0002\u0002&\r\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\b\u0003\u0007M+G\u000f\u0005\u0003\u0002.\u0005}RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t\r|'/\u001a\u0006\u0005\u0003k\t9$A\u0004nKR\u0014\u0018nY:\u000b\t\u0005e\u00121H\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005u\u0012aA2p[&!\u0011\u0011IA\u0018\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u000f[\u0016$(/[2t\u0017\u0016L8+\u001a;!\u0003A!Xm\u001d;P]2LxJ\\3CCR\u001c\u0007\u000e\u0006\u0002\u0002JA\u0019!-a\u0013\n\u0007\u000553M\u0001\u0003V]&$\bf\u0001\u0006\u0002RA!\u00111KA-\u001b\t\t)FC\u0002\u0002XY\fQA[;oSRLA!a\u0017\u0002V\t!A+Z:u\u0003M!Xm\u001d;BY2|w/T;mi&\u0014\u0015\r^2iQ\rY\u0011\u0011K\u00015i\u0016\u001cHOV1mS\u0012\fG/[8o\u001f\u001a\u0014\u0015\r^2iKN<\u0016\u000e\u001e5O_:\u001cV-];f]RL\u0017\r\\%o]\u0016\u0014xJ\u001a4tKR\u001c\bf\u0001\u0007\u0002R\u0005\tB/Z:u\u001b&\u001cX*\u0019;dQ6\u000bw-[2)\u00075\t\t&A\tdQ\u0016\u001c7n\u00148ms>sWMQ1uG\"$\u0002\"!\u0013\u0002n\u0005]\u0014q\u0011\u0005\b\u0003_r\u0001\u0019AA9\u0003\u0015i\u0017mZ5d!\r\u0011\u00171O\u0005\u0004\u0003k\u001a'\u0001\u0002\"zi\u0016Dq!!\u001f\u000f\u0001\u0004\tY(A\u000bt_V\u00148-Z\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!r\u0003\u0019\u0011XmY8sI&!\u0011QQA@\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007bBAE\u001d\u0001\u0007\u00111P\u0001\u0016i\u0006\u0014x-\u001a;D_6\u0004(/Z:tS>tG+\u001f9f\u0003Q\u0019\u0007.Z2l\u00032dwn^'vYRL')\u0019;dQRA\u0011\u0011JAH\u0003#\u000b\u0019\nC\u0004\u0002p=\u0001\r!!\u001d\t\u000f\u0005et\u00021\u0001\u0002|!9\u0011\u0011R\bA\u0002\u0005m\u0014AE2iK\u000e\\W*[:nCR\u001c\u0007.T1hS\u000e$\u0002\"!\u0013\u0002\u001a\u0006u\u0015\u0011\u0015\u0005\b\u00037\u0003\u0002\u0019AA9\u0003)\u0011\u0017\r^2i\u001b\u0006<\u0017n\u0019\u0005\b\u0003?\u0003\u0002\u0019AA9\u0003-\u0011XmY8sI6\u000bw-[2\t\u000f\u0005\r\u0006\u00031\u0001\u0002|\u0005y1m\\7qe\u0016\u001c8/[8o)f\u0004X-\u0001\twC2LG-\u0019;f\u001b\u0016\u001c8/Y4fgRQ\u0011\u0011VAc\u0003\u001f\f\t.a5\u0011\t\u0005-\u0016q\u0018\b\u0005\u0003[\u000bYL\u0004\u0003\u00020\u0006ef\u0002BAY\u0003ok!!a-\u000b\u0007\u0005Uv,\u0001\u0004=e>|GOP\u0005\u0002=&\u0011A,X\u0005\u0004\u0003{[\u0016\u0001\u0004'pOZ\u000bG.\u001b3bi>\u0014\u0018\u0002BAa\u0003\u0007\u0014qDV1mS\u0012\fG/[8o\u0003:$wJ\u001a4tKR\f5o]5h]J+7/\u001e7u\u0015\r\til\u0017\u0005\b\u0003\u000f\f\u0002\u0019AAe\u0003\u001d\u0011XmY8sIN\u0004B!! \u0002L&!\u0011QZA@\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011qN\tA\u0002\u0005E\u0004bBA=#\u0001\u0007\u00111\u0010\u0005\b\u0003\u0013\u000b\u0002\u0019AA>\u0003\u0001\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007I\t\t&\u0001\u0011uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIZ\u0013\u0004fA\n\u0002R\u0005y2\r[3dW2{w-\u00119qK:$G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3\u0015\t\u0005%\u0013\u0011\u001d\u0005\b\u0003_\"\u0002\u0019AA9\u0003\u0011\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]Z\u000b\u0004fA\u000b\u0002R\u0005\u00193\r[3dW2{w-\u00119qK:$G+[7f/&$\bNU3d_6\u0004(/Z:tS>tG\u0003BA%\u0003WDq!!<\u0017\u0001\u0004\t\t(A\u0006uCJ<W\r^'bO&\u001c\u0017\u0001\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f\u001b*fG>l\u0007O]3tg&|gN\u0016\u001a)\u0007]\t\t&A\u0014uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]Z\u000b\u0004f\u0001\r\u0002R\u000513\r[3dW2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8\u0015\t\u0005%\u00131 \u0005\b\u0003_J\u0002\u0019AA9\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e*b]\u001e,\u0017I\u001c3SK\u000e|'\u000fZ\"pk:$\bf\u0001\u000e\u0002R\u0005\u0001\u0013m]:feRLeN^1mS\u0012\u0014\u0015\r^2i\u0007>,h\u000e^(wKJ\u0014\u0018\u000eZ3t)\u0019\tIE!\u0002\u0003\u0010!9!qA\u000eA\u0002\t%\u0011a\u00047bgR|eMZ:fi\u0012+G\u000e^1\u0011\u0007\t\u0014Y!C\u0002\u0003\u000e\r\u00141!\u00138u\u0011\u001d\u0011\tb\u0007a\u0001\u0005\u0013\tQaY8v]R\fQE^1mS\u0012\fG/\u001a*fG>\u0014HMQ1uG\"<\u0016\u000e\u001e5D_VtGo\u0014<feJLG-Z:\u0015\r\u0005%#q\u0003B\r\u0011\u001d\u00119\u0001\ba\u0001\u0005\u0013AqA!\u0005\u001d\u0001\u0004\u0011I!A\u0014uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]Z\u0013\u0004fA\u000f\u0002R\u0005\u0019B/Z:u\u001d>t7i\\7qe\u0016\u001c8/\u001a3Wc!\u001aa$!\u0015\u0002%\rDWmY6O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u0005\u0003\u0013\u00129\u0003C\u0004\u0002p}\u0001\r!!\u001d\u0002'Q,7\u000f\u001e(p]\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u0007\u0001\n\t&A\nuKN$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007K\u0002\"\u0003#\n!c\u00195fG.\u0014VmY8naJ,7o]5p]R!\u0011\u0011\nB\u001b\u0011\u001d\tyG\ta\u0001\u0003c\n1\u0003^3tiJ+7m\\7qe\u0016\u001c8/[8o-JB3aIA)\u0003\u0001\"Xm\u001d;De\u0016\fG/\u001a+j[\u0016,\u0006oQ8om\u0016\u00148/[8o-B\"vNV\u0019)\u0007\u0011\n\t&A\u0011dQ\u0016\u001c7n\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c$s_64\u0006\u0007\u0006\u0003\u0002J\t\r\u0003b\u0002B#K\u0001\u0007\u0011\u0011O\u0001\bi>l\u0015mZ5d\u0003\u0001\"Xm\u001d;De\u0016\fG/\u001a+j[\u0016,\u0006oQ8om\u0016\u00148/[8o-B\"vN\u0016\u001a)\u0007\u0019\n\t&\u0001\u0011uKN$8I]3bi\u0016$\u0016.\\3Va\u000e{gN^3sg&|gNV\u0019U_Z\u0013\u0004fA\u0014\u0002R\u0005\u0001B/Z:u\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004Q\u0005E\u0013aD2iK\u000e\\7i\\7qe\u0016\u001c8/\u001a3\u0015\t\u0005%#q\u000b\u0005\b\u0003_J\u0003\u0019AA9\u0003A!Xm\u001d;D_6\u0004(/Z:tK\u00124&\u0007K\u0002+\u0003#\nA\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWMT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\bW\u0005E#\u0011\rB2\u0003!)\u0007\u0010]3di\u0016$7E\u0001B3!\u0011\u00119Ga\u001b\u000e\u0005\t%$B\u0001:^\u0013\u0011\u0011iG!\u001b\u00033I+7m\u001c:e-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\\\u0001%i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!:A&!\u0015\u0003b\t\r\u0014!\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fIZ\u000b\u0004fB\u0017\u0002R\t\u0005$1M\u0001\"i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,G+[7f\u0007>l\u0007O]3tg\u0016$gK\r\u0015\b]\u0005E#\u0011\rB2\u0003%\"Xm\u001d;BEN|G.\u001e;f\u001f\u001a47/\u001a;BgNLwM\\7f]RtuN\\\"p[B\u0014Xm]:fI\"\u001aq&!\u0015\u0002MQ,7\u000f^!cg>dW\u000f^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,G\rK\u00021\u0003#\n1\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGOT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004c\u0005E\u0013a\u000b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e\u001e(p]\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u0007I\n\t&\u0001\u0015uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;D_6\u0004(/Z:tK\u00124\u0016\u0007K\u00024\u0003#\n\u0001\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGoQ8naJ,7o]3e-JB3\u0001NA)\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u000bdj\u001c8D_6\u0004(/Z:tK\u0012D3!NA)\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u0013dj\u001c8D_6\u0004(/Z:tK\u0012D3ANA)\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u000b4i\\7qe\u0016\u001c8/\u001a3)\u0007]\n\t&A\u001buKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,3\u0007>l\u0007O]3tg\u0016$\u0007f\u0001\u001d\u0002R\u00059C/Z:u\u0007>tGO]8m%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$gI]8n\u00072LWM\u001c;tQ\u001dI\u0014\u0011\u000bB1\u0005O\u001b#A!+\u0011\u0007y\u0014Y+C\u0002\u0003.F\u0014a#\u00138wC2LGMU3d_J$W\t_2faRLwN\\\u0001 i\u0016\u001cHoQ8oiJ|GNU3d_J$7OT8u\u0007>l\u0007O]3tg\u0016$\u0007f\u0001\u001e\u0002R\u0005QD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-F\"vN\u0016\u0019O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004w\u0005E\u0013a\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4\u0016\u0007V8Wa\r{W\u000e\u001d:fgN,G\rK\u0002=\u0003#\n\u0001\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WcQ{gK\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u0002>\u0003#\nQ\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WcQ{gKM\"p[B\u0014Xm]:fI\"\u001aa(!\u0015\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0016GT8o\u0007>l\u0007O]3tg\u0016$\u0007fA \u0002R\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vNV\u0019D_6\u0004(/Z:tK\u0012D3\u0001QA)\u0003Q\"Xm\u001d;E_^t7i\u001c8wKJ\u001c\u0018n\u001c8PMR\u0013\u0018M\\:bGRLwN\\1m%\u0016\u001cwN\u001d3t\u001d>$\b+\u001a:nSR$X\r\u001a\u0015\b\u0003\u0006E#\u0011\rBhG\t\u0011\t\u000e\u0005\u0003\u0003T\neWB\u0001Bk\u0015\r\u00119.]\u0001\u0007KJ\u0014xN]:\n\t\tm'Q\u001b\u0002%+:\u001cX\u000f\u001d9peR,GMR8s\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;Fq\u000e,\u0007\u000f^5p]\u0006\tD/Z:u\t><hnQ8om\u0016\u00148/[8o\u001f\u001aLE-Z7q_R,g\u000e\u001e*fG>\u0014Hm\u001d(piB+'/\\5ui\u0016$\u0007f\u0002\"\u0002R\t\u0005$qZ\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u0003dj\u001c8D_6\u0004(/Z:tK\u0012D3aQA)\u0003]\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WeQ{g\u000bM\"p[B\u0014Xm]:fI\"\u001aA)!\u0015\u0002eQ,7\u000f\u001e(p]&s7M]3bg&twm\u00144gg\u0016$(+Z2pe\u0012\u0014\u0015\r^2i\u0011\u0006\u001cX*\u001a;sS\u000e\u001cHj\\4hK\u0012D3!RA)\u0003-\"Xm\u001d;D_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007f\u0002$\u0002R\t\u0005$qU\u0001,i\u0016\u001cHOW*uI\u000e{W\u000e\u001d:fgN,GmV5uQVs\u0017M^1jY\u0006\u0014G.Z%C!Z+'o]5p]\":q)!\u0015\u0003b\tU8E\u0001B|!\u0011\u0011\u0019N!?\n\t\tm(Q\u001b\u0002$+:\u001cX\u000f\u001d9peR,GmQ8naJ,7o]5p]RK\b/Z#yG\u0016\u0004H/[8o\u00035\"Xm\u001d;V]\u000e|W\u000e\u001d:fgN,GMQ1uG\"<\u0016\u000e\u001e5pkR\u0014VmY8sINtu\u000e^!mY><X\r\u001a\u0015\b\u0011\u0006E#\u0011\rBT\u00035\"Xm\u001d;SK\u000e|W\u000e\u001d:fgN,GMQ1uG\"<\u0016\u000e\u001e5pkR\u0014VmY8sINtu\u000e^!mY><X\r\u001a\u0015\b\u0013\u0006E#\u0011\rBT\u0003)\"Xm\u001d;J]Z\fG.\u001b3US6,7\u000f^1na\u0016C8-\u001a9uS>t\u0007*Y:CCR\u001c\u0007.\u00138eKbD3ASA)\u0003\u001d\"Xm\u001d;J]Z\fG.\u001b3SK\u000e|'\u000fZ#yG\u0016\u0004H/[8o\u0011\u0006\u001c()\u0019;dQ&sG-\u001a=)\u0007-\u000b\t&\u0001\u0018uKN$()\u0019;dQ^KG\u000f[%om\u0006d\u0017\u000e\u001a*fG>\u0014Hm]!oI&sg/\u00197jIRKW.Z:uC6\u0004\bf\u0001'\u0002R\u0005\tC/Z:u\u0005\u0006$8\r[,ji\"|W\u000f\u001e*fG>\u0014Hm\u001d(pi\u0006cGn\\<fIR1\u0011\u0011JB\u000b\u0007KAqaa\u0006N\u0001\u0004\u0019I\"A\u0006t_V\u00148-Z\"pI\u0016\u001c\u0007\u0003BB\u000e\u0007Ci!a!\b\u000b\u0007\r}Q,A\u0004nKN\u001c\u0018mZ3\n\t\r\r2Q\u0004\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000eDqaa\nN\u0001\u0004\u0019I\"A\u0006uCJ<W\r^\"pI\u0016\u001c\u0017!D2sK\u0006$XMU3d_J$7\u000f\u0006\u0005\u0002J\u000e52\u0011GB\u001e\u0011\u001d\u0019yC\u0014a\u0001\u0003c\n!\"\\1hS\u000e4\u0016\r\\;f\u0011%\u0019\u0019D\u0014I\u0001\u0002\u0004\u0019)$A\u0005uS6,7\u000f^1naB\u0019!ma\u000e\n\u0007\re2M\u0001\u0003M_:<\u0007bBB\u001f\u001d\u0002\u0007\u00111P\u0001\u0006G>$WmY\u0001\u0018GJ,\u0017\r^3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII*\"aa\u0011+\t\rU2QI\u0016\u0003\u0007\u000f\u0002Ba!\u0013\u0004T5\u001111\n\u0006\u0005\u0007\u001b\u001ay%A\u0005v]\u000eDWmY6fI*\u00191\u0011K2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004V\r-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00013M]3bi\u0016tuN\\%oGJ,\u0017m]5oO>3gm]3u%\u0016\u001cwN\u001d3t)!\tIma\u0017\u0004^\r}\u0003bBB\u0018!\u0002\u0007\u0011\u0011\u000f\u0005\n\u0007g\u0001\u0006\u0013!a\u0001\u0007kA\u0011b!\u0010Q!\u0003\u0005\r!a\u001f\u0002U\r\u0014X-\u0019;f\u001d>t\u0017J\\2sK\u0006\u001c\u0018N\\4PM\u001a\u001cX\r\u001e*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Q3M]3bi\u0016tuN\\%oGJ,\u0017m]5oO>3gm]3u%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001aTCAB4U\u0011\tYh!\u0012\u0002/\r\u0014X-\u0019;f)^|')\u0019;dQ\u0016$'+Z2pe\u0012\u001cH\u0003CAe\u0007[\u001ayg!\u001d\t\u000f\r=2\u000b1\u0001\u0002r!911G*A\u0002\rU\u0002bBB\u001f'\u0002\u0007\u00111P\u0001\rG\",7m[(gMN,Go\u001d\u000b\u0007\u0003\u0013\u001a9h!\u001f\t\u000f\u0005\u001dG\u000b1\u0001\u0002J\"911\u0010+A\u0002\rU\u0012A\u00032bg\u0016|eMZ:fi\u0006!#/Z2pe\u0012\u001cx+\u001b;i\u001d>t7+Z9vK:$\u0018.\u00197J]:,'o\u00144gg\u0016$8\u000f\u0006\u0005\u0002J\u000e\u000551QBC\u0011\u001d\u0019y#\u0016a\u0001\u0003cBqa!\u0010V\u0001\u0004\tY\bC\u0004\u0004\bV\u0003\rA!\u0003\u0002\u00159,XNU3d_J$7/\u0001\u000fsK\u000e|'\u000fZ:XSRD\u0017J\u001c<bY&$\u0017J\u001c8fe6\u000bw-[2\u0015\u0011\u0005%7QRBI\u0007+Cqaa$W\u0001\u0004\t\t(A\bcCR\u001c\u0007.T1hS\u000e4\u0016\r\\;f\u0011\u001d\u0019\u0019J\u0016a\u0001\u0003c\n\u0001C]3d_J$W*Y4jGZ\u000bG.^3\t\u000f\rub\u000b1\u0001\u0002|\u00059R.Y=cK\u000eCWmY6CCN,G+[7fgR\fW\u000e\u001d\u000b\u0007\u0003\u0013\u001aYj!(\t\u000f\t\u0005t\u000b1\u0001\u00046!91qT,A\u0002\r\u0005\u0016!\u00022bi\u000eD\u0007\u0003BA?\u0007GKAa!*\u0002\u0000\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0003U1\u0018\r\\5eCR,Gj\\4BaB,g\u000e\u001a+j[\u0016$\u0002\"!\u0013\u0004,\u000e=61\u0017\u0005\b\u0007[C\u0006\u0019AB\u001b\u0003U)\u0007\u0010]3di\u0016$Gj\\4BaB,g\u000e\u001a+j[\u0016Dqa!-Y\u0001\u0004\u0019)$A\u000bfqB,7\r^3e\u0005\u0006\u001cX\rV5nKN$\u0018-\u001c9\t\u000f\r}\u0005\f1\u0001\u0004\"\u0006Yb/\u001a:jMf\u0014VmY8sI\u000e{gN^3sg&|gn\u0015;biN$\"\"!\u0013\u0004:\u000e\r7qYBe\u0011\u001d\u0019Y,\u0017a\u0001\u0007{\u000bQa\u001d;biN\u0004B!! \u0004@&!1\u0011YA@\u0005U\u0011VmY8sI\u000e{gN^3sg&|gn\u0015;biNDqa!2Z\u0001\u0004\u0011I!A\nok6\u001cuN\u001c<feR,GMU3d_J$7\u000fC\u0004\u0002Hf\u0003\r!!3\t\u000f\r-\u0017\f1\u0001\u0004N\u0006Q1m\\7qe\u0016\u001c8/\u001a3\u0011\u0007\t\u001cy-C\u0002\u0004R\u000e\u0014qAQ8pY\u0016\fg\u000e")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Set<MetricName> metricsKeySet = AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testValidationOfBatchesWithNonSequentialInnerOffsets() {
        for (RecordVersion recordVersion : RecordVersion.values()) {
            this.testMessageValidation$1(recordVersion.value);
        }
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compressionType), batchMagic, compressionType, compressionType), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$2))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private LogValidator.ValidationAndOffsetAssignResult validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), 0L, CompressionCodec$.MODULE$.getCompressionCodec(sourceCompressionType.name), CompressionCodec$.MODULE$.getCompressionCodec(targetCompressionType.name), false, magic, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_3_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    @Test
    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().size(), (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size());
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        int expectedMaxTimestampOffset = magic >= 2 ? 2 : 0;
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(expectedMaxTimestampOffset).toString(), (long)expectedMaxTimestampOffset, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().size(), (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size());
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, -1L, (RecordBatch)batch));
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().size() - 1).toString(), (long)(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().size(), (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size());
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().size() - 1).toString(), (long)(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    private void checkNonCompressed(byte magic) {
        IntRef intRef;
        long now = System.currentTimeMillis();
        scala.collection.immutable.Seq timestampSeq = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)1324L, (Object)((short)10), (Object)984, (Object)true, (Object)40) : new Tuple5((Object)-1L, (Object)-1, (Object)-1, (Object)false, (Object)-1);
        long l = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short s = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int n = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int n2 = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)l, (short)s, (int)n, (int)n2, (boolean)bl, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, n2, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef i = intRef2;
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$checkNonCompressed$1(this, timestampSeq, s, l, n, bl, n2, i, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 1", (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    private void checkRecompression(byte magic) {
        IntRef intRef;
        long now = System.currentTimeMillis();
        scala.collection.immutable.Seq timestampSeq = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)1324L, (Object)((short)10), (Object)984, (Object)true, (Object)40) : new Tuple5((Object)-1L, (Object)-1, (Object)-1, (Object)false, (Object)-1);
        long l = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short s = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int n = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int n2 = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)l, (short)s, (int)n, (int)n2, (boolean)bl, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, n2, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef i = intRef2;
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$checkRecompression$1(this, timestampSeq, s, l, n, n2, i, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, false, toMagic, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(-1L).toString(), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size() - 1).toString(), (long)(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, timestamp, CompressionType.GZIP);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, timestamp, (CompressionCodec)x$9, (CompressionCodec)x$10, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size() - 1).toString(), (long)(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    private void checkCompressed(byte magic) {
        IntRef intRef;
        long now = System.currentTimeMillis();
        scala.collection.immutable.Seq timestampSeq = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)1324L, (Object)((short)10), (Object)984, (Object)true, (Object)40) : new Tuple5((Object)-1L, (Object)-1, (Object)-1, (Object)false, (Object)-1);
        long l = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short s = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int n = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int n2 = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)l, (short)s, (int)n, (int)n2, (boolean)bl, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, false, magic, TimestampType.CREATE_TIME, 1000L, n2, (AppendOrigin)x$13, x$14, x$15);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef i = intRef2;
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCompressed$1(this, timestampSeq, s, l, n, n2, i, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size() - 1).toString(), (long)(AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)validatedRecords.records()).asScala().size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$13, x$14, x$15);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$13, x$14, x$15);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef((long)offset);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        NoCompressionCodec$ x$9 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$10 = NoCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$16, x$17, x$18).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        List batches = TestUtils.toList((Iterable)LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)1, l, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)1, l, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        void withTransactionalRecords_records;
        MemoryRecords memoryRecords;
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        Object var7_6 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        void withIdempotentRecords_records;
        MemoryRecords memoryRecords;
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())};
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        Object var7_6 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, -1L, CompressionType.NONE);
        ((MutableRecordBatch)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.batches()).asScala().head()).setLastOffset(2L);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1225));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$9))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=UnsupportedCompressionTypeException.class)
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_0_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
            ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$15 = this.brokerTopicStats();
            return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$13, x$14, x$15);
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1288));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Seq seq = e.recordErrors();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)seq.length(), (long)3L);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1314));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Seq seq = e.recordErrors();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)seq.length(), (long)20L);
        e.recordErrors().foreach((Function1 & Serializable)x$10 -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$2(x$10);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        IntRef intRef;
        IndexedSeq indexedSeq;
        LegacyRecord legacyRecord;
        int n = 0;
        int until$extension_end = 5;
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            LegacyRecord legacyRecord2;
            LegacyRecord legacyRecord3 = legacyRecord2 = LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            legacyRecord2 = null;
            legacyRecord = legacyRecord3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            legacyRecord = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var7_3 = null;
        Object var8_4 = null;
        Object var9_5 = null;
        legacyRecord = null;
        indexedSeq = null;
        IndexedSeq records = indexedSeq2;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef offset = intRef2;
        byte[] create_value = "timestamp".getBytes();
        Object var15_14 = null;
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME));
        records.foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1347));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Seq seq = e.recordErrors();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)6L, (long)seq.length());
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        long l = 1324L;
        short s = (short)10;
        int n = 984;
        boolean bl = true;
        int n2 = 40;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)l, (short)s, (int)n, (long)0L, (long)5L, (int)n2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)bl, (boolean)false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        LongRef longRef;
        Assert.assertTrue((String)"Message set should not be empty", (boolean)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().nonEmpty());
        LongRef longRef2 = longRef = new LongRef(baseOffset);
        longRef = null;
        LongRef offset = longRef2;
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)records.records()).asScala().foreach((Function1 & Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords recordsWithNonSequentialInnerOffsets(byte magicValue, CompressionType codec, int numRecords) {
        IndexedSeq indexedSeq;
        SimpleRecord simpleRecord;
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numRecords, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            SimpleRecord simpleRecord2;
            SimpleRecord simpleRecord3 = simpleRecord2 = LogValidatorTest.$anonfun$recordsWithNonSequentialInnerOffsets$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            simpleRecord2 = null;
            simpleRecord = simpleRecord3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            simpleRecord = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var7_5 = null;
        Object var8_6 = null;
        Object var9_7 = null;
        simpleRecord = null;
        indexedSeq = null;
        IndexedSeq records = indexedSeq2;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records.foreach((Function1 & Serializable)record -> {
            builder.appendUncheckedWithOffset(0L, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        IntRef intRef;
        IndexedSeq indexedSeq;
        LegacyRecord legacyRecord;
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            LegacyRecord legacyRecord2;
            LegacyRecord legacyRecord3 = legacyRecord2 = LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)object));
            legacyRecord2 = null;
            legacyRecord = legacyRecord3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            legacyRecord = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var8_6 = null;
        Object var9_7 = null;
        Object var10_8 = null;
        legacyRecord = null;
        indexedSeq = null;
        IndexedSeq records = indexedSeq2;
        int n2 = Math.max(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)records.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024);
        int min_y = 65536;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(Math.min(n2, min_y)), (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        int create_e = 1234567;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef offset = intRef2;
        records.foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assert.assertEquals((String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString(), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString(), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString(), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString(), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString(), (tempBytes > (long)originalSize ? 1 : 0) != 0);
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((long)0L, (long)tempBytes);
    }

    private final void testMessageValidation$1(byte magicValue) {
        int numRecords = 20;
        MemoryRecords invalidRecords = this.recordsWithNonSequentialInnerOffsets(magicValue, CompressionType.GZIP, numRecords);
        if (magicValue >= 2) {
            Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            return;
        }
        LogValidator.ValidationAndOffsetAssignResult result = this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP);
        int n = 0;
        Assert.assertEquals((Object)new Range.Exclusive(n, numRecords, 1), (Object)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)result.validatedRecords().records()).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset())));
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$2) {
        return x$2.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(scala.collection.immutable.Seq timestampSeq$1, IntRef i$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$1, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$1, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$1, (long)batch.baseSequence());
        Assert.assertEquals((Object)isTransactional$1, (Object)batch.isTransactional());
        Assert.assertEquals((long)partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(scala.collection.immutable.Seq timestampSeq$2, IntRef i$2, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$2, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$2, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$2, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assert.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(scala.collection.immutable.Seq timestampSeq$3, IntRef i$3, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$3, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$3, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$3, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
        AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$9) {
        return x$9.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$2(ProduceResponse.RecordError x$10) {
        Assert.assertNotNull((Object)x$10);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(int id) {
        byte[] create_value = ((Object)id).toString().getBytes();
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(IntRef offset$1, MemoryRecordsBuilder builder$1, LegacyRecord record) {
        offset$1.elem += 30;
        builder$1.appendUncheckedWithOffset((long)offset$1.elem, record);
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$2, Record entry) {
        Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)offset$2.elem, (long)entry.offset());
        ++offset$2.elem;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$recordsWithNonSequentialInnerOffsets$1(int id) {
        return new SimpleRecord(((Object)id).toString().getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        void create_value;
        void create_key;
        byte[] byArray = ((Object)id).toString().getBytes();
        byte[] byArray2 = ((Object)id).toString().getBytes();
        long create_timestamp = -1L;
        return LegacyRecord.create((byte)recordMagicValue$1, (long)create_timestamp, (byte[])create_key, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$3, IntRef offset$3, LegacyRecord record) {
        builder$3.appendUncheckedWithOffset((long)offset$3.elem, record);
        ++offset$3.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString(), (long)expectedLogAppendTime$1, (long)record.timestamp());
    }

    public static final /* synthetic */ Object $anonfun$testValidationOfBatchesWithNonSequentialInnerOffsets$3$adapted(LogValidatorTest $this, RecordVersion version) {
        $this.testMessageValidation$1(version.value);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1$adapted(Object id) {
        return LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)id));
    }

    public static final /* synthetic */ SimpleRecord $anonfun$recordsWithNonSequentialInnerOffsets$1$adapted(Object id) {
        return LogValidatorTest.$anonfun$recordsWithNonSequentialInnerOffsets$1(BoxesRunTime.unboxToInt((Object)id));
    }

    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1$adapted(byte recordMagicValue$1, Object id) {
        return LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue$1, BoxesRunTime.unboxToInt((Object)id));
    }
}

