/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.collection.IterableFactory;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002B\u0002\u0016\u0001A\u0003%Q\u0004C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\t\rE\u0002\u0001\u0015!\u0003.\u0011\u0015\u0011\u0004\u0001\"\u00114\u0011\u0015\u0001\u0005\u0001\"\u00014\u0011\u0015)\u0005\u0001\"\u00014\u0011\u00151\u0005\u0001\"\u00014\u0005M\tEM^3si&\u001cXM\u0011:pW\u0016\u0014H+Z:u\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\t!R\"\u0001\u0002{W&\u0011ac\u0005\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005Y\u0011aB:feZ,'o]\u000b\u0002;A\u0019a$J\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u000f5,H/\u00192mK*\u0011!eI\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019z\"aC!se\u0006L()\u001e4gKJ\u0004\"A\u0007\u0015\n\u0005%Z!aC&bM.\f7+\u001a:wKJ\f\u0001b]3sm\u0016\u00148\u000fI\u0001\tEJ|7.\u001a:JIV\tQ\u0006\u0005\u0002/_5\t1%\u0003\u00021G\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003Q\u0002\"AL\u001b\n\u0005Y\u001a#\u0001B+oSRD#A\u0002\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014!\u00026v]&$(\"A\u001f\u0002\u0007=\u0014x-\u0003\u0002@u\t)\u0011I\u001a;fe\u00061C/Z:u\u0005J|7.\u001a:BIZ,'\u000f^5tK\"{7\u000f\u001e(b[\u0016\fe\u000e\u001a)peR$vNW&)\u0005\u001d\u0011\u0005CA\u001dD\u0013\t!%H\u0001\u0003UKN$\u0018\u0001\t;fgR\u0014%o\\6fe\u0006#g/\u001a:uSN,G*[:uK:,'o\u001d+p5.\u000bq\u0006^3ti\n\u0013xn[3s\u0003\u00124XM\u001d;jg\u0016d\u0015n\u001d;f]\u0016\u00148oV5uQ\u000e+8\u000f^8n\u001d\u0006lWm\u001d+p5.\u0003")
public class AdvertiseBrokerTest
extends ZooKeeperTestHarness {
    private final ArrayBuffer<KafkaServer> servers = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (scala.collection.immutable.Seq)Nil$.MODULE$);
    private final int brokerId;

    public ArrayBuffer<KafkaServer> servers() {
        return this.servers;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerAdvertiseHostNameAndPortToZK() {
        void $plus$eq_elem;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer;
        String advertisedHostName = "routable-host1";
        int advertisedPort = 1234;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put("advertised.host.name", advertisedHostName);
        props.put("advertised.port", ((Object)advertisedPort).toString());
        ArrayBuffer<KafkaServer> arrayBuffer = this.servers();
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        KafkaServer kafkaServer2 = kafkaServer = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
        Object var7_6 = null;
        kafkaConfig = null;
        time = null;
        kafkaServer = null;
        KafkaServer kafkaServer3 = kafkaServer2;
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)$plus$eq_elem);
        kafkaServer3 = null;
        Broker brokerInfo = (Broker)this.zkClient().getBroker(this.brokerId()).get();
        Seq seq = brokerInfo.endPoints();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)advertisedHostName, (Object)endpoint.host());
        Assert.assertEquals((long)advertisedPort, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName().value());
    }

    /*
     * WARNING - void declaration
     */
    public void testBrokerAdvertiseListenersToZK() {
        void $plus$eq_elem;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put("advertised.listeners", "PLAINTEXT://routable-listener:3334");
        ArrayBuffer<KafkaServer> arrayBuffer = this.servers();
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        KafkaServer kafkaServer2 = kafkaServer = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
        Object var5_4 = null;
        kafkaConfig = null;
        time = null;
        kafkaServer = null;
        KafkaServer kafkaServer3 = kafkaServer2;
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)$plus$eq_elem);
        kafkaServer3 = null;
        Broker brokerInfo = (Broker)this.zkClient().getBroker(this.brokerId()).get();
        Seq seq = brokerInfo.endPoints();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)"routable-listener", (Object)endpoint.host());
        Assert.assertEquals((long)3334L, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName());
    }

    /*
     * WARNING - void declaration
     */
    public void testBrokerAdvertiseListenersWithCustomNamesToZK() {
        void $plus$eq_elem;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put("listeners", "INTERNAL://:0,EXTERNAL://:0");
        props.put("advertised.listeners", "EXTERNAL://external-listener:9999,INTERNAL://internal-listener:10999");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT,EXTERNAL:PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        ArrayBuffer<KafkaServer> arrayBuffer = this.servers();
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        KafkaServer kafkaServer2 = kafkaServer = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
        Object var6_4 = null;
        kafkaConfig = null;
        time = null;
        kafkaServer = null;
        KafkaServer kafkaServer3 = kafkaServer2;
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)$plus$eq_elem);
        kafkaServer3 = null;
        Broker brokerInfo = (Broker)this.zkClient().getBroker(this.brokerId()).get();
        Seq seq = brokerInfo.endPoints();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)"external-listener", (Object)endpoint.host());
        Assert.assertEquals((long)9999L, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)"EXTERNAL", (Object)endpoint.listenerName().value());
        EndPoint endpoint2 = (EndPoint)brokerInfo.endPoints().apply(1);
        Assert.assertEquals((Object)"internal-listener", (Object)endpoint2.host());
        Assert.assertEquals((long)10999L, (long)endpoint2.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)"INTERNAL", (Object)endpoint2.listenerName());
    }

    public AdvertiseBrokerTest() {
        this.brokerId = 0;
    }
}

