/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import scala.$less$colon$less$;
import scala.Function1;
import scala.collection.SeqOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u0014)\u00015BQA\r\u0001\u0005\u0002MBQ!\u000e\u0001\u0005BYBqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004T\u0001\u0001\u0006I!\u0013\u0005\u0006)\u0002!\t\u0001\u0013\u0005\b5\u0002\u0011\r\u0011\"\u0003\\\u0011\u0019\u0011\u0007\u0001)A\u00059\"91\r\u0001b\u0001\n\u0013Y\u0006B\u00023\u0001A\u0003%A\fC\u0004f\u0001\t\u0007I\u0011\u00024\t\r5\u0004\u0001\u0015!\u0003h\u0011\u001dq\u0007A1A\u0005\n\u0019Daa\u001c\u0001!\u0002\u00139\u0007b\u00029\u0001\u0005\u0004%IA\u001a\u0005\u0007c\u0002\u0001\u000b\u0011B4\t\u000bI\u0004A\u0011A:\t\u000ba\u0004A\u0011A:\t\u000bi\u0004A\u0011A:\t\u000bq\u0004A\u0011A:\t\u000by\u0004A\u0011A:\t\r\u0005\u0005\u0001\u0001\"\u0001t\u0011\u0019\t)\u0001\u0001C\u0001g\"1\u0011\u0011\u0002\u0001\u0005\u0002MDa!!\u0004\u0001\t\u0003\u0019\bBBA\t\u0001\u0011\u00051\u000f\u0003\u0004\u0002\u0016\u0001!\ta\u001d\u0005\b\u00033\u0001A\u0011BA\u000e\u0011%\ti\u0005AI\u0001\n\u0013\ty\u0005C\u0004\u0002f\u0001!I!a\u001a\t\u0013\u0005e\u0004!%A\u0005\n\u0005=\u0003bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!a:\u0001\t\u0013\tI\u000fC\u0004\u0002l\u0002!I!!<\t\u000f\u0005M\b\u0001\"\u0003\u0002v\"9!1\u0002\u0001\u0005\n\t5\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0002%\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fV3ti*\u0011\u0011FK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001]A\u0011q\u0006M\u0007\u0002Q%\u0011\u0011\u0007\u000b\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003_\u0001\tqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005]j\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$\u0001B+oSRDQA\u0010\u0002A\u0002}\n!\u0002\u001d:pa\u0016\u0014H/[3t!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003vi&d'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%yF/Z:u\u001d\u0006lW-F\u0001J!\tQ\u0015+D\u0001L\u0015\taU*A\u0003sk2,7O\u0003\u0002O\u001f\u0006)!.\u001e8ji*\t\u0001+A\u0002pe\u001eL!AU&\u0003\u0011Q+7\u000f\u001e(b[\u0016\f!b\u0018;fgRt\u0015-\\3!\u0003!!Xm\u001d;OC6,\u0007FA\u0003W!\t9\u0006,D\u0001N\u0013\tIVJ\u0001\u0003Sk2,\u0017aE:bYR,G\rU1tg^|'\u000f\u001a\"zi\u0016\u001cX#\u0001/\u0011\u0007ajv,\u0003\u0002_s\t)\u0011I\u001d:bsB\u0011\u0001\bY\u0005\u0003Cf\u0012AAQ=uK\u0006!2/\u00197uK\u0012\u0004\u0016m]:x_J$')\u001f;fg\u0002\n\u0011b]1mi\nKH/Z:\u0002\u0015M\fG\u000e\u001e\"zi\u0016\u001c\b%A\u0003vg\u0016\u0014\u0018'F\u0001h!\tA7.D\u0001j\u0015\tQ7)\u0001\u0003mC:<\u0017B\u00017j\u0005\u0019\u0019FO]5oO\u00061Qo]3sc\u0001\nQ!^:feJ\na!^:feJ\u0002\u0013aC;oW:|wO\\+tKJ\fA\"\u001e8l]><h.V:fe\u0002\n\u0001\u0003^3ti\u0006cG/\u001a:O_RD\u0017N\\4\u0015\u0003]B#\u0001E;\u0011\u0005]3\u0018BA<N\u0005\u0011!Vm\u001d;\u0002;Q,7\u000f^!mi\u0016\u0014hj\u001c;iS:<gj\u001c;BkRDwN]5{K\u0012D#!E;\u0002?Q,7\u000f^!mi\u0016\u00148k\\7fi\"Lgn\u001a(pi\u0006+H\u000f[8sSj,G\r\u000b\u0002\u0013k\u00069B/Z:u\u00032$XM]*b[\u0016$\u0006.\u001b8h)^L7-\u001a\u0015\u0003'U\f!\u0003^3ti\u0006cG/\u001a:F[B$\u00180V:fe\"\u0012A#^\u0001\u001ai\u0016\u001cH/\u00117uKJ,fn\u001b8po:lUm\u00195b]&\u001cX\u000e\u000b\u0002\u0016k\u0006IB/Z:u\u00032$XM\u001d+p_\u001a+w/\u0013;fe\u0006$\u0018n\u001c8tQ\t1R/\u0001\u000euKN$\u0018\t\u001c;feR{w.T1os&#XM]1uS>t7\u000f\u000b\u0002\u0018k\u0006\u0019C/Z:u\t\u0016dW\r^3T_6,G\u000f[5oORC\u0017\r\u001e#pKNtu\u000e^#ySN$\bF\u0001\rv\u0003Y!Xm\u001d;BYR,'OT8u\u0007>tGO]8mY\u0016\u0014\bFA\rv\u0003Q!Xm\u001d;BYR,'/\u00118e\t\u0016\u001c8M]5cK\"\u0012!$^\u0001%g\u0016tG-\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR1\u0011QDA\u001a\u0003{\u0001B!a\b\u000205\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t9#!\u000b\u0002\r\r|W.\\8o\u0015\rY\u00131\u0006\u0006\u0004\u0003[y\u0015AB1qC\u000eDW-\u0003\u0003\u00022\u0005\u0005\"!I!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm\u001d9p]N,\u0007bBA\u001b7\u0001\u0007\u0011qG\u0001\be\u0016\fX/Z:u!\u0011\ty\"!\u000f\n\t\u0005m\u0012\u0011\u0005\u0002!\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fC\u0005\u0002@m\u0001\n\u00111\u0001\u0002B\u0005a1o\\2lKR\u001cVM\u001d<feB!\u00111IA%\u001b\t\t)EC\u0002\u0002H)\nqA\\3uo>\u00148.\u0003\u0003\u0002L\u0005\u0015#\u0001D*pG.,GoU3sm\u0016\u0014\u0018AL:f]\u0012\fE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\"!!\u0015+\t\u0005\u0005\u00131K\u0016\u0003\u0003+\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&A\u0005v]\u000eDWmY6fI*\u0019\u0011qL\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002d\u0005e#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u000693/\u001a8e\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u)\u0019\tI'a\u001c\u0002xA!\u0011qDA6\u0013\u0011\ti'!\t\u0003I\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7\u000f]8og\u0016Dq!!\u000e\u001e\u0001\u0004\t\t\b\u0005\u0003\u0002 \u0005M\u0014\u0002BA;\u0003C\u00111\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fC\u0005\u0002@u\u0001\n\u00111\u0001\u0002B\u0005\t4/\u001a8e\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012\u0014!I2iK\u000e\\\u0017\t\u001c7FeJ|'o]!mi\u0016\u0014\u0018N\\4De\u0016$WM\u001c;jC2\u001cHcB\u001c\u0002\u0000\u0005U\u0016Q\u0019\u0005\b\u0003\u0003{\u0002\u0019AAB\u00039\u0011Xm];miN$vn\u00115fG.\u0004R\u0001QAC\u0003\u0013K1!a\"B\u0005\u0011a\u0015n\u001d;\u0011\t\u0005-\u0015q\u0016\b\u0005\u0003\u001b\u000bIK\u0004\u0003\u0002\u0010\u0006\u0015f\u0002BAI\u0003GsA!a%\u0002\":!\u0011QSAP\u001d\u0011\t9*!(\u000e\u0005\u0005e%bAANY\u00051AH]8pizJ\u0011\u0001U\u0005\u0004\u0003[y\u0015bA\u0016\u0002,%!\u0011qEA\u0015\u0013\u0011\t9+!\n\u0002\u000f5,7o]1hK&!\u00111VAW\u0003\u0015\nE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0002(\u0006\u0015\u0012\u0002BAY\u0003g\u0013q$\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7/\u001e7u\u0015\u0011\tY+!,\t\u000f\u0005]v\u00041\u0001\u0002:\u0006iQ\r\u001f9fGR,G-\u0012:s_J\u0004B!a/\u0002B6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b)#\u0001\u0005qe>$xnY8m\u0013\u0011\t\u0019-!0\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\t9m\ba\u0001\u0003\u0013\f!bY8oi\u0016DH/T:h!\u0011\tY-a5\u000f\t\u00055\u0017q\u001a\t\u0004\u0003/K\u0014bAAis\u00051\u0001K]3eK\u001aL1\u0001\\Ak\u0015\r\t\t.O\u0001!G\",7m\u001b(p\u000bJ\u0014xN]:BYR,'/\u001b8h\u0007J,G-\u001a8uS\u0006d7\u000fF\u00028\u00037Dq!!!!\u0001\u0004\t\u0019)\u0001\u0010dQ\u0016\u001c7.V:fe\u0006\u0003\b/Z1sg&s\u0017\t\u001c;feJ+7/\u001e7ugR)q'!9\u0002d\"9\u0011\u0011Q\u0011A\u0002\u0005\r\u0005bBAsC\u0001\u0007\u0011\u0011Z\u0001\u0005kN,'/A\u0014eKN\u001c'/\u001b2f\u00032dw+\u001b;i\u001d>$v\u000e\u001d'fm\u0016dWI\u001d:pe\u000e{gNZ5s[\u0016$GCAA5\u0003%\u001a\u0007.Z2l\u001d>$v\u000e\u001d'fm\u0016dWI\u001d:pe\u0012+7o\u0019:jE&twm\u0011:fI\u0016tG/[1mgR\u0019q'a<\t\u000f\u0005E8\u00051\u0001\u0002j\u0005y!/Z:q_:\u001cX\rV8DQ\u0016\u001c7.\u0001\u000edQ\u0016\u001c7.V:fe\"\u000b7\u000fV<p\u0007J,G-\u001a8uS\u0006d7\u000fF\u00038\u0003o\u0014I\u0001C\u0004\u0002\u0002\u0012\u0002\r!!?\u0011\u000b\u0001\u000b))a?\u0011\t\u0005u(1\u0001\b\u0005\u0003\u001b\u000by0\u0003\u0003\u0003\u0002\u00055\u0016\u0001\u000b#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3ECR\f\u0017\u0002\u0002B\u0003\u0005\u000f\u0011!\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3tk2$(\u0002\u0002B\u0001\u0003[Cq!!:%\u0001\u0004\tI-\u0001\u0017dQ\u0016\u001c7NR8s'&tw\r\\3TQ\u0006,\u0014GM%uKJ\fG/[8ogb\n\u0014HM\"sK\u0012,g\u000e^5bYR)qGa\u0004\u0003\u0012!9\u0011\u0011Q\u0013A\u0002\u0005e\bbBAsK\u0001\u0007\u0011\u0011Z\u0001\u0016G\",7m\u001b#fg\u000e\u0014\u0018NY3G_J,%O]8s)\u001d9$q\u0003B\r\u00057Aq!!!'\u0001\u0004\tI\u0010C\u0004\u0002f\u001a\u0002\r!!3\t\u000f\u0005]f\u00051\u0001\u0002:\u0002")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private final TestName _testName = new TestName();
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String unknownUser;

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AlterCredentialsTest.TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), this.testName().getMethodName().endsWith("NotAuthorized") ? AlterCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName() : AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @Test
    public void testAlterNothing() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testAlterNothingNotAuthorized() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testAlterSomethingNotAuthorized() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)2L, (long)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.CLUSTER_AUTHORIZATION_FAILED, "when not authorized");
    }

    @Test
    public void testAlterSameThingTwice() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        .colon.colon foreach_these = new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion1)).setUpsertions(Arrays.asList(upsertion2, upsertion2))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion2)).setUpsertions(Arrays.asList(upsertion1, upsertion2))).build()), (List)Nil$.MODULE$));
        while (!foreach_these.isEmpty()) {
            AlterUserScramCredentialsRequest alterUserScramCredentialsRequest = (AlterUserScramCredentialsRequest)foreach_these.head();
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, alterUserScramCredentialsRequest);
            foreach_these = (List)foreach_these.tail();
        }
    }

    @Test
    public void testAlterEmptyUser() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        .colon.colon foreach_these = new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty)).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty, deletionEmpty)).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)Nil$.MODULE$)));
        while (!foreach_these.isEmpty()) {
            AlterUserScramCredentialsRequest alterUserScramCredentialsRequest = (AlterUserScramCredentialsRequest)foreach_these.head();
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, alterUserScramCredentialsRequest);
            foreach_these = (List)foreach_these.tail();
        }
    }

    @Test
    public void testAlterUnknownMechanism() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user3 = "user3";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown3 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user3).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid3 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user3).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionUnknown1, deletionValid1, deletionUnknown2)).setUpsertions(Arrays.asList(upsertionUnknown3, upsertionValid3, upsertionUnknown4, upsertionUnknown5))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)5L, (long)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)results).asScala().foreach((Function1 & Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterTooFewIterations() {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)1L, (long)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assert.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @Test
    public void testAlterTooManyIterations() {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)1L, (long)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assert.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @Test
    public void testDeleteSomethingThatDoesNotExist() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)1L, (long)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    @Test
    public void testAlterNotController() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().results();
        Assert.assertEquals((long)2L, (long)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.NOT_CONTROLLER, "when routed incorrectly to a non-Controller broker");
    }

    @Test
    public void testAlterAndDescribe() {
        AlterUserScramCredentialsRequest request1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())))).build();
        java.util.List results1 = this.sendAlterUserScramCredentialsRequest(request1, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)2L, (long)results1.size());
        this.checkNoErrorsAlteringCredentials(results1);
        this.checkUserAppearsInAlterResults(results1, this.user1());
        this.checkUserAppearsInAlterResults(results1, this.user2());
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assert.assertEquals((long)2L, (long)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.controllerSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assert.assertEquals((long)1L, (long)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.controllerSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assert.assertEquals((long)2L, (long)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.controllerSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assert.assertEquals((long)2L, (long)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)2L, (long)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assert.assertEquals((long)1L, (long)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)1L, (long)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assert.assertEquals((long)0L, (long)results7.size());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.controllerSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.controllerSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        SeqOps seqOps = (SeqOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resultsToCheck).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)));
        if (seqOps == null) {
            throw null;
        }
        Assert.assertEquals((String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString(), (long)0L, (long)seqOps.length());
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        SeqOps seqOps = (SeqOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resultsToCheck).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$2)));
        if (seqOps == null) {
            throw null;
        }
        Assert.assertEquals((String)"Expected no error when altering credentials", (long)0L, (long)seqOps.length());
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assert.assertTrue((String)new StringBuilder(29).append("Expected result to contain '").append(user).append("'").toString(), (boolean)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resultsToCheck).asScala().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$3))));
    }

    /*
     * WARNING - void declaration
     */
    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        void var1_1;
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.controllerSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return var1_1;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assert.assertEquals((String)"Expected no top-level error when describing the credentials", (long)Errors.NONE.code(), (long)responseToCheck.data().errorCode());
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assert.assertTrue((String)new StringBuilder(50).append("Expected result to contain '").append(user).append("' with 2 credentials: ").append(resultsToCheck).toString(), (boolean)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))));
        Assert.assertTrue((String)new StringBuilder(90).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: ").append(resultsToCheck).toString(), (boolean)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))));
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assert.assertTrue((String)new StringBuilder(49).append("Expected result to contain '").append(user).append("' with 1 credential: ").append(resultsToCheck).toString(), (boolean)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))));
        Assert.assertTrue((String)new StringBuilder(66).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_512/8192 credential: ").append(resultsToCheck).toString(), (boolean)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))));
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assert.assertTrue((String)new StringBuilder(45).append("Expected result to contain '").append(user).append("' with a ").append(expectedError.name()).append(" error: ").append(resultsToCheck).toString(), (boolean)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))));
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)2L, (long)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.controllerSocketServer()).data().results();
        Assert.assertEquals((long)1L, (long)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assert.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assert.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        String string = x$3.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.unknownUser = "unknownUser";
    }

    public static final /* synthetic */ Object $anonfun$testAlterSameThingTwice$1$adapted(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1($this, request);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAlterEmptyUser$1$adapted(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1($this, request);
        return BoxedUnit.UNIT;
    }
}

