/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013E!\u0005\u0003\u00041\u0001\u0001\u0006Ia\t\u0005\bc\u0001\u0001\r\u0011\"\u00053\u0011\u001d1\u0004\u00011A\u0005\u0012]Ba!\u0010\u0001!B\u0013\u0019\u0004b\u0002 \u0001\u0005\u0004%\tb\u0010\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002!\t\u000b\u0019\u0003A\u0011A$\t\u000b=\u0003A\u0011\u0003)\t\u000bu\u0003A\u0011\u00030\t\u0013\u0005%\u0001!%A\u0005\u0012\u0005-\u0001bBA\u0013\u0001\u0011E\u0011q\u0005\u0005\b\u0003'\u0002A\u0011CA+\u0011\u001d\t\t\b\u0001C\t\u0003g\u0012!DQ1tK\u000ec\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d+fgRT!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0012\u0003\u0011!\u0018.\\3\u0016\u0003\r\u0002\"\u0001\n\u0018\u000e\u0003\u0015R!AJ\u0014\u0002\u000bU$\u0018\u000e\\:\u000b\u0005!J\u0013AB2p[6|gN\u0003\u0002\u0015U)\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0013\tySE\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u00031qW/\\\"bY2\u0014\u0017mY6t+\u0005\u0019\u0004C\u0001\r5\u0013\t)\u0014DA\u0002J]R\f\u0001C\\;n\u0007\u0006dGNY1dWN|F%Z9\u0015\u0005aZ\u0004C\u0001\r:\u0013\tQ\u0014D\u0001\u0003V]&$\bb\u0002\u001f\u0006\u0003\u0003\u0005\raM\u0001\u0004q\u0012\n\u0014!\u00048v[\u000e\u000bG\u000e\u001c2bG.\u001c\b%A\u0004nKR\u0014\u0018nY:\u0016\u0003\u0001\u0003\"!Q\"\u000e\u0003\tS!AP\u0014\n\u0005\u0011\u0013%aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005AA/Z1s\t><h\u000eF\u00019Q\tI\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002MY\u0005)!.\u001e8ji&\u0011aj\u0013\u0002\u0006\u0003\u001a$XM]\u0001\tG\u0006dGNY1dWR\u0011\u0001(\u0015\u0005\u0006%*\u0001\raU\u0001\te\u0016\u001c\bo\u001c8tKB\u0011AK\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/N\tqA\\3uo>\u00148.\u0003\u0002Z-\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017BA.]\u0005!\u0011Vm\u001d9p]N,'BA-W\u00031\u0011W/\u001b7e%\u0016\fX/Z:u+\tyV\rF\u0002aiv\u0004B\u0001G1dc&\u0011!-\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0011,G\u0002\u0001\u0003\u0006M.\u0011\ra\u001a\u0002\u0002)F\u0011\u0001n\u001b\t\u00031%L!A[\r\u0003\u000f9{G\u000f[5oOB\u0011An\\\u0007\u0002[*\u0011anJ\u0001\te\u0016\fX/Z:ug&\u0011\u0001/\u001c\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3tiB\u0011AK]\u0005\u0003gr\u0013qAU3rk\u0016\u001cH\u000fC\u0003v\u0017\u0001\u0007a/A\u0004ck&dG-\u001a:\u0011\u0007]T8M\u0004\u0002mq&\u0011\u00110\\\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&\u00111\u0010 \u0002\b\u0005VLG\u000eZ3s\u0015\tIX\u000eC\u0004\u007f\u0017A\u0005\t\u0019A@\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005\u0005\u0011QA\u0007\u0003\u0003\u0007Q!aV\u0014\n\t\u0005\u001d\u00111\u0001\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0017EVLG\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011QBA\u0012+\t\tyAK\u0002\u0000\u0003#Y#!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;I\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011EA\f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006M2\u0011\raZ\u0001\rEVLG\u000eZ*fgNLwN\u001c\u000b\u0005\u0003S\ty\u0004\u0005\u0003\u0002,\u0005mbbAA\u00171:!\u0011qFA\u001d\u001d\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001b+\u00051AH]8pizJ\u0011\u0001F\u0005\u0003/NI1!!\u0010]\u0005\u001d\u0019Vm]:j_:Dq!!\u0011\u000e\u0001\u0004\t\u0019%\u0001\u0003vg\u0016\u0014\b\u0003BA#\u0003\u001brA!a\u0012\u0002JA\u0019\u0011\u0011G\r\n\u0007\u0005-\u0013$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017J\u0012aC7bs\n,'+Z2pe\u0012$\u0012bMA,\u0003C\n\u0019'a\u001a\t\u000f\u0005ec\u00021\u0001\u0002\\\u0005a\u0011/^8uC6\u000bg.Y4feB\u0019\u0001%!\u0018\n\u0007\u0005}\u0013C\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\bbBA!\u001d\u0001\u0007\u00111\t\u0005\b\u0003Kr\u0001\u0019AA\"\u0003!\u0019G.[3oi&#\u0007bBA5\u001d\u0001\u0007\u00111N\u0001\u0006m\u0006dW/\u001a\t\u00041\u00055\u0014bAA83\t1Ai\\;cY\u0016\f\u0001\u0002\u001e5s_R$H.\u001a\u000b\fq\u0005U\u0014qOA=\u0003w\ny\bC\u0004\u0002Z=\u0001\r!a\u0017\t\u000f\u0005\u0005s\u00021\u0001\u0002D!9\u0011QM\bA\u0002\u0005\r\u0003BBA?\u001f\u0001\u00071'\u0001\buQJ|G\u000f\u001e7f)&lW-T:\t\u000f\u0005\u0005u\u00021\u0001\u0002\u0004\u0006I2\r[1o]\u0016dG\u000b\u001b:piRd\u0017N\\4DC2d'-Y2l!\u0015A\u0012QQ*9\u0013\r\t9)\u0007\u0002\n\rVt7\r^5p]F\u0002")
public class BaseClientQuotaManagerTest {
    private final MockTime time = new MockTime();
    private int numCallbacks = 0;
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());

    public MockTime time() {
        return this.time;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public void callback(RequestChannel.Response response) {
        if (response instanceof RequestChannel.StartThrottlingResponse) {
            return;
        }
        if (response instanceof RequestChannel.EndThrottlingResponse) {
            this.numCallbacks_$eq(this.numCallbacks() + 1);
            return;
        }
        throw new MatchError((Object)response);
    }

    public <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    public <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public RequestChannel.Session buildSession(String user) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return new RequestChannel.Session(principal, null);
    }

    public int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        return quotaManager.maybeRecordAndGetThrottleTimeMs(this.buildSession(user), clientId, value, this.time().milliseconds());
    }

    public void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        quotaManager.throttle(request, throttleTimeMs, channelThrottlingCallback);
    }
}

