/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfig;
import kafka.server.DynamicConfigManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001\u0002\f\u0018\u0001qAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005\u0002!BQA\u000e\u0001\u0005\u0002]BQ!\u0012\u0001\u0005\u0002]BQa\u0012\u0001\u0005\n!CQ\u0001\u0018\u0001\u0005\u0002]BQA\u0018\u0001\u0005\u0002]BQ\u0001\u0019\u0001\u0005\u0002]BQA\u0019\u0001\u0005\u0002]BQ\u0001\u001a\u0001\u0005\u0002]BQA\u001a\u0001\u0005\u0002]BQ\u0001\u001b\u0001\u0005\u0002]BQA\u001b\u0001\u0005\u0002]BQ\u0001\u001c\u0001\u0005\u0002]BQA\u001c\u0001\u0005\u0002]BQ\u0001\u001d\u0001\u0005\u0002]BQA\u001d\u0001\u0005\u0002]BQ\u0001\u001e\u0001\u0005\u0002]BQA\u001e\u0001\u0005\u0002]BQ\u0001\u001f\u0001\u0005\u0002eDq!!\u0005\u0001\t\u0013\t\u0019BA\fEs:\fW.[2D_:4\u0017nZ\"iC:<W\rV3ti*\u0011\u0001$G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003i\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\u0011\u0001%G\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002#?\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002/\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001*!\rQ\u0013gM\u0007\u0002W)\u0011A&L\u0001\nS6lW\u000f^1cY\u0016T!AL\u0018\u0002\u0015\r|G\u000e\\3di&|gNC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u00114F\u0001\u0003MSN$\bC\u0001\u00145\u0013\t)tCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u0005;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0005A\u0004CA\u001d;\u001b\u0005y\u0013BA\u001e0\u0005\u0011)f.\u001b;)\u0005\ri\u0004C\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0015aA8sO&\u0011Ai\u0010\u0002\u0005)\u0016\u001cH/\u0001\u000fuKN$H)\u001f8b[&\u001cGk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3)\u0005\u0011i\u0014!\u0006;fgR\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0006q%3\u0006L\u0017\u0005\u0006\u0015\u0016\u0001\raS\u0001\u0005kN,'\u000f\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d>j\u0011a\u0014\u0006\u0003!n\ta\u0001\u0010:p_Rt\u0014B\u0001*0\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I{\u0003\"B,\u0006\u0001\u0004Y\u0015\u0001C2mS\u0016tG/\u00133\t\u000be+\u0001\u0019A&\u0002\u001dI|w\u000e^#oi&$\u0018\u0010V=qK\")1,\u0002a\u0001\u0017\u0006\u00012m\u001c8gS\u001e,e\u000e^5us:\u000bW.Z\u0001\u001ei\u0016\u001cHo\u00117jK:$\u0018\nZ)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012a!P\u0001\u001ai\u0016\u001cH/V:feF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002\b{\u0005YB/Z:u+N,'o\u00117jK:$\u0018\nZ)v_R\f7\t[1oO\u0016D#\u0001C\u001f\u0002IQ,7\u000f\u001e#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#!C\u001f\u0002AQ,7\u000f\u001e#fM\u0006,H\u000e^+tKJ\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003\u0015u\n\u0001\u0006^3ti\u0012+g-Y;miV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#aC\u001f\u0002/Q,7\u000f^)v_R\f\u0017J\\5uS\u0006d\u0017N_1uS>t\u0007F\u0001\u0007>\u0003\t\"Xm\u001d;D_:4\u0017nZ\"iC:<Wm\u00148O_:,\u00050[:uS:<Gk\u001c9jG\"\u0012Q\"P\u00012i\u0016\u001cHoQ8oM&<7\t[1oO\u0016|eNT8o\u000bbL7\u000f^5oOR{\u0007/[2XSRD\u0017\tZ7j]\u000ec\u0017.\u001a8uQ\tqQ(A\fuKN$\bK]8dKN\u001chj\u001c;jM&\u001c\u0017\r^5p]\"\u0012q\"P\u0001&g\"|W\u000f\u001c3QCJ\u001cXMU3qY&\u001c\u0017\r^5p]F+x\u000e^1Qe>\u0004XM\u001d;jKND#\u0001E\u001f\u0002[MDw.\u001e7e!\u0006\u00148/Z,jY\u0012\u001c\u0017M\u001d3SKBd\u0017nY1uS>t\u0017+^8uCB\u0013x\u000e]3si&,7\u000f\u000b\u0002\u0012{\u0005\u00013\u000f[8vY\u0012\u0004\u0016M]:f%\u0016\u0004H.[2bi&|g.U;pi\u0006\u0014Vm]3uQ\t\u0011R(A\u0017tQ>,H\u000e\u001a)beN,'+Z4be\u0012dWm]:PM^C\u0017\u000e^3ta\u0006\u001cW-\u0011:pk:$g+\u00197vKND#aE\u001f\u0002\u000bA\f'o]3\u0015\u000bi\f\u0019!!\u0004\u0011\u0007mdh0D\u0001.\u0013\tiXFA\u0002TKF\u0004\"!O@\n\u0007\u0005\u0005qFA\u0002J]RDq!!\u0002\u0015\u0001\u0004\t9!A\u0007d_:4\u0017n\u001a%b]\u0012dWM\u001d\t\u0004M\u0005%\u0011bAA\u0006/\t\u0011Bk\u001c9jG\u000e{gNZ5h\u0011\u0006tG\r\\3s\u0011\u0019\ty\u0001\u0006a\u0001\u0017\u0006)a/\u00197vK\u0006\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0015\u0005\u0005U\u0001\u0003BA\f\u0003Oi!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003?\t\t#A\u0004dY&,g\u000e^:\u000b\u0007i\t\u0019CC\u0002\u0002&\u0005\u000ba!\u00199bG\",\u0017\u0002BA\u0015\u00033\u0011Q!\u00113nS:\u0004")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigChange() {
        Long l;
        Long l2;
        Assert.assertTrue((String)"Should contain a ConfigHandler for topics", (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()));
        Long l3 = l2 = Long.valueOf(100000L);
        l2 = null;
        Long oldVal = l3;
        Long l4 = l = Long.valueOf(200000L);
        l = null;
        Long newVal = l4;
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        long l5 = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var19_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += Math.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var5_8 = null;
        Object var10_12 = null;
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l7 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l8 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l8).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var20_20 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l8);
                l8 += Math.min(l8, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicTopicConfigChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)oldSegmentSize).toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var24_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var9_5 = null;
        Object var14_11 = null;
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Log log = (Log)qual$2.getLog(tp, x$4).get();
        int newSegmentSize = 2000;
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)newSegmentSize).toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var25_22 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += Math.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var15_17 = null;
        Object var20_21 = null;
        int n = 1;
        int to$extension_end = 50;
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive(n, to$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)this.servers(), tp.topic(), ((Object)foreach$mVc$sp_i).toString(), 30000, 20000);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var21_26 = null;
        Assert.assertTrue((String)"Log segment size change not applied", (boolean)log.logSegments().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$4(x$1))));
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assert.assertTrue((String)new StringBuilder(35).append("Should contain a ConfigHandler for ").append(rootEntityType).toString(), (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType));
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().quotas();
        String string = ConfigType$.MODULE$.Client();
        if (!(string != null ? !string.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, props);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, props);
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string2;
                    String string3 = string2 = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string2 = null;
                    String msgWithLogIdent_msg = string3;
                    Object var24_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var12_8 = null;
        Object var17_12 = null;
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string4 = ConfigType$.MODULE$.Client();
        if (!(string4 != null ? !string4.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, emptyProps);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, emptyProps);
        }
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string5;
                    String string6 = string5 = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string5 = null;
                    String msgWithLogIdent_msg = string6;
                    Object var25_23 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += Math.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        Properties userProps = new Properties();
        userProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "10000");
        userProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "100000");
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("overriddenUser", userProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        double upperBound_upperBound = 1000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound2 = 2000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound3 = 10000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound3, true), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound4 = 20000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound4, true), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound5 = 100000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound5, true), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        double upperBound_upperBound6 = 200000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound6, true), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try {
            Properties logProps = new Properties();
            logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), (Object)10000);
            this.adminZkClient().changeTopicConfig(topic, logProps);
            Assert.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            return;
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            return;
        }
    }

    @Test
    public void testConfigChangeOnNonExistingTopicWithAdminClient() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMessagesProp(), "10000"), AlterConfigOp.OpType.SET);
                Object[] objectArray = new Tuple2[1];
                Collection $minus$greater$extension_y = AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection();
                Object var6_5 = null;
                objectArray[0] = new Tuple2((Object)resource, (Object)$minus$greater$extension_y);
                admin.incrementalAlterConfigs(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava()).all().get();
                Assert.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assert.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessNotification() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        Integer n;
        String string;
        new Properties().put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        Object[] objectArray = new Tuple2[1];
        String string2 = string = ConfigType$.MODULE$.Topic();
        string = null;
        String $minus$greater$extension_$this = string2;
        Object var9_5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)handler);
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), 900000L, Time.SYSTEM);
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        try {
            void $minus$greater$extension_y4;
            Integer n2;
            void $minus$greater$extension_y5;
            Integer n3;
            Object[] objectArray2 = new Tuple2[2];
            Integer n4 = n3 = Integer.valueOf(1);
            n3 = null;
            Integer n5 = n4;
            String $minus$greater$extension_$this2 = "v";
            Object var10_9 = null;
            n5 = null;
            objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
            Integer n6 = n2 = Integer.valueOf(2);
            n2 = null;
            Integer n7 = n6;
            String $minus$greater$extension_$this3 = "x";
            Object var12_12 = null;
            n7 = null;
            objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
            Map jsonMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)jsonMap).asJava()));
            Assert.fail((String)new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString());
        }
        catch (Throwable throwable) {}
        try {
            void $minus$greater$extension_y6;
            void $minus$greater$extension_y7;
            void $minus$greater$extension_y8;
            Integer n8;
            Object[] objectArray3 = new Tuple2[3];
            Integer n9 = n8 = Integer.valueOf(1);
            n8 = null;
            Integer n10 = n9;
            String $minus$greater$extension_$this4 = "version";
            Object var14_16 = null;
            n10 = null;
            objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y8);
            String string3 = "garbage";
            String $minus$greater$extension_$this5 = "entity_type";
            Object var16_18 = null;
            string3 = null;
            objectArray3[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y7);
            String string4 = "x";
            String $minus$greater$extension_$this6 = "entity_name";
            Object var18_20 = null;
            string4 = null;
            objectArray3[2] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
            Map jsonMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)jsonMap).asJava()));
            Assert.fail((String)new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString());
        }
        catch (Throwable throwable) {}
        try {
            void $minus$greater$extension_y9;
            void $minus$greater$extension_y10;
            Integer n11;
            Object[] objectArray4 = new Tuple2[2];
            Integer n12 = n11 = Integer.valueOf(1);
            n11 = null;
            Integer n13 = n12;
            String $minus$greater$extension_$this7 = "version";
            Object var20_24 = null;
            n13 = null;
            objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y10);
            String string5 = ConfigType$.MODULE$.Topic();
            String $minus$greater$extension_$this8 = "entity_type";
            Object var22_26 = null;
            string5 = null;
            objectArray4[1] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y9);
            Map jsonMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)jsonMap).asJava()));
            Assert.fail((String)new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString());
        }
        catch (Throwable throwable) {}
        Object[] objectArray5 = new Tuple2[3];
        Integer n14 = n = Integer.valueOf(1);
        n = null;
        Integer n15 = n14;
        String $minus$greater$extension_$this9 = "version";
        Object var24_30 = null;
        n15 = null;
        objectArray5[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y3);
        String string6 = ConfigType$.MODULE$.Topic();
        String $minus$greater$extension_$this10 = "entity_type";
        Object var26_32 = null;
        string6 = null;
        objectArray5[1] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y2);
        String string7 = "x";
        String $minus$greater$extension_$this11 = "entity_name";
        Object var28_34 = null;
        string7 = null;
        objectArray5[2] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y);
        Map jsonMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)jsonMap).asJava()));
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assert.assertEquals((Object)Nil$.MODULE$, this.parse(configHandler, " "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assert.assertTrue((boolean)logOpt.isDefined());
        Assert.assertEquals((Object)oldVal$1, (Object)((Log)logOpt.get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assert.assertEquals((Object)newVal$1, (Object)((Log)qual$2.getLog(tp$1, x$4).get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assert.assertTrue((boolean)logOpt.isDefined());
        Assert.assertEquals((Object)oldSegmentSize$1, (Object)((Log)logOpt.get()).config().segmentSize());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, Log log$1) {
        Assert.assertEquals((Object)newSegmentSize$1, (Object)log$1.config().segmentSize());
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicTopicConfigChange$4(LogSegment x$1) {
        return x$1.size() > 1000;
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        double upperBound_upperBound = 1000.0;
        Assert.assertEquals((String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString(), (Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota);
        double upperBound_upperBound2 = 2000.0;
        Assert.assertEquals((String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString(), (Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assert.assertEquals((String)new StringBuilder(0).append(new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").toString()).append(defaultProducerQuota$1).toString(), (Object)new Quota(defaultProducerQuota$1, true), (Object)producerQuota);
        Assert.assertEquals((String)new StringBuilder(0).append(new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").toString()).append(defaultConsumerQuota$1).toString(), (Object)new Quota(defaultConsumerQuota$1, true), (Object)consumerQuota);
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }
}

