/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import kafka.server.MetadataCache;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001B\u0007\u000f\u0001MAQA\u0007\u0001\u0005\u0002mAqA\b\u0001C\u0002\u0013\u0005q\u0004\u0003\u0004$\u0001\u0001\u0006I\u0001\t\u0005\u0006I\u0001!\t!\n\u0005\u0006e\u0001!\t!\n\u0005\u0006i\u0001!\t!\n\u0005\u0006m\u0001!\t!\n\u0005\u0006q\u0001!I!\u000f\u0005\u0006y\u0002!\t!\n\u0005\u0006}\u0002!\t!\n\u0005\u0007\u0003\u0003\u0001A\u0011A\u0013\t\r\u0005\u0015\u0001\u0001\"\u0001&\u0005EiU\r^1eCR\f7)Y2iKR+7\u000f\u001e\u0006\u0003\u001fA\taa]3sm\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005q\u0011a\u00032s_.,'/\u00129pG\",\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\t1{gnZ\u0001\rEJ|7.\u001a:Fa>\u001c\u0007\u000eI\u0001\"O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006tuN\\#ySN$\u0018N\\4U_BL7m\u001d\u000b\u0002MA\u0011QcJ\u0005\u0003QY\u0011A!\u00168ji\"\u0012AA\u000b\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nQA[;oSRT\u0011aL\u0001\u0004_J<\u0017BA\u0019-\u0005\u0011!Vm\u001d;\u0002!\u001d,G\u000fV8qS\u000elU\r^1eCR\f\u0007FA\u0003+\u0003-:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MK\u0006$WM\u001d(pi\u00063\u0018-\u001b7bE2,\u0007F\u0001\u0004+\u0003U:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MSN$XM\\3s\u001d>$\u0018I^1jY\u0006\u0014G.Z(o\u0019\u0016\fG-\u001a:)\u0005\u001dQ\u0013\u0001\u000f<fe&4\u0017\u0010V8qS\u000elU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'o\u0014:F]\u0012\u0004x.\u001b8u\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\bMizT-\\8x\u0011\u0015Y\u0004\u00021\u0001=\u0003UiW\r^1eCR\f7)Y2iK\n\u0013xn[3s\u0013\u0012\u0004\"!F\u001f\n\u0005y2\"aA%oi\")\u0001\t\u0003a\u0001\u0003\u00069!M]8lKJ\u001c\bc\u0001\"K\u001b:\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rJ\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0005%3\u0012a\u00029bG.\fw-Z\u0005\u0003\u00172\u00131aU3r\u0015\tIe\u0003\u0005\u0002OE:\u0011qj\u0018\b\u0003!rs!!U-\u000f\u0005I;fBA*V\u001d\t!E+C\u00010\u0013\t1f&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003#aS!A\u0016\u0018\n\u0005i[\u0016AB2p[6|gN\u0003\u0002\u00121&\u0011QLX\u0001\b[\u0016\u001c8/Y4f\u0015\tQ6,\u0003\u0002aC\u0006IR\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$H)\u0019;b\u0015\tif,\u0003\u0002dI\n!R\u000b\u001d3bi\u0016lU\r^1eCR\f'I]8lKJT!\u0001Y1\t\u000b\u0019D\u0001\u0019A4\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\u0005!\\W\"A5\u000b\u0005)t\u0016a\u00028fi^|'o[\u0005\u0003Y&\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016DQA\u001c\u0005A\u0002q\na\u0001\\3bI\u0016\u0014\b\"\u00029\t\u0001\u0004\t\u0018!D3ya\u0016\u001cG/\u001a3FeJ|'\u000f\u0005\u0002sk6\t1O\u0003\u0002u=\u0006A\u0001O]8u_\u000e|G.\u0003\u0002wg\n1QI\u001d:peNDQ\u0001\u001f\u0005A\u0002e\f\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3MSN$XM\\3sgB\u0011QC_\u0005\u0003wZ\u0011qAQ8pY\u0016\fg.A\u0012hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+\u0007\u000f\\5dC:{G/\u0011<bS2\f'\r\\3)\u0005%Q\u0013aH4fiR{\u0007/[2NKR\fG-\u0019;b\u0013N\u0014hj\u001c;Bm\u0006LG.\u00192mK\"\u0012!BK\u00011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006<\u0016\u000e\u001e5O_:\u001cV\u000f\u001d9peR,GmU3dkJLG/\u001f)s_R|7m\u001c7)\u0005-Q\u0013AL4fi\u0006c\u0017N^3Ce>\\WM]:TQ>,H\u000e\u001a(pi\n+W*\u001e;bi\u0016$')_+qI\u0006$XmQ1dQ\u0016D#\u0001\u0004\u0016")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void getTopicMetadataNonExistingTopics() {
        void apply_elems;
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertTrue((boolean)cache.getTopicMetadata((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void getTopicMetadata() {
        IndexedSeq indexedSeq;
        UpdateMetadataRequestData.UpdateMetadataBroker updateMetadataBroker;
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int n = 0;
        int to$extension_end = 4;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            UpdateMetadataRequestData.UpdateMetadataBroker updateMetadataBroker2;
            UpdateMetadataRequestData.UpdateMetadataBroker updateMetadataBroker3 = updateMetadataBroker2 = MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            updateMetadataBroker2 = null;
            updateMetadataBroker = updateMetadataBroker3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            updateMetadataBroker = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var13_9 = null;
        Object var14_10 = null;
        Object var15_11 = null;
        updateMetadataBroker = null;
        indexedSeq = null;
        IndexedSeq brokers = indexedSeq2;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(0, 1, 3)).setZkVersion(zkVersion).setReplicas(Arrays.asList(0, 1, 3)), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(1, 0)).setZkVersion(zkVersion).setReplicas(Arrays.asList(1, 2, 0, 4)), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(2, 1)).setZkVersion(zkVersion).setReplicas(Arrays.asList(2, 1, 3)), (List)Nil$.MODULE$)));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)partitionStates).asJava(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        .colon.colon foreach_these = new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$));
        while (!foreach_these.isEmpty()) {
            SecurityProtocol securityProtocol = (SecurityProtocol)foreach_these.head();
            MetadataCacheTest.$anonfun$getTopicMetadata$2(cache, (scala.collection.immutable.Seq)partitionStates, topic0, topic1, securityProtocol);
            foreach_these = (List)foreach_these.tail();
        }
    }

    @Test
    public void getTopicMetadataPartitionLeaderNotAvailable() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(metadataCacheBrokerId, (scala.collection.immutable.Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(metadataCacheBrokerId, (scala.collection.immutable.Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(metadataCacheBrokerId, (scala.collection.immutable.Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(metadataCacheBrokerId, (scala.collection.immutable.Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(int metadataCacheBrokerId, scala.collection.immutable.Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        boolean x$4;
        void apply_elems;
        String topic = "topic";
        MetadataCache cache = new MetadataCache(metadataCacheBrokerId);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(0)).setZkVersion(zkVersion).setReplicas(Arrays.asList(0)), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)partitionStates).asJava(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4 = cache.getTopicMetadata$default$3(), errorUnavailableListeners);
        if (topicMetadatas == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)topicMetadatas.length());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assert.assertEquals((long)Errors.NONE.code(), (long)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partitionIndex());
        Assert.assertEquals((long)expectedError.code(), (long)partitionMetadata.errorCode());
        Assert.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadata.replicaNodes()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void getTopicMetadataReplicaNotAvailable() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(0, 1);
        java.util.List<Integer> isr = Arrays.asList(0);
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)partitionStates).asJava(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Seq topicMetadatas = cache.getTopicMetadata((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems6), listenerName, false, cache.getTopicMetadata$default$4());
        if (topicMetadatas == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)topicMetadatas.length());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assert.assertEquals((long)Errors.NONE.code(), (long)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partitionIndex());
        Assert.assertEquals((long)Errors.NONE.code(), (long)partitionMetadata.errorCode());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems5), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadata.replicaNodes()).asScala().toSet());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems4), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadata.isrNodes()).asScala().toSet());
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems3), listenerName, true, cache.getTopicMetadata$default$4());
        if (topicMetadatasWithError == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.length());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assert.assertEquals((long)Errors.NONE.code(), (long)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partitionIndex());
        Assert.assertEquals((long)Errors.REPLICA_NOT_AVAILABLE.code(), (long)partitionMetadataWithError.errorCode());
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems2), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void getTopicMetadataIsrNotAvailable() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(0);
        java.util.List<Integer> isr = Arrays.asList(0, 1);
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)partitionStates).asJava(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Seq topicMetadatas = cache.getTopicMetadata((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems6), listenerName, false, cache.getTopicMetadata$default$4());
        if (topicMetadatas == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)topicMetadatas.length());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assert.assertEquals((long)Errors.NONE.code(), (long)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partitionIndex());
        Assert.assertEquals((long)Errors.NONE.code(), (long)partitionMetadata.errorCode());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems5), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadata.replicaNodes()).asScala().toSet());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems4), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadata.isrNodes()).asScala().toSet());
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems3), listenerName, true, cache.getTopicMetadata$default$4());
        if (topicMetadatasWithError == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.length());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assert.assertEquals((long)Errors.NONE.code(), (long)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partitionIndex());
        Assert.assertEquals((long)Errors.REPLICA_NOT_AVAILABLE.code(), (long)partitionMetadataWithError.errorCode());
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems2), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void getTopicMetadataWithNonSupportedSecurityProtocol() {
        void apply_elems;
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(0);
        java.util.List<Integer> isr = Arrays.asList(0, 1);
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)partitionStates).asJava(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Seq topicMetadata = cache.getTopicMetadata((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        if (topicMetadata == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)topicMetadata.length());
        Assert.assertEquals((long)1L, (long)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assert.assertEquals((long)-1L, (long)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @Test
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache() {
        Range.Inclusive inclusive;
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int n = 0;
        int to$extension_end = 2;
        Range.Inclusive inclusive2 = inclusive = new Range.Inclusive(n, to$extension_end, 1);
        inclusive = null;
        Range.Inclusive initialBrokerIds = inclusive2;
        this.updateCache$1((scala.collection.immutable.Seq)initialBrokerIds, topic, cache);
        Seq aliveBrokersFromCache = cache.getAliveBrokers();
        int n2 = 0;
        int to$extension_end2 = 3;
        this.updateCache$1((scala.collection.immutable.Seq)new Range.Inclusive(n2, to$extension_end2, 1), topic, cache);
        Assert.assertEquals((Object)IterableOnceOps.toSet$((IterableOnceOps)initialBrokerIds), (Object)((IterableOnceOps)aliveBrokersFromCache.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()))).toSet());
    }

    private static final scala.collection.immutable.Seq endpoints$1(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)MetadataCacheTest.endpoints$1(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$1, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$1) : topic$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
        return x$2.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(scala.collection.immutable.Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assert.assertEquals((long)Errors.NONE.code(), (long)partitionMetadata.errorCode());
            Assert.assertEquals((long)partitionId, (long)partitionMetadata.partitionIndex());
            Option option = topicPartitionStates$1.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$2)));
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw Assertions$.MODULE$.fail(new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString(), new Position("MetadataCacheTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            }
            Object var5_4 = null;
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)getOrElse_this.get();
            Assert.assertEquals((long)partitionState.leader(), (long)partitionMetadata.leaderId());
            Assert.assertEquals((long)partitionState.leaderEpoch(), (long)partitionMetadata.leaderEpoch());
            Assert.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assert.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, scala.collection.immutable.Seq partitionStates$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        if (topicMetadatas == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)topicMetadatas.length());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assert.assertEquals((long)Errors.NONE.code(), (long)topicMetadata.errorCode());
        Assert.assertEquals((Object)topic, (Object)topicMetadata.name());
        scala.collection.immutable.Seq topicPartitionStates = (scala.collection.immutable.Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        if (topicPartitionStates == null) {
            throw null;
        }
        if (partitionMetadatas == null) {
            throw null;
        }
        Assert.assertEquals((String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString(), (long)topicPartitionStates.length(), (long)partitionMetadatas.length());
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, scala.collection.immutable.Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(scala.collection.immutable.Seq brokerIds, String topic$2, MetadataCache cache$2) {
        scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(0);
        java.util.List<Integer> isr = Arrays.asList(0, 1);
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$2).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)partitionStates).asJava(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)brokers).asJava()).build();
        cache$2.updateMetadata(15, updateMetadataRequest);
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1$adapted(Object brokerId) {
        return MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId));
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, scala.collection.immutable.Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

