/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.utils.IncludeList;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t2Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\tyAk\u001c9jG\u001aKG\u000e^3s)\u0016\u001cHO\u0003\u0002\u0006\r\u0005)Q\u000f^5mg*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002%A\u00111\u0003A\u0007\u0002\t\u0005\u0001B/Z:u\u0013:\u001cG.\u001e3f\u0019&\u001cHo\u001d\u000b\u0002-A\u00111bF\u0005\u000311\u0011A!\u00168ji\"\u0012!A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;")
public class TopicFilterTest {
    @Test
    public void testIncludeLists() {
        IncludeList topicFilter1 = new IncludeList("yes1,yes2");
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed("yes2", true));
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed("yes2", false));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed("no1", true));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed("no1", false));
        IncludeList topicFilter2 = new IncludeList(".+");
        Assert.assertTrue((boolean)topicFilter2.isTopicAllowed("alltopics", true));
        Assert.assertFalse((boolean)topicFilter2.isTopicAllowed("__consumer_offsets", true));
        Assert.assertTrue((boolean)topicFilter2.isTopicAllowed("__consumer_offsets", false));
        IncludeList topicFilter3 = new IncludeList("included-topic.+");
        Assert.assertTrue((boolean)topicFilter3.isTopicAllowed("included-topic1", true));
        Assert.assertFalse((boolean)topicFilter3.isTopicAllowed("no1", true));
        IncludeList topicFilter4 = new IncludeList("test-(?!bad\\b)[\\w]+");
        Assert.assertTrue((boolean)topicFilter4.isTopicAllowed("test-good", true));
        Assert.assertFalse((boolean)topicFilter4.isTopicAllowed("test-bad", true));
    }
}

