/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!1\u0001\u0005\u0001Q\u0001\n\u0005Ba!\u000b\u0001!\u0002\u0013\t\u0003\"\u0002\u0016\u0001\t\u0003Y\u0003\"\u0002\u001f\u0001\t\u0003Y\u0003\"\u0002 \u0001\t\u0003Y\u0003\"\u0002!\u0001\t\u0003Y\u0003\"\u0002\"\u0001\t\u0003Y\u0003\"\u0002#\u0001\t\u0003Y\u0003\"\u0002$\u0001\t\u0003Y\u0003\"\u0002%\u0001\t\u0003Y\u0003\"\u0002&\u0001\t\u0003Y\u0003\"\u0002'\u0001\t\u0003Y\u0003B\u0002(\u0001A\u0013%qJ\u0001\tU_BL7mQ8n[\u0006tG\rV3ti*\u0011\u0011CE\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002'\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011\u0001E\u0001\u000bEJ|7.\u001a:MSN$\bC\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013Q|\u0007/[2OC6,\u0017A\t;fgRL5OT8u+:$WM\u001d*fa2L7-\u0019;fI^CWM\\!eI&tw\rF\u0001-!\t9R&\u0003\u0002/1\t!QK\\5uQ\t!\u0001\u0007\u0005\u00022u5\t!G\u0003\u00024i\u0005\u0019\u0011\r]5\u000b\u0005U2\u0014a\u00026va&$XM\u001d\u0006\u0003oa\nQA[;oSRT\u0011!O\u0001\u0004_J<\u0017BA\u001e3\u0005\u0011!Vm\u001d;\u0002MQ,7\u000f^!mi\u0016\u0014x+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0002\u0006a\u0005\tC/Z:u\u0007>tg-[4PaR<\u0016\u000e\u001e5C_>$8\u000f\u001e:baN+'O^3sg\"\u0012a\u0001M\u00015i\u0016\u001cHo\u0011:fCR,w+\u001b;i!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u/&$\bn\\;u%\u0016\u0004H.[2bi&|gNR1di>\u0014\bFA\u00041\u0003Q\"Xm\u001d;De\u0016\fG/Z,ji\"\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN],ji\"|W\u000f\u001e)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0003\u0011A\n\u0011\u0006^3ti\u000e\u0013X-\u0019;f/&$\b.Q:tS\u001etW.\u001a8u\u0003:$\u0007+\u0019:uSRLwN\\\"pk:$\bFA\u00051\u00031\"Xm\u001d;De\u0016\fG/Z,ji\"\f5o]5h]6,g\u000e^!oIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u000b\u0002\u000ba\u0005\u0019C/Z:u!\u0006\u00148/Z!tg&<g.\\3oi\u0012+\b\u000f\\5dCR,WI\u001c;sS\u0016\u001c\bFA\u00061\u00031\"Xm\u001d;QCJ\u001cX-Q:tS\u001etW.\u001a8u!\u0006\u0014H/\u001b;j_:\u001cxJ\u001a#jM\u001a,'/\u001a8u'&TX\r\u000b\u0002\ra\u0005\u0019B/Z:u!\u0006\u00148/Z!tg&<g.\\3oi\"\u0012Q\u0002M\u0001\u0018CN\u001cXM\u001d;DQ\u0016\u001c7.\u0011:hg\u0016C\u0018\u000e^\"pI\u0016$2\u0001\f)V\u0011\u0015\tf\u00021\u0001S\u0003!)\u0007\u0010]3di\u0016$\u0007CA\fT\u0013\t!\u0006DA\u0002J]RDQA\u0016\bA\u0002]\u000bqa\u001c9uS>t7\u000f\u0005\u0002YE:\u0011\u0011\f\u0019\b\u00035~s!a\u00170\u000e\u0003qS!!\u0018\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012BA\t\u0013\u0013\t\t\u0007#\u0001\u0007U_BL7mQ8n[\u0006tG-\u0003\u0002dI\n\u0019Bk\u001c9jG\u000e{W.\\1oI>\u0003H/[8og*\u0011\u0011\r\u0005")
public class TopicCommandTest {
    private final String brokerList;
    private final String topicName;

    @Test
    public void testIsNotUnderReplicatedWhenAdding() {
        List replicaIds = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        List replicas = replicaIds.map((Function1 & Serializable)id -> TopicCommandTest.$anonfun$testIsNotUnderReplicatedWhenAdding$1(BoxesRunTime.unboxToInt((Object)id)));
        Assertions.assertFalse((boolean)new TopicCommand.PartitionDescription("test-topic", new TopicPartitionInfo(0, new Node(1, "localhost", 9091), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(1, "localhost", 9091)}))).asJava()), (Option)None$.MODULE$, false, (Option)new Some((Object)new PartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaIds.map((Function1 & Serializable)id -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)}))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()))).isUnderReplicated());
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName}));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName, "--partitions", "3", "--config", "cleanup.policy=compact"}));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName, "--partitions", "3", "--delete-config", "cleanup.policy"}));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList, "--create", "--topic", this.topicName, "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"});
        opts.checkArgs();
        Assertions.assertTrue((boolean)opts.hasCreateOption());
        Assertions.assertEquals((Object)this.brokerList, (Object)opts.bootstrapServer().get());
        Assertions.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreateWithPartitionCountWithoutReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList, "--create", "--partitions", "2", "--topic", this.topicName}));
    }

    @Test
    public void testCreateWithReplicationFactorWithoutPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList, "--create", "--replication-factor", "3", "--topic", this.topicName}));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList, "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", this.topicName}));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList, "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", this.topicName}));
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions.assertThrows(AdminCommandFailedException.class, () -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions.assertThrows(AdminOperationException.class, () -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"));
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})))}))), (Object)actualAssignment);
    }

    private void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(exitCode, x$1) -> TopicCommandTest.$anonfun$assertCheckArgsExitCode$1(expected, BoxesRunTime.unboxToInt((Object)exitCode), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_3 = null;
        try {
            Assertions.assertThrows(RuntimeException.class, () -> options.checkArgs());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    public static final /* synthetic */ Node $anonfun$testIsNotUnderReplicatedWhenAdding$1(int id) {
        return new Node(id, "localhost", 9090 + id);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertCheckArgsExitCode$1(int expected$1, int exitCode, Option x$1) {
        Assertions.assertEquals((int)expected$1, (int)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandTest() {
        this.brokerList = "localhost:9092";
        this.topicName = "topicName";
    }
}

