/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberMetadata$;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tEb\u0001\u0002'N\u0001QCQa\u0017\u0001\u0005\u0002qCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004j\u0001\u0001\u0006I!\u0019\u0005\bU\u0002\u0011\r\u0011\"\u0003a\u0011\u0019Y\u0007\u0001)A\u0005C\"9A\u000e\u0001b\u0001\n\u0013\u0001\u0007BB7\u0001A\u0003%\u0011\rC\u0004o\u0001\t\u0007I\u0011\u00021\t\r=\u0004\u0001\u0015!\u0003b\u0011\u001d\u0001\bA1A\u0005\n\u0001Da!\u001d\u0001!\u0002\u0013\t\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007o\u0002\u0001\u000b\u0011\u0002;\t\u000fa\u0004!\u0019!C\u0005g\"1\u0011\u0010\u0001Q\u0001\nQDqA\u0014\u0001A\u0002\u0013%!\u0010C\u0004\u007f\u0001\u0001\u0007I\u0011B@\t\u000f\u0005-\u0001\u0001)Q\u0005w\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u0016\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003k\u0001A\u0011AA\b\u0011\u001d\tI\u0004\u0001C\u0001\u0003\u001fAq!!\u0010\u0001\t\u0003\ty\u0001C\u0004\u0002B\u0001!\t!a\u0004\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002\u0010!9\u0011\u0011\n\u0001\u0005\u0002\u0005=\u0001bBA'\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003#\u0002A\u0011AA\b\u0011\u001d\t)\u0006\u0001C\u0001\u0003\u001fAq!!\u0017\u0001\t\u0003\ty\u0001C\u0004\u0002^\u0001!\t!a\u0004\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002\u0010!9\u0011Q\r\u0001\u0005\u0002\u0005=\u0001bBA5\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003[\u0002A\u0011AA\b\u0011\u001d\t\t\b\u0001C\u0001\u0003\u001fAq!!\u001e\u0001\t\u0003\ty\u0001C\u0004\u0002x\u0001!\t!a\u0004\t\u000f\u0005m\u0004\u0001\"\u0001\u0002\u0010!9\u0011q\u0010\u0001\u0005\u0002\u0005=\u0001bBAB\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003\u000f\u0003A\u0011AA\b\u0011\u001d\tY\t\u0001C\u0001\u0003\u001fAq!a$\u0001\t\u0003\ty\u0001C\u0004\u0002\u0014\u0002!\t!a\u0004\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u0010!9\u00111\u0014\u0001\u0005\u0002\u0005=\u0001bBAP\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003G\u0003A\u0011AA\b\u0011\u001d\t9\u000b\u0001C\u0001\u0003\u001fAq!a+\u0001\t\u0003\ty\u0001C\u0004\u00020\u0002!\t!a\u0004\t\u000f\u0005M\u0006\u0001\"\u0001\u0002\u0010!9\u0011q\u0017\u0001\u0005\u0002\u0005=\u0001bBA^\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003\u007f\u0003A\u0011AA\b\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u001fAq!a2\u0001\t\u0003\ty\u0001C\u0004\u0002L\u0002!\t!a\u0004\t\u000f\u0005=\u0007\u0001\"\u0001\u0002\u0010!9\u00111\u001b\u0001\u0005\u0002\u0005=\u0001bBAl\u0001\u0011\u0005\u0011q\u0002\u0005\b\u00037\u0004A\u0011AA\b\u0011\u001d\ty\u000e\u0001C\u0001\u0003\u001fAq!a9\u0001\t\u0003\ty\u0001C\u0004\u0002h\u0002!\t!a\u0004\t\u000f\u0005-\b\u0001\"\u0001\u0002\u0010!9\u0011q\u001e\u0001\u0005\u0002\u0005=\u0001bBAz\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003o\u0004A\u0011AA\b\u0011\u001d\tY\u0010\u0001C\u0001\u0003\u001fAq!a@\u0001\t\u0003\ty\u0001C\u0004\u0003\u0004\u0001!\t!a\u0004\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n!9!q\u0003\u0001\u0005\n\te!!E$s_V\u0004X*\u001a;bI\u0006$\u0018\rV3ti*\u0011ajT\u0001\u0006OJ|W\u000f\u001d\u0006\u0003!F\u000b1bY8pe\u0012Lg.\u0019;pe*\t!+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0006C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;B\u0011a\fA\u0007\u0002\u001b\u0006a\u0001O]8u_\u000e|G\u000eV=qKV\t\u0011\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006!A.\u00198h\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[2\u0003\rM#(/\u001b8h\u00035\u0001(o\u001c;pG>dG+\u001f9fA\u0005yqM]8va&s7\u000f^1oG\u0016LE-\u0001\the>,\b/\u00138ti\u0006t7-Z%eA\u0005AQ.Z7cKJLE-A\u0005nK6\u0014WM]%eA\u0005A1\r\\5f]RLE-A\u0005dY&,g\u000e^%eA\u0005Q1\r\\5f]RDun\u001d;\u0002\u0017\rd\u0017.\u001a8u\u0011>\u001cH\u000fI\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5/F\u0001u!\t1V/\u0003\u0002w/\n\u0019\u0011J\u001c;\u0002'I,'-\u00197b]\u000e,G+[7f_V$Xj\u001d\u0011\u0002!M,7o]5p]RKW.Z8vi6\u001b\u0018!E:fgNLwN\u001c+j[\u0016|W\u000f^'tAU\t1\u0010\u0005\u0002_y&\u0011Q0\u0014\u0002\u000e\u000fJ|W\u000f]'fi\u0006$\u0017\r^1\u0002\u0013\u001d\u0014x.\u001e9`I\u0015\fH\u0003BA\u0001\u0003\u000f\u00012AVA\u0002\u0013\r\t)a\u0016\u0002\u0005+:LG\u000f\u0003\u0005\u0002\nE\t\t\u00111\u0001|\u0003\rAH%M\u0001\u0007OJ|W\u000f\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005\u0005\u0001fA\n\u0002\u0014A!\u0011QCA\u0014\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011aA1qS*!\u0011QDA\u0010\u0003\u001dQW\u000f]5uKJTA!!\t\u0002$\u0005)!.\u001e8ji*\u0011\u0011QE\u0001\u0004_J<\u0017\u0002BA\u0015\u0003/\u0011!BQ3g_J,W)Y2i\u0003i!Xm\u001d;DC:\u0014VMY1mC:\u001cWm\u00165f]N#\u0018M\u00197fQ\r!\u0012q\u0006\t\u0005\u0003+\t\t$\u0003\u0003\u00024\u0005]!\u0001\u0002+fgR\fq\u0005^3ti\u000e\u000bgNU3cC2\fgnY3XQ\u0016t7i\\7qY\u0016$\u0018N\\4SK\n\fG.\u00198dK\"\u001aQ#a\f\u0002SQ,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016t\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2fQ\r1\u0012qF\u0001\u001ci\u0016\u001cHoQ1o]>$(+\u001a2bY\u0006t7-Z,iK:$U-\u00193)\u0007]\ty#\u0001\u0015uKN$8\u000b^1cY\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000eK\u0002\u0019\u0003_\t!\u0004^3tiN#\u0018M\u00197f)>$U-\u00193Ue\u0006t7/\u001b;j_:D3!GA\u0018\u0003M\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000eK\u0002\u001b\u0003_\ta\u0005^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p\t\u0016\fG\r\u0016:b]NLG/[8oQ\rY\u0012qF\u0001(i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{W)\u001c9usR\u0013\u0018M\\:ji&|g\u000eK\u0002\u001d\u0003_\t\u0011\u0004^3ti\u0016k\u0007\u000f^=U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001aQ$a\f\u0002OQ,7\u000f^!xC&$\u0018N\\4SK\n\fG.\u00198dKR{7\u000b^1cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0004=\u0005=\u0012A\t;fgR,U\u000e\u001d;z)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002 \u0003_\t1\u0005^3tiN#\u0018M\u00197f)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002!\u0003_\tQ\u0006^3ti\u0016k\u0007\u000f^=U_\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\r\t\u0013qF\u0001<i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007f\u0001\u0012\u00020\u0005yC/Z:u!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\rV8Ti\u0006\u0014G.Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a1%a\f\u0002sQ,7\u000f^!xC&$\u0018N\\4SK\n\fG.\u00198dKR{\u0017i^1ji&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3\u0001JA\u0018\u0003}!Xm\u001d;EK\u0006$Gk\u001c#fC\u0012LE\u000e\\3hC2$&/\u00198tSRLwN\\\u0001\"i\u0016\u001cH\u000fR3bIR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004M\u0005=\u0012!\f;fgR$U-\u00193U_B\u0013X\r]1sS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aq%a\f\u0002YQ,7\u000f\u001e#fC\u0012$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007f\u0001\u0015\u00020\u0005\u0011B/Z:u'\u0016dWm\u0019;Qe>$xnY8mQ\rI\u0013qF\u0001$i\u0016\u001cHoU3mK\u000e$\bK]8u_\u000e|GNU1jg\u0016\u001c\u0018J\u001a(p\u001b\u0016l'-\u001a:tQ\rQ\u0013qF\u0001,i\u0016\u001cHoU3mK\u000e$\bK]8u_\u000e|Gn\u00115p_N,7oQ8na\u0006$\u0018N\u00197f!J|Go\\2pY\"\u001a1&a\f\u0002+Q,7\u000f^*vaB|'\u000f^:Qe>$xnY8mg\"\u001aA&a\f\u0002)Q,7\u000f^*vEN\u001c'/\u001b2fIR{\u0007/[2tQ\ri\u0013qF\u0001%i\u0016\u001cHoU;cg\u000e\u0014\u0018NY3e)>\u0004\u0018nY:O_:\u001cuN\\:v[\u0016\u0014xI]8va\"\u001aa&a\f\u0002-Q,7\u000f^%oSRtU\r\u001f;HK:,'/\u0019;j_:D3aLA\u0018\u0003\u0001\"Xm\u001d;J]&$h*\u001a=u\u000f\u0016tWM]1uS>tW)\u001c9us\u001e\u0013x.\u001e9)\u0007A\ny#\u0001\tuKN$xJ\u001a4tKR\u001cu.\\7ji\"\u001a\u0011'a\f\u0002/Q,7\u000f^(gMN,GoQ8n[&$h)Y5mkJ,\u0007f\u0001\u001a\u00020\u0005IC/Z:u\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e$bS2,(/Z,ji\"\fen\u001c;iKJ\u0004VM\u001c3j]\u001eD3aMA\u0018\u0003\t\"Xm\u001d;PM\u001a\u001cX\r^\"p[6LGoV5uQ\u0006sw\u000e\u001e5feB+g\u000eZ5oO\"\u001aA'a\f\u0002UQ,7\u000f^\"p]N,X.\u001a:CK\u0006$8\u000f\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7ji\"\u001aQ'a\f\u0002QQ,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u0014U-\u0019;t\u0007>t7/^7fe>3gm]3u\u0007>lW.\u001b;)\u0007Y\ny#A\u001buKN$HK]1og\u0006\u001cG/[8oC2\u001cu.\\7ji&\u001b\u0018IY8si\u0016$\u0017I\u001c3D_:\u001cX/\\3s\u0007>lW.\u001b;XS:\u001c\bfA\u001c\u00020\u0005iC/Z:u\r\u0006LG.\u001a3Uq:|eMZ:fi\u000e{W.\\5u\u0019\u0016\fg/Z:O_B+g\u000eZ5oON#\u0018\r^3)\u0007a\ny#A\u0017uKN$(+\u001a9mC\u000e,wI]8va&s7\u000f^1oG\u0016<\u0016\u000e\u001e5O_:,\u00050[:uS:<W*Z7cKJD3!OA\u0018\u0003a!Xm\u001d;SKBd\u0017mY3He>,\b/\u00138ti\u0006t7-\u001a\u0015\u0004u\u0005=\u0012A\u0006;fgRLeN^8lK*{\u0017N\\\"bY2\u0014\u0017mY6)\u0007m\ny#A\ruKN$hj\u001c;J]Z|7.\u001a&pS:\u001c\u0015\r\u001c7cC\u000e\\\u0007f\u0001\u001f\u00020\u00051B/Z:u\u0013:4xn[3Ts:\u001c7)\u00197mE\u0006\u001c7\u000eK\u0002>\u0003_\t\u0011\u0004^3ti:{G/\u00138w_.,7+\u001f8d\u0007\u0006dGNY1dW\"\u001aa(a\f\u00027Q,7\u000f\u001e%bgB+g\u000eZ5oO:{g\u000e\u0016=o\u001f\u001a47/\u001a;tQ\ry\u0014qF\u0001\u0019i\u0016\u001cH\u000fS1t!\u0016tG-\u001b8h)btwJ\u001a4tKR\u001c\bf\u0001!\u00020\u0005\u0011C/Z:u\u0007\u0006tgn\u001c;BI\u0012\u0004VM\u001c3j]\u001elU-\u001c2fe&37\u000b^1cY\u0016D3!QA\u0018\u0003%\"Xm\u001d;SK6|g/\u00197Ge>l\u0007+\u001a8eS:<\u0017I\u001a;fe6+WNY3s\u0013N\u001cF/\u00192mK\"\u001a!)a\f\u0002SQ,7\u000f\u001e*f[>4\u0018\r\u001c$s_6\u0004VM\u001c3j]\u001e<\u0006.\u001a8NK6\u0014WM]%t%\u0016lwN^3eQ\r\u0019\u0015qF\u0001*i\u0016\u001cHoQ1o]>$\u0018\t\u001a3Ti\u0006$\u0018nY'f[\n,'/\u00134BYJ,\u0017\rZ=Qe\u0016\u001cXM\u001c;)\u0007\u0011\u000by#A\u0014uKN$8)\u00198o_R\fE\r\u001a)f]\u0012LgnZ*z]\u000e|e-\u00168l]><h.T3nE\u0016\u0014\bfA#\u00020\u0005QC/Z:u\u0007\u0006tgn\u001c;SK6|g/\u001a)f]\u0012LgnZ*z]\u000e|e-\u00168l]><h.T3nE\u0016\u0014\bf\u0001$\u00020\u0005!C/Z:u\u0007\u0006t\u0017\t\u001a3B]\u0012\u0014V-\\8wKB+g\u000eZ5oONKhnY'f[\n,'\u000fK\u0002H\u0003_\tQ\u0006^3tiJ+Wn\u001c<bY\u001a\u0013x.\u001c)f]\u0012LgnZ*z]\u000e<\u0006.\u001a8NK6\u0014WM]%t%\u0016lwN^3eQ\rA\u0015qF\u0001*i\u0016\u001cHOT3x\u000f\u0016tWM]1uS>t7\t\\3beN\u0004VM\u001c3j]\u001e\u001c\u0016P\\2NK6\u0014WM]:)\u0007%\u000by#A\u0006bgN,'\u000f^*uCR,GCBA\u0001\u0005\u0017\u0011i\u0001C\u0003O\u0015\u0002\u00071\u0010C\u0004\u0003\u0010)\u0003\rA!\u0005\u0002\u0017Q\f'oZ3u'R\fG/\u001a\t\u0004=\nM\u0011b\u0001B\u000b\u001b\nQqI]8vaN#\u0018\r^3\u0002#=4gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003\u001c\t\u001d\u0002\u0003\u0002B\u000f\u0005Gi!Aa\b\u000b\u0007\t\u0005\u0012+\u0001\u0004d_6lwN\\\u0005\u0005\u0005K\u0011yBA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006DqA!\u000bL\u0001\u0004\u0011Y#\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0004-\n5\u0012b\u0001B\u0018/\n!Aj\u001c8h\u0001")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupInstanceId;
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test
    public void testEmptyToStableIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$3 = this.group();
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(lastMember, x$6);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolRaisesIfNoMembers() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testSubscribedTopics() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).asJava()), (short)1).array())})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(memberWithFaultyProtocol, x$4);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        member.supportedProtocols_$eq((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(member, (Function1 & Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId));
    }

    @Test
    public void testReplaceGroupInstance() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        member.awaitingSyncCallback_$eq((Function1 & Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)new Some((Object)this.memberId()), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId);
        Assertions.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assertions.assertEquals((Object)new Some((Object)newMemberId), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        Assertions.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assertions.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable)x$2 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertTrue((boolean)invoked.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        member.awaitingSyncCallback_$eq((Function1 & Serializable)x$3 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$3);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testHasPendingNonTxnOffsets() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition));
    }

    @Test
    public void testHasPendingTxnOffsets() {
        TopicPartition txnPartition = new TopicPartition("foo", 1);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int producerId = 5;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)txnPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition));
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    @Test
    public void testCannotAddPendingMemberIfStable() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingAfterMemberIsStable() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingWhenMemberIsRemoved() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        this.group().remove(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testCannotAddStaticMemberIfAlreadyPresent() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().hasStaticMember(this.groupInstanceId()));
        Assertions.assertThrows(IllegalStateException.class, () -> {
            GroupMetadata qual$2 = this.group();
            Function1 x$4 = qual$2.add$default$2();
            qual$2.add(member, x$4);
        });
    }

    @Test
    public void testCannotAddPendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingSyncMember(this.memberId()));
    }

    @Test
    public void testCannotRemovePendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().removePendingSyncMember(this.memberId()));
    }

    @Test
    public void testCanAddAndRemovePendingSyncMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().removePendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testRemovalFromPendingSyncWhenMemberIsRemoved() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().remove(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testNewGenerationClearsPendingSyncMembers() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        ((Set)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}))).$minus((Object)targetState)).foreach((Function1 & Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$3) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assertions.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupInstanceId = "groupInstanceId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

