/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.EndPoint;
import kafka.server.BrokerLifecycleManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MockBrokerToControllerChannelManager;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Timeout(value=12L)
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBQ!\u000f\u0001\u0005\u0002i2Aa\u0011\u0001\u0001\t\")Qg\u0001C\u0001\u0011\"91j\u0001b\u0001\n\u0003a\u0005B\u00021\u0004A\u0003%Q\nC\u0003b\u0007\u0011\u0005#\rC\u0003g\u0007\u0011\u0005s\rC\u0003o\u0007\u0011\u0005s\u000eC\u0003y\u0007\u0011\u0005\u0013P\u0002\u0004\u0002\f\u0001\u0001\u0011Q\u0002\u0005\n\u0003\u001fY!\u0011!Q\u0001\nmBa!N\u0006\u0005\u0002\u0005E\u0001\"CA\f\u0017\t\u0007I\u0011AA\r\u0011!\t\tc\u0003Q\u0001\n\u0005m\u0001\"CA\u0012\u0017\t\u0007I\u0011AA\u0013\u0011!\t\u0019d\u0003Q\u0001\n\u0005\u001d\u0002\"CA\u001b\u0017\t\u0007I\u0011AA\u001c\u0011!\tyd\u0003Q\u0001\n\u0005e\u0002\"CA!\u0017\t\u0007I\u0011AA\"\u0011!\t\tf\u0003Q\u0001\n\u0005\u0015\u0003\"CA*\u0017\t\u0007I\u0011AA+\u0011!\tif\u0003Q\u0001\n\u0005]\u0003\"CA0\u0017\t\u0007I\u0011AA1\u0011\u001d\t\u0019g\u0003Q\u0001\n%C\u0011\"!\u001a\f\u0005\u0004%\t!a\u001a\t\u0011\u0005=4\u0002)A\u0005\u0003SB\u0011\"!\u001d\f\u0005\u0004%\t!a\u001d\t\u0011\u0005m4\u0002)A\u0005\u0003kB\u0011\"! \f\u0005\u0004%\t!a \t\u0011\u0005-5\u0002)A\u0005\u0003\u0003C\u0011\"!$\f\u0005\u0004%\t!a$\t\u0011\u0005]6\u0002)A\u0005\u0003#Cq!!/\f\t\u0003\tY\fC\u0004\u0002D\u0002!\t!a/\t\u000f\u0005m\u0007\u0001\"\u0001\u0002<\"9\u0011q\u001c\u0001\u0005\u0002\u0005m\u0006bBAr\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003O\u0004A\u0011AA^\u0005i\u0011%o\\6fe2Kg-Z2zG2,W*\u00198bO\u0016\u0014H+Z:u\u0015\tQ3&\u0001\u0004tKJ4XM\u001d\u0006\u0002Y\u0005)1.\u00194lC\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011!K\u0001\u0011G>tg-[4Qe>\u0004XM\u001d;jKN,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA!\u001e;jY*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005)\u0001&o\u001c9feRLWm\u001d\u0002\u001d'&l\u0007\u000f\\3D_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3s'\r\u0019q&\u0012\t\u0003q\u0019K!aR\u0015\u0003-\r{g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ$\u0012!\u0013\t\u0003\u0015\u000ei\u0011\u0001A\u0001\u0005]>$W-F\u0001N!\rq5+V\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0007CR|W.[2\u000b\u0005Ik\u0014AC2p]\u000e,(O]3oi&\u0011Ak\u0014\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0011aKX\u0007\u0002/*\u0011\u0001,W\u0001\u0007G>lWn\u001c8\u000b\u00051R&BA.]\u0003\u0019\t\u0007/Y2iK*\tQ,A\u0002pe\u001eL!aX,\u0003\t9{G-Z\u0001\u0006]>$W\rI\u0001\u0004O\u0016$H#A2\u0011\u0007A\"W+\u0003\u0002fc\t1q\n\u001d;j_:\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W^\u000bqA\\3uo>\u00148.\u0003\u0002nU\naA*[:uK:,'OT1nK\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002aB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0005CV$\bN\u0003\u0002v/\u0006A1/Z2ve&$\u00180\u0003\u0002xe\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001\u000eg\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003i\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{Fj\u0011A \u0006\u0003\u007f6\na\u0001\u0010:p_Rt\u0014bAA\u0002c\u00051\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u00012\u0005\u0005\u0012%o\\6fe2Kg-Z2zG2,W*\u00198bO\u0016\u0014H+Z:u\u0007>tG/\u001a=u'\tYq&\u0001\u0006qe>\u0004XM\u001d;jKN$B!a\u0005\u0002\u0016A\u0011!j\u0003\u0005\u0007\u0003\u001fi\u0001\u0019A\u001e\u0002\r\r|gNZ5h+\t\tY\u0002E\u00029\u0003;I1!a\b*\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005!A/[7f+\t\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ticK\u0001\u0006kRLGn]\u0005\u0005\u0003c\tYC\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003UA\u0017n\u001a5fgRlU\r^1eCR\fwJ\u001a4tKR,\"!!\u000f\u0011\u00079\u000bY$C\u0002\u0002>=\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0003YA\u0017n\u001a5fgRlU\r^1eCR\fwJ\u001a4tKR\u0004\u0013\u0001C7fi\u0006$\u0017\r^1\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-\u0013,A\u0004dY&,g\u000e^:\n\t\u0005=\u0013\u0011\n\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006IQ.\u001a;bI\u0006$\u0018\rI\u0001\u000b[>\u001c7n\u00117jK:$XCAA,!\u0011\t9%!\u0017\n\t\u0005m\u0013\u0011\n\u0002\u000b\u001b>\u001c7n\u00117jK:$\u0018aC7pG.\u001cE.[3oi\u0002\nacY8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM]\u000b\u0002\u0013\u000692m\u001c8ue>dG.\u001a:O_\u0012,\u0007K]8wS\u0012,'\u000fI\u0001\u0010]>$W-\u00119j-\u0016\u00148/[8ogV\u0011\u0011\u0011\u000e\t\u0005\u0003\u000f\nY'\u0003\u0003\u0002n\u0005%#a\u0004(pI\u0016\f\u0005/\u001b,feNLwN\\:\u0002!9|G-Z!qSZ+'o]5p]N\u0004\u0013AE7pG.\u001c\u0005.\u00198oK2l\u0015M\\1hKJ,\"!!\u001e\u0011\u0007a\n9(C\u0002\u0002z%\u0012A%T8dW\n\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0014[>\u001c7n\u00115b]:,G.T1oC\u001e,'\u000fI\u0001\nG2,8\u000f^3s\u0013\u0012,\"!!!\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"@\u0003\u0011a\u0017M\\4\n\t\u0005\u001d\u0011QQ\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0013aE1em\u0016\u0014H/[:fI2K7\u000f^3oKJ\u001cXCAAI!\u0011\t\u0019*!-\u000f\t\u0005U\u00151\u0016\b\u0005\u0003/\u000b9K\u0004\u0003\u0002\u001a\u0006\u0015f\u0002BAN\u0003GsA!!(\u0002\":\u0019Q0a(\n\u0003uK!a\u0017/\n\u00051R\u0016B\u0001-Z\u0013\r\tIkV\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ti+a,\u0002;\t\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c*fcV,7\u000f\u001e#bi\u0006T1!!+X\u0013\u0011\t\u0019,!.\u0003%1K7\u000f^3oKJ\u001cu\u000e\u001c7fGRLwN\u001c\u0006\u0005\u0003[\u000by+\u0001\u000bbIZ,'\u000f^5tK\u0012d\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0005a>dG\u000e\u0006\u0002\u0002>B\u0019\u0001'a0\n\u0007\u0005\u0005\u0017G\u0001\u0003V]&$\u0018A\u0005;fgR\u001c%/Z1uK\u0006sGm\u00117pg\u0016D3aIAd!\u0011\tI-a6\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f1!\u00199j\u0015\u0011\t\t.a5\u0002\u000f),\b/\u001b;fe*\u0019\u0011Q\u001b/\u0002\u000b),h.\u001b;\n\t\u0005e\u00171\u001a\u0002\u0005)\u0016\u001cH/A\fuKN$8I]3bi\u0016\u001cF/\u0019:u\u0003:$7\t\\8tK\"\u001aA%a2\u00025Q,7\u000f^*vG\u000e,7o\u001d4vYJ+w-[:ue\u0006$\u0018n\u001c8)\u0007\u0015\n9-A\fuKN$(+Z4jgR\u0014\u0018\r^5p]RKW.Z8vi\"\u001aa%a2\u0002-Q,7\u000f^\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:D3aJAdQ\u001d\u0001\u0011Q^Az\u0003k\u0004B!!3\u0002p&!\u0011\u0011_Af\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u0004")
public class BrokerLifecycleManagerTest {
    /*
     * WARNING - void declaration
     */
    public Properties configProperties() {
        void var1_1;
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9093");
        properties.setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "300000");
        return var1_1;
    }

    @Test
    public void testCreateAndClose() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        new BrokerLifecycleManager(context.config(), (Time)context.time(), (Option)None$.MODULE$).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateStartAndClose() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), (Option)None$.MODULE$);
        Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, (Object)manager.state());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (BrokerToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testCreateStartAndClose$2(manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var9_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var3_4 = null;
        Object var8_8 = null;
        manager.close();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager.state());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulRegistration() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), (Option)None$.MODULE$);
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (BrokerToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$2(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var10_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_9 = null;
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegistrationTimeout() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        Node controllerNode = new Node(3000, "localhost", 8021);
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), (Option)None$.MODULE$);
        context.controllerNodeProvider().node().set(controllerNode);
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        Assertions.assertEquals((int)1, (int)context.mockClient().futureResponses().size());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (BrokerToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var22_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_10 = null;
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        long l3 = 60000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var23_18 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_13 = null;
        Object var15_17 = null;
        context.time().sleep(300000L);
        long l5 = 60000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string4 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string4;
                    Object var24_26 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += scala.math.package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_21 = null;
        Object var21_25 = null;
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        BrokerLifecycleManagerTestContext context = new BrokerLifecycleManagerTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), (Option)None$.MODULE$);
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsCaughtUp(true)), controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (BrokerToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$2(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var28_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_10 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsFenced(false)), controllerNode);
        context.time().sleep(20L);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var29_19 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_13 = null;
        Object var15_18 = null;
        manager.beginControlledShutdown();
        long l5 = 10000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string4 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string4;
                    Object var30_26 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += scala.math.package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_21 = null;
        Object var21_25 = null;
        context.mockClient().respond(body -> {
            boolean bl;
            if (body instanceof BrokerHeartbeatRequest) {
                Assertions.assertTrue((boolean)((BrokerHeartbeatRequest)body).data().wantShutDown());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setShouldShutDown(true)));
        long l7 = 10000L;
        TestUtils$ retry_this4 = TestUtils$.MODULE$;
        long l8 = 1L;
        long retry_startTime4 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$6(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime4 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this4.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string5 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l8).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string5;
                    Object var31_34 = null;
                    retry_this4.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this4, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l8);
                l8 += scala.math.package$.MODULE$.min(l8, 1000L);
                continue;
            }
            break;
        }
        Object var22_29 = null;
        Object var27_33 = null;
        manager.controlledShutdownFuture().get();
        manager.close();
    }

    public static final /* synthetic */ void $anonfun$testCreateStartAndClose$2(BrokerLifecycleManager manager$1) {
        Assertions.assertEquals((Object)BrokerState.STARTING, (Object)manager$1.state());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$2(BrokerLifecycleManagerTestContext context$2, BrokerLifecycleManager manager$2) {
        context$2.poll();
        Assertions.assertEquals((long)1000L, (long)manager$2.brokerEpoch());
    }

    private static final void newDuplicateRegistrationResponse$1(BrokerLifecycleManagerTestContext context$3, Node controllerNode$1) {
        context$3.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setErrorCode(Errors.DUPLICATE_BROKER_REGISTRATION.code())), controllerNode$1);
        context$3.mockChannelManager().poll();
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$2(BrokerLifecycleManagerTestContext context$3) {
        context$3.poll();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$3(BrokerLifecycleManagerTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.time().sleep(100L);
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$4(BrokerLifecycleManagerTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$3.state());
        Assertions.assertTrue((boolean)manager$3.initialCatchUpFuture().isCompletedExceptionally());
        Assertions.assertEquals((long)-1L, (long)manager$3.brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$2(BrokerLifecycleManagerTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RECOVERY, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$3(BrokerLifecycleManagerTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$4(BrokerLifecycleManagerTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN, (Object)manager$4.state());
        Assertions.assertTrue((boolean)context$4.mockClient().hasInFlightRequests());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$6(BrokerLifecycleManagerTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$4.state());
    }

    public class BrokerLifecycleManagerTestContext {
        private final KafkaConfig config;
        private final MockTime time;
        private final AtomicLong highestMetadataOffset;
        private final Metadata metadata;
        private final MockClient mockClient;
        private final SimpleControllerNodeProvider controllerNodeProvider;
        private final NodeApiVersions nodeApiVersions;
        private final MockBrokerToControllerChannelManager mockChannelManager;
        private final String clusterId;
        private final BrokerRegistrationRequestData.ListenerCollection advertisedListeners;

        public KafkaConfig config() {
            return this.config;
        }

        public MockTime time() {
            return this.time;
        }

        public AtomicLong highestMetadataOffset() {
            return this.highestMetadataOffset;
        }

        public Metadata metadata() {
            return this.metadata;
        }

        public MockClient mockClient() {
            return this.mockClient;
        }

        public SimpleControllerNodeProvider controllerNodeProvider() {
            return this.controllerNodeProvider;
        }

        public NodeApiVersions nodeApiVersions() {
            return this.nodeApiVersions;
        }

        public MockBrokerToControllerChannelManager mockChannelManager() {
            return this.mockChannelManager;
        }

        public String clusterId() {
            return this.clusterId;
        }

        public BrokerRegistrationRequestData.ListenerCollection advertisedListeners() {
            return this.advertisedListeners;
        }

        public void poll() {
            this.mockClient().wakeup();
            this.mockChannelManager().poll();
        }

        public /* synthetic */ BrokerLifecycleManagerTest kafka$server$BrokerLifecycleManagerTest$BrokerLifecycleManagerTestContext$$$outer() {
            return BrokerLifecycleManagerTest.this;
        }

        public static final /* synthetic */ boolean $anonfun$new$1(BrokerLifecycleManagerTestContext $this, EndPoint ep) {
            return $this.advertisedListeners().add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Listener().setHost(ep.host()).setName(ep.listenerName().value()).setPort((int)((short)ep.port())).setSecurityProtocol(ep.securityProtocol().id));
        }

        public BrokerLifecycleManagerTestContext(Properties properties) {
            if (BrokerLifecycleManagerTest.this == null) {
                throw null;
            }
            this.config = new KafkaConfig((Map)properties);
            this.time = new MockTime(1L, 1L);
            this.highestMetadataOffset = new AtomicLong(0L);
            this.metadata = new Metadata(1000L, 1000L, new LogContext(), new ClusterResourceListeners());
            this.mockClient = new MockClient((Time)this.time(), this.metadata());
            this.controllerNodeProvider = new SimpleControllerNodeProvider();
            this.nodeApiVersions = new NodeApiVersions((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiKeys[]{ApiKeys.BROKER_REGISTRATION, ApiKeys.BROKER_HEARTBEAT})).map((Function1 & Serializable)apiKey -> new ApiVersionsResponseData.ApiVersion().setApiKey(apiKey.id).setMinVersion(apiKey.oldestVersion()).setMaxVersion(apiKey.latestVersion()))).toList()).asJava());
            this.mockChannelManager = new MockBrokerToControllerChannelManager(this.mockClient(), this.time(), this.controllerNodeProvider(), this.nodeApiVersions(), 60000, 30000);
            this.clusterId = "x4AJGXQSRnephtTZzujw4w";
            this.advertisedListeners = new BrokerRegistrationRequestData.ListenerCollection();
            this.config().advertisedListeners().foreach((Function1 & Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)BrokerLifecycleManagerTestContext.$anonfun$new$1(this, ep)));
        }
    }

    public class SimpleControllerNodeProvider
    implements ControllerNodeProvider {
        private final AtomicReference<Node> node;

        public AtomicReference<Node> node() {
            return this.node;
        }

        public Option<Node> get() {
            return Option$.MODULE$.apply((Object)this.node().get());
        }

        public ListenerName listenerName() {
            return new ListenerName("PLAINTEXT");
        }

        public SecurityProtocol securityProtocol() {
            return SecurityProtocol.PLAINTEXT;
        }

        public String saslMechanism() {
            return "GSSAPI";
        }

        public /* synthetic */ BrokerLifecycleManagerTest kafka$server$BrokerLifecycleManagerTest$SimpleControllerNodeProvider$$$outer() {
            return BrokerLifecycleManagerTest.this;
        }

        public SimpleControllerNodeProvider() {
            if (BrokerLifecycleManagerTest.this == null) {
                throw null;
            }
            this.node = new AtomicReference<Object>(null);
        }
    }
}

