/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.CheckpointFile;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u2A\u0001C\u0005\u0001!!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)1\u0007\u0001C\u0001E!)Q\u0007\u0001C\u0001E!)q\u0007\u0001C\u0001E!)\u0011\b\u0001C\u0001E!)1\b\u0001C\u0001E\tArJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$Vm\u001d;\u000b\u0005)Y\u0011aC2iK\u000e\\\u0007o\\5oiNT!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u001b\u0005)Q\u000f^5mg&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011\"\u0001\u0014tQ>,H\u000e\u001a)feNL7\u000f^!oI>3XM]<sSR,\u0017I\u001c3SK2|\u0017\r\u001a$jY\u0016$\u0012a\t\t\u0003%\u0011J!!J\n\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u001d\u0002\"\u0001K\u0019\u000e\u0003%R!AK\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002-[\u00059!.\u001e9ji\u0016\u0014(B\u0001\u00180\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0014aA8sO&\u0011!'\u000b\u0002\u0005)\u0016\u001cH/A\rtQ>,H\u000e\u001a%b]\u0012dW-T;mi&\u0004H.\u001a'j]\u0016\u001c\bFA\u0002(\u0003\u0001\u001a\bn\\;mIJ+G/\u001e:o\u000b6\u0004H/_'ba\u001a{'/R7qif4\u0015\u000e\\3)\u0005\u00119\u0013aI:i_VdG\r\u00165s_^LeMV3sg&|g.S:O_R\u0014VmY8h]&\u001cX\r\u001a\u0015\u0003\u000b\u001d\n\u0001\u0004^3ti2\u000b'0_(gMN,Go\u00115fG.\u0004x.\u001b8uQ\t1q%A\u0015uKN$H*\u0019>z\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3J]Z\fG.\u001b3M_\u001e$\u0015N\u001d\u0015\u0003\u000f\u001d\u0002")
public class OffsetCheckpointFileTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile(), null);
        Map offsets = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 2)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assertions.assertEquals((Object)offsets, (Object)checkpoint.read());
        Map offsets2 = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)15L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 3)), (Object)BoxesRunTime.boxToLong((long)20L))}));
        checkpoint.write(offsets2);
        Assertions.assertEquals((Object)offsets2, (Object)checkpoint.read());
    }

    @Test
    public void shouldHandleMultipleLines() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile(), null);
        Map offsets = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 6)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 7)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 8)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 9)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 10)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assertions.assertEquals((Object)offsets, (Object)checkpoint.read());
    }

    @Test
    public void shouldReturnEmptyMapForEmptyFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile(), null);
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
        checkpoint.write((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
    }

    @Test
    public void shouldThrowIfVersionIsNotRecognised() {
        File file;
        File file2 = file = TestUtils.tempFile();
        file = null;
        File file3 = file2;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        CheckpointFile checkpointFile = new CheckpointFile(file3, OffsetCheckpointFile$.MODULE$.CurrentVersion() + 1, (CheckpointFileFormatter)OffsetCheckpointFile.Formatter$.MODULE$, logDirFailureChannel, file3.getParent());
        checkpointFile.write((Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)10L))})));
        Assertions.assertThrows(KafkaStorageException.class, () -> new OffsetCheckpointFile(checkpointFile.file(), logDirFailureChannel).read());
    }

    @Test
    public void testLazyOffsetCheckpoint() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir), (Object)mockCheckpointFile)})));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.never())).read();
        TopicPartition partition0 = new TopicPartition("foo", 0);
        TopicPartition partition1 = new TopicPartition("foo", 1);
        TopicPartition partition2 = new TopicPartition("foo", 2);
        Mockito.when((Object)mockCheckpointFile.read()).thenReturn(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)BoxesRunTime.boxToLong((long)1000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)BoxesRunTime.boxToLong((long)2000L))})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)1000L)), (Object)lazyCheckpoints.fetch(logDir, partition0));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2000L)), (Object)lazyCheckpoints.fetch(logDir, partition1));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lazyCheckpoints.fetch(logDir, partition2));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.times((int)1))).read();
    }

    @Test
    public void testLazyOffsetCheckpointFileInvalidLogDir() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir), (Object)mockCheckpointFile)})));
        Assertions.assertThrows(IllegalArgumentException.class, () -> lazyCheckpoints.fetch("/invalid/kafka-logs", new TopicPartition("foo", 0)));
    }
}

