/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.BaseAdminIntegrationTest;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.authorizer.AclEntry$;
import kafka.server.Defaults$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.EligibleLeadersNotAvailableException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\rEb\u0001B(Q\u0001UCQA\u0017\u0001\u0005\u0002mCq!\u0018\u0001C\u0002\u0013\u0005a\f\u0003\u0004h\u0001\u0001\u0006Ia\u0018\u0005\bQ\u0002\u0011\r\u0011\"\u0001j\u0011\u0019\u0001\b\u0001)A\u0005U\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\bB\u0002@\u0001A\u0003%1\u000f\u0003\u0006\u0000\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003A1\"a\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0012!Y\u0011Q\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0002\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u0012\u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!!\u0019\u0001\t\u0003\nY\u0005C\u0004\u0002l\u0001!\t!a\u0013\t\u000f\u0005U\u0004\u0001\"\u0001\u0002L!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005-\u0003bBA?\u0001\u0011\u0005\u00111\n\u0005\b\u0003\u0003\u0003A\u0011AA&\u0011\u001d\t)\t\u0001C\u0001\u0003\u0017Bq!!#\u0001\t\u0003\tY\u0005C\u0004\u0002\u000e\u0002!\t!a\u0013\t\u000f\u0005E\u0005\u0001\"\u0001\u0002L!9\u0011Q\u0013\u0001\u0005\u0002\u0005-\u0003bBAM\u0001\u0011\u0005\u00111\n\u0005\b\u0003;\u0003A\u0011AA&\u0011\u001d\t\t\u000b\u0001C\u0001\u0003\u0017Bq!!*\u0001\t\u0003\tY\u0005C\u0004\u0002*\u0002!\t!a\u0013\t\u000f\u00055\u0006\u0001\"\u0001\u0002L!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005-\u0003bBA[\u0001\u0011\u0005\u00111\n\u0005\b\u0003s\u0003A\u0011AA&\u0011\u001d\ti\f\u0001C\u0001\u0003\u0017Bq!!1\u0001\t\u0003\tY\u0005C\u0004\u0002F\u0002!\t!a\u0013\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"9\u0011Q\u001e\u0001\u0005\n\u0005=\bb\u0002B\u0003\u0001\u0011\u0005\u00111\n\u0005\b\u0005\u0013\u0001A\u0011AA&\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003\u0017BqA!\u0005\u0001\t\u0003\tY\u0005C\u0004\u0003\u0016\u0001!\t!a\u0013\t\u000f\te\u0001\u0001\"\u0001\u0002L!9!Q\u0004\u0001\u0005\u0002\u0005-\u0003b\u0002B\u0011\u0001\u0011\u0005\u00111\n\u0005\b\u0005K\u0001A\u0011AA&\u0011\u001d\u0011I\u0003\u0001C\u0001\u0003\u0017BqA!\f\u0001\t\u0003\tY\u0005C\u0004\u00032\u0001!\t!a\u0013\t\u000f\tU\u0002\u0001\"\u0001\u0002L!9!\u0011\b\u0001\u0005\u0002\u0005-\u0003b\u0002B\u001f\u0001\u0011\u0005\u00111\n\u0005\b\u0005\u0003\u0002A\u0011AA&\u0011\u001d\u0011)\u0005\u0001C\u0001\u0003\u0017BqA!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0003N\u0001!\t!a\u0013\t\u000f\tE\u0003\u0001\"\u0001\u0002L!9!Q\u000b\u0001\u0005\u0002\u0005-\u0003b\u0002B-\u0001\u0011\u0005\u00111\n\u0005\b\u0005;\u0002A\u0011AA&\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0003\u0017BqA!\u001a\u0001\t\u0003\tY\u0005C\u0004\u0003j\u0001!\t!a\u0013\t\u000f\t5\u0004\u0001\"\u0001\u0002L!9!\u0011\u0010\u0001\u0005\u0002\u0005-\u0003b\u0002B@\u0001\u0011\u0005\u00111\n\u0005\b\u0005\u000b\u0003A\u0011AA&\u0011\u001d\u0011Y\t\u0001C\u0001\u0003\u0017BqA!%\u0001\t\u0003\u0011\u0019\nC\u0005\u0003<\u0002\t\n\u0011\"\u0001\u0003>\"9!1\u001b\u0001\u0005\u0002\tU\u0007b\u0002Bo\u0001\u0011%\u00111J\u0004\b\u0005?\u0004\u0006\u0012\u0001Bq\r\u0019y\u0005\u000b#\u0001\u0003d\"1!l\u0013C\u0001\u0005WDqA!<L\t\u0003\u0011y\u000fC\u0004\u0004\u0004-#\ta!\u0002\u0003;Ac\u0017-\u001b8uKb$\u0018\tZ7j]&sG/Z4sCRLwN\u001c+fgRT!!\u0015*\u0002\u0007\u0005\u0004\u0018NC\u0001T\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001,\u0011\u0005]CV\"\u0001)\n\u0005e\u0003&\u0001\u0007\"bg\u0016\fE-\\5o\u0013:$Xm\u001a:bi&|g\u000eV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u0018\t\u0003/\u0002\tQ\u0001^8qS\u000e,\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fA\u0001\\1oO*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T\u0011!\\\u0001\u0006g\u000e\fG.Y\u0005\u0003_2\u00141!\u00138u\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005\u0019\bC\u0001;}\u001b\u0005)(B\u0001<x\u0003\u0019\u0019w.\\7p]*\u00111\u000b\u001f\u0006\u0003sj\fa!\u00199bG\",'\"A>\u0002\u0007=\u0014x-\u0003\u0002~k\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u00025\t\u0014xn[3s\u0019><w-\u001a:D_:4\u0017n\u001a*fg>,(oY3\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%Q/\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003\u001b\t9A\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u0002=\t\u0014xn[3s\u0019><w-\u001a:D_:4\u0017n\u001a*fg>,(oY3`I\u0015\fH\u0003BA\n\u00033\u00012a[A\u000b\u0013\r\t9\u0002\u001c\u0002\u0005+:LG\u000fC\u0005\u0002\u001c%\t\t\u00111\u0001\u0002\u0004\u0005\u0019\u0001\u0010J\u0019\u00027\t\u0014xn[3s\u0019><w-\u001a:D_:4\u0017n\u001a*fg>,(oY3!\u0003Q\u0019\u0007.\u00198hK\u0012\u0014%o\\6fe2{wmZ3sgV\u0011\u00111\u0005\t\u0007\u0003K\ty#a\r\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tq!\\;uC\ndWMC\u0002\u0002.1\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t$a\n\u0003\u0007M+G\u000f\u0005\u0003\u00026\u0005\rc\u0002BA\u001c\u0003\u007f\u00012!!\u000fm\u001b\t\tYDC\u0002\u0002>Q\u000ba\u0001\u0010:p_Rt\u0014bAA!Y\u00061\u0001K]3eK\u001aL1AZA#\u0015\r\t\t\u0005\\\u0001\u0016G\"\fgnZ3e\u0005J|7.\u001a:M_\u001e<WM]:!\u0003\u0015\u0019X\r^+q)\t\t\u0019\u0002K\u0002\u000e\u0003\u001f\u0002B!!\u0015\u0002^5\u0011\u00111\u000b\u0006\u0004#\u0006U#\u0002BA,\u00033\nqA[;qSR,'OC\u0002\u0002\\i\fQA[;oSRLA!a\u0018\u0002T\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3ADA3!\u0011\t\t&a\u001a\n\t\u0005%\u00141\u000b\u0002\n\u0003\u001a$XM]#bG\"\f\u0011\u0002^3ti\u000ecwn]3)\u0007=\ty\u0007\u0005\u0003\u0002R\u0005E\u0014\u0002BA:\u0003'\u0012A\u0001V3ti\u0006iA/Z:u\u0019&\u001cHOT8eKND3\u0001EA8\u0003)\"Xm\u001d;BI6Lgn\u00117jK:$\b*\u00198eY&twMQ1e\u0013B;\u0016\u000e\u001e5pkR$\u0016.\\3pkRD3!EA8\u0003E\"Xm\u001d;De\u0016\fG/Z#ySN$\u0018N\\4U_BL7m\u001d+ie><Hk\u001c9jG\u0016C\u0018n\u001d;t\u000bb\u001cW\r\u001d;j_:D3AEA8\u0003]!Xm\u001d;EK2,G/\u001a+pa&\u001c7oV5uQ&#7\u000fK\u0002\u0014\u0003_\n1\u0003^3ti6+G/\u00193bi\u0006\u0014VM\u001a:fg\"D3\u0001FA8\u0003q!Xm\u001d;EKN\u001c'/\u001b2f\u001d>tW\t_5ti&tw\rV8qS\u000eD3!FA8\u0003M!Xm\u001d;EKN\u001c'/\u001b2f\u00072,8\u000f^3sQ\r1\u0012qN\u0001\u0014i\u0016\u001cH\u000fR3tGJL'-\u001a'pO\u0012K'o\u001d\u0015\u0004/\u0005=\u0014A\u0007;fgR$Um]2sS\n,'+\u001a9mS\u000e\fGj\\4ESJ\u001c\bf\u0001\r\u0002p\u00059B/Z:u\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d\u0015\u00043\u0005=\u0014a\u0007;fgR$Um]2sS\n,\u0017I\u001c3BYR,'oQ8oM&<7\u000fK\u0002\u001b\u0003_\nA\u0003^3ti\u000e\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001c\bfA\u000e\u0002p\u0005QB/Z:u'\u0016,7.\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u001aA$a\u001c\u00029Q,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oi\"\u001aQ$a\u001c\u0002IQ,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND3AHA8\u0003]\"Xm\u001d;SKBd\u0017nY1DC:4U\r^2i\rJ|W\u000eT8h'R\f'\u000f^(gMN,G/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u001aq$a\u001c\u0002EQ,7\u000f^!mi\u0016\u0014Hj\\4ESJ\u001c\u0018I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3tQ\r\u0001\u0013qN\u0001&i\u0016\u001cHo\u00144gg\u0016$8OR8s)&lWm]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND3!IA8\u0003u!Xm\u001d;D_:\u001cX/\\3BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bf\u0001\u0012\u0002p\u0005qB/Z:u\t\u0016dW\r^3SK\u000e|'\u000fZ:XSRDW\t_2faRLwN\u001c\u0015\u0004G\u0005=\u0014a\u0007;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001chi\u001c:U_BL7\rK\u0002%\u0003_\nQd];cg\u000e\u0014\u0018NY3B]\u0012<\u0016-\u001b;G_J\f5o]5h]6,g\u000e\u001e\u000b\u0007\u0003'\ti-a4\t\ru+\u0003\u0019AA\u001a\u0011\u001d\t\t.\na\u0001\u0003'\f\u0001bY8ogVlWM\u001d\t\t\u0003+\fi.!9\u0002b6\u0011\u0011q\u001b\u0006\u0005\u0003#\fINC\u0002\u0002\\^\fqa\u00197jK:$8/\u0003\u0003\u0002`\u0006]'!D&bM.\f7i\u001c8tk6,'\u000fE\u0003l\u0003G\f9/C\u0002\u0002f2\u0014Q!\u0011:sCf\u00042a[Au\u0013\r\tY\u000f\u001c\u0002\u0005\u0005f$X-A\u0006tK:$'+Z2pe\u0012\u001cH\u0003CA\n\u0003c\fyPa\u0001\t\u000f\u0005Mh\u00051\u0001\u0002v\u0006A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u0002x\u0006m\u0018\u0011]Aq\u001b\t\tIP\u0003\u0003\u0002t\u0006e\u0017\u0002BA\u007f\u0003s\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bB\u0002B\u0001M\u0001\u0007!.\u0001\u0006ok6\u0014VmY8sINDQ!\u001d\u0014A\u0002M\fq\u0003^3ti&sg/\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:)\u0007\u001d\ny'A\tuKN$\u0018i\u00197Pa\u0016\u0014\u0018\r^5p]ND3\u0001KA8\u0003A!Xm\u001d;EK2\f\u00170\u001a3DY>\u001cX\rK\u0002*\u0003_\na\u0002^3ti\u001a{'oY3DY>\u001cX\rK\u0002+\u0003_\n!\u0004^3ti6Kg.[7v[J+\u0017/^3tiRKW.Z8viND3aKA8\u0003a!Xm\u001d;DC2d\u0017J\u001c$mS\u001eDG\u000fV5nK>,Ho\u001d\u0015\u0004Y\u0005=\u0014A\u0005;fgR\u001cuN\\:v[\u0016\u0014xI]8vaND3!LA8\u0003y!Xm\u001d;EK2,G/Z\"p]N,X.\u001a:He>,\bo\u00144gg\u0016$8\u000fK\u0002/\u0003_\n\u0011\u0004^3ti\u0016cWm\u0019;Qe\u00164WM\u001d:fI2+\u0017\rZ3sg\"\u001aq&a\u001c\u0002MQ,7\u000f^#mK\u000e$XK\\2mK\u0006tG*Z1eKJ\u001chi\u001c:P]\u0016\u0004\u0016M\u001d;ji&|g\u000eK\u00021\u0003_\n\u0001\u0006^3ti\u0016cWm\u0019;V]\u000edW-\u00198MK\u0006$WM]:G_Jl\u0015M\\=QCJ$\u0018\u000e^5p]ND3!MA8\u0003\u001d\"Xm\u001d;FY\u0016\u001cG/\u00168dY\u0016\fg\u000eT3bI\u0016\u00148OR8s\u00032d\u0007+\u0019:uSRLwN\\:)\u0007I\ny'A\u0016uKN$X\t\\3diVs7\r\\3b]2+\u0017\rZ3sg\u001a{'/\u00168l]><h\u000eU1si&$\u0018n\u001c8tQ\r\u0019\u0014qN\u0001)i\u0016\u001cH/\u00127fGR,fn\u00197fC:dU-\u00193feN<\u0006.\u001a8O_2Kg/\u001a\"s_.,'o\u001d\u0015\u0004i\u0005=\u0014a\u0007;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\u001d>|\u0007\u000fK\u00026\u0003_\na\u0004^3ti\u0016cWm\u0019;V]\u000edW-\u00198MK\u0006$WM]:B]\u0012tun\u001c9)\u0007Y\ny'\u0001\u001duKN$H*[:u%\u0016\f7o]5h]6,g\u000e^:E_\u0016\u001chj\u001c;TQ><hj\u001c8SK\u0006\u001c8/[4oS:<\u0007+\u0019:uSRLwN\\:)\u0007]\ny'A\u0019uKN$H*[:u%\u0016\f7o]5h]6,g\u000e^:E_\u0016\u001chj\u001c;TQ><H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:)\u0007a\ny'\u0001\u0011uKN$h+\u00197jI&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c\bfA\u001d\u0002p\u0005!D/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON$U\r\\3uK\u0006sGmU3u\u0005J|7.\u001a:D_:4\u0017nZ:)\u0007i\ny'\u0001\u0018uKN$\u0018J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d#fY\u0016$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\bfA\u001e\u0002p\u0005\u0011C/Z:u\u0013:4\u0018\r\\5e\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jOND3\u0001PA8\u0003\u0019\"Xm\u001d;J]Z\fG.\u001b3BYR,'\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGo\u001d\u0015\u0004{\u0005=\u0014A\u0005;fgRduN\\4U_BL7MT1nKND3APA8\u0003=!Xm\u001d;Ok2d7i\u001c8gS\u001e\u001c\bfA \u0002p\u0005!C/Z:u\t\u0016\u001c8M]5cK\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7\u000fK\u0002A\u0003_\nA\u0006^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001chi\u001c:M_\u001e$$\u000eT8h\u0019\u00164X\r\\:)\u0007\u0005\u0013\t\b\u0005\u0003\u0002R\tM\u0014\u0002\u0002B;\u0003'\u0012\u0001\u0002R5tC\ndW\r\u001a\u0015\u0004\u0003\u0006=\u0014a\u0012;fgRLen\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7OR8s\u0019><GG\u001b'pO2+g/\u001a7t\u0007\u0006t'+Z:fi2{wmZ3s)>\u001cUO\u001d:f]R\u0014vn\u001c;)\u0007\t\u0013\t\bK\u0002C\u0003_\n\u0011\t^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001chi\u001c:M_\u001e$$\u000eT8h\u0019\u00164X\r\\:DC:tw\u000e\u001e*fg\u0016$(k\\8u\u0019><w-\u001a:)\u0007\r\u0013\t\bK\u0002D\u0003_\n\u0011\n^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001chi\u001c:M_\u001e$$\u000eT8h\u0019\u00164X\r\\:E_\u0016\u001chj\u001c;X_J\\w+\u001b;i\u0013:4\u0018\r\\5e\u0007>tg-[4tQ\r!%\u0011\u000f\u0015\u0004\t\u0006=\u0014\u0001\f;fgR\fE\u000e^3s\u0007>tg-[4t\r>\u0014Hj\\45U2{w\rT3wK2\u001cHi\\3t\u001d>$xk\u001c:lQ\r)%\u0011\u000f\u0015\u0004\u000b\u0006=\u0014AE1mi\u0016\u0014(I]8lKJdunZ4feN$b!a\u0005\u0003\u0016\nE\u0006b\u0002BL\r\u0002\u0007!\u0011T\u0001\bK:$(/[3t!\u0019\u0011YJ!)\u0003&6\u0011!Q\u0014\u0006\u0004\u0005?\u001b\u0017\u0001B;uS2LAAa)\u0003\u001e\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\t\u001d&QV\u0007\u0003\u0005SSAAa+\u0002Z\u0006)\u0011\rZ7j]&!!q\u0016BU\u00055\tE\u000e^3s\u0007>tg-[4Pa\"I!1\u0017$\u0011\u0002\u0003\u0007!QW\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\t\u0004W\n]\u0016b\u0001B]Y\n9!i\\8mK\u0006t\u0017\u0001H1mi\u0016\u0014(I]8lKJdunZ4feN$C-\u001a4bk2$HEM\u000b\u0003\u0005\u007fSCA!.\u0003B.\u0012!1\u0019\t\u0005\u0005\u000b\u0014y-\u0004\u0002\u0003H*!!\u0011\u001aBf\u0003%)hn\u00195fG.,GMC\u0002\u0003N2\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tNa2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000beKN\u001c'/\u001b2f\u0005J|7.\u001a:M_\u001e<WM]:\u0015\u0005\t]\u0007\u0003\u0002BT\u00053LAAa7\u0003*\n11i\u001c8gS\u001e\fQ\u0003^3be\u0012|wO\u001c\"s_.,'\u000fT8hO\u0016\u00148/A\u000fQY\u0006Lg\u000e^3yi\u0006#W.\u001b8J]R,wM]1uS>tG+Z:u!\t96jE\u0002L\u0005K\u00042a\u001bBt\u0013\r\u0011I\u000f\u001c\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0005\u0018AF2iK\u000e\\g+\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:\u0015\u0011\u0005M!\u0011\u001fB~\u0005\u007fDqAa=N\u0001\u0004\u0011)0\u0001\u0004dY&,g\u000e\u001e\t\u0005\u0005O\u001390\u0003\u0003\u0003z\n%&!B!e[&t\u0007b\u0002B\u007f\u001b\u0002\u0007\u00111A\u0001\u000fi>\u0004\u0018n\u0019*fg>,(oY32\u0011\u001d\u0019\t!\u0014a\u0001\u0003\u0007\ta\u0002^8qS\u000e\u0014Vm]8ve\u000e,''\u0001\rdQ\u0016\u001c7.\u00138wC2LG-\u00117uKJ\u001cuN\u001c4jON$\u0002\"a\u0005\u0004\b\r]1q\u0006\u0005\b\u0007\u0013q\u0005\u0019AB\u0006\u0003!Q8n\u00117jK:$\b\u0003BB\u0007\u0007'i!aa\u0004\u000b\u0007\rE!+\u0001\u0002{W&!1QCB\b\u00055Y\u0015MZ6b5.\u001cE.[3oi\"91\u0011\u0004(A\u0002\rm\u0011aB:feZ,'o\u001d\t\u0007\u0007;\u0019yba\t\u000e\u0005\u0005-\u0012\u0002BB\u0011\u0003W\u00111aU3r!\u0011\u0019)ca\u000b\u000e\u0005\r\u001d\"bAB\u0015%\u000611/\u001a:wKJLAa!\f\u0004(\tY1*\u00194lCN+'O^3s\u0011\u001d\u0011\u0019P\u0014a\u0001\u0005k\u0004")
public class PlaintextAdminIntegrationTest
extends BaseAdminIntegrationTest {
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private ConfigResource brokerLoggerConfigResource;
    private final Set<String> changedBrokerLoggers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);

    public static void checkInvalidAlterConfigs(KafkaZkClient zkClient, scala.collection.Seq<KafkaServer> servers, Admin client) {
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(zkClient, servers, client);
    }

    public static void checkValidAlterConfigs(Admin client, ConfigResource topicResource1, ConfigResource topicResource2) {
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(client, topicResource1, topicResource2);
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ConfigResource brokerLoggerConfigResource() {
        return this.brokerLoggerConfigResource;
    }

    private void brokerLoggerConfigResource_$eq(ConfigResource x$1) {
        this.brokerLoggerConfigResource = x$1;
    }

    private Set<String> changedBrokerLoggers() {
        return this.changedBrokerLoggers;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.brokerLoggerConfigResource_$eq(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, Integer.toString(((KafkaServer)this.servers().head()).config().brokerId())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.teardownBrokerLoggers();
        super.tearDown();
    }

    @Test
    public void testClose() {
        Admin client = Admin.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        List nodeStrs;
        this.client_$eq(Admin.create(this.createConfig()));
        List brokerStrs = (List)Predef$.MODULE$.wrapRefArray((Object[])this.brokerList().split(",")).toList().sorted((Ordering)Ordering.String$.MODULE$);
        while ((nodeStrs = (List)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().describeCluster().nodes().get()).asScala().map((Function1 & Serializable)node -> new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assertions.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testAdminClientHandlingBadIPWithoutTimeout() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("socket.connection.setup.timeout.ms", "1000");
        HostResolver returnBadAddressFirst = new HostResolver(null){

            public InetAddress[] resolve(String host) {
                return new InetAddress[]{InetAddress.getByName("10.200.20.100"), InetAddress.getByName(host)};
            }
        };
        this.client_$eq(AdminClientTestUtils.create(config, (HostResolver)returnBadAddressFirst));
        this.client().describeCluster().nodes().get();
    }

    @Test
    public void testCreateExistingTopicsThrowTopicExistsException() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "mytopic";
        .colon.colon topics = new .colon.colon((Object)topic, (List)Nil$.MODULE$);
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic, 1, (short)1), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)topics, (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        .colon.colon newTopicsWithInvalidRF = new .colon.colon((Object)new NewTopic(topic, 1, (short)(this.servers().size() + 1)), (List)Nil$.MODULE$);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> PlaintextAdminIntegrationTest.$anonfun$testCreateExistingTopicsThrowTopicExistsException$1(this, (scala.collection.Seq)newTopicsWithInvalidRF))).getCause() instanceof TopicExistsException));
    }

    @Test
    public void testDeleteTopicsWithIds() {
        this.client_$eq(Admin.create(this.createConfig()));
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)new .colon.colon((Object)"mytopic3", (List)Nil$.MODULE$)));
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$))).asJava())}))).asJava()), (List)new .colon.colon((Object)new NewTopic("mytopic2", 3, (short)3), (List)new .colon.colon((Object)new NewTopic("mytopic3", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty()))), (List)Nil$.MODULE$)));
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)topics, (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        scala.collection.immutable.Set topicIds = this.getTopicIds().values().toSet();
        this.client().deleteTopics((TopicCollection)TopicCollection.ofTopicIds((Collection)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)topicIds).asJava())).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)), (scala.collection.Seq<String>)topics);
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(Admin.create(this.createConfig()));
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)Nil$.MODULE$);
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", 3, (short)3), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)topics, (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testMetadataRefresh$1(this, x$2))).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)topics).asJava()).all().get();
        Assertions.assertEquals((Object)topics.toSet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(topicDesc.keySet()).asScala());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(Admin.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$).map((Function1 & Serializable)x$3 -> new NewTopic(x$3, 1, (short)1))).asJava()).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$), (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)nonExistingTopic, (List)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$))).asJava()).values();
        Assertions.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)results.get(nonExistingTopic)).get()).getCause() instanceof UnknownTopicOrPartitionException;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(Admin.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Collection nodes = (Collection)result.nodes().get();
        String clusterId = (String)result.clusterId().get();
        Assertions.assertEquals((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().clusterId(), (Object)clusterId);
        Node controller = (Node)result.controller().get();
        Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), (int)controller.id());
        Object[] brokers = this.brokerList().split(",");
        Assertions.assertEquals((int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(brokers)), (int)nodes.size());
        CollectionConverters$.MODULE$.CollectionHasAsScala(nodes).asScala().foreach(arg_0 -> PlaintextAdminIntegrationTest.$anonfun$testDescribeCluster$2$adapted((String[])brokers, arg_0));
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map partitionsByBroker = (scala.collection.immutable.Map)this.createTopic(topic, 10, this.createTopic$default$3(), this.createTopic$default$4()).groupBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$1))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int k = x0$2._1$mcI$sp();
            scala.collection.immutable.Map v = (scala.collection.immutable.Map)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.keys().toSeq());
            return tuple2;
        });
        IndexedSeq brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)brokers).asJava()).allDescriptions().get();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$4))).get();
            Seq expectedPartitions = (Seq)partitionsByBroker.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
            java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker.get(BoxesRunTime.boxToInteger((int)brokerId));
            scala.collection.mutable.Map replicaInfos = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(logDirInfos).asScala().flatMap((Function1 & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                LogDirDescription logDirInfo = (LogDirDescription)x0$3._2();
                scala.collection.mutable.Map map = CollectionConverters$.MODULE$.MapHasAsScala(logDirInfo.replicaInfos()).asScala();
                return map;
            }).filter((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$7(topic, x0$4)));
            Assertions.assertEquals((Object)expectedPartitions.toSet(), (Object)((IterableOnceOps)replicaInfos.keys().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.partition()))).toSet());
            logDirInfos.forEach((logDir, logDirInfo) -> CollectionConverters$.MODULE$.MapHasAsScala(logDirInfo.replicaInfos()).asScala().keys().foreach((Function1 & Serializable)tp -> {
                PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$10(server, logDir, tp);
                return BoxedUnit.UNIT;
            }));
        });
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        Seq replicas = ((IterableOnceOps)this.createTopic(topic, 10, this.createTopic$default$3(), this.createTopic$default$4()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            int brokerId = x0$1._2$mcI$sp();
            TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(topic, partition, brokerId);
            return topicPartitionReplica;
        })).toSeq();
        ((java.util.Map)this.client().describeReplicaLogDirs(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)replicas).asJavaCollection()).all().get()).forEach((topicPartitionReplica, replicaDirInfo) -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$6))).get();
            TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
            LogManager qual$1 = server.logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Assertions.assertEquals((Object)((Log)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
        });
    }

    @Test
    public void testAlterReplicaLogDirs() {
        String string;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((IterableOnceOps)this.servers().map((Function1 & Serializable)server -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(server), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map firstReplicaAssignment = ((IterableOnceOps)this.servers().map((Function1 & Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map secondReplicaAssignment = ((IterableOnceOps)this.servers().map((Function1 & Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CollectionConverters$.MODULE$.MapHasAsScala(this.client().alterReplicaLogDirs(CollectionConverters$.MODULE$.MapHasAsJava((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala().values().foreach((Function1 & Serializable)future -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$4(future);
            return BoxedUnit.UNIT;
        });
        int x$2 = this.brokerCount();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(topic, x$3, x$2, x$4);
        this.servers().foreach((Function1 & Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$6(tp, firstReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        this.client().alterReplicaLogDirs(CollectionConverters$.MODULE$.MapHasAsJava((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1 & Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$7(tp, secondReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        scala.concurrent.Future producerFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            int n;
            ByteArraySerializer byteArraySerializer;
            ByteArraySerializer byteArraySerializer2;
            None$ none$;
            String string;
            String x$9 = TestUtils$.MODULE$.getBrokerListStrFromServers((scala.collection.Seq<KafkaServer>)this.servers(), this.securityProtocol());
            SecurityProtocol x$10 = this.securityProtocol();
            Option<File> x$11 = this.trustStoreFile();
            long l = 60000L;
            long l2 = 0x100000L;
            int n2 = 30000;
            int n3 = 0;
            int n4 = 16384;
            String string2 = string = "none";
            string = null;
            String x$20 = string2;
            None$ none$2 = none$ = None$.MODULE$;
            none$ = null;
            None$ x$21 = none$2;
            ByteArraySerializer byteArraySerializer3 = byteArraySerializer2 = new ByteArraySerializer();
            byteArraySerializer2 = null;
            ByteArraySerializer x$22 = byteArraySerializer3;
            ByteArraySerializer byteArraySerializer4 = byteArraySerializer = new ByteArraySerializer();
            byteArraySerializer = null;
            ByteArraySerializer x$23 = byteArraySerializer4;
            boolean bl = false;
            try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$9, -1, l, l2, 0, n2, n3, n4, x$20, 10000, x$10, x$11, (Option<Properties>)x$21, x$22, x$23, bl);){
                while (running.get()) {
                    Future future = producer.send(new ProducerRecord(topic, (Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(numMessages).toString().getBytes()));
                    numMessages.incrementAndGet();
                    future.get(10L, TimeUnit.SECONDS);
                }
                n = numMessages.get();
            }
            return n;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$11(numMessages)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$12(numMessages, producerFuture));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            this.client().alterReplicaLogDirs(CollectionConverters$.MODULE$.MapHasAsJava((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1 & Serializable)server -> {
                PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$13(tp, firstReplicaAssignment, topic, producerFuture, server);
                return BoxedUnit.UNIT;
            });
            int currentMessagesNum = numMessages.get();
            long l3 = 15000L;
            long l4 = 100L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$16(numMessages, currentMessagesNum)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$17(numMessages, currentMessagesNum, producerFuture));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
        }
        finally {
            running.set(false);
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$27 = this.servers();
        SecurityProtocol x$30 = this.securityProtocol();
        Option<File> x$31 = this.trustStoreFile();
        String string2 = string = "group";
        string = null;
        String x$32 = string2;
        long l = 15000L;
        ((IterableOnceOps)TestUtils$.MODULE$.consumeTopicRecords((scala.collection.Seq<KafkaServer>)x$27, topic, finalNumMessages, x$32, x$30, x$31, l).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$18(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().apply(1)).config().brokerId()));
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().apply(2)).config().brokerId()));
        .colon.colon configResources = new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource1, (List)new .colon.colon((Object)brokerResource2, (List)Nil$.MODULE$))));
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)configResources).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assertions.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assertions.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assertions.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assertions.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assertions.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MessageMaxBytes()), (Object)maxMessageBytes2.value());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assertions.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assertions.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assertions.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assertions.assertEquals((int)((KafkaServer)this.servers().apply(1)).config().nonInternalValues().size(), (int)((Config)configs.get(brokerResource1)).entries().size());
        Assertions.assertEquals((Object)Integer.toString(((KafkaServer)this.servers().apply(1)).config().brokerId()), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assertions.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assertions.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assertions.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assertions.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assertions.assertNull((Object)truststorePassword.value());
        Assertions.assertFalse((boolean)truststorePassword.isDefault());
        Assertions.assertTrue((boolean)truststorePassword.isSensitive());
        Assertions.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assertions.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType(), (Object)compressionType.value());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assertions.assertTrue((boolean)compressionType.isDefault());
        Assertions.assertFalse((boolean)compressionType.isSensitive());
        Assertions.assertFalse((boolean)compressionType.isReadOnly());
        Assertions.assertEquals((int)((KafkaServer)this.servers().apply(2)).config().nonInternalValues().size(), (int)((Config)configs.get(brokerResource2)).entries().size());
        Assertions.assertEquals((Object)Integer.toString(((KafkaServer)this.servers().apply(2)).config().brokerId()), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assertions.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(topic2, x$3, 2, x$4);
        TopicDescription topic1_metadata = this.getTopicMetadata(this.client(), topic1, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        TopicDescription topic2_metadata = this.getTopicMetadata(this.client(), topic2, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topic1_metadata.partitions().size());
        Assertions.assertEquals((int)1, (int)topic2_metadata.partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        Void cfr_ignored_0 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assertions.assertEquals((int)1, (int)this.numPartitions$1(topic1, (Option)None$.MODULE$));
        alterResult.elem = this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        Void cfr_ignored_1 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$1(this, topic1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for new partitions to appear");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        java.util.List<java.util.List> newPartition2Assignments = Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
        alterResult.elem = this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        Void cfr_ignored_2 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assertions.assertEquals((int)1, (int)this.numPartitions$1(topic2, (Option)None$.MODULE$));
        alterResult.elem = this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        Void cfr_ignored_3 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
        Assertions.assertEquals((int)3, (int)actualPartitions2.size());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()))).toList());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()))).toList());
        new .colon.colon((Object)validateOnly, (List)new .colon.colon((Object)actuallyDoIt, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)option -> {
            PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$5(this, alterResult, topic1, topic2, newPartition2Assignments, option);
            return BoxedUnit.UNIT;
        });
        alterResult.elem = this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        Void cfr_ignored_4 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$30(this, topic1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Timed out waiting for new partitions to appear");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2)).get());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException));
        Assertions.assertEquals((Object)"Topic currently has 3 partitions, which is higher than the requested 2.", (Object)e.getCause().getMessage());
        Assertions.assertEquals((int)3, (int)this.numPartitions$1(topic2, (Option)None$.MODULE$));
        ((KafkaFuture)this.client().deleteTopics(Arrays.asList(topic1)).topicNameValues().get(topic1)).get();
        alterResult.elem = this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1)).get(), () -> "Expect InvalidTopicException when the topic is queued for deletion");
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException));
        Assertions.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
    }

    @Test
    public void testSeekAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assertions.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assertions.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assertions.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assertions.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assertions.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    @Test
    public void testLogStartOffsetCheckpoint() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        DeleteRecordsResult deleteRecordsResult = this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)deleteRecordsResult.lowWatermarks().get(this.topicPartition())).get()).lowWatermark()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)some);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((scala.collection.Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(Admin.create(this.createConfig()));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            ExecutionException executionException;
            boolean bl;
            deleteRecordsResult = this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
            some = None$.MODULE$;
            KafkaFuture $anonfun$testLogStartOffsetCheckpoint$2_future = (KafkaFuture)deleteRecordsResult.lowWatermarks().get(this.topicPartition());
            try {
                some = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)$anonfun$testLogStartOffsetCheckpoint$2_future.get()).lowWatermark()));
                bl = some.contains((Object)BoxesRunTime.boxToLong((long)5L));
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ExecutionException) || !((executionException = (ExecutionException)throwable).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderOrFollowerException)) {
                    throw throwable;
                }
                boolean bl2 = false;
                bl = bl2;
            }
            Object var10_9 = null;
            Object var11_10 = null;
            executionException = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ").append(((Option)some).getOrElse((Function0 & Serializable)() -> "no response within the timeout")).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assertions.assertEquals((long)3L, (long)lowWatermark);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)3L, (long)((Log)((KafkaServer)this.servers().apply(i)).replicaManager().localLog(this.topicPartition()).get()).logStartOffset()));
    }

    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        Properties x$4;
        String x$1 = this.topic();
        int x$2 = this.brokerCount();
        int x$3 = this.createTopic$default$2();
        int followerIndex = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$2, x$4 = this.createTopic$default$4()).apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)3L, (long)((Log)((KafkaServer)this.servers().apply(i)).replicaManager().localLog(this.topicPartition()).get()).logStartOffset()));
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)117L))}))).asJava()).all().get();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        this.client_$eq(Admin.create(this.createConfig()));
        String x$1 = this.topic();
        int x$2 = this.brokerCount();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((long)3L, (long)((Log)((KafkaServer)this.servers().apply(i)).replicaManager().localLog(this.topicPartition()).get()).logStartOffset());
            Assertions.assertEquals((long)expectedLEO, (long)((Log)((KafkaServer)this.servers().apply(i)).replicaManager().localLog(this.topicPartition()).get()).logEndOffset());
        });
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        this.client().alterReplicaLogDirs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)futureReplica), (Object)futureLogDir)}))).asJava()).all().get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$2(this, futureLogDir)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"timed out waiting for replica movement");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertEquals((long)3L, (long)((Log)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logStartOffset());
        Assertions.assertEquals((long)expectedLEO, (long)((Log)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logEndOffset());
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assertions.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).all().get();
        Assertions.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        Assertions.assertNull(consumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition()));
    }

    @Test
    public void testConsumeAfterDeleteRecords() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        TestUtils$.MODULE$.consumeRecords(consumer, 10, 15000L);
        this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 7, 15000L);
        this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)8L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L);
    }

    @Test
    public void testDeleteRecordsWithException() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assertions.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).getCause();
        Assertions.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistPartition), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(nonExistPartition)).get()).getCause();
        Assertions.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)describeResult1.values().get(nonExistentTopic)).get()).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)describeResult2.values().get(invalidTopic)).get()).getCause() instanceof InvalidTopicException));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        long l = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(java.time.Duration.ofMillis(100L));
            if (PlaintextAdminIntegrationTest.$anonfun$subscribeAndWaitForAssignment$1(consumer)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected non-empty assignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> PlaintextAdminIntegrationTest.$anonfun$sendRecords$1(this, topicPartition, producer, BoxesRunTime.unboxToInt((Object)i))).foreach((Function1 & Serializable)x$9 -> (RecordMetadata)x$9.get());
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (scala.collection.Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testAclOperations() {
        AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        this.client_$eq(Admin.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(acl)).all(), SecurityDisabledException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(acl.toFilter())).all(), SecurityDisabledException.class, (Option<String>)None$.MODULE$);
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(Admin.create(this.createConfig()));
        scala.collection.Seq newTopics = (scala.collection.Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable)x$10 -> new NewTopic(x$10, 1, (short)1));
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(java.time.Duration.ofHours(2L));
        KafkaFuture future2 = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class, (Option<String>)None$.MODULE$);
        future.get();
        this.client().close(java.time.Duration.ofMinutes(30L));
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        this.client_$eq(Admin.create(config));
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable)x$11 -> new NewTopic(x$11, 1, (short)1))).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(java.time.Duration.ZERO);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, (Option<String>)None$.MODULE$);
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        config.put("request.timeout.ms", "0");
        this.client_$eq(Admin.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable)x$12 -> new NewTopic(x$12, 1, (short)1))).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, (Option<String>)None$.MODULE$);
        Assertions.assertTrue((Time.SYSTEM.milliseconds() > startTimeMs ? 1 : 0) != 0, (String)"Expected the timeout to take at least one millisecond.");
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("default.api.timeout.ms", "100000000");
        config.put("retries", "0");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((Admin)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable)x$13 -> new NewTopic(x$13, 1, (short)1))).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, (Option<String>)None$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)"mytopic3", (List)new .colon.colon((Object)"mytopic4", (List)Nil$.MODULE$)).map((Function1 & Serializable)x$14 -> new NewTopic(x$14, 1, (short)1))).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        Assertions.assertEquals((int)1, (int)factory.failuresInjected());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerGroups() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            ListConsumerGroupsResult list1 = this.client().listConsumerGroups();
            Assertions.assertTrue((0 == ((Collection)list1.all().get()).size() ? 1 : 0) != 0);
            Assertions.assertTrue((0 == ((Collection)list1.errors().get()).size() ? 1 : 0) != 0);
            Assertions.assertTrue((0 == ((Collection)list1.valid().get()).size() ? 1 : 0) != 0);
            String testTopicName = "test_topic";
            String testTopicName1 = new StringBuilder(1).append(testTopicName).append("1").toString();
            String testTopicName2 = new StringBuilder(1).append(testTopicName).append("2").toString();
            int testNumPartitions = 2;
            this.client().createTopics(Arrays.asList(new NewTopic(testTopicName, testNumPartitions, (short)1), new NewTopic(testTopicName1, testNumPartitions, (short)1), new NewTopic(testTopicName2, testNumPartitions, (short)1))).all().get();
            this.waitForTopics(this.client(), (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testTopicName, testTopicName1, testTopicName2}))), (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            String EMPTY_GROUP_INSTANCE_ID = "";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String testInstanceId1 = "test_instance_id_1";
            String testInstanceId2 = "test_instance_id_2";
            String fakeGroupId = "fake_group_id";
            scala.collection.immutable.Set groupInstanceSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testInstanceId1, testInstanceId2, EMPTY_GROUP_INSTANCE_ID}));
            scala.collection.immutable.Set consumerSet = (scala.collection.immutable.Set)groupInstanceSet.map((Function1 & Serializable)groupInstanceId -> {
                Properties x$1 = this.createProperties$1((String)groupInstanceId, testGroupId, testClientId, EMPTY_GROUP_INSTANCE_ID);
                ByteArrayDeserializer x$2 = this.createConsumer$default$1();
                ByteArrayDeserializer x$3 = this.createConsumer$default$2();
                List<String> x$4 = this.createConsumer$default$4();
                return this.createConsumer(x$2, x$3, x$1, x$4);
            });
            scala.collection.immutable.Set topicSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testTopicName, testTopicName1, testTopicName2}));
            CountDownLatch latch = new CountDownLatch(consumerSet.size());
            try {
                scala.collection.immutable.Set consumerThreads = (scala.collection.immutable.Set)((IterableOps)consumerSet.zip((IterableOnce)topicSet)).map((Function1 & Serializable)zipped -> {
                    String createConsumerThread$1_topic = (String)zipped._2();
                    KafkaConsumer createConsumerThread$1_consumer = (KafkaConsumer)zipped._1();
                    return new Thread(null, createConsumerThread$1_consumer, createConsumerThread$1_topic, latch){
                        private final KafkaConsumer consumer$2;
                        private final String topic$4;
                        private final CountDownLatch latch$1;

                        public void run() {
                            this.consumer$2.subscribe(Collections.singleton(this.topic$4));
                            try {
                                while (true) {
                                    this.consumer$2.poll(java.time.Duration.ofSeconds(5L));
                                    if (!this.consumer$2.assignment().isEmpty() && this.latch$1.getCount() > 0L) {
                                        this.latch$1.countDown();
                                    }
                                    this.consumer$2.commitSync();
                                }
                            }
                            catch (InterruptException interruptException) {
                                return;
                            }
                        }
                        {
                            this.consumer$2 = consumer$2;
                            this.topic$4 = topic$4;
                            this.latch$1 = latch$1;
                        }
                    };
                });
                try {
                    consumerThreads.foreach((Function1 & Serializable)x$15 -> {
                        x$15.start();
                        return BoxedUnit.UNIT;
                    });
                    Assertions.assertTrue((boolean)latch.await(30000L, TimeUnit.MILLISECONDS));
                    long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    long waitUntilTrue_startTime = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$4(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                            Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$6(testGroupId));
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    }
                    long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    long waitUntilTrue_startTime2 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$7(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                            Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$9(testGroupId));
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                    }
                    long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    long waitUntilTrue_startTime3 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$10(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                            Assertions.fail((String)"Expected to find zero groups");
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
                    }
                    DescribeConsumerGroupsResult describeWithFakeGroupResult = this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)testGroupId, (List)new .colon.colon((Object)fakeGroupId, (List)Nil$.MODULE$))).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assertions.assertEquals((int)2, (int)describeWithFakeGroupResult.describedGroups().size());
                    Assertions.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(testGroupId));
                    ConsumerGroupDescription testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(testGroupId)).get();
                    Assertions.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assertions.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assertions.assertEquals((int)groupInstanceSet.size(), (int)testGroupDescription.members().size());
                    Collection members = testGroupDescription.members();
                    CollectionConverters$.MODULE$.CollectionHasAsScala(members).asScala().foreach((Function1 & Serializable)member -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$13(testClientId, member);
                        return BoxedUnit.UNIT;
                    });
                    scala.collection.immutable.Map topicPartitionsByTopic = ((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(members).asScala().flatMap((Function1 & Serializable)x$17 -> CollectionConverters$.MODULE$.SetHasAsScala(x$17.assignment().topicPartitions()).asScala())).groupBy((Function1 & Serializable)x$18 -> x$18.topic());
                    topicSet.foreach((Function1 & Serializable)topic -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$16(topicPartitionsByTopic, testNumPartitions, topic);
                        return BoxedUnit.UNIT;
                    });
                    java.util.Set expectedOperations = CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)AclEntry$.MODULE$.supportedOperations(ResourceType.GROUP)).asJava();
                    Assertions.assertEquals((Object)expectedOperations, (Object)testGroupDescription.authorizedOperations());
                    Assertions.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(fakeGroupId));
                    ConsumerGroupDescription fakeGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(fakeGroupId)).get();
                    Assertions.assertEquals((Object)fakeGroupId, (Object)fakeGroupDescription.groupId());
                    Assertions.assertEquals((int)0, (int)fakeGroupDescription.members().size());
                    Assertions.assertEquals((Object)"", (Object)fakeGroupDescription.partitionAssignor());
                    Assertions.assertEquals((Object)ConsumerGroupState.DEAD, (Object)fakeGroupDescription.state());
                    Assertions.assertEquals((Object)expectedOperations, (Object)fakeGroupDescription.authorizedOperations());
                    Assertions.assertEquals((int)2, (int)((java.util.Map)describeWithFakeGroupResult.all().get()).size());
                    long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    long waitUntilTrue_startTime4 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$18(this, testGroupId, testTopicName)) {
                        void waitUntilTrue_pause;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                            Assertions.fail((String)"Expected the offset for partition 0 to eventually become 1.");
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
                    }
                    String invalidInstanceId = "invalid-instance-id";
                    RemoveMembersFromConsumerGroupResult removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(invalidInstanceId))));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(removeMembersResult.all(), UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    KafkaFuture firstMemberFuture = removeMembersResult.memberResult(new MemberToRemove(invalidInstanceId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(firstMemberFuture, UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    DeleteConsumerGroupsResult deleteResult = this.client().deleteConsumerGroups((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)testGroupId, (List)new .colon.colon((Object)fakeGroupId, (List)Nil$.MODULE$))).asJava());
                    Assertions.assertEquals((int)2, (int)deleteResult.deletedGroups().size());
                    Assertions.assertTrue((boolean)deleteResult.deletedGroups().containsKey(fakeGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(fakeGroupId), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    Assertions.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(testGroupId), GroupNotEmptyException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(testInstanceId1))));
                    Assertions.assertNull((Object)removeMembersResult.all().get());
                    Assertions.assertNull((Object)removeMembersResult.memberResult(new MemberToRemove(testInstanceId1)).get());
                    DescribeConsumerGroupsResult describeTestGroupResult = this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assertions.assertEquals((int)1, (int)describeTestGroupResult.describedGroups().size());
                    testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeTestGroupResult.describedGroups().get(testGroupId)).get();
                    Assertions.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assertions.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assertions.assertEquals((int)(consumerSet.size() - 1), (int)testGroupDescription.members().size());
                    removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions());
                    Assertions.assertNull((Object)removeMembersResult.all().get());
                    testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true)).describedGroups().get(testGroupId)).get();
                    Assertions.assertTrue((boolean)testGroupDescription.members().isEmpty());
                    deleteResult = this.client().deleteConsumerGroups((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava());
                    Assertions.assertEquals((int)1, (int)deleteResult.deletedGroups().size());
                    Assertions.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    Assertions.assertNull((Object)((KafkaFuture)deleteResult.deletedGroups().get(testGroupId)).get());
                }
                finally {
                    consumerThreads.foreach((Function1 & Serializable)x0$1 -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$20(x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            finally {
                ((IterableOnceOps)consumerSet.zip((IterableOnce)groupInstanceSet)).foreach((Function1 & Serializable)zipped -> {
                    PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$21(zipped);
                    return BoxedUnit.UNIT;
                });
            }
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsets() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            String testTopicName = "test_topic";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String fakeGroupId = "fake_group_id";
            TopicPartition tp1 = new TopicPartition(testTopicName, 0);
            TopicPartition tp2 = new TopicPartition("foo", 0);
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, 1, (short)1))).all().get();
            this.waitForTopics(this.client(), (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testTopicName}))), (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            newConsumerConfig.setProperty("max.poll.interval.ms", Integer.toString(Integer.MAX_VALUE));
            newConsumerConfig.setProperty("session.timeout.ms", Integer.toString(Defaults$.MODULE$.GroupMaxSessionTimeoutMs()));
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$2, x$3, newConsumerConfig, x$4);
            try {
                TestUtils$.MODULE$.subscribeAndWaitForRecords(testTopicName, consumer, 15000L);
                consumer.commitSync();
                DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), GroupSubscribedToTopicException.class, (Option<String>)None$.MODULE$);
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp1), GroupSubscribedToTopicException.class, (Option<String>)None$.MODULE$);
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
                DeleteConsumerGroupOffsetsResult fakeDeleteResult = this.client().deleteConsumerGroupOffsets(fakeGroupId, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.all(), GroupIdNotFoundException.class, (Option<String>)None$.MODULE$);
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp1), GroupIdNotFoundException.class, (Option<String>)None$.MODULE$);
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp2), GroupIdNotFoundException.class, (Option<String>)None$.MODULE$);
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
            DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
            Assertions.assertNull((Object)offsetDeleteResult.partitionResult(tp1).get());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    @Test
    public void testElectPreferredLeaders() {
        this.client_$eq(Admin.create(this.createConfig()));
        scala.collection.Seq prefer0 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        scala.collection.Seq prefer1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        scala.collection.Seq prefer2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        TopicPartition partition1 = new TopicPartition("elect-preferred-leaders-topic-1", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)prefer0)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TopicPartition partition2 = new TopicPartition("elect-preferred-leaders-topic-2", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition2.topic(), (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)prefer0)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.PREFERRED, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Throwable exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assertions.assertEquals(ElectionNotNeededException.class, exception.getClass());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assertions.assertTrue((boolean)((java.util.Map)electResult.partitions().get()).isEmpty());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        Assertions.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((java.util.Map)electResult.partitions().get()).keySet()).asScala());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        TopicPartition unknownPartition = new TopicPartition("topic-does-not-exist", 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assertions.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assertions.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        this.changePreferredLeader$1(prefer2, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assertions.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assertions.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        electResult = this.client().electLeaders(ElectionType.PREFERRED, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        ((KafkaServer)this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
        ElectLeadersOptions shortTimeout = (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Predef$.MODULE$.int2Integer(10000));
        electResult = this.client().electLeaders(ElectionType.PREFERRED, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), shortTimeout);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assertions.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"), (String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null, shortTimeout);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assertions.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"), (String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get();
        Assertions.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-2-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"), (String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
    }

    @Test
    public void testElectUncleanLeadersForOnePartition() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        TopicPartition partition1 = new TopicPartition("unclean-test-topic-1", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
    }

    @Test
    public void testElectUncleanLeadersForManyPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        scala.collection.Seq assignment2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition2, (Option<Object>)None$.MODULE$);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker2);
    }

    @Test
    public void testElectUncleanLeadersForAllPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        scala.collection.Seq assignment2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, null);
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assertions.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    @Test
    public void testElectUncleanLeadersForUnknownPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition unknownPartition = new TopicPartition(topic, 1);
        TopicPartition unknownTopic = new TopicPartition("unknown-topic", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)assignment1)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), new TopicPartition(topic, 0), broker1);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, unknownTopic}))).asJava());
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get() instanceof UnknownTopicOrPartitionException));
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownTopic)).get() instanceof UnknownTopicOrPartitionException));
    }

    @Test
    public void testElectUncleanLeadersWhenNoLiveBrokers() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).get() instanceof EligibleLeadersNotAvailableException));
    }

    @Test
    public void testElectUncleanLeadersNoop() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        ((KafkaServer)this.servers().apply(broker1)).startup();
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).get() instanceof ElectionNotNeededException));
    }

    @Test
    public void testElectUncleanLeadersAndNoop() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        scala.collection.Seq assignment2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get() instanceof ElectionNotNeededException));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    @Test
    public void testListReassignmentsDoesNotShowNonReassigningPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(topic, x$3, 3, x$4);
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assertions.assertEquals((int)0, (int)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assertions.assertEquals((int)0, (int)allReassignmentsMap.size());
    }

    @Test
    public void testListReassignmentsDoesNotShowDeletedPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assertions.assertEquals((int)0, (int)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assertions.assertEquals((int)0, (int)allReassignmentsMap.size());
    }

    @Test
    public void testValidIncrementalAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topic1CreateConfigs = new Properties();
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic1, 1, 1, topic1CreateConfigs);
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete()), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)))).asJavaCollection();
        Collection topic2AlterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$)))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assertions.assertEquals((Object)"compact,delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)"lz4", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)"delete,compact", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))).asJava();
        topic2AlterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString()), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$)).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assertions.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assertions.assertEquals((Object)"", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()).value());
        Assertions.assertEquals((Object)"", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$)).asJava();
        alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)topic1Resource, (List)Nil$.MODULE$)).asJava()).all().get();
        Assertions.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "zip"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJava();
        alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testIncrementalAlterConfigsDeleteAndSetBrokerConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection())}))).asJava()).all().get();
        long l = 15000L;
        long waitUntilTrue_pause = 25L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$1(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected to see the broker properties we just set");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
        this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "654"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "987"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection())}))).asJava()).all().get();
        long l2 = 15000L;
        long waitUntilTrue_pause2 = 25L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$6(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l2) {
                Assertions.fail((String)"Expected to see the broker properties we just modified");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l2), waitUntilTrue_pause2));
        }
    }

    @Test
    public void testIncrementalAlterConfigsDeleteBrokerConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection())}))).asJava()).all().get();
        long l = 15000L;
        long waitUntilTrue_pause = 25L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$1(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected to see the broker properties we just set");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
        this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)))).asJavaCollection())}))).asJava()).all().get();
        long l2 = 15000L;
        long waitUntilTrue_pause2 = 25L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$7(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l2) {
                Assertions.fail((String)"Expected to see the broker properties we just removed to be deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l2), waitUntilTrue_pause2));
        }
    }

    @Test
    public void testInvalidIncrementalAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.75"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.65"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection();
        Collection topic2AlterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Error due to duplicate config keys"));
        ((KafkaFuture)alterResult.values().get(topic2Resource)).get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType().toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        topic1AlterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$)).asJavaCollection();
        topic2AlterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$)).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value append is not allowed for config"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic2Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value subtract is not allowed for config"));
        topic1AlterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testInvalidAlterPartitionReassignments() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "alter-reassignments-topic-1";
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        TopicPartition tp3 = new TopicPartition(topic, 2);
        this.createTopic(topic, 4, this.createTopic$default$3(), this.createTopic$default$4());
        Optional<NewPartitionReassignment> validAssignment = Optional.of(new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1 & Serializable)x$19 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$1(BoxesRunTime.unboxToInt((Object)x$19)))).asJava()));
        TopicPartition nonExistentTp1 = new TopicPartition("topicA", 0);
        TopicPartition nonExistentTp2 = new TopicPartition(topic, 4);
        java.util.Map nonExistentPartitionsResult = this.client().alterPartitionReassignments(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp1), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp2), validAssignment)}))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp1), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp2), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
        Optional<NewPartitionReassignment> extraNonExistentReplica = Optional.of(new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount() + 1).map((Function1 & Serializable)x$20 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$2(BoxesRunTime.unboxToInt((Object)x$20)))).asJava()));
        Optional<NewPartitionReassignment> negativeIdReplica = Optional.of(new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-3, -2, -1})).map((Function1 & Serializable)x$21 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$3(BoxesRunTime.unboxToInt((Object)x$21)))).asJava()));
        Optional<NewPartitionReassignment> duplicateReplica = Optional.of(new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 1})).map((Function1 & Serializable)x$22 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$4(BoxesRunTime.unboxToInt((Object)x$22)))).asJava()));
        java.util.Map invalidReplicaResult = this.client().alterPartitionReassignments(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), extraNonExistentReplica), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), negativeIdReplica), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), duplicateReplica)}))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp1), InvalidReplicaAssignmentException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp2), InvalidReplicaAssignmentException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp3), InvalidReplicaAssignmentException.class, (Option<String>)None$.MODULE$);
    }

    @Test
    public void testLongTopicNames() {
        Admin client = Admin.create(this.createConfig());
        String longTopicName = String.join((CharSequence)"", Collections.nCopies(249, "x"));
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(250, "x"));
        .colon.colon newTopics2 = new .colon.colon((Object)new NewTopic(invalidTopicName, 3, (short)3), (List)new .colon.colon((Object)new NewTopic(longTopicName, 3, (short)3), (List)Nil$.MODULE$));
        java.util.Map results = client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)newTopics2).asJava()).values();
        Assertions.assertTrue((boolean)results.containsKey(longTopicName));
        ((KafkaFuture)results.get(longTopicName)).get();
        Assertions.assertTrue((boolean)results.containsKey(invalidTopicName));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get(invalidTopicName), InvalidTopicException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(client.alterReplicaLogDirs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(longTopicName, 0, 0)), ((KafkaServer)this.servers().apply(0)).config().logDirs().apply(0))}))).asJava()).all(), InvalidTopicException.class, (Option<String>)None$.MODULE$);
        client.close();
    }

    @Test
    public void testNullConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        java.util.Map invalidConfigs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.RetentionBytesProp()), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)"producer")}))).asJava();
        NewTopic newTopic = new NewTopic(this.topic(), 2, (short)this.brokerCount());
        ExecutionException e1 = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.client().createTopics(Collections.singletonList(newTopic.configs(invalidConfigs))).all().get());
        Assertions.assertTrue((boolean)(e1.getCause() instanceof InvalidRequestException), (String)new StringBuilder(21).append("Unexpected exception ").append(e1.getCause().getClass()).toString());
        java.util.Map validConfigs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)"producer")}))).asJava();
        this.client().createTopics(Collections.singletonList(newTopic.configs(validConfigs))).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), (scala.collection.Seq<String>)((scala.collection.Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        this.validateLogConfig$1("producer");
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        .colon.colon alterOps = new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionBytesProp(), null), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$));
        ExecutionException e2 = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> PlaintextAdminIntegrationTest.$anonfun$testNullConfigs$2(this, topicResource, (scala.collection.Seq)alterOps));
        Assertions.assertTrue((boolean)(e2.getCause() instanceof InvalidRequestException), (String)new StringBuilder(21).append("Unexpected exception ").append(e2.getCause().getClass()).toString());
        this.validateLogConfig$1("producer");
    }

    @Test
    public void testDescribeConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        LoggerFactory.getLogger((String)"kafka.cluster.Replica").trace("Message to create the logger");
        Config loggerConfig = this.describeBrokerLoggers();
        String kafkaLogLevel = loggerConfig.get("kafka").value();
        ConfigEntry logCleanerLogLevelConfig = loggerConfig.get("kafka.cluster.Replica");
        Assertions.assertEquals((Object)kafkaLogLevel, (Object)logCleanerLogLevelConfig.value());
        Assertions.assertEquals((Object)"kafka.cluster.Replica", (Object)logCleanerLogLevelConfig.name());
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, (Object)logCleanerLogLevelConfig.source());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isReadOnly()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isSensitive()));
        Assertions.assertTrue((boolean)logCleanerLogLevelConfig.synonyms().isEmpty());
    }

    @Test
    @Disabled
    public void testIncrementalAlterConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        Config initialLoggerConfig = this.describeBrokerLoggers();
        String initialRootLogLevel = initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.log.LogCleaner").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.server.ReplicaManager").value());
        String newRootLogLevel = "DEBUG";
        Collection alterRootLoggerEntry = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, true);
        Config validatedLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.controller.KafkaController").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.log.LogCleaner").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedRootLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.controller.KafkaController").value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.log.LogCleaner").value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterZKLoggerEntry = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", "ERROR"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterZKLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedZKLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)"ERROR", (Object)changedZKLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterLogLevelsEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))))).asJavaCollection();
        this.alterBrokerLoggers(alterLogLevelsEntries, this.alterBrokerLoggers$default$2());
        Config alteredLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)"INFO", (Object)alteredLoggerConfig.get("kafka.controller.KafkaController").value());
        Assertions.assertEquals((Object)"ERROR", (Object)alteredLoggerConfig.get("kafka.log.LogCleaner").value());
        Assertions.assertEquals((Object)"TRACE", (Object)alteredLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
    }

    @Test
    @Disabled
    public void testIncrementalAlterConfigsForLog4jLogLevelsCanResetLoggerToCurrentRoot() {
        this.client_$eq(Admin.create(this.createConfig()));
        String initialRootLogLevel = "TRACE";
        Collection alterRootLoggerEntry = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), initialRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config initialLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection alterControllerLoggerEntry = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedControllerLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)changedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)"INFO", (Object)changedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection deleteControllerLoggerEntry = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(deleteControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config deletedControllerLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        String newRootLogLevel = "ERROR";
        Collection newAlterRootLoggerEntry = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(newAlterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config newRootLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get("kafka.controller.KafkaController").value());
    }

    @Test
    @Disabled
    public void testIncrementalAlterConfigsForLog4jLogLevelsCannotResetRootLogger() {
        this.client_$eq(Admin.create(this.createConfig()));
        Collection deleteRootLoggerEntry = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(deleteRootLoggerEntry, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
    }

    @Test
    @Disabled
    public void testIncrementalAlterConfigsForLog4jLogLevelsDoesNotWorkWithInvalidConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String validLoggerName = "kafka.server.KafkaRequestHandler";
        ConfigEntry expectedValidLoggerLogLevel = this.describeBrokerLoggers().get(validLoggerName);
        Collection appendLogLevelEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(appendLogLevelEntries, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection subtractLogLevelEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(subtractLogLevelEntries, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection invalidLogLevelLogLevelEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "OFF"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(invalidLogLevelLogLevelEntries, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection invalidLoggerNameLogLevelEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("Some Other LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(invalidLoggerNameLogLevelEntries, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
    }

    @Test
    @Disabled
    public void testAlterConfigsForLog4jLogLevelsDoesNotWork() {
        this.client_$eq(Admin.create(this.createConfig()));
        Collection alterLogLevelsEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("kafka.controller.KafkaController", "INFO"), (List)Nil$.MODULE$)).asJavaCollection();
        AlterConfigsResult alterResult = this.client().alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.brokerLoggerConfigResource()), (Object)new Config(alterLogLevelsEntries))}))).asJava());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)alterResult.values().get(this.brokerLoggerConfigResource())).get()).getCause() instanceof InvalidRequestException));
    }

    public void alterBrokerLoggers(Collection<AlterConfigOp> entries, boolean validateOnly) {
        if (!validateOnly) {
            CollectionConverters$.MODULE$.CollectionHasAsScala(entries).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$alterBrokerLoggers$1(this, entry)));
        }
        ((KafkaFuture)this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.brokerLoggerConfigResource()), entries)}))).asJava(), new AlterConfigsOptions().validateOnly(validateOnly)).values().get(this.brokerLoggerConfigResource())).get();
    }

    public boolean alterBrokerLoggers$default$2() {
        return false;
    }

    public Config describeBrokerLoggers() {
        return (Config)((KafkaFuture)this.client().describeConfigs(Collections.singletonList(this.brokerLoggerConfigResource())).values().get(this.brokerLoggerConfigResource())).get();
    }

    private void teardownBrokerLoggers() {
        if (this.changedBrokerLoggers().nonEmpty()) {
            scala.collection.immutable.Set validLoggers = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.describeBrokerLoggers().entries()).asScala().filterNot((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$teardownBrokerLoggers$1(x$23)))).map((Function1 & Serializable)x$24 -> x$24.name())).toSet();
            Collection unsetBrokerLoggersEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)this.changedBrokerLoggers().intersect((scala.collection.Set)validLoggers).map((Function1 & Serializable)logger -> new AlterConfigOp(new ConfigEntry(logger, ""), AlterConfigOp.OpType.DELETE))).asJavaCollection();
            this.alterBrokerLoggers(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), "FATAL"), AlterConfigOp.OpType.SET)}))).asJavaCollection(), this.alterBrokerLoggers$default$2());
            this.alterBrokerLoggers(unsetBrokerLoggersEntries, this.alterBrokerLoggers$default$2());
            this.changedBrokerLoggers().clear();
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateExistingTopicsThrowTopicExistsException$1(PlaintextAdminIntegrationTest $this, scala.collection.Seq newTopicsWithInvalidRF$1) {
        $this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(newTopicsWithInvalidRF$1).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataRefresh$1(PlaintextAdminIntegrationTest $this, KafkaServer x$2) {
        return x$2.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected($this.zkClient(), 15000L);
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString();
        Assertions.assertTrue((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])brokers$1), (Object)hostStr), (String)new StringBuilder(45).append("Unknown host:port pair ").append(hostStr).append(" in brokerVersionInfos").toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$1) {
        void var1_1;
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int leaderId = x0$1._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$4) {
        return x$4.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, Tuple2 x0$4) {
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        String string = ((TopicPartition)x0$4._1()).topic();
        boolean bl = !(string != null ? !string.equals(topic$1) : topic$1 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertEquals((Object)((Log)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$6) {
        return x$6.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$4(KafkaFuture future) {
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get())).getCause() instanceof UnknownTopicOrPartitionException));
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$6(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$6 = qual$1.getLog$default$2();
        String logDir = ((Log)qual$1.getLog(tp$1, x$6).get()).dir().getParent();
        Assertions.assertEquals((Object)firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$8(KafkaServer server$2, TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3) {
        LogManager qual$2 = server$2.logManager();
        boolean x$8 = qual$2.getLog$default$2();
        String logDir = ((Log)qual$2.getLog(tp$1, x$8).get()).dir().getParent();
        Object object = secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$2.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$9() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$7(TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3, KafkaServer server) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$8(server, tp$1, secondReplicaAssignment$1, topic$3)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"timed out waiting for replica movement");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$11(AtomicInteger numMessages$1) {
        return numMessages$1.get() > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$12(AtomicInteger numMessages$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(60).append("only ").append(numMessages$1).append(" messages are produced before timeout. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$14(KafkaServer server$3, TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3) {
        LogManager qual$3 = server$3.logManager();
        boolean x$26 = qual$3.getLog$default$2();
        String logDir = ((Log)qual$3.getLog(tp$1, x$26).get()).dir().getParent();
        Object object = firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$3.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$15(scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(56).append("timed out waiting for replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$13(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, scala.concurrent.Future producerFuture$1, KafkaServer server) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$14(server, tp$1, firstReplicaAssignment$1, topic$3)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$15(producerFuture$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$16(AtomicInteger numMessages$1, int currentMessagesNum$1) {
        return numMessages$1.get() - currentMessagesNum$1 > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$17(AtomicInteger numMessages$1, int currentMessagesNum$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(83).append("only ").append(numMessages$1.get() - currentMessagesNum$1).append(" messages are produced within timeout after replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$18(Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord consumerRecord = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(index).toString(), (Object)new String((byte[])consumerRecord.value()));
            return;
        }
        throw new MatchError(null);
    }

    private final java.util.List partitions$1(String topic, Option expectedNumPartitionsOpt) {
        Admin x$1 = this.client();
        DescribeTopicsOptions x$4 = this.getTopicMetadata$default$3();
        return this.getTopicMetadata(x$1, topic, x$4, (Option<Object>)expectedNumPartitionsOpt).partitions();
    }

    private final int numPartitions$1(String topic, Option expectedNumPartitionsOpt) {
        return this.partitions$1(topic, expectedNumPartitionsOpt).size();
    }

    private static final Option numPartitions$default$2$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$1(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, (Option)None$.MODULE$) == 3;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$2() {
        return "Timed out waiting for new partitions to appear";
    }

    public static final /* synthetic */ void $anonfun$testCreatePartitions$5(PlaintextAdminIntegrationTest $this, ObjectRef alterResult$1, String topic1$1, String topic2$1, java.util.List newPartition2Assignments$1, CreatePartitionsOptions option) {
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(63).append(desc).append(": Expect InvalidPartitionsException when newCount is a decrease").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        Assertions.assertEquals((Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get(), () -> new StringBuilder(58).append(desc).append(": Expect InvalidPartitionsException when requesting a noop").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        Assertions.assertEquals((Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        Assertions.assertEquals((Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(newPartition2Assignments$1).asScala().reverse()).toList()).asJava()))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        Assertions.assertEquals((Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (String)desc);
        String unknownTopic = "an-unknown-topic";
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get(), () -> new StringBuilder(58).append(desc).append(": Expect InvalidTopicException when using an unknown topic").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof UnknownTopicOrPartitionException), (String)desc);
        Assertions.assertEquals((Object)"The topic 'an-unknown-topic' does not exist.", (Object)e.getCause().getMessage(), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        Assertions.assertEquals((Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(71).append(desc).append(": Expect InvalidPartitionsException when #brokers != replication factor").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        Assertions.assertEquals((Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)6, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(1)))))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        Assertions.assertEquals((Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(1)), Arrays.asList(Predef$.MODULE$.int2Integer(2)))))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        Assertions.assertEquals((Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)))))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(81).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        Assertions.assertEquals((Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)5, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(1)), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)))))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(94).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        Assertions.assertEquals((Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(12)))))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(86).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        Assertions.assertEquals((Object)"Unknown broker(s) in replica assignment: 12.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Collections.emptyList()))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(68).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments is empty").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        Assertions.assertEquals((Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$30(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, (Option)None$.MODULE$) == 4;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$31() {
        return "Timed out waiting for new partitions to appear";
    }

    public static final /* synthetic */ boolean $anonfun$testLogStartOffsetCheckpoint$2(PlaintextAdminIntegrationTest $this, ObjectRef result$1, ObjectRef lowWatermark$1) {
        result$1.elem = $this.client().deleteRecords(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
        lowWatermark$1.elem = None$.MODULE$;
        KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)result$1.elem).lowWatermarks().get($this.topicPartition());
        try {
            lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
            return ((Option)lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (!(throwable instanceof ExecutionException) || !((executionException = (ExecutionException)throwable).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderOrFollowerException)) {
                throw throwable;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$testLogStartOffsetCheckpoint$3(ObjectRef lowWatermark$1) {
        return new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ").append(((Option)lowWatermark$1.elem).getOrElse((Function0 & Serializable)() -> "no response within the timeout")).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int followerIndex$1) {
        Option option = ((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition());
        None$ none$ = None$.MODULE$;
        return option == null || !option.equals(none$);
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$2() {
        return "Expected follower to create replica for partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedStartOffset$1) {
        return ((Log)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset() == expectedStartOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(long expectedStartOffset$1) {
        return new StringBuilder(51).append("Expected follower to discover new log start offset ").append(expectedStartOffset$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedEndOffset$1) {
        return ((Log)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logEndOffset() == expectedEndOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(long expectedEndOffset$1) {
        return new StringBuilder(48).append("Expected follower to catch up to log end offset ").append(expectedEndOffset$1).toString();
    }

    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(this, followerIndex$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected follower to create replica for partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(this, followerIndex$1, expectedStartOffset)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(expectedStartOffset));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(this, followerIndex$1, expectedEndOffset)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(expectedEndOffset));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterLogDirsAfterDeleteRecords$2(PlaintextAdminIntegrationTest $this, String futureLogDir$1) {
        String string = futureLogDir$1;
        LogManager qual$1 = ((KafkaServer)$this.servers().apply(0)).logManager();
        TopicPartition x$5 = $this.topicPartition();
        boolean x$6 = qual$1.getLog$default$2();
        String string2 = ((Log)qual$1.getLog(x$5, x$6).get()).dir().getParent();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterLogDirsAfterDeleteRecords$3() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForAssignment$1(KafkaConsumer consumer$1) {
        return !consumer$1.assignment().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(PlaintextAdminIntegrationTest $this, TopicPartition topicPartition$1, KafkaProducer producer$1, int i) {
        ProducerRecord record = new ProducerRecord(topicPartition$1.topic(), Predef$.MODULE$.int2Integer(topicPartition$1.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    private final Properties createProperties$1(String groupInstanceId, String testGroupId$1, String testClientId$1, String EMPTY_GROUP_INSTANCE_ID$1) {
        Properties newConsumerConfig = new Properties(this.consumerConfig());
        newConsumerConfig.setProperty("enable.auto.commit", "false");
        newConsumerConfig.setProperty("group.id", testGroupId$1);
        newConsumerConfig.setProperty("client.id", testClientId$1);
        String string = groupInstanceId;
        if (string == null ? EMPTY_GROUP_INSTANCE_ID$1 != null : !string.equals(EMPTY_GROUP_INSTANCE_ID$1)) {
            newConsumerConfig.setProperty("group.instance.id", groupInstanceId);
        }
        return newConsumerConfig;
    }

    private static final Thread createConsumerThread$1(KafkaConsumer consumer, String topic, CountDownLatch latch$1) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$5(String testGroupId$1, ConsumerGroupListing group) {
        String string = group.groupId();
        if (!(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null)) {
            Object t = group.state().get();
            ConsumerGroupState consumerGroupState = ConsumerGroupState.STABLE;
            if (!(t != null ? !t.equals(consumerGroupState) : consumerGroupState != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$4(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        return ((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)$this.client().listConsumerGroups().all().get()).asScala().filter((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$5(testGroupId$1, group)))).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$6(String testGroupId$1) {
        return new StringBuilder(28).append("Expected to be able to list ").append(testGroupId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$8(String testGroupId$1, ConsumerGroupListing group) {
        String string = group.groupId();
        if (!(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null)) {
            Object t = group.state().get();
            ConsumerGroupState consumerGroupState = ConsumerGroupState.STABLE;
            if (!(t != null ? !t.equals(consumerGroupState) : consumerGroupState != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$7(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        ListConsumerGroupsOptions options = new ListConsumerGroupsOptions().inStates(CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).asJava());
        return ((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)$this.client().listConsumerGroups(options).all().get()).asScala().filter((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$8(testGroupId$1, group)))).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$9(String testGroupId$1) {
        return new StringBuilder(44).append("Expected to be able to list ").append(testGroupId$1).append(" in state Stable").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$11(String testGroupId$1, ConsumerGroupListing x$16) {
        String string = x$16.groupId();
        return !(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$10(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        ListConsumerGroupsOptions options = new ListConsumerGroupsOptions().inStates(CollectionConverters$.MODULE$.SetHasAsJava((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.EMPTY}))).asJava());
        return ((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)$this.client().listConsumerGroups(options).all().get()).asScala().filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$11(testGroupId$1, x$16)))).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$12() {
        return "Expected to find zero groups";
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$13(String testClientId$1, MemberDescription member) {
        Assertions.assertEquals((Object)testClientId$1, (Object)member.clientId());
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$16(scala.collection.immutable.Map topicPartitionsByTopic$1, int testNumPartitions$1, String topic) {
        Iterable topicPartitions = (Iterable)topicPartitionsByTopic$1.getOrElse((Object)topic, (Function0 & Serializable)() -> package$.MODULE$.List().empty());
        Assertions.assertEquals((int)testNumPartitions$1, (int)topicPartitions.size());
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$18(PlaintextAdminIntegrationTest $this, String testGroupId$1, String testTopicName$1) {
        TopicPartition part;
        java.util.Map parts = (java.util.Map)$this.client().listConsumerGroupOffsets(testGroupId$1).partitionsToOffsetAndMetadata().get();
        return parts.containsKey(part = new TopicPartition(testTopicName$1, 0)) && ((OffsetAndMetadata)parts.get(part)).offset() == 1L;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$19() {
        return "Expected the offset for partition 0 to eventually become 1.";
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$20(Thread x0$1) {
        x0$1.interrupt();
        x0$1.join();
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$21(Tuple2 zipped) {
        Utils.closeQuietly((AutoCloseable)((AutoCloseable)zipped._1()), (String)((String)zipped._2()));
    }

    private final int preferredLeader$1(TopicPartition topicPartition) {
        return ((Node)((TopicPartitionInfo)this.getTopicMetadata(this.client(), topicPartition.topic(), this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4()).partitions().get(topicPartition.partition())).replicas().get(0)).id();
    }

    public static final /* synthetic */ boolean $anonfun$testElectPreferredLeaders$1(PlaintextAdminIntegrationTest $this, TopicPartition partition1$1, int preferred$1, TopicPartition partition2$1) {
        return $this.preferredLeader$1(partition1$1) == preferred$1 && $this.preferredLeader$1(partition2$1) == preferred$1;
    }

    public static final /* synthetic */ String $anonfun$testElectPreferredLeaders$2(PlaintextAdminIntegrationTest $this, int preferred$1, TopicPartition partition1$1, TopicPartition partition2$1) {
        return new StringBuilder(50).append("Expected preferred leader to become ").append(preferred$1).append(", but is ").append($this.preferredLeader$1(partition1$1)).append(" and ").append($this.preferredLeader$1(partition2$1)).toString();
    }

    private final void changePreferredLeader$1(scala.collection.Seq newAssignment, TopicPartition partition1$1, TopicPartition partition2$1) {
        int preferred = BoxesRunTime.unboxToInt((Object)newAssignment.head());
        int prior1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition1$1).get());
        int prior2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition2$1).get());
        scala.collection.immutable.Map m = Predef$.MODULE$.Map().empty();
        if (prior1 != preferred) {
            m = (scala.collection.immutable.Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1$1), (Object)newAssignment));
        }
        if (prior2 != preferred) {
            m = (scala.collection.immutable.Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2$1), (Object)newAssignment));
        }
        this.zkClient().createPartitionReassignment((Map)m);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$1(this, partition1$1, preferred, partition2$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$2(this, preferred, partition1$1, partition2$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        TestUtils$.MODULE$.assertLeader(this.client(), partition1$1, prior1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2$1, prior2);
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$1(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$1) {
        scala.collection.immutable.Map broker0Configs = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)broker0Resource$1, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$1)).entries()).asScala().map((Function1 & Serializable)x0$1 -> new Tuple2((Object)x0$1.name(), (Object)x0$1.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "123".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "456".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$5() {
        return "Expected to see the broker properties we just set";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$6(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$1) {
        scala.collection.immutable.Map broker0Configs = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)broker0Resource$1, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$1)).entries()).asScala().map((Function1 & Serializable)x0$2 -> new Tuple2((Object)x0$2.name(), (Object)x0$2.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "654".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "987".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$11() {
        return "Expected to see the broker properties we just modified";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$1(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$2) {
        scala.collection.immutable.Map broker0Configs = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)broker0Resource$2, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$2)).entries()).asScala().map((Function1 & Serializable)x0$1 -> new Tuple2((Object)x0$1.name(), (Object)x0$1.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "123".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "456".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "789".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$6() {
        return "Expected to see the broker properties we just set";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$7(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$2) {
        scala.collection.immutable.Map broker0Configs = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)new .colon.colon((Object)broker0Resource$2, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$2)).entries()).asScala().map((Function1 & Serializable)x0$2 -> new Tuple2((Object)x0$2.name(), (Object)x0$2.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$12() {
        return "Expected to see the broker properties we just removed to be deleted";
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$1(int x$19) {
        return BoxesRunTime.boxToInteger((int)x$19);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$2(int x$20) {
        return BoxesRunTime.boxToInteger((int)x$20);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$3(int x$21) {
        return BoxesRunTime.boxToInteger((int)x$21);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$4(int x$22) {
        return BoxesRunTime.boxToInteger((int)x$22);
    }

    private final void validateLogConfig$1(String compressionType) {
        LogConfig logConfig = (LogConfig)((MapOps)this.zkClient().getLogConfigs((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), Collections.emptyMap())._1()).apply((Object)this.topic());
        Assertions.assertEquals((Object)compressionType, logConfig.originals().get(LogConfig$.MODULE$.CompressionTypeProp()));
        Assertions.assertNull(logConfig.originals().get(LogConfig$.MODULE$.RetentionBytesProp()));
        Assertions.assertEquals((long)Defaults$.MODULE$.LogRetentionBytes(), (Long)logConfig.retentionSize());
    }

    public static final /* synthetic */ void $anonfun$testNullConfigs$2(PlaintextAdminIntegrationTest $this, ConfigResource topicResource$1, scala.collection.Seq alterOps$1) {
        $this.client().incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource$1), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alterOps$1).asJavaCollection())}))).asJava()).all().get();
    }

    private final void assertLogLevelDidNotChange$1(ConfigEntry expectedValidLoggerLogLevel$1, String validLoggerName$1) {
        Assertions.assertEquals((Object)expectedValidLoggerLogLevel$1, (Object)this.describeBrokerLoggers().get(validLoggerName$1));
    }

    public static final /* synthetic */ boolean $anonfun$alterBrokerLoggers$1(PlaintextAdminIntegrationTest $this, AlterConfigOp entry) {
        return $this.changedBrokerLoggers().add((Object)entry.configEntry().name());
    }

    public static final /* synthetic */ boolean $anonfun$teardownBrokerLoggers$1(ConfigEntry x$23) {
        return x$23.name().equals(Log4jController$.MODULE$.ROOT_LOGGER());
    }

    public PlaintextAdminIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
    }

    public static final /* synthetic */ Object $anonfun$testDescribeCluster$2$adapted(String[] brokers$1, Node node) {
        PlaintextAdminIntegrationTest.$anonfun$testDescribeCluster$2(brokers$1, node);
        return BoxedUnit.UNIT;
    }
}

