/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.TxnMetadata;
import kafka.log.UnifiedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tug\u0001B$I\u00015CQ\u0001\u0016\u0001\u0005\u0002UCq\u0001\u0017\u0001A\u0002\u0013\u0005\u0011\fC\u0004c\u0001\u0001\u0007I\u0011A2\t\r%\u0004\u0001\u0015)\u0003[\u0011\u001dQ\u0007\u00011A\u0005\u0002-Dqa\u001c\u0001A\u0002\u0013\u0005\u0001\u000f\u0003\u0004s\u0001\u0001\u0006K\u0001\u001c\u0005\bg\u0002\u0011\r\u0011\"\u0001u\u0011\u001d\t\t\u0001\u0001Q\u0001\nUD\u0011\"a\u0001\u0001\u0005\u0004%\t!!\u0002\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000fA\u0011\"a\u0004\u0001\u0005\u0004%\t!!\u0005\t\u0011\u0005e\u0001\u0001)A\u0005\u0003'A\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005-\u0002\u0001)A\u0005\u0003?Aq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002H\u0001!\t!a\f\t\u000f\u0005E\u0003\u0001\"\u0001\u00020!9\u00111\f\u0001\u0005\u0002\u0005=\u0002bBA0\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003G\u0002A\u0011AA\u0018\u0011\u001d\t9\u0007\u0001C\u0001\u0003_Aq!a\u001b\u0001\t\u0003\ty\u0003C\u0004\u0002p\u0001!\t!a\f\t\u000f\u0005M\u0004\u0001\"\u0001\u00020!9\u0011q\u000f\u0001\u0005\u0002\u0005=\u0002bBA>\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003\u007f\u0002A\u0011AA\u0018\u0011\u001d\t\u0019\t\u0001C\u0001\u0003_Aq!a\"\u0001\t\u0003\ty\u0003C\u0004\u0002\f\u0002!\t!a\f\t\u000f\u0005=\u0005\u0001\"\u0001\u00020!9\u00111\u0013\u0001\u0005\u0002\u0005=\u0002bBAL\u0001\u0011\u0005\u0011q\u0006\u0005\b\u00037\u0003A\u0011AA\u0018\u0011\u001d\ty\n\u0001C\u0001\u0003_Aq!a)\u0001\t\u0003\ty\u0003C\u0004\u0002(\u0002!\t!a\f\t\u000f\u0005-\u0006\u0001\"\u0001\u00020!9\u0011q\u0016\u0001\u0005\u0002\u0005=\u0002bBAZ\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003o\u0003A\u0011AA\u0018\u0011\u001d\tY\f\u0001C\u0001\u0003_Aq!a0\u0001\t\u0003\ty\u0003C\u0004\u0002D\u0002!\t!a\f\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u00020!9\u00111\u001a\u0001\u0005\u0002\u0005=\u0002bBAh\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003'\u0004A\u0011AA\u0018\u0011\u001d\t9\u000e\u0001C\u0001\u0003_Aq!a7\u0001\t\u0003\ty\u0003C\u0004\u0002`\u0002!\t!a\f\t\u000f\u0005\r\b\u0001\"\u0001\u00020!9\u0011q\u001d\u0001\u0005\u0002\u0005=\u0002bBAv\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003_\u0004A\u0011AA\u0018\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003_Aq!a>\u0001\t\u0003\ty\u0003C\u0004\u0002|\u0002!\t!a\f\t\u000f\u0005}\b\u0001\"\u0001\u00020!9!1\u0001\u0001\u0005\n\t\u0015\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\n\u0005;\u0002\u0011\u0013!C\u0005\u0005?B\u0011B!\u001e\u0001#\u0003%IAa\u001e\t\u000f\tm\u0004\u0001\"\u0003\u0003~!I!\u0011\u0015\u0001\u0012\u0002\u0013%!q\u000f\u0005\n\u0005G\u0003\u0011\u0013!C\u0005\u0005KC\u0011B!+\u0001#\u0003%IAa+\t\u000f\tm\u0004\u0001\"\u0003\u00030\"9!1\u0019\u0001\u0005\n\t\u0015'\u0001\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'\u000fV3ti*\u0011\u0011JS\u0001\u0004Y><'\"A&\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0006CA,\u0001\u001b\u0005A\u0015A\u00027pO\u0012K'/F\u0001[!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0002j_*\tq,\u0001\u0003kCZ\f\u0017BA1]\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002eOB\u0011q*Z\u0005\u0003MB\u0013A!\u00168ji\"9\u0001nAA\u0001\u0002\u0004Q\u0016a\u0001=%c\u00059An\\4ESJ\u0004\u0013\u0001D:uCR,W*\u00198bO\u0016\u0014X#\u00017\u0011\u0005]k\u0017B\u00018I\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u0006\u00012\u000f^1uK6\u000bg.Y4fe~#S-\u001d\u000b\u0003IFDq\u0001\u001b\u0004\u0002\u0002\u0003\u0007A.A\u0007ti\u0006$X-T1oC\u001e,'\u000fI\u0001\na\u0006\u0014H/\u001b;j_:,\u0012!\u001e\t\u0003mzl\u0011a\u001e\u0006\u0003qf\faaY8n[>t'BA&{\u0015\tYH0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0006\u0019qN]4\n\u0005}<(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039s_\u0012,8-\u001a:JIV\u0011\u0011q\u0001\t\u0004\u001f\u0006%\u0011bAA\u0006!\n!Aj\u001c8h\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0002%5\f\u0007\u0010U5e\u000bb\u0004\u0018N]1uS>tWj]\u000b\u0003\u0003'\u00012aTA\u000b\u0013\r\t9\u0002\u0015\u0002\u0004\u0013:$\u0018aE7bqBKG-\u0012=qSJ\fG/[8o\u001bN\u0004\u0013\u0001\u0002;j[\u0016,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nx\u0003\u0015)H/\u001b7t\u0013\u0011\tI#a\t\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nQa]3u+B$\u0012\u0001\u001a\u0015\u0004!\u0005M\u0002\u0003BA\u001b\u0003\u0007j!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0004CBL'\u0002BA\u001f\u0003\u007f\tqA[;qSR,'OC\u0002\u0002Bq\fQA[;oSRLA!!\u0012\u00028\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!EA&!\u0011\t)$!\u0014\n\t\u0005=\u0013q\u0007\u0002\n\u0003\u001a$XM]#bG\"\f!\u0003^3ti\n\u000b7/[2JI6\u000b\u0007\u000f]5oO\"\u001a!#!\u0016\u0011\t\u0005U\u0012qK\u0005\u0005\u00033\n9D\u0001\u0003UKN$\u0018A\n;fgR\f\u0005\u000f]3oIRCh.T1sW\u0016\u0014x+\u001b;i\u001d>\u0004&o\u001c3vG\u0016\u00148\u000b^1uK\"\u001a1#!\u0016\u0002=Q,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f/J\f\u0007/\u0011:pk:$\u0007f\u0001\u000b\u0002V\u0005iC/Z:u!J|G-^2feN+\u0017/^3oG\u0016<\u0016\u000e\u001e5Xe\u0006\u0004\u0018I]8v]\u0012\u0014\u0015\r^2i%\u0016\u001cwN\u001d3)\u0007U\t)&A\u0013uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z%om\u0006d\u0017\u000eZ,sCB\f%o\\;oI\"\u001aa#!\u0016\u0002UQ,7\u000f\u001e(p-\u0006d\u0017\u000eZ1uS>twJ\u001c$jeN$XI\u001c;ss^CWM\u001c'pC\u0012Lgn\u001a'pO\"\u001aq#!\u0016\u0002GQ,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014HMQ;naN\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\"\u001a\u0001$!\u0016\u0002AQ,7\u000f\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1DC\u000eDW\r\u001a\u0015\u00043\u0005U\u0013!\u0007;fgR\u001c6.\u001b9F[B$\u0018\u0010\u0016:b]N\f7\r^5p]ND3AGA+\u0003\u0001\"Xm\u001d;MCN$8\u000b^1cY\u0016|eMZ:fi\u000e{W\u000e\u001d7fi\u0016$G\u000b\u001f8)\u0007m\t)&\u0001\u0010uKN$\bK]3qCJ,W\u000b\u001d3bi\u0016$u.Z:O_RlU\u000f^1uK\"\u001aA$!\u0016\u0002=U\u0004H-\u0019;f!J|G-^2feR\u0013\u0018M\\:bGRLwN\\*uCR,\u0007fA\u000f\u0002V\u0005aC/Z:u\u001fV$xJZ*fcV,gnY3BMR,'oQ8oiJ|GNU3d_J$W\t]8dQ\n+X\u000e\u001d\u0015\u0004=\u0005U\u0013\u0001\r;fgRtuN\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00119qK:$w+\u001b;i\u001f:<w.\u001b8h)J\fgn]1di&|g\u000eK\u0002 \u0003+\nq\u0006^3tiR\u0013XO\\2bi\u0016\fe\u000e\u001a*fY>\fGMU3n_Z,7oT;u\u001f\u001a\u0014\u0016M\\4f':\f\u0007o\u001d5piND3\u0001IA+\u0003A!Xm\u001d;UC.,7K\\1qg\"|G\u000fK\u0002\"\u0003+\nA\u0006^3tiJ+7m\u001c<fe\u001a\u0013x.\\*oCB\u001c\bn\u001c;V]\u001aLg.[:iK\u0012$&/\u00198tC\u000e$\u0018n\u001c8)\u0007\t\n)&\u0001\u0016uKN$(+Z2pm\u0016\u0014hI]8n':\f\u0007o\u001d5pi\u001aKg.[:iK\u0012$&/\u00198tC\u000e$\u0018n\u001c8)\u0007\r\n)&A\u0014uKN$(+Z2pm\u0016\u0014hI]8n':\f\u0007o\u001d5pi\u0016k\u0007\u000f^=Ue\u0006t7/Y2uS>t\u0007f\u0001\u0013\u0002V\u0005AC/Z:u!J|G-^2feN#\u0018\r^3BMR,'OR3oG&tw-\u00112peRl\u0015M]6fe\"\u001aQ%!\u0016\u0002;Q,7\u000f\u001e*f[>4X-\u0012=qSJ,G\rU5eg>s'+\u001a7pC\u0012D3AJA+\u00035\"Xm\u001d;BG\u000e,\u0007\u000f^!qa\u0016tGmV5uQ>,H\u000f\u0015:pIV\u001cWM]*uCR,wJ\u001c*fa2L7-\u0019\u0015\u0004O\u0005U\u0013!\u000b;fgR\f5mY3qi\u0006\u0003\b/\u001a8e/&$\bnU3rk\u0016t7-Z$baN|eNU3qY&\u001c\u0017\rK\u0002)\u0003+\n\u0011\u0004^3ti\u0012+G.\u001a;f':\f\u0007o\u001d5piN\u0014UMZ8sK\"\u001a\u0011&!\u0016\u00027Q,7\u000f\u001e+sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!uQ\rQ\u0013QK\u0001'i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKR\fe\r^3s)J,hnY1uS>t\u0007fA\u0016\u0002V\u0005qC/Z:u\u0019>\fGM\u0012:p[Ns\u0017\r]:i_R\u0014V\r^1j]NtuN\\#ya&\u0014X\r\u001a)s_\u0012,8-\u001a:tQ\ra\u0013QK\u0001\"i\u0016\u001cHoU6jaNs\u0017\r]:i_RLem\u00144gg\u0016$XK\\2iC:<W\r\u001a\u0015\u0004[\u0005U\u0013\u0001\u0007;fgR\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]RKW.Z8vi\"\u001aa&!\u0016\u0002/Q,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\bfA\u0018\u0002V\u0005qC/Z:u!J|G-^2feN<\u0016\u000e\u001e5P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t7\u000fR8oi\u0016C\b/\u001b:fQ\r\u0001\u0014QK\u0001.i\u0016\u001cHoU3rk\u0016t7-\u001a(piZ\u000bG.\u001b3bi\u0016$gi\u001c:He>,\b/T3uC\u0012\fG/\u0019+pa&\u001c\u0007fA\u0019\u0002V\u0005aB/Z:u\u001f2$W\t]8dQ\u001a{'oQ8oiJ|GNU3d_J$\u0007f\u0001\u001a\u0002V\u00051B/Z:u\u0007>|'\u000fZ5oCR|'OR3oG&tw\rK\u00024\u0003+\n\u0001\u0005^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$f]\u000e,G-\u00114uKJ\u0014V\r\\8bI\"\u001aA'!\u0016\u0002;Q,7\u000f\u001e'pC\u00124%o\\7F[B$\u0018p\u00158baNDw\u000e\u001e$jY\u0016D3!NA+\u0003\u0005\"Xm\u001d;M_\u0006$gI]8n)J,hnY1uK\u0012\u001cf.\u00199tQ>$h)\u001b7fQ\r1\u0014QK\u0001 i\u0016\u001cH\u000fT8bI\u001a\u0013x.\\\"peJ,\b\u000f^*oCB\u001c\bn\u001c;GS2,\u0007fA\u001c\u0002V\u0005YB/Z:u\u0003B\u0004XM\u001c3F[B$\u0018pQ8oiJ|GNQ1uG\"D3\u0001OA+\u0003E\"Xm\u001d;SK6|g/Z*ue\u0006L8K\\1qg\"|Go]&fKB\u001cE.Z1o'\",H\u000fZ8x]Ns\u0017\r]:i_RD3!OA+\u0003m!Xm\u001d;SK6|g/Z!mYN#(/Y=T]\u0006\u00048\u000f[8ug\"\u001a!(!\u0016\u0002IQ,7\u000f\u001e*f[>4X-\u00118e\u001b\u0006\u00148n\u00158baNDw\u000e\u001e$pe\u0012+G.\u001a;j_:D3aOA+\u0003I\"Xm\u001d;SK6|g/Z!oI6\u000b'o[*oCB\u001c\bn\u001c;G_J$U\r\\3uS>t\u0017\t\u001c:fC\u0012LH)\u001a7fi\u0016$\u0007f\u0001\u001f\u0002V\u0005YB/Z:u\u0019>\fGM\u0012:p[\u000e{'O];qiNs\u0017\r]:i_R$2\u0001\u001aB\u0004\u0011\u001d\u0011I!\u0010a\u0001\u0005\u0017\tq\"\\1lK\u001aKG.Z\"peJ,\b\u000f\u001e\t\u0007\u001f\n5!\u0011\u00033\n\u0007\t=\u0001KA\u0005Gk:\u001cG/[8ocA!!1\u0003B\u000f\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011\u0001C2iC:tW\r\\:\u000b\u0007\tma,A\u0002oS>LAAa\b\u0003\u0016\tYa)\u001b7f\u0007\"\fgN\\3m\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015!\t\u0015\"\u0011\u0007B\u001b\u0005o\u0011\tE!\u0015\u0003V\te\u0003#B(\u0003(\t-\u0012b\u0001B\u0015!\n1q\n\u001d;j_:\u00042a\u0016B\u0017\u0013\r\u0011y\u0003\u0013\u0002\r\u0007>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\u0005\u0007\u0005gq\u0004\u0019\u00017\u0002\u000f5\f\u0007\u000f]5oO\"9\u00111\u0001 A\u0002\u0005\u001d\u0001b\u0002B\u001d}\u0001\u0007!1H\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007=\u0013i$C\u0002\u0003@A\u0013Qa\u00155peRDqAa\u0011?\u0001\u0004\u0011)%A\u0006d_:$(o\u001c7UsB,\u0007\u0003\u0002B$\u0005\u001bj!A!\u0013\u000b\u0007\t-s/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005\u001f\u0012IEA\tD_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016DqAa\u0015?\u0001\u0004\t9!\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\n\u0005/r\u0004\u0013!a\u0001\u0003'\t\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u0013\tmc\b%AA\u0002\u0005\u001d\u0011!\u0003;j[\u0016\u001cH/Y7q\u0003q\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIY*\"A!\u0019+\t\u0005M!1M\u0016\u0003\u0005K\u0002BAa\u001a\u0003r5\u0011!\u0011\u000e\u0006\u0005\u0005W\u0012i'A\u0005v]\u000eDWmY6fI*\u0019!q\u000e)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003t\t%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3sI\u0011,g-Y;mi\u0012:TC\u0001B=U\u0011\t9Aa\u0019\u0002\r\u0005\u0004\b/\u001a8e)E!'q\u0010BA\u0005\u0007\u0013)I!#\u0003\f\n5%q\u0013\u0005\u0006U\u0006\u0003\r\u0001\u001c\u0005\b\u0003\u0007\t\u0005\u0019AA\u0004\u0011\u001d\u0011I$\u0011a\u0001\u0005wAqAa\"B\u0001\u0004\t\u0019\"A\u0002tKFDqAa\u0015B\u0001\u0004\t9\u0001C\u0005\u0003\\\u0005\u0003\n\u00111\u0001\u0002\b!I!qR!\u0011\u0002\u0003\u0007!\u0011S\u0001\u0010SN$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0019qJa%\n\u0007\tU\u0005KA\u0004C_>dW-\u00198\t\u0013\te\u0015\t%AA\u0002\tm\u0015AB8sS\u001eLg\u000eE\u0002X\u0005;K1Aa(I\u00051\t\u0005\u000f]3oI>\u0013\u0018nZ5o\u0003A\t\u0007\u000f]3oI\u0012\"WMZ1vYR$c'\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u0015\u0016\u0005\u0005#\u0013\u0019'\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!Q\u0016\u0016\u0005\u00057\u0013\u0019\u0007F\u0006e\u0005c\u0013\u0019L!.\u00038\n\u0005\u0007\"\u00026F\u0001\u0004a\u0007bBA\u0002\u000b\u0002\u0007\u0011q\u0001\u0005\b\u0005'*\u0005\u0019AA\u0004\u0011\u001d\u0011I,\u0012a\u0001\u0005w\u000bQAY1uG\"\u0004BAa\u0012\u0003>&!!q\u0018B%\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u000f\teU\t1\u0001\u0003\u001c\u000612-\u001e:sK:$8K\\1qg\"|Go\u00144gg\u0016$8/\u0006\u0002\u0003HB1!\u0011\u001aBl\u0003\u000fqAAa3\u0003TB\u0019!Q\u001a)\u000e\u0005\t='b\u0001Bi\u0019\u00061AH]8pizJ1A!6Q\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u001cBn\u0005\r\u0019V\r\u001e\u0006\u0004\u0005+\u0004\u0006")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean bl = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, bl, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 2020L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean bl = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, bl, (AppendOrigin)x$6);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean bl = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, bl, (AppendOrigin)x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.appendData$1(16L, 20L, firstAppend, producerEpoch, seq);
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), 16L), (Object)firstAppend.startedTransactions().head());
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(16L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition())), (Object)this.stateManager().firstUnstableOffset());
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option firstCompletedTxn = this.appendEndTxn$1(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(30L, 31L, secondAppend, producerEpoch, seq);
        Assertions.assertEquals((int)2, (int)secondAppend.startedTransactions().size());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Option)None$.MODULE$), (Object)secondAppend.startedTransactions().head());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Option)None$.MODULE$), (Object)secondAppend.startedTransactions().last());
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(30L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.messageOffset())));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 20L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Option completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isDefined());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assertions.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        AppendOrigin.Client$ client$3;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$3 = AppendOrigin.Client$.MODULE$;
        client$3 = null;
        AppendOrigin.Client$ x$8 = client$4;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$5 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$16 = client$5;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, (AppendOrigin)x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            AppendOrigin.Client$ client$;
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            long x$23 = this.append$default$6();
            AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
            client$ = null;
            AppendOrigin.Client$ x$24 = client$2;
            this.append(x$17, x$18, bumpedEpoch, 2, 2L, x$23, true, (AppendOrigin)x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            AppendOrigin.Client$ client$;
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            long x$31 = this.append$default$6();
            AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
            client$ = null;
            AppendOrigin.Client$ x$32 = client$2;
            this.append(x$25, x$26, x$27, 2, 2L, x$31, true, (AppendOrigin)x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        long x$39 = this.append$default$6();
        AppendOrigin.Client$ client$6 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$40 = client$6;
        this.append(x$33, x$34, bumpedEpoch, 0, 0L, x$39, true, (AppendOrigin)x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        AppendOrigin.Client$ client$;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            AppendOrigin.Client$ client$;
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            long x$15 = this.append$default$6();
            AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
            client$ = null;
            AppendOrigin.Client$ x$16 = client$2;
            this.append(x$9, x$10, epoch, 1, 1L, x$15, false, (AppendOrigin)x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())))), (String)"Snapshot file is empty");
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        AppendOrigin.Client$ client$3;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$3 = AppendOrigin.Client$.MODULE$;
        client$3 = null;
        AppendOrigin.Client$ x$8 = client$4;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$5 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$16 = client$5;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, (AppendOrigin)x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        long x$23 = this.append$default$6();
        AppendOrigin.Client$ client$6 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$24 = client$6;
        this.append(recoveredMapping, x$18, epoch, 2, 2L, x$23, true, (AppendOrigin)x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$3 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$8 = client$3;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$16 = client$4;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, (AppendOrigin)x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int n = 0;
        this.appendEndTxnMarker(x$1, x$2, epoch, ControlRecordType.ABORT, 0L, n, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isDefined());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        AppendOrigin.Client$ client$;
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, (AppendOrigin)x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)((Tuple2)recoveredMapping.activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        boolean bl = false;
        this.append(recoveredMapping, x$2, epoch, sequence, 2L, 70001L, bl, (AppendOrigin)x$7);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            AppendOrigin.Client$ x$7 = AppendOrigin.Client$.MODULE$;
            boolean bl = false;
            this.append(x$1, x$2, epoch, outOfOrderSequence, 1L, 1L, bl, (AppendOrigin)x$7);
        });
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        AppendOrigin.Replication$ x$15 = AppendOrigin.Replication$.MODULE$;
        boolean bl = false;
        this.append(x$9, x$10, epoch, outOfOrderSequence, 1L, 1L, bl, (AppendOrigin)x$15);
        Assertions.assertEquals((int)outOfOrderSequence, (int)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        AppendOrigin.Client$ client$;
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$72 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, sequence, 99L, x$72, true, (AppendOrigin)x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)((Tuple2)this.stateManager().activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        AppendOrigin.Client$ client$;
        AppendOrigin.Client$ client$2;
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$3 = client$2 = AppendOrigin.Client$.MODULE$;
        client$2 = null;
        AppendOrigin.Client$ x$82 = client$3;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$82);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$92 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin.Client$ client$4 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$16 = client$4;
        this.append(x$92, anotherPid, epoch, sequence, 105L, x$15, true, (AppendOrigin)x$16);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        AppendOrigin.Client$ client$;
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        short epoch = (short)0;
        long x$2 = this.producerId();
        AppendOrigin.Coordinator$ x$7 = AppendOrigin.Coordinator$.MODULE$;
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, -1, 99L, x$8, true, (AppendOrigin)x$7);
        long x$10 = this.producerId();
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, -1, 100L, x$16, true, (AppendOrigin)x$15);
    }

    @Test
    public void testOldEpochForControlRecord() {
        AppendOrigin.Client$ client$;
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        AppendOrigin.Client$ client$;
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, (AppendOrigin)x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        AppendOrigin.Client$ client$;
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin.Client$ client$2 = client$ = AppendOrigin.Client$.MODULE$;
        client$ = null;
        AppendOrigin.Client$ x$8 = client$2;
        this.append(x$1, x$2, producerEpoch, 0, 99L, x$7, true, (AppendOrigin)x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)42)), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 42})), (Object)((SeqOps)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.offset()))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{42L})));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{42})), (Object)((SeqOps)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.offset()))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        TopicPartition x$1 = this.partition();
        File x$2 = this.logDir();
        MockTime x$3 = this.time();
        int n = 3600000;
        ProducerStateManager manager = new ProducerStateManager(x$1, x$2, n, (Time)x$3);
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L);
        file.createNewFile();
        TopicPartition x$1 = this.partition();
        File x$2 = this.logDir();
        MockTime x$3 = this.time();
        int n = 3600000;
        ProducerStateManager manager = new ProducerStateManager(x$1, x$2, n, (Time)x$3);
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Files.delete(file.toPath());
        Assertions.assertTrue((boolean)manager.removeAndMarkSnapshotForDeletion(5L).isEmpty());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), false, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable)completedTxn -> {
            mapping.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)UnifiedLog$.MODULE$.offsetFromFile(file)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds());
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$3) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$3, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap(new byte[]{37}), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

