/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004E\u0001\u0001\u0006Ia\u000f\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019i\u0005\u0001)A\u0005\u000f\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002/\u0001A\u0003%\u0001\u000bC\u0004^\u0001\t\u0007I\u0011\u00010\t\r\u0011\u0004\u0001\u0015!\u0003`\u0011\u001d)\u0007A1A\u0005\u0002\u0019Daa\u001b\u0001!\u0002\u00139\u0007b\u00027\u0001\u0005\u0004%\tA\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B4\t\u000f9\u0004!\u0019!C\u0001_\"11\u000f\u0001Q\u0001\nADq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002<\t\u0013\u0005-\u0001A1A\u0005\u0002\u00055\u0001\u0002CA\u000b\u0001\u0001\u0006I!a\u0004\t\u0013\u0005]\u0001A1A\u0005\u0002\u00055\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0004\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005u\u0001\u0002CA.\u0001\u0001\u0006I!a\b\t\u0017\u0005u\u0003\u00011AA\u0002\u0013\u0005\u0011q\f\u0005\f\u0003o\u0002\u0001\u0019!a\u0001\n\u0003\tI\bC\u0006\u0002\u0006\u0002\u0001\r\u0011!Q!\n\u0005\u0005\u0004bCAD\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013C1\"!%\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0014\"Y\u0011q\u0013\u0001A\u0002\u0003\u0005\u000b\u0015BAF\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a-\u0001\t\u0003\tY\nC\u0004\u00028\u0002!\t!a'\t\u000f\u0005m\u0006\u0001\"\u0001\u0002\u001c\"9\u0011q\u0018\u0001\u0005\u0002\u0005m\u0005bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\n\u0003K\u0004\u0011\u0013!C\u0001\u0003OD\u0011\"!@\u0001#\u0003%\t!a@\t\u000f\t\r\u0001\u0001\"\u0001\u0002\u001c\"9!Q\u0002\u0001\u0005\u0002\t=!\u0001\u0007*fa2L7-Y'b]\u0006<WM])v_R\f7\u000fV3ti*\u0011!fK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00031\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001c\u0011\u0005a\u0002Q\"A\u0015\u0002\u000f\r|gNZ5hgV\t1\bE\u0002=\u007f\u0005k\u0011!\u0010\u0006\u0003}E\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0001UHA\u0002TKF\u0004\"\u0001\u000f\"\n\u0005\rK#aC&bM.\f7i\u001c8gS\u001e\f\u0001bY8oM&<7\u000fI\u0001\u0005i&lW-F\u0001H!\tA5*D\u0001J\u0015\tQ5&A\u0003vi&d7/\u0003\u0002M\u0013\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003A\u0003\"!\u0015.\u000e\u0003IS!AT*\u000b\u0005Q+\u0016AB2p[6|gN\u0003\u0002--*\u0011q\u000bW\u0001\u0007CB\f7\r[3\u000b\u0003e\u000b1a\u001c:h\u0013\tY&KA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\naA]3d_J$W#A0\u0011\u0005\u0001\u0014W\"A1\u000b\u0005u\u001b\u0016BA2b\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0003\u001d\u0011XmY8sI\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.M\u000b\u0002OB\u0011\u0001.[\u0007\u0002'&\u0011!n\u0015\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004%A\bu_BL7\rU1si&$\u0018n\u001c83\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004%A\u0004u_BL7-\u00133\u0016\u0003A\u0004\"\u0001[9\n\u0005I\u001c&\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\ti>\u0004\u0018nY%egV\ta\u000f\u0005\u0003xyz\u0004X\"\u0001=\u000b\u0005eT\u0018\u0001B;uS2T\u0011a_\u0001\u0005U\u00064\u0018-\u0003\u0002~q\n\u0019Q*\u00199\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001>\u0002\t1\fgnZ\u0005\u0005\u0003\u000f\t\tA\u0001\u0004TiJLgnZ\u0001\ni>\u0004\u0018nY%eg\u0002\n\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c82+\t\ty\u0001E\u0002i\u0003#I1!a\u0005T\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\nu_BL7-\u00133QCJ$\u0018\u000e^5p]F\u0002\u0013!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oe\u0005\u0011Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u001a!\u0003%1W\r^2i\u0013:4w.\u0006\u0002\u0002 A1\u0011\u0011EA\u0014\u0003Si!!a\t\u000b\u0007\u0005\u0015R(A\u0005j[6,H/\u00192mK&\u0019\u0001)a\t\u0011\u000fA\nY#a\u0004\u00020%\u0019\u0011QF\u0019\u0003\rQ+\b\u000f\\33!\u0011\t\t$!\u0016\u000f\t\u0005M\u0012q\n\b\u0005\u0003k\tYE\u0004\u0003\u00028\u0005%c\u0002BA\u001d\u0003\u000frA!a\u000f\u0002F9!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B5\na\u0001\u0010:p_Rt\u0014\"A-\n\u0005]C\u0016B\u0001\u0017W\u0013\t!V+C\u0002\u0002NM\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003#\n\u0019&\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cHOC\u0002\u0002NMKA!a\u0016\u0002Z\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006TA!!\u0015\u0002T\u0005Qa-\u001a;dQ&sgm\u001c\u0011\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0016\u0005\u0005\u0005\u0004\u0003BA2\u0003crA!!\u001a\u0002n9!\u0011qMA6\u001d\u0011\ti$!\u001b\n\u00031J!AK\u0016\n\u0007\u0005=\u0014&\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002t\u0005U$!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002p%\n\u0001#];pi\u0006l\u0015M\\1hKJ|F%Z9\u0015\t\u0005m\u0014\u0011\u0011\t\u0004a\u0005u\u0014bAA@c\t!QK\\5u\u0011%\t\u0019)GA\u0001\u0002\u0004\t\t'A\u0002yIE\nQ\"];pi\u0006l\u0015M\\1hKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003\u0017\u00032\u0001OAG\u0013\r\ty)\u000b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\t\u0005m\u0014Q\u0013\u0005\n\u0003\u0007c\u0012\u0011!a\u0001\u0003\u0017\u000bqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001+g\"|W\u000f\u001c3Fq\u000edW\u000fZ3Tk\n\u001cX-];f]R$\u0006N]8ui2,G\rU1si&$\u0018n\u001c8t)\t\tY\bK\u0002\u001f\u0003?\u0003B!!)\u000206\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0002ba&TA!!+\u0002,\u00069!.\u001e9ji\u0016\u0014(bAAW1\u0006)!.\u001e8ji&!\u0011\u0011WAR\u0005\u0011!Vm\u001d;\u0002sMDw.\u001e7e\u000f\u0016$hj\\'fgN\fw-Z:JMF+x\u000e^1t\u000bb\u001cW-\u001a3fI>s7+\u001e2tKF,XM\u001c;QCJ$\u0018\u000e^5p]ND3aHAP\u0003\t\u001a\bn\\;mI\u001e+GOQ8uQ6+7o]1hKNLe-U;pi\u0006\u001c\u0018\t\u001c7po\"\u001a\u0001%a(\u0002IMDw.\u001e7e\u0013:\u001cG.\u001e3f\u0013:\u001c\u0016P\\2UQJ|G\u000f\u001e7fIJ+\u0007\u000f\\5dCND3!IAP\u0003=\"Xm\u001d;D_6\u0004H.\u001a;f\u0013:$U\r\\1zK\u00124U\r^2i/&$\bNU3qY&\u001c\u0017\r\u00165s_R$H.\u001b8hQ\r\u0011\u0013qT\u0001\u000bg\u0016$X\u000b]'pG.\u001cH\u0003CA>\u0003\u000f\fI.a7\t\u000f\u0005m1\u00051\u0001\u0002JB1\u00111ZAk\u0003SqA!!4\u0002R:!\u0011QHAh\u0013\u0005\u0011\u0014bAAjc\u00059\u0001/Y2lC\u001e,\u0017b\u0001!\u0002X*\u0019\u00111[\u0019\t\u000fu\u001b\u0003\u0013!a\u0001?\"I\u0011Q\\\u0012\u0011\u0002\u0003\u0007\u0011q\\\u0001\u0013E>$\bNU3qY&\u001c\u0017m]%o'ft7\rE\u00021\u0003CL1!a92\u0005\u001d\u0011un\u001c7fC:\fAc]3u+BlunY6tI\u0011,g-Y;mi\u0012\u0012TCAAuU\ry\u00161^\u0016\u0003\u0003[\u0004B!a<\u0002z6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\f)0A\u0005v]\u000eDWmY6fI*\u0019\u0011q_\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002|\u0006E(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!2/\u001a;Va6{7m[:%I\u00164\u0017-\u001e7uIM*\"A!\u0001+\t\u0005}\u00171^\u0001\ti\u0016\f'\u000fR8x]\"\u001aaEa\u0002\u0011\t\u0005\u0005&\u0011B\u0005\u0005\u0005\u0017\t\u0019KA\u0005BMR,'/R1dQ\u0006IQn\\2l#V|G/\u0019\u000b\u0005\u0005#\u00119\u0002E\u00029\u0005'I1A!\u0006*\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0011\u001d\u0011Ib\na\u0001\u00057\tQAY8v]\u0012\u00042\u0001\rB\u000f\u0013\r\u0011y\"\r\u0002\u0005\u0019>tw\r")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$1 -> {
        Properties fromProps_overrides = new Properties();
        return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
    });
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Uuid topicId = Uuid.randomUuid();
    private final java.util.Map<String, Uuid> topicIds = Collections.singletonMap("test-topic", this.topicId());
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId(), this.topicPartition1());
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId(), this.topicPartition2());
    private final scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition1()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition2()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty()))}));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public java.util.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public TopicIdPartition topicIdPartition1() {
        return this.topicIdPartition1;
    }

    public TopicIdPartition topicIdPartition2() {
        return this.topicIdPartition2;
    }

    public scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala().size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$6))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$7))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both throttled, we should get no messages");
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$8))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$9))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> x$1 = this.fetchInfo();
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, true);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$10))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$11))).get())._2()).info().records().batches()).asScala().size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    /*
     * WARNING - void declaration
     */
    public void setUpMocks(scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        ZkMetadataCache zkMetadataCache;
        void withRecords_records;
        void withRecords_timestampType;
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        UnifiedLog log = (UnifiedLog)EasyMock.createNiceMock(UnifiedLog.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)5L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)5L)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition())).anyTimes();
        EasyMock.expect((Object)log.topicId()).andReturn((Object)new Some((Object)this.topicId())).anyTimes();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{record};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var26_7 = null;
        simpleRecordArray = null;
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), false, (Option)None$.MODULE$)).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$)).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        AlterIsrManager alterIsrManager = (AlterIsrManager)EasyMock.createMock(AlterIsrManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(leaderBrokerId);
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$7 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$122 = none$7;
        None$ none$8 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$13 = none$8;
        None$ none$9 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$14 = none$9;
        None$ none$10 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$15 = none$10;
        None$ none$11 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$16 = none$11;
        None$ none$12 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$12;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, (Scheduler)scheduler, logManager, x$6, (MetadataCache)x$7, x$8, alterIsrManager, x$10, x$11, (Option)x$122, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17));
        fetchInfo.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$12 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$12);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$13 -> {
            x$13.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$10) {
        Object object = x$10._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$11) {
        Object object = x$11._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getPartitionOrException((TopicPartition)EasyMock.anyObject())).andReturn((Object)partition).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)EasyMock.anyObject(), (Partition)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject())))).andReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0)).anyTimes();
        EasyMock.expect((Object)partition.getReplica(1)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{replicaManager, partition});
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp, (Object)fetchPartitionStatus)})));
        return new DelayedFetch(null, fetchMetadata, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, UnifiedLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$12) {
        if (x$12 != null) {
            TopicIdPartition p = (TopicIdPartition)x$12._1();
            Partition partition = $this.replicaManager().createPartition(p.topicPartition());
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty());
            return;
        }
        throw new MatchError(null);
    }
}

