/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u0005\u000b\u0001=AQ\u0001\u0006\u0001\u0005\u0002UAQa\u0006\u0001\u0005BaAQa\b\u0001\u0005B\u0001BQA\u000b\u0001\u0005\u0002-BQ\u0001\u0010\u0001\u0005\nuBQ!\u0011\u0001\u0005\n\tCQ!\u0015\u0001\u0005\u0002ICQ!\u001c\u0001\u0005\n9\u0014a%T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\"fi^,WM\u001c#jM\u001a,'/\u001a8u\u0013\n\u0004H+Z:u\u0015\tYA\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u000b\u0013\t\u0019\"BA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0012\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"aA%oi\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\"!\r\u0011SeJ\u0007\u0002G)\u0011AeG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0014$\u0005\r\u0019V-\u001d\t\u0003#!J!!\u000b\u0006\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0013i\u0016\u001cH/\u00168l]><h\u000eV8qS\u000eLE\rF\u0001-!\tQR&\u0003\u0002/7\t!QK\\5uQ\t!\u0001\u0007\u0005\u00022u5\t!G\u0003\u00024i\u0005\u0019\u0011\r]5\u000b\u0005U2\u0014a\u00026va&$XM\u001d\u0006\u0003oa\nQA[;oSRT\u0011!O\u0001\u0004_J<\u0017BA\u001e3\u0005\u0011!Vm\u001d;\u0002%\u0015t7/\u001e:f\u0007>tGO]8mY\u0016\u0014\u0018J\u001c\u000b\u0003YyBQaP\u0003A\u0002\u0001\u000b\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\u0007\t*\u0013$\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\rF\u0002(\u0007\u0016CQ\u0001\u0012\u0004A\u0002e\taA\\8eK&#\u0007\"\u0002$\u0007\u0001\u00049\u0015AE5oi\u0016\u0014(I]8lKJ4VM]:j_:\u0004\"\u0001S(\u000e\u0003%S!AS&\u0002\r\r|W.\\8o\u0015\tYAJ\u0003\u0002\u000e\u001b*\u0011a\nO\u0001\u0007CB\f7\r[3\n\u0005AK%aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002\u0017I,\u0017/^3ti\u0012\u000bG/\u0019\u000b\u0004'j;\u0007C\u0001+Y\u001b\u0005)&B\u0001,X\u0003\u001diWm]:bO\u0016T!A\u0013'\n\u0005e+&aE'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f\u0007\"B.\b\u0001\u0004a\u0016!\u0002;pa&\u001c\u0007CA/e\u001d\tq&\r\u0005\u0002`75\t\u0001M\u0003\u0002b\u001d\u00051AH]8pizJ!aY\u000e\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GnAQ\u0001[\u0004A\u0002%\fq\u0001^8qS\u000eLE\r\u0005\u0002kW6\tq+\u0003\u0002m/\n!Q+^5e\u0003M\u0019XM\u001c3NKR\fG-\u0019;b%\u0016\fX/Z:u)\ryWO\u001f\t\u0003aNl\u0011!\u001d\u0006\u0003e^\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003iF\u0014\u0001#T3uC\u0012\fG/\u0019*fgB|gn]3\t\u000bYD\u0001\u0019A<\u0002\u000fI,\u0017/^3tiB\u0011\u0001\u000f_\u0005\u0003sF\u0014q\"T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u0005\u0006w\"\u0001\r\u0001`\u0001\fI\u0016\u001cH/\u001b8bi&|g\u000eE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f2\tqA\\3uo>\u00148.C\u0002\u0002\u0004y\u0014AbU8dW\u0016$8+\u001a:wKJ\u0004")
public class MetadataRequestBetweenDifferentIbpTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)this.createConfig(0, MetadataVersion.IBP_2_8_IV0), (List)new .colon.colon((Object)this.createConfig(1, MetadataVersion.latest()), (List)new .colon.colon((Object)this.createConfig(2, MetadataVersion.latest()), (List)Nil$.MODULE$)));
    }

    @Test
    public void testUnknownTopicId() {
        String topic = "topic";
        this.ensureControllerIn((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}))), this.createTopicWithAssignment$default$3());
        Uuid topicId = ((MetadataResponse.TopicMetadata)this.sendMetadataRequest(new MetadataRequest(this.requestData(topic, Uuid.ZERO_UUID), (short)12), this.controllerSocketServer()).topicMetadata().iterator().next()).topicId();
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)this.sendMetadataRequest(new MetadataRequest(this.requestData(null, topicId), (short)12), this.controllerSocketServer()).topicMetadata().iterator().next();
        Assertions.assertEquals((Object)topicId, (Object)topicMetadata.topicId());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.topic());
        this.ensureControllerIn((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.killBroker(1);
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        MetadataResponse resp2 = this.sendMetadataRequest(new MetadataRequest(this.requestData(topic, topicId), (short)12), this.brokerSocketServer(1));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_ID, (Object)((MetadataResponse.TopicMetadata)resp2.topicMetadata().iterator().next()).error());
    }

    private void ensureControllerIn(Seq<Object> brokerIds) {
        while (!brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)this.controllerSocketServer().config().brokerId()))) {
            this.zkClient().deleteController(ZkVersion$.MODULE$.MatchAnyVersion());
            TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        }
    }

    private KafkaConfig createConfig(int nodeId, MetadataVersion interBrokerVersion) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerVersion.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    /*
     * WARNING - void declaration
     */
    public MetadataRequestData requestData(String topic, Uuid topicId) {
        void var3_3;
        MetadataRequestData data = new MetadataRequestData();
        data.topics().add(new MetadataRequestData.MetadataRequestTopic().setName(topic).setTopicId(topicId));
        return var3_3;
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, SocketServer destination) {
        return (MetadataResponse)this.connectAndReceive((AbstractRequest)request, destination, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }
}

