/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.controller.ControllerStats;
import kafka.network.Processor;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001B\u0017/\u0001MBQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013\u0005q\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0003Q\u0005B\u0002(\u0001A\u0003%1\nC\u0004P\u0001\u0001\u0007I\u0011\u0001)\t\u000fe\u0003\u0001\u0019!C\u00015\"1\u0001\r\u0001Q!\nECq!\u0019\u0001A\u0002\u0013\u0005\u0001\u000bC\u0004c\u0001\u0001\u0007I\u0011A2\t\r\u0015\u0004\u0001\u0015)\u0003R\u0011\u001d1\u0007\u00011A\u0005\u0002\u001dDq!\u001d\u0001A\u0002\u0013\u0005!\u000f\u0003\u0004u\u0001\u0001\u0006K\u0001\u001b\u0005\bk\u0002\u0001\r\u0011\"\u0001w\u0011\u001dY\b\u00011A\u0005\u0002qDaA \u0001!B\u00139\b\u0002C@\u0001\u0005\u0004%\t!!\u0001\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0004\u0001\u0005\u0004%\t!!\u0005\t\u0011\u0005}\u0001\u0001)A\u0005\u0003'A\u0001\"!\t\u0001\u0005\u0004%\ta\u0010\u0005\b\u0003G\u0001\u0001\u0015!\u0003A\u0011%\t)\u0003\u0001b\u0001\n\u0003\t9\u0003\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u0015\u0011%\ty\u0004\u0001b\u0001\n\u0003\t9\u0003\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0015\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000bBq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005u\u0004\u0001\"\u0001\u0002j!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0004bBAF\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003\u001f\u0003A\u0011AA5\u0011\u001d\t\u0019\n\u0001C\u0001\u0003SBq!a&\u0001\t\u0003\tI\u0007C\u0004\u0002\u001a\u0002!\t!!\u001b\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBAa\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\tY\u000f\u0001C\u0005\u0003[\u0014\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u0011q\u0006M\u0001\fS:$Xm\u001a:bi&|gNC\u00012\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]\u0002\u0014AB:feZ,'/\u0003\u0002:m\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005a\u0004CA\u001f\u0001\u001b\u0005q\u0013!\u00032s_.,'/\u001332+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%aA%oi\u0006Q!M]8lKJLE-\r\u0011\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0014\u0014A\u00032s_.,'/\u001333A\u0005ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\u0016\u0003-\u0003\"!\u0011'\n\u00055\u0013%a\u0002\"p_2,\u0017M\\\u0001\u001aK:\f'\r\\3D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007%\u0001\u0007d_:4\u0017n\u001a)s_B\u001c\u0018'F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0003vi&d'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003A\u0019wN\u001c4jOB\u0013x\u000e]:2?\u0012*\u0017\u000f\u0006\u0002\\=B\u0011\u0011\tX\u0005\u0003;\n\u0013A!\u00168ji\"9q,CA\u0001\u0002\u0004\t\u0016a\u0001=%c\u0005i1m\u001c8gS\u001e\u0004&o\u001c9tc\u0001\nAbY8oM&<\u0007K]8qgJ\n\u0001cY8oM&<\u0007K]8qgJzF%Z9\u0015\u0005m#\u0007bB0\r\u0003\u0003\u0005\r!U\u0001\u000eG>tg-[4Qe>\u00048O\r\u0011\u0002\u000f\r|gNZ5hgV\t\u0001\u000eE\u0002jY:l\u0011A\u001b\u0006\u0003W\n\u000b!bY8mY\u0016\u001cG/[8o\u0013\ti'NA\u0002TKF\u0004\"!N8\n\u0005A4$aC&bM.\f7i\u001c8gS\u001e\f1bY8oM&<7o\u0018\u0013fcR\u00111l\u001d\u0005\b?>\t\t\u00111\u0001i\u0003!\u0019wN\u001c4jON\u0004\u0013aB:feZ,'o]\u000b\u0002oB\u0019\u0011\u000e\u001c=\u0011\u0005UJ\u0018B\u0001>7\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u00037vDqa\u0018\n\u0002\u0002\u0003\u0007q/\u0001\u0005tKJ4XM]:!\u0003\u0019\u0011\u0018M\u001c3p[V\u0011\u00111\u0001\t\u0005\u0003\u000b\tI!\u0004\u0002\u0002\b)\u0011AKQ\u0005\u0005\u0003\u0017\t9A\u0001\u0004SC:$w.\\\u0001\be\u0006tGm\\7!\u0003\u0015!x\u000e]5d+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"V\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001e\u0005]!AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\fa\u0006\u0014H/\u001b;j_:LE-\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007%A\blC\u001a\\\u0017-\u00119jg2{wmZ3s+\t\tI\u0003\u0005\u0003\u0002,\u0005eRBAA\u0017\u0015\u0011\ty#!\r\u0002\u000b1|w\r\u000e6\u000b\t\u0005M\u0012QG\u0001\u0007CB\f7\r[3\u000b\u0005\u0005]\u0012aA8sO&!\u00111HA\u0017\u0005\u0019aunZ4fe\u0006\u00012.\u00194lC\u0006\u0003\u0018n\u001d'pO\u001e,'\u000fI\u0001\u0017]\u0016$xo\u001c:l!J|7-Z:t_JdunZ4fe\u00069b.\u001a;x_J\\\u0007K]8dKN\u001cxN\u001d'pO\u001e,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00047\u0006\u001d\u0003bBA%=\u0001\u0007\u00111J\u0001\ti\u0016\u001cH/\u00138g_B!\u0011QJA.\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013aA1qS*!\u0011QKA,\u0003\u001dQW\u000f]5uKJTA!!\u0017\u00026\u0005)!.\u001e8ji&!\u0011QLA(\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\u0010\u0002bA!\u0011QJA2\u0013\u0011\t)'a\u0014\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005Y\u0006fA\u0010\u0002nA!\u0011QJA8\u0013\u0011\t\t(a\u0014\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001D:uCJ$(I]8lKJ\u001cHcA.\u0002x!9\u0011\u0011\u0010\u0011A\u0002\u0005m\u0014aB2mkN$XM\u001d\t\u0004S2\f\u0016\u0001\t;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012D3!IAA!\u0011\ti%a!\n\t\u0005\u0015\u0015q\n\u0002\u0005)\u0016\u001cH/A\u0011uKN$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tG)[:bE2,G\rK\u0002#\u0003\u0003\u000bq\u0006^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016D3aIAA\u0003A\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3e\u0005f$v\u000e]5d\u001fZ,'O]5eK\"\u001aA%!!\u0002[Q,7\u000f^+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\%om\u0006d\u0017\u000e\u001a+pa&\u001cwJ^3se&$W\rK\u0002&\u0003\u0003\u000b!E^3sS\u001aLXK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0017a\t<fe&4\u00170\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eR5tC\ndW\rZ\u0001\u000fg\",H\u000fZ8x]N+'O^3s)\rY\u0016q\u0014\u0005\u0006o!\u0002\r\u0001_\u0001\u0013G>t7/^7f\u00032dW*Z:tC\u001e,7\u000f\u0006\u0004\u0002&\u0006m\u0016Q\u0018\t\u0005S2\f9\u000b\u0005\u0003\u0002*\u0006]f\u0002BAV\u0003g\u00032!!,C\u001b\t\tyKC\u0002\u00022J\na\u0001\u0010:p_Rt\u0014bAA[\u0005\u00061\u0001K]3eK\u001aLA!!\b\u0002:*\u0019\u0011Q\u0017\"\t\u000f\u0005=\u0011\u00061\u0001\u0002(\"1\u0011qX\u0015A\u0002\u0001\u000b1B\\;n\u001b\u0016\u001c8/Y4fg\u0006!C/Z:u)>\u0004\u0018nY+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\rK\u0002+\u0003\u0003\u000b\u0011#\u00197uKJ$v\u000e]5d\u0007>tg-[4t)!\tI-a7\u0002f\u0006\u001d\b\u0003BAf\u0003/l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003'\f).A\u0004dY&,g\u000e^:\u000b\u0007E\n\t$\u0003\u0003\u0002Z\u00065'AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDq!!8,\u0001\u0004\ty.A\u0006bI6Lgn\u00117jK:$\b\u0003BAf\u0003CLA!a9\u0002N\n)\u0011\tZ7j]\"9\u0011qB\u0016A\u0002\u0005\u001d\u0006BBAuW\u0001\u0007\u0011+\u0001\u0007u_BL7mQ8oM&<7/A\tde\u0016\fG/Z!e[&t7\t\\5f]R$\"!a8")
public class UncleanLeaderElectionTest
extends QuorumTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1 = null;
    private Properties configProps2 = null;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))).foreach((Function1 & Serializable)configProps -> {
            configProps.put("controlled.shutdown.enable", Boolean.toString(this.enableControlledShutdown()));
            configProps.put("controlled.shutdown.max.retries", "1");
            return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.servers().foreach((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)server -> {
            CoreUtils$.MODULE$.delete(server.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUncleanLeaderElectionEnabled() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabled() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        Assertions.assertThrows(ConfigException.class, () -> TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})))}))), this.servers(), topicProps));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        None$ none$;
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, server)))).map((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable)x$1 -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(x$1);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)this.servers().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$6(leaderId, x$2)))).map((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$8(followerId, x$3))).get();
        followerServer.startup();
        KafkaZkClient x$32 = this.zkClient();
        String x$4 = this.topic();
        int x$5 = this.partitionId();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long l = 30000L;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$2;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$32, x$4, x$5, l, (Option<Object>)x$8, (Option<Object>)x$6);
        Assertions.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first", "third"})), this.consumeAllMessages(this.topic(), 2));
    }

    public void verifyUncleanLeaderElectionDisabled() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic(), 1));
        ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, server)))).foreach((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic(), 2));
        this.servers().foreach((Function1 & Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(server);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$6(leaderId, server)))).foreach((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$8(followerId, x$4))).get();
        followerServer.startup();
        KafkaZkClient x$3 = this.zkClient();
        String x$42 = this.topic();
        int x$5 = this.partitionId();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        long l = 30000L;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$4;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$42, x$5, l, (Option<Object>)x$8, (Option<Object>)x$6);
        Assertions.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaServer> x$9 = this.servers();
            String x$10 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$9, x$10, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$10(leaderId, server)))).foreach((Function1 & Serializable)server -> {
            server.startup();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$15 = this.zkClient();
        String x$16 = this.topic();
        int x$17 = this.partitionId();
        Some x$18 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        long l2 = 30000L;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$20 = none$5;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$15, x$16, x$17, l2, (Option<Object>)x$20, (Option<Object>)x$18);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", null, 30000, 20000);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$12(this, followerServer, followerId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l3) {
                Assertions.fail((String)"Inconsistent metadata after first server startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$14(leaderId, server)))).foreach((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$21 = this.zkClient();
        String x$22 = this.topic();
        int x$23 = this.partitionId();
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long l5 = 30000L;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$26 = none$6;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$21, x$22, x$23, l5, (Option<Object>)x$26, (Option<Object>)x$24);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second", "third"})), this.consumeAllMessages(this.topic(), 3));
    }

    private void shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        ByteArrayDeserializer byteArrayDeserializer;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String brokerList = TestUtils$.MODULE$.plaintextBootstrapServers(this.servers());
        String x$2 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        StringDeserializer x$4 = new StringDeserializer();
        String string2 = string = "earliest";
        string = null;
        String x$52 = string2;
        boolean bl = false;
        int n = 500;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$8 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$4;
        ByteArrayDeserializer byteArrayDeserializer2 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer2;
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, x$52, false, bl, n, x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$4);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, 15000L).map((Function1 & Serializable)x$5 -> (String)x$5.value());
        }
        return seq;
    }

    @Test
    public void testTopicUncleanLeaderElectionEnable() {
        None$ none$;
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.topic();
        Properties x$2 = new Properties();
        Map x$3 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        qual$1.createTopicWithAssignment(x$1, x$2, x$3, x$4, x$5);
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$1(followerId, server)))).map((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$3(server);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$4(leaderId, server)))).map((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$6(followerId, x$6))).get();
        followerServer.startup();
        Assertions.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaServer> x$8 = this.servers();
            String x$9 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$8, x$9, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        Admin adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
        adminClient.close();
        KafkaZkClient x$14 = this.zkClient();
        String x$15 = this.topic();
        int x$16 = this.partitionId();
        Some x$17 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long l = 30000L;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$19 = none$2;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$14, x$15, x$16, l, (Option<Object>)x$19, (Option<Object>)x$17);
        Assertions.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first", "third"})), this.consumeAllMessages(this.topic(), 2));
    }

    private AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfigs).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            ConfigEntry configEntry = new ConfigEntry(k, v);
            return configEntry;
        })).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(this.servers());
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaServer kafkaServer;
        void createServer_time;
        KafkaServer kafkaServer2;
        Time time;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        KafkaServer kafkaServer3 = kafkaServer2 = createServer_this.createServer(config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, true);
        Object var6_6 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer4 = kafkaServer = kafkaServer3;
        Object var4_5 = null;
        time3 = null;
        kafkaServer = null;
        KafkaServer server = kafkaServer4;
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{config})))));
        $this.servers_$eq((Seq<KafkaServer>)((Seq)$this.servers().$plus$plus((IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})))));
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaServer server) {
        return server.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionEnabled$5(KafkaServer x$1) {
        ControllerStats qual$1 = x$1.kafkaController().controllerContext().stats();
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric("UncleanLeaderElectionsPerSec", x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$6(int leaderId$1, KafkaServer x$2) {
        return x$2.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$8(int followerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaServer server) {
        return server.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionDisabled$5(KafkaServer server) {
        ControllerStats qual$1 = server.kafkaController().controllerContext().stats();
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric("UncleanLeaderElectionsPerSec", x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$6(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$8(int followerId$2, KafkaServer x$4) {
        return x$4.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$10(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$12(UncleanLeaderElectionTest $this, KafkaServer followerServer$1, int followerId$2) {
        Option partitionInfoOpt = followerServer$1.metadataCache().getPartitionInfo($this.topic(), $this.partitionId());
        return partitionInfoOpt.isDefined() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)followerId$2));
    }

    public static final /* synthetic */ String $anonfun$verifyUncleanLeaderElectionDisabled$13() {
        return "Inconsistent metadata after first server startup";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$14(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$1(int followerId$3, KafkaServer server) {
        return server.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ void $anonfun$testTopicUncleanLeaderElectionEnable$3(KafkaServer server) {
        ControllerStats qual$2 = server.kafkaController().controllerContext().stats();
        Map x$7 = qual$2.removeMetric$default$2();
        qual$2.removeMetric("UncleanLeaderElectionsPerSec", x$7);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$4(int leaderId$3, KafkaServer server) {
        return server.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$6(int followerId$3, KafkaServer x$6) {
        return x$6.config().brokerId() == followerId$3;
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

