/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotasTest$ListenerDesc$;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Implicits;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001db\u0001B1c\u0001\u001dDQA\u001c\u0001\u0005\u0002=D\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011B:\t\u0017\u0005\u0005\u0001\u00011AA\u0002\u0013%\u00111\u0001\u0005\u000b\u0003\u001f\u0001\u0001\u0019!A!B\u0013!\bbCA\t\u0001\u0001\u0007\t\u0019!C\u0005\u0003'A1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,!Y\u0011q\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000b\u0011-\t\t\u0004\u0001a\u0001\u0002\u0004%I!a\r\t\u0017\u0005m\u0002\u00011AA\u0002\u0013%\u0011Q\b\u0005\f\u0003\u0003\u0002\u0001\u0019!A!B\u0013\t)\u0004C\u0006\u0002D\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0003bCA*\u0001\u0001\u0007\t\u0019!C\u0005\u0003+B1\"!\u0017\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H!I\u00111\f\u0001C\u0002\u0013%\u0011Q\f\u0005\t\u0005{\u0001\u0001\u0015!\u0003\u0002`!I!q\b\u0001C\u0002\u0013%!\u0011\t\u0005\t\u0005G\u0002\u0001\u0015!\u0003\u0003D!I!Q\r\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0005O\u0002\u0001\u0015!\u0003\u00022\"I!\u0011\u000e\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0005W\u0002\u0001\u0015!\u0003\u00022\"I!Q\u000e\u0001C\u0002\u0013%!1\u0001\u0005\t\u0005_\u0002\u0001\u0015!\u0003\u0003\u0006!I!\u0011\u000f\u0001C\u0002\u0013%!1\u0001\u0005\t\u0005g\u0002\u0001\u0015!\u0003\u0003\u0006!I!Q\u000f\u0001C\u0002\u0013%!q\u000f\u0005\t\u0005\u007f\u0002\u0001\u0015!\u0003\u0003z\u00191\u00111\u0010\u0001A\u0003{B!\"!(\u001d\u0005+\u0007I\u0011AAP\u0011)\tY\u000b\bB\tB\u0003%\u0011\u0011\u0015\u0005\u000b\u0003[c\"Q3A\u0005\u0002\u0005=\u0006BCA_9\tE\t\u0015!\u0003\u00022\"1a\u000e\bC\u0001\u0003\u007fCq!!2\u001d\t\u0003\n9\rC\u0005\u0002Xr\t\t\u0011\"\u0001\u0002Z\"I\u0011q\u001c\u000f\u0012\u0002\u0013\u0005\u0011\u0011\u001d\u0005\n\u0003od\u0012\u0013!C\u0001\u0003sD\u0011\"!@\u001d\u0003\u0003%\t%a@\t\u0013\t\u0005A$!A\u0005\u0002\t\r\u0001\"\u0003B\u00069\u0005\u0005I\u0011\u0001B\u0007\u0011%\u00119\u0002HA\u0001\n\u0003\u0012I\u0002C\u0005\u0003\"q\t\t\u0011\"\u0001\u0003$!I!Q\u0006\u000f\u0002\u0002\u0013\u0005#q\u0006\u0005\n\u0005ga\u0012\u0011!C!\u0005kA\u0011Ba\u000e\u001d\u0003\u0003%\tE!\u000f\b\u0013\t\u0005\u0005!!A\t\u0002\t\re!CA>\u0001\u0005\u0005\t\u0012\u0001BC\u0011\u0019qw\u0006\"\u0001\u0003\u001e\"I\u0011QY\u0018\u0002\u0002\u0013\u0015#q\u0014\u0005\n\u0005C{\u0013\u0011!CA\u0005GC\u0011B!+0\u0003\u0003%\tIa+\t\u000f\tu\u0006\u0001\"\u0001\u0003@\"9!\u0011\u001a\u0001\u0005\n\t-\u0007b\u0002Bg\u0001\u0011\u0005!1\u001a\u0005\b\u0005K\u0004A\u0011\u0001Bf\u0011\u001d\u0011y\u000f\u0001C\u0001\u0005\u0017DqA!?\u0001\t\u0003\u0011Y\rC\u0004\u0003~\u0002!\tAa3\t\u000f\r\u0005\u0001\u0001\"\u0001\u0003L\"91Q\u0001\u0001\u0005\u0002\t-\u0007bBB\u0005\u0001\u0011\u0005!1\u001a\u0005\b\u0007\u001b\u0001A\u0011\u0001Bf\u0011\u001d\u0019\t\u0002\u0001C\u0001\u0005\u0017Dqa!\u0006\u0001\t\u0003\u0011Y\rC\u0004\u0004\u001a\u0001!\tAa3\t\u000f\ru\u0001\u0001\"\u0001\u0003L\"91\u0011\u0005\u0001\u0005\u0002\t-\u0007bBB\u0013\u0001\u0011\u0005!1\u001a\u0005\b\u0007S\u0001A\u0011\u0001Bf\u0011\u001d\u0019i\u0003\u0001C\u0001\u0005\u0017Dqa!\r\u0001\t\u0003\u0011Y\rC\u0004\u00046\u0001!\tAa3\t\u000f\re\u0002\u0001\"\u0001\u0003L\"91Q\b\u0001\u0005\u0002\t-\u0007bBB!\u0001\u0011\u0005!1\u001a\u0005\b\u0007\u000b\u0002A\u0011BB$\u0011\u001d\u0019)\u0005\u0001C\u0005\u00077Bqaa\u001f\u0001\t\u0013\u0011Y\rC\u0004\u0004~\u0001!IAa3\t\u000f\r}\u0004\u0001\"\u0003\u0004\u0002\"911\u0012\u0001\u0005\n\t-\u0007bBBG\u0001\u0011%1q\u0012\u0005\b\u0007/\u0003A\u0011BBM\u0011\u001d\u0019\u0019\u000b\u0001C\u0005\u0007KCqa!+\u0001\t\u0013\u0019Y\u000bC\u0004\u00040\u0002!Ia!-\t\u000f\rM\u0006\u0001\"\u0003\u00046\"911\u0018\u0001\u0005\n\ru\u0006bBBb\u0001\u0011%1Q\u0019\u0005\b\u0007\u001b\u0004A\u0011BBh\u0011%\u0019I\u000fAI\u0001\n\u0013\u0019Y\u000fC\u0005\u0004p\u0002\t\n\u0011\"\u0003\u0004r\"91Q\u001f\u0001\u0005\n\r]\b\"\u0003C\u0006\u0001E\u0005I\u0011BBy\u0011\u001d\u0019i\r\u0001C\u0005\t\u001bAq\u0001\"\b\u0001\t\u0013!yB\u0001\u000bD_:tWm\u0019;j_:\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003G\u0012\fqA\\3uo>\u00148NC\u0001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u00015\u0011\u0005%dW\"\u00016\u000b\u0003-\fQa]2bY\u0006L!!\u001c6\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u000f\u0005\u0002r\u00015\t!-A\u0004nKR\u0014\u0018nY:\u0016\u0003Q\u0004\"!\u001e@\u000e\u0003YT!A]<\u000b\u0005aL\u0018AB2p[6|gN\u0003\u0002fu*\u00111\u0010`\u0001\u0007CB\f7\r[3\u000b\u0003u\f1a\u001c:h\u0013\tyhOA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u0002j\u0003\u000fI1!!\u0003k\u0005\u0011)f.\u001b;\t\u0011\u000551!!AA\u0002Q\f1\u0001\u001f\u00132\u0003!iW\r\u001e:jGN\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\u0005U\u0001\u0003BA\f\u0003Ki!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0010\u0003C\tA!\u001e;jY*\u0011\u00111E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0005e!aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0019\u0015DXmY;u_J|F%Z9\u0015\t\u0005\u0015\u0011Q\u0006\u0005\n\u0003\u001b1\u0011\u0011!a\u0001\u0003+\t\u0011\"\u001a=fGV$xN\u001d\u0011\u0002!\r|gN\\3di&|g.U;pi\u0006\u001cXCAA\u001b!\r\t\u0018qG\u0005\u0004\u0003s\u0011'\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003Q\u0019wN\u001c8fGRLwN\\)v_R\f7o\u0018\u0013fcR!\u0011QAA \u0011%\ti!CA\u0001\u0002\u0004\t)$A\td_:tWm\u0019;j_:\fVo\u001c;bg\u0002\nA\u0001^5nKV\u0011\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011QJ<\u0002\u000bU$\u0018\u000e\\:\n\t\u0005E\u00131\n\u0002\u0005)&lW-\u0001\u0005uS6,w\fJ3r)\u0011\t)!a\u0016\t\u0013\u00055A\"!AA\u0002\u0005\u001d\u0013!\u0002;j[\u0016\u0004\u0013!\u00037jgR,g.\u001a:t+\t\ty\u0006\u0005\u0005\u0002b\u0005\u001d\u00141NA<\u001b\t\t\u0019GC\u0002\u0002f)\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI'a\u0019\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002n\u0005MTBAA8\u0015\u0011\t\t(!\t\u0002\t1\fgnZ\u0005\u0005\u0003k\nyG\u0001\u0004TiJLgn\u001a\t\u0004\u0003sbR\"\u0001\u0001\u0003\u00191K7\u000f^3oKJ$Um]2\u0014\rqA\u0017qPAC!\rI\u0017\u0011Q\u0005\u0004\u0003\u0007S'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u000f\u000b9J\u0004\u0003\u0002\n\u0006Me\u0002BAF\u0003#k!!!$\u000b\u0007\u0005=e-\u0001\u0004=e>|GOP\u0005\u0002W&\u0019\u0011Q\u00136\u0002\u000fA\f7m[1hK&!\u0011\u0011TAN\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t)J[\u0001\rY&\u001cH/\u001a8fe:\u000bW.Z\u000b\u0003\u0003C\u0003B!a)\u0002(6\u0011\u0011Q\u0015\u0006\u0003G^LA!!+\u0002&\naA*[:uK:,'OT1nK\u0006iA.[:uK:,'OT1nK\u0002\n\u0011\u0002Z3gCVdG/\u00139\u0016\u0005\u0005E\u0006\u0003BAZ\u0003sk!!!.\u000b\t\u0005]\u0016\u0011E\u0001\u0004]\u0016$\u0018\u0002BA^\u0003k\u00131\"\u00138fi\u0006#GM]3tg\u0006QA-\u001a4bk2$\u0018\n\u001d\u0011\u0015\r\u0005]\u0014\u0011YAb\u0011\u001d\ti*\ta\u0001\u0003CCq!!,\"\u0001\u0004\t\t,\u0001\u0005u_N#(/\u001b8h)\t\tI\r\u0005\u0003\u0002L\u0006Mg\u0002BAg\u0003\u001f\u00042!a#k\u0013\r\t\tN[\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0014Q\u001b\u0006\u0004\u0003#T\u0017\u0001B2paf$b!a\u001e\u0002\\\u0006u\u0007\"CAOGA\u0005\t\u0019AAQ\u0011%\tik\tI\u0001\u0002\u0004\t\t,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r(\u0006BAQ\u0003K\\#!a:\u0011\t\u0005%\u00181_\u0007\u0003\u0003WTA!!<\u0002p\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003cT\u0017AC1o]>$\u0018\r^5p]&!\u0011Q_Av\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYP\u000b\u0003\u00022\u0006\u0015\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002l\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u0001\t\u0004S\n\u001d\u0011b\u0001B\u0005U\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u0002B\u000b!\rI'\u0011C\u0005\u0004\u0005'Q'aA!os\"I\u0011Q\u0002\u0015\u0002\u0002\u0003\u0007!QA\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0004\t\u0007\u0003C\u0012iBa\u0004\n\t\t}\u00111\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003&\t-\u0002cA5\u0003(%\u0019!\u0011\u00066\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u0002\u0016\u0002\u0002\u0003\u0007!qB\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002l\tE\u0002\"CA\u0007W\u0005\u0005\t\u0019\u0001B\u0003\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0003\u0003\u0019)\u0017/^1mgR!!Q\u0005B\u001e\u0011%\ti!LA\u0001\u0002\u0004\u0011y!\u0001\u0006mSN$XM\\3sg\u0002\nAC\u00197pG.,G\rU3sG\u0016tG/T3uKJ\u001cXC\u0001B\"!!\u0011)Ea\u0013\u0002J\n5SB\u0001B$\u0015\u0011\u0011I%a\u0019\u0002\u000f5,H/\u00192mK&!\u0011\u0011\u000eB$!\u0011\u0011yEa\u0018\u000e\u0005\tE#\u0002\u0002B*\u0005+\nAaY8sK*\u0019!Oa\u0016\u000b\t\te#1L\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\tu\u0013aA2p[&!!\u0011\rB)\u0005\u0015iU\r^3s\u0003U\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3sg\u0002\n\u0011b\u001b8po:Dun\u001d;\u0002\u0015-twn\u001e8I_N$\b%A\u0006v].twn\u001e8I_N$\u0018\u0001D;oW:|wO\u001c%pgR\u0004\u0013a\u00048v[F+x\u000e^1TC6\u0004H.Z:\u0002!9,X.U;pi\u0006\u001c\u0016-\u001c9mKN\u0004\u0013AF9v_R\fw+\u001b8e_^\u001c\u0016N_3TK\u000e|g\u000eZ:\u0002/E,x\u000e^1XS:$wn^*ju\u0016\u001cVmY8oIN\u0004\u0013aA3qgV\u0011!\u0011\u0010\t\u0004S\nm\u0014b\u0001B?U\n1Ai\\;cY\u0016\fA!\u001a9tA\u0005aA*[:uK:,'\u000fR3tGB\u0019\u0011\u0011P\u0018\u0014\u000b=\u00129Ia%\u0011\u0015\t%%qRAQ\u0003c\u000b9(\u0004\u0002\u0003\f*\u0019!Q\u00126\u0002\u000fI,h\u000e^5nK&!!\u0011\u0013BF\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*!!\u0011TA\u0011\u0003\tIw.\u0003\u0003\u0002\u001a\n]EC\u0001BB)\t\tY'A\u0003baBd\u0017\u0010\u0006\u0004\u0002x\t\u0015&q\u0015\u0005\b\u0003;\u0013\u0004\u0019AAQ\u0011\u001d\tiK\ra\u0001\u0003c\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003.\ne\u0006#B5\u00030\nM\u0016b\u0001BYU\n1q\n\u001d;j_:\u0004r!\u001bB[\u0003C\u000b\t,C\u0002\u00038*\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003B^g\u0005\u0005\t\u0019AA<\u0003\rAH\u0005M\u0001'EJ|7.\u001a:Qe>\u00048oV5uQ\u0012+g-Y;mi\u000e{gN\\3di&|g\u000eT5nSR\u001cXC\u0001Ba!\u0011\u0011\u0019M!2\u000e\u0005\u0005u\u0011\u0002\u0002Bd\u0003;\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u00035\u0019X\r^;q\u001b>\u001c7\u000eV5nKR\u0011\u0011QA\u0001\u0006g\u0016$X\u000b\u001d\u0015\u0004m\tE\u0007\u0003\u0002Bj\u0005Cl!A!6\u000b\t\t]'\u0011\\\u0001\u0004CBL'\u0002\u0002Bn\u0005;\fqA[;qSR,'OC\u0002\u0003`r\fQA[;oSRLAAa9\u0003V\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3a\u000eBu!\u0011\u0011\u0019Na;\n\t\t5(Q\u001b\u0002\n\u0003\u001a$XM]#bG\"\fq\u0003^3ti\u001a\u000b\u0017\u000e\\,iK:tu\u000eT5ti\u0016tWM]:)\u0007a\u0012\u0019\u0010\u0005\u0003\u0003T\nU\u0018\u0002\u0002B|\u0005+\u0014A\u0001V3ti\u0006iB/Z:u\r\u0006LG\u000eR3de\u0016lWM\u001c;G_J,fn\u001b8po:L\u0005\u000fK\u0002:\u0005g\fq\u0004^3ti:{7i\u001c8oK\u000e$\u0018n\u001c8MS6LGo\u001d\"z\t\u00164\u0017-\u001e7uQ\rQ$1_\u0001\u0018i\u0016\u001cH/T1y\u0007>tg.Z2uS>t7\u000fU3s\u0013BD3a\u000fBz\u0003\u0001\"Xm\u001d;NCb\u0014%o\\6fe^KG-Z\"p]:,7\r^5p]2KW.\u001b;)\u0007q\u0012\u00190A\u0010uKN$X*\u0019=MSN$XM\\3s\u0007>tg.Z2uS>tG*[7jiND3!\u0010Bz\u0003U\"Xm\u001d;Ce>\\WM]\"p]:,7\r^5p]J\u000bG/\u001a'j[&$x\u000b[3o\u0003\u000e$X/\u00197SCR,')\u001a7po2KW.\u001b;)\u0007y\u0012\u00190A\u001buKN$(I]8lKJ\u001cuN\u001c8fGRLwN\u001c*bi\u0016d\u0015.\\5u/\",g.Q2uk\u0006d'+\u0019;f\u0003\n|g/\u001a'j[&$\bfA \u0003t\u00069D/Z:u\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|gNU1uK2KW.\u001b;XQ\u0016t\u0017i\u0019;vC2\u0014\u0016\r^3CK2|w\u000fT5nSRD3\u0001\u0011Bz\u0003]\"Xm\u001d;MSN$XM\\3s\u0007>tg.Z2uS>t'+\u0019;f\u0019&l\u0017\u000e^,iK:\f5\r^;bYJ\u000bG/Z!c_Z,G*[7ji\"\u001a\u0011Ia=\u0002YQ,7\u000f^%q\u0007>tg.Z2uS>t'+\u0019;f/\",g.Q2uk\u0006d'+\u0019;f\u0005\u0016dwn\u001e'j[&$\bf\u0001\"\u0003t\u0006aC/Z:u\u0013B\u001cuN\u001c8fGRLwN\u001c*bi\u0016<\u0006.\u001a8BGR,\u0018\r\u001c*bi\u0016\f%m\u001c<f\u0019&l\u0017\u000e\u001e\u0015\u0004\u0007\nM\u0018A\f;fgRL\u0005oQ8o]\u0016\u001cG/[8o%\u0006$XmV5uQ2K7\u000f^3oKJ\u001cuN\u001c8fGRLwN\u001c*bi\u0016D3\u0001\u0012Bz\u0003i\"Xm\u001d;SK*,7\r^3e\u0013B\u001cuN\u001c8fGRLwN\\+oe\u0016\u001cwN\u001d3fI\u001a\u0013x.\\\"p]:,7\r^5p]J\u000bG/Z)v_R\f7\u000fK\u0002F\u0005g\f\u0001\u0007^3ti6\u000b\u0007\u0010T5ti\u0016tWM]\"p]:,7\r^5p]2K7\u000f^3oKJlUo\u001d;CK\u0006\u0013wN^3[KJ|\u0007f\u0001$\u0003t\u0006aC/Z:u\u001b\u0006DH*[:uK:,'oQ8o]\u0016\u001cG/[8o%\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u0015\u0004\u000f\nM\u0018A\u000b;fgRl\u0015\r\u001f\"s_.,'oQ8o]\u0016\u001cG/[8o%\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u0015\u0004\u0011\nM\u0018\u0001\t;fgRL\u0005oQ8o]\u0016\u001cG/[8o%\u0006$X-T3ue&\u001cW\u000b\u001d3bi\u0016D3!\u0013Bz\u0003\u001d\"Xm\u001d;F]\u001a|'oY3e\u0013B\u001cuN\u001c8fGRLwN\u001c*bi\u0016\fVo\u001c;b+B$\u0017\r^3)\u0007)\u0013\u00190\u0001\u0018uKN$hj\u001c8EK\u001a\fW\u000f\u001c;D_:tWm\u0019;j_:\u001cu.\u001e8u\u0019&l\u0017\u000e^!oIJ\u000bG/\u001a'j[&$\bfA&\u0003t\u0006)\u0012\r\u001a3MSN$XM\\3sg\u0006sGMV3sS\u001aLHCBA\u0003\u0007\u0013\u001aI\u0006C\u0004\u0004L1\u0003\ra!\u0014\u0002\r\r|gNZ5h!\u0011\u0019ye!\u0016\u000e\u0005\rE#bAB*I\u000611/\u001a:wKJLAaa\u0016\u0004R\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\t\t\u0004\u0014a\u0001\u0003k!\u0002\"!\u0002\u0004^\r}3\u0011\u0010\u0005\b\u0007\u0017j\u0005\u0019AB'\u0011\u001d\u0019\t'\u0014a\u0001\u0007G\na\u0002\\5ti\u0016tWM]\"p]\u001aLw\r\r\u0003\u0004f\r5\u0004\u0003\u0003Bb\u0007O\nIm!\u001b\n\t\u0005%\u0014Q\u0004\t\u0005\u0007W\u001ai\u0007\u0004\u0001\u0005\u0019\r=4qLA\u0001\u0002\u0003\u0015\ta!\u001d\u0003\u0007}#\u0013'\u0005\u0003\u0004t\t=\u0001cA5\u0004v%\u00191q\u000f6\u0003\u000f9{G\u000f[5oO\"9\u0011\u0011G'A\u0002\u0005U\u0012\u0001\f<fe&4\u0017PT8CY>\u001c7.\u001a3QKJ\u001cWM\u001c;SK\u000e|'\u000fZ3e\u001f:\fE\u000e\u001c'jgR,g.\u001a:t\u0003a2XM]5gs:{gNW3s_\ncwnY6fIB+'oY3oi\u0006sG\r\u00165s_R$H.\u001a+j[\u0016|e.\u00117m\u0019&\u001cH/\u001a8feN\faD^3sS\u001aL\u0018\n\u001d+ie>$H\u000f\\3US6,wJ\u001c'jgR,g.\u001a:\u0015\r\u0005\u001511QBD\u0011\u001d\u0019)\t\u0015a\u0001\u0003C\u000b\u0001\u0002\\5ti\u0016tWM\u001d\u0005\b\u0007\u0013\u0003\u0006\u0019\u0001B\u0013\u00039)\u0007\u0010]3diRC'o\u001c;uY\u0016\fqG^3sS\u001aLxJ\u001c7z\u001d>t\u0017J\u001c;fe\n\u0013xn[3s\u0019&\u001cH/\u001a8feN\u0014En\\2lK\u0012\u0004VM]2f]R\u0014VmY8sI\u0016$\u0017\u0001\n<fe&4\u0017pQ8o]\u0016\u001cG/[8o\u0007>,h\u000e^(o\u000bZ,'/\u001f'jgR,g.\u001a:\u0015\r\u0005\u00151\u0011SBJ\u0011\u001d\t\tD\u0015a\u0001\u0003kAqa!&S\u0001\u0004\u0011)!A\ffqB,7\r^3e\u0007>tg.Z2uS>t7i\\;oi\u0006QB.[:uK:,'oQ8o]RC'o\u001c;uY\u0016lU\r\u001e:jGR!11TBQ!\r)8QT\u0005\u0004\u0007?3(aC&bM.\fW*\u001a;sS\u000eDqa!\"T\u0001\u0004\tI-\u0001\u000bja\u000e{gN\u001c+ie>$H\u000f\\3NKR\u0014\u0018n\u0019\u000b\u0005\u00077\u001b9\u000bC\u0004\u0004\u0006R\u0003\r!!3\u0002-1L7\u000f^3oKJ\u001cuN\u001c8SCR,W*\u001a;sS\u000e$Baa'\u0004.\"91QQ+A\u0002\u0005%\u0017\u0001\u00062s_.,'oQ8o]J\u000bG/Z'fiJL7\r\u0006\u0002\u0004\u001c\u0006\u0001\u0012\u000e]\"p]:\u0014\u0016\r^3NKR\u0014\u0018n\u0019\u000b\u0005\u00077\u001b9\fC\u0004\u0004:^\u0003\r!!3\u0002\u0005%\u0004\u0018aC7fiJL7MV1mk\u0016$BA!\u001f\u0004@\"91\u0011\u0019-A\u0002\rm\u0015AB7fiJL7-A\fwKJLg-_%q\u0007>tg.Z2uS>t\u0017+^8uCR1\u0011QABd\u0007\u0013Dqa!/Z\u0001\u0004\t\t\fC\u0004\u0004Lf\u0003\rA!\u0002\u0002\u000bE,x\u000e^1\u0002#\u0005\u001c7-\u001a9u\u0007>tg.Z2uS>t7\u000f\u0006\u0007\u0002\u0006\rE71[Bl\u0007C\u001c)\u000fC\u0004\u00022i\u0003\r!!\u000e\t\u000f\rU'\f1\u0001\u0002x\u0005aA.[:uK:,'\u000fR3tG\"91\u0011\u001c.A\u0002\rm\u0017A\u00048v[\u000e{gN\\3di&|gn\u001d\t\u0004S\u000eu\u0017bABpU\n!Aj\u001c8h\u0011%\u0019\u0019O\u0017I\u0001\u0002\u0004\u0019Y.\u0001\buS6,\u0017J\u001c;feZ\fG.T:\t\u0013\r\u001d(\f%AA\u0002\t\u0015\u0012\u0001E3ya\u0016\u001cG/\u00139UQJ|G\u000f\u001e7f\u0003m\t7mY3qi\u000e{gN\\3di&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u001e\u0016\u0005\u00077\f)/A\u000ebG\u000e,\u0007\u000f^\"p]:,7\r^5p]N$C-\u001a4bk2$H%N\u000b\u0003\u0007gTCA!\n\u0002f\u0006q\u0012mY2faR\u001cuN\u001c8fGRLwN\\:B]\u00124VM]5gsJ\u000bG/\u001a\u000b\u0011\u0003\u000b\u0019Ipa?\u0004~\u000e}H\u0011\u0001C\u0003\t\u0013Aq!!\r^\u0001\u0004\t)\u0004C\u0004\u0004Vv\u0003\r!a\u001e\t\u000f\reW\f1\u0001\u0004\\\"911]/A\u0002\rm\u0007b\u0002C\u0002;\u0002\u0007!QA\u0001\rKb\u0004Xm\u0019;fIJ\u000bG/\u001a\u0005\b\t\u000fi\u0006\u0019\u0001B\u0003\u0003\u001d)\u0007o]5m_:D\u0011ba:^!\u0003\u0005\rA!\n\u0002Q\u0005\u001c7-\u001a9u\u0007>tg.Z2uS>t7/\u00118e-\u0016\u0014\u0018NZ=SCR,G\u0005Z3gCVdG\u000fJ\u001c\u0015\u001d\t\u0015Bq\u0002C\t\t'!9\u0002\"\u0007\u0005\u001c!9\u0011\u0011G0A\u0002\u0005U\u0002bBAO?\u0002\u0007\u0011\u0011\u0015\u0005\b\t+y\u0006\u0019AAY\u0003\u001d\tG\r\u001a:fgNDqa!7`\u0001\u0004\u0019Y\u000eC\u0004\u0004d~\u0003\raa7\t\u000f\r\u001dx\f1\u0001\u0003&\u0005i\u0012mY2faR\u001cuN\u001c8fGRLwN\\:BE>4X-\u00139MS6LG\u000f\u0006\u0005\u0002\u0006\u0011\u0005B1\u0005C\u0013\u0011\u001d\t\t\u0004\u0019a\u0001\u0003kAqa!6a\u0001\u0004\t9\bC\u0004\u0004Z\u0002\u0004\raa7")
public class ConnectionQuotasTest {
    private volatile ConnectionQuotasTest$ListenerDesc$ ListenerDesc$module;
    private Metrics metrics;
    private ExecutorService executor;
    private ConnectionQuotas connectionQuotas;
    private Time time;
    private final Map<String, ListenerDesc> listeners = (Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL"), (Object)new ListenerDesc(this, new ListenerName("EXTERNAL"), InetAddress.getByName("192.168.1.1"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ADMIN"), (Object)new ListenerDesc(this, new ListenerName("ADMIN"), InetAddress.getByName("192.168.1.2"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REPLICATION"), (Object)new ListenerDesc(this, new ListenerName("REPLICATION"), InetAddress.getByName("192.168.1.3")))}));
    private final scala.collection.mutable.Map<String, Meter> blockedPercentMeters = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final InetAddress knownHost = InetAddress.getByName("192.168.10.0");
    private final InetAddress unknownHost = InetAddress.getByName("192.168.2.0");
    private final int numQuotaSamples;
    private final int quotaWindowSizeSeconds;
    private final double eps;

    public ConnectionQuotasTest$ListenerDesc$ ListenerDesc() {
        if (this.ListenerDesc$module == null) {
            this.ListenerDesc$lzycompute$1();
        }
        return this.ListenerDesc$module;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    private Map<String, ListenerDesc> listeners() {
        return this.listeners;
    }

    private scala.collection.mutable.Map<String, Meter> blockedPercentMeters() {
        return this.blockedPercentMeters;
    }

    private InetAddress knownHost() {
        return this.knownHost;
    }

    private InetAddress unknownHost() {
        return this.unknownHost;
    }

    private int numQuotaSamples() {
        return this.numQuotaSamples;
    }

    private int quotaWindowSizeSeconds() {
        return this.quotaWindowSizeSeconds;
    }

    private double eps() {
        return this.eps;
    }

    /*
     * WARNING - void declaration
     */
    public Properties brokerPropsWithDefaultConnectionLimits() {
        void var1_24;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        boolean bl8 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 0, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s, bl8);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1,ADMIN://localhost:2");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,ADMIN:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), Integer.toString(this.numQuotaSamples()));
        props.put(KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp(), Integer.toString(this.quotaWindowSizeSeconds()));
        return var1_24;
    }

    private void setupMockTime() {
        this.metrics().close();
        this.time_$eq((Time)new MockTime());
        this.metrics_$eq(new Metrics(this.time()));
    }

    @BeforeEach
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.listeners().keys().foreach((Function1 & Serializable)name -> this.blockedPercentMeters().put(name, (Object)KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)KafkaMetricsGroup$.MODULE$, (String)new StringBuilder(14).append((String)name).append("BlockedPercent").toString(), (String)"blocked time", (TimeUnit)TimeUnit.NANOSECONDS, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), name)}))))));
        this.time_$eq(Time.SYSTEM);
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), this.time()));
        this.executor_$eq(Executors.newFixedThreadPool(this.listeners().size()));
    }

    @AfterEach
    public void tearDown() {
        this.executor().shutdownNow();
        if (this.connectionQuotas() != null) {
            this.connectionQuotas().close();
        }
        this.metrics().close();
        TestUtils$.MODULE$.clearYammerMetrics();
        this.blockedPercentMeters().clear();
    }

    @Test
    public void testFailWhenNoListeners() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> Assertions.assertThrows(RuntimeException.class, () -> this.connectionQuotas().inc(listener.listenerName(), listener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")))).get(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testFailDecrementForUnknownIp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), this.unknownHost()));
    }

    @Test
    public void testNoConnectionLimitsByDefault() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        int numConnections = 10000;
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, numConnections, 0L, false)))).foreach((Function1 & Serializable)x$5 -> x$5.get(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.brokerConnRateMetric().metricValue()) > 0.0 ? 1 : 0) != 0, (String)"Expected broker-connection-accept-rate metric to get recorded");
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testNoConnectionLimitsByDefault$4(this, numConnections, listener);
            return BoxedUnit.UNIT;
        });
        this.verifyNoBlockedPercentRecordedOnAllListeners();
    }

    @Test
    public void testMaxConnectionsPerIp() {
        int maxConnectionsPerIp = 17;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), Integer.toString(maxConnectionsPerIp));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener, maxConnectionsPerIp, 0L, false)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnectionsPerIp, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        this.executor().submit(() -> this.acceptConnectionsAboveIpLimit(this.connectionQuotas(), externalListener, 2L)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)(maxConnectionsPerIp + 2), (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener.listenerName(), this.knownHost(), maxConnectionsPerIp, 0L, false)).get(5L, TimeUnit.SECONDS);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> this.connectionQuotas().dec(externalListener.listenerName(), externalListener.defaultIp()));
        Assertions.assertEquals((int)(maxConnectionsPerIp - 2), (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener, 2L, 0L, false)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnectionsPerIp, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
    }

    @Test
    public void testMaxBrokerWideConnectionLimit() {
        int maxConnections = 800;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), Integer.toString(maxConnections));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), maxConnections, 0L, false)).get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnections, (int)this.connectionQuotas().get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString());
        Assertions.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
        Assertions.assertFalse((boolean)this.connectionQuotas().maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()), (String)"Total number of connections is exactly the maximum.");
        Future<?> future = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, 0L, false));
        Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
        this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
        future.get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnections, (int)this.connectionQuotas().get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString());
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric to be recorded");
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, 0L, false)).get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.connectionQuotas().maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()), (String)"Expected the number of connections to exceed the maximum.");
        Future<?> future1 = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"ADMIN"), 1L, 0L, false));
        Assertions.assertThrows(TimeoutException.class, () -> future1.get(1L, TimeUnit.SECONDS));
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, 0L, false)).get(5L, TimeUnit.SECONDS);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
        Assertions.assertThrows(TimeoutException.class, () -> future1.get(100L, TimeUnit.MILLISECONDS));
        this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
        future1.get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testMaxListenerConnectionLimits() {
        int maxConnections = 800;
        int listenerMaxConnections = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), Integer.toString(maxConnections));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        java.util.Map listenerConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionsProp()), (Object)Integer.toString(listenerMaxConnections))}))).asJava();
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$1(this, listenerConfig, listener);
            return BoxedUnit.UNIT;
        });
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, listenerMaxConnections, 0L, false)))).foreach((Function1 & Serializable)x$8 -> x$8.get(5L, TimeUnit.SECONDS));
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$5(this, listenerMaxConnections, listener);
            return BoxedUnit.UNIT;
        });
        Iterable overLimitFutures = (Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, 1L, 0L, false)));
        overLimitFutures.foreach((Function1 & Serializable)future -> (TimeoutException)Assertions.assertThrows(TimeoutException.class, () -> future.get(1L, TimeUnit.SECONDS)));
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$10(this, listener);
            return BoxedUnit.UNIT;
        });
        overLimitFutures.foreach((Function1 & Serializable)x$9 -> x$9.get(5L, TimeUnit.SECONDS));
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), listenerMaxConnections);
    }

    @Test
    public void testBrokerConnectionRateLimitWhenActualRateBelowLimit() {
        int brokerRateLimit = 125;
        int connCreateIntervalMs = 25;
        int connectionsPerListener = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, false)))).foreach((Function1 & Serializable)x$10 -> x$10.get(10L, TimeUnit.SECONDS));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testBrokerConnectionRateLimitWhenActualRateAboveLimit() {
        int brokerRateLimit = 90;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        int connCreateIntervalMs = 10;
        int connectionsPerListener = 400;
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, false)))).foreach((Function1 & Serializable)x$11 -> x$11.get(20L, TimeUnit.SECONDS));
        this.verifyOnlyNonInterBrokerListenersBlockedPercentRecorded();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testListenerConnectionRateLimitWhenActualRateBelowLimit() {
        int brokerRateLimit = 125;
        int listenerRateLimit = 50;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        java.util.Map listenerConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(listenerRateLimit))}))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        int connectionsPerListener = 200;
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, false)))).foreach((Function1 & Serializable)x$12 -> x$12.get(10L, TimeUnit.SECONDS));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testListenerConnectionRateLimitWhenActualRateAboveLimit() {
        int brokerRateLimit = 125;
        int listenerRateLimit = 30;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        java.util.Map listenerConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(listenerRateLimit))}))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        int connectionsPerListener = 600;
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, listenerRateLimit, 7, false)))).foreach((Function1 & Serializable)x$13 -> x$13.get(30L, TimeUnit.SECONDS));
        this.verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testIpConnectionRateWhenActualRateBelowLimit() {
        int ipConnectionRateLimit = 30;
        int connCreateIntervalMs = 40;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.setupMockTime();
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        int numConnections = 200;
        this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), externalListener, numConnections, connCreateIntervalMs, 25, 0, false);
        Assertions.assertEquals((int)numConnections, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        ListenerDesc adminListener = (ListenerDesc)this.listeners().apply((Object)"ADMIN");
        int unthrottledConnectionCreateInterval = 20;
        this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), adminListener, numConnections, unthrottledConnectionCreateInterval, 50, 0, false);
        Assertions.assertEquals((int)numConnections, (int)this.connectionQuotas().get(adminListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(adminListener).append(":").toString());
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        ((IterableOnceOps)this.listeners().values().map((Function1 & Serializable)x$14 -> x$14.listenerName())).foreach((Function1 & Serializable)x$15 -> {
            this.verifyIpThrottleTimeOnListener(x$15, false);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testIpConnectionRateWhenActualRateAboveLimit() {
        int ipConnectionRateLimit = 20;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.setupMockTime();
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        int numConnections = 80;
        this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), externalListener, numConnections, connCreateIntervalMs, ipConnectionRateLimit, 1, true);
        this.verifyIpThrottleTimeOnListener(externalListener.listenerName(), true);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        ListenerDesc adminListener = (ListenerDesc)this.listeners().apply((Object)"ADMIN");
        this.verifyIpThrottleTimeOnListener(adminListener.listenerName(), false);
        this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), adminListener, numConnections, connCreateIntervalMs, ipConnectionRateLimit, 1, true);
        this.verifyIpThrottleTimeOnListener(adminListener.listenerName(), true);
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyIpThrottleTimeOnListener(((ListenerDesc)this.listeners().apply((Object)"REPLICATION")).listenerName(), false);
    }

    @Test
    public void testIpConnectionRateWithListenerConnectionRate() {
        int ipConnectionRateLimit = 25;
        int listenerRateLimit = 35;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        java.util.Map listenerConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(listenerRateLimit))}))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        ListenerName listener = ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName();
        int numConnections = 35;
        List throttledIps = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{this.executor().submit(() -> BoxesRunTime.boxToBoolean((boolean)this.acceptConnections(this.connectionQuotas(), listener, this.knownHost(), numConnections, 0L, true))), this.executor().submit(() -> BoxesRunTime.boxToBoolean((boolean)this.acceptConnections(this.connectionQuotas(), listener, this.unknownHost(), numConnections, 0L, true)))}))).map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ConnectionQuotasTest.$anonfun$testIpConnectionRateWithListenerConnectionRate$3(x$16))).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ConnectionQuotasTest.$anonfun$testIpConnectionRateWithListenerConnectionRate$4(BoxesRunTime.unboxToBoolean((Object)x))));
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded");
        Assertions.assertTrue((throttledIps.size() < 2 ? 1 : 0) != 0, (String)"Expect at most one IP to get throttled");
    }

    @Test
    public void testRejectedIpConnectionUnrecordedFromConnectionRateQuotas() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, (Time)new MockTime(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        ListenerDesc protectedListener = (ListenerDesc)this.listeners().apply((Object)"REPLICATION");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)protectedListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.connectionQuotas().inc(externalListener.listenerName(), externalListener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")));
        KafkaMetric brokerRateMetric = this.brokerConnRateMetric();
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.ipConnRateMetric(externalListener.defaultIp().getHostAddress()).metricValue()), (double)this.eps());
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.listenerConnRateMetric(externalListener.listenerName().value()).metricValue()), (double)this.eps());
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)brokerRateMetric.metricValue()), (double)this.eps());
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.connectionQuotas().inc(protectedListener.listenerName(), protectedListener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"REPLICATION")));
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.ipConnRateMetric(protectedListener.defaultIp().getHostAddress()).metricValue()), (double)this.eps());
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.listenerConnRateMetric(protectedListener.listenerName().value()).metricValue()), (double)this.eps());
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)brokerRateMetric.metricValue()), (double)this.eps());
    }

    @Test
    public void testMaxListenerConnectionListenerMustBeAboveZero() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        int maxListenerConnectionRate = 0;
        java.util.Map listenerConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(maxListenerConnectionRate))}))).asJava();
        Assertions.assertThrows(ConfigException.class, () -> ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).validateReconfiguration(listenerConfig));
    }

    @Test
    public void testMaxListenerConnectionRateReconfiguration() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        int listenerRateLimit = 20;
        java.util.Map listenerConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(listenerRateLimit))}))).asJava();
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).configure(listenerConfig);
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).reconfigure(CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.empty()).asJava());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1000L, 0L, false)).get(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count(), (String)"BlockedPercentMeter metric for EXTERNAL listener");
        int newMaxListenerConnectionRate = 10;
        java.util.Map newListenerConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()), (Object)Integer.toString(newMaxListenerConnectionRate))}))).asJava();
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).reconfigure(newListenerConfig);
        int connectionsPerListener = 200;
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), connectionsPerListener, 5L, newMaxListenerConnectionRate, 3, false)).get(30L, TimeUnit.SECONDS);
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded");
    }

    @Test
    public void testMaxBrokerConnectionRateReconfiguration() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.addListenersAndVerify(config, this.connectionQuotas());
        int maxBrokerConnectionRate = 50;
        this.connectionQuotas().updateBrokerMaxConnectionRate(maxBrokerConnectionRate);
        int totalConnections = 400;
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), totalConnections, 5L, maxBrokerConnectionRate, 20, false)).get(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded");
    }

    @Test
    public void testIpConnectionRateMetricUpdate() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"ADMIN")).listenerName());
        int defaultIpRate = 50;
        int defaultOverrideRate = 20;
        int overrideIpRate = 30;
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        ListenerDesc adminListener = (ListenerDesc)this.listeners().apply((Object)"ADMIN");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)defaultIpRate)));
        this.connectionQuotas().inc(externalListener.listenerName(), externalListener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL"));
        this.connectionQuotas().inc(adminListener.listenerName(), adminListener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"ADMIN"));
        this.verifyIpConnectionQuota(externalListener.defaultIp(), defaultIpRate);
        this.verifyIpConnectionQuota(adminListener.defaultIp(), defaultIpRate);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)overrideIpRate)));
        this.verifyIpConnectionQuota(externalListener.defaultIp(), overrideIpRate);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)defaultOverrideRate)));
        this.verifyIpConnectionQuota(externalListener.defaultIp(), overrideIpRate);
        this.verifyIpConnectionQuota(adminListener.defaultIp(), defaultOverrideRate);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)None$.MODULE$);
        this.verifyIpConnectionQuota(adminListener.defaultIp(), Integer.MAX_VALUE);
        this.verifyIpConnectionQuota(externalListener.defaultIp(), overrideIpRate);
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)None$.MODULE$);
        this.verifyIpConnectionQuota(externalListener.defaultIp(), Integer.MAX_VALUE);
    }

    @Test
    public void testEnforcedIpConnectionRateQuotaUpdate() {
        int ipConnectionRateLimit = 20;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.setupMockTime();
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        int connectionRate = 40;
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.acceptConnections(this.connectionQuotas(), externalListener, connectionRate, 0L, false));
        Assertions.assertEquals((int)ipConnectionRateLimit, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        int updatedRateLimit = 30;
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)updatedRateLimit)));
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.acceptConnections(this.connectionQuotas(), externalListener, connectionRate, 0L, false));
        Assertions.assertEquals((int)updatedRateLimit, (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        this.connectionQuotas().updateIpConnectionRateQuota((Option)new Some((Object)externalListener.defaultIp()), (Option)None$.MODULE$);
        this.acceptConnections(this.connectionQuotas(), externalListener, connectionRate, 0L, false);
        Assertions.assertEquals((int)(connectionRate + updatedRateLimit), (int)this.connectionQuotas().get(externalListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString());
        ListenerDesc adminListener = (ListenerDesc)this.listeners().apply((Object)"ADMIN");
        this.acceptConnections(this.connectionQuotas(), adminListener, connectionRate, 0L, false);
        Assertions.assertEquals((int)connectionRate, (int)this.connectionQuotas().get(adminListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(adminListener).append(":").toString());
        this.connectionQuotas().updateIpConnectionRateQuota((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)ipConnectionRateLimit)));
        Assertions.assertThrows(ConnectionThrottledException.class, () -> this.acceptConnections(this.connectionQuotas(), adminListener, connectionRate, 0L, false));
        Assertions.assertEquals((int)(connectionRate + ipConnectionRateLimit), (int)this.connectionQuotas().get(adminListener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(adminListener).append(":").toString());
        this.verifyNoBlockedPercentRecordedOnAllListeners();
    }

    @Test
    public void testNonDefaultConnectionCountLimitAndRateLimit() {
        int brokerRateLimit = 25;
        int maxConnections = 350;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), Integer.toString(maxConnections));
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(brokerRateLimit));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, this.time(), this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), listener, maxConnections, 10L, brokerRateLimit, 8, false)).get(20L, TimeUnit.SECONDS);
        Assertions.assertTrue((((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0, (String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded");
        Assertions.assertEquals((int)maxConnections, (int)this.connectionQuotas().get(listener.defaultIp()), (String)"Number of connections on EXTERNAL listener:");
        Future<?> future = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, 0L, false));
        Assertions.assertThrows(TimeoutException.class, () -> future.get(100L, TimeUnit.MILLISECONDS));
        this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
        future.get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)maxConnections, (int)this.connectionQuotas().get(listener.defaultIp()), (String)"Number of connections on EXTERNAL listener:");
    }

    private void addListenersAndVerify(KafkaConfig config, ConnectionQuotas connectionQuotas) {
        this.addListenersAndVerify(config, CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.empty()).asJava(), connectionQuotas);
    }

    private void addListenersAndVerify(KafkaConfig config, java.util.Map<String, ?> listenerConfig, ConnectionQuotas connectionQuotas) {
        Assertions.assertNotNull((Object)this.brokerConnRateMetric(), (String)"Expected broker-connection-accept-rate metric to exist");
        this.listeners().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, listener) -> {
            ConnectionQuotasTest.$anonfun$addListenersAndVerify$1(this, connectionQuotas, config, listenerConfig, name, listener);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.brokerConnRateMetric().metricValue()), (double)this.eps(), (String)"Broker-wide connection acceptance rate metric");
    }

    private void verifyNoBlockedPercentRecordedOnAllListeners() {
        this.blockedPercentMeters().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, meter) -> {
            ConnectionQuotasTest.$anonfun$verifyNoBlockedPercentRecordedOnAllListeners$1(name, meter);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
    }

    private void verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners() {
        this.blockedPercentMeters().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, meter) -> {
            ConnectionQuotasTest.$anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$1(name, meter);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$2(this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyIpThrottleTimeOnListener(ListenerName listener, boolean expectThrottle) {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectThrottle), (Object)BoxesRunTime.boxToBoolean(((long)BoxesRunTime.unboxToDouble((Object)this.ipConnThrottleMetric(listener.value()).metricValue()) > 0L ? 1 : 0) != 0), (String)new StringBuilder(45).append("IP connection throttle recorded for listener ").append(listener.value()).toString());
    }

    private void verifyOnlyNonInterBrokerListenersBlockedPercentRecorded() {
        this.blockedPercentMeters().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, meter) -> {
            ConnectionQuotasTest.$anonfun$verifyOnlyNonInterBrokerListenersBlockedPercentRecorded$1(name, meter);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
    }

    private void verifyConnectionCountOnEveryListener(ConnectionQuotas connectionQuotas, int expectedConnectionCount) {
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$verifyConnectionCountOnEveryListener$1(expectedConnectionCount, connectionQuotas, listener);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaMetric listenerConnThrottleMetric(String listener) {
        MetricName metricName = this.metrics().metricName("connection-accept-throttle-time", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric ipConnThrottleMetric(String listener) {
        MetricName metricName = this.metrics().metricName("ip-connection-accept-throttle-time", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric listenerConnRateMetric(String listener) {
        MetricName metricName = this.metrics().metricName("connection-accept-rate", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric brokerConnRateMetric() {
        MetricName metricName = this.metrics().metricName("broker-connection-accept-rate", SocketServer$.MODULE$.MetricsGroup());
        return this.metrics().metric(metricName);
    }

    private KafkaMetric ipConnRateMetric(String ip) {
        MetricName metricName = this.metrics().metricName("connection-accept-rate", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap("ip", ip));
        return this.metrics().metric(metricName);
    }

    private double metricValue(KafkaMetric metric) {
        return BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    private void verifyIpConnectionQuota(InetAddress ip, int quota) {
        Assertions.assertEquals((int)quota, (int)this.connectionQuotas().connectionRateForIp(ip));
        Option option = Option$.MODULE$.apply((Object)this.ipConnRateMetric(ip.getHostAddress()));
        if (option instanceof Some) {
            KafkaMetric metric = (KafkaMetric)((Some)option).value();
            Assertions.assertEquals((double)quota, (double)metric.config().quota().bound(), (double)0.1);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(46).append("Expected ").append(ip).append(" connection rate metric to be defined").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs, boolean expectIpThrottle) {
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs, expectIpThrottle);
    }

    private void acceptConnectionsAndVerifyRate(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs, int expectedRate, int epsilon, boolean expectIpThrottle) {
        long startTimeMs = this.time().milliseconds();
        int startNumConnections = connectionQuotas.get(listenerDesc.defaultIp());
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs, expectIpThrottle);
        double elapsedSeconds = MetricsUtils.convert((long)(this.time().milliseconds() - startTimeMs), (TimeUnit)TimeUnit.SECONDS);
        int createdConnections = connectionQuotas.get(listenerDesc.defaultIp()) - startNumConnections;
        double actualRate = (double)createdConnections / elapsedSeconds;
        Assertions.assertEquals((double)expectedRate, (double)actualRate, (double)epsilon, (String)new StringBuilder(52).append("Expected rate (").append(expectedRate).append(" +- ").append(epsilon).append("), but got ").append(actualRate).append(" (").append(createdConnections).append(" connections / ").append(elapsedSeconds).append(" sec)").toString());
    }

    private boolean acceptConnections(ConnectionQuotas connectionQuotas, ListenerName listenerName, InetAddress address, long numConnections, long timeIntervalMs, boolean expectIpThrottle) {
        LongRef nextSendTime = LongRef.create((long)(this.time().milliseconds() + timeIntervalMs));
        BooleanRef ipThrottled = BooleanRef.create((boolean)false);
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)numConnections)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$17 -> {
            try {
                connectionQuotas.inc(listenerName, address, (Meter)this.blockedPercentMeters().apply((Object)listenerName.value()));
            }
            catch (ConnectionThrottledException e) {
                if (!expectIpThrottle) {
                    throw e;
                }
                ipThrottled$1.elem = true;
            }
            long sleepMs = scala.math.package$.MODULE$.max(nextSendTime$1.elem - this.time().milliseconds(), 0L);
            if (sleepMs > 0L) {
                this.time().sleep(sleepMs);
            }
            nextSendTime$1.elem += timeIntervalMs;
        });
        return ipThrottled.elem;
    }

    private long acceptConnections$default$4() {
        return 0L;
    }

    private boolean acceptConnections$default$5() {
        return false;
    }

    private boolean acceptConnectionsAndVerifyRate$default$7() {
        return false;
    }

    private void acceptConnectionsAboveIpLimit(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections) {
        ListenerName listenerName = listenerDesc.listenerName();
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)numConnections)).foreach((Function1 & Serializable)i -> ConnectionQuotasTest.$anonfun$acceptConnectionsAboveIpLimit$1(this, connectionQuotas, listenerName, listenerDesc, BoxesRunTime.unboxToLong((Object)i)));
    }

    private final void ListenerDesc$lzycompute$1() {
        synchronized (this) {
            if (this.ListenerDesc$module == null) {
                this.ListenerDesc$module = new ConnectionQuotasTest$ListenerDesc$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testNoConnectionLimitsByDefault$4(ConnectionQuotasTest $this, int numConnections$1, ListenerDesc listener) {
        Assertions.assertEquals((int)numConnections$1, (int)$this.connectionQuotas().get(listener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString());
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)$this.listenerConnRateMetric(listener.listenerName().value()).metricValue()) > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(68).append("Expected connection-accept-rate metric to get recorded for listener ").append(listener).toString());
        $this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
        Assertions.assertEquals((int)(numConnections$1 - 1), (int)$this.connectionQuotas().get(listener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString());
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$1(ConnectionQuotasTest $this, java.util.Map listenerConfig$1, ListenerDesc listener) {
        ((ConnectionQuotas.ListenerConnectionQuota)$this.connectionQuotas().maxConnectionsPerListener().apply((Object)listener.listenerName())).configure(listenerConfig$1);
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$5(ConnectionQuotasTest $this, int listenerMaxConnections$1, ListenerDesc listener) {
        Assertions.assertEquals((int)listenerMaxConnections$1, (int)$this.connectionQuotas().get(listener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString());
        Assertions.assertFalse((boolean)$this.connectionQuotas().maxConnectionsExceeded(listener.listenerName()), (String)new StringBuilder(62).append("Total number of connections on ").append(listener).append(" should be exactly the maximum.").toString());
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$10(ConnectionQuotasTest $this, ListenerDesc listener) {
        $this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
    }

    public static final /* synthetic */ boolean $anonfun$testIpConnectionRateWithListenerConnectionRate$3(Future x$16) {
        return BoxesRunTime.unboxToBoolean(x$16.get(3L, TimeUnit.SECONDS));
    }

    public static final /* synthetic */ boolean $anonfun$testIpConnectionRateWithListenerConnectionRate$4(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ void $anonfun$addListenersAndVerify$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$1, KafkaConfig config$1, java.util.Map listenerConfig$3, String name, ListenerDesc listener) {
        ListenerName listenerName = listener.listenerName();
        connectionQuotas$1.addListener(config$1, listenerName);
        ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas$1.maxConnectionsPerListener().apply((Object)listenerName)).configure(listenerConfig$3);
        Assertions.assertFalse((boolean)connectionQuotas$1.maxConnectionsExceeded(listenerName), (String)new StringBuilder(72).append("Should not exceed max connection limit on ").append(name).append(" listener after initialization").toString());
        Assertions.assertEquals((int)0, (int)connectionQuotas$1.get(listener.defaultIp()), (String)new StringBuilder(35).append("Number of connections on ").append(listener).append(" listener:").toString());
        Assertions.assertNotNull((Object)$this.listenerConnRateMetric(listenerName.value()), (String)new StringBuilder(61).append("Expected connection-accept-rate metric to exist for listener ").append(listenerName.value()).toString());
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)$this.listenerConnRateMetric(listenerName.value()).metricValue()), (double)$this.eps(), (String)new StringBuilder(47).append("Connection acceptance rate metric for listener ").append(listenerName.value()).toString());
        Assertions.assertNotNull((Object)$this.listenerConnThrottleMetric(listenerName.value()), (String)new StringBuilder(70).append("Expected connection-accept-throttle-time metric to exist for listener ").append(listenerName.value()).toString());
        Assertions.assertEquals((long)0L, (long)((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnThrottleMetric(listenerName.value()).metricValue())), (String)new StringBuilder(49).append("Listener connection throttle metric for listener ").append(listenerName.value()).toString());
        Assertions.assertEquals((long)0L, (long)((long)BoxesRunTime.unboxToDouble((Object)$this.ipConnThrottleMetric(listenerName.value()).metricValue())), (String)new StringBuilder(43).append("Ip connection throttle metric for listener ").append(listenerName.value()).toString());
    }

    public static final /* synthetic */ void $anonfun$verifyNoBlockedPercentRecordedOnAllListeners$1(String name, Meter meter) {
        Assertions.assertEquals((long)0L, (long)meter.count(), (String)new StringBuilder(40).append("BlockedPercentMeter metric for ").append(name).append(" listener").toString());
    }

    public static final /* synthetic */ void $anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$1(String name, Meter meter) {
        Assertions.assertTrue((meter.count() > 0L ? 1 : 0) != 0, (String)new StringBuilder(64).append("Expected BlockedPercentMeter metric for ").append(name).append(" listener to be recorded").toString());
    }

    public static final /* synthetic */ void $anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$2(ConnectionQuotasTest $this, ListenerDesc listener) {
        Assertions.assertTrue(((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnThrottleMetric(listener.listenerName().value()).metricValue()) > 0L ? 1 : 0) != 0, (String)new StringBuilder(40).append("Connection throttle metric for listener ").append(listener.listenerName().value()).toString());
    }

    public static final /* synthetic */ void $anonfun$verifyOnlyNonInterBrokerListenersBlockedPercentRecorded$1(String name, Meter meter) {
        switch (name == null ? 0 : name.hashCode()) {
            case 1090493356: {
                if (!"REPLICATION".equals(name)) break;
                Assertions.assertEquals((long)0L, (long)meter.count(), (String)new StringBuilder(40).append("BlockedPercentMeter metric for ").append(name).append(" listener").toString());
                return;
            }
        }
        Assertions.assertTrue((meter.count() > 0L ? 1 : 0) != 0, (String)new StringBuilder(64).append("Expected BlockedPercentMeter metric for ").append(name).append(" listener to be recorded").toString());
    }

    public static final /* synthetic */ void $anonfun$verifyConnectionCountOnEveryListener$1(int expectedConnectionCount$1, ConnectionQuotas connectionQuotas$2, ListenerDesc listener) {
        Assertions.assertEquals((int)expectedConnectionCount$1, (int)connectionQuotas$2.get(listener.defaultIp()), (String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString());
    }

    public static final /* synthetic */ TooManyConnectionsException $anonfun$acceptConnectionsAboveIpLimit$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$4, ListenerName listenerName$2, ListenerDesc listenerDesc$1, long i) {
        return (TooManyConnectionsException)Assertions.assertThrows(TooManyConnectionsException.class, () -> connectionQuotas$4.inc(listenerName$2, listenerDesc$1.defaultIp(), (Meter)$this.blockedPercentMeters().apply((Object)listenerName$2.value())));
    }

    public ConnectionQuotasTest() {
        this.numQuotaSamples = 2;
        this.quotaWindowSizeSeconds = 1;
        this.eps = 0.01;
    }

    public class ListenerDesc
    implements Product,
    Serializable {
        private final ListenerName listenerName;
        private final InetAddress defaultIp;
        public final /* synthetic */ ConnectionQuotasTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public InetAddress defaultIp() {
            return this.defaultIp;
        }

        public String toString() {
            return new StringBuilder(20).append("(listener=").append(this.listenerName().value()).append(", client=").append(this.defaultIp().getHostAddress()).append(")").toString();
        }

        public ListenerDesc copy(ListenerName listenerName, InetAddress defaultIp) {
            return new ListenerDesc(this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer(), listenerName, defaultIp);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public InetAddress copy$default$2() {
            return this.defaultIp();
        }

        public String productPrefix() {
            return "ListenerDesc";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.listenerName();
                }
                case 1: {
                    return this.defaultIp();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ListenerDesc;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "listenerName";
                }
                case 1: {
                    return "defaultIp";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ListenerDesc)) return false;
            if (((ListenerDesc)x$1).kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() != this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ListenerDesc listenerDesc = (ListenerDesc)x$1;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = listenerDesc.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            InetAddress inetAddress = this.defaultIp();
            InetAddress inetAddress2 = listenerDesc.defaultIp();
            if (inetAddress == null) {
                if (inetAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetAddress).equals(inetAddress2)) return false;
            if (!listenerDesc.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ConnectionQuotasTest kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() {
            return this.$outer;
        }

        public ListenerDesc(ConnectionQuotasTest $outer, ListenerName listenerName, InetAddress defaultIp) {
            this.listenerName = listenerName;
            this.defaultIp = defaultIp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

