/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.Kafka$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.BaseAuthorizerTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rUc\u0001\u0002,X\u0001yCQ!\u001b\u0001\u0005\u0002)Dq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004|\u0001\u0001\u0006IA\u001c\u0005\by\u0002\u0011\r\u0011\"\u0003n\u0011\u0019i\b\u0001)A\u0005]\"9a\u0010\u0001b\u0001\n\u0013i\u0007BB@\u0001A\u0003%a\u000eC\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u0011\u0011\u0003\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u0011Q\u0003\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u0011\u0011\u0004\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003\u0002\u001e!A\u0011Q\u0006\u0001!\u0002\u0013\ty\u0002C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u00022!A\u0011\u0011\b\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u00022!A\u0011Q\b\u0001!\u0002\u0013\t\u0019D\u0002\u0004\u0002@\u0001\u0001\u0011\u0011\t\u0005\u000b\u0003\u0007\"\"\u0011!Q\u0001\n\u0005\u0015\u0003BCA0)\t\u0005\t\u0015!\u0003\u0002F!1\u0011\u000e\u0006C\u0001\u0003CBq!a\u001b\u0015\t\u0003\ni\u0007\u0003\u0004Y\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003\u001f\u0003A\u0011IAI\u0011\u001d\tI\f\u0001C!\u0003wCq!!2\u0001\t\u0003\tY\fC\u0004\u0002P\u0002!\t!a/\t\u000f\u0005M\u0007\u0001\"\u0001\u0002<\"9\u0011q\u001b\u0001\u0005\u0002\u0005m\u0006bBAn\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003?\u0004A\u0011AA^\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003wCq!a:\u0001\t\u0003\tY\fC\u0004\u0002l\u0002!\t!a/\t\u000f\u0005=\b\u0001\"\u0001\u0002<\"9\u00111\u001f\u0001\u0005\u0002\u0005m\u0006bBA|\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003w\u0004A\u0011AA^\u0011\u001d\ty\u0010\u0001C\u0001\u0003wCqAa\u0001\u0001\t\u0003\tY\fC\u0004\u0003\b\u0001!\t!a/\t\u000f\t-\u0001\u0001\"\u0001\u0002<\"9!q\u0002\u0001\u0005\u0002\u0005m\u0006b\u0002B\n\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011y\u0003\u0001C\u0005\u0005cAqA!\u000f\u0001\t\u0003\tY\fC\u0004\u0003>\u0001!\t!a/\t\u000f\t\u0005\u0003\u0001\"\u0001\u0002<\"9!Q\t\u0001\u0005\u0002\u0005m\u0006b\u0002B%\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005\u001b\u0002A\u0011AA^\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0003wCqA!\u0016\u0001\t\u0003\tY\fC\u0004\u0003Z\u0001!\t!a/\t\u000f\tu\u0003\u0001\"\u0001\u0002<\"9!\u0011\r\u0001\u0005\u0002\u0005m\u0006b\u0002B3\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005S\u0002A\u0011AA^\u0011\u001d\u0011i\u0007\u0001C\u0001\u0003wCqA!\u001d\u0001\t\u0003\tY\fC\u0004\u0003v\u0001!\t!a/\t\u000f\te\u0004\u0001\"\u0001\u0002<\"9!Q\u0010\u0001\u0005\u0002\u0005m\u0006b\u0002BA\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005\u000b\u0003A\u0011AA^\u0011\u001d\u0011I\t\u0001C\u0001\u0003wCqA!$\u0001\t\u0003\tY\fC\u0004\u0003\u0012\u0002!\t!a/\t\u000f\tU\u0005\u0001\"\u0001\u0002<\"9!\u0011\u0014\u0001\u0005\u0002\u0005m\u0006b\u0002BO\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005C\u0003A\u0011\u0002BR\u0011\u001d\u0011I\f\u0001C\u0005\u0005wCqA!6\u0001\t\u0013\u00119\u000eC\u0005\u0003j\u0002\t\n\u0011\"\u0003\u0003l\"91\u0011\u0001\u0001\u0005\n\r\r\u0001bBB\u000f\u0001\u0011%1q\u0004\u0005\b\u0007;\u0001A\u0011BB\u0014\u0011\u001d\u0019i\u0002\u0001C\u0005\u0007oAqaa\u000f\u0001\t\u0013\u0019i\u0004C\u0004\u0004D\u0001!Ia!\u0012\t\u000f\r\u001d\u0003\u0001\"\u0003\u0004J\t\t\u0012i\u00197BkRDwN]5{KJ$Vm\u001d;\u000b\u0005aK\u0016AC1vi\"|'/\u001b>fe*\u0011!lW\u0001\tg\u0016\u001cWO]5us*\tA,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001yV\r\u0005\u0002aG6\t\u0011M\u0003\u0002c7\u000611/\u001a:wKJL!\u0001Z1\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002gO6\tq+\u0003\u0002i/\n\u0011\")Y:f\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u000e\u0005\u0002g\u0001\u0005a\u0011\r\u001c7poJ+\u0017\rZ!dYV\ta\u000e\u0005\u0002ps6\t\u0001O\u0003\u0002re\u0006\u0019\u0011m\u00197\u000b\u0005M$\u0018AB2p[6|gN\u0003\u0002]k*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h\u0013\tQ\bO\u0001\nBG\u000e,7o]\"p]R\u0014x\u000e\\#oiJL\u0018!D1mY><(+Z1e\u0003\u000ed\u0007%A\u0007bY2|wo\u0016:ji\u0016\f5\r\\\u0001\u000fC2dwn^,sSR,\u0017i\u00197!\u0003-!WM\\=SK\u0006$\u0017i\u00197\u0002\u0019\u0011,g.\u001f*fC\u0012\f5\r\u001c\u0011\u0002!]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,WCAA\u0003!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006e\u0006A!/Z:pkJ\u001cW-\u0003\u0003\u0002\u0010\u0005%!a\u0004*fg>,(oY3QCR$XM\u001d8\u0002#]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,\u0007%\u0001\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0006\t\u0002O]3gSb,GMU3t_V\u00148-\u001a\u0011\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016\f\u0001c\u00197vgR,'OU3t_V\u00148-\u001a\u0011\u0002#]LG\u000eZ2be\u0012\u0004&/\u001b8dSB\fG.\u0006\u0002\u0002 A!\u0011\u0011EA\u0015\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012\u0001B1vi\"T!A\u0017:\n\t\u0005-\u00121\u0005\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003I9\u0018\u000e\u001c3dCJ$\u0007K]5oG&\u0004\u0018\r\u001c\u0011\u0002\u001b\u0005\u001cG.Q;uQ>\u0014\u0018N_3s+\t\t\u0019\u0004E\u0002g\u0003kI1!a\u000eX\u00055\t5\r\\!vi\"|'/\u001b>fe\u0006q\u0011m\u00197BkRDwN]5{KJ\u0004\u0013AD1dY\u0006+H\u000f[8sSj,'OM\u0001\u0010C\u000ed\u0017)\u001e;i_JL'0\u001a:3A\ty1)^:u_6\u0004&/\u001b8dSB\fGnE\u0002\u0015\u0003?\tQ\u0002\u001d:j]\u000eL\u0007/\u00197UsB,\u0007\u0003BA$\u00033rA!!\u0013\u0002VA!\u00111JA)\u001b\t\tiEC\u0002\u0002Pu\u000ba\u0001\u0010:p_Rt$BAA*\u0003\u0015\u00198-\u00197b\u0013\u0011\t9&!\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\tY&!\u0018\u0003\rM#(/\u001b8h\u0015\u0011\t9&!\u0015\u0002\t9\fW.\u001a\u000b\u0007\u0003G\n9'!\u001b\u0011\u0007\u0005\u0015D#D\u0001\u0001\u0011\u001d\t\u0019e\u0006a\u0001\u0003\u000bBq!a\u0018\u0018\u0001\u0004\t)%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003_\n9\b\u0005\u0003\u0002r\u0005MTBAA)\u0013\u0011\t)(!\u0015\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0010\rA\u0002\u0005m\u0014!A8\u0011\t\u0005E\u0014QP\u0005\u0005\u0003\u007f\n\tFA\u0002B]f,\"!a!\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1\u0001WAE\u0015\t\u0011G/\u0003\u0003\u0002\u000e\u0006\u001d%AC!vi\"|'/\u001b>fe\u0006)1/\u001a;VaR!\u00111SAM!\u0011\t\t(!&\n\t\u0005]\u0015\u0011\u000b\u0002\u0005+:LG\u000fC\u0004\u0002\u001cj\u0001\r!!(\u0002\u0011Q,7\u000f^%oM>\u0004B!a(\u0002.6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+A\u0002ba&TA!a*\u0002*\u00069!.\u001e9ji\u0016\u0014(bAAVo\u0006)!.\u001e8ji&!\u0011qVAQ\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\u000e\u00024B!\u0011qTA[\u0013\u0011\t9,!)\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\t\u0019\nK\u0002\u001c\u0003\u007f\u0003B!a(\u0002B&!\u00111YAQ\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0014uKN$\u0018)\u001e;i_JL'0\u001a+ie><8o\u00148O_:d\u0015\u000e^3sC2\u0014Vm]8ve\u000e,\u0007f\u0001\u000f\u0002JB!\u0011qTAf\u0013\u0011\ti-!)\u0003\tQ+7\u000f^\u0001#i\u0016\u001cH/Q;uQ>\u0014\u0018N_3XSRDW)\u001c9usJ+7o\\;sG\u0016t\u0015-\\3)\u0007u\tI-A\u000euKN$X)\u001c9us\u0006\u001bG\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004=\u0005%\u0017\u0001\u0004;fgR$v\u000e]5d\u0003\u000ed\u0007fA\u0010\u0002J\u0006\u0011C/Z:u\u00032dwn^!dG\u0016\u001c8oV5uQ\u000e+8\u000f^8n!JLgnY5qC2D3\u0001IAe\u0003]!Xm\u001d;EK:LH+Y6fgB\u0013XmY3eK:\u001cW\rK\u0002\"\u0003\u0013\f!\u0003^3ti\u0006cGn\\<BY2\f5mY3tg\"\u001a!%!3\u0002-Q,7\u000f^*va\u0016\u0014Xk]3s\u0011\u0006\u001c\u0018iY2fgND3aIAe\u0003%\"Xm\u001d;TkB,'/V:fe^KG\u000f[\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197ICN\f5mY3tg\"\u001aA%!3\u0002!Q,7\u000f^,jY\u0012\u001c\u0015M\u001d3BG2\u001c\bfA\u0013\u0002J\u0006qA/Z:u\u001d>\f5\r\u001c$pk:$\u0007f\u0001\u0014\u0002J\u00061B/Z:u\u001d>\f5\r\u001c$pk:$wJ^3se&$W\rK\u0002(\u0003\u0013\fQ\u0003^3ti\u0006\u001bG.T1oC\u001e,W.\u001a8u\u0003BK5\u000fK\u0002)\u0003\u0013\fQ\u0002^3ti2{\u0017\rZ\"bG\",\u0007fA\u0015\u0002J\u0006AB/Z:u\u0007\"\fgnZ3MSN$XM\\3s)&l\u0017N\\4)\u0007)\nI-A\u0017uKN$Hj\\2bY\u000e{gnY;se\u0016tG/T8eS\u001aL7-\u0019;j_:|eMU3t_V\u00148-Z!dYND3aKAe\u0003M\"Xm\u001d;ESN$(/\u001b2vi\u0016$7i\u001c8dkJ\u0014XM\u001c;N_\u0012Lg-[2bi&|gn\u00144SKN|WO]2f\u0003\u000ed7\u000fK\u0002-\u0003\u0013\fQ\u0006^3ti\"Kw\r[\"p]\u000e,(O]3oGflu\u000eZ5gS\u000e\fG/[8o\u001f\u001a\u0014Vm]8ve\u000e,\u0017i\u00197tQ\ri\u0013\u0011Z\u0001\u0013i\u0016\u001cH/Q2m\u0013:DWM]5uC:\u001cW\rK\u0002/\u0003\u0013\fq\u0003^3ti&k\u0007\u000f\\5dCRLwN\\:PM\u0006cGn\\<\u0015\r\u0005M%1\u0004B\u0013\u0011\u001d\u0011ib\fa\u0001\u0005?\t\u0001\u0002]1sK:$x\n\u001d\t\u0004_\n\u0005\u0012b\u0001B\u0012a\na\u0011i\u00197Pa\u0016\u0014\u0018\r^5p]\"9!qE\u0018A\u0002\t%\u0012AC1mY><X\rZ(qgB1\u0011q\tB\u0016\u0005?IAA!\f\u0002^\t\u00191+\u001a;\u0002-Q,7\u000f^%na2L7-\u0019;j_:\u001cxJ\u001a#f]f$b!a%\u00034\tU\u0002b\u0002B\u000fa\u0001\u0007!q\u0004\u0005\b\u0005o\u0001\u0004\u0019\u0001B\u0015\u0003%!WM\\5fI>\u00038/A\u0015uKN$\b*[4i\u0007>t7-\u001e:sK:\u001c\u0017\u0010R3mKRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004c\u0005%\u0017a\r;fgR\f5mY3tg\u0006cGn\\<fI&3\u0017\t\u001c7po\u0006\u001bG.\u0012=jgR\u001cxJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\r\u0011\u0014\u0011Z\u0001 i\u0016\u001cH\u000fR3mKR,\u0017i\u00197P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007fA\u001a\u0002J\u0006\u0011C/Z:u\t\u0016dW\r^3BY2\f5\r\\(o/&dGmY1sIJ+7o\\;sG\u0016D3\u0001NAe\u0003M\"Xm\u001d;BG\u000e,7o]!mY><X\rZ%g\u00032dwn^!dY\u0016C\u0018n\u001d;t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u00026\u0003\u0013\fq\u0004^3ti\u0012+G.\u001a;f\u0003\u000edwJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\r1\u0014\u0011Z\u0001#i\u0016\u001cH\u000fR3mKR,\u0017\t\u001c7BG2|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\u0007]\nI-\u0001\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\u001c'ji\u0016\u0014\u0018\r\u001c*fg>,(oY3)\u0007a\nI-A\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\rI\u0014\u0011Z\u0001\u001ei\u0016\u001cH/\u00113e\u0003\u000ed7o\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\u001a!(!3\u0002CQ,7\u000f^!vi\"|'/\u001b>f/&$\b\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\u0007m\nI-A\u0010uKN$8+\u001b8hY\u0016\u001c\u0005.\u0019:bGR,'OU3t_V\u00148-Z!dYND3\u0001PAe\u0003Q!Xm\u001d;HKR\f5\r\\:Qe&t7-\u001b9bY\"\u001aQ(!3\u0002\u001dQ,7\u000f^!dYN4\u0015\u000e\u001c;fe\"\u001aa(!3\u0002yQ,7\u000f\u001e+ie><8o\u00148BI\u0012\u0004&/\u001a4jq\u0016$\u0017i\u00197JM&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8U_>dun\u001e\u0015\u0004\u007f\u0005%\u0017\u0001\n;fgR\u001c%/Z1uK\u0006\u001bGnV5uQ&sg/\u00197jIJ+7o\\;sG\u0016t\u0015-\\3)\u0007\u0001\u000bI-A\u001euKN$xK]5uKN,\u0005\u0010^3oI\u0016$\u0017i\u00197DQ\u0006tw-Z#wK:$\u0018JZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dgj\u001c;TKRD3!QAe\u0003\u0015#Xm\u001d;Xe&$Xm]#yi\u0016tG-\u001a3BG2\u001c\u0005.\u00198hK\u00163XM\u001c;XQ\u0016t\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pY\u0006#H*Z1ti.\u000bgm[1We!\u001a!)!3\u0002qR,7\u000f^,sSR,7\u000fT5uKJ\fGn\u0016:ji\u0016\u001cH*\u001b;fe\u0006d\u0017i\u00197DQ\u0006tw-Z#wK:$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c'fgN$\u0006.\u00198LC\u001a\\\u0017M\u0016\u001afe\u0006d\u0017i\u00197DQ\u0006tw-Z:G_J|E\u000eZ3s!J|Go\\2pYZ+'o]5p]ND3aQAe\u0003}\"Xm\u001d;Xe&$Xm\u001d'ji\u0016\u0014\u0018\r\\!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u0013N\\\u0015MZ6b-JB3\u0001RAe\u0003a!Xm\u001d;BkRDwN]5{KJtuNW6D_:4\u0017n\u001a\u0015\u0004\u000b\u0006%\u0017!\r;fgR\fU\u000f\u001e5pe&TXM\u001d.l\u0007>tg-[4Ge>l7*\u00194lC\u000e{gNZ5h/&$\b\u000eR3gCVdGo\u001d\u0015\u0004\r\u0006%\u0017!\n;fgR\fU\u000f\u001e5pe&TXM\u001d.l\u0007>tg-[4Ge>l7*\u00194lC\u000e{gNZ5hQ\r9\u0015\u0011Z\u0001*i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s5.\u001cuN\u001c4jO\u001a\u0013x.\u001c)sK\u001aL\u0007p\u0014<feJLG-Z:)\u0007!\u000bI-\u0001\fuKN$8I]3bi\u0016$U\r\\3uKRKW.\u001b8hQ\rI\u0015\u0011Z\u0001.i\u0016\u001cH/Q;uQ>\u0014\u0018N_3CsJ+7o\\;sG\u0016$\u0016\u0010]3O_\u0006\u001bGNR8v]\u0012|e/\u001a:sS\u0012,\u0007f\u0001&\u0002J\u0006\u0011s-\u001b<f]\u0006+H\u000f[8sSj,'oV5uQB\u0013x\u000e^8d_24VM]:j_:$B!a%\u0003&\"9!qU&A\u0002\t%\u0016a\u00049s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0011\r\u0005E$1\u0016BX\u0013\u0011\u0011i+!\u0015\u0003\r=\u0003H/[8o!\u0011\u0011\tL!.\u000e\u0005\tM&bA:\u0002\n&!!q\u0017BZ\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017!G4fi\u0006\u001bGn\u00115b]\u001e,WI^3oi\u0006\u001b8\u000b\u001e:j]\u001e$BA!0\u0003LB!!q\u0018Be\u001b\t\u0011\tM\u0003\u0003\u0003D\n\u0015\u0017\u0001\u00027b]\u001eT!Aa2\u0002\t)\fg/Y\u0005\u0005\u00037\u0012\t\rC\u0004\u0003N2\u0003\rAa4\u0002\u0017A\fG\u000f^3s]RK\b/\u001a\t\u0005\u0003\u000f\u0011\t.\u0003\u0003\u0003T\u0006%!a\u0003)biR,'O\u001c+za\u0016\f!c\u00195b]\u001e,\u0017i\u00197B]\u00124VM]5gsRQ!\u0011\u001cBn\u0005?\u0014\u0019Oa:\u0011\u000b\u0005\u001d#1\u00068\t\u000f\tuW\n1\u0001\u0003Z\u0006aqN]5hS:\fG.Q2mg\"9!\u0011]'A\u0002\te\u0017!C1eI\u0016$\u0017i\u00197t\u0011\u001d\u0011)/\u0014a\u0001\u00053\f1B]3n_Z,G-Q2mg\"I\u00111B'\u0011\u0002\u0003\u0007\u0011QA\u0001\u001dG\"\fgnZ3BG2\fe\u000e\u001a,fe&4\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iO\u000b\u0003\u0002\u0006\t=8F\u0001By!\u0011\u0011\u0019P!@\u000e\u0005\tU(\u0002\u0002B|\u0005s\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tm\u0018\u0011K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0000\u0005k\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003%\tW\u000f\u001e5pe&TX\r\u0006\u0006\u0002p\r\u00151qAB\f\u00077Aa\u0001W(A\u0002\u0005M\u0002bBB\u0005\u001f\u0002\u000711B\u0001\u000fe\u0016\fX/Z:u\u0007>tG/\u001a=u!\u0011\u0019iaa\u0005\u000e\u0005\r=!bAB\te\u0006A!/Z9vKN$8/\u0003\u0003\u0004\u0016\r=!A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u00073y\u0005\u0019\u0001B\u0010\u0003%y\u0007/\u001a:bi&|g\u000eC\u0004\u0002\f=\u0003\r!!\u0002\u0002\u000f\u001d,G/Q2mgR1!\u0011\\B\u0011\u0007GAa\u0001\u0017)A\u0002\u0005M\u0002bBB\u0013!\u0002\u0007\u0011QA\u0001\u0010e\u0016\u001cx.\u001e:dKB\u000bG\u000f^3s]R11\u0011FB\u0019\u0007g\u0001b!a\u0012\u0003,\r-\u0002cA8\u0004.%\u00191q\u00069\u0003\u0015\u0005\u001bGNQ5oI&tw\r\u0003\u0004Y#\u0002\u0007\u00111\u0007\u0005\b\u0007k\t\u0006\u0019AA\u0010\u0003%\u0001(/\u001b8dSB\fG\u000e\u0006\u0003\u0004*\re\u0002B\u0002-S\u0001\u0004\t\u0019$A\u0004wC2LGm\u00149\u0015\t\u0005=4q\b\u0005\b\u0007\u0003\u001a\u0006\u0019\u0001B\u0010\u0003\ty\u0007/\u0001\u000bqe\u0016\u0004\u0018M]3EK\u001a\fW\u000f\u001c;D_:4\u0017nZ\u000b\u0003\u0003\u000b\nQ\u0002\u001d:fa\u0006\u0014XmQ8oM&<G\u0003BA#\u0007\u0017Bqa!\u0014V\u0001\u0004\u0019y%A\u0003mS:,7\u000f\u0005\u0004\u0002r\rE\u0013QI\u0005\u0005\u0007'\n\tFA\u0003BeJ\f\u0017\u0010")
public class AclAuthorizerTest
extends QuorumTestHarness
implements BaseAuthorizerTest {
    private final AccessControlEntry allowReadAcl;
    private final AccessControlEntry allowWriteAcl;
    private final AccessControlEntry denyReadAcl;
    private final ResourcePattern wildCardResource;
    private final ResourcePattern prefixedResource;
    private final ResourcePattern clusterResource;
    private final KafkaPrincipal wildcardPrincipal;
    private final AclAuthorizer aclAuthorizer;
    private final AclAuthorizer aclAuthorizer2;
    private String superUsers;
    private String username;
    private KafkaPrincipal principal;
    private RequestContext requestContext;
    private String superUserName;
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;
    private ResourcePattern resource;

    @Override
    @Test
    public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeMultipleAddAndRemove$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeDenyTakesPrecedence$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypePrefixedResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWildcardResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllOperationAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllOperationAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllHostAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllHostAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllPrincipalAce$(this);
    }

    @Override
    @Test
    public void testAuthorzeByResourceTypeSuperUserHasAccess() {
        BaseAuthorizerTest.testAuthorzeByResourceTypeSuperUserHasAccess$(this);
    }

    @Override
    public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return BaseAuthorizerTest.newRequestContext$(this, principal, clientAddress, apiKey);
    }

    @Override
    public ApiKeys newRequestContext$default$3() {
        return BaseAuthorizerTest.newRequestContext$default$3$(this);
    }

    @Override
    public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return BaseAuthorizerTest.authorizeByResourceType$(this, authorizer, requestContext, operation, resourceType);
    }

    @Override
    public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        BaseAuthorizerTest.addAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        return BaseAuthorizerTest.removeAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public String superUsers() {
        return this.superUsers;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public String superUserName() {
        return this.superUserName;
    }

    @Override
    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    public ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    @Override
    public void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    public ResourcePattern resource() {
        return this.resource;
    }

    @Override
    public void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String x$1) {
        this.superUsers = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String x$1) {
        this.username = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal x$1) {
        this.principal = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext x$1) {
        this.requestContext = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String x$1) {
        this.superUserName = x$1;
    }

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    @Override
    public Authorizer authorizer() {
        return this.aclAuthorizer();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest", new ZKClientConfig(), "AclAuthorizerTest"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test
    public void testAuthorizeThrowsOnNonLiteralResource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED)));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException), (String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString());
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should have WRITE access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host2 as no allow acl is defined");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should not have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should have DESCRIBE access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host2");
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.resource()), (String)"User2 should have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.resource()), (String)"User3 should have DESCRIBE access from host2");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.READ, this.resource()), (String)"User2 should have READ access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.WRITE, this.resource()), (String)"User3 should have WRITE access from host2");
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()), (String)"deny should take precedence over allow.");
    }

    @Test
    public void testAllowAllAccess() {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), context, AclOperation.READ, this.resource()), (String)"allow all acl should allow access to all.");
    }

    @Test
    public void testSuperUserHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session1, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session2, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()), (String)"superuser with custom principal always has access, no matter what acls.");
    }

    @Test
    public void testWildCardAcls() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should fail close.");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host1");
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host1");
    }

    @Test
    public void testNoAclFound() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should deny op.");
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = new AclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.");
        }
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"changes not propagated in timeout period");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"changes not propagated in timeout period");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL)), acls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL)), acls)}));
        resourceToAcls.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ResourcePattern key = (ResourcePattern)x0$1._1();
            Set value = (Set)x0$1._2();
            Set<AccessControlEntry> set = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        Set expectedAcls = ((IterableOnceOps)resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), acls)).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            ResourcePattern res = (ResourcePattern)x0$2._1();
            Set set = (Set)((Set)x0$2._2()).map((Function1 & Serializable)acl -> new AclBinding(res, acl));
            return set;
        })).toSet();
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)"changes not propagated in timeout period.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.resource());
        acls = null;
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), AccessControlEntryFilter.ANY);
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource()));
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.resource());
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource()));
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assertions.assertEquals((Object)acls, this.getAcls(authorizer, this.resource()));
            Assertions.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
        }
    }

    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(() -> aclAuthorizer3.configure(this.config().originals()));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)}));
            this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.resource()));
        }
        finally {
            aclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource), (String)"The authorizer should see a value that needs to be deleted");
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        IndexedSeq acls = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable)i -> AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            AccessControlEntry acl = (AccessControlEntry)x0$1._1();
            int aclId = x0$1._2$mcI$sp();
            Function0 & Serializable intersect = (Function0 & Serializable)() -> {
                if (aclId % 2 == 0) {
                    this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                } else {
                    this.addAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                }
                if (aclId % 10 == 0) {
                    return BoxesRunTime.boxToBoolean((boolean)this.removeAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource));
                }
                return BoxedUnit.UNIT;
            };
            return intersect;
        });
        Set expectedAcls = ((IterableOnceOps)((IndexedSeqOps)acls.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(x0$2)))).map((Function1 & Serializable)x$1 -> (AccessControlEntry)x$1._1())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS}))));
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()), (Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)))), (Function1 & Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()), (Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)))), (Function1 & Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        IndexedSeq concurrentFuctions = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable)x$2 -> AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$2)));
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer2(), this.resource(), AccessControlEntryFilter.ANY);
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.resource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.resource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size(), (String)"acl on specific should not be returned for wildcard request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size(), (String)"acl on specific should be returned for different principal instance");
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.resource());
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size(), (String)"acl on wildcard should be returned for wildcard request");
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on wildcard should not be returned for specific request");
    }

    @Test
    public void testAclsFilter() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4}))).asJava());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.aclAuthorizer().acls(AclBindingFilter.ANY)).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.aclAuthorizer().acls(matchingFilter)).asScala().toSet());
        List filters = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{matchingFilter, acl1.toFilter(), new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY)}));
        Buffer deleteResults = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)filters).asJava())).asScala().map((Function1 & Serializable)x$3 -> (AclDeleteResult)x$3.toCompletableFuture().get());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)deleteResults.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$2(x$4))));
        filters.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(i)).aclBindingDeleteResults()).asScala().toSet().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$4(x$5)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$6 -> x$6.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$7 -> x$7.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$8 -> x$8.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$9 -> x$9.aclBinding())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.apply((Object)MetadataVersion.IBP_2_0_IV0));
        ApiException e = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED)));
        Assertions.assertTrue((boolean)(e.getCause() instanceof UnsupportedVersionException), (String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString());
    }

    @Test
    public void testCreateAclWithInvalidResourceName() {
        Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "test/1", PatternType.LITERAL)));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.empty());
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.apply((Object)MetadataVersion.IBP_2_0_IV1));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.apply((Object)MetadataVersion.IBP_2_0_IV0));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<MetadataVersion>)Option$.MODULE$.apply((Object)MetadataVersion.IBP_2_0_IV1));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAuthorizerNoZkConfig() {
        Properties noTlsProps = Kafka$.MODULE$.getPropsFromArgs(new String[]{this.prepareDefaultConfig()});
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(noTlsProps), CollectionConverters$.MODULE$.MapHasAsScala((Map)noTlsProps).asScala());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)propName -> {
            AclAuthorizerTest.$anonfun$testAuthorizerNoZkConfig$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromKafkaConfigWithDefaults() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue)}));
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value);
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromKafkaConfig() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp()), (Object)"false")}));
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromPrefixOverrides() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        String prefixedValue = "prefixedValue";
        String prefix = "authorizer.";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslProtocolProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()).toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCrlEnableProp()).toString()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslOcspEnableProp()).toString()), (Object)"true")}));
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(zkClientConfig, prefixedValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateDeleteTiming() {
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        ResourcePattern wildcardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        Semaphore updateSemaphore = new Semaphore(1);
        try (AclAuthorizer deleteAuthorizer = new AclAuthorizer(null, updateSemaphore){
            private final Semaphore updateSemaphore$1;

            public void processAclChangeNotification(ResourcePattern resource) {
                this.updateSemaphore$1.acquire();
                try {
                    super.processAclChangeNotification(resource);
                }
                finally {
                    this.updateSemaphore$1.release();
                }
            }
            {
                this.updateSemaphore$1 = updateSemaphore$1;
            }
        };){
            deleteAuthorizer.configure(this.config().originals());
            ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{literalResource, prefixedResource, wildcardResource}))).foreach((Function1 & Serializable)resource -> {
                AclAuthorizerTest.$anonfun$testCreateDeleteTiming$9(this, deleteAuthorizer, updateSemaphore, ace, resource);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testAuthorizeByResourceTypeNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer aclAuthorizer = new AclAuthorizer();){
            aclAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)this.authorizeByResourceType((Authorizer)aclAuthorizer, this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have read access to at least one topic");
            Assertions.assertTrue((boolean)this.authorizeByResourceType((Authorizer)aclAuthorizer, this.requestContext(), AclOperation.WRITE, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have write access to at least one topic");
        }
    }

    private void givenAuthorizerWithProtocolVersion(Option<MetadataVersion> protocolVersion) {
        this.aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1 & Serializable)version -> props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), true, (Option)None$.MODULE$));
        children.maybeThrow();
        Assertions.assertEquals((int)1, (int)children.children().size(), (String)"Expecting 1 change event");
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), (Option)None$.MODULE$));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls((Authorizer)this.aclAuthorizer(), addedAcls, resource);
            acls = (Set)originalAcls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls((Authorizer)this.aclAuthorizer(), removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls, (Authorizer)this.aclAuthorizer(), resource, AccessControlEntryFilter.ANY);
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private boolean authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(authorizer.authorize((AuthorizableRequestContext)requestContext, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Action[]{action}))).asJava())).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet().map((Function1 & Serializable)x$14 -> x$14.entry());
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(filter)).asScala().toSet();
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(AclBindingFilter.ANY)).asScala().toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    private String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"broker.id=1", "zookeeper.connect=somewhere"});
    }

    private String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)l -> {
                AclAuthorizerTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AclAuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        Object object = ((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1}))).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AclAuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        Object object = ((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1}))).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AclAuthorizerTest $this, Set expectedAcls$1) {
        Set set = expectedAcls$1;
        Set<AclBinding> set2 = $this.getAcls($this.aclAuthorizer());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", Integer.toString(i));
        return new Tuple2((Object)new AccessControlEntry(useri.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcI$sp() % 10 != 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString());
            return;
        }
        Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString());
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString());
            return;
        }
        Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString());
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(AclAuthorizerTest $this, AccessControlEntry acl$2, int x$2) {
        return (JFunction0.mcZ.sp & Serializable)() -> {
            $this.addAcls((Authorizer)$this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
            return $this.removeAcls((Authorizer)$this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
        };
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$4) {
        return x$4.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$5) {
        return x$5.exception().isPresent();
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerNoZkConfig$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(ZKClientConfig zkClientConfig$2, String kafkaValue$1, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        if (!(string5 != null ? !string5.equals(prop) : prop != null)) {
            Assertions.assertEquals((Object)"TLSv1.2", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)kafkaValue$1, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfig$2(ZKClientConfig zkClientConfig$3, String kafkaValue$2, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)kafkaValue$2, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(ZKClientConfig zkClientConfig$4, String prefixedValue$1, String prop) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(prop) : prop != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(prop) : prop != null);
            }
        }
        if (bl) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(prop) : prop != null)) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)prefixedValue$1, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
    }

    private final AclBinding createAcl$1(AclAuthorizer createAuthorizer, ResourcePattern resource, AccessControlEntry ace$1) {
        AclBinding acl = new AclBinding(resource, ace$1);
        CollectionConverters$.MODULE$.ListHasAsScala(createAuthorizer.createAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(acl))).asScala().foreach((Function1 & Serializable)x$10 -> (AclCreateResult)x$10.toCompletableFuture().get(15L, TimeUnit.SECONDS));
        return acl;
    }

    private final List deleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resource.resourceType(), resource.name(), deletePatternType), AccessControlEntryFilter.ANY);
        return ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(deleteAuthorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(filter))).asScala().map((Function1 & Serializable)x$11 -> (AclDeleteResult)x$11.toCompletableFuture().get(15L, TimeUnit.SECONDS))).flatMap((Function1 & Serializable)x$12 -> CollectionConverters$.MODULE$.CollectionHasAsScala(x$12.aclBindingDeleteResults()).asScala())).map((Function1 & Serializable)x$13 -> x$13.aclBinding())).toList();
    }

    private static final List listAcls$1(AclAuthorizer authorizer) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(AclBindingFilter.ANY)).asScala().toList();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$5(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$6() {
        return "ACL not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$7(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$8() {
        return "ACL delete not propagated";
    }

    private final void verifyCreateDeleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType, Semaphore updateSemaphore$1, AccessControlEntry ace$1) {
        updateSemaphore$1.acquire();
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)AclAuthorizerTest.listAcls$1(deleteAuthorizer));
        AclBinding acl = this.createAcl$1(this.aclAuthorizer(), resource, ace$1);
        List deleted = this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType);
        PatternType patternType = deletePatternType;
        PatternType patternType2 = PatternType.MATCH;
        if (patternType == null ? patternType2 != null : !patternType.equals(patternType2)) {
            Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl})), (Object)deleted);
        } else {
            Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)deleted);
        }
        updateSemaphore$1.release();
        PatternType patternType3 = deletePatternType;
        PatternType patternType4 = PatternType.MATCH;
        if (!(patternType3 != null ? !patternType3.equals(patternType4) : patternType4 != null)) {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$5(deleteAuthorizer)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"ACL not propagated");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl})), (Object)this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType));
        }
        long l = 15000L;
        long l3 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$7(deleteAuthorizer)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"ACL delete not propagated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l3));
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTiming$9(AclAuthorizerTest $this, AclAuthorizer deleteAuthorizer$2, Semaphore updateSemaphore$1, AccessControlEntry ace$1, ResourcePattern resource) {
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, resource.patternType(), updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.ANY, updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.MATCH, updateSemaphore$1, ace$1);
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public AclAuthorizerTest() {
        BaseAuthorizerTest.$init$(this);
        this.allowReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.allowWriteAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.denyReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        this.prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        this.aclAuthorizer = new AclAuthorizer();
        this.aclAuthorizer2 = new AclAuthorizer();
        Statics.releaseFence();
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

