/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.login.Configuration;
import kafka.raft.KafkaRaftManager;
import kafka.raft.RaftManager;
import kafka.server.ControllerServer;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t%g!\u0002\u001d:\u0003\u0003q\u0004\"B&\u0001\t\u0003a\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B)\t\u000fU\u0003!\u0019!C\u0001!\"1a\u000b\u0001Q\u0001\nECqa\u0016\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0015\u0005\u00063\u0002!\tB\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0005c\u0011\u0019\u0011\b\u0001)A\u0005G\")1\u000f\u0001C\ti\"9\u0011q\u0001\u0001\u0005\u0012\u0005%\u0001bCA\f\u0001\u0001\u0007\t\u0019!C\u0005\u00033A1\"a\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00022!Y\u0011Q\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000e\u0011-\ty\u0004\u0001a\u0001\u0002\u0004%I!!\u0011\t\u0017\u0005%\u0003\u00011AA\u0002\u0013%\u00111\n\u0005\f\u0003\u001f\u0002\u0001\u0019!A!B\u0013\t\u0019\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0001\u0002T!A\u0011q\r\u0001!\u0002\u0013\t)\u0006C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005=\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!a&\u0001\t\u0003\tI\nC\u0004\u0002\"\u0002!\t!!'\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"1\u0011Q\u0016\u0001\u0005\u0002ACq!a,\u0001\t\u0003\t\t\fC\u0004\u0002J\u0002!\t!!-\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007\"CAn\u0001\t\u0007I\u0011AAo\u0011!\tY\u000f\u0001Q\u0001\n\u0005}\u0007bBAw\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011%\u00119\u0003AI\u0001\n\u0003\u0011I\u0003C\u0005\u0003@\u0001\t\n\u0011\"\u0001\u0003B!I!Q\t\u0001\u0012\u0002\u0013\u0005!q\t\u0005\b\u0005\u0017\u0002A\u0011AA8\u0011\u001d\u0011i\u0005\u0001C\u0001\u0003_BqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0004\u0003l\u0001!IA!\u001c\t\u000f\tE\u0004\u0001\"\u0003\u0002v!9!1\u000f\u0001\u0005\u0002\u0005=\u0004b\u0002B?\u0001\u0011\u0005!qP\u0004\b\u0005;K\u0004\u0012\u0001BP\r\u0019A\u0014\b#\u0001\u0003\"\"11J\rC\u0001\u0005GC\u0011B!*3\u0005\u0004%\tAa*\t\u0011\tM&\u0007)A\u0005\u0005SCqA!.3\t\u0003\ty\u0007C\u0004\u0003@J\"\t!a\u001c\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8O\u0003\u0002;w\u000511/\u001a:wKJT\u0011\u0001P\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019KU\"A$\u000b\u0005![\u0014!B;uS2\u001c\u0018B\u0001&H\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"A\u001d\u0002'i\\7i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;\u0016\u0003E\u0003\"\u0001\u0011*\n\u0005M\u000b%aA%oi\u0006!\"p[\"p]:,7\r^5p]RKW.Z8vi\u0002\n\u0001C_6TKN\u001c\u0018n\u001c8US6,w.\u001e;\u0002#i\\7+Z:tS>tG+[7f_V$\b%A\u000b{W6\u000b\u00070\u00138GY&<\u0007\u000e\u001e*fcV,7\u000f^:\u0002-i\\W*\u0019=J]\u001ac\u0017n\u001a5u%\u0016\fX/Z:ug\u0002\nQB_6BG2\u001cXI\\1cY\u0016$W#A.\u0011\u0007\u0001cf,\u0003\u0002^\u0003\n1q\n\u001d;j_:\u0004\"\u0001Q0\n\u0005\u0001\f%a\u0002\"p_2,\u0017M\\\u0001#G>tGO]8mY\u0016\u0014H*[:uK:,'oU3dkJLG/\u001f)s_R|7m\u001c7\u0016\u0003\r\u0004\"\u0001\u001a9\u000e\u0003\u0015T!AZ4\u0002\t\u0005,H\u000f\u001b\u0006\u0003Q&\f\u0001b]3dkJLG/\u001f\u0006\u0003U.\faaY8n[>t'B\u0001\u001fm\u0015\tig.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0006\u0019qN]4\n\u0005E,'\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0003\r\u001awN\u001c;s_2dWM\u001d'jgR,g.\u001a:TK\u000e,(/\u001b;z!J|Go\\2pY\u0002\nac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0002kB\u0019a/_>\u000e\u0003]T!\u0001_!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002{o\n\u00191+Z9\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0003vi&d'BAA\u0001\u0003\u0011Q\u0017M^1\n\u0007\u0005\u0015QP\u0001\u0006Qe>\u0004XM\u001d;jKN\fq\"\\3uC\u0012\fG/\u0019,feNLwN\\\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004U\u0006E!B\u0001\u001el\u0013\u0011\t)\"a\u0004\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0001\u0002^3ti&sgm\\\u000b\u0003\u00037\u0001B!!\b\u0002,5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0002ba&TA!!\n\u0002(\u00059!.\u001e9ji\u0016\u0014(bAA\u0015]\u0006)!.\u001e8ji&!\u0011QFA\u0010\u0005!!Vm\u001d;J]\u001a|\u0017\u0001\u0004;fgRLeNZ8`I\u0015\fH\u0003BA\u001a\u0003s\u00012\u0001QA\u001b\u0013\r\t9$\u0011\u0002\u0005+:LG\u000fC\u0005\u0002<9\t\t\u00111\u0001\u0002\u001c\u0005\u0019\u0001\u0010J\u0019\u0002\u0013Q,7\u000f^%oM>\u0004\u0013AD5na2,W.\u001a8uCRLwN\\\u000b\u0003\u0003\u0007\u00022ATA#\u0013\r\t9%\u000f\u0002\u0015#V|'/^7J[BdW-\\3oi\u0006$\u0018n\u001c8\u0002%%l\u0007\u000f\\3nK:$\u0018\r^5p]~#S-\u001d\u000b\u0005\u0003g\ti\u0005C\u0005\u0002<E\t\t\u00111\u0001\u0002D\u0005y\u0011.\u001c9mK6,g\u000e^1uS>t\u0007%\u0001\tc_>$8\u000f\u001e:baJ+7m\u001c:egV\u0011\u0011Q\u000b\t\u0007\u0003/\ni&!\u0019\u000e\u0005\u0005e#bAA.o\u00069Q.\u001e;bE2,\u0017\u0002BA0\u00033\u0012!\u0002T5ti\n+hMZ3s!\u0011\ti!a\u0019\n\t\u0005\u0015\u0014q\u0002\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002#\t|w\u000e^:ue\u0006\u0004(+Z2pe\u0012\u001c\b%A\u0006jg.\u0013\u0016M\u001a;UKN$H#\u00010\u0002\u001b\rDWmY6Jgj[E+Z:u)\t\t\u0019$\u0001\tdQ\u0016\u001c7.S:L%\u00064G\u000fV3ti\u0006!\u0011m\u001d.l)\t\t9\bE\u0002O\u0003sJ1!a\u001f:\u0005uQvn\\&fKB,'/U;peVl\u0017*\u001c9mK6,g\u000e^1uS>t\u0017aB1t\u0017J\u000bg\r\u001e\u000b\u0003\u0003\u0003\u00032ATAB\u0013\r\t))\u000f\u0002\u001a\u0017J\u000bg\r^)v_J,X.S7qY\u0016lWM\u001c;bi&|g.A\u0005{_>\\W-\u001a9feV\u0011\u00111\u0012\t\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*\u0019\u0011\u0011S\u001e\u0002\u0005i\\\u0017\u0002BAK\u0003\u001f\u0013\u0011#R7cK\u0012$W\r\u001a.p_.,W\r]3s\u0003!Q8n\u00117jK:$XCAAN!\u0011\ti)!(\n\t\u0005}\u0015q\u0012\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u001di\\7\t\\5f]R|%OT;mY\u0006i\u0011\rZ7j]j[7\t\\5f]R,\"!a*\u0011\t\u00055\u0015\u0011V\u0005\u0005\u0003W\u000byIA\u0007BI6LgNW6DY&,g\u000e^\u0001\u0007u.\u0004vN\u001d;\u0002\u0013i\\7i\u001c8oK\u000e$XCAAZ!\u0011\t),a1\u000f\t\u0005]\u0016q\u0018\t\u0004\u0003s\u000bUBAA^\u0015\r\ti,P\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005\u0017)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\f9M\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003\f\u0015a\u0004>l\u0007>tg.Z2u\u001fJtU\u000f\u001c7\u0002!\r|g\u000e\u001e:pY2,'oU3sm\u0016\u0014XCAAh!\rq\u0015\u0011[\u0005\u0004\u0003'L$\u0001E\"p]R\u0014x\u000e\u001c7feN+'O^3s\u0003E\u0019wN\u001c;s_2dWM]*feZ,'o]\u000b\u0003\u00033\u0004BA^=\u0002P\u0006aa-Y;mi\"\u000bg\u000e\u001a7feV\u0011\u0011q\u001c\t\u0005\u0003C\f9/\u0004\u0002\u0002d*!\u0011Q]A\t\u0003\u00151\u0017-\u001e7u\u0013\u0011\tI/a9\u0003!5{7m\u001b$bk2$\b*\u00198eY\u0016\u0014\u0018!\u00044bk2$\b*\u00198eY\u0016\u0014\b%A\u0003tKR,\u0006\u000f\u0006\u0003\u00024\u0005E\bbBA\fK\u0001\u0007\u00111\u0004\u0015\u0004K\u0005U\b\u0003BA\u000f\u0003oLA!!?\u0002 \tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0019\r\u0014X-\u0019;f\u0005J|7.\u001a:\u0015\u0015\u0005}(Q\u0001B\b\u0005;\u0011\t\u0003E\u0002O\u0005\u0003I1Aa\u0001:\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\t\u000f\t\u001da\u00051\u0001\u0003\n\u000511m\u001c8gS\u001e\u00042A\u0014B\u0006\u0013\r\u0011i!\u000f\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0005\u0003\u0012\u0019\u0002\n\u00111\u0001\u0003\u0014\u0005!A/[7f!\u0011\u0011)B!\u0007\u000e\u0005\t]!B\u0001%j\u0013\u0011\u0011YBa\u0006\u0003\tQKW.\u001a\u0005\t\u0005?1\u0003\u0013!a\u0001=\u000691\u000f^1siV\u0004\b\"\u0003B\u0012MA\u0005\t\u0019\u0001B\u0013\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010\u0005\u0003A9\u0006M\u0016AF2sK\u0006$XM\u0011:pW\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t-\"\u0006\u0002B\n\u0005[Y#Aa\f\u0011\t\tE\"1H\u0007\u0003\u0005gQAA!\u000e\u00038\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005s\t\u0015AC1o]>$\u0018\r^5p]&!!Q\bB\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017GJ,\u0017\r^3Ce>\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\t\u0016\u0004=\n5\u0012AF2sK\u0006$XM\u0011:pW\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t%#\u0006\u0002B\u0013\u0005[\t\u0011c\u001d5vi\u0012|wO\u001c.p_.+W\r]3s\u0003]\u0019\b.\u001e;e_^t7JU1gi\u000e{g\u000e\u001e:pY2,'/A\tg_Jl\u0017\r\u001e#je\u0016\u001cGo\u001c:jKN$b!a\r\u0003T\t\u0005\u0004b\u0002B+Y\u0001\u0007!qK\u0001\fI&\u0014Xm\u0019;pe&,7\u000f\u0005\u0004\u0003Z\t}\u00131W\u0007\u0003\u00057R1A!\u0018x\u0003%IW.\\;uC\ndW-C\u0002{\u00057BqAa\u0019-\u0001\u0004\u0011)'\u0001\bnKR\f\u0007K]8qKJ$\u0018.Z:\u0011\u00079\u00139'C\u0002\u0003je\u0012a\"T3uCB\u0013x\u000e]3si&,7/\u0001\boK^\\%+\u00194u#V|'/^7\u0015\t\u0005\u0005%q\u000e\u0005\b\u0003/i\u0003\u0019AA\u000e\u0003IqWm\u001e.p_.+W\r]3s#V|'/^7\u0002\u0011Q,\u0017M\u001d#po:D3a\fB<!\u0011\tiB!\u001f\n\t\tm\u0014q\u0004\u0002\n\u0003\u001a$XM]#bG\"\f1f\u0019:fCR,'l\\8LK\u0016\u0004XM]\"mS\u0016tG\u000fV8Ue&<w-\u001a:TKN\u001c\u0018n\u001c8FqBL'/\u001f\u000b\u0005\u0005\u0003\u0013Y\t\u0005\u0003\u0003\u0004\n\u001dUB\u0001BC\u0015\r\t9\t\\\u0005\u0005\u0005\u0013\u0013)IA\u0005[_>\\U-\u001a9fe\"9!Q\u0012\u0019A\u0002\t\u0005\u0015!\u0003>p_.+W\r]3sQ\u001d\u0001!\u0011\u0013BL\u00053\u0003B!!\b\u0003\u0014&!!QSA\u0010\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u00057\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0006\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0011\u00059\u00134C\u0001\u001a@)\t\u0011y*A\r[W\u000ec\u0017.\u001a8u\u000bZ,g\u000e\u001e+ie\u0016\fGmU;gM&DXC\u0001BU!\u0011\u0011YK!-\u000e\u0005\t5&b\u0001BX\u007f\u0006!A.\u00198h\u0013\u0011\t)M!,\u00025i[7\t\\5f]R,e/\u001a8u)\"\u0014X-\u00193Tk\u001a4\u0017\u000e\u001f\u0011\u0002\u0015M,G/\u00169DY\u0006\u001c8\u000fK\u00027\u0005s\u0003B!!\b\u0003<&!!QXA\u0010\u0005%\u0011UMZ8sK\u0006cG.A\u0007uK\u0006\u0014Hi\\<o\u00072\f7o\u001d\u0015\u0004o\t\r\u0007\u0003BA\u000f\u0005\u000bLAAa2\u0002 \tA\u0011I\u001a;fe\u0006cG\u000e")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests = Integer.MAX_VALUE;
    private final SecurityProtocol controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final ListBuffer<ApiMessageAndVersion> bootstrapRecords = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final MockFaultHandler faultHandler = new MockFaultHandler("quorumTestHarnessFaultHandler");
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latest();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public ListBuffer<ApiMessageAndVersion> bootstrapRecords() {
        return this.bootstrapRecords;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), Level.WARN);
    }

    private void formatDirectories(scala.collection.immutable.Seq<String> directories, MetaProperties metaProperties) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, this.metadataVersion(), false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories).toString());
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        if (props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()) == null) {
            props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()));
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), nodeId);
        this.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties);
        Metrics controllerMetrics = new Metrics();
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        String threadNamePrefix = new StringBuilder(11).append("Controller_").append(testInfo.getDisplayName()).toString();
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        KafkaRaftManager raftManager = new KafkaRaftManager(metaProperties, config, (RecordSerde)MetadataRecordSerde.INSTANCE, new TopicPartition(KafkaRaftServer$.MODULE$.MetadataTopic(), 0), KafkaRaftServer$.MODULE$.MetadataTopicId(), Time.SYSTEM, controllerMetrics, Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture);
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(metaProperties, config, (RaftManager)raftManager, Time.SYSTEM, controllerMetrics, (ControllerMetrics)new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry(), Time.SYSTEM), Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture, KafkaRaftServer$.MODULE$.configSchema(), raftManager.apiVersions(), BootstrapMetadata.fromVersion((MetadataVersion)this.metadataVersion(), (String)"test harness"), (FaultHandler)this.faultHandler(), (FaultHandler)this.faultHandler());
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
            raftManager.startup();
        }
        catch (Throwable e2) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> raftManager.shutdown(), (Logging)this, Level.WARN);
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, Level.WARN);
            }
            throw e2;
        }
        return new KRaftQuorumImplementation((KafkaRaftManager<ApiMessageAndVersion>)raftManager, (ControllerServer)controllerServer.elem, metadataDir, controllerQuorumVotersFuture, metaProperties.clusterId(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> JaasUtils.isZkSaslEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "ZooKeeperTestHarness", new ZKClientConfig(), "kafka.server", "SessionExpireListener", false);
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> zookeeper.shutdown(), (Logging)this, Level.WARN);
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, Level.WARN);
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public QuorumTestHarness() {
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
    }
}

