/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.PartitionTest$;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004G\u0001\u0001\u0006I!\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019y\u0005\u0001)A\u0005\u0013\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u00020\u0001A\u0003%!\u000bC\u0004`\u0001\t\u0007I\u0011\u00011\t\r\u0019\u0004\u0001\u0015!\u0003b\u0011\u001d9\u0007A1A\u0005\u0002!Da!\u001c\u0001!\u0002\u0013I\u0007b\u00028\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007_\u0002\u0001\u000b\u0011B5\t\u000fA\u0004!\u0019!C\u0001c\"1Q\u000f\u0001Q\u0001\nIDqA\u001e\u0001C\u0002\u0013\u0005q\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002=\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0005\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005\u0005\u0002\u0002CA0\u0001\u0001\u0006I!a\t\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013\u0005\u00111\r\u0005\f\u0003w\u0002\u0001\u0019!a\u0001\n\u0003\ti\bC\u0006\u0002\n\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0004bCAF\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001bC1\"!&\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0018\"Y\u00111\u0014\u0001A\u0002\u0003\u0005\u000b\u0015BAH\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!a.\u0001\t\u0003\ty\nC\u0004\u0002<\u0002!\t!a(\t\u000f\u0005}\u0006\u0001\"\u0001\u0002 \"9\u00111\u0019\u0001\u0005\u0002\u0005}\u0005bBAd\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003\u0017\u0004A\u0011AAP\u0011\u001d\ty\r\u0001C\u0001\u0003#D\u0011\"!=\u0001#\u0003%\t!a=\t\u0013\t%\u0001!%A\u0005\u0002\t-\u0001b\u0002B\b\u0001\u0011\u0005\u0011q\u0014\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0005a\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003Y5\naa]3sm\u0016\u0014(\"\u0001\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0004C\u0001\u001e\u0001\u001b\u0005Y\u0013aB2p]\u001aLwm]\u000b\u0002{A\u0019a(Q\"\u000e\u0003}R!\u0001Q\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C\u007f\t\u00191+Z9\u0011\u0005i\"\u0015BA#,\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0011\r|gNZ5hg\u0002\nA\u0001^5nKV\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002M[\u0005)Q\u000f^5mg&\u0011aj\u0013\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#\u0001*\u0011\u0005McV\"\u0001+\u000b\u0005A+&B\u0001,X\u0003\u0019\u0019w.\\7p]*\u0011a\u0006\u0017\u0006\u00033j\u000ba!\u00199bG\",'\"A.\u0002\u0007=\u0014x-\u0003\u0002^)\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\rI,7m\u001c:e+\u0005\t\u0007C\u00012e\u001b\u0005\u0019'BA0V\u0013\t)7M\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H-A\u0004sK\u000e|'\u000f\u001a\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]F*\u0012!\u001b\t\u0003U.l\u0011!V\u0005\u0003YV\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\tu_BL7\rU1si&$\u0018n\u001c82A\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t''\u0001\tu_BL7\rU1si&$\u0018n\u001c83A\u00059Ao\u001c9jG&#W#\u0001:\u0011\u0005)\u001c\u0018B\u0001;V\u0005\u0011)V/\u001b3\u0002\u0011Q|\u0007/[2JI\u0002\n\u0001\u0002^8qS\u000eLEm]\u000b\u0002qB)\u0011P`A\u0001e6\t!P\u0003\u0002|y\u0006!Q\u000f^5m\u0015\u0005i\u0018\u0001\u00026bm\u0006L!a >\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9\u0001`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\f\u0005\u0015!AB*ue&tw-A\u0005u_BL7-\u00133tA\u0005\tBo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0019\u0016\u0005\u0005M\u0001c\u00016\u0002\u0016%\u0019\u0011qC+\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017A\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oc\u0001\n\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c83\u0003I!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gN\r\u0011\u0002\u0013\u0019,Go\u00195J]\u001a|WCAA\u0012!\u0019\t)#a\u000b\u0002.5\u0011\u0011q\u0005\u0006\u0004\u0003Sy\u0014!C5n[V$\u0018M\u00197f\u0013\r\u0011\u0015q\u0005\t\be\u0005=\u00121CA\u001a\u0013\r\t\td\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005U\u0012\u0011\f\b\u0005\u0003o\t\u0019F\u0004\u0003\u0002:\u0005=c\u0002BA\u001e\u0003\u001brA!!\u0010\u0002L9!\u0011qHA%\u001d\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#_\u00051AH]8pizJ\u0011aW\u0005\u00033jK!A\f-\n\u0005Y;\u0016bAA)+\u0006A!/Z9vKN$8/\u0003\u0003\u0002V\u0005]\u0013\u0001\u0004$fi\u000eD'+Z9vKN$(bAA)+&!\u00111LA/\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u0011QKA,\u0003)1W\r^2i\u0013:4w\u000eI\u0001\rcV|G/Y'b]\u0006<WM]\u000b\u0003\u0003K\u0002B!a\u001a\u0002v9!\u0011\u0011NA9\u001d\u0011\tY'a\u001c\u000f\t\u0005\u0005\u0013QN\u0005\u0002]%\u0011A&L\u0005\u0004\u0003gZ\u0013\u0001D)v_R\fg)Y2u_JL\u0018\u0002BA<\u0003s\u0012Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAA:W\u0005\u0001\u0012/^8uC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u007f\n)\tE\u00023\u0003\u0003K1!a!4\u0005\u0011)f.\u001b;\t\u0013\u0005\u001d\u0015$!AA\u0002\u0005\u0015\u0014a\u0001=%c\u0005i\u0011/^8uC6\u000bg.Y4fe\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002\u0010B\u0019!(!%\n\u0007\u0005M5F\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u007f\nI\nC\u0005\u0002\br\t\t\u00111\u0001\u0002\u0010\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0016tQ>,H\u000eZ#yG2,H-Z*vEN,\u0017/^3oiRC'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0005\u0005}\u0004f\u0001\u0010\u0002$B!\u0011QUAZ\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016aA1qS*!\u0011QVAX\u0003\u001dQW\u000f]5uKJT1!!-[\u0003\u0015QWO\\5u\u0013\u0011\t),a*\u0003\tQ+7\u000f^\u0001:g\"|W\u000f\u001c3HKRtu.T3tg\u0006<Wm]%g#V|G/Y:Fq\u000e,W\rZ3e\u001f:\u001cVOY:fcV,g\u000e\u001e)beRLG/[8og\"\u001aq$a)\u0002EMDw.\u001e7e\u000f\u0016$(i\u001c;i\u001b\u0016\u001c8/Y4fg&3\u0017+^8uCN\fE\u000e\\8xQ\r\u0001\u00131U\u0001%g\"|W\u000f\u001c3J]\u000edW\u000fZ3J]NKhn\u0019+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\"\u001a\u0011%a)\u0002]MDw.\u001e7e\u0013:\u001cG.\u001e3f)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001chi\u001c:D_:\u001cX/\\3s\r\u0016$8\r\u001b\u0015\u0004E\u0005\r\u0016a\f;fgR\u001cu.\u001c9mKR,\u0017J\u001c#fY\u0006LX\r\u001a$fi\u000eDw+\u001b;i%\u0016\u0004H.[2b)\"\u0014x\u000e\u001e;mS:<\u0007fA\u0012\u0002$\u00069C/Z:u\u0007>l\u0007\u000f\\3uK&sG)\u001a7bs\u0016$g)\u001a;dQ\u000e{gn];nKJ4U\r^2iQ\r!\u00131U\u0001\u000bg\u0016$X\u000b]'pG.\u001cH\u0003CA@\u0003'\f)/a:\t\u000f\u0005}Q\u00051\u0001\u0002VB1\u0011q[Aq\u0003[qA!!7\u0002^:!\u0011\u0011IAn\u0013\u0005!\u0014bAApg\u00059\u0001/Y2lC\u001e,\u0017b\u0001\"\u0002d*\u0019\u0011q\\\u001a\t\u000f}+\u0003\u0013!a\u0001C\"I\u0011\u0011^\u0013\u0011\u0002\u0003\u0007\u00111^\u0001\u0013E>$\bNU3qY&\u001c\u0017m]%o'ft7\rE\u00023\u0003[L1!a<4\u0005\u001d\u0011un\u001c7fC:\fAc]3u+BlunY6tI\u0011,g-Y;mi\u0012\u0012TCAA{U\r\t\u0017q_\u0016\u0003\u0003s\u0004B!a?\u0003\u00065\u0011\u0011Q \u0006\u0005\u0003\u007f\u0014\t!A\u0005v]\u000eDWmY6fI*\u0019!1A\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\u0005u(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!2/\u001a;Va6{7m[:%I\u00164\u0017-\u001e7uIM*\"A!\u0004+\t\u0005-\u0018q_\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0001Fa\u0005\u0011\t\u0005\u0015&QC\u0005\u0005\u0005/\t9KA\u0005BMR,'/R1dQ\u0006IQn\\2l#V|G/\u0019\u000b\u0003\u0005;\u00012A\u000fB\u0010\u0013\r\u0011\tc\u000b\u0002\r%\u0016\u0004H.[2b#V|G/\u0019")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
        Properties fromProps_overrides = new Properties();
        return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
    });
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Uuid topicId = Uuid.randomUuid();
    private final java.util.Map<String, Uuid> topicIds = Collections.singletonMap("test-topic", this.topicId());
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId(), this.topicPartition1());
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId(), this.topicPartition2());
    private final scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition1()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition2()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty()))}));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public java.util.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public TopicIdPartition topicIdPartition1() {
        return this.topicIdPartition1;
    }

    public TopicIdPartition topicIdPartition2() {
        return this.topicIdPartition2;
    }

    public scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, 0L, 1, Integer.MAX_VALUE);
        Seq fetch = this.replicaManager().readFromLocalLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala().size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, 0L, 1, Integer.MAX_VALUE);
        Seq fetch = this.replicaManager().readFromLocalLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$6))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$7))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both throttled, we should get no messages");
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, 0L, 1, Integer.MAX_VALUE);
        Seq fetch = this.replicaManager().readFromLocalLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$8))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$9))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> x$1 = this.fetchInfo();
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, true);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, 0L, 1, Integer.MAX_VALUE);
        Seq fetch = this.replicaManager().readFromLocalLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$10))).get())._2()).info().records().batches()).asScala().size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$11))).get())._2()).info().records().batches()).asScala().size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void shouldIncludeThrottledReplicasForConsumerFetch() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.consumerFetchParams(0L, 1, Integer.MAX_VALUE, (Option<ClientMetadata>)None$.MODULE$, (FetchIsolation)FetchHighWatermark$.MODULE$);
        scala.collection.immutable.Map fetch = this.replicaManager().readFromLocalLog(fetchParams, this.fetchInfo(), quota, false).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)fetch.apply((Object)this.topicIdPartition1())).info().records().batches()).asScala().size(), (String)"Replication throttled partitions should return data for consumer fetch");
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((LogReadResult)fetch.apply((Object)this.topicIdPartition2())).info().records().batches()).asScala().size(), (String)"Replication throttled partitions should return data for consumer fetch");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    @Test
    public void testCompleteInDelayedFetchConsumerFetch() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$2(false).tryComplete(), (String)"Consumer fetch replica should complete if reading from current segment");
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$2(true).tryComplete(), (String)"Consumer fetch replica should complete if reading from older segment");
    }

    /*
     * WARNING - void declaration
     */
    public void setUpMocks(scala.collection.immutable.Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        void zkMetadataCache_brokerFeatures;
        ZkMetadataCache zkMetadataCache;
        BrokerFeatures brokerFeatures;
        void withRecords_records;
        void withRecords_timestampType;
        KafkaScheduler scheduler = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)log.logEndOffsetMetadata()).thenReturn((Object)new LogOffsetMetadata(20L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{record};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var28_7 = null;
        simpleRecordArray = null;
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), AdditionalMatchers.geq((int)1), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), false, (Option)None$.MODULE$));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)0), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$));
        Mockito.when((Object)log.maybeIncrementHighWatermark((LogOffsetMetadata)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        BrokerFeatures brokerFeatures2 = brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        brokerFeatures = null;
        BrokerFeatures brokerFeatures3 = brokerFeatures2;
        MetadataVersion zkMetadataCache_metadataVersion = ((KafkaConfig)this.configs().head()).interBrokerProtocolVersion();
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(leaderBrokerId, zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures);
        Object var23_20 = null;
        brokerFeatures3 = null;
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$7 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$122 = none$7;
        None$ none$8 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$13 = none$8;
        None$ none$9 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$14 = none$9;
        None$ none$10 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$15 = none$10;
        None$ none$11 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$16 = none$11;
        None$ none$12 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$12;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, (Scheduler)scheduler, logManager, x$6, (MetadataCache)x$7, x$8, alterIsrManager, x$10, x$11, (Option)x$122, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17));
        fetchInfo.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$12 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$12);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$13 -> {
            x$13.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota() {
        void var1_1;
        ReplicaQuota quota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$10) {
        Object object = x$10._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$11) {
        Object object = x$11._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0));
        Mockito.when((Object)partition.getReplica(1)).thenReturn((Object)None$.MODULE$);
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), 1, 600L, 1, 1000, (FetchIsolation)FetchLogEnd$.MODULE$, (Option)None$.MODULE$);
        return new DelayedFetch(null, fetchParams, tp, fetchPartitionStatus, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    private static final DelayedFetch setupDelayedFetch$2(boolean isFetchFromOlderSegment) {
        LogOffsetMetadata endOffsetMetadata = isFetchFromOlderSegment ? new LogOffsetMetadata(100L, 0L, 500) : new LogOffsetMetadata(150L, 50L, 500);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        TopicIdPartition tidp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -1, 600L, 1, 1000, (FetchIsolation)FetchHighWatermark$.MODULE$, (Option)None$.MODULE$);
        return new DelayedFetch(null, fetchParams, tidp, fetchPartitionStatus, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, UnifiedLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$12) {
        if (x$12 != null) {
            TopicIdPartition p = (TopicIdPartition)x$12._1();
            Partition partition = $this.replicaManager().createPartition(p.topicPartition());
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), true, bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), LeaderRecoveryState.RECOVERED);
            return;
        }
        throw new MatchError(null);
    }
}

