/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Properties;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0016,\u00019BQ!\u000e\u0001\u0005\u0002YBQ!\u000f\u0001\u0005\u0002iBQa\u0013\u0001\u0005\u0002iBQ\u0001\u0015\u0001\u0005\u0002iBQ!\u0016\u0001\u0005\u0002iBQa\u0016\u0001\u0005\u0002iBQ!\u0017\u0001\u0005\u0002iBQa\u0017\u0001\u0005\u0002iBQ!\u0018\u0001\u0005\u0002iBQa\u0018\u0001\u0005\u0002iBQ!\u0019\u0001\u0005\u0002iBQa\u0019\u0001\u0005\n\u0011DQa\u001c\u0001\u0005\u0002iBQ!\u001d\u0001\u0005\u0002iBqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004y\u0001\u0001\u0006I!\u001e\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nmD\u0001\"!\u0002\u0001\u0005\u0004%IA\u001f\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003|\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\u0007\u0011\u0019\ty\u0002\u0001C\u0001u!1\u00111\u0005\u0001\u0005\u0002iBa!a\n\u0001\t\u0003Q\u0004BBA\u0016\u0001\u0011\u0005!\b\u0003\u0004\u00020\u0001!\tA\u000f\u0005\u0007\u0003g\u0001A\u0011\u0001\u001e\t\r\u0005]\u0002\u0001\"\u0001;\u0011\u0019\tY\u0004\u0001C\u0001u!1\u0011q\b\u0001\u0005\u0002iBa!a\u0011\u0001\t\u0003Q\u0004BBA$\u0001\u0011\u0005!\b\u0003\u0004\u0002L\u0001!\tA\u000f\u0005\u0007\u0003\u001f\u0002A\u0011\u0001\u001e\t\r\u0005M\u0003\u0001\"\u0001;\u0011\u0019\t9\u0006\u0001C\u0001u!9\u00111\f\u0001\u0005\n\u0005u\u0003\"CAc\u0001E\u0005I\u0011BAd\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDq!!<\u0001\t\u0003\tyOA\u0005LC\u001a\\\u0017\rV3ti*\tA&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002oA\u0011\u0001\bA\u0007\u0002W\u0005)1/\u001a;VaR\t1\b\u0005\u00021y%\u0011Q(\r\u0002\u0005+:LG\u000f\u000b\u0002\u0003\u007fA\u0011\u0001)S\u0007\u0002\u0003*\u0011!iQ\u0001\u0004CBL'B\u0001#F\u0003\u001dQW\u000f]5uKJT!AR$\u0002\u000b),h.\u001b;\u000b\u0003!\u000b1a\u001c:h\u0013\tQ\u0015I\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u00075\u0003\"\u0001\u0011(\n\u0005=\u000b%!C!gi\u0016\u0014X)Y2i\u0003i!Xm\u001d;HKR\\\u0015MZ6b\u0007>tg-[4Ge>l\u0017I]4tQ\t!!\u000b\u0005\u0002A'&\u0011A+\u0011\u0002\u0005)\u0016\u001cH/A\u0015uKN$x)\u001a;LC\u001a\\\u0017mQ8oM&<gI]8n\u0003J<7OT8o\u0003J<7/\u0011;UQ\u0016,e\u000e\u001a\u0015\u0003\u000bI\u000bQ\u0005^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sONtuN\\!sON|e\u000e\\=)\u0005\u0019\u0011\u0016!\f;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001chj\u001c8Be\u001e\u001c\u0018\t\u001e+iK\n+wmZ5oO\"\u0012qAU\u0001\u001fi\u0016\u001cHO\u0011:pW\u0016\u0014(k\u001c7f\u001d>$W-\u00133WC2LG-\u0019;j_:D#\u0001\u0003*\u0002EQ,7\u000f^\"p]R\u0014x\u000e\u001c7feJ{G.\u001a(pI\u0016LEMV1mS\u0012\fG/[8oQ\tI!+A\u0011uKN$8i\u001c7pG\u0006$X\r\u001a*pY\u0016tu\u000eZ3JIZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\u000b%\u0006qC/Z:u\u001bV\u001cHoQ8oi\u0006Lg.U;peVlgk\u001c;feNLe-V:j]\u001e\u0004&o\\2fgN\u0014v\u000e\\3tQ\tY!+\u0001\ttKRd\u0015n\u001d;f]\u0016\u0014\bK]8qgR\u00111(\u001a\u0005\u0006M2\u0001\raZ\u0001\u0006aJ|\u0007o\u001d\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA!\u001e;jY*\tA.\u0001\u0003kCZ\f\u0017B\u00018j\u0005)\u0001&o\u001c9feRLWm]\u0001\u0016i\u0016\u001cHoS1gW\u0006\u001c6\u000f\u001c)bgN<xN\u001d3tQ\ti!+\u0001\u0011uKN$8*\u00194lCN\u001bH\u000eU1tg^|'\u000fZ:XSRD7+_7c_2\u001c\bF\u0001\bS\u0003U\u0011wn\u001c7fC:\u0004&o\u001c9WC2,X\rV8TKR,\u0012!\u001e\t\u0003aYL!a^\u0019\u0003\u000f\t{w\u000e\\3b]\u00061\"m\\8mK\u0006t\u0007K]8q-\u0006dW/\u001a+p'\u0016$\b%\u0001\u000btiJLgn\u001a)s_B4\u0016\r\\;f)>\u001cV\r^\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011ap[\u0001\u0005Y\u0006tw-C\u0002\u0002\u0002u\u0014aa\u0015;sS:<\u0017!F:ue&tw\r\u0015:paZ\u000bG.^3U_N+G\u000fI\u0001\u0017a\u0006\u001c8o^8sIB\u0013x\u000e\u001d,bYV,Gk\\*fi\u00069\u0002/Y:to>\u0014H\r\u0015:paZ\u000bG.^3U_N+G\u000fI\u0001\u0013Y&\u001cH\u000f\u0015:paZ\u000bG.^3U_N+G/\u0006\u0002\u0002\u000eA)\u0011qBA\rw6\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0005j[6,H/\u00192mK*\u0019\u0011qC\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001c\u0005E!\u0001\u0002'jgR\f1\u0003\\5tiB\u0013x\u000e\u001d,bYV,Gk\\*fi\u0002\nQ\u0003^3tij[7k\u001d7DY&,g\u000e^#oC\ndW\r\u000b\u0002\u0018%\u0006IB/Z:u5.\u001c6\u000f\\&fsN#xN]3M_\u000e\fG/[8oQ\tA\"+A\u000euKN$(l[*tYR\u0013Xo\u001d;Ti>\u0014X\rT8dCRLwN\u001c\u0015\u00033I\u000bQ\u0004^3tij{wn[3fa\u0016\u00148*Z=Ti>\u0014X\rU1tg^|'\u000f\u001a\u0015\u00035I\u000bq\u0004^3tij{wn[3fa\u0016\u0014HK];tiN#xN]3QCN\u001cxo\u001c:eQ\tY\"+A\u000buKN$(l[*tY.+\u0017p\u0015;pe\u0016$\u0016\u0010]3)\u0005q\u0011\u0016a\u0006;fgRT6nU:m)J,8\u000f^*u_J,G+\u001f9fQ\ti\"+A\tuKN$(l[*tYB\u0013x\u000e^8d_2D#A\b*\u00023Q,7\u000f\u001e.l'NdWI\\1cY\u0016$\u0007K]8u_\u000e|Gn\u001d\u0015\u0003?I\u000bQ\u0003^3tij[7k\u001d7DSBDWM]*vSR,7\u000f\u000b\u0002!%\u0006AC/Z:u5.\u001c6\u000f\\#oIB|\u0017N\u001c;JI\u0016tG/\u001b4jG\u0006$\u0018n\u001c8BY\u001e|'/\u001b;i[\"\u0012\u0011EU\u0001\u0013i\u0016\u001cHOW6Tg2\u001c%\u000f\\#oC\ndW\r\u000b\u0002#%\u0006\u0019B/Z:u5.\u001c6\u000f\\(dgB,e.\u00192mK\"\u00121EU\u0001\"i\u0016\u001cHoQ8o]\u0016\u001cG/[8og6\u000b\u0007PU3bkRDWj\u001d#fM\u0006,H\u000e\u001e\u0015\u0003II\u000b!\u0005^3ti\u000e{gN\\3di&|gn]'bqJ+\u0017-\u001e;i\u001bN,\u0005\u0010\u001d7jG&$\bFA\u0013S\u00031!Xm\u001d;[W\u000e{gNZ5h+\u0019\ty&!#\u0002>Ry1(!\u0019\u0002z\u0005u\u0014\u0011QAN\u0003o\u000b\t\rC\u0004\u0002d\u0019\u0002\r!!\u001a\u0002\u001b-\fgm[1Qe>\u0004h*Y7f!\u0011\t9'!\u001e\u000f\t\u0005%\u0014\u0011\u000f\t\u0004\u0003W\nTBAA7\u0015\r\ty'L\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t9HC\u0002\u0002tEBq!a\u001f'\u0001\u0004\t)'A\u000bfqB,7\r^3e\u0017\u000647.\u0019)s_Bt\u0015-\\3\t\u000f\u0005}d\u00051\u0001\u0002f\u0005Y1/_:Qe>\u0004h*Y7f\u0011\u001d\t\u0019I\na\u0001\u0003\u000b\u000ba\u0002\u001d:paZ\u000bG.^3U_N+G\u000f\u0005\u0003\u0002\b\u0006%E\u0002\u0001\u0003\b\u0003\u00173#\u0019AAG\u0005\u0005!\u0016\u0003BAH\u0003+\u00032\u0001MAI\u0013\r\t\u0019*\r\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u0014qS\u0005\u0004\u00033\u000b$aA!os\"9\u0011Q\u0014\u0014A\u0002\u0005}\u0015\u0001E4fiB\u0013x\u000e\u001d,bYV,gI]8n!\u001d\u0001\u0014\u0011UAS\u0003cK1!a)2\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tYkK\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005=\u0016\u0011\u0016\u0002\f\u0017\u000647.Y\"p]\u001aLw\rE\u00031\u0003g\u000b))C\u0002\u00026F\u0012aa\u00149uS>t\u0007bBA]M\u0001\u0007\u00111X\u0001\u0016Kb\u0004Xm\u0019;fIB\u0013x\u000e]3sif4\u0016\r\\;f!\u0011\t9)!0\u0005\u000f\u0005}fE1\u0001\u0002\u000e\n\tQ\u000bC\u0005\u0002D\u001a\u0002\n\u00111\u0001\u00022\u0006!R\r\u001f9fGR,G\rR3gCVdGOV1mk\u0016\fa\u0003^3tij[7i\u001c8gS\u001e$C-\u001a4bk2$HeN\u000b\u0007\u0003\u0013\f)/a:\u0016\u0005\u0005-'\u0006BAg\u0003't1\u0001MAh\u0013\r\t\t.M\u0001\u0005\u001d>tWm\u000b\u0002\u0002VB!\u0011q[Aq\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017!C;oG\",7m[3e\u0015\r\ty.M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAr\u00033\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u001d\tYi\nb\u0001\u0003\u001b#q!a0(\u0005\u0004\ti)\u0001\u000bqe\u0016\u0004\u0018M]3EK\u001a\fW\u000f\u001c;D_:4\u0017n\u001a\u000b\u0003\u0003K\nQ\u0002\u001d:fa\u0006\u0014XmQ8oM&<G\u0003BA3\u0003cDq!a=*\u0001\u0004\t)0A\u0003mS:,7\u000fE\u00031\u0003o\f)'C\u0002\u0002zF\u0012Q!\u0011:sCf\u0004")
public class KafkaTest {
    private final boolean booleanPropValueToSet;
    private final String stringPropValueToSet;
    private final String passwordPropValueToSet;
    private final List<String> listPropValueToSet = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));

    @BeforeEach
    public void setUp() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$1) -> KafkaTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)status), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((int)1, (int)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=2"}));
        Assertions.assertEquals((int)2, (int)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"}));
        Assertions.assertEquals((int)1, (int)config3.brokerId());
        Assertions.assertEquals(Arrays.asList("compact"), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"}));
        Assertions.assertEquals((int)2, (int)config4.brokerId());
        Assertions.assertEquals(Arrays.asList("compact", "delete"), (Object)config4.logCleanupPolicy());
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testBrokerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains just the 'broker' role, the node id 1 must not be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testControllerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testColocatedRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testMustContainQuorumVotersIfUsingProcessRoles() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If using process.roles, controller.quorum.voters must contain a parseable set of voters.");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "Missing required configuration `zookeeper.connect` which has no default value.");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    private void setListenerProps(Properties props) {
        boolean hasBrokerRole = props.getProperty(KafkaConfig$.MODULE$.ProcessRolesProp()).contains("broker");
        boolean hasControllerRole = props.getProperty(KafkaConfig$.MODULE$.ProcessRolesProp()).contains("controller");
        String controllerListener = "SASL_PLAINTEXT://localhost:9092";
        String brokerListener = "PLAINTEXT://localhost:9093";
        if (hasBrokerRole || hasControllerRole) {
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SASL_PLAINTEXT");
            if (hasBrokerRole && hasControllerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(1).append(brokerListener).append(",").append(controllerListener).toString());
            } else if (hasControllerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), controllerListener);
            } else if (hasBrokerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), brokerListener);
            }
        } else {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), brokerListener);
        }
        if (!(hasControllerRole & !hasBrokerRole)) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            props.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092");
            return;
        }
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password", "--override", "ssl.keystore.certificate.chain=certificate_chain", "--override", "ssl.keystore.key=private_key", "--override", "ssl.truststore.certificates=truststore_certificates"}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreKeyProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreCertificateChainProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststoreCertificatesProp()).toString());
        Assertions.assertEquals((Object)"key_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assertions.assertEquals((Object)"keystore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assertions.assertEquals((Object)"truststore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        Assertions.assertEquals((Object)"private_key", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreKeyProp()).value());
        Assertions.assertEquals((Object)"certificate_chain", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreCertificateChainProp()).value());
        Assertions.assertEquals((Object)"truststore_certificates", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststoreCertificatesProp()).value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(22).append("ssl.keystore.password=").append(password).toString(), "--override", new StringBuilder(17).append("ssl.key.password=").append(password).toString(), "--override", new StringBuilder(24).append("ssl.truststore.password=").append(password).toString()}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    private boolean booleanPropValueToSet() {
        return this.booleanPropValueToSet;
    }

    private String stringPropValueToSet() {
        return this.stringPropValueToSet;
    }

    private String passwordPropValueToSet() {
        return this.passwordPropValueToSet;
    }

    private List<String> listPropValueToSet() {
        return this.listPropValueToSet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslClientEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.client.secure";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.client.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.location";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.location";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperKeyStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.keyStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.password";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperTrustStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.trustStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.password";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.type";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.type";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslProtocol() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)"TLSv1.2");
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.protocol";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.protocol";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslEnabledProtocols() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.enabledProtocols";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.enabled.protocols";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCipherSuites() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.ciphersuites";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.cipher.suites";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslCipherSuites().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslCipherSuites());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
    }

    @Test
    public void testZkSslEndpointIdentificationAlgorithm() {
        String kafkaPropName = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Assertions.assertEquals((Object)"zookeeper.ssl.endpoint.identification.algorithm", (Object)kafkaPropName);
        String sysProp = "zookeeper.ssl.hostnameVerification";
        String expectedDefaultValue = "HTTPS";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, emptyConfig.values().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, (Object)emptyConfig.ZkSslEndpointIdentificationAlgorithm());
        ((IterableOnceOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), (Object)"")}))).foreach((Function1 & Serializable)x0$1 -> {
            KafkaTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$1(sysProp, propertiesFile, kafkaPropName, expectedDefaultValue, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"https", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)expected -> {
            KafkaTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$2(propertiesFile, kafkaPropName, expected);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCrlEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.crl";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.crl.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslOcspEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.ocsp";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.ocsp.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(47).append("sasl_ssl.oauthbearer.connections.max.reauth.ms=").append(expected).toString()}));
        Assertions.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    private <T, U> void testZkConfig(String kafkaPropName, String expectedKafkaPropName, String sysPropName, T propValueToSet, Function1<KafkaConfig, Option<T>> getPropValueFrom, U expectedPropertyValue, Option<T> expectedDefaultValue) {
        Assertions.assertEquals((Object)expectedKafkaPropName, (Object)kafkaPropName);
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        if (expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)expectedDefaultValue.get(), emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)expectedDefaultValue.get(), (Object)((Option)getPropValueFrom.apply((Object)emptyConfig)).get());
        } else {
            Assertions.assertNull(emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)getPropValueFrom.apply((Object)emptyConfig));
        }
        try {
            System.setProperty(sysPropName, String.valueOf(propValueToSet));
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
            Assertions.assertNull(config.originals().get(kafkaPropName));
            if (expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)expectedDefaultValue.get(), config.values().get(kafkaPropName));
            } else {
                Assertions.assertNull(config.values().get(kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
        }
        finally {
            System.clearProperty(sysPropName);
        }
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(1).append(kafkaPropName).append("=").append(propValueToSet).toString()}));
        Assertions.assertEquals(expectedPropertyValue, config.values().get(kafkaPropName));
        Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
    }

    private <T, U> None$ testZkConfig$default$7() {
        return None$.MODULE$;
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"broker.id=1", "zookeeper.connect=somewhere"});
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = TestUtils.tempFile((String)"kafkatest", (String)".properties");
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)l -> {
                KafkaTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int status, Option x$1) {
        throw new FatalExitError(status);
    }

    public static final /* synthetic */ Some $anonfun$testZkSslClientEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.zkSslClientEnable()));
    }

    public static final /* synthetic */ Option $anonfun$testZkSslKeyStoreLocation$1(KafkaConfig config) {
        return config.zkSslKeyStoreLocation();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslTrustStoreLocation$1(KafkaConfig config) {
        return config.zkSslTrustStoreLocation();
    }

    public static final /* synthetic */ Option $anonfun$testZookeeperKeyStorePassword$1(KafkaConfig config) {
        return config.zkSslKeyStorePassword();
    }

    public static final /* synthetic */ Option $anonfun$testZookeeperTrustStorePassword$1(KafkaConfig config) {
        return config.zkSslTrustStorePassword();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslKeyStoreType$1(KafkaConfig config) {
        return config.zkSslKeyStoreType();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslTrustStoreType$1(KafkaConfig config) {
        return config.zkSslTrustStoreType();
    }

    public static final /* synthetic */ Some $anonfun$testZkSslProtocol$1(KafkaConfig config) {
        return new Some((Object)config.ZkSslProtocol());
    }

    public static final /* synthetic */ Option $anonfun$testZkSslEnabledProtocols$1(KafkaConfig config) {
        return config.ZkSslEnabledProtocols();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslCipherSuites$1(KafkaConfig config) {
        return config.ZkSslCipherSuites();
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$1(String sysProp$1, String propertiesFile$4, String kafkaPropName$1, String expectedDefaultValue$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String sysPropValue = (String)x0$1._1();
            String expected = (String)x0$1._2();
            try {
                System.setProperty(sysProp$1, sysPropValue);
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile$4}));
                Assertions.assertNull(config.originals().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expectedDefaultValue$1, config.values().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
            }
            finally {
                System.clearProperty(sysProp$1);
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$2(String propertiesFile$4, String kafkaPropName$1, String expected) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile$4, "--override", new StringBuilder(1).append(kafkaPropName$1).append("=").append(expected).toString()}));
        Assertions.assertEquals((Object)expected, config.originals().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, config.values().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
    }

    public static final /* synthetic */ Some $anonfun$testZkSslCrlEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable()));
    }

    public static final /* synthetic */ Some $anonfun$testZkSslOcspEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable()));
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public KafkaTest() {
        this.booleanPropValueToSet = true;
        this.stringPropValueToSet = "foo";
        this.passwordPropValueToSet = "ThePa$$word!";
    }
}

